/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Cortina PHY drivers framework
 *
 * Copyright 2018-2022 NXP
 * Copyright (C) 2006-2017 Inphi Corporation, Inc. All rights reserved.
 */

#ifndef __CORTINA_API_H_
#define __CORTINA_API_H_

#include <config.h>
#include <malloc.h>
#include <linux/ctype.h>
#include <linux/string.h>
#include <linux/err.h>
#include <linux/delay.h>
#include <phy.h>

/* endiannes */
#define CS_LITTLE_ENDIAN

/* Things that can be tweaked */
#define CS_PRINTF(x)	debug x
#define CS_FPRINTF(x)	fprintf x
#define CS_FLUSH()	fflush(stdout)
#define CS_SNPRINTF(x)	snprintf x
#define CS_TRACE(x)	debug x
#define CS_UDELAY(x)	udelay((x))
#define CS_MDELAY(x)	udelay((x)*1000)

/* Make sure endianess is defined */
#ifdef CS_BIG_ENDIAN
#  ifdef CS_LITTLE_ENDIAN
#	 error "CS_BIG_ENDIAN and CS_LITTLE_ENDIAN are both defined."
#  endif
#else
#  ifndef CS_LITTLE_ENDIAN
#	 error "Either CS_BIG_ENDIAN or CS_LITTLE_ENDIAN must be defined."
#  endif
#endif

/* Cortina/Inphi reference software version */
#define CS_API_VERSION	  "3.10.0"
#define CS_API_BUILD_DATE "Apr 21, 2017 at 16:09:26"

#define CS_API_VERSION_MAJOR  3
#define CS_API_VERSION_MINOR  10
#define CS_API_VERSION_UPDATE 0

#define CS_OK		0
#define CS_ERROR	-1

#define CS_TRUE		1
#define CS_FALSE	0

#ifndef NULL
#define NULL			0
#endif

/* Chip family defines */
#define CS4224_GLOBAL_CHIP_ID_LSB				  0x0
#define CS4224_GLOBAL_CHIP_ID_LSB_dft			  0x3E5
#define CS4224_GLOBAL_CHIP_ID_MSB				  0x1
#define CS4224_GLOBAL_CHIP_ID_MSB_dft			  0x7003
#define CS4224_GLOBAL_SCRATCH					  0x2
#define CS4224_GLOBAL_SCRATCH_dft				  0x0
#define CS4224_GLOBAL_UCODE_VERSION_SR			  0x3
#define CS4224_GLOBAL_UCODE_VERSION_SR_dft		  0x0
#define CS4224_GLOBAL_UCODE_VERSION_CX1			  0x4
#define CS4224_GLOBAL_UCODE_VERSION_CX1_dft		  0x0
#define CS4224_GLOBAL_UCODE_VERSION_KR			  0x5
#define CS4224_GLOBAL_UCODE_VERSION_KR_dft		  0x0
#define CS4224_GLOBAL_UCODE_VERSION_ZR			  0x6
#define CS4224_GLOBAL_UCODE_VERSION_ZR_dft		  0x0
#define CS4224_GLOBAL_UCODE_VERSION_FC			  0x7
#define CS4224_GLOBAL_UCODE_VERSION_FC_dft		  0x0
#define CS4224_GLOBAL_UCODE_TIMESTAMP0			  0x8
#define CS4224_GLOBAL_UCODE_TIMESTAMP0_dft		  0x0
#define CS4224_GLOBAL_UCODE_TIMESTAMP1			  0x9
#define CS4224_GLOBAL_UCODE_TIMESTAMP1_dft		  0x0
#define CS4224_GLOBAL_UCODE_TIMESTAMP2			  0xA
#define CS4224_GLOBAL_UCODE_TIMESTAMP2_dft		  0x0
#define CS4224_GLOBAL_MPIF_SOFT_RESET			  0xD
#define CS4224_GLOBAL_MPIF_SOFT_RESET_dft		  0x0
#define CS4224_GLOBAL_MDIO_CONFIG				  0xF
#define CS4224_GLOBAL_MDIO_CONFIG_dft			  0x50
#define CS4224_GLOBAL_DWNLD_CHECKSUM_CTRL		  0x11
#define CS4224_GLOBAL_DWNLD_CHECKSUM_CTRL_dft	  0x0
#define CS4224_GLOBAL_DWNLD_CHECKSUM_STATUS		  0x12
#define CS4224_GLOBAL_DWNLD_CHECKSUM_STATUS_dft   0x0
#define CS4224_GLOBAL_DWNLD_CHECKSUM_HW			  0x13
#define CS4224_GLOBAL_DWNLD_CHECKSUM_HW_dft		  0xFFFF
#define CS4224_GLOBAL_DWNLD_CHECKSUM_SW			  0x14
#define CS4224_GLOBAL_DWNLD_CHECKSUM_SW_dft		  0x0
#define CS4224_GLOBAL_PIN_STATUS				  0x16
#define CS4224_GLOBAL_PIN_STATUS_dft			  0x0
#define CS4224_GLOBAL_BROADCAST					  0x17
#define CS4224_GLOBAL_BROADCAST_dft				  0x0
#define CS4224_GLOBAL_GT_10KHZ_REF_CLK_CNT1		  0x18
#define CS4224_GLOBAL_GT_10KHZ_REF_CLK_CNT1_dft   0x0
#define CS4224_GLOBAL_GT_10KHZ_REF_CLK_CNT0		  0x19
#define CS4224_GLOBAL_GT_10KHZ_REF_CLK_CNT0_dft   0x3CF0
#define CS4224_GLOBAL_SCRATCH0					  0x1D
#define CS4224_GLOBAL_SCRATCH0_dft				  0x0
#define CS4224_GLOBAL_SCRATCH6					  0x23
#define CS4224_GLOBAL_SCRATCH6_dft				  0x0
#define CS4224_GLOBAL_SCRATCH7					  0x24
#define CS4224_GLOBAL_SCRATCH7_dft				  0x0
#define CS4224_GLOBAL_GLOBAL_INTERRUPT			  0x26
#define CS4224_GLOBAL_GLOBAL_INTERRUPT_dft		  0x0
#define CS4224_GLOBAL_GLOBAL_INTE				  0x27
#define CS4224_GLOBAL_GLOBAL_INTE_dft			  0x0
#define CS4224_GLOBAL_DATAPATH_INTERRUPT		  0x28
#define CS4224_GLOBAL_DATAPATH_INTERRUPT_dft	  0x0
#define CS4224_GLOBAL_DATAPATH_INTE				  0x29
#define CS4224_GLOBAL_DATAPATH_INTE_dft			  0x0
#define CS4224_GPIO_INTERR						  0x100
#define CS4224_GPIO_INTERR_dft					  0x0
#define CS4224_GPIO_GPIO1						  0x106
#define CS4224_GPIO_GPIO1_dft					  0x0
#define CS4224_GPIO_GPIO2						  0x10C
#define CS4224_GPIO_GPIO2_dft					  0x0
#define CS4224_GPIO_GPIO3						  0x112
#define CS4224_GPIO_GPIO3_dft					  0x0
#define CS4224_GPIO_GPIO4						  0x118
#define CS4224_GPIO_GPIO4_dft					  0x0
#define CS4224_GPIO_GPIO_INPUT0					  0x11E
#define CS4224_GPIO_GPIO_INPUT0_dft				  0x0
#define CS4224_GPIO_GPIO_INPUT_INT				  0x124
#define CS4224_GPIO_GPIO_INPUT_INT_dft			  0x0
#define CS4224_GPIO_GPIO_INPUT_INTE				  0x125
#define CS4224_GPIO_GPIO_INPUT_INTE_dft			  0x0
#define CS4224_GPIO_GPIO_INPUT_INTS				  0x126
#define CS4224_GPIO_GPIO_INPUT_INTS_dft			  0x0
#define CS4224_GPIO_GPIO_INPUT_INTZ				  0x127
#define CS4224_GPIO_GPIO_INPUT_INTZ_dft			  0x0
#define CS4224_EFUSE_GENERAL_STATUS				  0x181
#define CS4224_EFUSE_GENERAL_STATUS_dft			  0x0
#define CS4224_EFUSE_PDF_SKU					  0x19F
#define CS4224_EFUSE_PDF_SKU_dft				  0x0
#define CS4224_EFUSE_PDF_MON_CAL_DATA			  0x1A4
#define CS4224_EFUSE_PDF_MON_CAL_DATA_dft		  0x0
#define CS4224_EFUSE_PDF_MON_GAIN_DATA			  0x1A5
#define CS4224_EFUSE_PDF_MON_GAIN_DATA_dft		  0x0
#define CS4224_EFUSE_PDF_MON_LUT15				  0x1A6
#define CS4224_EFUSE_PDF_MON_LUT15_dft			  0x0
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA2		  0x1B7
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA2_dft   0x0
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA1		  0x1B8
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA1_dft   0x0
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA0		  0x1B9
#define CS4224_EFUSE_PDF_POLY_RES_CAL_DATA0_dft   0x0
#define CS4224_MONITOR_CONTROL0					  0x200
#define CS4224_MONITOR_CONTROL0_dft				  0x630C
#define CS4224_MONITOR_CONFIG_MASK				  0x204
#define CS4224_MONITOR_CONFIG_MASK_dft			  0x0
#define CS4224_MONITOR_LUT_SELECT				  0x20B
#define CS4224_MONITOR_LUT_SELECT_dft			  0x0
#define CS4224_MONITOR_LUT_LOCAL_SELECT			  0x20C
#define CS4224_MONITOR_LUT_LOCAL_SELECT_dft		  0x0
#define CS4224_MONITOR_LUT_APPLY				  0x20D
#define CS4224_MONITOR_LUT_APPLY_dft			  0x0
#define CS4224_MONITOR_CAL_CONST_OVERRIDE_ENA	  0x20E
#define CS4224_MONITOR_CAL_CONST_OVERRIDE_ENA_dft 0x0
#define CS4224_MONITOR_CAL_OVERRIDE				  0x20F
#define CS4224_MONITOR_CAL_OVERRIDE_dft			  0x0
#define CS4224_MONITOR_CAL_CONST_APPLY			  0x210
#define CS4224_MONITOR_CAL_CONST_APPLY_dft		  0x0
#define CS4224_MONITOR_STATUS_FINAL0			  0x25A
#define CS4224_MONITOR_STATUS_FINAL0_dft		  0x0
#define CS4224_MONITOR_STATUS_FINAL2			  0x25C
#define CS4224_MONITOR_STATUS_FINAL2_dft		  0x0
#define CS4224_MONITOR_STATUS_FINAL6			  0x260
#define CS4224_MONITOR_STATUS_FINAL6_dft		  0x0
#define CS4224_MONITOR_LUT_RANGE0				  0x27B
#define CS4224_MONITOR_LUT_RANGE0_dft			  0x0
#define CS4224_MONITOR_LUT_VALUE0				  0x28B
#define CS4224_MONITOR_LUT_VALUE0_dft			  0x0
#define CS4224_CLKMON_GBL_CLKSEL				  0x2E0
#define CS4224_CLKMON_GBL_CLKSEL_dft			  0x7F
#define CS4224_CLKMON_GBL_CTRL					  0x2E1
#define CS4224_CLKMON_GBL_CTRL_dft				  0x110
#define CS4224_CLKMON_GBL_DURATION				  0x2E2
#define CS4224_CLKMON_GBL_DURATION_dft			  0x0
#define CS4224_CLKMON_GBL_MINTHRESH1			  0x2E6
#define CS4224_CLKMON_GBL_MINTHRESH1_dft		  0x0
#define CS4224_CLKMON_GBL_MINTHRESH0			  0x2E7
#define CS4224_CLKMON_GBL_MINTHRESH0_dft		  0x0
#define CS4224_CLKMON_GBL_MAXTHRESH1			  0x2E8
#define CS4224_CLKMON_GBL_MAXTHRESH1_dft		  0x0
#define CS4224_CLKMON_GBL_MAXTHRESH0			  0x2E9
#define CS4224_CLKMON_GBL_MAXTHRESH0_dft		  0x0
#define CS4224_MSEQ_PS_RAM_CONTROL				  0x301
#define CS4224_MSEQ_PS_RAM_CONTROL_dft			  0x0
#define CS4224_MSEQ_PS_RAM_DATA1				  0x302
#define CS4224_MSEQ_PS_RAM_DATA1_dft			  0x0
#define CS4224_MSEQ_PS_RAM_DATA0				  0x303
#define CS4224_MSEQ_PS_RAM_DATA0_dft			  0x0
#define CS4224_MSEQ_PS_INT						  0x306
#define CS4224_MSEQ_PS_INT_dft					  0x0
#define CS4224_MSEQ_PS_INTE						  0x307
#define CS4224_MSEQ_PS_INTE_dft					  0x0
#define CS4224_MSEQ_PS_INTO						  0x308
#define CS4224_MSEQ_PS_INTO_dft					  0x0
#define CS4224_MSEQ_PS_INTZ						  0x309
#define CS4224_MSEQ_PS_INTZ_dft					  0x0
#define CS4224_MSEQ_PS_MBIST_CTRL				  0x30A
#define CS4224_MSEQ_PS_MBIST_CTRL_dft			  0x0
#define CS4224_MSEQ_PS_MBIST_STATUS				  0x30B
#define CS4224_MSEQ_PS_MBIST_STATUS_dft			  0x0
#define CS4224_PP_LINE_LINEMISC_SOFT_RESET		  0x1000
#define CS4224_PP_LINE_LINEMISC_SOFT_RESET_dft	  0x2
#define CS4224_PP_LINE_LINEMISC_MPIF_RESET_DOTREG 0x1001
#define CS4224_PP_LINE_LINEMISC_MPIF_RESET_DOTREG_dft 0x7
#define CS4224_PP_LINE_LINEMISC_GIGEPCS_SOFT_RESET 0x1002
#define CS4224_PP_LINE_LINEMISC_GIGEPCS_SOFT_RESET_dft 0x3
#define CS4224_PP_LINE_LINEMISC_FUNCEN			  0x1003
#define CS4224_PP_LINE_LINEMISC_FUNCEN_dft		  0x0
#define CS4224_PP_LINE_LINEMISC_CLKEN			  0x1004
#define CS4224_PP_LINE_LINEMISC_CLKEN_dft		  0x0
#define CS4224_PP_LINE_LINEMISC_MSEQCLKCTRL		  0x1007
#define CS4224_PP_LINE_LINEMISC_MSEQCLKCTRL_dft   0x4
#define CS4224_PP_LINE_LINEMISC_DATAPATH_CTRL	  0x100B
#define CS4224_PP_LINE_LINEMISC_DATAPATH_CTRL_dft 0xF180
#define CS4224_PP_LINE_LINEMISC_KR_AN_PORT_ADDR   0x100C
#define CS4224_PP_LINE_LINEMISC_KR_AN_PORT_ADDR_dft 0x0
#define CS4224_PP_LINE_LINEMISC_AN_MODE_SEL		  0x100D
#define CS4224_PP_LINE_LINEMISC_AN_MODE_SEL_dft   0x0
#define CS4224_PP_LINE_LINEMISC_OVERRIDE_EN		  0x1010
#define CS4224_PP_LINE_LINEMISC_OVERRIDE_EN_dft   0x0
#define CS4224_PP_LINE_LINEMISC_INTERRUPT		  0x1011
#define CS4224_PP_LINE_LINEMISC_INTERRUPT_dft	  0x0
#define CS4224_PP_LINE_LINEMISC_INTENABLE		  0x1012
#define CS4224_PP_LINE_LINEMISC_INTENABLE_dft	  0x0
#define CS4224_PP_LINE_SDS_COMMON_RX0_Config	  0x1020
#define CS4224_PP_LINE_SDS_COMMON_RX0_Config_dft  0x18
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CONFIG  0x1021
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CONFIG_dft 0x4
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CLKDIV_CTRL 0x1023
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CLKDIV_CTRL_dft 0x3005
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CLKOUT_CTRL 0x1024
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CLKOUT_CTRL_dft 0x2FF
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CPA	  0x1027
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CPA_dft 0x77
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_IBIAS_TUNE 0x1029
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_IBIAS_TUNE_dft 0x4
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_RBIAS_TUNE 0x102A
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_RBIAS_TUNE_dft 0x44
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_MISC	  0x102D
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_MISC_dft 0x300
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_SPARE   0x102F
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_SPARE_dft 0xE0F0
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CONFIG_EYEMON 0x1030
#define CS4224_PP_LINE_SDS_COMMON_SRX0_RX_CONFIG_EYEMON_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_VCOMAX   0x1031
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_VCOMAX_dft 0xFFF
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_CONTROL  0x1033
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_CONTROL_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_ALTCT_LIMIT_HI 0x1035
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_ALTCT_LIMIT_HI_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_ALTCT_STATUS 0x1037
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_ALTCT_STATUS_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL3  0x1039
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL3_dft 0xFF
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL2  0x103A
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL2_dft 0xFF
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL1  0x103B
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL1_dft 0xFF
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL0  0x103C
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPLVL0_dft 0xFF
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES04 0x103D
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES04_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES03 0x103E
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES03_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES02 0x103F
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES02_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES01 0x1040
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES01_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES00 0x1041
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES00_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES14 0x1042
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES14_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES13 0x1043
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES13_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES12 0x1044
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES12_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES11 0x1045
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES11_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES10 0x1046
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_TMPTHRES10_dft 0x19
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL00 0x1047
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL00_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL01 0x1048
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL01_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL02 0x1049
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL02_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL03 0x104A
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL03_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL10 0x104B
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL10_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL11 0x104C
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL11_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL12 0x104D
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL12_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL13 0x104E
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_BIASVAL13_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_VCOBIAS 0x104F
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_LC_VCOBIAS_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_STATUS   0x1050
#define CS4224_PP_LINE_SDS_COMMON_RXVCO0_STATUS_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_RESOLUTION 0x1057
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_RESOLUTION_dft 0x3
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_CONTROL 0x1059
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_CONTROL_dft 0x2098
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTERRUPT 0x105B
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTERRUPT_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTSTATUS 0x105C
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTSTATUS_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTENABLE 0x105D
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTENABLE_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTERRUPTZ 0x105E
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKD0_INTERRUPTZ_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RXELST0_Control 0x106E
#define CS4224_PP_LINE_SDS_COMMON_RXELST0_Control_dft 0x2
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Cfg	  0x106F
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Cfg_dft 0x2000
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Ctrl   0x1070
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Ctrl_dft 0xC
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Count1 0x1071
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Count1_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Count0 0x1072
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_Count0_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_INTERRUPT 0x1073
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_INTERRUPT_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_INTSTATUS 0x1074
#define CS4224_PP_LINE_SDS_COMMON_PRBSCHK0_INTSTATUS_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_RESET	  0x1077
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_RESET_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_EN		  0x1078
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_EN_dft	  0x0
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_NUMERATOR0 0x1079
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_NUMERATOR0_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_NUMERATOR1 0x107A
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_NUMERATOR1_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_NUMERATOR0 0x107D
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_NUMERATOR0_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_NUMERATOR1 0x107E
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_NUMERATOR1_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_WIDTH	  0x1081
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_WIDTH_dft 0xA
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_INTDIV	  0x1082
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_INTDIV_dft 0x1919
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_STAGE_EN  0x1083
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_STAGE_EN_dft 0x408
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD0 0x1084
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD0_dft 0xCCCC
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD1 0x1085
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD1_dft 0xCC
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE2PRELOAD0 0x1086
#define CS4224_PP_LINE_SDS_COMMON_RDIVFRAC0_STAGE2PRELOAD0_dft 0xCCCC
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE1PRELOAD0 0x1088
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE1PRELOAD0_dft 0xCCCC
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE1PRELOAD1 0x1089
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE1PRELOAD1_dft 0xCC
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE2PRELOAD0 0x108A
#define CS4224_PP_LINE_SDS_COMMON_COREFRAC0_STAGE2PRELOAD0_dft 0xCCCC
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_DITHER	  0x108D
#define CS4224_PP_LINE_SDS_COMMON_FRAC0_DITHER_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_TX0_Config	  0x108E
#define CS4224_PP_LINE_SDS_COMMON_TX0_Config_dft  0x18
#define CS4224_PP_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLA 0x108F
#define CS4224_PP_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLA_dft 0x814
#define CS4224_PP_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLB 0x1090
#define CS4224_PP_LINE_SDS_COMMON_STX0_TX_OUTPUT_CTRLB_dft 0x4
#define CS4224_PP_LINE_SDS_COMMON_STX0_SQUELCH	  0x1091
#define CS4224_PP_LINE_SDS_COMMON_STX0_SQUELCH_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_STX0_MISC		  0x1092
#define CS4224_PP_LINE_SDS_COMMON_STX0_MISC_dft   0x33
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Cfg	  0x1096
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Cfg_dft 0x2000
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Ctrl   0x1097
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Ctrl_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Fixed0_Pattern1 0x1098
#define CS4224_PP_LINE_SDS_COMMON_PRBSGEN0_Fixed0_Pattern1_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_TXELST0_Control 0x109D
#define CS4224_PP_LINE_SDS_COMMON_TXELST0_Control_dft 0x2
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG1 0x10A1
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG1_dft 0x4
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG2 0x10A2
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG2_dft 0x40
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG4 0x10A4
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_CONFIG4_dft 0x81F0
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_RTUNE  0x10A5
#define CS4224_PP_LINE_SDS_COMMON_SRX0_AGC_RTUNE_dft 0x4
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DAC_ENB_MSB 0x10A6
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DAC_ENB_MSB_dft 0xD
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DAC_ENB_LSB 0x10A7
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DAC_ENB_LSB_dft 0xDFFF
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_DLY_CTRL1 0x10A8
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_DLY_CTRL1_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_DLY_CTRL2 0x10A9
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_DLY_CTRL2_dft 0x0
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_BIAS1  0x10AA
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_BIAS1_dft 0x5555
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_CONFIG 0x10AE
#define CS4224_PP_LINE_SDS_COMMON_SRX0_DFE_CONFIG_dft 0x441
#define CS4224_PP_LINE_SDS_COMMON_SRX0_MONCTRL	  0x10B1
#define CS4224_PP_LINE_SDS_COMMON_SRX0_MONCTRL_dft 0x2000
#define CS4224_PP_LINE_SDS_COMMON_SRX0_VCO_CONFIG 0x10B2
#define CS4224_PP_LINE_SDS_COMMON_SRX0_VCO_CONFIG_dft 0x607
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVER_CONFIG 0x10B4
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVER_CONFIG_dft 0x10
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVER_TUNE 0x10B5
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVER_TUNE_dft 0x404
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVERCML_TUNE 0x10B6
#define CS4224_PP_LINE_SDS_COMMON_STX0_DRIVERCML_TUNE_dft 0x404
#define CS4224_PP_LINE_SDS_COMMON_Int			  0x10BA
#define CS4224_PP_LINE_SDS_COMMON_Int_dft		  0x0
#define CS4224_PP_LINE_SDS_COMMON_IntEn			  0x10BB
#define CS4224_PP_LINE_SDS_COMMON_IntEn_dft		  0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKDi		  0x10C7
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKDi_dft	  0x0
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKDe		  0x10C8
#define CS4224_PP_LINE_SDS_COMMON_RXLOCKDe_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_CR		  0x1220
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_CR_dft   0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_D1		  0x1221
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_D1_dft   0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_D0		  0x1222
#define CS4224_PP_LINE_SDS_DSP_MSEQ_GRAM_D0_dft   0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_PC_SHADOW	  0x1223
#define CS4224_PP_LINE_SDS_DSP_MSEQ_PC_SHADOW_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_OPTIONS_SHADOW 0x1224
#define CS4224_PP_LINE_SDS_DSP_MSEQ_OPTIONS_SHADOW_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_OPTIONS		  0x1225
#define CS4224_PP_LINE_SDS_DSP_MSEQ_OPTIONS_dft   0x8
#define CS4224_PP_LINE_SDS_DSP_MSEQ_PC			  0x1228
#define CS4224_PP_LINE_SDS_DSP_MSEQ_PC_dft		  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_IX			  0x1229
#define CS4224_PP_LINE_SDS_DSP_MSEQ_IX_dft		  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_BASE3_INST	  0x1233
#define CS4224_PP_LINE_SDS_DSP_MSEQ_BASE3_INST_dft 0x3
#define CS4224_PP_LINE_SDS_DSP_MSEQ_ENABLE		  0x1234
#define CS4224_PP_LINE_SDS_DSP_MSEQ_ENABLE_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_POWER_DOWN_LSB 0x1235
#define CS4224_PP_LINE_SDS_DSP_MSEQ_POWER_DOWN_LSB_dft 0x1E0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_POWER_DOWN_MSB 0x1236
#define CS4224_PP_LINE_SDS_DSP_MSEQ_POWER_DOWN_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_STATUS		  0x1237
#define CS4224_PP_LINE_SDS_DSP_MSEQ_STATUS_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_BANK_SELECTOR 0x1238
#define CS4224_PP_LINE_SDS_DSP_MSEQ_BANK_SELECTOR_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_SEL	  0x1239
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_SEL_dft  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_IN_LSB   0x123A
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_IN_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_IN_MSB   0x123B
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_IN_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_OUT_LSB  0x123C
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_OUT_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_OUT_MSB  0x123D
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MAIL_OUT_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MU_VALUE	  0x1245
#define CS4224_PP_LINE_SDS_DSP_MSEQ_MU_VALUE_dft  0xF0F
#define CS4224_PP_LINE_SDS_DSP_MSEQ_LEAK_INTVL_AGC 0x1247
#define CS4224_PP_LINE_SDS_DSP_MSEQ_LEAK_INTVL_AGC_dft 0x40
#define CS4224_PP_LINE_SDS_DSP_MSEQ_LEAK_INTVL_DFE 0x1248
#define CS4224_PP_LINE_SDS_DSP_MSEQ_LEAK_INTVL_DFE_dft 0x40
#define CS4224_PP_LINE_SDS_DSP_MSEQ_COEF_DSP_INIT_SEL 0x1249
#define CS4224_PP_LINE_SDS_DSP_MSEQ_COEF_DSP_INIT_SEL_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_COEF_DSP_FLOAT 0x124C
#define CS4224_PP_LINE_SDS_DSP_MSEQ_COEF_DSP_FLOAT_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_EQADJ1 0x125E
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_EQADJ1_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_EQADJ2 0x125F
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_EQADJ2_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN0 0x1262
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN0_dft 0x1FF
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN1 0x1263
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN1_dft 0x1FF
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN2 0x1264
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_DFE_GAIN2_dft 0x1FF
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_PHSEL  0x1265
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_PHSEL_dft 0x20
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_SLICER 0x1266
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_SLICER_dft 0x80
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_AGC_MISC 0x1268
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_AGC_MISC_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_AGC_GAIN 0x1269
#define CS4224_PP_LINE_SDS_DSP_MSEQ_CAL_RX_AGC_GAIN_dft 0x7
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SNR_CTRL	  0x126C
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SNR_CTRL_dft  0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SNR_ZEROS_LSB 0x126D
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SNR_ZEROS_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_RESET_COUNT_LSB 0x1273
#define CS4224_PP_LINE_SDS_DSP_MSEQ_RESET_COUNT_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_RESET_COUNT_MSB 0x1274
#define CS4224_PP_LINE_SDS_DSP_MSEQ_RESET_COUNT_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SERDES		  0x1275
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SERDES_dft	  0x30
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE0_LSB	  0x1280
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE0_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE0_MSB	  0x1281
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE0_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE1_LSB	  0x1282
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE1_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE1_MSB	  0x1283
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE1_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE2_LSB	  0x1284
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE2_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE2_MSB	  0x1285
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE2_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE3_LSB	  0x1286
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE3_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE3_MSB	  0x1287
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE3_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE4_LSB	  0x1288
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE4_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE4_MSB	  0x1289
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE4_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE5_LSB	  0x128A
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE5_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE5_MSB	  0x128B
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE5_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE6_LSB	  0x128C
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE6_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE6_MSB	  0x128D
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE6_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE7_LSB	  0x128E
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE7_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE7_MSB	  0x128F
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE7_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE8_LSB	  0x1290
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE8_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE8_MSB	  0x1291
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE8_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE9_LSB	  0x1292
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE9_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE9_MSB	  0x1293
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE9_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE10_LSB   0x1294
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE10_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE10_MSB   0x1295
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE10_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE11_LSB   0x1296
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE11_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE11_MSB   0x1297
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE11_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE12_LSB   0x1298
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE12_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE12_MSB   0x1299
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE12_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE13_LSB   0x129A
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE13_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE13_MSB   0x129B
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE13_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE14_LSB   0x129C
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE14_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE15_MSB   0x129F
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE15_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE16_LSB   0x12A0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE16_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE18_LSB   0x12A4
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE18_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE18_MSB   0x12A5
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE18_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE19_LSB   0x12A6
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE19_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE20_LSB   0x12A8
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE20_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE20_MSB   0x12A9
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE20_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE21_LSB   0x12AA
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE21_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE21_MSB   0x12AB
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE21_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE22_LSB   0x12AC
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE22_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE22_MSB   0x12AD
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE22_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE23_LSB   0x12AE
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE23_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE23_MSB   0x12AF
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE23_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE24_LSB   0x12B0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE24_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE24_MSB   0x12B1
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE24_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE25_LSB   0x12B2
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE25_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE25_MSB   0x12B3
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE25_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE26_LSB   0x12B4
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE26_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE26_MSB   0x12B5
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE26_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE27_LSB   0x12B6
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE27_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE27_MSB   0x12B7
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE27_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE28_LSB   0x12B8
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE28_LSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE28_MSB   0x12B9
#define CS4224_PP_LINE_SDS_DSP_MSEQ_SPARE28_MSB_dft 0x0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE0_0		  0x1320
#define CS4224_PP_LINE_SDS_DSP_IC_DFE0_0_dft	  0xA0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE0_1		  0x1321
#define CS4224_PP_LINE_SDS_DSP_IC_DFE0_1_dft	  0xF0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE1_0		  0x1324
#define CS4224_PP_LINE_SDS_DSP_IC_DFE1_0_dft	  0xE0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE1_1		  0x1325
#define CS4224_PP_LINE_SDS_DSP_IC_DFE1_1_dft	  0xF8
#define CS4224_PP_LINE_SDS_DSP_IC_DFE2_0		  0x1328
#define CS4224_PP_LINE_SDS_DSP_IC_DFE2_0_dft	  0xF0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE2_1		  0x1329
#define CS4224_PP_LINE_SDS_DSP_IC_DFE2_1_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE3_0		  0x132C
#define CS4224_PP_LINE_SDS_DSP_IC_DFE3_0_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE3_1		  0x132D
#define CS4224_PP_LINE_SDS_DSP_IC_DFE3_1_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE4_0		  0x132E
#define CS4224_PP_LINE_SDS_DSP_IC_DFE4_0_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_IC_DFE4_1		  0x132F
#define CS4224_PP_LINE_SDS_DSP_IC_DFE4_1_dft	  0x0
#define CS4224_PP_LINE_SDS_DSP_ENABLE			  0x1343
#define CS4224_PP_LINE_SDS_DSP_ENABLE_dft		  0x4
#define CS4224_PP_LINE_SDS_DSP_COEF_SATURATED_INT 0x1354
#define CS4224_PP_LINE_SDS_DSP_COEF_SATURATED_INT_dft 0x0
#define CS4224_PP_LINE_GIGEPCS_LINE_CONTROL		  0x1460
#define CS4224_PP_LINE_GIGEPCS_LINE_CONTROL_dft   0x140
#define CS4224_PP_LINE_GIGEPCS_LINE_STATUS		  0x1461
#define CS4224_PP_LINE_GIGEPCS_LINE_STATUS_dft	  0x9
#define CS4224_PP_LINE_GIGEPCS_INT_LINE_PCS1GE_INTERRUPT 0x1480
#define CS4224_PP_LINE_GIGEPCS_INT_LINE_PCS1GE_INTERRUPT_dft 0x0
#define CS4224_PP_LINE_GIGEPCS_INT_LINE_PCS1GE_INTSTATUS 0x1482
#define CS4224_PP_LINE_GIGEPCS_INT_LINE_PCS1GE_INTSTATUS_dft 0x0
#define CS4224_PP_LINE_EGPCS_RX_MODE			  0x14A0
#define CS4224_PP_LINE_EGPCS_RX_MODE_dft		  0x8003
#define CS4224_PP_LINE_EGPCS_RX_INTERRUPT		  0x14A4
#define CS4224_PP_LINE_EGPCS_RX_INTERRUPT_dft	  0x0
#define CS4224_PP_LINE_EGPCS_RX_INTSTATUS		  0x14A6
#define CS4224_PP_LINE_EGPCS_RX_INTSTATUS_dft	  0x0
#define CS4224_PP_LINE_EGPCS_TX_MODE			  0x14B0
#define CS4224_PP_LINE_EGPCS_TX_MODE_dft		  0x8001
#define CS4224_PP_LINE_EGPCS_TX_INTERRUPT		  0x14B5
#define CS4224_PP_LINE_EGPCS_TX_INTERRUPT_dft	  0x0
#define CS4224_PP_LINE_XGPCS_TX_TXCNTRL			  0x14C0
#define CS4224_PP_LINE_XGPCS_TX_TXCNTRL_dft		  0x8002
#define CS4224_PP_LINE_XGPCS_RX_RXCNTRL			  0x14E0
#define CS4224_PP_LINE_XGPCS_RX_RXCNTRL_dft		  0xD000
#define CS4224_PP_LINE_XGPCS_RX_RXSTATUS		  0x14E1
#define CS4224_PP_LINE_XGPCS_RX_RXSTATUS_dft	  0x0
#define CS4224_PP_LINE_XGPCS_RX_RXINT			  0x14E2
#define CS4224_PP_LINE_XGPCS_RX_RXINT_dft		  0x0
#define CS4224_PP_LINE_AN_TX_ENABLE				  0x1500
#define CS4224_PP_LINE_AN_TX_ENABLE_dft			  0x0
#define CS4224_PP_LINE_AN_TX_COMPLETE_STATUS	  0x1505
#define CS4224_PP_LINE_AN_TX_COMPLETE_STATUS_dft  0x0
#define CS4224_PP_LINE_AN_TX_AN_COMPLETE_STATUS_INT 0x1506
#define CS4224_PP_LINE_AN_TX_AN_COMPLETE_STATUS_INT_dft 0x0
#define CS4224_PP_LINE_AN_TX_ADV_ABILITY		  0x150C
#define CS4224_PP_LINE_AN_TX_ADV_ABILITY_dft	  0x0
#define CS4224_PP_LINE_AN_TX_TECH_ABILITY_1		  0x150D
#define CS4224_PP_LINE_AN_TX_TECH_ABILITY_1_dft   0x0
#define CS4224_PP_LINE_AN_TX_BP_STATUS			  0x151B
#define CS4224_PP_LINE_AN_TX_BP_STATUS_dft		  0x1
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMEOUT0   0x1523
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMEOUT0_dft 0x17C8
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMER_THRES1 0x1524
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMER_THRES1_dft 0x3B9
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMER_THRES0 0x1525
#define CS4224_PP_LINE_AN_TX_LINK_FAIL_TIMER_THRES0_dft 0xACA0
#define CS4224_PP_LINE_AN_TX_ABILITY_DETECT_TIMER_ENABLE 0x152A
#define CS4224_PP_LINE_AN_TX_ABILITY_DETECT_TIMER_ENABLE_dft 0x0
#define CS4224_PP_LINE_AN_TX_MAIN_INT			  0x152D
#define CS4224_PP_LINE_AN_TX_MAIN_INT_dft		  0x0
#define CS4224_PP_LINE_AN_TX_MAIN_INTS			  0x152F
#define CS4224_PP_LINE_AN_TX_MAIN_INTS_dft		  0x0
#define CS4224_PP_LINE_AN_TX_TX_AFIFO_INT		  0x1531
#define CS4224_PP_LINE_AN_TX_TX_AFIFO_INT_dft	  0x0
#define CS4224_PP_LINE_AN_TX_ARBITRATOR_STATE	  0x1536
#define CS4224_PP_LINE_AN_TX_ARBITRATOR_STATE_dft 0x0
#define CS4224_PP_LINE_AN_RX_PAGE_RECEIVED		  0x1545
#define CS4224_PP_LINE_AN_RX_PAGE_RECEIVED_dft	  0x0
#define CS4224_PP_LINE_AN_RX_LP_ABILITY_1		  0x1546
#define CS4224_PP_LINE_AN_RX_LP_ABILITY_1_dft	  0x0
#define CS4224_PP_LINE_AN_RX_LP_ABILITY_2		  0x1547
#define CS4224_PP_LINE_AN_RX_LP_ABILITY_2_dft	  0x0
#define CS4224_PP_LINE_AN_RX_MAIN_INT			  0x155A
#define CS4224_PP_LINE_AN_RX_MAIN_INT_dft		  0x0
#define CS4224_PP_LINE_AN_RX_RX_AFIFO_INT		  0x155E
#define CS4224_PP_LINE_AN_RX_RX_AFIFO_INT_dft	  0x0
#define CS4224_PP_LINE_TP_TX_ENABLE				  0x1580
#define CS4224_PP_LINE_TP_TX_ENABLE_dft			  0x0
#define CS4224_PP_LINE_TP_TX_TX_RX_RESET		  0x1581
#define CS4224_PP_LINE_TP_TX_TX_RX_RESET_dft	  0x3
#define CS4224_PP_LINE_TP_TX_BITSWAP			  0x1583
#define CS4224_PP_LINE_TP_TX_BITSWAP_dft		  0x1
#define CS4224_PP_LINE_TP_TX_TRAINING			  0x1586
#define CS4224_PP_LINE_TP_TX_TRAINING_dft		  0x0
#define CS4224_PP_LINE_TP_TX_TRAINING_INT		  0x1588
#define CS4224_PP_LINE_TP_TX_TRAINING_INT_dft	  0x0
#define CS4224_PP_LINE_TP_TX_TRAINING_INTS		  0x158A
#define CS4224_PP_LINE_TP_TX_TRAINING_INTS_dft	  0x0
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMEOUT1	  0x158C
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMEOUT1_dft 0x950
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMEOUT0	  0x158D
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMEOUT0_dft 0x2F90
#define CS4224_PP_LINE_TP_TX_WAIT_TIMEOUT		  0x158E
#define CS4224_PP_LINE_TP_TX_WAIT_TIMEOUT_dft	  0x64
#define CS4224_PP_LINE_TP_TX_ADDITIONAL_FRAMES	  0x158F
#define CS4224_PP_LINE_TP_TX_ADDITIONAL_FRAMES_dft 0x2
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_MAX_LIMIT  0x1590
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_MAX_LIMIT_dft 0x30
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_MAX_LIMIT 0x1591
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_MAX_LIMIT_dft 0x30
#define CS4224_PP_LINE_TP_TX_POST_COEFF_MAX_LIMIT 0x1592
#define CS4224_PP_LINE_TP_TX_POST_COEFF_MAX_LIMIT_dft 0x30
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_MIN_LIMIT  0x1593
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_MIN_LIMIT_dft 0x0
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_MIN_LIMIT 0x1594
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_MIN_LIMIT_dft 0x0
#define CS4224_PP_LINE_TP_TX_POST_COEFF_MIN_LIMIT 0x1595
#define CS4224_PP_LINE_TP_TX_POST_COEFF_MIN_LIMIT_dft 0x0
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_INIT		  0x1596
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_INIT_dft   0x0
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_INIT	  0x1597
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_INIT_dft  0x0
#define CS4224_PP_LINE_TP_TX_POST_COEFF_INIT	  0x1598
#define CS4224_PP_LINE_TP_TX_POST_COEFF_INIT_dft  0x0
#define CS4224_PP_LINE_TP_TX_PRESET_COEFF_OVERRIDE 0x1599
#define CS4224_PP_LINE_TP_TX_PRESET_COEFF_OVERRIDE_dft 0x0
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_PRESET	  0x159A
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_PRESET_dft 0x0
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_PRESET	  0x159B
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_PRESET_dft 0x0
#define CS4224_PP_LINE_TP_TX_POST_COEFF_PRESET	  0x159C
#define CS4224_PP_LINE_TP_TX_POST_COEFF_PRESET_dft 0x0
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_START	  0x159D
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_START_dft  0x5
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_START	  0x159E
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_START_dft 0x23
#define CS4224_PP_LINE_TP_TX_POST_COEFF_START	  0x159F
#define CS4224_PP_LINE_TP_TX_POST_COEFF_START_dft 0x24
#define CS4224_PP_LINE_TP_TX_PRE_COEFF			  0x15A0
#define CS4224_PP_LINE_TP_TX_PRE_COEFF_dft		  0x0
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF			  0x15A1
#define CS4224_PP_LINE_TP_TX_MAIN_COEFF_dft		  0x0
#define CS4224_PP_LINE_TP_TX_POST_COEFF			  0x15A2
#define CS4224_PP_LINE_TP_TX_POST_COEFF_dft		  0x0
#define CS4224_PP_LINE_TP_TX_COEFF_STEP_VALUE	  0x15A3
#define CS4224_PP_LINE_TP_TX_COEFF_STEP_VALUE_dft 0x111
#define CS4224_PP_LINE_TP_TX_LD_COEFF_UPDATE_CTRL 0x15A4
#define CS4224_PP_LINE_TP_TX_LD_COEFF_UPDATE_CTRL_dft 0x0
#define CS4224_PP_LINE_TP_TX_FC_OPTIONS			  0x15A8
#define CS4224_PP_LINE_TP_TX_FC_OPTIONS_dft		  0x0
#define CS4224_PP_LINE_TP_TX_ENCODER_STATE		  0x15A9
#define CS4224_PP_LINE_TP_TX_ENCODER_STATE_dft	  0x0
#define CS4224_PP_LINE_TP_TX_TRAINING_STATE		  0x15AA
#define CS4224_PP_LINE_TP_TX_TRAINING_STATE_dft   0x0
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMER_EN	  0x15AF
#define CS4224_PP_LINE_TP_TX_MAX_WAIT_TIMER_EN_dft 0x1
#define CS4224_PP_LINE_TP_RX_BITSWAP			  0x15C0
#define CS4224_PP_LINE_TP_RX_BITSWAP_dft		  0x1
#define CS4224_PP_LINE_TP_RX_REMOTE_RX_READY	  0x15C1
#define CS4224_PP_LINE_TP_RX_REMOTE_RX_READY_dft  0x113
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_INT		  0x15C2
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_INT_dft   0x0
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_INTS	  0x15C4
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_INTS_dft  0x0
#define CS4224_PP_LINE_TP_RX_FM_DETECT_STATE	  0x15C9
#define CS4224_PP_LINE_TP_RX_FM_DETECT_STATE_dft  0x0
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_STATE	  0x15CA
#define CS4224_PP_LINE_TP_RX_FRAME_LOCK_STATE_dft 0x0
#define CS4224_PP_LINE_KR_FEC_TX_RESET			  0x1600
#define CS4224_PP_LINE_KR_FEC_TX_RESET_dft		  0x1
#define CS4224_PP_LINE_KR_FEC_TX_STATUS			  0x1602
#define CS4224_PP_LINE_KR_FEC_TX_STATUS_dft		  0x0
#define CS4224_PP_LINE_KR_FEC_TX_STATS_CONTROL	  0x160A
#define CS4224_PP_LINE_KR_FEC_TX_STATS_CONTROL_dft 0x0
#define CS4224_PP_LINE_KR_FEC_TX_STATS_TX_BLK_TOTAL1 0x160B
#define CS4224_PP_LINE_KR_FEC_TX_STATS_TX_BLK_TOTAL1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_TX_STATS_TX_BLK_TOTAL0 0x160C
#define CS4224_PP_LINE_KR_FEC_TX_STATS_TX_BLK_TOTAL0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_TX_INT			  0x160D
#define CS4224_PP_LINE_KR_FEC_TX_INT_dft		  0x0
#define CS4224_PP_LINE_KR_FEC_RX_RESET			  0x1640
#define CS4224_PP_LINE_KR_FEC_RX_RESET_dft		  0x1
#define CS4224_PP_LINE_KR_FEC_RX_STATUS			  0x1642
#define CS4224_PP_LINE_KR_FEC_RX_STATUS_dft		  0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_CONTROL	  0x1644
#define CS4224_PP_LINE_KR_FEC_RX_STATS_CONTROL_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_TOTAL1 0x1645
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_TOTAL1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_TOTAL0 0x1646
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_TOTAL0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_CORR1 0x1647
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_CORR1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_CORR0 0x1648
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_CORR0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_UNCORR1 0x1649
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_UNCORR1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_UNCORR0 0x164A
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BLK_UNCORR0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ZERO_ERRS1 0x164B
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ZERO_ERRS1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ZERO_ERRS0 0x164C
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ZERO_ERRS0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ONE_ERRS1 0x164D
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ONE_ERRS1_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ONE_ERRS0 0x164E
#define CS4224_PP_LINE_KR_FEC_RX_STATS_RX_BIT_ONE_ERRS0_dft 0x0
#define CS4224_PP_LINE_KR_FEC_RX_INT			  0x165F
#define CS4224_PP_LINE_KR_FEC_RX_INT_dft		  0x0
#define CS4224_PP_LINE_MCAN_RESET				  0x1680
#define CS4224_PP_LINE_MCAN_RESET_dft			  0x1
#define CS4224_PP_HOST_HOSTMISC_SOFT_RESET		  0x1800
#define CS4224_PP_HOST_HOSTMISC_SOFT_RESET_dft	  0x2
#define CS4224_PP_HOST_HOSTMISC_MPIF_RESET_DOTREG 0x1801
#define CS4224_PP_HOST_HOSTMISC_MPIF_RESET_DOTREG_dft 0x3
#define CS4224_PP_HOST_HOSTMISC_GIGEPCS_SOFT_RESET 0x1802
#define CS4224_PP_HOST_HOSTMISC_GIGEPCS_SOFT_RESET_dft 0x1
#define CS4224_PP_HOST_HOSTMISC_FUNCEN			  0x1803
#define CS4224_PP_HOST_HOSTMISC_FUNCEN_dft		  0x0
#define CS4224_PP_HOST_HOSTMISC_CLKEN			  0x1804
#define CS4224_PP_HOST_HOSTMISC_CLKEN_dft		  0x0
#define CS4224_PP_HOST_HOSTMISC_MATE_SELECT		  0x1806
#define CS4224_PP_HOST_HOSTMISC_MATE_SELECT_dft   0x0
#define CS4224_PP_HOST_HOSTMISC_MSEQCLKCTRL		  0x1807
#define CS4224_PP_HOST_HOSTMISC_MSEQCLKCTRL_dft   0x4
#define CS4224_PP_HOST_HOSTMISC_OVERRIDE_EN		  0x1810
#define CS4224_PP_HOST_HOSTMISC_OVERRIDE_EN_dft   0x0
#define CS4224_PP_HOST_HOSTMISC_INTERRUPT		  0x1811
#define CS4224_PP_HOST_HOSTMISC_INTERRUPT_dft	  0x0
#define CS4224_PP_HOST_HOSTMISC_INTENABLE		  0x1812
#define CS4224_PP_HOST_HOSTMISC_INTENABLE_dft	  0x0
#define CS4224_PP_HOST_SDS_COMMON_RX0_Config	  0x1820
#define CS4224_PP_HOST_SDS_COMMON_RX0_Config_dft  0x18
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CONFIG  0x1821
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CONFIG_dft 0x4
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CLKDIV_CTRL 0x1823
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CLKDIV_CTRL_dft 0x3005
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CLKOUT_CTRL 0x1824
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CLKOUT_CTRL_dft 0x2FF
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CPA	  0x1827
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_CPA_dft 0x77
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_IBIAS_TUNE 0x1829
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_IBIAS_TUNE_dft 0x4
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_RBIAS_TUNE 0x182A
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_RBIAS_TUNE_dft 0x44
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_SPARE   0x182F
#define CS4224_PP_HOST_SDS_COMMON_SRX0_RX_SPARE_dft 0xE0F0
#define CS4224_PP_HOST_SDS_COMMON_RXVCO0_CONTROL  0x1833
#define CS4224_PP_HOST_SDS_COMMON_RXVCO0_CONTROL_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXVCO0_ALTCT_STATUS 0x1837
#define CS4224_PP_HOST_SDS_COMMON_RXVCO0_ALTCT_STATUS_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_CONTROL 0x1859
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_CONTROL_dft 0x2098
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTERRUPT 0x185B
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTERRUPT_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTSTATUS 0x185C
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTSTATUS_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTENABLE 0x185D
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTENABLE_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTERRUPTZ 0x185E
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKD0_INTERRUPTZ_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RXELST0_Control 0x186E
#define CS4224_PP_HOST_SDS_COMMON_RXELST0_Control_dft 0x2
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Cfg	  0x186F
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Cfg_dft 0x2000
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Ctrl   0x1870
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Ctrl_dft 0xC
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Count1 0x1871
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Count1_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Count0 0x1872
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_Count0_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_INTERRUPT 0x1873
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_INTERRUPT_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_INTSTATUS 0x1874
#define CS4224_PP_HOST_SDS_COMMON_PRBSCHK0_INTSTATUS_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_RESET	  0x1877
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_RESET_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_EN		  0x1878
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_EN_dft	  0x0
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_NUMERATOR0 0x1879
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_NUMERATOR0_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_NUMERATOR1 0x187A
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_NUMERATOR1_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_NUMERATOR0 0x187D
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_NUMERATOR0_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_NUMERATOR1 0x187E
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_NUMERATOR1_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_WIDTH	  0x1881
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_WIDTH_dft 0xA
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_INTDIV	  0x1882
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_INTDIV_dft 0x1919
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_STAGE_EN  0x1883
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_STAGE_EN_dft 0x408
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD0 0x1884
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD0_dft 0xCCCC
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD1 0x1885
#define CS4224_PP_HOST_SDS_COMMON_RDIVFRAC0_STAGE1PRELOAD1_dft 0xCC
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE1PRELOAD0 0x1888
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE1PRELOAD0_dft 0xCCCC
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE1PRELOAD1 0x1889
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE1PRELOAD1_dft 0xCC
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE2PRELOAD0 0x188A
#define CS4224_PP_HOST_SDS_COMMON_COREFRAC0_STAGE2PRELOAD0_dft 0xCCCC
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_DITHER	  0x188D
#define CS4224_PP_HOST_SDS_COMMON_FRAC0_DITHER_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_TX0_Config	  0x188E
#define CS4224_PP_HOST_SDS_COMMON_TX0_Config_dft  0x18
#define CS4224_PP_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLA 0x188F
#define CS4224_PP_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLA_dft 0x814
#define CS4224_PP_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLB 0x1890
#define CS4224_PP_HOST_SDS_COMMON_STX0_TX_OUTPUT_CTRLB_dft 0x4
#define CS4224_PP_HOST_SDS_COMMON_STX0_SQUELCH	  0x1891
#define CS4224_PP_HOST_SDS_COMMON_STX0_SQUELCH_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_STX0_MISC		  0x1892
#define CS4224_PP_HOST_SDS_COMMON_STX0_MISC_dft   0x33
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Cfg	  0x1896
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Cfg_dft 0x2000
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Ctrl   0x1897
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Ctrl_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Fixed0_Pattern1 0x1898
#define CS4224_PP_HOST_SDS_COMMON_PRBSGEN0_Fixed0_Pattern1_dft 0x0
#define CS4224_PP_HOST_SDS_COMMON_TXELST0_Control 0x189D
#define CS4224_PP_HOST_SDS_COMMON_TXELST0_Control_dft 0x2
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG1 0x18A1
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG1_dft 0x4
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG2 0x18A2
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG2_dft 0x40
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG4 0x18A4
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_CONFIG4_dft 0x81F0
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_RTUNE  0x18A5
#define CS4224_PP_HOST_SDS_COMMON_SRX0_AGC_RTUNE_dft 0x4
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DAC_ENB_MSB 0x18A6
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DAC_ENB_MSB_dft 0xD
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DAC_ENB_LSB 0x18A7
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DAC_ENB_LSB_dft 0xDFFF
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DFE_CONFIG 0x18AE
#define CS4224_PP_HOST_SDS_COMMON_SRX0_DFE_CONFIG_dft 0x441
#define CS4224_PP_HOST_SDS_COMMON_SRX0_VCO_CONFIG 0x18B2
#define CS4224_PP_HOST_SDS_COMMON_SRX0_VCO_CONFIG_dft 0x607
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVER_CONFIG 0x18B4
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVER_CONFIG_dft 0x10
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVER_TUNE 0x18B5
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVER_TUNE_dft 0x404
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVERCML_TUNE 0x18B6
#define CS4224_PP_HOST_SDS_COMMON_STX0_DRIVERCML_TUNE_dft 0x404
#define CS4224_PP_HOST_SDS_COMMON_Int			  0x18BA
#define CS4224_PP_HOST_SDS_COMMON_Int_dft		  0x0
#define CS4224_PP_HOST_SDS_COMMON_IntEn			  0x18BB
#define CS4224_PP_HOST_SDS_COMMON_IntEn_dft		  0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKDi		  0x18C7
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKDi_dft	  0x0
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKDe		  0x18C8
#define CS4224_PP_HOST_SDS_COMMON_RXLOCKDe_dft	  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_CR		  0x1A20
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_CR_dft   0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_D1		  0x1A21
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_D1_dft   0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_D0		  0x1A22
#define CS4224_PP_HOST_SDS_DSP_MSEQ_GRAM_D0_dft   0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_PC_SHADOW	  0x1A23
#define CS4224_PP_HOST_SDS_DSP_MSEQ_PC_SHADOW_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_OPTIONS_SHADOW 0x1A24
#define CS4224_PP_HOST_SDS_DSP_MSEQ_OPTIONS_SHADOW_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_OPTIONS		  0x1A25
#define CS4224_PP_HOST_SDS_DSP_MSEQ_OPTIONS_dft   0x8
#define CS4224_PP_HOST_SDS_DSP_MSEQ_PC			  0x1A28
#define CS4224_PP_HOST_SDS_DSP_MSEQ_PC_dft		  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_IX			  0x1A29
#define CS4224_PP_HOST_SDS_DSP_MSEQ_IX_dft		  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_BASE3_INST	  0x1A33
#define CS4224_PP_HOST_SDS_DSP_MSEQ_BASE3_INST_dft 0x3
#define CS4224_PP_HOST_SDS_DSP_MSEQ_ENABLE		  0x1A34
#define CS4224_PP_HOST_SDS_DSP_MSEQ_ENABLE_dft	  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_POWER_DOWN_LSB 0x1A35
#define CS4224_PP_HOST_SDS_DSP_MSEQ_POWER_DOWN_LSB_dft 0x1E0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_STATUS		  0x1A37
#define CS4224_PP_HOST_SDS_DSP_MSEQ_STATUS_dft	  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_BANK_SELECTOR 0x1A38
#define CS4224_PP_HOST_SDS_DSP_MSEQ_BANK_SELECTOR_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_SEL	  0x1A39
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_SEL_dft  0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_IN_LSB   0x1A3A
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_IN_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_IN_MSB   0x1A3B
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_IN_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_OUT_LSB  0x1A3C
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_OUT_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_OUT_MSB  0x1A3D
#define CS4224_PP_HOST_SDS_DSP_MSEQ_MAIL_OUT_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_CAL_RX_PHSEL  0x1A65
#define CS4224_PP_HOST_SDS_DSP_MSEQ_CAL_RX_PHSEL_dft 0x20
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SERDES		  0x1A75
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SERDES_dft	  0x30
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE0_LSB	  0x1A80
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE0_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE6_MSB	  0x1A8D
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE6_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE12_LSB   0x1A98
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE12_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE12_MSB   0x1A99
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE12_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE14_LSB   0x1A9C
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE14_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE15_MSB   0x1A9F
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE15_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE20_MSB   0x1AA9
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE20_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE22_LSB   0x1AAC
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE22_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE22_MSB   0x1AAD
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE22_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE24_MSB   0x1AB1
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE24_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE25_LSB   0x1AB2
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE25_LSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE25_MSB   0x1AB3
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE25_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE26_MSB   0x1AB5
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE26_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE28_MSB   0x1AB9
#define CS4224_PP_HOST_SDS_DSP_MSEQ_SPARE28_MSB_dft 0x0
#define CS4224_PP_HOST_SDS_DSP_COEF_SATURATED_INT 0x1B54
#define CS4224_PP_HOST_SDS_DSP_COEF_SATURATED_INT_dft 0x0
#define CS4224_PP_HOST_GIGEPCS_INT_HOST_PCS1GE_INTERRUPT 0x1C80
#define CS4224_PP_HOST_GIGEPCS_INT_HOST_PCS1GE_INTERRUPT_dft 0x0
#define CS4224_PP_HOST_GIGEPCS_INT_HOST_PCS1GE_INTSTATUS 0x1C82
#define CS4224_PP_HOST_GIGEPCS_INT_HOST_PCS1GE_INTSTATUS_dft 0x0
#define CS4224_PP_CLKMON_ING_CLKSEL				  0x1D00
#define CS4224_PP_CLKMON_ING_CLKSEL_dft			  0x7F
#define CS4224_PP_CLKMON_ING_CTRL				  0x1D01
#define CS4224_PP_CLKMON_ING_CTRL_dft			  0x110
#define CS4224_PP_CLKMON_ING_DURATION			  0x1D02
#define CS4224_PP_CLKMON_ING_DURATION_dft		  0x0
#define CS4224_PP_CLKMON_ING_STATUS				  0x1D03
#define CS4224_PP_CLKMON_ING_STATUS_dft			  0x0
#define CS4224_PP_CLKMON_ING_COUNT1				  0x1D04
#define CS4224_PP_CLKMON_ING_COUNT1_dft			  0x0
#define CS4224_PP_CLKMON_ING_COUNT0				  0x1D05
#define CS4224_PP_CLKMON_ING_COUNT0_dft			  0x0
#define CS4224_PP_CLKMON_ING_MINTHRESH1			  0x1D06
#define CS4224_PP_CLKMON_ING_MINTHRESH1_dft		  0x0
#define CS4224_PP_CLKMON_ING_MINTHRESH0			  0x1D07
#define CS4224_PP_CLKMON_ING_MINTHRESH0_dft		  0x0
#define CS4224_PP_CLKMON_ING_MAXTHRESH1			  0x1D08
#define CS4224_PP_CLKMON_ING_MAXTHRESH1_dft		  0x0
#define CS4224_PP_CLKMON_ING_MAXTHRESH0			  0x1D09
#define CS4224_PP_CLKMON_ING_MAXTHRESH0_dft		  0x0
#define CS4224_PP_CLKMON_EGR_CLKSEL				  0x1D10
#define CS4224_PP_CLKMON_EGR_CLKSEL_dft			  0x7F
#define CS4224_PP_CLKMON_EGR_CTRL				  0x1D11
#define CS4224_PP_CLKMON_EGR_CTRL_dft			  0x110
#define CS4224_PP_CLKMON_EGR_DURATION			  0x1D12
#define CS4224_PP_CLKMON_EGR_DURATION_dft		  0x0
#define CS4224_PP_CLKMON_EGR_STATUS				  0x1D13
#define CS4224_PP_CLKMON_EGR_STATUS_dft			  0x0
#define CS4224_PP_CLKMON_EGR_COUNT1				  0x1D14
#define CS4224_PP_CLKMON_EGR_COUNT1_dft			  0x0
#define CS4224_PP_CLKMON_EGR_COUNT0				  0x1D15
#define CS4224_PP_CLKMON_EGR_COUNT0_dft			  0x0
#define CS4224_PP_CLKMON_EGR_MINTHRESH1			  0x1D16
#define CS4224_PP_CLKMON_EGR_MINTHRESH1_dft		  0x0
#define CS4224_PP_CLKMON_EGR_MINTHRESH0			  0x1D17
#define CS4224_PP_CLKMON_EGR_MINTHRESH0_dft		  0x0
#define CS4224_PP_CLKMON_EGR_MAXTHRESH1			  0x1D18
#define CS4224_PP_CLKMON_EGR_MAXTHRESH1_dft		  0x0
#define CS4224_PP_CLKMON_EGR_MAXTHRESH0			  0x1D19
#define CS4224_PP_CLKMON_EGR_MAXTHRESH0_dft		  0x0
#define CS4224_EEPROM_LOADER_STATUS				  0x5001
#define CS4224_EEPROM_LOADER_STATUS_dft			  0x0
#define CS4224_EEPROM_MICRO_ACCESS_CONTROL		  0x5005
#define CS4224_EEPROM_MICRO_ACCESS_CONTROL_dft	  0x0
#define CS4224_EEPROM_MICRO_ACCESS_STATUS		  0x5006
#define CS4224_EEPROM_MICRO_ACCESS_STATUS_dft	  0x0

/* bit masks */
#define CS_BIT0  0x0001
#define CS_BIT1  0x0002
#define CS_BIT2  0x0004
#define CS_BIT3  0x0008
#define CS_BIT4  0x0010
#define CS_BIT5  0x0020
#define CS_BIT6  0x0040
#define CS_BIT7  0x0080
#define CS_BIT8  0x0100
#define CS_BIT9  0x0200
#define CS_BIT10 0x0400
#define CS_BIT11 0x0800
#define CS_BIT12 0x1000
#define CS_BIT13 0x2000
#define CS_BIT14 0x4000
#define CS_BIT15 0x8000

/* bit masks for MSB registers */
#define CS_MSB_BIT16 0x0001
#define CS_MSB_BIT17 0x0002
#define CS_MSB_BIT18 0x0004
#define CS_MSB_BIT19 0x0008
#define CS_MSB_BIT20 0x0010
#define CS_MSB_BIT21 0x0020
#define CS_MSB_BIT22 0x0040
#define CS_MSB_BIT23 0x0080
#define CS_MSB_BIT24 0x0100
#define CS_MSB_BIT25 0x0200
#define CS_MSB_BIT26 0x0400
#define CS_MSB_BIT27 0x0800
#define CS_MSB_BIT28 0x1000
#define CS_MSB_BIT29 0x2000
#define CS_MSB_BIT30 0x4000
#define CS_MSB_BIT31 0x8000

unsigned int CS_ABS(int value);

void *CS_MEMSET(void *p, int c, int n);
void *CS_MEMCPY(void *p, const void *src, int n);
int CS_STRLEN(const char *s);
char *CS_STRCAT(char *dest, const char *source);
char *CS_STRNCPY(char *dest, const char *source, int count);

#define CS_IF_SET(val, mask) (((val) & (mask)) != 0)
#define CS_IF_ALL_SET(val, mask) (((val) & (mask)) == mask)
#define CS_IF_CLR(val, mask) (((val) & (mask)) == 0)
#define CS_SET(val, mask) (((val) | (mask)))
#define CS_CLR(val, mask) (((val) & ~(mask)))
#define CS_TOGGLE(val, mask) (((val) ^ (mask)))

enum e_cs4224_kran_an_status_t {
	CS4224_KRAN_AN_NOT_DONE,
	CS4224_KRAN_AN_DONE,
};

struct cs4224_kran_advertised_config_t_s {
	/* (A4) (4 x 10G) 40G Faceplate/Cable */
	unsigned short tech_cr4;

	/* (A3) (4 x 10G) 40G Backplane */
	unsigned short tech_kr4;

	/* (A2) 10G Backplane */
	unsigned short tech_kr;

	/* (A0) 1G Backplane */
	unsigned short tech_kx;

	/* (A1) (4 x 2.5G) 10G Backplane */
	unsigned short tech_kx4;

	/* (F0) FEC Ability */
	unsigned short f0;

	/* (F1) FEC Requested */
	unsigned short f1;

	/* (C0) Link Partner Pause Ability */
	unsigned short pause_0;

	/* (C1) Link Partner Pause Ability */
	unsigned short pause_1;

	/* (D13) Remote Fault */
	unsigned short rf;
};

struct cs4224_kran_advanced_config_t_s {
	/* Enable the line side fixed-phase override */
	unsigned char phase_or;

	/* Enable the host side fixed-phase override */
	unsigned char hphase_or;

	/* Enable the AN Ability Detect Timeout */
	unsigned char en_adt;

	/* Enable the TP Max Wait Timer */
	unsigned char en_mwt;

	/* Skip Auto-Negotiation */
	unsigned char skip_an;

	/* Skip Training */
	unsigned char skip_tp;

	/* Skip line side Phase Calibration */
	unsigned char skip_phsc;

	/* Enable Link Fail Inhibit Timer */
	unsigned char en_lfit;

	/* Enable AN Retries */
	unsigned char en_retry;

	/* Disable AN start */
	unsigned char dis_start;

	/* Enable DFE Power Savings */
	unsigned char en_pwrsv;

	/* Enable DFE */
	unsigned char en_dfe;

	/* Count Frames with Invalid Markers */
	unsigned char bad_mrkrs;

	/* Disable PCS Sync Checks in Mission Mode */
	unsigned char dis_sync;
	/* Enable the tx squelch control in the egress (host->line) path */
	unsigned char sqlch_egr;

	/* Enable the tx squelch control in the ingress (line->host) path */
	unsigned char sqlch_ing;

	/* Enables the use of the ring oscillator VCO */
	unsigned char ring;

	/* Line side Fixed-phase value, used only when phase_or is TRUE */
	unsigned short  phase_ov;

	/* Host side fixed-phase value, used only when hphase_or is TRUE */
	unsigned short  hphase_ov;

	/* Number of Additional Frames to Send at the Start of SEND_DATA */
	unsigned short  xtra_f;

	/* Iterations to Wait for PCS to Sync (multiply by 2^16) */
	unsigned short  pcs_itr;

	/* 10G LFI Timeout */
	unsigned short  lfi_10g;

	/* TP_TX maximum wait */
	unsigned short  max_wait;

	/* LFI Threshold */
	unsigned short  lfi_thres;

	/* 1G LFI timeout */
	unsigned short  lfi_1g;

	/* Override the LINK_READY wait_timer */
	unsigned short  wait_tmr;

	/* True = Main-cursor incremented to maximum,
	 * False=Main-cursor untouched
	 */
	unsigned char	tpm0;

	/* True = Post-cursor adaptive calibration,
	 * False=Post-cursor incremented to maximum
	 */
	unsigned char	tpm1;

	/* True = Send preset command at start */
	unsigned char	tpm2;

	/* True = Send init command at start */
	unsigned char	tpm3;

	/* True = Force local_rx_ready to True immediately */
	unsigned char	tpm4;

	/* Always set to 'b000 */
	unsigned short	tpm567;

	/* True = Enable pre/main/post Cursor Preset Values */
	unsigned char	preset;

	/* True = Skip Rx data corruption */
	unsigned char	tpm30;

	/* True = Invert Pre & Post cursor orientation (Leeds emulation mode) */
	unsigned char	tpm31;

	/* True = calibrate if we lose lock */
	unsigned char	jmp2cal;

	/* True = reference clock frequency is 106.25Mhz,
	 * set according to rules->ref_clk_rate
	 */
	unsigned char	ref106;

	/* True = two-pass mode for optical links enabled */
	unsigned short two_pass_mode;

	/* True = disable FEC even when FEC is advertized and negotiated */
	unsigned short fec_bypass;

	/* Time to EDC converge in DFE mode, line side,
	 * range 0...0xffff, default 0x0180
	 */
	unsigned short line_t_to_conv_dfe;

	/* Time to EDC converge in DFE mode, host side,
	 * range 0...0xffff, default 0x0240
	 */
	unsigned short host_t_to_conv_dfe;

};

struct cs4224_kran_config_t_s {
	struct cs4224_kran_advertised_config_t_s advertised;
	struct cs4224_kran_advanced_config_t_s   advanced;
};

struct cs4224_kran_results_t_s {
	/* Parallel detect */
	unsigned char	bp_par_detect:1;

	/* (4 x 10G) 40G CR4 capability detect */
	unsigned char	bp_40gcr4:1;

	/* (4 x 10G) 40G KR4 capability detect */
	unsigned char	bp_40gkr4:1;

	/* 10G KR capability detect */
	unsigned char	bp_10gkr:1;

	/* 1G KX capability detect */
	unsigned char	bp_1000kx:1;

	/* (4 x 2.5G) 10G KX4 capability detect */
	unsigned char	bp_10gkx4:1;

	/* FEC capability detect */
	unsigned char	bp_fec:1;

	/* Remote Fault */
	unsigned char	bp_rf:1;

	/* Pause ability */
	unsigned char	bp_pause:3;
};
extern unsigned int cs4224_max_num_ports;

unsigned int CS4224_MAX_NUM_PORTS(void);
unsigned int CS4224_MAX_NUM_SLICES(unsigned int slice);
unsigned int CS4224_MAX_NUM_DIES(unsigned int slice);

#define CS4224_RULE_DISABLED 0xFFFF
#define CS4224_MAX_NUM_CS4223_PORTS   4  /*  4 port duplex	*/
#define CS4224_MAX_NUM_CS4224_PORTS  16  /* 16 port simplex */
#define CS4224_MAX_NUM_CS4343_PORTS   8  /*  8 port duplex	*/
#define CS4224_MAX_NUM_CS4221_PORTS  10  /* 10 port simplex */
#define CS4224_MAX_NUM_CS4227_PORTS   2  /*  2 port duplex	*/
#define CS4224_MAX_NUM_CS4210_PORTS  16  /* 16 port simplex */
#define CS4224_MAX_NUM_CS4341_PORTS   8  /*  8 port duplex */

/* The number of available dies in the device	 */
#define CS4224_MAX_NUM_CS4223_DIES	  1  /*  4 port duplex	*/
#define CS4224_MAX_NUM_CS4224_DIES	  2  /* 16 port simplex */
#define CS4224_MAX_NUM_CS4343_DIES	  2  /*  8 port duplex	*/
#define CS4224_MAX_NUM_CS4221_DIES	  2  /* 10 port simplex */
#define CS4224_MAX_NUM_CS4227_DIES	  1  /*  2 port duplex	*/
#define CS4224_MAX_NUM_CS4210_DIES	  2  /* 16 port simplex */
#define CS4224_MAX_NUM_CS4341_DIES	  2  /*  8 port duplex */

/* The difference between line and host PP registers */
#define CS4224_LINE_TO_HOST_OFFSET	  0x0800

#define CS4224_REF_CLK_156p25 156250 /* kHz */
#define CS4224_REF_CLK_155p52 155520
#define CS4224_REF_CLK_106p25 106250

/* The preferred GLOBAL_MDIO_CONFIG value */
#define CS4224_GLOBAL_MDIO_CONFIG_pref 0x78

/* Required or loaded ucode image bit map */
enum e_cs4224_ucode_image {
	CS4224_UCODE_IMAGE_NONE = 0x0,
	CS4224_UCODE_IMAGE_KR	= 0x1,
	CS4224_UCODE_IMAGE_FC	= 0x2,
	CS4224_UCODE_IMAGE_ANY	= 0x3,
};

/* Hardware ID numbers for the ASIC as defined in Efuse SKU */
enum e_cs4224_hardware_id {
	/* Undefined */
	CS4224_HW_UNDEF  = 0,

	/* 4 port duplex */
	CS4224_HW_CS4223 = 0x0010,

	/* 16 port simplex */
	CS4224_HW_CS4224 = 0x0011,

	/* 8 port duplex */
	CS4224_HW_CS4343 = 0x0012,

	/* 10 port simplex */
	CS4224_HW_CS4221 = 0x0013,

	/* 2 port duplex */
	CS4224_HW_CS4227 = 0x0014,

	/* 16 port simplex, 15G only */
	CS4224_HW_CS4210 = 0x0015,

	/* 8 port duplex, 10G only */
	CS4224_HW_CS4341 = 0x0016
};

/* Pre-defined target applications used
 * with the cs4224_rules_set_default() method
 * to setup default configurations
 */
enum e_cs4224_target_application {
	/* Configure the device for 156.25MHz ref clock, 1.25GHz operation */
	CS4224_TARGET_APPLICATION_1G = 0,

	/* Configure the device for 156.25MHz ref clock, 5GHz operation */
	CS4224_TARGET_APPLICATION_5G,

	/* Configure the device for 156.25MHz ref clock, 7.5GHz operation */
	CS4224_TARGET_APPLICATION_7p5G,

	/* Configure the device for 156.25MHz ref clock, 8GHz operation */
	CS4224_TARGET_APPLICATION_8G,

	/* Configure the device for 156.25MHz ref clock, 8.5GHz operation */
	CS4224_TARGET_APPLICATION_8p5G,

	/* Configure the device for 156.25MHz ref clock, 10.3125GHz operation */
	CS4224_TARGET_APPLICATION_10G,

	/* Configure the device for 156.25MHz ref clock, 15GHz operation */
	CS4224_TARGET_APPLICATION_15G,
	CS4224_TARGET_APPLICATION_10G_KR,
	CS4224_TARGET_APPLICATION_40G_KR,

	/* Configure the device for KR-AN operation */
	CS4224_TARGET_APPLICATION_KRAN,

	/* Configure the device for FC-AN operation */
	CS4224_TARGET_APPLICATION_FCAN,

	/* Configure the device for 106.25MHz refclk, 14.025GHz FC */
	CS4224_TARGET_APPLICATION_16G_FC,

	/* Configure the device for 106.25MHz refclk, 10.51875GHz FC */
	CS4224_TARGET_APPLICATION_10G_FC,

	/* Configure the device for 106.25MHz refclk, 8.5GHz FC */
	CS4224_TARGET_APPLICATION_8G_FC,

	/* Configure the device for 106.25MHz refclk, 4.25GHz FC */
	CS4224_TARGET_APPLICATION_4G_FC,

	/* Configure the device for 106.25MHz refclk, 2.125GHz FC*/
	CS4224_TARGET_APPLICATION_2G_FC,

	/* Configure the device for 106.25MHz refclk, 1.0625GHz FC */
	CS4224_TARGET_APPLICATION_1G_FC,

	/* Configure the device for 156.25MHz refclk, 622.08MHz OC12 */
	CS4224_TARGET_APPLICATION_OC12
};

#define e_cs4224_cfg_sides_t	e_cs4224_datapath_dir_t

/* Data-path direction and side selector */
enum e_cs4224_datapath_dir_t {
	/* Select the Line to Host path (Ingress) */
	CS4224_LINE_RX_TO_HOST_TX_DIR = 1,

	/* Configure the line side */
	CS4224_CFG_LINE_SIDE		  = 1,

	/* Select the Host to Line path (Egress) */
	CS4224_HOST_RX_TO_LINE_TX_DIR = 2,

	/* Configure the host side */
	CS4224_CFG_HOST_SIDE		  = 2,

	/* The channel is simplex; direction is picked automatically by API */
	CS4224_SIMPLEX_DIR = 3,

	/* Configure a simplex slice */
	CS4224_CFG_SIMPLEX = 3,
};

/* The supply voltage for the voltage monitor */
enum e_cs4224_mon_vlt_supply {
	/* 0.9V supply TX */
	CS4224_VLT_SUPPLY_0p9V = 0,

	/* 1.8V supply */
	CS4224_VLT_SUPPLY_1p8V = 1,
};

/* The EDC modes supported by the microcode */
enum e_cs4224_edc_mode {
	/*
	 * Disable the microcode. Does not disable the EDC.
	 *
	 * @{warning,
	 *	  This mode is not recommended and should not be used unless
	 *	  explicitly told to do so by Cortina
	 * }
	 */
	CS_HSIO_EDC_MODE_DISABLED = 0x0001,

	/*
	 * DFE mode meant for CX1 or direct attach compatible cables.
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		  ! Note
	 * - 9.8Gbps  ! <10.6Gbps ! API Optimized range
	 * - 10.6Gbps ! <11.3Gbps ! Optional tuning could be applied
	 * - 11.3Gbps ! <12.5Gbps ! Optional tuning could be applied
	 * }
	 */
	CS_HSIO_EDC_MODE_CX1 = 0x0002,

	/*
	 * Non-DFE mode meant to support low channel loss applications.
	 *
	 * Short for 'short reach'. This mode is suitable for connecting to
	 * SR modules, very short on-board connections, or anything involving
	 * slow data rates.
	 *
	 * @{note,
	 * Although it's a fully adaptive mode, unlike DFE modes receiver tuning
	 * is required to maximize performance. See these rules:
	 *
	 * - rules.rx_if.dplx_line_eq (Duplex devices)
	 * - rules.rx_if.dplx_host_eq (Duplex devices)
	 * - rules.rx_if.splx_eq	  (Simplex devices)
	 * }
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	 ! Max	   ! Note
	 * - 622Mbps ! 15Gbps  ! API Optimized range
	 * }
	 *
	 */
	CS_HSIO_EDC_MODE_SR = 0x0004,

	/*
	 * DFE mode meant to support ZR modules.
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		  ! Note
	 * - 9.8Gbps  ! <10.6Gbps ! API Optimized range
	 * - 10.6Gbps ! <11.3Gbps ! Optional tuning could be applied
	 * - 11.3Gbps ! <12.5Gbps ! Optional tuning could be applied
	 * }
	 */
	CS_HSIO_EDC_MODE_ZR = 0x0008,

	/*
	 * DFE mode meant to support DWDM modules.
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		  ! Note
	 * - 9.8Gbps  ! <10.6Gbps ! API Optimized range
	 * - 10.6Gbps ! <11.3Gbps ! Optional tuning could be applied
	 * - 11.3Gbps ! <12.5Gbps ! Optional tuning could be applied
	 * }
	 */
	CS_HSIO_EDC_MODE_DWDM = 0x0010,

	/*
	 * DFE mode meant to support 9.8 to 12.5G data rates over a backplane.
	 *
	 * @{note,
	 * KR-AN DFE mode is supported through CS_HSIO_EDC_MODE_10G_BP,
	 * see KR-AN programming
	 * examples for more info.
	 * }
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		  ! Note
	 * - 9.8Gbps  ! <10.6Gbps ! API Optimized range
	 * - 10.6Gbps ! <11.3Gbps ! Optional tuning could be applied to improve
	 * - 11.3Gbps ! <12.5Gbps ! Optional tuning could be applied to improve
	 * }
	 */
	CS_HSIO_EDC_MODE_10G_BP = 0x0020,

	/*
	 * DFE mode meant to support 12.5 to 15G data rates over a backplane.
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		! Note
	 * - 12.5Gbps ! <14Gbps ! Optional tuning could be applied.
	 * - 14Gbps   ! 15Gbps	! API optimized range
	 * }
	 */
	CS_HSIO_EDC_MODE_15G_BP = 0x0040,

	/*
	 * DFE mode meant to support 5 to 7.5G data rates over a backplane.
	 *
	 * @{note,
	 * CS_HSIO_EDC_MODE_5G_BP and CS_HSIO_EDC_MODE_7p5G_BP are functionally
	 * equivalent
	 * }
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	 ! Max	   ! Note
	 * - 5.0Gbps ! 7.5Gbps ! API optimized range
	 * }
	 */
	CS_HSIO_EDC_MODE_5G_BP = 0x0080,

	/*
	 * DFE mode meant to support 5 to 7.5G data rates over a backplane.
	 *
	 * @{note,
	 * CS_HSIO_EDC_MODE_5G_BP and CS_HSIO_EDC_MODE_7p5G_BP are functionally
	 * equivalent
	 * }
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	 ! Max	   ! Note
	 * - 5.0Gbps ! 7.5Gbps ! API optimized range
	 * }
	 */
	CS_HSIO_EDC_MODE_7p5G_BP = 0x0100,

	/*
	 * DFE mode meant to support 8 to 8.6G data rates over a backplane.
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	 ! Max	   ! Note
	 * - 8.0Gbps ! 8.6Gbps ! API optimized range
	 * }
	 */
	CS_HSIO_EDC_MODE_8p5G_BP = 0x0200,

	/*
	 * DFE mode for the line side on FC-AN connections.
	 *
	 * @{note,
	 * FC-AN SR/DFE mode on the line side is supported through
	 * CS_HSIO_EDC_MODE_FCAN,
	 * see FC-AN programming examples for more info.
	 * }
	 *
	 * @{table,
	 * -h Supported Data Rates
	 * -s Fibre Channel Rates ! Note
	 * - FC1, FC2, FC4, FC8, FC10, FC16 ! API optimized range
	 * }
	 */
	CS_HSIO_EDC_MODE_FCAN = 0x0400,

	/*
	 * DFE mode meant for very specific 15G backplane applications.
	 *
	 * @{warning,
	 * Do not use unless advised to do so by a Cortina AE.
	 * }
	 */
	CS_HSIO_EDC_MODE_15G_BP_27dB = 0x0800,

	/*
	 * DFE mode meant for Single Mode Fibre with a Long Reach Module (SMLRM)
	 * @{table,
	 * -h Supported Data Rates
	 * -s Min	  ! Max		  ! Note
	 * - 9.8Gbps  ! <10.6Gbps ! API Optimized range
	 * - 10.6Gbps ! <11.3Gbps ! Optional tuning could be applied
	 * - 11.3Gbps ! <12.5Gbps ! Optional tuning could be applied
	 * }
	 */
	CS_HSIO_EDC_MODE_SMLRM = 0x1000
};

/* Settings used to compensate for trace loss on the board */
enum e_cs4224_trace_loss {
	/* For trace loss where trace loss <= 1dB */
	CS_HSIO_TRACE_LOSS_0dB,

	/* For trace loss where trace loss <= 2dB */
	CS_HSIO_TRACE_LOSS_1dB,

	/* For trace loss where 2dB < trace loss <= 3dB */
	CS_HSIO_TRACE_LOSS_2dB,

	/* For trace loss where 3dB < trace loss < 4dB */
	CS_HSIO_TRACE_LOSS_3dB,

	/* For trace loss where 4dB < trace loss <= 5dB */
	CS_HSIO_TRACE_LOSS_4dB,

	/* For trace loss where 5dB < trace loss <= 5.5dB */
	CS_HSIO_TRACE_LOSS_5dB,

	/* For trace loss where trace loss > 5.5dB */
	CS_HSIO_TRACE_LOSS_6dB,

	/* For trace loss where trace loss = 15dB */
	CS_HSIO_TRACE_LOSS_15dB,

	/* For trace loss where trace loss = 27dB */
	CS_HSIO_TRACE_LOSS_27dB,

	/* For CR4 cables */
	CS_HSIO_TRACE_LOSS_CR4,

	/* Special case for no-loss coax cables, for use in the lab */
	CS_HSIO_TRACE_LOSS_LAB,
};

/* Polarity Inversion bit map */
enum e_cs4224_polarity_inv_t {
	/* No polarity inversion */
	CS4224_POLARITY_INV_NONE	  = 0,

	/* Duplex host Tx driver polarity inversion */
	CS4224_POLARITY_INV_DPLX_HOST_TX  = 1 << 0,

	/* Duplex line Tx driver polarity inversion */
	CS4224_POLARITY_INV_DPLX_LINE_TX  = 1 << 1,

	/* Simplex Tx driver polarity inversion */
	CS4224_POLARITY_INV_SPLX_TX	  = 1 << 2,

	/* Duplex host Rx (digital, pre-FEC) polarity inversion */
	CS4224_POLARITY_INV_DPLX_HOST_RX  = 1 << 3,

	/* Duplex line Rx (digital, pre-FEC) polarity inversion */
	CS4224_POLARITY_INV_DPLX_LINE_RX  = 1 << 4,

	/* Simplex Rx (digital, pre-FEC) polarity inversion */
	CS4224_POLARITY_INV_SPLX_RX	  = 1 << 5,

};

/* Determines which microsequencer to stall/un-stall */
enum e_cs4224_mseq_id {
	/* The simplex (line or host) microsequencer */
	CS4224_SPLX_MSEQ	  = 0,

	/* The duplex (line) microsequencer */
	CS4224_DPLX_LINE_MSEQ = 1,

	/* The duplex (host) microsequencer */
	CS4224_DPLX_HOST_MSEQ = 2,
};

/* Protection switch specific actions, note that for digital broadcast switching
 * the 0 refers to the lower slice (even) of the protection pair, slice 1 the
 * higher (odd).
 */
enum e_cs4224_switch_action_t {
	/* disable switch */
	CS4224_SWITCH_DISABLE				   = 0,

	/* Duplex 2x2 switch from slices 0 to 1 and 1 to 0 bi-directionally */
	CS4224_SWITCH_DIGITAL_SWITCH_2x2	   = 1,
	/* Duplex 2x2 switch from slices 0 to 1 and 1 to 0 bi-directionally */
	CS4224_SWITCH_DUPLEX_SWITCH_2x2		   = 1,

	/* Digital broadcast, Rx/Tx on slice 0 to 0 with line Tx only on 1 */
	CS4224_SWITCH_DIGITAL_BROADCAST_0_to_0 = 2,
	/* Duplex broadcast, Rx/Tx on slice 0 to 0 with line Tx only on 1 */
	CS4224_SWITCH_DUPLEX_BROADCAST_0_to_0  = 2,

	/* Digital broadcast, Rx/Tx on slice 1 to 1 with line Tx only on 0 */
	CS4224_SWITCH_DIGITAL_BROADCAST_1_to_1 = 3,
	CS4224_SWITCH_DUPLEX_BROADCAST_1_to_1 = 3,

	/* Digital broadcast, Rx/Tx on slice 0 to 1 with line Tx only on 0 */
	CS4224_SWITCH_DIGITAL_BROADCAST_0_to_1 = 4,
	CS4224_SWITCH_DUPLEX_BROADCAST_0_to_1 = 4,

	/* Digital broadcast, Rx/Tx on slice 1 to 0 with line Tx only on 1 */
	CS4224_SWITCH_DIGITAL_BROADCAST_1_to_0 = 5,
	CS4224_SWITCH_DUPLEX_BROADCAST_1_to_0 = 5,

	/* Simplex 2x2 switch of slice with mate */
	CS4224_SWITCH_SIMPLEX_SWITCH_2x2		= 6,
	/* Analog 2x2 switch of slice with mate */
	CS4224_SWITCH_ANALOG_SWITCH_2x2		   = 6,

	/* Simplex broadcast, transmits on slice and its mate */
	CS4224_SWITCH_SIMPLEX_BROADCAST			= 7,
	/* Analog broadcast, transmits on slice and its mate */
	CS4224_SWITCH_ANALOG_BROADCAST		   = 7,

};

/* The CLKDIV_CTRL, SRX_DDIV_SEL dividers
 * NOTE: There are accidentally two structures like this, the other is below
 */
enum e_cs4224_clkdiv_ddiv_t {
	/* Rx serial clock div by 1 */
	CS4224_CLKDIV_DDIV_BY_1   = 0,

	/* Rx serial clock div by 2 */
	CS4224_CLKDIV_DDIV_BY_2   = 1,

	/* Rx serial clock div by 4 */
	CS4224_CLKDIV_DDIV_BY_4   = 2,

	/* Rx serial clock div by 8 */
	CS4224_CLKDIV_DDIV_BY_8   = 3,

	/* Rx serial clock div by 16 */
	CS4224_CLKDIV_DDIV_BY_16  = 4,

	/* Rx serial clock div by 32 */
	CS4224_CLKDIV_DDIV_BY_32  = 5,

	/* Rx serial clock div by 64 */
	CS4224_CLKDIV_DDIV_BY_64  = 6,

	/* Rx serial clock div by 128 */
	CS4224_CLKDIV_DDIV_BY_128 = 7,

};

/* Divider for the clock rate for receive data path */
enum e_cs4224_ddiv_divide {
	/* Divide by 1 */
	CS4224_DDIV_DIV1 = 0,

	/* Divide by 2 */
	CS4224_DDIV_DIV2 = 1,

	/* Divide by 4 */
	CS4224_DDIV_DIV4 = 2,

	/* Divide by 8 */
	CS4224_DDIV_DIV8 = 3,

	/* Divide by 16 */
	CS4224_DDIV_DIV16 = 4,

	/* Divide by 32 */
	CS4224_DDIV_DIV32 = 5,

	/* Divide by 64 */
	CS4224_DDIV_DIV64 = 6,

	/* Divide by 128 */
	CS4224_DDIV_DIV128 = 7
};

/* The CLKDIV_CTRL, SRX_RDIV_SEL dividers
 * NOTE: There are accidentally two structures like this, the other is below
 */
enum e_cs4224_clkdiv_rdiv_t {
	/* Rx serial clock div by 8 */
	CS4224_CLKDIV_RDIV_BY_8   = 0,

	/* Rx serial clock div by 16 */
	CS4224_CLKDIV_RDIV_BY_16  = 1,

	/* Rx serial clock div by 32 */
	CS4224_CLKDIV_RDIV_BY_32  = 2,

	/* Rx serial clock div by 40 */
	CS4224_CLKDIV_RDIV_BY_40  = 3,

	/* Rx serial clock div by 64 */
	CS4224_CLKDIV_RDIV_BY_64  = 4,

	/* Rx serial clock div by 66 */
	CS4224_CLKDIV_RDIV_BY_66  = 5,

	/* Rx serial clock div by 80 */
	CS4224_CLKDIV_RDIV_BY_80  = 6,

	/* Rx serial clock div by 100 */
	CS4224_CLKDIV_RDIV_BY_100 = 7,

	/* Rx serial clock div by 128 */
	CS4224_CLKDIV_RDIV_BY_128 = 8,
};

/* The serial clock divider to receive PFD
 * for comparison to the clock reference.
 */
enum e_cs4224_rdiv_divide {
	/* Rx serial clock div by 8 */
	CS4224_RDIV_DIV8   = 0,

	/* Rx serial clock div by 16 */
	CS4224_RDIV_DIV16  = 1,

	/* Rx serial clock div by 32 */
	CS4224_RDIV_DIV32  = 2,

	/* Rx serial clock div by 40 */
	CS4224_RDIV_DIV40  = 3,

	/* Rx serial clock div by 64 */
	CS4224_RDIV_DIV64  = 4,

	/* Rx serial clock div by 66 */
	CS4224_RDIV_DIV66  = 5,

	/* Rx serial clock div by 80 */
	CS4224_RDIV_DIV80  = 6,

	/* Rx serial clock div by 100 */
	CS4224_RDIV_DIV100 = 7,

	/* Rx serial clock div by 128 */
	CS4224_RDIV_DIV128 = 8,
};

/* Accumulator width options for the Fractional-N divider */
enum e_cs4224_fracdiv_accumulator_width {
	/* 8 bit accumulator */
	CS4224_FRACDIV_ACCUM_WIDTH_8BIT = 0,

	/* 16 bit accumulator */
	CS4224_FRACDIV_ACCUM_WIDTH_16BIT = 1,

	/* 24 bit accumulator */
	CS4224_FRACDIV_ACCUM_WIDTH_24BIT = 2,

	/* 32 bit accumulator */
	CS4224_FRACDIV_ACCUM_WIDTH_32BIT = 3,
};

/* The clock monitor clock source divider */
enum e_cs4224_clk_mon_clksel_div {
	/* Divide by 1 */
	CS4224_CLK_MON_DIV1  = 0,

	/* Divide by 4 */
	CS4224_CLK_MON_DIV4  = 1,

	/* Divide by 8 */
	CS4224_CLK_MON_DIV8  = 2,

	/* Divide by 16 */
	CS4224_CLK_MON_DIV16 = 3,
};

/* The per-port (pp) clock monitor clock source */
enum e_cs4224_pp_clk_mon_clksel_src {
	/* Clock source is SRX_CLK */
	CS4224_CLK_MON_PP_SRX	 = 0x00 << 2,

	/* Clock source is STX_CLK */
	CS4224_CLK_MON_PP_STX	 = 0x01 << 2,

	/* Clock source is SRX_CLK_LD */
	CS4224_CLK_MON_PP_CLK_LD = 0x02 << 2,

	/* Clock source is SRX_REF_LD */
	CS4224_CLK_MON_PP_REF_LD = 0x03 << 2,

	/* Clock source is SRX_FAST_CLK */
	CS4224_CLK_MON_PP_FAST	 = 0x04 << 2,

	/* Clock source is SRX_DIV32_OUT */
	CS4224_CLK_MON_PP_DIV32  = 0x05 << 2,

	/* Clock source is SRX_DIV80_OUT */
	CS4224_CLK_MON_PP_DIV80  = 0x06 << 2,

	/* Clock source is SRX_DIV64_OUT */
	CS4224_CLK_MON_PP_DIV64  = 0x07 << 2,

	/* Clock source is SRX_MON_CLK */
	CS4224_CLK_MON_PP_MON	 = 0x08 << 2,

	/* Clock source is no clock */
	CS4224_CLK_MON_PP_NO_CLK = 0x10 << 2,

	/* Clock source is reset dividers, output idle */
	CS4224_CLK_MON_PP_RESET  = 0x3f,

};

/* The global (gbl) clock monitor clock source */
enum e_cs4224_gbl_clk_mon_clksel_src {
	/* Clock source is process monitor */
	CS4224_CLK_MON_GBL_PMON   = 0x00 << 2,

	/* Clock source is process monitor divided by 2 */
	CS4224_CLK_MON_GBL_PMOND2 = 0x01 << 2,

	/* Clock source is process monitor divided by 4 */
	CS4224_CLK_MON_GBL_PMOND4 = 0x02 << 2,

	/* Clock source is reference clock */
	CS4224_CLK_MON_GBL_REFCLK = 0x03 << 2,

	/* Clock source is clockless VCO clock */
	CS4224_CLK_MON_GBL_VCO	  = 0x04 << 2,

	/* Clock source is GPIO1 */
	CS4224_CLK_MON_GBL_GPIO1  = 0x06 << 2,

	/* Clock source is GPIO2 */
	CS4224_CLK_MON_GBL_GPIO2  = 0x07 << 2,

	/* Clock source is port pair 0 egress selected clock */
	CS4224_CLK_MON_GBL_PP0EGR = 0x08 << 2,

	/* Clock source is port pair 0 ingress selected clock */
	CS4224_CLK_MON_GBL_PP0ING = 0x09 << 2,

	/* Clock source is port pair 1 egress selected clock */
	CS4224_CLK_MON_GBL_PP1EGR = 0x0a << 2,

	/* Clock source is port pair 1 ingress selected clock */
	CS4224_CLK_MON_GBL_PP1ING = 0x0b << 2,

	/* Clock source is port pair 2 egress selected clock */
	CS4224_CLK_MON_GBL_PP2EGR = 0x0c << 2,

	/* Clock source is port pair 2 ingress selected clock */
	CS4224_CLK_MON_GBL_PP2ING = 0x0d << 2,

	/* Clock source is port pair 3 egress selected clock */
	CS4224_CLK_MON_GBL_PP3EGR = 0x0e << 2,

	/* Clock source is port pair 3 ingress selected clock */
	CS4224_CLK_MON_GBL_PP3ING = 0x0f << 2,

	/* Clock source is no clock */
	CS4224_CLK_MON_GBL_NO_CLK = 0x10 << 2,

	/* Clock source is reset dividers, output idle */
	CS4224_CLK_MON_GBL_RESET  = 0x7f,
};

/* Used to select the driver being configured */
enum e_cs4224_tx_driver_interface {
	/* The host side transmitter */
	CS4224_TX_HOST_INTERFACE  = 0,

	/* The line side transmitter */
	CS4224_TX_LINE_INTERFACE  = 1,

	/* If in simplex mode this automatically
	 * determines the appropriate transmitter for the channel
	 */
	CS4224_TX_SIMPLEX_INTERFACE = 2,
};

/* PCS Monitor Status */
struct cs4224_pcs_monitor_status_t {
	/* PCS monitor reveiver state machine sync status */
	unsigned char sync;

	/* PCS monitor is in a high bit error state (XGPCS only) */
	unsigned int high_ber;
};

/* FEC Statistics */
struct cs4224_fec_stats_t {
	/* Number of FEC blocks transmitted by the line side Tx module */
	unsigned int tx_blk_total;

	/* Number of FEC blocks received (decoded) by the line side Rx module */
	unsigned int rx_blk_total;

	/* Number of FEC blocks successfully corrected by the Rx module */
	unsigned int rx_blk_corr;

	/* Number of FEC blocks unable to be corrected by the Rx module */
	unsigned int rx_blk_uncorr;

	/* Number of zero bit errors detected by the Rx module */
	unsigned int rx_zero_errs;

	/* Number of one bit errors detected by the Rx module */
	unsigned int rx_one_errs;
};

/*
 * Configuration for the per-port (pp) clock monitor
 * Use cs4224_pp_clk_mon_cfg_init() to initialize
 */
struct cs4224_pp_clk_mon_cfg_t {
	/* Select the clock source divider */
	enum e_cs4224_clk_mon_clksel_div clksel_divider;

	/* Select the clock source */
	enum e_cs4224_pp_clk_mon_clksel_src clksel_src;

	/* Start counting flag */
	unsigned char go;

	/* Enable counter to free run	*/
	unsigned char free_run;

	/* Time duration to count */
	unsigned short  duration;

	/* minimum count threshold */
	unsigned int  min_thresh;

	/* maximum count threshold */
	unsigned int  max_thresh;
};

/* Configuration for the global (gbl) clock monitor */
struct cs4224_gbl_clk_mon_cfg_t {
	/* Select the clock source divider */
	enum e_cs4224_clk_mon_clksel_div clksel_divider;

	/* Select the clock source */
	enum e_cs4224_gbl_clk_mon_clksel_src clksel_src;

	/* Start counting flag */
	unsigned char go;

	/* Enable counter to free run	*/
	unsigned char free_run;

	/* Time duration to count */
	unsigned short  duration;

	/* minimum count threshold, 32 bits */
	unsigned short  min_thresh_0;
	unsigned short  min_thresh_1;

	/* maximum count threshold, 32 bits */
	unsigned short  max_thresh_0;
	unsigned short  max_thresh_1;
};

/*
 * This structure is used to store state information
 * that is used when enabling a 2x2 or broadcast
 * switch.
 */
struct cs4224_switch_state_t {
	/* The state of the line SRX0_RX_CLKOUT_CTRL register */
	unsigned short line_srx0_rx_clkout_ctrl;

	/* The state of the host SRX0_RX_CLKOUT_CTRL register */
	unsigned short host_srx0_rx_clkout_ctrl;

	/* The state of the line COMMON_STX0_MISC register */
	unsigned short line_stx0_misc;

	/* The state of the host COMMON_STX0_MISC register */
	unsigned short host_stx0_misc;

	/* The state of the line DSP_MSEQ_POWER_DOWN_LSB register */
	unsigned short line_mseq_power_down;

	/* The state of the host DSP_MSEQ_POWER_DOWN_LSB register */
	unsigned short host_mseq_power_down;

	/* The state of the line STX0_DRIVER_CONFIG register */
	unsigned short line_stx0_driver_config;

	/* The state of the host STX0_DRIVER_CONFIG register */
	unsigned short host_stx0_driver_config;

	/* The state of the line DSP_MSEQ_MAIL_SEL register */
	unsigned short line_dsp_mseq_mail_sel;

	/* The state of the host DSP_MSEQ_MAIL_SEL register */
	unsigned short host_dsp_mseq_mail_sel;

	/* The state of the host SRX0_VCO_CONFIG register */
	unsigned short host_srx0_vco_config;

	/* The state of the host SRX0_AGC_CONFIG1 register */
	unsigned short host_srx0_agc_config1;

	/* The state of the host SRX0_DFE_CONFIG register */
	unsigned short host_srx0_dfe_config;

	/* The state of the line SRX0_RX_CONFIG register */
	unsigned short line_srx0_rx_config;

	/* The state of the host SRX0_RX_CONFIG register */
	unsigned short host_srx0_rx_config;

	/* The state of the line MSEQ_SPARE12_LSB register */
	unsigned short line_spare12_lsb;

	/* The state of the host MSEQ_SPARE12_LSB register */
	unsigned short host_spare12_lsb;

	/* The state of the line MSEQ_SPARE26_LSB register */
	unsigned short line_spare26_lsb;
};

/*
 * This structure is used to maintain device state when
 * managing the duplex 2x2 protection switching. It must
 * be initialized when the switch is first initialized and
 * then gets passed to consecutive API calls to manage
 * the h/w state.
 */
struct cs4224_switch_pair_state_t {
	/*
	 * This flag is used to determine whether or not the
	 * switch state has been initialized. Before activating the
	 * switch for the first time this variable should be set to
	 * FALSE to ensure that the API knows that the state
	 * should be stored.
	 */
	unsigned char initialized;

	/*
	 * This flag is managed by the user to setup the switch in low
	 * latency mode. This bypasses the digital path through
	 * the chip and achieves the lowest possible latency. However
	 * it cannot be used when KR-AN or FC-AN are enabled
	 */
	unsigned char low_latency_switching;

	/*
	 * State space used to manage the two slices of
	 * the switch pair. This is managed automatically
	 * by the API.
	 */
	struct cs4224_switch_state_t slices[2];

	/*
	 * For duplex switching on dual-die devices, write the switch config to
	 * both dies at the same time.
	 *
	 * Ignored for simplex switching. Only supported in superfast methods.
	 * Only relevant for the 8-port duplex devices.
	 *
	 * For which pairs will be set at the same time:
	 *
	 * @{table,
	 * -h Slice pairs that will be set when broadcast is enabled
	 * -s Die 1 ! Die 0
	 * - 0/1 ! 6/7
	 * - 2/3 ! 4/5
	 * }
	 */
	unsigned char broadcast;
};

/* Configuration for the SyncE application */
struct cs4224_rules_synce_config_t {
	/* Enable SyncE */
	unsigned char enable;

	/* The core fracN integer divisor */
	unsigned short divisor;

	/* The core fracN numerator */
	unsigned int numerator;

	/* The clock divider */
	enum e_cs4224_clk_mon_clksel_div clk_divider;

	/* the GPIO to ouput the SyncE signal,
	 * range GPIO1 thru GPIO4 and GPIO_INTERR
	 */
	unsigned char  gpio;

	/* the direction, line Rx or host Rx */
	enum e_cs4224_datapath_dir_t dir;
};

/* Configuration for the CDR frac-N's in the Rx and Tx interfaces */
struct cs4224_rules_fracdiv_config_t {
	/* Enable the fracN block */
	unsigned char enable;

	/* The integer divisor, 8 bits wide */
	unsigned short divisor;

	/* The numerator, 24bits wide */
	unsigned int numerator;

};

/* Configuration rules for trace loss on the Rx or Tx interfaces */
struct cs4224_rules_intf_t {
	/* Trace loss setting */
	enum e_cs4224_trace_loss traceloss;
};

struct cs4224_advanced_rules_t {
	unsigned char phsel_bypass;
	unsigned short phsel_bypass_value;
};

/* Rx interface rules for device initialization */
struct cs4224_rules_rx_if_t {
	/* The EDC mode for the Rx interface (simplex only) */
	enum e_cs4224_edc_mode splx_edc_mode;

	/* The line EDC mode for the Rx interface (duplex only) */
	enum e_cs4224_edc_mode dplx_line_edc_mode;

	/* The host EDC mode for the Rx interface (duplex only) */
	enum e_cs4224_edc_mode dplx_host_edc_mode;

	/* Rx equalization rules (simplex only) */
	struct cs4224_rules_intf_t splx_eq;

	/* Rx line equalization rules (duplex only) */
	struct cs4224_rules_intf_t dplx_line_eq;

	/* Rx host equalization rules (duplex only) */
	struct cs4224_rules_intf_t dplx_host_eq;
};

/* Tx interface rules for device initialization */
struct cs4224_rules_tx_if_t {
	/* Disable the transmitter (simplex only) */
	unsigned char splx_disable;

	/* Disable the line transmitter (duplex only) */
	unsigned char dplx_line_disable;

	/* Disable the host transmitter (duplex only) */
	unsigned char dplx_host_disable;

	/* Tx driver initialization rules (simplex only) */
	struct cs4224_rules_intf_t splx_driver;

	/* Tx line driver initialization rules (duplex only) */
	struct cs4224_rules_intf_t dplx_line_driver;

	/* Tx host driver initialization rules (duplex only) */
	struct cs4224_rules_intf_t dplx_host_driver;

	/* power-down flag */
	unsigned char power_down;
};

/* Divider values for controlling CLKDIV_CTRL register */
struct cs4224_rules_div_config_t {
	/* Enable the manual CLKDIV_CTRL register updates */
	unsigned char enable;

	/* The SRX_RDIV_SEL divider */
	unsigned short rdiv;

	/* The SRX_DDIV_SEL divider */
	unsigned short ddiv;

	/* The SRX_FASTDIV_SEL divider */
	unsigned short fastdiv;
};

/*
 * This structure is used to manage callback functions
 * required during the initialization process.
 */
struct cs4224_callback_t {
	/* Pointer to user data passed back to the callback */
	void *user_data;

	/* Pointer to the callback method */
	void *fcn_ptr;
};

/* KR-AN specific rules */
struct cs4224_rules_kran_t {
	/* The advertised supported datarates,
	 * see enum e_cs4224_kran_data_rates_t
	 */
	unsigned int data_rates;

	/* FEC ability flag (F0) */
	unsigned char fec_ability_f0;

	/* FEC requested flag (F1) */
	unsigned char fec_requested_f1;

	/* Pause ability flag (C0) */
	unsigned char pause_ability_c0;

	/* Pause ability flag (C1) */
	unsigned char pause_ability_c1;

	/* Remote Fault flag (D13) */
	unsigned char remote_fault_d13;

	/* Training enable flag */
	unsigned char allow_training;

	unsigned char wait_for_an_done;

	/* A callback method */
	struct cs4224_callback_t poll_kran_callback;

	/* Internal advanced settings */
	struct cs4224_kran_advanced_config_t_s advanced;
};

enum e_cs4224_fcan_data_rate_t {
	/* 1 GE */
	CS4224_FCAN_DATA_RATE_1G = 0x1,

	/* 2 GE */
	CS4224_FCAN_DATA_RATE_2G = 0X2,

	/* 4 GE */
	CS4224_FCAN_DATA_RATE_4G = 0x4,

	/* 8 GE */
	CS4224_FCAN_DATA_RATE_8G = 0x8,

	/* 16 GE */
	CS4224_FCAN_DATA_RATE_16G = 0x10,

	/* Disabled - the default value for the negotiated_rate
	 * variable to prevent compilation problems
	 */
	CS4224_FCAN_DATA_RATE_DISABLED = 0,
};

enum e_cs4224_fcan_an_status_t {
	/* FC-AN negotiated a data rate */
	CS4224_FCAN_AN_DONE = 0x1,

	/* FC-AN could not negotiate a data rate */
	CS4224_FCAN_AN_NOT_DONE = 0x2,
};

/* FC-AN VCO mode */
enum e_cs4224_fcan_vco_mode_t {
	/* VCO in PD mode (through-timing) */
	CS4224_FCAN_VCO_PD_MODE = 0,

	/* VCO in PFD mode (local-timing) */
	CS4224_FCAN_VCO_PFD_MODE,
};

/* FC-AN advanced rules for debugging */
struct cs4224_fcan_advanced_t {
	/* Set Main tap to Maximum */
	unsigned char enable_tp_main_tap_to_max;

	/* Turn on adaptive post */
	unsigned char enable_tp_adaptive_post;

	/* Send Preset at the begining of training */
	unsigned char enable_tp_send_preset;

	/* Send Init at the begining of training */
	unsigned char enable_tp_send_init;

	/* Force local_rx_ready initial condition */
	unsigned char enable_tp_frc_lcl_rx_ready;

	/* lp_status inital condition */
	unsigned char enable_tp_lp_status;

	/* Send hold inital condition */
	unsigned char enable_tp_send_hold;

	/* SWC in limits initial condition */
	unsigned char enable_tp_swc_in_limits;

	/* Jump to cal.asm during train_taps if LOL */
	unsigned char enable_jmp_to_caldotasm;

	/* Disable FCAN power-savings */
	unsigned char disable_fc_power_savings;

	/* When disabled, PCS sync not monitored on line side, testing only */
	unsigned char disable_pcs_checks;

	/* Enable training to work in the lab with no loss cables */
	unsigned char enable_no_loss;

	/* Start AN immediately after pre-AN config, default is TRUE */
	unsigned char start_an;
};

/* FC-AN specific rules */
struct cs4224_rules_fcan_t {
	unsigned short data_rates;
	struct cs4224_callback_t poll_fcan_callback;
	unsigned char wait_for_an_done;
	enum e_cs4224_fcan_data_rate_t negotiated_rate;
	unsigned char speed_negotiation_support;
	unsigned char training_protocol_support;
	unsigned char fec_capable;
	unsigned char fec_request;
	unsigned char transmitter_fixed;
	struct cs4224_fcan_advanced_t advanced;
};

/*
 * This structure defines the rules used to initialize the
 * device. These rules serve as the high-level configuration
 * switches that a user can adjust to control the behavior
 * of the device(s).
 */
struct cs4224_rules_t {
	enum e_cs4224_target_application application;
	struct cs4224_rules_rx_if_t rx_if;
	struct cs4224_rules_tx_if_t tx_if;
	struct cs4224_rules_fcan_t fcan;
	struct cs4224_rules_kran_t kran;
	int ref_clk_rate;
	struct cs4224_rules_div_config_t clkdiv;
	struct cs4224_rules_fracdiv_config_t fracdiv;
	struct cs4224_rules_synce_config_t synce;
	unsigned char unsquelch_driver;
	unsigned char tx_auto_squelch;
	unsigned char enable_ac_decoupling_caps;
	unsigned char show_debug_info;
	unsigned char enable_power_savings;
	unsigned char enable_fec;
	enum e_cs4224_polarity_inv_t polarity_inv;
	unsigned char enable_die_broadcast;
	struct cs4224_advanced_rules_t advanced;
	unsigned char mseq_dyn_reconfig;
};

/* VCO lock status */
struct cs4224_vco_lock_status_t {
	unsigned char rx_line_lock;
	unsigned char rx_host_lock;
};

/* Struct to define a interface, used for methods that operate on multiple
 * interfaces at a time (cs4224_wait_for_links_ready, etc)
 */
struct cs4224_interface_t {
	unsigned int slice;
	enum e_cs4224_mseq_id mseq_id;
};

typedef int(*cs4224_callback_lock)(unsigned int slice);
typedef int(*cs4224_callback_unlock)(unsigned int slice);

/* Callback methods for implementing h/w locking */
void cs4224_set_callback_for_lock(cs4224_callback_lock callback);
void cs4224_set_callback_for_unlock(cs4224_callback_unlock callback);

void cs4224_reset_static_state(void);
void cs4224_reset_die_static_state(unsigned int die);

unsigned int cs4224_get_die_from_slice(
		unsigned int slice);

int cs4224_reg_get_channel(
		unsigned int slice,
		unsigned int addr,
		unsigned short *data);

unsigned short cs4224_reg_read(
		unsigned int slice,
		unsigned int addr);

int cs4224_reg_set_channel(
		unsigned int channel,
		unsigned int addr,
		unsigned short data);

int cs4224_reg_set_chk_channel(
		unsigned int channel,
		unsigned int addr,
		unsigned short data);

int cs4224_reg_get(
		unsigned int  die,
		unsigned int  addr,
		unsigned short *data);

int cs4224_reg_set(
		unsigned int die,
		unsigned int addr,
		unsigned short data);

int cs4224_lock(
		unsigned int slice);

int cs4224_unlock(
		unsigned int slice);

enum e_cs4224_hardware_id cs4224_hw_id(
		unsigned int slice);

unsigned char cs4224_is_hw_simplex(unsigned int slice);
unsigned char cs4224_is_hw_duplex(unsigned int slice);

int cs4224_mon_volt_read_fixp(
		unsigned int				slice,
		enum e_cs4224_mon_vlt_supply volt_source,
		unsigned int *voltage);

unsigned int cs4224_adj_pp(
		unsigned int slice,
		unsigned short addr);

int cs4224_init_global_timer_fixp(
		unsigned int slice,
		unsigned int ref_clk_freq);

unsigned int cs4224_adj_mseq(
		unsigned int slice,
		unsigned short addr);

int cs4224_simplex_mate_slice(
		unsigned int slice,
		unsigned int *mate);

unsigned char cs4224_line_rx_to_host_tx_dir(
		unsigned int slice);

int cs4224_version(
		char *buffer,
		unsigned int buffer_len);

int cs4224_resync_elsto(
		unsigned int slice,
		unsigned short elsto_reg);

int cs4224_init_vco(
		unsigned int slice,
		unsigned int addr);

int cs4224_slice_change_rate_intf(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t intf,
		struct cs4224_rules_t *rules);

int cs4224_rules_set_default(
		enum e_cs4224_target_application application,
		struct cs4224_rules_t *rules);

int cs4224_slice_enter_operational_state(
		unsigned int slice,
		struct cs4224_rules_t *rules);

int cs4224_get_mseq_id(
		unsigned int slice,
		enum e_cs4224_mseq_id *mseq_id);

unsigned int cs4224_mseq_get_addr_offset(
		unsigned int slice,
		enum e_cs4224_mseq_id mseq);

int cs4224_get_cfg_side(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t *side);

void cs4224_mseq_stall_set_delay(int us);
int cs4224_mseq_stall_get_delay(void);

int cs4224_mseq_stall(
		unsigned int slice,
		enum e_cs4224_mseq_id  mseq_id,
		unsigned char  stall);

int cs4224_mseqs_stall(
		struct cs4224_interface_t interfaces[],
		unsigned short length,
		unsigned char stall);

int cs4224_mseq_enable_power_savings(
		unsigned int		  slice,
		enum e_cs4224_mseq_id  mseq_id,
		unsigned char		  enable);

int cs4224_init_driver_settings(
		unsigned int slice,
		enum e_cs4224_tx_driver_interface intf,
		unsigned short ctrla,
		unsigned short ctrlb);

int cs4224_config_polarity_inv_points(
		unsigned int slice,
		unsigned short inv_points);

int cs4224_enable_polarity_inv(
		unsigned int slice,
		struct cs4224_rules_t *rules);

int cs4224_query_polarity_inv(
		unsigned int slice,
		unsigned short *inv_points);

int cs4224_debug_dump_polarity_inv(
		unsigned int slice);

void cs4224_pp_clk_mon_cfg_init(
		struct cs4224_pp_clk_mon_cfg_t *clk_mon_cfg);

int cs4224_pp_clock_monitor(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t side,
		struct cs4224_pp_clk_mon_cfg_t *clk_mon_cfg);

int cs4224_pp_clock_monitor_freq_fixp(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t side,
		struct cs4224_pp_clk_mon_cfg_t *pp_clk_mon_cfg,
		unsigned int ref_clk_rate,
		unsigned short *freq);

int cs4224_gbl_clock_monitor(
		unsigned int slice,
		struct cs4224_gbl_clk_mon_cfg_t *clk_mon_cfg);

int cs4224_fracdiv_core_init(
		unsigned int slice,
		enum e_cs4224_datapath_dir_t dir,
		unsigned short divisor,
		unsigned int numerator);

int cs4224_fracdiv_cdr_init(
		unsigned int slice,
		enum e_cs4224_datapath_dir_t dir,
		unsigned short divisor,
		unsigned int numerator);

int cs4224_slice_soft_reset(
		unsigned int slice);

int cs4224_slice_soft_reset_intf(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t intf);

int cs4224_mseq_squelch_ctrl(
		unsigned int slice,
		enum e_cs4224_datapath_dir_t dir,
		unsigned char enable);

int cs4224_send_squelch_request(
		unsigned int slice,
		enum e_cs4224_datapath_dir_t dir,
		unsigned char squelch);

int cs4224_squelch_driver(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t side,
		unsigned char squelch);

int cs4224_hard_reset_die(unsigned int die);
int cs4224_hard_reset(unsigned int slice);

void cs4224_debug_ucode_show_version(unsigned int slice);

int cs4224_mux_enable(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t side,
		unsigned char enable);

int cs4224_demux_enable(
		unsigned int slice,
		enum e_cs4224_cfg_sides_t side,
		unsigned char enable);

int cs4224_init_edc_mode_set(
		unsigned int slice,
		struct cs4224_rules_t *rules);

int cs4224_init_edc_mode_intf(
		unsigned int slice,
		struct cs4224_rules_t *rules,
		enum e_cs4224_mseq_id intf);

unsigned char cs4224_is_eeprom_finished(unsigned int die);

int cs4224_wait_for_eeprom_finished(
		unsigned int die,
		unsigned int max_iterations,
		unsigned int ms_delay_between_iterations);

int cs4224_restore_powered_down_regs(unsigned int slice);

int cs4224_slice_power_down(
		unsigned int slice);

int cs4224_save_edc_mode(
		unsigned int slice,
		unsigned short reg_offset,
		enum e_cs4224_edc_mode  edc_mode);

int cs4224_query_edc_mode(
		unsigned int slice,
		enum e_cs4224_mseq_id mseq_id,
		enum e_cs4224_edc_mode *edc_mode);

int cs4224_query_mseq_is_stalled(
		unsigned int slice,
		enum e_cs4224_mseq_id mseq_id,
		unsigned char *stalled);

int cs4224_query_mseq_power_savings(
		unsigned int slice,
		enum e_cs4224_mseq_id mseq_id,
		unsigned char *enabled);

const char *cs4224_translate_edc_mode(enum e_cs4224_edc_mode edc_mode);
const char *cs4224_translate_app_mode(
				enum e_cs4224_target_application app_mode);
const char *cs4224_switch_translate_state(
				enum e_cs4224_switch_action_t state);
const char *cs4224_translate_cfg_side(enum e_cs4224_cfg_sides_t side);
int cs4224_check_rules(unsigned int slice, struct cs4224_rules_t *rules);
unsigned int cs4224_query_data_rate(const struct cs4224_rules_t *rules);

int cs4224_ucode_data_prgm_image(
		unsigned int slice,
		unsigned short microcode[],
		unsigned int len_buffer);

int cs4224_ucode_data_prgm_image_broadcast(
		unsigned int slice,
		unsigned short microcode[],
		unsigned int len_buffer);

void cs4223_glue_phydev_set(struct phy_device *phydev);

#endif /* __CORTINA_API_H_ */
