// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2014      Panasonic Corporation
 * Copyright (C) 2015-2016 Socionext Inc.
 *   Author: Masahiro Yamada <yamada.masahiro@socionext.com>
 */

#include <dm/device_compat.h>
#include <linux/delay.h>
#include <linux/errno.h>
#include <linux/io.h>
#include <linux/sizes.h>
#include <linux/types.h>
#include <dm.h>
#include <fdtdec.h>
#include <i2c.h>
#include <common.h>
#include <asm/gpio.h>
#include <linux/err.h>
#include <linux/delay.h>

struct sgm37604a_i2c_priv {
	struct udevice *dev;
	struct gpio_desc bl_en;
	unsigned long input_clk;	/* master clock (Hz) */
	unsigned long wait_us;		/* wait for every byte transfer (us) */
	
};

static int sgm37604a_i2c_probe(struct udevice *dev)
{
	fdt_addr_t addr;
	int ret;
	int node;
	struct sgm37604a_i2c_priv *priv = dev_get_priv(dev);

	printf("%s: start!\n", __func__);
	addr = dev_read_addr(dev);
	if (addr == FDT_ADDR_T_NONE)
		return -EINVAL;
	priv->dev = dev;

	node = fdt_node_offset_by_compatible(gd->fdt_blob, 0, "qcom,sgm37604a");  
	if (node < 0) {
		return -EINVAL;
	}
	gpio_request_by_name_nodev(offset_to_ofnode(node), "lcm-bl-en-gpio", 0, &priv->bl_en, GPIOD_IS_OUT);
	if (dm_gpio_is_valid(&priv->bl_en)) {
		ret = dm_gpio_set_value(&priv->bl_en, 1);
		if (ret)
			printf("bl_en gpio fails to set true\n");
	}

	ret = dm_i2c_reg_write(dev, 0x11, 0x00);
	if(ret < 0) {
		printf("%s: Error writing data to I2C device.\n", __func__);
	}

	ret = dm_i2c_reg_write(dev, 0x1A, 4095 & 0x0F);
	if(ret < 0) {
		printf("%s: Error writing data to I2C device.\n", __func__);
	}

	ret = dm_i2c_reg_write(dev, 0x19, 4095 >> 4);
	if(ret < 0) {
		printf("%s: Error writing data to I2C device.\n", __func__);
	}

	return 0;
}

static const struct udevice_id sgm37604a_i2c_ids[] = {
	{ .compatible = "qcom,sgm37604a" },
	{ /* sentinel */ }
};

U_BOOT_DRIVER(sgm37604a_backlight) = {
	.name = "sgm37604a-i2c",
	.id = UCLASS_I2C,
	.of_match = sgm37604a_i2c_ids,
	.probe = sgm37604a_i2c_probe,
	.priv_auto	= sizeof(struct sgm37604a_i2c_priv),
};
