// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright (C) 2014      Panasonic Corporation
 * Copyright (C) 2015-2016 Socionext Inc.
 *   Author: Masahiro Yamada <yamada.masahiro@socionext.com>
 */

#include <dm/device_compat.h>
#include <linux/delay.h>
#include <linux/errno.h>
#include <linux/io.h>
#include <linux/sizes.h>
#include <linux/types.h>
#include <dm.h>
#include <fdtdec.h>
#include <i2c.h>
#include <common.h>
#include <asm/gpio.h>
#include <linux/err.h>
#include <linux/delay.h>

#define OCP2131_Positive_Output				0X00
#define OCP2131_Negative_Output				0X01
#define OCP2131_Set_voltage					0x14
#define OCP2131_Set_vsp_vsn_enable			0x03
#define OCP2131_Set_value					0x03
#define OCP2131_Mtp_Reg						0xFF
#define OCP2131_Mtp_save					0x80

#define LCD_BIAS_POSCNTL_REG				0x00
#define LCD_BIAS_NEGCNTL_REG				0x01
#define LCD_BIAS_CONTROL_REG				0x03
#define OCP2312_chip_id						0x04

struct lcd_i2c_bias_priv {
	struct udevice *dev;
	struct gpio_desc enp_gpio;
	struct gpio_desc enn_gpio;
	int select_bias_flag;
	
};

enum {
	ocp2131_bias = 0,
	sm5109c_bias,
};

static void lcd_bias_set_vpn(struct udevice *dev, unsigned int select)
{
	int level = 6000;
	int ret =0;

	printf("%s:lcd_bias_set_vpn\n", __func__);

	if (select == sm5109c_bias) {
		printf("%s:devices is sm5109c_bias\n", __func__);
		level = (level - 4000) / 100; 
		printf("%s:sm5109c_bias  level= %d\n", __func__,level);
		ret = dm_i2c_reg_write(dev, LCD_BIAS_POSCNTL_REG, (u8)level);
		if(ret < 0) {
			printf("%s: Error writing data to I2C device.\n", __func__);
		} else {
			printf("%s: Data written successfully to I2C device.\n", __func__);
		}
		mdelay(5);
		ret = dm_i2c_reg_write(dev, LCD_BIAS_NEGCNTL_REG, (u8)level);
		if(ret < 0) {
			printf("%s: Error writing data to I2C device.\n", __func__);
		} else {
			printf("%s: Data written successfully to I2C device.\n", __func__);
		}

	} else if (select == ocp2131_bias) {
		dm_i2c_reg_write(dev, OCP2131_Positive_Output, OCP2131_Set_voltage);
		if(ret < 0) {
			printf("%s: Error writing data to I2C device.\n", __func__);
		} else {
			printf("%s: Data written successfully to I2C device.\n", __func__);
		}

		dm_i2c_reg_write(dev, OCP2131_Negative_Output, OCP2131_Set_voltage);
		if(ret < 0) {
			printf("%s: Error writing data to I2C device.\n", __func__);
		} else {
			printf("%s: Data written successfully to I2C device.\n", __func__);
		}

		dm_i2c_reg_write(dev, OCP2131_Set_vsp_vsn_enable, OCP2131_Set_value);
		if(ret < 0) {
			printf("%s: Error writing data to I2C device.\n", __func__);
		} else {
			printf("%s: Data written successfully to I2C device.\n", __func__);
		}

	}
	
}


static int lcd_i2c_bias_probe(struct udevice *dev)
{
	unsigned char chip_id;
	unsigned char ocp2132_id = 0x0D;
	int ret;
	int value;
	int  node;

	printf("%s: start!\n", __func__);
	struct lcd_i2c_bias_priv *priv = dev_get_priv(dev);
	priv->dev = dev;

	node = fdt_node_offset_by_compatible(gd->fdt_blob, 0, "qualcomm,i2c_lcd_bias");  
	if (node < 0) {
		printf("===========================Don't find dm-gpio,test node\n");
		return -1; 
	} 
	gpio_request_by_name_nodev(offset_to_ofnode(node), "qualcomm,enp", 0, &priv->enp_gpio, GPIOD_IS_OUT);
	if (dm_gpio_is_valid(&priv->enp_gpio)) {
		value =  dm_gpio_get_value(&priv->enp_gpio);
		ret = dm_gpio_set_value(&priv->enp_gpio, 1);
		if (ret)
			printf("bl_en gpio fails to set true\n");
		value =  dm_gpio_get_value(&priv->enp_gpio);
		printf("2 enp_gpio gpio value is %d\n", value);
	}
	gpio_request_by_name_nodev(offset_to_ofnode(node), "qualcomm,enn", 0, &priv->enn_gpio, GPIOD_IS_OUT);
	if (dm_gpio_is_valid(&priv->enn_gpio)) {
		value =  dm_gpio_get_value(&priv->enn_gpio);
		ret = dm_gpio_set_value(&priv->enn_gpio, 1);
		if (ret)
			printf("bl_en gpio fails to set true\n");
		value =  dm_gpio_get_value(&priv->enp_gpio);
		printf("2 enp_gpio gpio value is %d\n", value);
	}

	chip_id = dm_i2c_reg_read(dev, 0x04);
	if (chip_id == ocp2132_id) {
		priv->select_bias_flag = ocp2131_bias;
		printf("%s: is ocp2131 bias,chip_id = %02x\n", __func__, chip_id);
	} else {
		priv->select_bias_flag = sm5109c_bias;
		printf("%s: is sm5109c bias\n", __func__);
	}

	
	lcd_bias_set_vpn(priv->dev, priv->select_bias_flag);

	return 0;
}


static const struct udevice_id lcd_bias_ids[] = {
	{ .compatible = "qualcomm,i2c_lcd_bias" },
	{ /* sentinel */ }
};

U_BOOT_DRIVER(lcd_i2c_bias) = {
	.name = "lcd_i2c_bias",
	.id = UCLASS_I2C,
	.of_match = lcd_bias_ids,
	.probe = lcd_i2c_bias_probe,
	.priv_auto	= sizeof(struct lcd_i2c_bias_priv),
};
