// SPDX-License-Identifier: GPL-2.0+
/*
 * Copyright 2023 NXP
 */
#include <linux/errno.h>
#include <linux/kernel.h>
#include <asm/arch/ddr.h>
#include <u-boot/crc.h>

static const uint32_t ddrphy_csr_cfg[DDRPHY_QB_CSR_SIZE] = {
	0x00090201,
	0x00090202,
	0x00090203,
	0x00090204,
	0x00090205,
	0x00090206,
	0x00090207,
	0x00090208,
	0x00190201,
	0x00190202,
	0x00190203,
	0x00190204,
	0x00190205,
	0x00190206,
	0x00190207,
	0x00190208,
	0x00290201,
	0x00290202,
	0x00290203,
	0x00290204,
	0x00290205,
	0x00290206,
	0x00290207,
	0x00290208,
	0x00390201,
	0x00390202,
	0x00390203,
	0x00390204,
	0x00390205,
	0x00390206,
	0x00390207,
	0x00390208,
	0x00090000,
	0x00090001,
	0x00090002,
	0x00090003,
	0x00090004,
	0x00090005,
	0x00090006,
	0x00090007,
	0x00090008,
	0x00090009,
	0x0009000a,
	0x0009000b,
	0x0009000c,
	0x0009000d,
	0x0009000e,
	0x0009000f,
	0x00090010,
	0x00090011,
	0x00090012,
	0x00090013,
	0x00090014,
	0x00090015,
	0x00090016,
	0x00090017,
	0x00090018,
	0x00090019,
	0x0009001a,
	0x0009001b,
	0x0009001c,
	0x0009001d,
	0x0009001e,
	0x0009001f,
	0x00090020,
	0x00090021,
	0x00090022,
	0x00090023,
	0x00090024,
	0x00090025,
	0x00090026,
	0x00090027,
	0x00090028,
	0x00090029,
	0x0009002a,
	0x0009002b,
	0x0009002c,
	0x0009002d,
	0x0009002e,
	0x0009002f,
	0x00090030,
	0x00090031,
	0x00090032,
	0x00090033,
	0x00090034,
	0x00090035,
	0x00090036,
	0x00090037,
	0x00090038,
	0x00090039,
	0x0009003a,
	0x0009003b,
	0x0009003c,
	0x0009003d,
	0x0009003e,
	0x0009003f,
	0x00090040,
	0x00090041,
	0x00090042,
	0x00090043,
	0x00090044,
	0x00090045,
	0x00090046,
	0x00090047,
	0x00090048,
	0x00090049,
	0x0009004a,
	0x0009004b,
	0x0009004c,
	0x0009004d,
	0x0009004e,
	0x0009004f,
	0x00090050,
	0x00090051,
	0x00090052,
	0x00090053,
	0x00090054,
	0x00090055,
	0x00090056,
	0x00090057,
	0x00090058,
	0x00090059,
	0x0009005a,
	0x0009005b,
	0x0009005c,
	0x0009005d,
	0x0009005e,
	0x0009005f,
	0x00090060,
	0x00090061,
	0x00090062,
	0x00090063,
	0x00090064,
	0x00090065,
	0x00090066,
	0x00090067,
	0x00090068,
	0x00090069,
	0x0009006a,
	0x0009006b,
	0x0009006c,
	0x0009006d,
	0x0009006e,
	0x0009006f,
	0x00090070,
	0x00090071,
	0x00090072,
	0x00090073,
	0x00090074,
	0x00090075,
	0x00090076,
	0x00090077,
	0x00090078,
	0x00090079,
	0x0009007a,
	0x0009007b,
	0x0009007c,
	0x0009007d,
	0x0009007e,
	0x0009007f,
	0x00090080,
	0x00090081,
	0x00090082,
	0x00090083,
	0x00090084,
	0x00090085,
	0x00090086,
	0x00090087,
	0x00090088,
	0x00090089,
	0x0009008a,
	0x0009008b,
	0x0009008c,
	0x0009008d,
	0x0009008e,
	0x0009008f,
	0x00090090,
	0x00090091,
	0x00090092,
	0x00090093,
	0x00090094,
	0x00090095,
	0x00090096,
	0x00090097,
	0x00090098,
	0x00090099,
	0x0009009a,
	0x0009009b,
	0x0009009c,
	0x0009009d,
	0x0009009e,
	0x0009009f,
	0x000900a0,
	0x000900a1,
	0x000900a2,
	0x000900a3,
	0x000900a4,
	0x000900a5,
	0x000900a6,
	0x000900a7,
	0x000900a8,
	0x000900a9,
	0x000900aa,
	0x000900ab,
	0x000900ac,
	0x000900ad,
	0x000900ae,
	0x000900af,
	0x000900b0,
	0x000900b1,
	0x000900b2,
	0x000900b3,
	0x000900b4,
	0x000900b5,
	0x000900b6,
	0x000900b7,
	0x000900b8,
	0x000900b9,
	0x000900ba,
	0x000900bb,
	0x000900bc,
	0x000900bd,
	0x000900be,
	0x000900bf,
	0x000900c0,
	0x000900c1,
	0x000900c2,
	0x000900c3,
	0x000900c4,
	0x000900c5,
	0x000900c6,
	0x000900c7,
	0x000900c8,
	0x000900c9,
	0x000900ca,
	0x000900cb,
	0x000900cc,
	0x000900cd,
	0x000900ce,
	0x000900cf,
	0x000900d0,
	0x000900d1,
	0x000900d2,
	0x000900d3,
	0x000900d4,
	0x000900d5,
	0x000900d6,
	0x000900d7,
	0x000900d8,
	0x000900d9,
	0x000900da,
	0x000900db,
	0x000900dc,
	0x000900dd,
	0x000900de,
	0x000900df,
	0x000900e0,
	0x000900e1,
	0x000900e2,
	0x000900e3,
	0x000900e4,
	0x000900e5,
	0x000900e6,
	0x000900e7,
	0x000900e8,
	0x000900e9,
	0x000900ea,
	0x000900eb,
	0x000900ec,
	0x000900ed,
	0x000900ee,
	0x000900ef,
	0x000900f0,
	0x000900f1,
	0x000900f2,
	0x000900f3,
	0x000900f4,
	0x000900f5,
	0x000900f6,
	0x000900f7,
	0x000900f8,
	0x000900f9,
	0x000900fa,
	0x000900fb,
	0x000900fc,
	0x000900fd,
	0x000900fe,
	0x000900ff,
	0x00090100,
	0x00090101,
	0x00090102,
	0x00090103,
	0x00090104,
	0x00090105,
	0x00090106,
	0x00090107,
	0x00090108,
	0x00090109,
	0x0009010a,
	0x0009010b,
	0x0009010c,
	0x0009010d,
	0x0009010e,
	0x0009010f,
	0x00090110,
	0x00090111,
	0x00090112,
	0x00090113,
	0x00090114,
	0x00090115,
	0x00090116,
	0x00090117,
	0x00090118,
	0x00090119,
	0x0009011a,
	0x0009011b,
	0x0009011c,
	0x0009011d,
	0x0009011e,
	0x0009011f,
	0x00090120,
	0x00090121,
	0x00090122,
	0x00090123,
	0x00090124,
	0x00090125,
	0x00090126,
	0x00090127,
	0x00090128,
	0x00090129,
	0x0009012a,
	0x0009012b,
	0x0009012c,
	0x0009012d,
	0x0009012e,
	0x0009012f,
	0x00090130,
	0x00090131,
	0x00090132,
	0x00090133,
	0x00090134,
	0x00090135,
	0x00090136,
	0x00090137,
	0x00090138,
	0x00090139,
	0x0009013a,
	0x0009013b,
	0x0009013c,
	0x0009013d,
	0x0009013e,
	0x0009013f,
	0x00090140,
	0x00090141,
	0x00090142,
	0x00090143,
	0x00090144,
	0x00090145,
	0x00090146,
	0x00090147,
	0x00090148,
	0x00090149,
	0x0009014a,
	0x0009014b,
	0x0009014c,
	0x0009014d,
	0x0009014e,
	0x0009014f,
	0x00090150,
	0x00090151,
	0x00090152,
	0x00090153,
	0x00090154,
	0x00090155,
	0x00090156,
	0x00090157,
	0x00090158,
	0x00090159,
	0x0009015a,
	0x0009015b,
	0x0009015c,
	0x0009015d,
	0x0009015e,
	0x0009015f,
	0x00090160,
	0x00090161,
	0x00090162,
	0x00090163,
	0x00090164,
	0x00090165,
	0x00090166,
	0x00090167,
	0x00090168,
	0x00090169,
	0x0009016a,
	0x0009016b,
	0x0009016c,
	0x0009016d,
	0x0009016e,
	0x0009016f,
	0x00090170,
	0x00090171,
	0x00090172,
	0x00090173,
	0x00090174,
	0x00090175,
	0x00090176,
	0x00090177,
	0x00090178,
	0x00090179,
	0x0009017a,
	0x0009017b,
	0x0009017c,
	0x0009017d,
	0x0009017e,
	0x0009017f,
	0x00090180,
	0x00090181,
	0x00090182,
	0x00090183,
	0x00090184,
	0x00090185,
	0x00090186,
	0x00090187,
	0x00090188,
	0x00090189,
	0x0009018a,
	0x0009018b,
	0x0009018c,
	0x0009018d,
	0x0009018e,
	0x0009018f,
	0x00090190,
	0x00090191,
	0x00090192,
	0x00090193,
	0x00090194,
	0x00090195,
	0x00090196,
	0x00090197,
	0x00090198,
	0x00090199,
	0x0009019a,
	0x0009019b,
	0x000902ff,
	0x00040080,
	0x00040081,
	0x00040082,
	0x00040083,
	0x00040084,
	0x00040085,
	0x00040086,
	0x00040087,
	0x00040088,
	0x00040089,
	0x0004008a,
	0x0004008b,
	0x0004008c,
	0x0004008d,
	0x0004008e,
	0x0004008f,
	0x00140080,
	0x00140081,
	0x00140082,
	0x00140083,
	0x00140084,
	0x00140085,
	0x00140086,
	0x00140087,
	0x00140088,
	0x00140089,
	0x0014008a,
	0x0014008b,
	0x0014008c,
	0x0014008d,
	0x0014008e,
	0x0014008f,
	0x00240080,
	0x00240081,
	0x00240082,
	0x00240083,
	0x00240084,
	0x00240085,
	0x00240086,
	0x00240087,
	0x00240088,
	0x00240089,
	0x0024008a,
	0x0024008b,
	0x0024008c,
	0x0024008d,
	0x0024008e,
	0x0024008f,
	0x00340080,
	0x00340081,
	0x00340082,
	0x00340083,
	0x00340084,
	0x00340085,
	0x00340086,
	0x00340087,
	0x00340088,
	0x00340089,
	0x0034008a,
	0x0034008b,
	0x0034008c,
	0x0034008d,
	0x0034008e,
	0x0034008f,
	0x00040000,
	0x00040001,
	0x00040002,
	0x00040003,
	0x00040004,
	0x00040005,
	0x00040006,
	0x00040007,
	0x00040008,
	0x00040009,
	0x0004000a,
	0x0004000b,
	0x0004000c,
	0x0004000d,
	0x0004000e,
	0x0004000f,
	0x00040010,
	0x00040011,
	0x00040012,
	0x00040013,
	0x00040014,
	0x00040015,
	0x00040016,
	0x00040017,
	0x00040018,
	0x00040019,
	0x0004001a,
	0x0004001b,
	0x0004001c,
	0x0004001d,
	0x0004001e,
	0x0004001f,
	0x00040020,
	0x00040021,
	0x00040022,
	0x00040023,
	0x00040024,
	0x00040025,
	0x00040026,
	0x00040027,
	0x00040028,
	0x00040029,
	0x0004002a,
	0x0004002b,
	0x0004002c,
	0x0004002d,
	0x0004002e,
	0x0004002f,
	0x00040030,
	0x00040031,
	0x00040032,
	0x00040033,
	0x00040034,
	0x00040035,
	0x00040036,
	0x00040037,
	0x00040038,
	0x00040039,
	0x0004003a,
	0x0004003b,
	0x0004003c,
	0x0004003d,
	0x0004003e,
	0x0004003f,
	0x00040040,
	0x00040041,
	0x00040042,
	0x00040043,
	0x00040044,
	0x00040045,
	0x00040046,
	0x00040047,
	0x00040048,
	0x00040049,
	0x0004004a,
	0x0004004b,
	0x0004004c,
	0x0004004d,
	0x0004004e,
	0x0004004f,
	0x00040050,
	0x00040051,
	0x00040052,
	0x00040053,
	0x00040054,
	0x00040055,
	0x00040056,
	0x00040057,
	0x00040058,
	0x00040059,
	0x0004005a,
	0x0004005b,
	0x0004005c,
	0x0004005d,
	0x0004005e,
	0x0004005f,
	0x00040060,
	0x00040061,
	0x00040062,
	0x00040063,
	0x00040064,
	0x00040065,
	0x00040066,
	0x00040067,
	0x00040068,
	0x00040069,
	0x0004006a,
	0x0004006b,
	0x0004006c,
	0x0004006d,
	0x0004006e,
	0x0004006f,
	0x00040070,
	0x00040071,
	0x00040072,
	0x00040073,
	0x00040074,
	0x00040075,
	0x00040076,
	0x00040077,
	0x00040078,
	0x00040079,
	0x0004007a,
	0x0004007b,
	0x0004007c,
	0x0004007d,
	0x0004007e,
	0x0004007f,
	0x00040080,
	0x00040081,
	0x00040082,
	0x00040083,
	0x00040084,
	0x00040085,
	0x00040086,
	0x00040087,
	0x00040088,
	0x00040089,
	0x0004008a,
	0x0004008b,
	0x0004008c,
	0x0004008d,
	0x0004008e,
	0x0004008f,
	0x00040090,
	0x00040091,
	0x00040092,
	0x00040093,
	0x00040094,
	0x00040095,
	0x00040096,
	0x00040097,
	0x00040098,
	0x00040099,
	0x0004009a,
	0x0004009b,
	0x0004009c,
	0x0004009d,
	0x0004009e,
	0x0004009f,
	0x000400a0,
	0x000400a1,
	0x000400a2,
	0x000400a3,
	0x000400a4,
	0x000400a5,
	0x000400a6,
	0x000400a7,
	0x000400a8,
	0x000400a9,
	0x000400aa,
	0x000400ab,
	0x000400ac,
	0x000400ad,
	0x000400ae,
	0x000400af,
	0x000400b0,
	0x000400b1,
	0x000400b2,
	0x000400b3,
	0x000400b4,
	0x000400b5,
	0x000400b6,
	0x000400b7,
	0x000400b8,
	0x000400b9,
	0x000400ba,
	0x000400bb,
	0x000400bc,
	0x000400bd,
	0x000400be,
	0x000400bf,
	0x000400c0,
	0x000400c1,
	0x000400c2,
	0x000400c3,
	0x000400c4,
	0x000400c5,
	0x000400c6,
	0x000400c7,
	0x000400c8,
	0x000400c9,
	0x000400ca,
	0x000400cb,
	0x000400cc,
	0x000400cd,
	0x000400ce,
	0x000400cf,
	0x000400d0,
	0x000400d1,
	0x000400d2,
	0x000400d3,
	0x000400d4,
	0x000400d5,
	0x000400d6,
	0x000400d7,
	0x000400d8,
	0x000400d9,
	0x000400da,
	0x000400db,
	0x000400dc,
	0x000400dd,
	0x000400de,
	0x000400df,
	0x000400e0,
	0x000400e1,
	0x000400e2,
	0x000400e3,
	0x000400e4,
	0x000400e5,
	0x000400e6,
	0x000400e7,
	0x000400e8,
	0x000400e9,
	0x000400ea,
	0x000400eb,
	0x000400ec,
	0x000400ed,
	0x000400ee,
	0x000400ef,
	0x000400f0,
	0x000400f1,
	0x000400f2,
	0x000400f3,
	0x000400f4,
	0x000400f5,
	0x000400f6,
	0x000400f7,
	0x000400f8,
	0x000400f9,
	0x000400fa,
	0x000400fb,
	0x000400fc,
	0x000400fd,
	0x000400fe,
	0x000400ff,
	0x000100b2,
	0x000100b4,
	0x000101b2,
	0x000101b4,
	0x000102b2,
	0x000102b4,
	0x000103b2,
	0x000103b4,
	0x000104b2,
	0x000104b4,
	0x000105b2,
	0x000105b4,
	0x000106b2,
	0x000106b4,
	0x000107b2,
	0x000107b4,
	0x000108b2,
	0x000108b4,
	0x00010011,
	0x00010012,
	0x00010013,
	0x00010018,
	0x00010002,
	0x000110b2,
	0x000110b4,
	0x000111b2,
	0x000111b4,
	0x000112b2,
	0x000112b4,
	0x000113b2,
	0x000113b4,
	0x000114b2,
	0x000114b4,
	0x000115b2,
	0x000115b4,
	0x000116b2,
	0x000116b4,
	0x000117b2,
	0x000117b4,
	0x000118b2,
	0x000118b4,
	0x00011011,
	0x00011012,
	0x00011013,
	0x00011018,
	0x00011002,
	0x000120b2,
	0x000120b4,
	0x000121b2,
	0x000121b4,
	0x000122b2,
	0x000122b4,
	0x000123b2,
	0x000123b4,
	0x000124b2,
	0x000124b4,
	0x000125b2,
	0x000125b4,
	0x000126b2,
	0x000126b4,
	0x000127b2,
	0x000127b4,
	0x000128b2,
	0x000128b4,
	0x00012011,
	0x00012012,
	0x00012013,
	0x00012018,
	0x00012002,
	0x000130b2,
	0x000130b4,
	0x000131b2,
	0x000131b4,
	0x000132b2,
	0x000132b4,
	0x000133b2,
	0x000133b4,
	0x000134b2,
	0x000134b4,
	0x000135b2,
	0x000135b4,
	0x000136b2,
	0x000136b4,
	0x000137b2,
	0x000137b4,
	0x000138b2,
	0x000138b4,
	0x00013011,
	0x00013012,
	0x00013013,
	0x00013018,
	0x00013002,
	0x000140b2,
	0x000140b4,
	0x000141b2,
	0x000141b4,
	0x000142b2,
	0x000142b4,
	0x000143b2,
	0x000143b4,
	0x000144b2,
	0x000144b4,
	0x000145b2,
	0x000145b4,
	0x000146b2,
	0x000146b4,
	0x000147b2,
	0x000147b4,
	0x000148b2,
	0x000148b4,
	0x00014011,
	0x00014012,
	0x00014013,
	0x00014018,
	0x00014002,
	0x000150b2,
	0x000150b4,
	0x000151b2,
	0x000151b4,
	0x000152b2,
	0x000152b4,
	0x000153b2,
	0x000153b4,
	0x000154b2,
	0x000154b4,
	0x000155b2,
	0x000155b4,
	0x000156b2,
	0x000156b4,
	0x000157b2,
	0x000157b4,
	0x000158b2,
	0x000158b4,
	0x00015011,
	0x00015012,
	0x00015013,
	0x00015018,
	0x00015002,
	0x000160b2,
	0x000160b4,
	0x000161b2,
	0x000161b4,
	0x000162b2,
	0x000162b4,
	0x000163b2,
	0x000163b4,
	0x000164b2,
	0x000164b4,
	0x000165b2,
	0x000165b4,
	0x000166b2,
	0x000166b4,
	0x000167b2,
	0x000167b4,
	0x000168b2,
	0x000168b4,
	0x00016011,
	0x00016012,
	0x00016013,
	0x00016018,
	0x00016002,
	0x000170b2,
	0x000170b4,
	0x000171b2,
	0x000171b4,
	0x000172b2,
	0x000172b4,
	0x000173b2,
	0x000173b4,
	0x000174b2,
	0x000174b4,
	0x000175b2,
	0x000175b4,
	0x000176b2,
	0x000176b4,
	0x000177b2,
	0x000177b4,
	0x000178b2,
	0x000178b4,
	0x00017011,
	0x00017012,
	0x00017013,
	0x00017018,
	0x00017002,
	0x000180b2,
	0x000180b4,
	0x000181b2,
	0x000181b4,
	0x000182b2,
	0x000182b4,
	0x000183b2,
	0x000183b4,
	0x000184b2,
	0x000184b4,
	0x000185b2,
	0x000185b4,
	0x000186b2,
	0x000186b4,
	0x000187b2,
	0x000187b4,
	0x000188b2,
	0x000188b4,
	0x00018011,
	0x00018012,
	0x00018013,
	0x00018018,
	0x00018002,
	0x000190b2,
	0x000190b4,
	0x000191b2,
	0x000191b4,
	0x000192b2,
	0x000192b4,
	0x000193b2,
	0x000193b4,
	0x000194b2,
	0x000194b4,
	0x000195b2,
	0x000195b4,
	0x000196b2,
	0x000196b4,
	0x000197b2,
	0x000197b4,
	0x000198b2,
	0x000198b4,
	0x00019011,
	0x00019012,
	0x00019013,
	0x00019018,
	0x00019002,
	0x00020010,
	0x00020011,
	0x00120010,
	0x00120011,
	0x00220010,
	0x00220011,
	0x00320010,
	0x00320011,
	0x00020088,
	0x000200f0,
	0x000200f1,
	0x000200f2,
	0x000200f3,
	0x000200f4,
	0x000200f5,
	0x000200f6,
	0x000200f7,
	0x0002000b,
	0x0002000c,
	0x0002000d,
	0x0002000e,
	0x0002002e,
	0x00020024,
	0x00020056,
	0x00020008,
	0x0002007c,
	0x000200b2,
	0x000200fa,
	0x00020019,
	0x0002002d,
	0x000200b0,
	0x000200b4,
	0x000200c5,
	0x00020062,
	0x00020063,
	0x00020064,
	0x00020065,
	0x00020066,
	0x00020067,
	0x00020068,
	0x000200f0,
	0x000200f1,
	0x000200f2,
	0x000200f3,
	0x000200f4,
	0x000200f5,
	0x000200f6,
	0x000200f7,
	0x0012000b,
	0x0012000c,
	0x0012000d,
	0x0012000e,
	0x0012002e,
	0x00120024,
	0x00120056,
	0x00120008,
	0x0012007c,
	0x001200b2,
	0x001200fa,
	0x00120019,
	0x0012002d,
	0x001200b0,
	0x001200b4,
	0x001200c5,
	0x00120062,
	0x00120063,
	0x00120064,
	0x00120065,
	0x00120066,
	0x00120067,
	0x00120068,
	0x000200f0,
	0x000200f1,
	0x000200f2,
	0x000200f3,
	0x000200f4,
	0x000200f5,
	0x000200f6,
	0x000200f7,
	0x0022000b,
	0x0022000c,
	0x0022000d,
	0x0022000e,
	0x0022002e,
	0x00220024,
	0x00220056,
	0x00220008,
	0x0022007c,
	0x002200b2,
	0x002200fa,
	0x00220019,
	0x0022002d,
	0x002200b0,
	0x002200b4,
	0x002200c5,
	0x00220062,
	0x00220063,
	0x00220064,
	0x00220065,
	0x00220066,
	0x00220067,
	0x00220068,
	0x000200f0,
	0x000200f1,
	0x000200f2,
	0x000200f3,
	0x000200f4,
	0x000200f5,
	0x000200f6,
	0x000200f7,
	0x0032000b,
	0x0032000c,
	0x0032000d,
	0x0032000e,
	0x0032002e,
	0x00320024,
	0x00320056,
	0x00320008,
	0x0032007c,
	0x003200b2,
	0x003200fa,
	0x00320019,
	0x0032002d,
	0x003200b0,
	0x003200b4,
	0x003200c5,
	0x00320062,
	0x00320063,
	0x00320064,
	0x00320065,
	0x00320066,
	0x00320067,
	0x00320068,
	0x0002003a,
	0x00020018,
	0x00020075,
	0x00020050,
	0x00020088,
	0x0002005b,
	0x0002005c,
	0x00020025,
	0x00020131,
	0x00020130,
	0x00020137,
	0x00020138,
	0x00020139,
	0x0002013a,
	0x00020001,
	0x0002002c,
	0x00020027,
	0x00020021,
	0x00020023,
	0x00020071,
	0x00020098,
	0x000200ef,
	0x00020060,
	0x00020061,
	0x00020120,
	0x00020132,
	0x00020135,
	0x00020100,
	0x00020110,
	0x00020121,
	0x00020133,
	0x00020136,
	0x00020101,
	0x00020111,
	0x00020122,
	0x00020134,
	0x00020102,
	0x00020112,
	0x00020123,
	0x00020103,
	0x00020113,
	0x00020124,
	0x00020104,
	0x00020114,
	0x00020125,
	0x00020105,
	0x00020115,
	0x00020126,
	0x00020106,
	0x00020116,
	0x00020127,
	0x00020107,
	0x00020117,
	0x00020128,
	0x00020108,
	0x00020118,
	0x00020129,
	0x00020109,
	0x00020119,
	0x0002012a,
	0x0002012b,
	0x0002012c,
	0x0002012d,
	0x0002012e,
	0x0002012f,
	0x00000043,
	0x00000055,
	0x00001043,
	0x00001055,
	0x00002043,
	0x00002055,
	0x00003043,
	0x00003055,
	0x00004043,
	0x00004055,
	0x00005043,
	0x00005055,
	0x00006043,
	0x00006055,
	0x00007043,
	0x00007055,
	0x00008043,
	0x00008055,
	0x00009043,
	0x00009055,
	0x0000a043,
	0x0000a055,
	0x0000b043,
	0x0000b055,
	0x0002007d,
	0x00020020,
	0x0012007d,
	0x00120020,
	0x0022007d,
	0x00220020,
	0x0032007d,
	0x00320020,
	0x00020077,
	0x00020072,
	0x00020073,
	0x00020005,
	0x000200cb,
	0x00000080,
	0x00100080,
	0x00200080,
	0x00300080,
	0x00001080,
	0x00101080,
	0x00201080,
	0x00301080,
	0x00002080,
	0x00102080,
	0x00202080,
	0x00302080,
	0x00003080,
	0x00103080,
	0x00203080,
	0x00303080,
	0x00004080,
	0x00104080,
	0x00204080,
	0x00304080,
	0x00005080,
	0x00105080,
	0x00205080,
	0x00305080,
	0x00006080,
	0x00106080,
	0x00206080,
	0x00306080,
	0x00007080,
	0x00107080,
	0x00207080,
	0x00307080,
	0x00008080,
	0x00108080,
	0x00208080,
	0x00308080,
	0x00009080,
	0x00109080,
	0x00209080,
	0x00309080,
	0x0000a080,
	0x0010a080,
	0x0020a080,
	0x0030a080,
	0x0000b080,
	0x0010b080,
	0x0020b080,
	0x0030b080,
	0x000100c0,
	0x00010068,
	0x00010040,
	0x00010030,
	0x00010062,
	0x000101c0,
	0x00010168,
	0x00010140,
	0x00010130,
	0x00010162,
	0x000102c0,
	0x00010268,
	0x00010240,
	0x00010230,
	0x00010262,
	0x000103c0,
	0x00010368,
	0x00010340,
	0x00010330,
	0x00010362,
	0x000104c0,
	0x00010468,
	0x00010440,
	0x00010430,
	0x00010462,
	0x000105c0,
	0x00010568,
	0x00010540,
	0x00010530,
	0x00010562,
	0x000106c0,
	0x00010668,
	0x00010640,
	0x00010630,
	0x00010662,
	0x000107c0,
	0x00010768,
	0x00010740,
	0x00010730,
	0x00010762,
	0x000108c0,
	0x00010868,
	0x00010840,
	0x00010830,
	0x00010862,
	0x000100d0,
	0x0001008c,
	0x00010090,
	0x00010080,
	0x000101d0,
	0x0001018c,
	0x00010190,
	0x00010180,
	0x000100c1,
	0x00010069,
	0x000101c1,
	0x00010169,
	0x000102c1,
	0x00010269,
	0x000103c1,
	0x00010369,
	0x000104c1,
	0x00010469,
	0x000105c1,
	0x00010569,
	0x000106c1,
	0x00010669,
	0x000107c1,
	0x00010769,
	0x000108c1,
	0x00010869,
	0x000100d1,
	0x0001008d,
	0x00010091,
	0x00010081,
	0x000101d1,
	0x0001018d,
	0x00010191,
	0x00010181,
	0x00010020,
	0x000100ae,
	0x000100af,
	0x00010048,
	0x00010041,
	0x0001004b,
	0x0001004d,
	0x00010049,
	0x00010043,
	0x0001005f,
	0x00010141,
	0x0001014b,
	0x0001014d,
	0x00010149,
	0x00010143,
	0x0001015f,
	0x001100c0,
	0x001101c0,
	0x001102c0,
	0x001103c0,
	0x001104c0,
	0x001105c0,
	0x001106c0,
	0x001107c0,
	0x001108c0,
	0x001100d0,
	0x0011008c,
	0x00110090,
	0x00110080,
	0x001101d0,
	0x0011018c,
	0x00110190,
	0x00110180,
	0x001100c1,
	0x001101c1,
	0x001102c1,
	0x001103c1,
	0x001104c1,
	0x001105c1,
	0x001106c1,
	0x001107c1,
	0x001108c1,
	0x001100d1,
	0x0011008d,
	0x00110091,
	0x00110081,
	0x001101d1,
	0x0011018d,
	0x00110191,
	0x00110181,
	0x00110020,
	0x001100ae,
	0x001100af,
	0x00110048,
	0x00110041,
	0x0011004b,
	0x0011004d,
	0x00110049,
	0x00110043,
	0x0011005f,
	0x00110141,
	0x0011014b,
	0x0011014d,
	0x00110149,
	0x00110143,
	0x0011015f,
	0x002100c0,
	0x002101c0,
	0x002102c0,
	0x002103c0,
	0x002104c0,
	0x002105c0,
	0x002106c0,
	0x002107c0,
	0x002108c0,
	0x002100d0,
	0x0021008c,
	0x00210090,
	0x00210080,
	0x002101d0,
	0x0021018c,
	0x00210190,
	0x00210180,
	0x002100c1,
	0x002101c1,
	0x002102c1,
	0x002103c1,
	0x002104c1,
	0x002105c1,
	0x002106c1,
	0x002107c1,
	0x002108c1,
	0x002100d1,
	0x0021008d,
	0x00210091,
	0x00210081,
	0x002101d1,
	0x0021018d,
	0x00210191,
	0x00210181,
	0x00210020,
	0x002100ae,
	0x002100af,
	0x00210048,
	0x00210041,
	0x0021004b,
	0x0021004d,
	0x00210049,
	0x00210043,
	0x0021005f,
	0x00210141,
	0x0021014b,
	0x0021014d,
	0x00210149,
	0x00210143,
	0x0021015f,
	0x003100c0,
	0x003101c0,
	0x003102c0,
	0x003103c0,
	0x003104c0,
	0x003105c0,
	0x003106c0,
	0x003107c0,
	0x003108c0,
	0x003100d0,
	0x0031008c,
	0x00310090,
	0x00310080,
	0x003101d0,
	0x0031018c,
	0x00310190,
	0x00310180,
	0x003100c1,
	0x003101c1,
	0x003102c1,
	0x003103c1,
	0x003104c1,
	0x003105c1,
	0x003106c1,
	0x003107c1,
	0x003108c1,
	0x003100d1,
	0x0031008d,
	0x00310091,
	0x00310081,
	0x003101d1,
	0x0031018d,
	0x00310191,
	0x00310181,
	0x00310020,
	0x003100ae,
	0x003100af,
	0x00310048,
	0x00310041,
	0x0031004b,
	0x0031004d,
	0x00310049,
	0x00310043,
	0x0031005f,
	0x00310141,
	0x0031014b,
	0x0031014d,
	0x00310149,
	0x00310143,
	0x0031015f,
	0x000100aa,
	0x00010001,
	0x000100a0,
	0x000100a1,
	0x000100a2,
	0x000100a3,
	0x000100a4,
	0x000100a5,
	0x000100a6,
	0x000100a7,
	0x00010000,
	0x0001004a,
	0x000110c0,
	0x00011068,
	0x00011040,
	0x00011030,
	0x00011062,
	0x000111c0,
	0x00011168,
	0x00011140,
	0x00011130,
	0x00011162,
	0x000112c0,
	0x00011268,
	0x00011240,
	0x00011230,
	0x00011262,
	0x000113c0,
	0x00011368,
	0x00011340,
	0x00011330,
	0x00011362,
	0x000114c0,
	0x00011468,
	0x00011440,
	0x00011430,
	0x00011462,
	0x000115c0,
	0x00011568,
	0x00011540,
	0x00011530,
	0x00011562,
	0x000116c0,
	0x00011668,
	0x00011640,
	0x00011630,
	0x00011662,
	0x000117c0,
	0x00011768,
	0x00011740,
	0x00011730,
	0x00011762,
	0x000118c0,
	0x00011868,
	0x00011840,
	0x00011830,
	0x00011862,
	0x000110d0,
	0x0001108c,
	0x00011090,
	0x00011080,
	0x000111d0,
	0x0001118c,
	0x00011190,
	0x00011180,
	0x000110c1,
	0x00011069,
	0x000111c1,
	0x00011169,
	0x000112c1,
	0x00011269,
	0x000113c1,
	0x00011369,
	0x000114c1,
	0x00011469,
	0x000115c1,
	0x00011569,
	0x000116c1,
	0x00011669,
	0x000117c1,
	0x00011769,
	0x000118c1,
	0x00011869,
	0x000110d1,
	0x0001108d,
	0x00011091,
	0x00011081,
	0x000111d1,
	0x0001118d,
	0x00011191,
	0x00011181,
	0x00011020,
	0x000110ae,
	0x000110af,
	0x00011048,
	0x00011041,
	0x0001104b,
	0x0001104d,
	0x00011049,
	0x00011043,
	0x0001105f,
	0x00011141,
	0x0001114b,
	0x0001114d,
	0x00011149,
	0x00011143,
	0x0001115f,
	0x001110c0,
	0x001111c0,
	0x001112c0,
	0x001113c0,
	0x001114c0,
	0x001115c0,
	0x001116c0,
	0x001117c0,
	0x001118c0,
	0x001110d0,
	0x0011108c,
	0x00111090,
	0x00111080,
	0x001111d0,
	0x0011118c,
	0x00111190,
	0x00111180,
	0x001110c1,
	0x001111c1,
	0x001112c1,
	0x001113c1,
	0x001114c1,
	0x001115c1,
	0x001116c1,
	0x001117c1,
	0x001118c1,
	0x001110d1,
	0x0011108d,
	0x00111091,
	0x00111081,
	0x001111d1,
	0x0011118d,
	0x00111191,
	0x00111181,
	0x00111020,
	0x001110ae,
	0x001110af,
	0x00111048,
	0x00111041,
	0x0011104b,
	0x0011104d,
	0x00111049,
	0x00111043,
	0x0011105f,
	0x00111141,
	0x0011114b,
	0x0011114d,
	0x00111149,
	0x00111143,
	0x0011115f,
	0x002110c0,
	0x002111c0,
	0x002112c0,
	0x002113c0,
	0x002114c0,
	0x002115c0,
	0x002116c0,
	0x002117c0,
	0x002118c0,
	0x002110d0,
	0x0021108c,
	0x00211090,
	0x00211080,
	0x002111d0,
	0x0021118c,
	0x00211190,
	0x00211180,
	0x002110c1,
	0x002111c1,
	0x002112c1,
	0x002113c1,
	0x002114c1,
	0x002115c1,
	0x002116c1,
	0x002117c1,
	0x002118c1,
	0x002110d1,
	0x0021108d,
	0x00211091,
	0x00211081,
	0x002111d1,
	0x0021118d,
	0x00211191,
	0x00211181,
	0x00211020,
	0x002110ae,
	0x002110af,
	0x00211048,
	0x00211041,
	0x0021104b,
	0x0021104d,
	0x00211049,
	0x00211043,
	0x0021105f,
	0x00211141,
	0x0021114b,
	0x0021114d,
	0x00211149,
	0x00211143,
	0x0021115f,
	0x003110c0,
	0x003111c0,
	0x003112c0,
	0x003113c0,
	0x003114c0,
	0x003115c0,
	0x003116c0,
	0x003117c0,
	0x003118c0,
	0x003110d0,
	0x0031108c,
	0x00311090,
	0x00311080,
	0x003111d0,
	0x0031118c,
	0x00311190,
	0x00311180,
	0x003110c1,
	0x003111c1,
	0x003112c1,
	0x003113c1,
	0x003114c1,
	0x003115c1,
	0x003116c1,
	0x003117c1,
	0x003118c1,
	0x003110d1,
	0x0031108d,
	0x00311091,
	0x00311081,
	0x003111d1,
	0x0031118d,
	0x00311191,
	0x00311181,
	0x00311020,
	0x003110ae,
	0x003110af,
	0x00311048,
	0x00311041,
	0x0031104b,
	0x0031104d,
	0x00311049,
	0x00311043,
	0x0031105f,
	0x00311141,
	0x0031114b,
	0x0031114d,
	0x00311149,
	0x00311143,
	0x0031115f,
	0x000110aa,
	0x00011001,
	0x000110a0,
	0x000110a1,
	0x000110a2,
	0x000110a3,
	0x000110a4,
	0x000110a5,
	0x000110a6,
	0x000110a7,
	0x00011000,
	0x0001104a,
};

static const uint32_t ddrphy_fsp_cfg[DDRPHY_QB_FSP_SIZE] = {
	0x00054026, /* TrainedVREFDQ_A0,   Byte offset 0x4d,      CSR Addr 0x54026 */
	0x00054027, /* TrainedVREFDQ_A1,   Byte offset 0x4e,      CSR Addr 0x54027 */
	0x00054040, /* TrainedVREFDQ_B0&1, Byte offset 0x80&0x81, CSR Addr 0x54040 */
};

struct ddrphy_qb_state qb_state;

int ddrphy_qb_save(void)
{
	int i;

	/* enable the ddrphy apb */
	dwc_ddrphy_apb_wr(0xd0000, 0x0);

	for (i = 0; i < DDRPHY_QB_ERR_SIZE; i++)
		qb_state.err[i] = dwc_ddrphy_apb_rd(ddrphy_err_cfg[i]);

	for (i = 0; i < DDRPHY_QB_CSR_SIZE; i++)
		qb_state.csr[i] = dwc_ddrphy_apb_rd(ddrphy_csr_cfg[i]);

	/* disable the ddrphy apb */
	dwc_ddrphy_apb_wr(0xd0000, 0x1);

	qb_state.crc = crc32(0, (void *)&(qb_state.flags), DDRPHY_QB_STATE_SIZE);
	return 0;
}

void ddrphy_init_read_msg_block(enum fw_type type)
{
	int i;

	if (type != FW_2D_IMAGE)
		return;

	qb_state.flags |= DDRPHY_QB_FLAG_2D;
	for (i = 0; i < DDRPHY_QB_FSP_SIZE; i++)
		qb_state.fsp[i] = dwc_ddrphy_apb_rd(ddrphy_fsp_cfg[i]);
}
