/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * Copyright 2022 NXP
 */

#ifndef __ASM_ARCH_IMX93_PINS_H__
#define __ASM_ARCH_IMX93_PINS_H__

#include <asm/mach-imx/iomux-v3.h>

enum {
	MX93_PAD_DAP_TDI__JTAG_MUX_TDI                           = IOMUX_PAD(0x01B0, 0x0000, 0, 0x03D8, 0, 0),
	MX93_PAD_DAP_TDI__MQS2_LEFT                              = IOMUX_PAD(0x01B0, 0x0000, 1, 0x0000, 0, 0),
	MX93_PAD_DAP_TDI__CAN2_TX                                = IOMUX_PAD(0x01B0, 0x0000, 3, 0x0000, 0, 0),
	MX93_PAD_DAP_TDI__FLEXIO2_FLEXIO30                       = IOMUX_PAD(0x01B0, 0x0000, 4, 0x0000, 0, 0),
	MX93_PAD_DAP_TDI__GPIO3_IO28                             = IOMUX_PAD(0x01B0, 0x0000, 5, 0x0000, 0, 0),
	MX93_PAD_DAP_TDI__LPUART5_RX                             = IOMUX_PAD(0x01B0, 0x0000, 6, 0x0430, 0, 0),

	MX93_PAD_DAP_TMS_SWDIO__JTAG_MUX_TMS                     = IOMUX_PAD(0x01B4, 0x0004, 0, 0x03DC, 0, 0),
	MX93_PAD_DAP_TMS_SWDIO__FLEXIO2_FLEXIO31                 = IOMUX_PAD(0x01B4, 0x0004, 4, 0x0000, 0, 0),
	MX93_PAD_DAP_TMS_SWDIO__GPIO3_IO29                       = IOMUX_PAD(0x01B4, 0x0004, 5, 0x0000, 0, 0),
	MX93_PAD_DAP_TMS_SWDIO__LPUART5_RTS_B                    = IOMUX_PAD(0x01B4, 0x0004, 6, 0x0000, 0, 0),

	MX93_PAD_DAP_TCLK_SWCLK__JTAG_MUX_TCK                    = IOMUX_PAD(0x01B8, 0x0008, 0, 0x03D4, 0, 0),
	MX93_PAD_DAP_TCLK_SWCLK__FLEXIO1_FLEXIO30                = IOMUX_PAD(0x01B8, 0x0008, 4, 0x0000, 0, 0),
	MX93_PAD_DAP_TCLK_SWCLK__GPIO3_IO30                      = IOMUX_PAD(0x01B8, 0x0008, 5, 0x0000, 0, 0),
	MX93_PAD_DAP_TCLK_SWCLK__LPUART5_CTS_B                   = IOMUX_PAD(0x01B8, 0x0008, 6, 0x042C, 0, 0),

	MX93_PAD_DAP_TDO_TRACESWO__JTAG_MUX_TDO                  = IOMUX_PAD(0x01BC, 0x000C, 0, 0x0000, 0, 0),
	MX93_PAD_DAP_TDO_TRACESWO__MQS2_RIGHT                    = IOMUX_PAD(0x01BC, 0x000C, 1, 0x0000, 0, 0),
	MX93_PAD_DAP_TDO_TRACESWO__CAN2_RX                       = IOMUX_PAD(0x01BC, 0x000C, 3, 0x0364, 0, 0),
	MX93_PAD_DAP_TDO_TRACESWO__FLEXIO1_FLEXIO31              = IOMUX_PAD(0x01BC, 0x000C, 4, 0x0000, 0, 0),
	MX93_PAD_DAP_TDO_TRACESWO__GPIO3_IO31                    = IOMUX_PAD(0x01BC, 0x000C, 5, 0x0000, 0, 0),
	MX93_PAD_DAP_TDO_TRACESWO__LPUART5_TX                    = IOMUX_PAD(0x01BC, 0x000C, 6, 0x0434, 0, 0),

	MX93_PAD_GPIO_IO00__GPIO2_IO00                           = IOMUX_PAD(0x01C0, 0x0010, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO00__LPI2C3_SDA                           = IOMUX_PAD(0x01C0, 0x0010, 1 | IOMUX_CONFIG_SION, 0x03E4, 0, 0),
	MX93_PAD_GPIO_IO00__MEDIAMIX_CAM_CLK                     = IOMUX_PAD(0x01C0, 0x0010, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO00__MEDIAMIX_DISP_CLK                    = IOMUX_PAD(0x01C0, 0x0010, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO00__LPSPI6_PCS0                          = IOMUX_PAD(0x01C0, 0x0010, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO00__LPUART5_TX                           = IOMUX_PAD(0x01C0, 0x0010, 5, 0x0434, 1, 0),
	MX93_PAD_GPIO_IO00__LPI2C5_SDA                           = IOMUX_PAD(0x01C0, 0x0010, 6 | IOMUX_CONFIG_SION, 0x03EC, 0, 0),
	MX93_PAD_GPIO_IO00__FLEXIO1_FLEXIO00                     = IOMUX_PAD(0x01C0, 0x0010, 7, 0x036C, 0, 0),

	MX93_PAD_GPIO_IO01__GPIO2_IO01                           = IOMUX_PAD(0x01C4, 0x0014, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO01__LPI2C3_SCL                           = IOMUX_PAD(0x01C4, 0x0014, 1 | IOMUX_CONFIG_SION, 0x03E0, 0, 0),
	MX93_PAD_GPIO_IO01__MEDIAMIX_CAM_DATA00                  = IOMUX_PAD(0x01C4, 0x0014, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO01__MEDIAMIX_DISP_DE                     = IOMUX_PAD(0x01C4, 0x0014, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO01__LPSPI6_SIN                           = IOMUX_PAD(0x01C4, 0x0014, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO01__LPUART5_RX                           = IOMUX_PAD(0x01C4, 0x0014, 5, 0x0430, 1, 0),
	MX93_PAD_GPIO_IO01__LPI2C5_SCL                           = IOMUX_PAD(0x01C4, 0x0014, 6 | IOMUX_CONFIG_SION, 0x03E8, 0, 0),
	MX93_PAD_GPIO_IO01__FLEXIO1_FLEXIO01                     = IOMUX_PAD(0x01C4, 0x0014, 7, 0x0370, 0, 0),

	MX93_PAD_GPIO_IO02__GPIO2_IO02                           = IOMUX_PAD(0x01C8, 0x0018, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO02__LPI2C4_SDA                           = IOMUX_PAD(0x01C8, 0x0018, 1 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO02__MEDIAMIX_CAM_VSYNC                   = IOMUX_PAD(0x01C8, 0x0018, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO02__MEDIAMIX_DISP_VSYNC                  = IOMUX_PAD(0x01C8, 0x0018, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO02__LPSPI6_SOUT                          = IOMUX_PAD(0x01C8, 0x0018, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO02__LPUART5_CTS_B                        = IOMUX_PAD(0x01C8, 0x0018, 5, 0x042C, 1, 0),
	MX93_PAD_GPIO_IO02__LPI2C6_SDA                           = IOMUX_PAD(0x01C8, 0x0018, 6 | IOMUX_CONFIG_SION, 0x03F4, 0, 0),
	MX93_PAD_GPIO_IO02__FLEXIO1_FLEXIO02                     = IOMUX_PAD(0x01C8, 0x0018, 7, 0x0374, 0, 0),

	MX93_PAD_GPIO_IO03__GPIO2_IO03                           = IOMUX_PAD(0x01CC, 0x001C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__LPI2C4_SCL                           = IOMUX_PAD(0x01CC, 0x001C, 1 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__MEDIAMIX_CAM_HSYNC                   = IOMUX_PAD(0x01CC, 0x001C, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__MEDIAMIX_DISP_HSYNC                  = IOMUX_PAD(0x01CC, 0x001C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__LPSPI6_SCK                           = IOMUX_PAD(0x01CC, 0x001C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__LPUART5_RTS_B                        = IOMUX_PAD(0x01CC, 0x001C, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO03__LPI2C6_SCL                           = IOMUX_PAD(0x01CC, 0x001C, 6 | IOMUX_CONFIG_SION, 0x03F0, 0, 0),
	MX93_PAD_GPIO_IO03__FLEXIO1_FLEXIO03                     = IOMUX_PAD(0x01CC, 0x001C, 7, 0x0378, 0, 0),

	MX93_PAD_GPIO_IO04__GPIO2_IO04                           = IOMUX_PAD(0x01D0, 0x0020, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__TPM3_CH0                             = IOMUX_PAD(0x01D0, 0x0020, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__PDM_CLK                              = IOMUX_PAD(0x01D0, 0x0020, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__MEDIAMIX_DISP_DATA00                 = IOMUX_PAD(0x01D0, 0x0020, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__LPSPI7_PCS0                          = IOMUX_PAD(0x01D0, 0x0020, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__LPUART6_TX                           = IOMUX_PAD(0x01D0, 0x0020, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO04__LPI2C6_SDA                           = IOMUX_PAD(0x01D0, 0x0020, 6 | IOMUX_CONFIG_SION, 0x03F4, 1, 0),
	MX93_PAD_GPIO_IO04__FLEXIO1_FLEXIO04                     = IOMUX_PAD(0x01D0, 0x0020, 7, 0x037C, 0, 0),

	MX93_PAD_GPIO_IO05__GPIO2_IO05                           = IOMUX_PAD(0x01D4, 0x0024, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO05__TPM4_CH0                             = IOMUX_PAD(0x01D4, 0x0024, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO05__PDM_BIT_STREAM00                     = IOMUX_PAD(0x01D4, 0x0024, 2, 0x0438, 0, 0),
	MX93_PAD_GPIO_IO05__MEDIAMIX_DISP_DATA01                 = IOMUX_PAD(0x01D4, 0x0024, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO05__LPSPI7_SIN                           = IOMUX_PAD(0x01D4, 0x0024, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO05__LPUART6_RX                           = IOMUX_PAD(0x01D4, 0x0024, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO05__LPI2C6_SCL                           = IOMUX_PAD(0x01D4, 0x0024, 6 | IOMUX_CONFIG_SION, 0x03F0, 1, 0),
	MX93_PAD_GPIO_IO05__FLEXIO1_FLEXIO05                     = IOMUX_PAD(0x01D4, 0x0024, 7, 0x0380, 0, 0),

	MX93_PAD_GPIO_IO06__GPIO2_IO06                           = IOMUX_PAD(0x01D8, 0x0028, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO06__TPM5_CH0                             = IOMUX_PAD(0x01D8, 0x0028, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO06__PDM_BIT_STREAM01                     = IOMUX_PAD(0x01D8, 0x0028, 2, 0x043C, 0, 0),
	MX93_PAD_GPIO_IO06__MEDIAMIX_DISP_DATA02                 = IOMUX_PAD(0x01D8, 0x0028, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO06__LPSPI7_SOUT                          = IOMUX_PAD(0x01D8, 0x0028, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO06__LPUART6_CTS_B                        = IOMUX_PAD(0x01D8, 0x0028, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO06__LPI2C7_SDA                           = IOMUX_PAD(0x01D8, 0x0028, 6 | IOMUX_CONFIG_SION, 0x03FC, 0, 0),
	MX93_PAD_GPIO_IO06__FLEXIO1_FLEXIO06                     = IOMUX_PAD(0x01D8, 0x0028, 7, 0x0384, 0, 0),

	MX93_PAD_GPIO_IO07__GPIO2_IO07                           = IOMUX_PAD(0x01DC, 0x002C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__LPSPI3_PCS1                          = IOMUX_PAD(0x01DC, 0x002C, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__MEDIAMIX_CAM_DATA01                  = IOMUX_PAD(0x01DC, 0x002C, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__MEDIAMIX_DISP_DATA03                 = IOMUX_PAD(0x01DC, 0x002C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__LPSPI7_SCK                           = IOMUX_PAD(0x01DC, 0x002C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__LPUART6_RTS_B                        = IOMUX_PAD(0x01DC, 0x002C, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO07__LPI2C7_SCL                           = IOMUX_PAD(0x01DC, 0x002C, 6 | IOMUX_CONFIG_SION, 0x03F8, 0, 0),
	MX93_PAD_GPIO_IO07__FLEXIO1_FLEXIO07                     = IOMUX_PAD(0x01DC, 0x002C, 7, 0x0388, 0, 0),

	MX93_PAD_GPIO_IO08__GPIO2_IO08                           = IOMUX_PAD(0x01E0, 0x0030, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__LPSPI3_PCS0                          = IOMUX_PAD(0x01E0, 0x0030, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__MEDIAMIX_CAM_DATA02                  = IOMUX_PAD(0x01E0, 0x0030, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__MEDIAMIX_DISP_DATA04                 = IOMUX_PAD(0x01E0, 0x0030, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__TPM6_CH0                             = IOMUX_PAD(0x01E0, 0x0030, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__LPUART7_TX                           = IOMUX_PAD(0x01E0, 0x0030, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO08__LPI2C7_SDA                           = IOMUX_PAD(0x01E0, 0x0030, 6 | IOMUX_CONFIG_SION, 0x03FC, 1, 0),
	MX93_PAD_GPIO_IO08__FLEXIO1_FLEXIO08                     = IOMUX_PAD(0x01E0, 0x0030, 7, 0x038C, 0, 0),

	MX93_PAD_GPIO_IO09__GPIO2_IO09                           = IOMUX_PAD(0x01E4, 0x0034, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__LPSPI3_SIN                           = IOMUX_PAD(0x01E4, 0x0034, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__MEDIAMIX_CAM_DATA03                  = IOMUX_PAD(0x01E4, 0x0034, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__MEDIAMIX_DISP_DATA05                 = IOMUX_PAD(0x01E4, 0x0034, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__TPM3_EXTCLK                          = IOMUX_PAD(0x01E4, 0x0034, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__LPUART7_RX                           = IOMUX_PAD(0x01E4, 0x0034, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO09__LPI2C7_SCL                           = IOMUX_PAD(0x01E4, 0x0034, 6 | IOMUX_CONFIG_SION, 0x03F8, 1, 0),
	MX93_PAD_GPIO_IO09__FLEXIO1_FLEXIO09                     = IOMUX_PAD(0x01E4, 0x0034, 7, 0x0390, 0, 0),

	MX93_PAD_GPIO_IO10__GPIO2_IO10                           = IOMUX_PAD(0x01E8, 0x0038, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__LPSPI3_SOUT                          = IOMUX_PAD(0x01E8, 0x0038, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__MEDIAMIX_CAM_DATA04                  = IOMUX_PAD(0x01E8, 0x0038, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__MEDIAMIX_DISP_DATA06                 = IOMUX_PAD(0x01E8, 0x0038, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__TPM4_EXTCLK                          = IOMUX_PAD(0x01E8, 0x0038, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__LPUART7_CTS_B                        = IOMUX_PAD(0x01E8, 0x0038, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO10__LPI2C8_SDA                           = IOMUX_PAD(0x01E8, 0x0038, 6 | IOMUX_CONFIG_SION, 0x0404, 0, 0),
	MX93_PAD_GPIO_IO10__FLEXIO1_FLEXIO10                     = IOMUX_PAD(0x01E8, 0x0038, 7, 0x0394, 0, 0),

	MX93_PAD_GPIO_IO11__GPIO2_IO11                           = IOMUX_PAD(0x01EC, 0x003C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__LPSPI3_SCK                           = IOMUX_PAD(0x01EC, 0x003C, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__MEDIAMIX_CAM_DATA05                  = IOMUX_PAD(0x01EC, 0x003C, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__MEDIAMIX_DISP_DATA07                 = IOMUX_PAD(0x01EC, 0x003C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__TPM5_EXTCLK                          = IOMUX_PAD(0x01EC, 0x003C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__LPUART7_RTS_B                        = IOMUX_PAD(0x01EC, 0x003C, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO11__LPI2C8_SCL                           = IOMUX_PAD(0x01EC, 0x003C, 6 | IOMUX_CONFIG_SION, 0x0400, 0, 0),
	MX93_PAD_GPIO_IO11__FLEXIO1_FLEXIO11                     = IOMUX_PAD(0x01EC, 0x003C, 7, 0x0398, 0, 0),

	MX93_PAD_GPIO_IO12__GPIO2_IO12                           = IOMUX_PAD(0x01F0, 0x0040, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO12__TPM3_CH2                             = IOMUX_PAD(0x01F0, 0x0040, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO12__PDM_BIT_STREAM02                     = IOMUX_PAD(0x01F0, 0x0040, 2, 0x0440, 0, 0),
	MX93_PAD_GPIO_IO12__MEDIAMIX_DISP_DATA08                 = IOMUX_PAD(0x01F0, 0x0040, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO12__LPSPI8_PCS0                          = IOMUX_PAD(0x01F0, 0x0040, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO12__LPUART8_TX                           = IOMUX_PAD(0x01F0, 0x0040, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO12__LPI2C8_SDA                           = IOMUX_PAD(0x01F0, 0x0040, 6 | IOMUX_CONFIG_SION, 0x0404, 1, 0),
	MX93_PAD_GPIO_IO12__SAI3_RX_SYNC                         = IOMUX_PAD(0x01F0, 0x0040, 7, 0x0450, 0, 0),

	MX93_PAD_GPIO_IO13__GPIO2_IO13                           = IOMUX_PAD(0x01F4, 0x0044, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO13__TPM4_CH2                             = IOMUX_PAD(0x01F4, 0x0044, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO13__PDM_BIT_STREAM03                     = IOMUX_PAD(0x01F4, 0x0044, 2, 0x0444, 0, 0),
	MX93_PAD_GPIO_IO13__MEDIAMIX_DISP_DATA09                 = IOMUX_PAD(0x01F4, 0x0044, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO13__LPSPI8_SIN                           = IOMUX_PAD(0x01F4, 0x0044, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO13__LPUART8_RX                           = IOMUX_PAD(0x01F4, 0x0044, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO13__LPI2C8_SCL                           = IOMUX_PAD(0x01F4, 0x0044, 6 | IOMUX_CONFIG_SION, 0x0400, 1, 0),
	MX93_PAD_GPIO_IO13__FLEXIO1_FLEXIO13                     = IOMUX_PAD(0x01F4, 0x0044, 7, 0x039C, 0, 0),

	MX93_PAD_GPIO_IO14__GPIO2_IO14                           = IOMUX_PAD(0x01F8, 0x0048, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO14__LPUART3_TX                           = IOMUX_PAD(0x01F8, 0x0048, 1, 0x041C, 0, 0),
	MX93_PAD_GPIO_IO14__MEDIAMIX_CAM_DATA06                  = IOMUX_PAD(0x01F8, 0x0048, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO14__MEDIAMIX_DISP_DATA10                 = IOMUX_PAD(0x01F8, 0x0048, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO14__LPSPI8_SOUT                          = IOMUX_PAD(0x01F8, 0x0048, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO14__LPUART8_CTS_B                        = IOMUX_PAD(0x01F8, 0x0048, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO14__LPUART4_TX                           = IOMUX_PAD(0x01F8, 0x0048, 6, 0x0428, 0, 0),
	MX93_PAD_GPIO_IO14__FLEXIO1_FLEXIO14                     = IOMUX_PAD(0x01F8, 0x0048, 7, 0x03A0, 0, 0),

	MX93_PAD_GPIO_IO15__GPIO2_IO15                           = IOMUX_PAD(0x01FC, 0x004C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO15__LPUART3_RX                           = IOMUX_PAD(0x01FC, 0x004C, 1, 0x0418, 0, 0),
	MX93_PAD_GPIO_IO15__MEDIAMIX_CAM_DATA07                  = IOMUX_PAD(0x01FC, 0x004C, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO15__MEDIAMIX_DISP_DATA11                 = IOMUX_PAD(0x01FC, 0x004C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO15__LPSPI8_SCK                           = IOMUX_PAD(0x01FC, 0x004C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO15__LPUART8_RTS_B                        = IOMUX_PAD(0x01FC, 0x004C, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO15__LPUART4_RX                           = IOMUX_PAD(0x01FC, 0x004C, 6, 0x0424, 0, 0),
	MX93_PAD_GPIO_IO15__FLEXIO1_FLEXIO15                     = IOMUX_PAD(0x01FC, 0x004C, 7, 0x03A4, 0, 0),

	MX93_PAD_GPIO_IO16__GPIO2_IO16                           = IOMUX_PAD(0x0200, 0x0050, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO16__SAI3_TX_BCLK                         = IOMUX_PAD(0x0200, 0x0050, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO16__PDM_BIT_STREAM02                     = IOMUX_PAD(0x0200, 0x0050, 2, 0x0440, 1, 0),
	MX93_PAD_GPIO_IO16__MEDIAMIX_DISP_DATA12                 = IOMUX_PAD(0x0200, 0x0050, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO16__LPUART3_CTS_B                        = IOMUX_PAD(0x0200, 0x0050, 4, 0x0414, 0, 0),
	MX93_PAD_GPIO_IO16__LPSPI4_PCS2                          = IOMUX_PAD(0x0200, 0x0050, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO16__LPUART4_CTS_B                        = IOMUX_PAD(0x0200, 0x0050, 6, 0x0420, 0, 0),
	MX93_PAD_GPIO_IO16__FLEXIO1_FLEXIO16                     = IOMUX_PAD(0x0200, 0x0050, 7, 0x03A8, 0, 0),

	MX93_PAD_GPIO_IO17__GPIO2_IO17                           = IOMUX_PAD(0x0204, 0x0054, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__SAI3_MCLK                            = IOMUX_PAD(0x0204, 0x0054, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__MEDIAMIX_CAM_DATA08                  = IOMUX_PAD(0x0204, 0x0054, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__MEDIAMIX_DISP_DATA13                 = IOMUX_PAD(0x0204, 0x0054, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__LPUART3_RTS_B                        = IOMUX_PAD(0x0204, 0x0054, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__LPSPI4_PCS1                          = IOMUX_PAD(0x0204, 0x0054, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__LPUART4_RTS_B                        = IOMUX_PAD(0x0204, 0x0054, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO17__FLEXIO1_FLEXIO17                     = IOMUX_PAD(0x0204, 0x0054, 7, 0x03AC, 0, 0),

	MX93_PAD_GPIO_IO18__GPIO2_IO18                           = IOMUX_PAD(0x0208, 0x0058, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__SAI3_RX_BCLK                         = IOMUX_PAD(0x0208, 0x0058, 1, 0x044C, 0, 0),
	MX93_PAD_GPIO_IO18__MEDIAMIX_CAM_DATA09                  = IOMUX_PAD(0x0208, 0x0058, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__MEDIAMIX_DISP_DATA14                 = IOMUX_PAD(0x0208, 0x0058, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__LPSPI5_PCS0                          = IOMUX_PAD(0x0208, 0x0058, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__LPSPI4_PCS0                          = IOMUX_PAD(0x0208, 0x0058, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__TPM5_CH2                             = IOMUX_PAD(0x0208, 0x0058, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO18__FLEXIO1_FLEXIO18                     = IOMUX_PAD(0x0208, 0x0058, 7, 0x03B0, 0, 0),

	MX93_PAD_GPIO_IO19__GPIO2_IO19                           = IOMUX_PAD(0x020C, 0x005C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO19__SAI3_RX_SYNC                         = IOMUX_PAD(0x020C, 0x005C, 1, 0x0450, 1, 0),
	MX93_PAD_GPIO_IO19__PDM_BIT_STREAM03                     = IOMUX_PAD(0x020C, 0x005C, 2, 0x0444, 1, 0),
	MX93_PAD_GPIO_IO19__MEDIAMIX_DISP_DATA15                 = IOMUX_PAD(0x020C, 0x005C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO19__LPSPI5_SIN                           = IOMUX_PAD(0x020C, 0x005C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO19__LPSPI4_SIN                           = IOMUX_PAD(0x020C, 0x005C, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO19__TPM6_CH2                             = IOMUX_PAD(0x020C, 0x005C, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO19__SAI3_TX_DATA00                       = IOMUX_PAD(0x020C, 0x005C, 7, 0x0000, 0, 0),

	MX93_PAD_GPIO_IO20__GPIO2_IO20                           = IOMUX_PAD(0x0210, 0x0060, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__SAI3_RX_DATA00                       = IOMUX_PAD(0x0210, 0x0060, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__PDM_BIT_STREAM00                     = IOMUX_PAD(0x0210, 0x0060, 2, 0x0438, 1, 0),
	MX93_PAD_GPIO_IO20__MEDIAMIX_DISP_DATA16                 = IOMUX_PAD(0x0210, 0x0060, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__LPSPI5_SOUT                          = IOMUX_PAD(0x0210, 0x0060, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__LPSPI4_SOUT                          = IOMUX_PAD(0x0210, 0x0060, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__TPM3_CH1                             = IOMUX_PAD(0x0210, 0x0060, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO20__FLEXIO1_FLEXIO20                     = IOMUX_PAD(0x0210, 0x0060, 7, 0x03B4, 0, 0),

	MX93_PAD_GPIO_IO21__GPIO2_IO21                           = IOMUX_PAD(0x0214, 0x0064, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__SAI3_TX_DATA00                       = IOMUX_PAD(0x0214, 0x0064, 1, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__PDM_CLK                              = IOMUX_PAD(0x0214, 0x0064, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__MEDIAMIX_DISP_DATA17                 = IOMUX_PAD(0x0214, 0x0064, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__LPSPI5_SCK                           = IOMUX_PAD(0x0214, 0x0064, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__LPSPI4_SCK                           = IOMUX_PAD(0x0214, 0x0064, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__TPM4_CH1                             = IOMUX_PAD(0x0214, 0x0064, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO21__SAI3_RX_BCLK                         = IOMUX_PAD(0x0214, 0x0064, 7, 0x044C, 1, 0),

	MX93_PAD_GPIO_IO22__GPIO2_IO22                           = IOMUX_PAD(0x0218, 0x0068, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO22__USDHC3_CLK                           = IOMUX_PAD(0x0218, 0x0068, 1, 0x0458, 0, 0),
	MX93_PAD_GPIO_IO22__SPDIF_IN                             = IOMUX_PAD(0x0218, 0x0068, 2, 0x0454, 0, 0),
	MX93_PAD_GPIO_IO22__MEDIAMIX_DISP_DATA18                 = IOMUX_PAD(0x0218, 0x0068, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO22__TPM5_CH1                             = IOMUX_PAD(0x0218, 0x0068, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO22__TPM6_EXTCLK                          = IOMUX_PAD(0x0218, 0x0068, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO22__LPI2C5_SDA                           = IOMUX_PAD(0x0218, 0x0068, 6 | IOMUX_CONFIG_SION, 0x03EC, 1, 0),
	MX93_PAD_GPIO_IO22__FLEXIO1_FLEXIO22                     = IOMUX_PAD(0x0218, 0x0068, 7, 0x03B8, 0, 0),

	MX93_PAD_GPIO_IO23__GPIO2_IO23                           = IOMUX_PAD(0x021C, 0x006C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO23__USDHC3_CMD                           = IOMUX_PAD(0x021C, 0x006C, 1, 0x045C, 0, 0),
	MX93_PAD_GPIO_IO23__SPDIF_OUT                            = IOMUX_PAD(0x021C, 0x006C, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO23__MEDIAMIX_DISP_DATA19                 = IOMUX_PAD(0x021C, 0x006C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO23__TPM6_CH1                             = IOMUX_PAD(0x021C, 0x006C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO23__LPI2C5_SCL                           = IOMUX_PAD(0x021C, 0x006C, 6 | IOMUX_CONFIG_SION, 0x03E8, 1, 0),
	MX93_PAD_GPIO_IO23__FLEXIO1_FLEXIO23                     = IOMUX_PAD(0x021C, 0x006C, 7, 0x03BC, 0, 0),

	MX93_PAD_GPIO_IO24__GPIO2_IO24                           = IOMUX_PAD(0x0220, 0x0070, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO24__USDHC3_DATA0                         = IOMUX_PAD(0x0220, 0x0070, 1, 0x0460, 0, 0),
	MX93_PAD_GPIO_IO24__MEDIAMIX_DISP_DATA20                 = IOMUX_PAD(0x0220, 0x0070, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO24__TPM3_CH3                             = IOMUX_PAD(0x0220, 0x0070, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO24__JTAG_MUX_TDO                         = IOMUX_PAD(0x0220, 0x0070, 5, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO24__LPSPI6_PCS1                          = IOMUX_PAD(0x0220, 0x0070, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO24__FLEXIO1_FLEXIO24                     = IOMUX_PAD(0x0220, 0x0070, 7, 0x03C0, 0, 0),

	MX93_PAD_GPIO_IO25__GPIO2_IO25                           = IOMUX_PAD(0x0224, 0x0074, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO25__USDHC3_DATA1                         = IOMUX_PAD(0x0224, 0x0074, 1, 0x0464, 0, 0),
	MX93_PAD_GPIO_IO25__CAN2_TX                              = IOMUX_PAD(0x0224, 0x0074, 2, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO25__MEDIAMIX_DISP_DATA21                 = IOMUX_PAD(0x0224, 0x0074, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO25__TPM4_CH3                             = IOMUX_PAD(0x0224, 0x0074, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO25__JTAG_MUX_TCK                         = IOMUX_PAD(0x0224, 0x0074, 5, 0x03D4, 1, 0),
	MX93_PAD_GPIO_IO25__LPSPI7_PCS1                          = IOMUX_PAD(0x0224, 0x0074, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO25__FLEXIO1_FLEXIO25                     = IOMUX_PAD(0x0224, 0x0074, 7, 0x03C4, 0, 0),

	MX93_PAD_GPIO_IO26__GPIO2_IO26                           = IOMUX_PAD(0x0228, 0x0078, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO26__USDHC3_DATA2                         = IOMUX_PAD(0x0228, 0x0078, 1, 0x0468, 0, 0),
	MX93_PAD_GPIO_IO26__PDM_BIT_STREAM01                     = IOMUX_PAD(0x0228, 0x0078, 2, 0x043C, 1, 0),
	MX93_PAD_GPIO_IO26__MEDIAMIX_DISP_DATA22                 = IOMUX_PAD(0x0228, 0x0078, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO26__TPM5_CH3                             = IOMUX_PAD(0x0228, 0x0078, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO26__JTAG_MUX_TDI                         = IOMUX_PAD(0x0228, 0x0078, 5, 0x03D8, 1, 0),
	MX93_PAD_GPIO_IO26__LPSPI8_PCS1                          = IOMUX_PAD(0x0228, 0x0078, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO26__SAI3_TX_SYNC                         = IOMUX_PAD(0x0228, 0x0078, 7, 0x0000, 0, 0),

	MX93_PAD_GPIO_IO27__GPIO2_IO27                           = IOMUX_PAD(0x022C, 0x007C, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO27__USDHC3_DATA3                         = IOMUX_PAD(0x022C, 0x007C, 1, 0x046C, 0, 0),
	MX93_PAD_GPIO_IO27__CAN2_RX                              = IOMUX_PAD(0x022C, 0x007C, 2, 0x0364, 1, 0),
	MX93_PAD_GPIO_IO27__MEDIAMIX_DISP_DATA23                 = IOMUX_PAD(0x022C, 0x007C, 3, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO27__TPM6_CH3                             = IOMUX_PAD(0x022C, 0x007C, 4, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO27__JTAG_MUX_TMS                         = IOMUX_PAD(0x022C, 0x007C, 5, 0x03DC, 1, 0),
	MX93_PAD_GPIO_IO27__LPSPI5_PCS1                          = IOMUX_PAD(0x022C, 0x007C, 6, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO27__FLEXIO1_FLEXIO27                     = IOMUX_PAD(0x022C, 0x007C, 7, 0x03C8, 0, 0),

	MX93_PAD_GPIO_IO28__GPIO2_IO28                           = IOMUX_PAD(0x0230, 0x0080, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO28__LPI2C3_SDA                           = IOMUX_PAD(0x0230, 0x0080, 1 | IOMUX_CONFIG_SION, 0x03E4, 1, 0),
	MX93_PAD_GPIO_IO28__FLEXIO1_FLEXIO28                     = IOMUX_PAD(0x0230, 0x0080, 7, 0x0000, 0, 0),

	MX93_PAD_GPIO_IO29__GPIO2_IO29                           = IOMUX_PAD(0x0234, 0x0084, 0, 0x0000, 0, 0),
	MX93_PAD_GPIO_IO29__LPI2C3_SCL                           = IOMUX_PAD(0x0234, 0x0084, 1 | IOMUX_CONFIG_SION, 0x03E0, 1, 0),
	MX93_PAD_GPIO_IO29__FLEXIO1_FLEXIO29                     = IOMUX_PAD(0x0234, 0x0084, 7, 0x0000, 0, 0),

	MX93_PAD_CCM_CLKO1__CCMSRCGPCMIX_CLKO1                   = IOMUX_PAD(0x0238, 0x0088, 0, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO1__FLEXIO1_FLEXIO26                     = IOMUX_PAD(0x0238, 0x0088, 4, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO1__GPIO3_IO26                           = IOMUX_PAD(0x0238, 0x0088, 5, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO2__GPIO3_IO27                           = IOMUX_PAD(0x023C, 0x008C, 5, 0x0000, 0, 0),

	MX93_PAD_CCM_CLKO2__CCMSRCGPCMIX_CLKO2                   = IOMUX_PAD(0x023C, 0x008C, 0, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO2__FLEXIO1_FLEXIO27                     = IOMUX_PAD(0x023C, 0x008C, 4, 0x03C8, 1, 0),

	MX93_PAD_CCM_CLKO3__CCMSRCGPCMIX_CLKO3                   = IOMUX_PAD(0x0240, 0x0090, 0, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO3__FLEXIO2_FLEXIO28                     = IOMUX_PAD(0x0240, 0x0090, 4, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO3__GPIO4_IO28                           = IOMUX_PAD(0x0240, 0x0090, 5, 0x0000, 0, 0),

	MX93_PAD_CCM_CLKO4__CCMSRCGPCMIX_CLKO4                   = IOMUX_PAD(0x0244, 0x0094, 0, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO4__FLEXIO2_FLEXIO29                     = IOMUX_PAD(0x0244, 0x0094, 4, 0x0000, 0, 0),
	MX93_PAD_CCM_CLKO4__GPIO4_IO29                           = IOMUX_PAD(0x0244, 0x0094, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_MDC__ENET_QOS_MDC                         = IOMUX_PAD(0x0248, 0x0098, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDC__LPUART3_DCB_B                        = IOMUX_PAD(0x0248, 0x0098, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDC__I3C2_SCL                             = IOMUX_PAD(0x0248, 0x0098, 2 | IOMUX_CONFIG_SION, 0x03CC, 0, 0),
	MX93_PAD_ENET1_MDC__HSIOMIX_OTG_ID1                      = IOMUX_PAD(0x0248, 0x0098, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDC__FLEXIO2_FLEXIO00                     = IOMUX_PAD(0x0248, 0x0098, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDC__GPIO4_IO00                           = IOMUX_PAD(0x0248, 0x0098, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_MDIO__ENET_QOS_MDIO                       = IOMUX_PAD(0x024C, 0x009C, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDIO__LPUART3_RIN_B                       = IOMUX_PAD(0x024C, 0x009C, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDIO__I3C2_SDA                            = IOMUX_PAD(0x024C, 0x009C, 2 | IOMUX_CONFIG_SION, 0x03D0, 0, 0),
	MX93_PAD_ENET1_MDIO__HSIOMIX_OTG_PWR1                    = IOMUX_PAD(0x024C, 0x009C, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDIO__FLEXIO2_FLEXIO01                    = IOMUX_PAD(0x024C, 0x009C, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_MDIO__GPIO4_IO01                          = IOMUX_PAD(0x024C, 0x009C, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_TD3__ENET_QOS_RGMII_TD3                   = IOMUX_PAD(0x0250, 0x00A0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD3__CAN2_TX                              = IOMUX_PAD(0x0250, 0x00A0, 2, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD3__HSIOMIX_OTG_ID2                      = IOMUX_PAD(0x0250, 0x00A0, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD3__FLEXIO2_FLEXIO02                     = IOMUX_PAD(0x0250, 0x00A0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD3__GPIO4_IO02                           = IOMUX_PAD(0x0250, 0x00A0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_TD2__ENET_QOS_RGMII_TD2                   = IOMUX_PAD(0x0254, 0x00A4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD2__CCM_ENET_QOS_CLOCK_GENERATE_REF_CLK  = IOMUX_PAD(0x0254, 0x00A4, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD2__CAN2_RX                              = IOMUX_PAD(0x0254, 0x00A4, 2, 0x0364, 2, 0),
	MX93_PAD_ENET1_TD2__HSIOMIX_OTG_OC2                      = IOMUX_PAD(0x0254, 0x00A4, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD2__FLEXIO2_FLEXIO03                     = IOMUX_PAD(0x0254, 0x00A4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD2__GPIO4_IO03                           = IOMUX_PAD(0x0254, 0x00A4, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_TD1__ENET_QOS_RGMII_TD1                   = IOMUX_PAD(0x0258, 0x00A8, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__LPUART3_RTS_B                        = IOMUX_PAD(0x0258, 0x00A8, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__I3C2_PUR                             = IOMUX_PAD(0x0258, 0x00A8, 2, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__HSIOMIX_OTG_OC1                      = IOMUX_PAD(0x0258, 0x00A8, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__FLEXIO2_FLEXIO04                     = IOMUX_PAD(0x0258, 0x00A8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__GPIO4_IO04                           = IOMUX_PAD(0x0258, 0x00A8, 5, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD1__I3C2_PUR_B                           = IOMUX_PAD(0x0258, 0x00A8, 6, 0x0000, 0, 0),

	MX93_PAD_ENET1_TD0__ENET_QOS_RGMII_TD0                   = IOMUX_PAD(0x025C, 0x00AC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD0__LPUART3_TX                           = IOMUX_PAD(0x025C, 0x00AC, 1, 0x041C, 1, 0),
	MX93_PAD_ENET1_TD0__FLEXIO2_FLEXIO05                     = IOMUX_PAD(0x025C, 0x00AC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TD0__GPIO4_IO05                           = IOMUX_PAD(0x025C, 0x00AC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_TX_CTL__ENET_QOS_RGMII_TX_CTL             = IOMUX_PAD(0x0260, 0x00B0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TX_CTL__LPUART3_DTR_B                     = IOMUX_PAD(0x0260, 0x00B0, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_TX_CTL__FLEXIO2_FLEXIO06                  = IOMUX_PAD(0x0260, 0x00B0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TX_CTL__GPIO4_IO06                        = IOMUX_PAD(0x0260, 0x00B0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_TXC__CCM_ENET_QOS_CLOCK_GENERATE_TX_CLK   = IOMUX_PAD(0x0264, 0x00B4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_TXC__ENET_QOS_TX_ER                       = IOMUX_PAD(0x0264, 0x00B4, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_TXC__FLEXIO2_FLEXIO07                     = IOMUX_PAD(0x0264, 0x00B4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_TXC__GPIO4_IO07                           = IOMUX_PAD(0x0264, 0x00B4, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RX_CTL__ENET_QOS_RGMII_RX_CTL             = IOMUX_PAD(0x0268, 0x00B8, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RX_CTL__LPUART3_DSR_B                     = IOMUX_PAD(0x0268, 0x00B8, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_RX_CTL__HSIOMIX_OTG_PWR2                  = IOMUX_PAD(0x0268, 0x00B8, 3, 0x0000, 0, 0),
	MX93_PAD_ENET1_RX_CTL__FLEXIO2_FLEXIO08                  = IOMUX_PAD(0x0268, 0x00B8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RX_CTL__GPIO4_IO08                        = IOMUX_PAD(0x0268, 0x00B8, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RXC__CCM_ENET_QOS_CLOCK_GENERATE_RX_CLK   = IOMUX_PAD(0x026C, 0x00BC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RXC__ENET_QOS_RX_ER                       = IOMUX_PAD(0x026C, 0x00BC, 1, 0x0000, 0, 0),
	MX93_PAD_ENET1_RXC__FLEXIO2_FLEXIO09                     = IOMUX_PAD(0x026C, 0x00BC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RXC__GPIO4_IO09                           = IOMUX_PAD(0x026C, 0x00BC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RD0__ENET_QOS_RGMII_RD0                   = IOMUX_PAD(0x0270, 0x00C0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD0__LPUART3_RX                           = IOMUX_PAD(0x0270, 0x00C0, 1, 0x0418, 1, 0),
	MX93_PAD_ENET1_RD0__FLEXIO2_FLEXIO10                     = IOMUX_PAD(0x0270, 0x00C0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD0__GPIO4_IO10                           = IOMUX_PAD(0x0270, 0x00C0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RD1__ENET_QOS_RGMII_RD1                   = IOMUX_PAD(0x0274, 0x00C4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD1__LPUART3_CTS_B                        = IOMUX_PAD(0x0274, 0x00C4, 1, 0x0414, 1, 0),
	MX93_PAD_ENET1_RD1__LPTMR2_ALT1                          = IOMUX_PAD(0x0274, 0x00C4, 3, 0x0408, 0, 0),
	MX93_PAD_ENET1_RD1__FLEXIO2_FLEXIO11                     = IOMUX_PAD(0x0274, 0x00C4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD1__GPIO4_IO11                           = IOMUX_PAD(0x0274, 0x00C4, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RD2__ENET_QOS_RGMII_RD2                   = IOMUX_PAD(0x0278, 0x00C8, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD2__LPTMR2_ALT2                          = IOMUX_PAD(0x0278, 0x00C8, 3, 0x040C, 0, 0),
	MX93_PAD_ENET1_RD2__FLEXIO2_FLEXIO12                     = IOMUX_PAD(0x0278, 0x00C8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD2__GPIO4_IO12                           = IOMUX_PAD(0x0278, 0x00C8, 5, 0x0000, 0, 0),

	MX93_PAD_ENET1_RD3__ENET_QOS_RGMII_RD3                   = IOMUX_PAD(0x027C, 0x00CC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD3__FLEXSPI1_TESTER_TRIGGER              = IOMUX_PAD(0x027C, 0x00CC, 2, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD3__LPTMR2_ALT3                          = IOMUX_PAD(0x027C, 0x00CC, 3, 0x0410, 0, 0),
	MX93_PAD_ENET1_RD3__FLEXIO2_FLEXIO13                     = IOMUX_PAD(0x027C, 0x00CC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET1_RD3__GPIO4_IO13                           = IOMUX_PAD(0x027C, 0x00CC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_MDC__ENET1_MDC                            = IOMUX_PAD(0x0280, 0x00D0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDC__LPUART4_DCB_B                        = IOMUX_PAD(0x0280, 0x00D0, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDC__SAI2_RX_SYNC                         = IOMUX_PAD(0x0280, 0x00D0, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDC__FLEXIO2_FLEXIO14                     = IOMUX_PAD(0x0280, 0x00D0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDC__GPIO4_IO14                           = IOMUX_PAD(0x0280, 0x00D0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_MDIO__ENET1_MDIO                          = IOMUX_PAD(0x0284, 0x00D4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDIO__LPUART4_RIN_B                       = IOMUX_PAD(0x0284, 0x00D4, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDIO__SAI2_RX_BCLK                        = IOMUX_PAD(0x0284, 0x00D4, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDIO__FLEXIO2_FLEXIO15                    = IOMUX_PAD(0x0284, 0x00D4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_MDIO__GPIO4_IO15                          = IOMUX_PAD(0x0284, 0x00D4, 5, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD3__SAI2_RX_DATA00                       = IOMUX_PAD(0x0288, 0x00D8, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD3__FLEXIO2_FLEXIO16                     = IOMUX_PAD(0x0288, 0x00D8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD3__GPIO4_IO16                           = IOMUX_PAD(0x0288, 0x00D8, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_TD3__ENET1_RGMII_TD3                      = IOMUX_PAD(0x0288, 0x00D8, 0, 0x0000, 0, 0),

	MX93_PAD_ENET2_TD2__ENET1_RGMII_TD2                      = IOMUX_PAD(0x028C, 0x00DC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD2__ENET1_TX_CLK                         = IOMUX_PAD(0x028C, 0x00DC, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD2__SAI2_RX_DATA01                       = IOMUX_PAD(0x028C, 0x00DC, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD2__FLEXIO2_FLEXIO17                     = IOMUX_PAD(0x028C, 0x00DC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD2__GPIO4_IO17                           = IOMUX_PAD(0x028C, 0x00DC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_TD1__ENET1_RGMII_TD1                      = IOMUX_PAD(0x0290, 0x00E0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD1__LPUART4_RTS_B                        = IOMUX_PAD(0x0290, 0x00E0, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD1__SAI2_RX_DATA02                       = IOMUX_PAD(0x0290, 0x00E0, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD1__FLEXIO2_FLEXIO18                     = IOMUX_PAD(0x0290, 0x00E0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD1__GPIO4_IO18                           = IOMUX_PAD(0x0290, 0x00E0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_TD0__ENET1_RGMII_TD0                      = IOMUX_PAD(0x0294, 0x00E4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD0__LPUART4_TX                           = IOMUX_PAD(0x0294, 0x00E4, 1, 0x0428, 1, 0),
	MX93_PAD_ENET2_TD0__SAI2_RX_DATA03                       = IOMUX_PAD(0x0294, 0x00E4, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD0__FLEXIO2_FLEXIO19                     = IOMUX_PAD(0x0294, 0x00E4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TD0__GPIO4_IO19                           = IOMUX_PAD(0x0294, 0x00E4, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_TX_CTL__ENET1_RGMII_TX_CTL                = IOMUX_PAD(0x0298, 0x00E8, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_TX_CTL__LPUART4_DTR_B                     = IOMUX_PAD(0x0298, 0x00E8, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_TX_CTL__SAI2_TX_SYNC                      = IOMUX_PAD(0x0298, 0x00E8, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TX_CTL__FLEXIO2_FLEXIO20                  = IOMUX_PAD(0x0298, 0x00E8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TX_CTL__GPIO4_IO20                        = IOMUX_PAD(0x0298, 0x00E8, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_TXC__ENET1_RGMII_TXC                      = IOMUX_PAD(0x029C, 0x00EC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_TXC__ENET1_TX_ER                          = IOMUX_PAD(0x029C, 0x00EC, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_TXC__SAI2_TX_BCLK                         = IOMUX_PAD(0x029C, 0x00EC, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_TXC__FLEXIO2_FLEXIO21                     = IOMUX_PAD(0x029C, 0x00EC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_TXC__GPIO4_IO21                           = IOMUX_PAD(0x029C, 0x00EC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RX_CTL__ENET1_RGMII_RX_CTL                = IOMUX_PAD(0x02A0, 0x00F0, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RX_CTL__LPUART4_DSR_B                     = IOMUX_PAD(0x02A0, 0x00F0, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_RX_CTL__SAI2_TX_DATA00                    = IOMUX_PAD(0x02A0, 0x00F0, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_RX_CTL__FLEXIO2_FLEXIO22                  = IOMUX_PAD(0x02A0, 0x00F0, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RX_CTL__GPIO4_IO22                        = IOMUX_PAD(0x02A0, 0x00F0, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RXC__ENET1_RGMII_RXC                      = IOMUX_PAD(0x02A4, 0x00F4, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RXC__ENET1_RX_ER                          = IOMUX_PAD(0x02A4, 0x00F4, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_RXC__SAI2_TX_DATA01                       = IOMUX_PAD(0x02A4, 0x00F4, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_RXC__FLEXIO2_FLEXIO23                     = IOMUX_PAD(0x02A4, 0x00F4, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RXC__GPIO4_IO23                           = IOMUX_PAD(0x02A4, 0x00F4, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RD0__ENET1_RGMII_RD0                      = IOMUX_PAD(0x02A8, 0x00F8, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD0__LPUART4_RX                           = IOMUX_PAD(0x02A8, 0x00F8, 1, 0x0424, 1, 0),
	MX93_PAD_ENET2_RD0__SAI2_TX_DATA02                       = IOMUX_PAD(0x02A8, 0x00F8, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD0__FLEXIO2_FLEXIO24                     = IOMUX_PAD(0x02A8, 0x00F8, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD0__GPIO4_IO24                           = IOMUX_PAD(0x02A8, 0x00F8, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RD1__ENET1_RGMII_RD1                      = IOMUX_PAD(0x02AC, 0x00FC, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD1__SPDIF_IN                             = IOMUX_PAD(0x02AC, 0x00FC, 1, 0x0454, 1, 0),
	MX93_PAD_ENET2_RD1__SAI2_TX_DATA03                       = IOMUX_PAD(0x02AC, 0x00FC, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD1__FLEXIO2_FLEXIO25                     = IOMUX_PAD(0x02AC, 0x00FC, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD1__GPIO4_IO25                           = IOMUX_PAD(0x02AC, 0x00FC, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RD2__ENET1_RGMII_RD2                      = IOMUX_PAD(0x02B0, 0x0100, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD2__LPUART4_CTS_B                        = IOMUX_PAD(0x02B0, 0x0100, 1, 0x0420, 1, 0),
	MX93_PAD_ENET2_RD2__SAI2_MCLK                            = IOMUX_PAD(0x02B0, 0x0100, 2, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD2__MQS2_RIGHT                           = IOMUX_PAD(0x02B0, 0x0100, 3, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD2__FLEXIO2_FLEXIO26                     = IOMUX_PAD(0x02B0, 0x0100, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD2__GPIO4_IO26                           = IOMUX_PAD(0x02B0, 0x0100, 5, 0x0000, 0, 0),

	MX93_PAD_ENET2_RD3__ENET1_RGMII_RD3                      = IOMUX_PAD(0x02B4, 0x0104, 0, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD3__SPDIF_OUT                            = IOMUX_PAD(0x02B4, 0x0104, 1, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD3__SPDIF_IN                             = IOMUX_PAD(0x02B4, 0x0104, 2, 0x0454, 2, 0),
	MX93_PAD_ENET2_RD3__MQS2_LEFT                            = IOMUX_PAD(0x02B4, 0x0104, 3, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD3__FLEXIO2_FLEXIO27                     = IOMUX_PAD(0x02B4, 0x0104, 4, 0x0000, 0, 0),
	MX93_PAD_ENET2_RD3__GPIO4_IO27                           = IOMUX_PAD(0x02B4, 0x0104, 5, 0x0000, 0, 0),
	MX93_PAD_SD1_CLK__FLEXIO1_FLEXIO08                       = IOMUX_PAD(0x02B8, 0x0108, 4, 0x038C, 1, 0),
	MX93_PAD_SD1_CLK__GPIO3_IO08                             = IOMUX_PAD(0x02B8, 0x0108, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_CLK__USDHC1_CLK                             = IOMUX_PAD(0x02B8, 0x0108, 0, 0x0000, 0, 0),

	MX93_PAD_SD1_CMD__USDHC1_CMD                             = IOMUX_PAD(0x02BC, 0x010C, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_CMD__FLEXIO1_FLEXIO09                       = IOMUX_PAD(0x02BC, 0x010C, 4, 0x0390, 1, 0),
	MX93_PAD_SD1_CMD__GPIO3_IO09                             = IOMUX_PAD(0x02BC, 0x010C, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA0__USDHC1_DATA0                         = IOMUX_PAD(0x02C0, 0x0110, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA0__FLEXIO1_FLEXIO10                     = IOMUX_PAD(0x02C0, 0x0110, 4, 0x0394, 1, 0),
	MX93_PAD_SD1_DATA0__GPIO3_IO10                           = IOMUX_PAD(0x02C0, 0x0110, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA1__USDHC1_DATA1                         = IOMUX_PAD(0x02C4, 0x0114, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA1__FLEXIO1_FLEXIO11                     = IOMUX_PAD(0x02C4, 0x0114, 4, 0x0398, 1, 0),
	MX93_PAD_SD1_DATA1__GPIO3_IO11                           = IOMUX_PAD(0x02C4, 0x0114, 5, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA1__CCMSRCGPCMIX_INT_BOOT                = IOMUX_PAD(0x02C4, 0x0114, 6, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA2__USDHC1_DATA2                         = IOMUX_PAD(0x02C8, 0x0118, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA2__FLEXIO1_FLEXIO12                     = IOMUX_PAD(0x02C8, 0x0118, 4, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA2__GPIO3_IO12                           = IOMUX_PAD(0x02C8, 0x0118, 5, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA2__CCMSRCGPCMIX_PMIC_READY              = IOMUX_PAD(0x02C8, 0x0118, 6, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA3__USDHC1_DATA3                         = IOMUX_PAD(0x02CC, 0x011C, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA3__FLEXSPI1_A_SS1_B                     = IOMUX_PAD(0x02CC, 0x011C, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA3__FLEXIO1_FLEXIO13                     = IOMUX_PAD(0x02CC, 0x011C, 4, 0x039C, 1, 0),
	MX93_PAD_SD1_DATA3__GPIO3_IO13                           = IOMUX_PAD(0x02CC, 0x011C, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA4__USDHC1_DATA4                         = IOMUX_PAD(0x02D0, 0x0120, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA4__FLEXSPI1_A_DATA04                    = IOMUX_PAD(0x02D0, 0x0120, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA4__FLEXIO1_FLEXIO14                     = IOMUX_PAD(0x02D0, 0x0120, 4, 0x03A0, 1, 0),
	MX93_PAD_SD1_DATA4__GPIO3_IO14                           = IOMUX_PAD(0x02D0, 0x0120, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA5__USDHC1_DATA5                         = IOMUX_PAD(0x02D4, 0x0124, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA5__FLEXSPI1_A_DATA05                    = IOMUX_PAD(0x02D4, 0x0124, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA5__USDHC1_RESET_B                       = IOMUX_PAD(0x02D4, 0x0124, 2, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA5__FLEXIO1_FLEXIO15                     = IOMUX_PAD(0x02D4, 0x0124, 4, 0x03A4, 1, 0),
	MX93_PAD_SD1_DATA5__GPIO3_IO15                           = IOMUX_PAD(0x02D4, 0x0124, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA6__USDHC1_DATA6                         = IOMUX_PAD(0x02D8, 0x0128, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA6__FLEXSPI1_A_DATA06                    = IOMUX_PAD(0x02D8, 0x0128, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA6__USDHC1_CD_B                          = IOMUX_PAD(0x02D8, 0x0128, 2, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA6__FLEXIO1_FLEXIO16                     = IOMUX_PAD(0x02D8, 0x0128, 4, 0x03A8, 1, 0),
	MX93_PAD_SD1_DATA6__GPIO3_IO16                           = IOMUX_PAD(0x02D8, 0x0128, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_DATA7__USDHC1_DATA7                         = IOMUX_PAD(0x02DC, 0x012C, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA7__FLEXSPI1_A_DATA07                    = IOMUX_PAD(0x02DC, 0x012C, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA7__USDHC1_WP                            = IOMUX_PAD(0x02DC, 0x012C, 2, 0x0000, 0, 0),
	MX93_PAD_SD1_DATA7__FLEXIO1_FLEXIO17                     = IOMUX_PAD(0x02DC, 0x012C, 4, 0x03AC, 1, 0),
	MX93_PAD_SD1_DATA7__GPIO3_IO17                           = IOMUX_PAD(0x02DC, 0x012C, 5, 0x0000, 0, 0),

	MX93_PAD_SD1_STROBE__USDHC1_STROBE                       = IOMUX_PAD(0x02E0, 0x0130, 0, 0x0000, 0, 0),
	MX93_PAD_SD1_STROBE__FLEXSPI1_A_DQS                      = IOMUX_PAD(0x02E0, 0x0130, 1, 0x0000, 0, 0),
	MX93_PAD_SD1_STROBE__FLEXIO1_FLEXIO18                    = IOMUX_PAD(0x02E0, 0x0130, 4, 0x03B0, 1, 0),
	MX93_PAD_SD1_STROBE__GPIO3_IO18                          = IOMUX_PAD(0x02E0, 0x0130, 5, 0x0000, 0, 0),

	MX93_PAD_SD2_VSELECT__USDHC2_VSELECT                     = IOMUX_PAD(0x02E4, 0x0134, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_VSELECT__USDHC2_WP                          = IOMUX_PAD(0x02E4, 0x0134, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_VSELECT__LPTMR2_ALT3                        = IOMUX_PAD(0x02E4, 0x0134, 2, 0x0410, 1, 0),
	MX93_PAD_SD2_VSELECT__FLEXIO1_FLEXIO19                   = IOMUX_PAD(0x02E4, 0x0134, 4, 0x0000, 0, 0),
	MX93_PAD_SD2_VSELECT__GPIO3_IO19                         = IOMUX_PAD(0x02E4, 0x0134, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_VSELECT__CCMSRCGPCMIX_EXT_CLK1              = IOMUX_PAD(0x02E4, 0x0134, 6, 0x0368, 0, 0),

	MX93_PAD_SD3_CLK__USDHC3_CLK                             = IOMUX_PAD(0x02E8, 0x0138, 0, 0x0458, 1, 0),
	MX93_PAD_SD3_CLK__FLEXSPI1_A_SCLK                        = IOMUX_PAD(0x02E8, 0x0138, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_CLK__FLEXIO1_FLEXIO20                       = IOMUX_PAD(0x02E8, 0x0138, 4, 0x03B4, 1, 0),
	MX93_PAD_SD3_CLK__GPIO3_IO20                             = IOMUX_PAD(0x02E8, 0x0138, 5, 0x0000, 0, 0),

	MX93_PAD_SD3_CMD__USDHC3_CMD                             = IOMUX_PAD(0x02EC, 0x013C, 0, 0x045C, 1, 0),
	MX93_PAD_SD3_CMD__FLEXSPI1_A_SS0_B                       = IOMUX_PAD(0x02EC, 0x013C, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_CMD__FLEXIO1_FLEXIO21                       = IOMUX_PAD(0x02EC, 0x013C, 4, 0x0000, 0, 0),
	MX93_PAD_SD3_CMD__GPIO3_IO21                             = IOMUX_PAD(0x02EC, 0x013C, 5, 0x0000, 0, 0),

	MX93_PAD_SD3_DATA0__USDHC3_DATA0                         = IOMUX_PAD(0x02F0, 0x0140, 0, 0x0460, 1, 0),
	MX93_PAD_SD3_DATA0__FLEXSPI1_A_DATA00                    = IOMUX_PAD(0x02F0, 0x0140, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_DATA0__FLEXIO1_FLEXIO22                     = IOMUX_PAD(0x02F0, 0x0140, 4, 0x03B8, 1, 0),
	MX93_PAD_SD3_DATA0__GPIO3_IO22                           = IOMUX_PAD(0x02F0, 0x0140, 5, 0x0000, 0, 0),

	MX93_PAD_SD3_DATA1__USDHC3_DATA1                         = IOMUX_PAD(0x02F4, 0x0144, 0, 0x0464, 1, 0),
	MX93_PAD_SD3_DATA1__FLEXSPI1_A_DATA01                    = IOMUX_PAD(0x02F4, 0x0144, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_DATA1__FLEXIO1_FLEXIO23                     = IOMUX_PAD(0x02F4, 0x0144, 4, 0x03BC, 1, 0),
	MX93_PAD_SD3_DATA1__GPIO3_IO23                           = IOMUX_PAD(0x02F4, 0x0144, 5, 0x0000, 0, 0),

	MX93_PAD_SD3_DATA2__USDHC3_DATA2                         = IOMUX_PAD(0x02F8, 0x0148, 0, 0x0468, 1, 0),
	MX93_PAD_SD3_DATA2__FLEXSPI1_A_DATA02                    = IOMUX_PAD(0x02F8, 0x0148, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_DATA2__FLEXIO1_FLEXIO24                     = IOMUX_PAD(0x02F8, 0x0148, 4, 0x03C0, 1, 0),
	MX93_PAD_SD3_DATA2__GPIO3_IO24                           = IOMUX_PAD(0x02F8, 0x0148, 5, 0x0000, 0, 0),

	MX93_PAD_SD3_DATA3__USDHC3_DATA3                         = IOMUX_PAD(0x02FC, 0x014C, 0, 0x046C, 1, 0),
	MX93_PAD_SD3_DATA3__FLEXSPI1_A_DATA03                    = IOMUX_PAD(0x02FC, 0x014C, 1, 0x0000, 0, 0),
	MX93_PAD_SD3_DATA3__FLEXIO1_FLEXIO25                     = IOMUX_PAD(0x02FC, 0x014C, 4, 0x03C4, 1, 0),
	MX93_PAD_SD3_DATA3__GPIO3_IO25                           = IOMUX_PAD(0x02FC, 0x014C, 5, 0x0000, 0, 0),

	MX93_PAD_SD2_CD_B__USDHC2_CD_B                           = IOMUX_PAD(0x0300, 0x0150, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_CD_B__ENET_QOS_1588_EVENT0_IN               = IOMUX_PAD(0x0300, 0x0150, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_CD_B__I3C2_SCL                              = IOMUX_PAD(0x0300, 0x0150, 2 | IOMUX_CONFIG_SION, 0x03CC, 1, 0),
	MX93_PAD_SD2_CD_B__FLEXIO1_FLEXIO00                      = IOMUX_PAD(0x0300, 0x0150, 4, 0x036C, 1, 0),
	MX93_PAD_SD2_CD_B__GPIO3_IO00                            = IOMUX_PAD(0x0300, 0x0150, 5, 0x0000, 0, 0),

	MX93_PAD_SD2_CLK__USDHC2_CLK                             = IOMUX_PAD(0x0304, 0x0154, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_CLK__ENET_QOS_1588_EVENT0_OUT               = IOMUX_PAD(0x0304, 0x0154, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_CLK__I3C2_SDA                               = IOMUX_PAD(0x0304, 0x0154, 2 | IOMUX_CONFIG_SION, 0x03D0, 1, 0),
	MX93_PAD_SD2_CLK__FLEXIO1_FLEXIO01                       = IOMUX_PAD(0x0304, 0x0154, 4, 0x0370, 1, 0),
	MX93_PAD_SD2_CLK__GPIO3_IO01                             = IOMUX_PAD(0x0304, 0x0154, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_CLK__CCMSRCGPCMIX_OBSERVE0                  = IOMUX_PAD(0x0304, 0x0154, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_CMD__USDHC2_CMD                             = IOMUX_PAD(0x0308, 0x0158, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_CMD__ENET1_1588_EVENT0_IN                   = IOMUX_PAD(0x0308, 0x0158, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_CMD__I3C2_PUR                               = IOMUX_PAD(0x0308, 0x0158, 2, 0x0000, 0, 0),
	MX93_PAD_SD2_CMD__I3C2_PUR_B                             = IOMUX_PAD(0x0308, 0x0158, 3, 0x0000, 0, 0),
	MX93_PAD_SD2_CMD__FLEXIO1_FLEXIO02                       = IOMUX_PAD(0x0308, 0x0158, 4, 0x0374, 1, 0),
	MX93_PAD_SD2_CMD__GPIO3_IO02                             = IOMUX_PAD(0x0308, 0x0158, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_CMD__CCMSRCGPCMIX_OBSERVE1                  = IOMUX_PAD(0x0308, 0x0158, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_DATA0__USDHC2_DATA0                         = IOMUX_PAD(0x030C, 0x015C, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA0__ENET1_1588_EVENT0_OUT                = IOMUX_PAD(0x030C, 0x015C, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA0__CAN2_TX                              = IOMUX_PAD(0x030C, 0x015C, 2, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA0__FLEXIO1_FLEXIO03                     = IOMUX_PAD(0x030C, 0x015C, 4, 0x0378, 1, 0),
	MX93_PAD_SD2_DATA0__GPIO3_IO03                           = IOMUX_PAD(0x030C, 0x015C, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA0__CCMSRCGPCMIX_OBSERVE2                = IOMUX_PAD(0x030C, 0x015C, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_DATA1__USDHC2_DATA1                         = IOMUX_PAD(0x0310, 0x0160, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA1__ENET1_1588_EVENT1_IN                 = IOMUX_PAD(0x0310, 0x0160, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA1__CAN2_RX                              = IOMUX_PAD(0x0310, 0x0160, 2, 0x0364, 3, 0),
	MX93_PAD_SD2_DATA1__FLEXIO1_FLEXIO04                     = IOMUX_PAD(0x0310, 0x0160, 4, 0x037C, 1, 0),
	MX93_PAD_SD2_DATA1__GPIO3_IO04                           = IOMUX_PAD(0x0310, 0x0160, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA1__CCMSRCGPCMIX_WAIT                    = IOMUX_PAD(0x0310, 0x0160, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_DATA2__USDHC2_DATA2                         = IOMUX_PAD(0x0314, 0x0164, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA2__ENET1_1588_EVENT1_OUT                = IOMUX_PAD(0x0314, 0x0164, 1, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA2__MQS2_RIGHT                           = IOMUX_PAD(0x0314, 0x0164, 2, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA2__FLEXIO1_FLEXIO05                     = IOMUX_PAD(0x0314, 0x0164, 4, 0x0380, 1, 0),
	MX93_PAD_SD2_DATA2__GPIO3_IO05                           = IOMUX_PAD(0x0314, 0x0164, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA2__CCMSRCGPCMIX_STOP                    = IOMUX_PAD(0x0314, 0x0164, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_DATA3__USDHC2_DATA3                         = IOMUX_PAD(0x0318, 0x0168, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA3__LPTMR2_ALT1                          = IOMUX_PAD(0x0318, 0x0168, 1, 0x0408, 1, 0),
	MX93_PAD_SD2_DATA3__MQS2_LEFT                            = IOMUX_PAD(0x0318, 0x0168, 2, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA3__FLEXIO1_FLEXIO06                     = IOMUX_PAD(0x0318, 0x0168, 4, 0x0384, 1, 0),
	MX93_PAD_SD2_DATA3__GPIO3_IO06                           = IOMUX_PAD(0x0318, 0x0168, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_DATA3__CCMSRCGPCMIX_EARLY_RESET             = IOMUX_PAD(0x0318, 0x0168, 6, 0x0000, 0, 0),

	MX93_PAD_SD2_RESET_B__USDHC2_RESET_B                     = IOMUX_PAD(0x031C, 0x016C, 0, 0x0000, 0, 0),
	MX93_PAD_SD2_RESET_B__LPTMR2_ALT2                        = IOMUX_PAD(0x031C, 0x016C, 1, 0x040C, 1, 0),
	MX93_PAD_SD2_RESET_B__FLEXIO1_FLEXIO07                   = IOMUX_PAD(0x031C, 0x016C, 4, 0x0388, 1, 0),
	MX93_PAD_SD2_RESET_B__GPIO3_IO07                         = IOMUX_PAD(0x031C, 0x016C, 5, 0x0000, 0, 0),
	MX93_PAD_SD2_RESET_B__CCMSRCGPCMIX_SYSTEM_RESET          = IOMUX_PAD(0x031C, 0x016C, 6, 0x0000, 0, 0),

	MX93_PAD_I2C1_SCL__LPI2C1_SCL                            = IOMUX_PAD(0x0320, 0x0170, 0 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C1_SCL__I3C1_SCL                              = IOMUX_PAD(0x0320, 0x0170, 1 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C1_SCL__LPUART1_DCB_B                         = IOMUX_PAD(0x0320, 0x0170, 2, 0x0000, 0, 0),
	MX93_PAD_I2C1_SCL__TPM2_CH0                              = IOMUX_PAD(0x0320, 0x0170, 3, 0x0000, 0, 0),
	MX93_PAD_I2C1_SCL__GPIO1_IO00                            = IOMUX_PAD(0x0320, 0x0170, 5, 0x0000, 0, 0),

	MX93_PAD_I2C1_SDA__LPI2C1_SDA                            = IOMUX_PAD(0x0324, 0x0174, 0 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C1_SDA__I3C1_SDA                              = IOMUX_PAD(0x0324, 0x0174, 1 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C1_SDA__LPUART1_RIN_B                         = IOMUX_PAD(0x0324, 0x0174, 2, 0x0000, 0, 0),
	MX93_PAD_I2C1_SDA__TPM2_CH1                              = IOMUX_PAD(0x0324, 0x0174, 3, 0x0000, 0, 0),
	MX93_PAD_I2C1_SDA__GPIO1_IO01                            = IOMUX_PAD(0x0324, 0x0174, 5, 0x0000, 0, 0),

	MX93_PAD_I2C2_SCL__LPI2C2_SCL                            = IOMUX_PAD(0x0328, 0x0178, 0 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__I3C1_PUR                              = IOMUX_PAD(0x0328, 0x0178, 1, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__LPUART2_DCB_B                         = IOMUX_PAD(0x0328, 0x0178, 2, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__TPM2_CH2                              = IOMUX_PAD(0x0328, 0x0178, 3, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__SAI1_RX_SYNC                          = IOMUX_PAD(0x0328, 0x0178, 4, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__GPIO1_IO02                            = IOMUX_PAD(0x0328, 0x0178, 5, 0x0000, 0, 0),
	MX93_PAD_I2C2_SCL__I3C1_PUR_B                            = IOMUX_PAD(0x0328, 0x0178, 6, 0x0000, 0, 0),

	MX93_PAD_I2C2_SDA__LPI2C2_SDA                            = IOMUX_PAD(0x032C, 0x017C, 0 | IOMUX_CONFIG_SION, 0x0000, 0, 0),
	MX93_PAD_I2C2_SDA__LPUART2_RIN_B                         = IOMUX_PAD(0x032C, 0x017C, 2, 0x0000, 0, 0),
	MX93_PAD_I2C2_SDA__TPM2_CH3                              = IOMUX_PAD(0x032C, 0x017C, 3, 0x0000, 0, 0),
	MX93_PAD_I2C2_SDA__SAI1_RX_BCLK                          = IOMUX_PAD(0x032C, 0x017C, 4, 0x0000, 0, 0),
	MX93_PAD_I2C2_SDA__GPIO1_IO03                            = IOMUX_PAD(0x032C, 0x017C, 5, 0x0000, 0, 0),

	MX93_PAD_UART1_RXD__LPUART1_RX                           = IOMUX_PAD(0x0330, 0x0180, 0, 0x0000, 0, 0),
	MX93_PAD_UART1_RXD__S400_UART_RX                         = IOMUX_PAD(0x0330, 0x0180, 1, 0x0000, 0, 0),
	MX93_PAD_UART1_RXD__LPSPI2_SIN                           = IOMUX_PAD(0x0330, 0x0180, 2, 0x0000, 0, 0),
	MX93_PAD_UART1_RXD__TPM1_CH0                             = IOMUX_PAD(0x0330, 0x0180, 3, 0x0000, 0, 0),
	MX93_PAD_UART1_RXD__GPIO1_IO04                           = IOMUX_PAD(0x0330, 0x0180, 5, 0x0000, 0, 0),

	MX93_PAD_UART1_TXD__LPUART1_TX                           = IOMUX_PAD(0x0334, 0x0184, 0, 0x0000, 0, 0),
	MX93_PAD_UART1_TXD__S400_UART_TX                         = IOMUX_PAD(0x0334, 0x0184, 1, 0x0000, 0, 0),
	MX93_PAD_UART1_TXD__LPSPI2_PCS0                          = IOMUX_PAD(0x0334, 0x0184, 2, 0x0000, 0, 0),
	MX93_PAD_UART1_TXD__TPM1_CH1                             = IOMUX_PAD(0x0334, 0x0184, 3, 0x0000, 0, 0),
	MX93_PAD_UART1_TXD__GPIO1_IO05                           = IOMUX_PAD(0x0334, 0x0184, 5, 0x0000, 0, 0),

	MX93_PAD_UART2_RXD__LPUART2_RX                           = IOMUX_PAD(0x0338, 0x0188, 0, 0x0000, 0, 0),
	MX93_PAD_UART2_RXD__LPUART1_CTS_B                        = IOMUX_PAD(0x0338, 0x0188, 1, 0x0000, 0, 0),
	MX93_PAD_UART2_RXD__LPSPI2_SOUT                          = IOMUX_PAD(0x0338, 0x0188, 2, 0x0000, 0, 0),
	MX93_PAD_UART2_RXD__TPM1_CH2                             = IOMUX_PAD(0x0338, 0x0188, 3, 0x0000, 0, 0),
	MX93_PAD_UART2_RXD__SAI1_MCLK                            = IOMUX_PAD(0x0338, 0x0188, 4, 0x0448, 0, 0),
	MX93_PAD_UART2_RXD__GPIO1_IO06                           = IOMUX_PAD(0x0338, 0x0188, 5, 0x0000, 0, 0),

	MX93_PAD_UART2_TXD__LPUART2_TX                           = IOMUX_PAD(0x033C, 0x018C, 0, 0x0000, 0, 0),
	MX93_PAD_UART2_TXD__LPUART1_RTS_B                        = IOMUX_PAD(0x033C, 0x018C, 1, 0x0000, 0, 0),
	MX93_PAD_UART2_TXD__LPSPI2_SCK                           = IOMUX_PAD(0x033C, 0x018C, 2, 0x0000, 0, 0),
	MX93_PAD_UART2_TXD__TPM1_CH3                             = IOMUX_PAD(0x033C, 0x018C, 3, 0x0000, 0, 0),
	MX93_PAD_UART2_TXD__GPIO1_IO07                           = IOMUX_PAD(0x033C, 0x018C, 5, 0x0000, 0, 0),

	MX93_PAD_PDM_CLK__PDM_CLK                                = IOMUX_PAD(0x0340, 0x0190, 0, 0x0000, 0, 0),
	MX93_PAD_PDM_CLK__MQS1_LEFT                              = IOMUX_PAD(0x0340, 0x0190, 1, 0x0000, 0, 0),
	MX93_PAD_PDM_CLK__LPTMR1_ALT1                            = IOMUX_PAD(0x0340, 0x0190, 4, 0x0000, 0, 0),
	MX93_PAD_PDM_CLK__GPIO1_IO08                             = IOMUX_PAD(0x0340, 0x0190, 5, 0x0000, 0, 0),
	MX93_PAD_PDM_CLK__CAN1_TX                                = IOMUX_PAD(0x0340, 0x0190, 6, 0x0000, 0, 0),

	MX93_PAD_PDM_BIT_STREAM0__PDM_BIT_STREAM00               = IOMUX_PAD(0x0344, 0x0194, 0, 0x0438, 2, 0),
	MX93_PAD_PDM_BIT_STREAM0__MQS1_RIGHT                     = IOMUX_PAD(0x0344, 0x0194, 1, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM0__LPSPI1_PCS1                    = IOMUX_PAD(0x0344, 0x0194, 2, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM0__TPM1_EXTCLK                    = IOMUX_PAD(0x0344, 0x0194, 3, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM0__LPTMR1_ALT2                    = IOMUX_PAD(0x0344, 0x0194, 4, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM0__GPIO1_IO09                     = IOMUX_PAD(0x0344, 0x0194, 5, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM0__CAN1_RX                        = IOMUX_PAD(0x0344, 0x0194, 6, 0x0360, 0, 0),

	MX93_PAD_PDM_BIT_STREAM1__PDM_BIT_STREAM01               = IOMUX_PAD(0x0348, 0x0198, 0, 0x043C, 2, 0),
	MX93_PAD_PDM_BIT_STREAM1__NMI_GLUE_NMI                   = IOMUX_PAD(0x0348, 0x0198, 1, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM1__LPSPI2_PCS1                    = IOMUX_PAD(0x0348, 0x0198, 2, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM1__TPM2_EXTCLK                    = IOMUX_PAD(0x0348, 0x0198, 3, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM1__LPTMR1_ALT3                    = IOMUX_PAD(0x0348, 0x0198, 4, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM1__GPIO1_IO10                     = IOMUX_PAD(0x0348, 0x0198, 5, 0x0000, 0, 0),
	MX93_PAD_PDM_BIT_STREAM1__CCMSRCGPCMIX_EXT_CLK1          = IOMUX_PAD(0x0348, 0x0198, 6, 0x0368, 1, 0),

	MX93_PAD_SAI1_TXFS__SAI1_TX_SYNC                         = IOMUX_PAD(0x034C, 0x019C, 0, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXFS__SAI1_TX_DATA01                       = IOMUX_PAD(0x034C, 0x019C, 1, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXFS__LPSPI1_PCS0                          = IOMUX_PAD(0x034C, 0x019C, 2, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXFS__LPUART2_DTR_B                        = IOMUX_PAD(0x034C, 0x019C, 3, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXFS__MQS1_LEFT                            = IOMUX_PAD(0x034C, 0x019C, 4, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXFS__GPIO1_IO11                           = IOMUX_PAD(0x034C, 0x019C, 5, 0x0000, 0, 0),

	MX93_PAD_SAI1_TXC__SAI1_TX_BCLK                          = IOMUX_PAD(0x0350, 0x01A0, 0, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXC__LPUART2_CTS_B                         = IOMUX_PAD(0x0350, 0x01A0, 1, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXC__LPSPI1_SIN                            = IOMUX_PAD(0x0350, 0x01A0, 2, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXC__LPUART1_DSR_B                         = IOMUX_PAD(0x0350, 0x01A0, 3, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXC__CAN1_RX                               = IOMUX_PAD(0x0350, 0x01A0, 4, 0x0360, 1, 0),
	MX93_PAD_SAI1_TXC__GPIO1_IO12                            = IOMUX_PAD(0x0350, 0x01A0, 5, 0x0000, 0, 0),

	MX93_PAD_SAI1_TXD0__SAI1_TX_DATA00                       = IOMUX_PAD(0x0354, 0x01A4, 0, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXD0__LPUART2_RTS_B                        = IOMUX_PAD(0x0354, 0x01A4, 1, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXD0__LPSPI1_SCK                           = IOMUX_PAD(0x0354, 0x01A4, 2, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXD0__LPUART1_DTR_B                        = IOMUX_PAD(0x0354, 0x01A4, 3, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXD0__CAN1_TX                              = IOMUX_PAD(0x0354, 0x01A4, 4, 0x0000, 0, 0),
	MX93_PAD_SAI1_TXD0__GPIO1_IO13                           = IOMUX_PAD(0x0354, 0x01A4, 5, 0x0000, 0, 0),

	MX93_PAD_SAI1_RXD0__SAI1_RX_DATA00                       = IOMUX_PAD(0x0358, 0x01A8, 0, 0x0000, 0, 0),
	MX93_PAD_SAI1_RXD0__SAI1_MCLK                            = IOMUX_PAD(0x0358, 0x01A8, 1, 0x0448, 1, 0),
	MX93_PAD_SAI1_RXD0__LPSPI1_SOUT                          = IOMUX_PAD(0x0358, 0x01A8, 2, 0x0000, 0, 0),
	MX93_PAD_SAI1_RXD0__LPUART2_DSR_B                        = IOMUX_PAD(0x0358, 0x01A8, 3, 0x0000, 0, 0),
	MX93_PAD_SAI1_RXD0__MQS1_RIGHT                           = IOMUX_PAD(0x0358, 0x01A8, 4, 0x0000, 0, 0),
	MX93_PAD_SAI1_RXD0__GPIO1_IO14                           = IOMUX_PAD(0x0358, 0x01A8, 5, 0x0000, 0, 0),

	MX93_PAD_WDOG_ANY__WDOG1_WDOG_ANY                        = IOMUX_PAD(0x035C, 0x01AC, 0, 0x0000, 0, 0),
	MX93_PAD_WDOG_ANY__GPIO1_IO15                            = IOMUX_PAD(0x035C, 0x01AC, 5, 0x0000, 0, 0),
};
#endif  /* __ASM_ARCH_IMX93_PINS_H__ */
