/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright 2015-2016 by Freescale Semiconductor
 * Copyright 2016-2017, 2019 NXP
 */

#ifndef __DT_BINDINGS_S32V234_PINCTRL_H__
#define __DT_BINDINGS_S32V234_PINCTRL_H__

/*
 * Use to set PAD control
 */
#define PAD_CTL_DCYLE_TRIM_OFS      (22)
#define PAD_CTL_DCYLE_TRIM_NONE     (0 << PAD_CTL_DCYLE_TRIM_OFS)
#define PAD_CTL_DCYLE_TRIM_LEFT     (1 << PAD_CTL_DCYLE_TRIM_OFS)
#define PAD_CTL_DCYLE_TRIM_RIGHT    (2 << PAD_CTL_DCYLE_TRIM_OFS)

#define PAD_CTL_OBE         (1 << 21)
#define PAD_CTL_ODE         (1 << 20)
#define PAD_CTL_IBE         (1 << 19)
#define PAD_CTL_HYS         (1 << 18)
#define PAD_CTL_INV         (1 << 17)
#define PAD_CTL_PKE         (1 << 16)

#define PAD_CTL_SRE_OFS             (14)
#define PAD_CTL_SRE_LOW_50HZ        (0 << PAD_CTL_SRE_OFS)
#define PAD_CTL_SRE_LOW_100MHZ      (1 << PAD_CTL_SRE_OFS)
/* The manual reports the same value for SRE = 01 and SRE = 10 */
#define PAD_CTL_SRE_HIGH_100MHZ     (2 << PAD_CTL_SRE_OFS)
#define PAD_CTL_SRE_HIGH_200MHZ     (3 << PAD_CTL_SRE_OFS)

#define PAD_CTL_PUE             (1 << 13)

#define PAD_CTL_PUS_OFS         (11)
#define PAD_CTL_PUS_100K_DOWN   (0 << PAD_CTL_PUS_OFS)
#define PAD_CTL_PUS_50K_UP      (1 << PAD_CTL_PUS_OFS)
#define PAD_CTL_PUS_100K_UP     (2 << PAD_CTL_PUS_OFS)
#define PAD_CTL_PUS_33K_UP      (3 << PAD_CTL_PUS_OFS)
#define PAD_CTL_PUS_MASK        (3 << PAD_CTL_PUS_OFS)

#define PAD_CTL_DSE_OFS         (8)
#define PAD_CTL_DSE_OUT_DISABLE (0 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_240         (1 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_120         (2 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_80          (3 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_60          (4 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_48          (5 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_40          (6 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_34          (7 << PAD_CTL_DSE_OFS)
#define PAD_CTL_DSE_MASK        (7 << PAD_CTL_DSE_OFS)

#define PAD_CTL_CRPOINT_TRIM    (3 << 6)

#define PAD_CTL_SMC             (1 << 5)

#define PAD_CTL_MUX_MODE_ALT0   (0)
#define PAD_CTL_MUX_MODE_ALT1   (1)
#define PAD_CTL_MUX_MODE_ALT2   (2)
#define PAD_CTL_MUX_MODE_ALT3   (3)
#define PAD_CTL_MUX_MODE_ALT4   (4)
#define PAD_CTL_MUX_MODE_ALT5   (5)
#define PAD_CTL_MUX_MODE_ALT6   (6)
#define PAD_CTL_MUX_MODE_ALT7   (7)
#define PAD_CTL_MUX_MODE_MASK   (0xF)

/* UART configuration */
#define PAD_CTL_UART_TX         (PAD_CTL_OBE | PAD_CTL_PUS_100K_UP |\
				PAD_CTL_DSE_60 | PAD_CTL_SRE_LOW_100MHZ |\
				PAD_CTL_MUX_MODE_ALT1)
#define PAD_CTL_UART_RX_MSCR    (PAD_CTL_PUE | PAD_CTL_IBE |\
				PAD_CTL_DCYLE_TRIM_RIGHT)
#define PAD_CTL_UART_RX_IMCR    (PAD_CTL_MUX_MODE_ALT2)

/* CAN0 configuration */
#define PAD_CTL_CAN_FD0_TX      (PAD_CTL_OBE | PAD_CTL_PUS_50K_UP |\
				PAD_CTL_PUE | PAD_CTL_DSE_34 |\
				PAD_CTL_MUX_MODE_ALT1)
#define PAD_CTL_CAN_FD0_RX_MSCR (PAD_CTL_PUE | PAD_CTL_IBE | PAD_CTL_PUS_50K_UP)
#define PAD_CTL_CAN_FD0_RX_IMCR (PAD_CTL_MUX_MODE_ALT2)

/* CAN1 configuration */
#define PAD_CTL_CAN_FD1_TX      (PAD_CTL_OBE | PAD_CTL_PUS_50K_UP |\
				PAD_CTL_PUE | PAD_CTL_DSE_34 |\
				PAD_CTL_MUX_MODE_ALT1)
#define PAD_CTL_CAN_FD1_RX_MSCR (PAD_CTL_PUE | PAD_CTL_IBE | PAD_CTL_PUS_50K_UP)
#define PAD_CTL_CAN_FD1_RX_IMCR (PAD_CTL_MUX_MODE_ALT3)

/* USDHC configuration  */
#define PAD_CTL_USDHC_BASE      (PAD_CTL_SRE_HIGH_200MHZ | PAD_CTL_OBE | \
				PAD_CTL_DSE_34 | PAD_CTL_PKE |  \
				PAD_CTL_IBE | PAD_CTL_PUS_100K_UP | PAD_CTL_PUE)
#define PAD_CTL_USDHC_CMD       (PAD_CTL_USDHC_BASE | PAD_CTL_MUX_MODE_ALT1)
#define PAD_CTL_USDHC_CLK       (PAD_CTL_USDHC_BASE | PAD_CTL_MUX_MODE_ALT2)
#define PAD_CTL_USDHC_DAT0_3    (PAD_CTL_USDHC_BASE | PAD_CTL_MUX_MODE_ALT2)
#define PAD_CTL_USDHC_DAT4_7    (PAD_CTL_USDHC_BASE | PAD_CTL_MUX_MODE_ALT3)

/* QSPI configuration */
#define PAD_CTL_QSPI_BASE         (PAD_CTL_SRE_HIGH_200MHZ | PAD_CTL_OBE | \
				  PAD_CTL_DSE_34 | PAD_CTL_IBE)
#define PAD_CTL_QSPI_CLK_BASE     (PAD_CTL_SRE_HIGH_200MHZ | PAD_CTL_DSE_34 | \
				  PAD_CTL_PUS_100K_UP | PAD_CTL_OBE)
#define PAD_CTL_QSPI_CK2_MUX      PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_A_SCK_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_B_SCK_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_A_CS0_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_B_CS0_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_A_CS1_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_B_CS1_MUX    PAD_CTL_MUX_MODE_ALT1
#define PAD_CTL_QSPI_A_DQS        (PAD_CTL_SRE_HIGH_200MHZ | PAD_CTL_IBE | \
				  PAD_CTL_PUS_100K_DOWN | PAD_CTL_PUE | \
				  PAD_CTL_PKE)
#define PAD_CTL_QSPI_A_DATA0_3    (PAD_CTL_QSPI_BASE | PAD_CTL_MUX_MODE_ALT1)
#define PAD_CTL_QSPI_A_DATA4_7    (PAD_CTL_QSPI_BASE | PAD_CTL_MUX_MODE_ALT2)
#define PAD_CTL_QSPI_B_DATA0_3    (PAD_CTL_QSPI_BASE | PAD_CTL_MUX_MODE_ALT1)

/* EIRQ configuration */
#define PAD_CTL_EIRQ              PAD_CTL_MUX_MODE_ALT2

/* I2C0 - Serial Data Input PA15 */
#define PAD_CTL_I2C0_MSCR_SDA_PA15    (PAD_CTL_MUX_MODE_ALT1 | PAD_CTL_OBE | \
				      PAD_CTL_IBE | PAD_CTL_ODE | \
				      PAD_CTL_DSE_34)
#define PAD_CTL_I2C0_IMCR_SDA_PA15    (PAD_CTL_MUX_MODE_ALT2)

/* I2C0 - Serial Clock Input PB0 */
#define PAD_CTL_I2C0_MSCR_SCLK_PB0    (PAD_CTL_MUX_MODE_ALT1 | PAD_CTL_OBE | \
				      PAD_CTL_IBE | PAD_CTL_ODE | \
				      PAD_CTL_DSE_34)
#define PAD_CTL_I2C0_IMCR_SCLK_PB0    (PAD_CTL_MUX_MODE_ALT2)

/* I2C0 - Serial Data Input PG3 */
#define PAD_CTL_I2C0_MSCR_SDA_PG3     (PAD_CTL_MUX_MODE_ALT2 | PAD_CTL_OBE | \
				      PAD_CTL_IBE | PAD_CTL_ODE | \
				      PAD_CTL_DSE_34)
#define PAD_CTL_I2C0_IMCR_SDA_PG3     (PAD_CTL_MUX_MODE_ALT3)

/* I2C0 - Serial Clock Input PG4 */
#define PAD_CTL_I2C0_MSCR_SCLK_PG4    (PAD_CTL_MUX_MODE_ALT2 | PAD_CTL_OBE | \
				      PAD_CTL_IBE | PAD_CTL_ODE | \
				      PAD_CTL_DSE_34)
#define PAD_CTL_I2C0_IMCR_SCLK_PG4    (PAD_CTL_MUX_MODE_ALT3)

/* I2C1 - Serial Data Input */
#define  PAD_CTL_I2C1_MSCR_SDA  (PAD_CTL_MUX_MODE_ALT2 | PAD_CTL_OBE | \
				PAD_CTL_IBE | PAD_CTL_ODE | PAD_CTL_DSE_34)
#define PAD_CTL_I2C1_IMCR_SDA   (PAD_CTL_MUX_MODE_ALT3)

/* I2C1 - Serial Clock Input */
#define  PAD_CTL_I2C1_MSCR_SCLK (PAD_CTL_MUX_MODE_ALT2 | PAD_CTL_OBE | \
				PAD_CTL_IBE | PAD_CTL_ODE | PAD_CTL_DSE_34)
#define PAD_CTL_I2C1_IMCR_SCLK  (PAD_CTL_MUX_MODE_ALT3)

/* I2C2 - Serial Data Input */
#define  PAD_CTL_I2C2_MSCR_SDA  (PAD_CTL_MUX_MODE_ALT1 | PAD_CTL_OBE | \
				PAD_CTL_IBE | PAD_CTL_ODE | PAD_CTL_DSE_34)
#define PAD_CTL_I2C2_IMCR_SDA   (PAD_CTL_MUX_MODE_ALT2)

/* I2C2 - Serial Clock Input */
#define  PAD_CTL_I2C2_MSCR_SCLK (PAD_CTL_MUX_MODE_ALT1 | PAD_CTL_OBE | \
				PAD_CTL_IBE | PAD_CTL_ODE | PAD_CTL_DSE_34)
#define PAD_CTL_I2C2_IMCR_SCLK  (PAD_CTL_MUX_MODE_ALT2)

/* ENET CFG1 = 0x203701 */
#define PAD_CTL_ENET_CFG1       (PAD_CTL_DSE_34 | PAD_CTL_PUS_100K_UP | PAD_CTL_PUE | \
                                PAD_CTL_OBE | PAD_CTL_MUX_MODE_ALT1)

/* ENET CFG2 = 0x20c701 */
#define PAD_CTL_ENET_CFG2       (PAD_CTL_DSE_34 | PAD_CTL_SRE_HIGH_200MHZ | \
                                PAD_CTL_OBE | PAD_CTL_MUX_MODE_ALT1)

/* ENET CFG3 = 0x28c701 */
#define PAD_CTL_ENET_CFG3       (PAD_CTL_DSE_34 | PAD_CTL_SRE_HIGH_200MHZ | \
                                PAD_CTL_OBE | PAD_CTL_IBE | PAD_CTL_MUX_MODE_ALT1)

/* ENET CFG7 = 0x8c700 */
#define PAD_CTL_ENET_CFG4       (PAD_CTL_DSE_34 | PAD_CTL_SRE_HIGH_200MHZ | PAD_CTL_IBE)

/* DCU CFG = 0x20C101 */
#define PAD_CTL_DCU_CFG         (PAD_CTL_DSE_80 | PAD_CTL_SRE_HIGH_200MHZ | \
				PAD_CTL_OBE | PAD_CTL_IBE | \
				PAD_CTL_MUX_MODE_ALT1)

#define PAD_CTL_DCU_CLK_CFG_DSE_DISABLE (PAD_CTL_SRE_HIGH_200MHZ | \
					PAD_CTL_OBE | PAD_CTL_IBE | \
					PAD_CTL_MUX_MODE_ALT1)

/* VIU IMCR = 0x00000002 */
#define PAD_CTL_VIU_CFG         (PAD_CTL_MUX_MODE_ALT2)

/* VIU MSCR = 0x00000002 */
#define PAD_CTL_VIU_IBE         (PAD_CTL_IBE)

/* SPI 0-3 */
#define PAD_CTL_SPI_MSCR_CSx    (PAD_CTL_OBE | PAD_CTL_PUS_100K_UP | \
				PAD_CTL_DSE_34 | PAD_CTL_PUE)

#define PAD_CTL_SPI_MSCR_SCK    (PAD_CTL_OBE | PAD_CTL_DSE_34 | \
				PAD_CTL_MUX_MODE_ALT1)

#define PAD_CTL_SPI_MSCR_SOUT   (PAD_CTL_OBE | PAD_CTL_DSE_34 | \
				PAD_CTL_MUX_MODE_ALT1)

#define PAD_CTL_SPI_MSCR_SIN    (PAD_CTL_PUE | PAD_CTL_IBE | \
				PAD_CTL_PUS_50K_UP)

#define PAD_CTL_SPI_IMCR_SIN    (PAD_CTL_MUX_MODE_ALT2)

/* MSCR register numbers associated to port or function */
#define S32V234_MSCR_PA0        0
#define S32V234_MSCR_PA1        1
#define S32V234_MSCR_PA2        2
#define S32V234_MSCR_PA3        3
#define S32V234_MSCR_PA4        4
#define S32V234_MSCR_PA5        5
#define S32V234_MSCR_PA6        6
#define S32V234_MSCR_PA7        7
#define S32V234_MSCR_PA8        8
#define S32V234_MSCR_PA9        9
#define S32V234_MSCR_PA10       10
#define S32V234_MSCR_PA11       11
#define S32V234_MSCR_PA12       12
#define S32V234_MSCR_PA13       13
#define S32V234_MSCR_PA14       14
#define S32V234_MSCR_PA15       15
#define S32V234_MSCR_PB0        16
#define S32V234_MSCR_PB1        17
#define S32V234_MSCR_PB2        18
#define S32V234_MSCR_PB3        19
#define S32V234_MSCR_PB4        20
#define S32V234_MSCR_PB5        21
#define S32V234_MSCR_PB6        22
#define S32V234_MSCR_PB7        23
#define S32V234_MSCR_PB8        24
#define S32V234_MSCR_PB9        25
#define S32V234_MSCR_PB10       26
#define S32V234_MSCR_PB11       27
#define S32V234_MSCR_PB12       28
#define S32V234_MSCR_PB13       29
#define S32V234_MSCR_PB14       30
#define S32V234_MSCR_PB15       31
#define S32V234_MSCR_PC0        32
#define S32V234_MSCR_PC1        33
#define S32V234_MSCR_PC2        34
#define S32V234_MSCR_PC3        35
#define S32V234_MSCR_PC4        36
#define S32V234_MSCR_PC5        37
#define S32V234_MSCR_PC6        38
#define S32V234_MSCR_PC7        39
#define S32V234_MSCR_PC8        40
#define S32V234_MSCR_PC9        41
#define S32V234_MSCR_PC10       42
#define S32V234_MSCR_PC11       43
#define S32V234_MSCR_PC12       44
#define S32V234_MSCR_PC13       45
#define S32V234_MSCR_PC14       46
#define S32V234_MSCR_PC15       47
#define S32V234_MSCR_PD0        48
#define S32V234_MSCR_PD1        49
#define S32V234_MSCR_PD2        50
#define S32V234_MSCR_PD3        51
#define S32V234_MSCR_PD4        52
#define S32V234_MSCR_PD5        53
#define S32V234_MSCR_PD6        54
#define S32V234_MSCR_PD7        55
#define S32V234_MSCR_PD8        56
#define S32V234_MSCR_PD9        57
#define S32V234_MSCR_PD10       58
#define S32V234_MSCR_PD11       59
#define S32V234_MSCR_PD12       60
#define S32V234_MSCR_PD13       61
#define S32V234_MSCR_PD14       62
#define S32V234_MSCR_PD15       63
#define S32V234_MSCR_PE0        64
#define S32V234_MSCR_PE1        65
#define S32V234_MSCR_PE2        66
#define S32V234_MSCR_PE3        67
#define S32V234_MSCR_PE4        68
#define S32V234_MSCR_PE5        69
#define S32V234_MSCR_PE6        70
#define S32V234_MSCR_PE7        71
#define S32V234_MSCR_PE8        72
#define S32V234_MSCR_PE9        73
#define S32V234_MSCR_PE10       74
#define S32V234_MSCR_PE11       75
#define S32V234_MSCR_PE12       76
#define S32V234_MSCR_PE13       77
#define S32V234_MSCR_PE14       78
#define S32V234_MSCR_PE15       79
#define S32V234_MSCR_PF0        80
#define S32V234_MSCR_PF1        81
#define S32V234_MSCR_PF2        82
#define S32V234_MSCR_PF3        83
#define S32V234_MSCR_PF4        84
#define S32V234_MSCR_PF5        85
#define S32V234_MSCR_PF6        86
#define S32V234_MSCR_PF7        87
#define S32V234_MSCR_PF8        88
#define S32V234_MSCR_PF9        89
#define S32V234_MSCR_PF10       90
#define S32V234_MSCR_PF11       91
#define S32V234_MSCR_PF12       92
#define S32V234_MSCR_PF13       93
#define S32V234_MSCR_PF14       94
#define S32V234_MSCR_PF15       95
#define S32V234_MSCR_PG0        96
#define S32V234_MSCR_PG1        97
#define S32V234_MSCR_PG2        98
#define S32V234_MSCR_PG3        99
#define S32V234_MSCR_PG4        100
#define S32V234_MSCR_PG5        101
#define S32V234_MSCR_PG6        102
#define S32V234_MSCR_PG7        103
#define S32V234_MSCR_PG8        104
#define S32V234_MSCR_PG9        105
#define S32V234_MSCR_PG10       106
#define S32V234_MSCR_PG11       107
#define S32V234_MSCR_PG12       108
#define S32V234_MSCR_PG13       109
#define S32V234_MSCR_PG14       110
#define S32V234_MSCR_PG15       111
#define S32V234_MSCR_PH0        112
#define S32V234_MSCR_PH1        113
#define S32V234_MSCR_PH2        114
#define S32V234_MSCR_PH3        115
#define S32V234_MSCR_PH4        116
#define S32V234_MSCR_PH5        117
#define S32V234_MSCR_PH6        118
#define S32V234_MSCR_PH7        119
#define S32V234_MSCR_PH8        120
#define S32V234_MSCR_PH9        121
#define S32V234_MSCR_PH10       122
#define S32V234_MSCR_PH11       123
#define S32V234_MSCR_PH12       124
#define S32V234_MSCR_PH13       125
#define S32V234_MSCR_PH14       126
#define S32V234_MSCR_PH15       127
#define S32V234_MSCR_PJ0        128
#define S32V234_MSCR_PJ1        129
#define S32V234_MSCR_PJ2        130
#define S32V234_MSCR_PJ3        131
#define S32V234_MSCR_PJ4        132
#define S32V234_MSCR_PJ5        133
#define S32V234_MSCR_PJ6        134
#define S32V234_MSCR_PJ7        135
#define S32V234_MSCR_PJ8        136
#define S32V234_MSCR_PJ9        137
#define S32V234_MSCR_PJ10       138
#define S32V234_MSCR_PJ11       139
#define S32V234_MSCR_PJ12       140
#define S32V234_MSCR_PJ13       141
#define S32V234_MSCR_PJ14       142
#define S32V234_MSCR_PJ15       143
#define S32V234_MSCR_PK0        144
#define S32V234_MSCR_PK1        145
#define S32V234_MSCR_PK2        146
#define S32V234_MSCR_PK3        147
#define S32V234_MSCR_PK4        148
#define S32V234_MSCR_PK5        149
#define S32V234_MSCR_PK6        150
#define S32V234_MSCR_PK7        151
#define S32V234_MSCR_PK8        152
#define S32V234_MSCR_PK9        153
#define S32V234_MSCR_PK10       154
#define S32V234_MSCR_PK11       155
#define S32V234_MSCR_PK12       156
#define S32V234_MSCR_PK13       157
#define S32V234_MSCR_PK14       158
#define S32V234_MSCR_PK15       159
#define S32V234_MSCR_PL0        160
#define S32V234_MSCR_PL1        161
#define S32V234_MSCR_PL2        162
#define S32V234_MSCR_PL3        163
#define S32V234_MSCR_PL4        164
#define S32V234_MSCR_PL5        165
#define S32V234_MSCR_PL8        166

#define S32V234_IMCR_FlexTimer0_CH0    512
#define S32V234_IMCR_FlexTimer0_CH1    513
#define S32V234_IMCR_FlexTimer0_CH2    514
#define S32V234_IMCR_FlexTimer0_CH3    515
#define S32V234_IMCR_FlexTimer0_CH4    516
#define S32V234_IMCR_FlexTimer0_CH5    517
#define S32V234_IMCR_FlexTimer0_EXTCLK 520
#define S32V234_IMCR_FlexTimer1_CH0    521
#define S32V234_IMCR_FlexTimer1_CH1    522
#define S32V234_IMCR_FlexTimer1_CH2    523
#define S32V234_IMCR_FlexTimer1_CH3    524
#define S32V234_IMCR_FlexTimer1_CH4    525
#define S32V234_IMCR_FlexTimer1_CH5    526
#define S32V234_IMCR_FlexTimer1_EXTCLK 529
#define S32V234_IMCR_LFAST_REF_CLK     550
#define S32V234_IMCR_BOOT_BOOTMOD0     570
#define S32V234_IMCR_BOOT_BOOTMOD1     571
#define S32V234_IMCR_SIUL_EIRQ0        590
#define S32V234_IMCR_SIUL_EIRQ1        591
#define S32V234_IMCR_SIUL_EIRQ2        592
#define S32V234_IMCR_SIUL_EIRQ3        593
#define S32V234_IMCR_SIUL_EIRQ4        594
#define S32V234_IMCR_SIUL_EIRQ5        595
#define S32V234_IMCR_SIUL_EIRQ6        596
#define S32V234_IMCR_SIUL_EIRQ7        597
#define S32V234_IMCR_SIUL_EIRQ8        598
#define S32V234_IMCR_SIUL_EIRQ9        599
#define S32V234_IMCR_SIUL_EIRQ10       600
#define S32V234_IMCR_SIUL_EIRQ11       601
#define S32V234_IMCR_SIUL_EIRQ12       602
#define S32V234_IMCR_SIUL_EIRQ13       603
#define S32V234_IMCR_SIUL_EIRQ14       604
#define S32V234_IMCR_SIUL_EIRQ15       605
#define S32V234_IMCR_SIUL_EIRQ16       606
#define S32V234_IMCR_SIUL_EIRQ17       607
#define S32V234_IMCR_SIUL_EIRQ18       608
#define S32V234_IMCR_SIUL_EIRQ19       609
#define S32V234_IMCR_SIUL_EIRQ20       610
#define S32V234_IMCR_SIUL_EIRQ21       611
#define S32V234_IMCR_SIUL_EIRQ22       612
#define S32V234_IMCR_SIUL_EIRQ23       613
#define S32V234_IMCR_SIUL_EIRQ24       614
#define S32V234_IMCR_SIUL_EIRQ25       615
#define S32V234_IMCR_SIUL_EIRQ26       616
#define S32V234_IMCR_SIUL_EIRQ27       617
#define S32V234_IMCR_SIUL_EIRQ28       618
#define S32V234_IMCR_SIUL_EIRQ29       619
#define S32V234_IMCR_SIUL_EIRQ30       620
#define S32V234_IMCR_SIUL_EIRQ31       621
#define S32V234_IMCR_VIU0_HSYNC        622
#define S32V234_IMCR_VIU0_VSYNC        623
#define S32V234_IMCR_VIU0_PCLK         624
#define S32V234_IMCR_VIU0_D4           629
#define S32V234_IMCR_VIU0_D5           630
#define S32V234_IMCR_VIU0_D6           631
#define S32V234_IMCR_VIU0_D7           632
#define S32V234_IMCR_VIU0_D8           633
#define S32V234_IMCR_VIU0_D9           634
#define S32V234_IMCR_VIU0_D10          635
#define S32V234_IMCR_VIU0_D11          636
#define S32V234_IMCR_VIU0_D12          637
#define S32V234_IMCR_VIU0_D13          638
#define S32V234_IMCR_VIU0_D14          639
#define S32V234_IMCR_VIU0_D15          640
#define S32V234_IMCR_VIU0_D16          641
#define S32V234_IMCR_VIU0_D17          642
#define S32V234_IMCR_VIU0_D18          643
#define S32V234_IMCR_VIU0_D19          644
#define S32V234_IMCR_VIU0_D20          645
#define S32V234_IMCR_VIU0_D21          646
#define S32V234_IMCR_VIU0_D22          647
#define S32V234_IMCR_VIU0_D23          648
#define S32V234_IMCR_VIU1_HSYNC        657
#define S32V234_IMCR_VIU1_VSYNC        658
#define S32V234_IMCR_VIU1_PCLK         659
#define S32V234_IMCR_VIU1_D8           668
#define S32V234_IMCR_VIU1_D9           669
#define S32V234_IMCR_VIU1_D10          670
#define S32V234_IMCR_VIU1_D11          671
#define S32V234_IMCR_VIU1_D12          672
#define S32V234_IMCR_VIU1_D13          673
#define S32V234_IMCR_VIU1_D14          674
#define S32V234_IMCR_VIU1_D15          675
#define S32V234_IMCR_VIU1_D16          676
#define S32V234_IMCR_VIU1_D17          677
#define S32V234_IMCR_VIU1_D18          678
#define S32V234_IMCR_VIU1_D19          679
#define S32V234_IMCR_VIU1_D20          680
#define S32V234_IMCR_VIU1_D21          681
#define S32V234_IMCR_VIU1_D22          682
#define S32V234_IMCR_VIU1_D23          683
#define S32V234_IMCR_CAN_FD0_RXD       700
#define S32V234_IMCR_CAN_FD1_RXD       701
#define S32V234_IMCR_UART0_RXD         712
#define S32V234_IMCR_UART1_RXD         714
#define S32V234_IMCR_IIC0_CLK          780
#define S32V234_IMCR_IIC0_DATA         781
#define S32V234_IMCR_IIC1_CLK          782
#define S32V234_IMCR_IIC1_DATA         783
#define S32V234_IMCR_IIC2_CLK          784
#define S32V234_IMCR_IIC2_DATA         785
#define S32V234_IMCR_SPI0_SIN          800
#define S32V234_IMCR_SPI0_SCK          801
#define S32V234_IMCR_SPI0_CS0          802
#define S32V234_IMCR_SPI1_SIN          803
#define S32V234_IMCR_SPI1_SCK          804
#define S32V234_IMCR_SPI1_CS0          805
#define S32V234_IMCR_SPI2_SIN          806
#define S32V234_IMCR_SPI2_SCK          807
#define S32V234_IMCR_SPI2_CS0          808
#define S32V234_IMCR_SPI3_SIN          809
#define S32V234_IMCR_SPI3_SCK          810
#define S32V234_IMCR_SPI3_CS0          811
#define S32V234_IMCR_QSPI_A_DQS        819
#define S32V234_IMCR_QSPI_A_DATA0      820
#define S32V234_IMCR_QSPI_A_DATA1      821
#define S32V234_IMCR_QSPI_A_DATA2      822
#define S32V234_IMCR_QSPI_A_DATA3      823
#define S32V234_IMCR_QSPI_A_DATA4      824
#define S32V234_IMCR_QSPI_A_DATA5      825
#define S32V234_IMCR_QSPI_A_DATA6      826
#define S32V234_IMCR_QSPI_A_DATA7      827
#define S32V234_IMCR_QSPI_B_DQS        828
#define S32V234_IMCR_QSPI_B_DATA0      829
#define S32V234_IMCR_QSPI_B_DATA1      830
#define S32V234_IMCR_QSPI_B_DATA2      831
#define S32V234_IMCR_QSPI_B_DATA3      832
#define S32V234_IMCR_USDHC_WP          900
#define S32V234_IMCR_USDHC_CMD         901
#define S32V234_IMCR_USDHC_CLK         902
#define S32V234_IMCR_USDHC_DAT0        903
#define S32V234_IMCR_USDHC_DAT1        904
#define S32V234_IMCR_USDHC_DAT2        905
#define S32V234_IMCR_USDHC_DAT3        906
#define S32V234_IMCR_USDHC_DAT4        907
#define S32V234_IMCR_USDHC_DAT5        908
#define S32V234_IMCR_USDHC_DAT6        909
#define S32V234_IMCR_USDHC_DAT7        910
#define S32V234_IMCR_Ethernet_RX_ER    970
#define S32V234_IMCR_Ethernet_COL      971
#define S32V234_IMCR_Ethernet_CRS      972
#define S32V234_IMCR_Ethernet_RX_DV    973
#define S32V234_IMCR_Ethernet_RX_D0    974
#define S32V234_IMCR_Ethernet_RX_D1    975
#define S32V234_IMCR_Ethernet_RX_D2    976
#define S32V234_IMCR_Ethernet_RX_D3    977
#define S32V234_IMCR_Ethernet_TX_CLK   978
#define S32V234_IMCR_Ethernet_RX_CLK   979
#define S32V234_IMCR_Ethernet_MDIO     981
#define S32V234_IMCR_Ethernet_TIMER0   982
#define S32V234_IMCR_Ethernet_TIMER1   983
#define S32V234_IMCR_Ethernet_TIMER2   984
#define S32V234_IMCR_FlexRay_CA_RX     1012
#define S32V234_IMCR_FlexRay_CB_RX     1013
#define S32V234_IMCR_SSE_IN0           1018
#define S32V234_IMCR_SSE_IN1           1019
#define S32V234_IMCR_SSE_IN2           1020
#define S32V234_IMCR_SSE_IN3           1021

/* Format of pins: MSCR_IDX PAD_CONFIGURATION If you know the IMCR_IDX
 * instead of MSCR_IDX, add 512 to it as the Reference Manual states.
 */

/* UART configuration */
#define S32V234_PAD_PA12__UART0_TXD     S32V234_MSCR_PA12 PAD_CTL_UART_TX
#define S32V234_PAD_PA11__UART0_RXD_OUT S32V234_MSCR_PA11 PAD_CTL_UART_RX_MSCR
#define S32V234_PAD_PA11__UART0_RXD_IN  S32V234_IMCR_UART0_RXD \
					PAD_CTL_UART_RX_IMCR

#define S32V234_PAD_PA14__UART1_TXD     S32V234_MSCR_PA14 PAD_CTL_UART_TX
#define S32V234_PAD_PA13__UART1_RXD_OUT S32V234_MSCR_PA13 PAD_CTL_UART_RX_MSCR
#define S32V234_PAD_PA13__UART1_RXD_IN  S32V234_IMCR_UART1_RXD \
					PAD_CTL_UART_RX_IMCR

/* CAN0 configuration */
#define S32V234_PAD_PA2__CAN_FD0_TXD     S32V234_MSCR_PA2 PAD_CTL_CAN_FD0_TX
#define S32V234_PAD_PA3__CAN_FD0_RXD_OUT S32V234_MSCR_PA3 \
					 PAD_CTL_CAN_FD0_RX_MSCR
#define S32V234_PAD_PA3__CAN_FD0_RXD_IN  S32V234_IMCR_CAN_FD0_RXD \
					 PAD_CTL_CAN_FD0_RX_IMCR

/* CAN1 configuration */
#define S32V234_PAD_PA4__CAN_FD1_TXD     S32V234_MSCR_PA4 PAD_CTL_CAN_FD1_TX
#define S32V234_PAD_PA5__CAN_FD1_RXD_OUT S32V234_MSCR_PA5 \
					 PAD_CTL_CAN_FD1_RX_MSCR
#define S32V234_PAD_PA5__CAN_FD1_RXD_IN  S32V234_IMCR_CAN_FD1_RXD \
					 PAD_CTL_CAN_FD1_RX_IMCR

/* uSDHC configuration */
#define S32V234_PAD_PK6__USDHC_CLK_OUT   S32V234_MSCR_PK6 PAD_CTL_USDHC_CLK
#define S32V234_PAD_PK6__USDHC_CLK_IN    S32V234_IMCR_USDHC_CLK \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK7__USDHC_CMD_OUT   S32V234_MSCR_PK7 PAD_CTL_USDHC_CMD
#define S32V234_PAD_PK7__USDHC_CMD_IN    S32V234_IMCR_USDHC_CMD \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK8__USDHC_DAT0_OUT  S32V234_MSCR_PK8 PAD_CTL_USDHC_DAT0_3
#define S32V234_PAD_PK8__USDHC_DAT0_IN   S32V234_IMCR_USDHC_DAT0 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK9__USDHC_DAT1_OUT  S32V234_MSCR_PK9 PAD_CTL_USDHC_DAT0_3
#define S32V234_PAD_PK9__USDHC_DAT1_IN   S32V234_IMCR_USDHC_DAT1 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK10__USDHC_DAT2_OUT S32V234_MSCR_PK10 PAD_CTL_USDHC_DAT0_3
#define S32V234_PAD_PK10__USDHC_DAT2_IN  S32V234_IMCR_USDHC_DAT2 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK11__USDHC_DAT3_OUT S32V234_MSCR_PK11 PAD_CTL_USDHC_DAT0_3
#define S32V234_PAD_PK11__USDHC_DAT3_IN  S32V234_IMCR_USDHC_DAT3 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PK15__USDHC_DAT4_OUT S32V234_MSCR_PK15 PAD_CTL_USDHC_DAT4_7
#define S32V234_PAD_PK15__USDHC_DAT4_IN  S32V234_IMCR_USDHC_DAT4 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PL0__USDHC_DAT5_OUT  S32V234_MSCR_PL0 PAD_CTL_USDHC_DAT4_7
#define S32V234_PAD_PL0__USDHC_DAT5_IN   S32V234_IMCR_USDHC_DAT5 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PL1__USDHC_DAT6_OUT  S32V234_MSCR_PL1 PAD_CTL_USDHC_DAT4_7
#define S32V234_PAD_PL1__USDHC_DAT6_IN   S32V234_IMCR_USDHC_DAT6 \
					 PAD_CTL_MUX_MODE_ALT3

#define S32V234_PAD_PL2__USDHC_DAT7_OUT  S32V234_MSCR_PL2 PAD_CTL_USDHC_DAT4_7
#define S32V234_PAD_PL2__USDHC_DAT7_IN   S32V234_IMCR_USDHC_DAT7 \
					 PAD_CTL_MUX_MODE_ALT3

/* QSPI configuration */
#define S32V234_PAD_PK7__QSPI_A_DQS        S32V234_IMCR_QSPI_A_DQS \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK14__QSPI_B_DQS       S32V234_IMCR_QSPI_B_DQS \
					   PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PK8__QSPI_A_DATA0_IN   S32V234_IMCR_QSPI_A_DATA0 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK8__QSPI_A_DATA0_OUT  S32V234_MSCR_PK8 \
					   PAD_CTL_QSPI_A_DATA0_3

#define S32V234_PAD_PK9__QSPI_A_DATA1_IN   S32V234_IMCR_QSPI_A_DATA1 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK9__QSPI_A_DATA1_OUT  S32V234_MSCR_PK9 \
					   PAD_CTL_QSPI_A_DATA0_3

#define S32V234_PAD_PK10__QSPI_A_DATA2_IN  S32V234_IMCR_QSPI_A_DATA2 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK10__QSPI_A_DATA2_OUT S32V234_MSCR_PK10 \
					   PAD_CTL_QSPI_A_DATA0_3

#define S32V234_PAD_PK11__QSPI_A_DATA3_IN  S32V234_IMCR_QSPI_A_DATA3 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK11__QSPI_A_DATA3_OUT S32V234_MSCR_PK11 \
					   PAD_CTL_QSPI_A_DATA0_3

#define S32V234_PAD_PK15__QSPI_A_DATA4_IN  S32V234_IMCR_QSPI_A_DATA4 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK15__QSPI_A_DATA4_OUT S32V234_MSCR_PK15 \
					   PAD_CTL_QSPI_A_DATA4_7

#define S32V234_PAD_PL0__QSPI_A_DATA5_IN   S32V234_IMCR_QSPI_A_DATA5 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL0__QSPI_A_DATA5_OUT  S32V234_MSCR_PL0 \
					   PAD_CTL_QSPI_A_DATA4_7

#define S32V234_PAD_PL1__QSPI_A_DATA6_IN   S32V234_IMCR_QSPI_A_DATA6 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL1__QSPI_A_DATA6_OUT  S32V234_MSCR_PL1 \
					   PAD_CTL_QSPI_A_DATA4_7

#define S32V234_PAD_PL2__QSPI_A_DATA7_IN   S32V234_IMCR_QSPI_A_DATA7 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL2__QSPI_A_DATA7_OUT  S32V234_MSCR_PL2 \
					   PAD_CTL_QSPI_A_DATA4_7

#define S32V234_PAD_PK15__QSPI_B_DATA0_IN  S32V234_IMCR_QSPI_B_DATA0 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PK15__QSPI_B_DATA0_OUT S32V234_MSCR_PK15 \
					   PAD_CTL_QSPI_B_DATA0_3

#define S32V234_PAD_PL0__QSPI_B_DATA1_IN   S32V234_IMCR_QSPI_B_DATA1 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL0__QSPI_B_DATA1_OUT  S32V234_MSCR_PL0 \
					   PAD_CTL_QSPI_B_DATA0_3

#define S32V234_PAD_PL1__QSPI_B_DATA2_IN   S32V234_IMCR_QSPI_B_DATA2 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL1__QSPI_B_DATA2_OUT  S32V234_MSCR_PL1 \
					   PAD_CTL_QSPI_B_DATA0_3

#define S32V234_PAD_PL2__QSPI_B_DATA3_IN   S32V234_IMCR_QSPI_B_DATA3 \
					   PAD_CTL_MUX_MODE_ALT2
#define S32V234_PAD_PL2__QSPI_B_DATA3_OUT  S32V234_MSCR_PL2 \
					   PAD_CTL_QSPI_B_DATA0_3

#define S32V234_PAD_PF12__QSPI_A_CS1       S32V234_MSCR_PF12 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_A_CS1_MUX)
#define S32V234_PAD_PF13__QSPI_B_CS1       S32V234_MSCR_PF13 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_B_CS1_MUX)

#define S32V234_PAD_PK5__QSPI_A_CS0        S32V234_MSCR_PK5 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_A_CS0_MUX)
#define S32V234_PAD_PK6__QSPI_A_SCK        S32V234_MSCR_PK6 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_A_SCK_MUX)

#define S32V234_PAD_PK12__QSPI_B_CS0       S32V234_MSCR_PK12 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_B_CS0_MUX)
#define S32V234_PAD_PK13__QSPI_B_SCK       S32V234_MSCR_PK13 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_B_SCK_MUX)

#define S32V234_PAD_PK13__QSPI_CK2         S32V234_MSCR_PK13 \
					   (PAD_CTL_QSPI_CLK_BASE | \
					   PAD_CTL_QSPI_CK2_MUX)

/* I2C configuration */
#define S32V234_PAD_PA15__I2C0_DATA_OUT S32V234_MSCR_PA15 \
					PAD_CTL_I2C0_MSCR_SDA_PA15
#define S32V234_PAD_PA15__I2C0_DATA_IN  S32V234_IMCR_IIC0_DATA \
					PAD_CTL_I2C0_IMCR_SDA_PA15

#define S32V234_PAD_PB0__I2C0_SCLK_OUT  S32V234_MSCR_PB0 \
					PAD_CTL_I2C0_MSCR_SCLK_PB0
#define S32V234_PAD_PB0__I2C0_SCLK_IN   S32V234_IMCR_IIC0_CLK \
					PAD_CTL_I2C0_IMCR_SCLK_PB0

#define S32V234_PAD_PG3__I2C0_DATA_OUT  S32V234_MSCR_PG3 \
					PAD_CTL_I2C0_MSCR_SDA_PG3
#define S32V234_PAD_PG3__I2C0_DATA_IN   S32V234_IMCR_IIC0_DATA \
					PAD_CTL_I2C0_IMCR_SDA_PG3

#define S32V234_PAD_PG4__I2C0_SCLK_OUT  S32V234_MSCR_PG4 \
					PAD_CTL_I2C0_MSCR_SCLK_PG4
#define S32V234_PAD_PG4__I2C0_SCLK_IN   S32V234_IMCR_IIC0_CLK \
					PAD_CTL_I2C0_IMCR_SCLK_PG4

#define S32V234_PAD_PG5__I2C1_DATA_OUT  S32V234_MSCR_PG5 \
					PAD_CTL_I2C1_MSCR_SDA
#define S32V234_PAD_PG5__I2C1_DATA_IN   S32V234_IMCR_IIC1_DATA \
					PAD_CTL_I2C1_IMCR_SDA

#define S32V234_PAD_PG6__I2C1_SCLK_OUT  S32V234_MSCR_PG6 \
					PAD_CTL_I2C1_MSCR_SCLK
#define S32V234_PAD_PG6__I2C1_SCLK_IN   S32V234_IMCR_IIC1_CLK \
					PAD_CTL_I2C1_IMCR_SCLK

#define S32V234_PAD_PB3__I2C2_DATA_OUT  S32V234_MSCR_PB3 \
					PAD_CTL_I2C2_MSCR_SDA
#define S32V234_PAD_PB3__I2C2_DATA_IN   S32V234_IMCR_IIC2_DATA \
					PAD_CTL_I2C2_IMCR_SDA

#define S32V234_PAD_PB4__I2C2_SCLK_OUT  S32V234_MSCR_PB4 \
					PAD_CTL_I2C2_MSCR_SCLK
#define S32V234_PAD_PB4__I2C2_SCLK_IN   S32V234_IMCR_IIC2_CLK \
					PAD_CTL_I2C2_IMCR_SCLK

/* ENET configuration */
#define S32V234_PAD_PC13__MDC       S32V234_MSCR_PC13 PAD_CTL_ENET_CFG2

#define S32V234_PAD_PC14__MDIO_OUT  S32V234_MSCR_PC14 PAD_CTL_ENET_CFG3
#define S32v234_PAD_PC14__MDIO_IN   S32V234_IMCR_Ethernet_MDIO \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PC15__TXCLK_OUT S32V234_MSCR_PC15 PAD_CTL_ENET_CFG1
#define S32V234_PAD_PC15__TXCLK_IN  S32V234_IMCR_Ethernet_TX_CLK \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD0__RXCLK_OUT  S32V234_MSCR_PD0 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD0__RXCLK_IN   S32V234_IMCR_Ethernet_RX_CLK \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD1__RX_D0_OUT  S32V234_MSCR_PD1 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD1__RX_D0_IN   S32V234_IMCR_Ethernet_RX_D0 \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD2__RX_D1_OUT  S32V234_MSCR_PD2 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD2__RX_D1_IN   S32V234_IMCR_Ethernet_RX_D1 \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD3__RX_D2_OUT  S32V234_MSCR_PD3 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD3__RX_D2_IN   S32V234_IMCR_Ethernet_RX_D2 \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD4__RX_D3_OUT  S32V234_MSCR_PD4 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD4__RX_D3_IN   S32V234_IMCR_Ethernet_RX_D3 \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD4__RX_DV_OUT  S32V234_MSCR_PD5 PAD_CTL_ENET_CFG4
#define S32V234_PAD_PD4__RX_DV_IN   S32V234_IMCR_Ethernet_RX_DV \
				    PAD_CTL_MUX_MODE_ALT2

#define S32V234_PAD_PD7__TX_D0_OUT  S32V234_MSCR_PD7  PAD_CTL_ENET_CFG2
#define S32V234_PAD_PD8__TX_D1_OUT  S32V234_MSCR_PD8  PAD_CTL_ENET_CFG2
#define S32V234_PAD_PD9__TX_D2_OUT  S32V234_MSCR_PD9  PAD_CTL_ENET_CFG2
#define S32V234_PAD_PD10__TX_D3_OUT S32V234_MSCR_PD10 PAD_CTL_ENET_CFG2
#define S32V234_PAD_PD11__TX_EN_OUT S32V234_MSCR_PD11 PAD_CTL_ENET_CFG2

/* 2D ACE DCU */
#define S32V234_PAD_PH8__DCU_HSYNC_C1 S32V234_MSCR_PH8  PAD_CTL_DCU_CFG
#define S32V234_PAD_PH9__DCU_VSYNC_C2 S32V234_MSCR_PH9  PAD_CTL_DCU_CFG
#define S32V234_PAD_PH10__DCU_DE_C3   S32V234_MSCR_PH10 PAD_CTL_DCU_CFG

#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_DISABLE S32V234_MSCR_PH12 \
					PAD_CTL_DCU_CLK_CFG_DSE_DISABLE
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_240     S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_240)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_120     S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_120)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_80      S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_80)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_60      S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_60)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_48      S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_48)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_40      S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_40)
#define S32V234_PAD_PH12__DCU_PCLK_D1_DSE_34      S32V234_MSCR_PH12 \
					(PAD_CTL_DCU_CLK_CFG_DSE_DISABLE | \
					PAD_CTL_DSE_34)

#define S32V234_PAD_PH13__DCU_R0_D2  S32V234_MSCR_PH13 PAD_CTL_DCU_CFG
#define S32V234_PAD_PH14__DCU_R1_D3  S32V234_MSCR_PH14 PAD_CTL_DCU_CFG
#define S32V234_PAD_PH15__DCU_R2_D4  S32V234_MSCR_PH15 PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ0__DCU_R3_D5   S32V234_MSCR_PJ0  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ1__DCU_R4_D6   S32V234_MSCR_PJ1  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ2__DCU_R5_D7   S32V234_MSCR_PJ2  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ3__DCU_R6_D8   S32V234_MSCR_PJ3  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ4__DCU_R7_D9   S32V234_MSCR_PJ4  PAD_CTL_DCU_CFG

#define S32V234_PAD_PJ5__DCU_G0_D10  S32V234_MSCR_PJ5  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ6__DCU_G1_D11  S32V234_MSCR_PJ6  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ7__DCU_G2_D12  S32V234_MSCR_PJ7  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ8__DCU_G3_D13  S32V234_MSCR_PJ8  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ9__DCU_G4_D14  S32V234_MSCR_PJ9  PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ10__DCU_G5_D15 S32V234_MSCR_PJ10 PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ11__DCU_G6_D16 S32V234_MSCR_PJ11 PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ12__DCU_G7_D17 S32V234_MSCR_PJ12 PAD_CTL_DCU_CFG

#define S32V234_PAD_PJ13__DCU_B0_D18 S32V234_MSCR_PJ13 PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ14__DCU_B1_D19 S32V234_MSCR_PJ14 PAD_CTL_DCU_CFG
#define S32V234_PAD_PJ15__DCU_B2_D20 S32V234_MSCR_PJ15 PAD_CTL_DCU_CFG
#define S32V234_PAD_PK0__DCU_B3_D21  S32V234_MSCR_PK0  PAD_CTL_DCU_CFG
#define S32V234_PAD_PK1__DCU_B4_D22  S32V234_MSCR_PK1  PAD_CTL_DCU_CFG
#define S32V234_PAD_PK2__DCU_B5_D23  S32V234_MSCR_PK2  PAD_CTL_DCU_CFG
#define S32V234_PAD_PK3__DCU_B6_D24  S32V234_MSCR_PK3  PAD_CTL_DCU_CFG
#define S32V234_PAD_PK4__DCU_B7_D25  S32V234_MSCR_PK4  PAD_CTL_DCU_CFG

/* VIULite0 */
#define S32V234_PAD_PD13__VIU0_EN    S32V234_MSCR_PD13       PAD_CTL_VIU_IBE
#define S32V234_PAD_PD13__VIU0_PCLK  S32V234_IMCR_VIU0_PCLK  PAD_CTL_VIU_CFG
#define S32V234_PAD_PD14__VIU0_EN    S32V234_MSCR_PD14       PAD_CTL_VIU_IBE
#define S32V234_PAD_PD14__VIU0_HSYNC S32V234_IMCR_VIU0_HSYNC PAD_CTL_VIU_CFG
#define S32V234_PAD_PD15__VIU0_EN    S32V234_MSCR_PD15       PAD_CTL_VIU_IBE
#define S32V234_PAD_PD15__VIU0_VSYNC S32V234_IMCR_VIU0_VSYNC PAD_CTL_VIU_CFG

#define S32V234_PAD_PF3__VIU_EN      S32V234_MSCR_PF3        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF3__VIU0_D4     S32V234_IMCR_VIU0_D4    PAD_CTL_VIU_CFG
#define S32V234_PAD_PF4__VIU_EN      S32V234_MSCR_PF4        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF4__VIU0_D5     S32V234_IMCR_VIU0_D5    PAD_CTL_VIU_CFG
#define S32V234_PAD_PF5__VIU_EN      S32V234_MSCR_PF5        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF5__VIU0_D6     S32V234_IMCR_VIU0_D6    PAD_CTL_VIU_CFG
#define S32V234_PAD_PF6__VIU_EN      S32V234_MSCR_PF6        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF6__VIU0_D7     S32V234_IMCR_VIU0_D7    PAD_CTL_VIU_CFG
#define S32V234_PAD_PE0__VIU0_EN     S32V234_MSCR_PE0        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE0__VIU0_D8     S32V234_IMCR_VIU0_D8    PAD_CTL_VIU_CFG
#define S32V234_PAD_PE1__VIU0_EN     S32V234_MSCR_PE1        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE1__VIU0_D9     S32V234_IMCR_VIU0_D9    PAD_CTL_VIU_CFG
#define S32V234_PAD_PE2__VIU0_EN     S32V234_MSCR_PE2        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE2__VIU0_D10    S32V234_IMCR_VIU0_D10   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE3__VIU0_EN     S32V234_MSCR_PE3        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE3__VIU0_D11    S32V234_IMCR_VIU0_D11   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE4__VIU0_EN     S32V234_MSCR_PE4        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE4__VIU0_D12    S32V234_IMCR_VIU0_D12   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE5__VIU0_EN     S32V234_MSCR_PE5        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE5__VIU0_D13    S32V234_IMCR_VIU0_D13   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE6__VIU0_EN     S32V234_MSCR_PE6        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE6__VIU0_D14    S32V234_IMCR_VIU0_D14   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE7__VIU0_EN     S32V234_MSCR_PE7        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE7__VIU0_D15    S32V234_IMCR_VIU0_D15   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE8__VIU0_EN     S32V234_MSCR_PE8        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE8__VIU0_D16    S32V234_IMCR_VIU0_D16   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE9__VIU0_EN     S32V234_MSCR_PE9        PAD_CTL_VIU_IBE
#define S32V234_PAD_PE9__VIU0_D17    S32V234_IMCR_VIU0_D17   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE10__VIU0_EN    S32V234_MSCR_PE10       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE10__VIU0_D18   S32V234_IMCR_VIU0_D18   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE11__VIU0_EN    S32V234_MSCR_PE11       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE11__VIU0_D19   S32V234_IMCR_VIU0_D19   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE12__VIU0_EN    S32V234_MSCR_PE12       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE12__VIU0_D20   S32V234_IMCR_VIU0_D20   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE13__VIU0_EN    S32V234_MSCR_PE13       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE13__VIU0_D21   S32V234_IMCR_VIU0_D21   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE14__VIU0_EN    S32V234_MSCR_PE14       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE14__VIU0_D22   S32V234_IMCR_VIU0_D22   PAD_CTL_VIU_CFG
#define S32V234_PAD_PE15__VIU0_EN    S32V234_MSCR_PE15       PAD_CTL_VIU_IBE
#define S32V234_PAD_PE15__VIU0_D23   S32V234_IMCR_VIU0_D23   PAD_CTL_VIU_CFG

/* VIULite1 */
#define S32V234_PAD_PF0__VIU1_EN    S32V234_MSCR_PF0        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF0__VIU1_PCLK  S32V234_IMCR_VIU1_PCLK  PAD_CTL_VIU_CFG
#define S32V234_PAD_PF1__VIU1_EN    S32V234_MSCR_PF1        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF1__VIU1_HSYNC S32V234_IMCR_VIU1_HSYNC PAD_CTL_VIU_CFG
#define S32V234_PAD_PF2__VIU1_EN    S32V234_MSCR_PF2        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF2__VIU1_VSYNC S32V234_IMCR_VIU1_VSYNC PAD_CTL_VIU_CFG

#define S32V234_PAD_PF3__VIU_EN     S32V234_MSCR_PF3        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF3__VIU1_D8    S32V234_IMCR_VIU1_D8    PAD_CTL_VIU_CFG
#define S32V234_PAD_PF4__VIU_EN     S32V234_MSCR_PF4        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF4__VIU1_D9    S32V234_IMCR_VIU1_D9    PAD_CTL_VIU_CFG
#define S32V234_PAD_PF5__VIU_EN     S32V234_MSCR_PF5        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF5__VIU1_D10   S32V234_IMCR_VIU1_D10   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF6__VIU_EN     S32V234_MSCR_PF6        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF6__VIU1_D11   S32V234_IMCR_VIU1_D11   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF7__VIU1_EN    S32V234_MSCR_PF7        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF7__VIU1_D12   S32V234_IMCR_VIU1_D12   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF8__VIU1_EN    S32V234_MSCR_PF8        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF8__VIU1_D13   S32V234_IMCR_VIU1_D13   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF9__VIU1_EN    S32V234_MSCR_PF9        PAD_CTL_VIU_IBE
#define S32V234_PAD_PF9__VIU1_D14   S32V234_IMCR_VIU1_D14   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF10__VIU1_EN   S32V234_MSCR_PF10       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF10__VIU1_D15  S32V234_IMCR_VIU1_D15   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF11__VIU1_EN   S32V234_MSCR_PF11       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF11__VIU1_D16  S32V234_IMCR_VIU1_D16   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF12__VIU1_EN   S32V234_MSCR_PF12       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF12__VIU1_D17  S32V234_IMCR_VIU1_D17   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF13__VIU1_EN   S32V234_MSCR_PF13       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF13__VIU1_D18  S32V234_IMCR_VIU1_D18   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF14__VIU1_EN   S32V234_MSCR_PF14       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF14__VIU1_D19  S32V234_IMCR_VIU1_D19   PAD_CTL_VIU_CFG
#define S32V234_PAD_PF15__VIU1_EN   S32V234_MSCR_PF15       PAD_CTL_VIU_IBE
#define S32V234_PAD_PF15__VIU1_D20  S32V234_IMCR_VIU1_D20   PAD_CTL_VIU_CFG
#define S32V234_PAD_PG0__VIU1_EN    S32V234_MSCR_PG0        PAD_CTL_VIU_IBE
#define S32V234_PAD_PG0__VIU1_D21   S32V234_IMCR_VIU1_D21   PAD_CTL_VIU_CFG
#define S32V234_PAD_PG1__VIU1_EN    S32V234_MSCR_PG1        PAD_CTL_VIU_IBE
#define S32V234_PAD_PG1__VIU1_D22   S32V234_IMCR_VIU1_D22   PAD_CTL_VIU_CFG
#define S32V234_PAD_PG2__VIU1_EN    S32V234_MSCR_PG2        PAD_CTL_VIU_IBE
#define S32V234_PAD_PG2__VIU1_D23   S32V234_IMCR_VIU1_D23   PAD_CTL_VIU_CFG

/* SPI 0-3 */
#define S32V234_PAD_PB6__SPI0_SOUT_OUT  S32V234_MSCR_PB6 PAD_CTL_SPI_MSCR_SOUT
#define S32V234_PAD_PB7__SPI0_SIN_OUT   S32V234_MSCR_PB7 PAD_CTL_SPI_MSCR_SIN
#define S32V234_PAD_PB7__SPI0_SIN_IN    S32V234_IMCR_SPI0_SIN \
					PAD_CTL_SPI_IMCR_SIN
#define S32V234_PAD_PB5__SPI0_SCK_OUT   S32V234_MSCR_PB5 PAD_CTL_SPI_MSCR_SCK
#define S32V234_PAD_PB8__SPI0_CS0_OUT   S32V234_MSCR_PB8 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT1)
#define S32V234_PAD_PC0__SPI0_CS4_OUT   S32V234_MSCR_PC0 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT3)
#define S32V234_PAD_PC1__SPI0_CS5_OUT   S32V234_MSCR_PC1 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT3)
#define S32V234_PAD_PC2__SPI0_CS6_OUT   S32V234_MSCR_PC2 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT3)
#define S32V234_PAD_PC3__SPI0_CS7_OUT   S32V234_MSCR_PC3 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT2)

#define S32V234_PAD_PB10__SPI1_SOUT_OUT S32V234_MSCR_PB10 PAD_CTL_SPI_MSCR_SOUT
#define S32V234_PAD_PB11__SPI1_SIN_OUT  S32V234_MSCR_PB11 PAD_CTL_SPI_MSCR_SIN
#define S32V234_PAD_PB11__SPI1_SIN_IN   S32V234_IMCR_SPI1_SIN \
					PAD_CTL_SPI_IMCR_SIN
#define S32V234_PAD_PB9__SPI1_SCK_OUT   S32V234_MSCR_PB9 PAD_CTL_SPI_MSCR_SCK
#define S32V234_PAD_PB12__SPI1_CS0_OUT  S32V234_MSCR_PB12 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT1)

#define S32V234_PAD_PB14__SPI2_SOUT_OUT S32V234_MSCR_PB14 PAD_CTL_SPI_MSCR_SOUT
#define S32V234_PAD_PB15__SPI2_SIN_OUT  S32V234_MSCR_PB15 PAD_CTL_SPI_MSCR_SIN
#define S32V234_PAD_PB15__SPI2_SIN_IN   S32V234_IMCR_SPI2_SIN \
					PAD_CTL_SPI_IMCR_SIN
#define S32V234_PAD_P13__SPI2_SCK_OUT   S32V234_MSCR_PB13 PAD_CTL_SPI_MSCR_SCK
#define S32V234_PAD_PC0__SPI2_CS0_OUT   S32V234_MSCR_PC0 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT1)

#define S32V234_PAD_PC2__SPI3_SOUT_OUT  S32V234_MSCR_PC2 PAD_CTL_SPI_MSCR_SOUT
#define S32V234_PAD_PC3__SPI3_SIN_OUT   S32V234_MSCR_PC3 PAD_CTL_SPI_MSCR_SIN
#define S32V234_PAD_PC3__SPI3_SIN_IN    S32V234_IMCR_SPI3_SIN \
					PAD_CTL_SPI_IMCR_SIN
#define S32V234_PAD_PC1__SPI3_SCK_OUT   S32V234_MSCR_PC1 PAD_CTL_SPI_MSCR_SCK
#define S32V234_PAD_PC4__SPI3_CS0_OUT   S32V234_MSCR_PC4 \
					(PAD_CTL_SPI_MSCR_CSx | \
					PAD_CTL_MUX_MODE_ALT1)

/* SIUL2 GPIOs */
#define S32V234_PAD_PA0__SIUL_GPIO0    S32V234_MSCR_PA0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA1__SIUL_GPIO1    S32V234_MSCR_PA1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA2__SIUL_GPIO2    S32V234_MSCR_PA2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA3__SIUL_GPIO3    S32V234_MSCR_PA3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA4__SIUL_GPIO4    S32V234_MSCR_PA4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA5__SIUL_GPIO5    S32V234_MSCR_PA5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA6__SIUL_GPIO6    S32V234_MSCR_PA6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA7__SIUL_GPIO7    S32V234_MSCR_PA7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA8__SIUL_GPIO8    S32V234_MSCR_PA8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA9__SIUL_GPIO9    S32V234_MSCR_PA9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA10__SIUL_GPIO10  S32V234_MSCR_PA10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA11__SIUL_GPIO11  S32V234_MSCR_PA11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA12__SIUL_GPIO12  S32V234_MSCR_PA12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA13__SIUL_GPIO13  S32V234_MSCR_PA13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA14__SIUL_GPIO14  S32V234_MSCR_PA14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PA15__SIUL_GPIO15  S32V234_MSCR_PA15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB0__SIUL_GPIO16   S32V234_MSCR_PB0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB1__SIUL_GPIO17   S32V234_MSCR_PB1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB2__SIUL_GPIO18   S32V234_MSCR_PB2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB3__SIUL_GPIO19   S32V234_MSCR_PB3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB4__SIUL_GPIO20   S32V234_MSCR_PB4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB5__SIUL_GPIO21   S32V234_MSCR_PB5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB6__SIUL_GPIO22   S32V234_MSCR_PB6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB7__SIUL_GPIO23   S32V234_MSCR_PB7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB8__SIUL_GPIO24   S32V234_MSCR_PB8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB9__SIUL_GPIO25   S32V234_MSCR_PB9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB10__SIUL_GPIO26  S32V234_MSCR_PB10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB11__SIUL_GPIO27  S32V234_MSCR_PB11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB12__SIUL_GPIO28  S32V234_MSCR_PB12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB13__SIUL_GPIO29  S32V234_MSCR_PB13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB14__SIUL_GPIO30  S32V234_MSCR_PB14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PB15__SIUL_GPIO31  S32V234_MSCR_PB15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC0__SIUL_GPIO32   S32V234_MSCR_PC0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC1__SIUL_GPIO33   S32V234_MSCR_PC1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC2__SIUL_GPIO34   S32V234_MSCR_PC2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC3__SIUL_GPIO35   S32V234_MSCR_PC3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC4__SIUL_GPIO36   S32V234_MSCR_PC4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC5__SIUL_GPIO37   S32V234_MSCR_PC5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC6__SIUL_GPIO38   S32V234_MSCR_PC6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC7__SIUL_GPIO39   S32V234_MSCR_PC7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC8__SIUL_GPIO40   S32V234_MSCR_PC8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC9__SIUL_GPIO41   S32V234_MSCR_PC9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC10__SIUL_GPIO42  S32V234_MSCR_PC10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC11__SIUL_GPIO43  S32V234_MSCR_PC11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC12__SIUL_GPIO44  S32V234_MSCR_PC12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC13__SIUL_GPIO45  S32V234_MSCR_PC13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC14__SIUL_GPIO46  S32V234_MSCR_PC14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PC15__SIUL_GPIO47  S32V234_MSCR_PC15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD0__SIUL_GPIO48   S32V234_MSCR_PD0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD1__SIUL_GPIO49   S32V234_MSCR_PD1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD2__SIUL_GPIO50   S32V234_MSCR_PD2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD3__SIUL_GPIO51   S32V234_MSCR_PD3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD4__SIUL_GPIO52   S32V234_MSCR_PD4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD5__SIUL_GPIO53   S32V234_MSCR_PD5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD6__SIUL_GPIO54   S32V234_MSCR_PD6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD7__SIUL_GPIO55   S32V234_MSCR_PD7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD8__SIUL_GPIO56   S32V234_MSCR_PD8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD9__SIUL_GPIO57   S32V234_MSCR_PD9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD10__SIUL_GPIO58  S32V234_MSCR_PD10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD11__SIUL_GPIO59  S32V234_MSCR_PD11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD12__SIUL_GPIO60  S32V234_MSCR_PD12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD13__SIUL_GPIO61  S32V234_MSCR_PD13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD14__SIUL_GPIO62  S32V234_MSCR_PD14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PD15__SIUL_GPIO63  S32V234_MSCR_PD15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE0__SIUL_GPIO64   S32V234_MSCR_PE0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE1__SIUL_GPIO65   S32V234_MSCR_PE1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE2__SIUL_GPIO66   S32V234_MSCR_PE2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE3__SIUL_GPIO67   S32V234_MSCR_PE3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE4__SIUL_GPIO68   S32V234_MSCR_PE4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE5__SIUL_GPIO69   S32V234_MSCR_PE5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE6__SIUL_GPIO70   S32V234_MSCR_PE6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE7__SIUL_GPIO71   S32V234_MSCR_PE7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE8__SIUL_GPIO72   S32V234_MSCR_PE8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE9__SIUL_GPIO73   S32V234_MSCR_PE9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE10__SIUL_GPIO74  S32V234_MSCR_PE10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE11__SIUL_GPIO75  S32V234_MSCR_PE11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE12__SIUL_GPIO76  S32V234_MSCR_PE12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE13__SIUL_GPIO77  S32V234_MSCR_PE13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE14__SIUL_GPIO78  S32V234_MSCR_PE14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PE15__SIUL_GPIO79  S32V234_MSCR_PE15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF0__SIUL_GPIO80   S32V234_MSCR_PF0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF1__SIUL_GPIO81   S32V234_MSCR_PF1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF2__SIUL_GPIO82   S32V234_MSCR_PF2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF3__SIUL_GPIO83   S32V234_MSCR_PF3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF4__SIUL_GPIO84   S32V234_MSCR_PF4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF5__SIUL_GPIO85   S32V234_MSCR_PF5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF6__SIUL_GPIO86   S32V234_MSCR_PF6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF7__SIUL_GPIO87   S32V234_MSCR_PF7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF8__SIUL_GPIO88   S32V234_MSCR_PF8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF9__SIUL_GPIO89   S32V234_MSCR_PF9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF10__SIUL_GPIO90  S32V234_MSCR_PF10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF11__SIUL_GPIO91  S32V234_MSCR_PF11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF12__SIUL_GPIO92  S32V234_MSCR_PF12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF13__SIUL_GPIO93  S32V234_MSCR_PF13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF14__SIUL_GPIO94  S32V234_MSCR_PF14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PF15__SIUL_GPIO95  S32V234_MSCR_PF15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG0__SIUL_GPIO96   S32V234_MSCR_PG0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG1__SIUL_GPIO97   S32V234_MSCR_PG1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG2__SIUL_GPIO98   S32V234_MSCR_PG2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG3__SIUL_GPIO99   S32V234_MSCR_PG3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG4__SIUL_GPIO100  S32V234_MSCR_PG4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG5__SIUL_GPIO101  S32V234_MSCR_PG5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG6__SIUL_GPIO102  S32V234_MSCR_PG6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG7__SIUL_GPIO103  S32V234_MSCR_PG7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG8__SIUL_GPIO104  S32V234_MSCR_PG8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG9__SIUL_GPIO105  S32V234_MSCR_PG9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG10__SIUL_GPIO106 S32V234_MSCR_PG10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG11__SIUL_GPIO107 S32V234_MSCR_PG11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG12__SIUL_GPIO108 S32V234_MSCR_PG12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG13__SIUL_GPIO109 S32V234_MSCR_PG13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG14__SIUL_GPIO110 S32V234_MSCR_PG14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PG15__SIUL_GPIO111 S32V234_MSCR_PG15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH0__SIUL_GPIO112  S32V234_MSCR_PH0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH1__SIUL_GPIO113  S32V234_MSCR_PH1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH2__SIUL_GPIO114  S32V234_MSCR_PH2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH3__SIUL_GPIO115  S32V234_MSCR_PH3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH4__SIUL_GPIO116  S32V234_MSCR_PH4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH5__SIUL_GPIO117  S32V234_MSCR_PH5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH6__SIUL_GPIO118  S32V234_MSCR_PH6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH7__SIUL_GPIO119  S32V234_MSCR_PH7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH8__SIUL_GPIO120  S32V234_MSCR_PH8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH9__SIUL_GPIO121  S32V234_MSCR_PH9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH10__SIUL_GPIO122 S32V234_MSCR_PH10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH11__SIUL_GPIO123 S32V234_MSCR_PH11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH12__SIUL_GPIO124 S32V234_MSCR_PH12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH13__SIUL_GPIO125 S32V234_MSCR_PH13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH14__SIUL_GPIO126 S32V234_MSCR_PH14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PH15__SIUL_GPIO127 S32V234_MSCR_PH15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ0__SIUL_GPIO128  S32V234_MSCR_PJ0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ1__SIUL_GPIO129  S32V234_MSCR_PJ1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ2__SIUL_GPIO130  S32V234_MSCR_PJ2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ3__SIUL_GPIO131  S32V234_MSCR_PJ3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ4__SIUL_GPIO132  S32V234_MSCR_PJ4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ5__SIUL_GPIO133  S32V234_MSCR_PJ5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ6__SIUL_GPIO134  S32V234_MSCR_PJ6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ7__SIUL_GPIO135  S32V234_MSCR_PJ7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ8__SIUL_GPIO136  S32V234_MSCR_PJ8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ9__SIUL_GPIO137  S32V234_MSCR_PJ9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ10__SIUL_GPIO138 S32V234_MSCR_PJ10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ11__SIUL_GPIO139 S32V234_MSCR_PJ11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ12__SIUL_GPIO140 S32V234_MSCR_PJ12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ13__SIUL_GPIO141 S32V234_MSCR_PJ13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ14__SIUL_GPIO142 S32V234_MSCR_PJ14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PJ15__SIUL_GPIO143 S32V234_MSCR_PJ15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK0__SIUL_GPIO144  S32V234_MSCR_PK0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK1__SIUL_GPIO145  S32V234_MSCR_PK1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK2__SIUL_GPIO146  S32V234_MSCR_PK2  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK3__SIUL_GPIO147  S32V234_MSCR_PK3  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK4__SIUL_GPIO148  S32V234_MSCR_PK4  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK5__SIUL_GPIO149  S32V234_MSCR_PK5  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK6__SIUL_GPIO150  S32V234_MSCR_PK6  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK7__SIUL_GPIO151  S32V234_MSCR_PK7  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK8__SIUL_GPIO152  S32V234_MSCR_PK8  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK9__SIUL_GPIO153  S32V234_MSCR_PK9  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK10__SIUL_GPIO154 S32V234_MSCR_PK10 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK11__SIUL_GPIO155 S32V234_MSCR_PK11 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK12__SIUL_GPIO156 S32V234_MSCR_PK12 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK13__SIUL_GPIO157 S32V234_MSCR_PK13 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK14__SIUL_GPIO158 S32V234_MSCR_PK14 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PK15__SIUL_GPIO159 S32V234_MSCR_PK15 PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PL0__SIUL_GPIO160  S32V234_MSCR_PL0  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PL1__SIUL_GPIO161  S32V234_MSCR_PL1  PAD_CTL_MUX_MODE_ALT0
#define S32V234_PAD_PL2__SIUL_GPIO162  S32V234_MSCR_PL2  PAD_CTL_MUX_MODE_ALT0

/* SIUL2 EIRQ pins */
#define S32V234_PAD_PA0__SIUL_EIRQ0   S32V234_IMCR_SIUL_EIRQ0  PAD_CTL_EIRQ
#define S32V234_PAD_PA1__SIUL_EIRQ1   S32V234_IMCR_SIUL_EIRQ1  PAD_CTL_EIRQ
#define S32V234_PAD_PA2__SIUL_EIRQ2   S32V234_IMCR_SIUL_EIRQ2  PAD_CTL_EIRQ
#define S32V234_PAD_PA3__SIUL_EIRQ3   S32V234_IMCR_SIUL_EIRQ3  PAD_CTL_EIRQ
#define S32V234_PAD_PA4__SIUL_EIRQ4   S32V234_IMCR_SIUL_EIRQ4  PAD_CTL_EIRQ
#define S32V234_PAD_PA5__SIUL_EIRQ5   S32V234_IMCR_SIUL_EIRQ5  PAD_CTL_EIRQ
#define S32V234_PAD_PA6__SIUL_EIRQ6   S32V234_IMCR_SIUL_EIRQ6  PAD_CTL_EIRQ
#define S32V234_PAD_PA7__SIUL_EIRQ7   S32V234_IMCR_SIUL_EIRQ7  PAD_CTL_EIRQ
#define S32V234_PAD_PA8__SIUL_EIRQ8   S32V234_IMCR_SIUL_EIRQ8  PAD_CTL_EIRQ
#define S32V234_PAD_PA9__SIUL_EIRQ9   S32V234_IMCR_SIUL_EIRQ9  PAD_CTL_EIRQ
#define S32V234_PAD_PA10__SIUL_EIRQ10 S32V234_IMCR_SIUL_EIRQ10 PAD_CTL_EIRQ
#define S32V234_PAD_PA11__SIUL_EIRQ11 S32V234_IMCR_SIUL_EIRQ11 PAD_CTL_EIRQ
#define S32V234_PAD_PA12__SIUL_EIRQ12 S32V234_IMCR_SIUL_EIRQ12 PAD_CTL_EIRQ
#define S32V234_PAD_PA13__SIUL_EIRQ13 S32V234_IMCR_SIUL_EIRQ13 PAD_CTL_EIRQ
#define S32V234_PAD_PA14__SIUL_EIRQ14 S32V234_IMCR_SIUL_EIRQ14 PAD_CTL_EIRQ
#define S32V234_PAD_PA15__SIUL_EIRQ15 S32V234_IMCR_SIUL_EIRQ15 PAD_CTL_EIRQ
#define S32V234_PAD_PB0__SIUL_EIRQ16  S32V234_IMCR_SIUL_EIRQ16 PAD_CTL_EIRQ
#define S32V234_PAD_PB1__SIUL_EIRQ17  S32V234_IMCR_SIUL_EIRQ17 PAD_CTL_EIRQ
#define S32V234_PAD_PB2__SIUL_EIRQ18  S32V234_IMCR_SIUL_EIRQ18 PAD_CTL_EIRQ
#define S32V234_PAD_PB3__SIUL_EIRQ19  S32V234_IMCR_SIUL_EIRQ19 PAD_CTL_EIRQ
#define S32V234_PAD_PB4__SIUL_EIRQ20  S32V234_IMCR_SIUL_EIRQ20 PAD_CTL_EIRQ
#define S32V234_PAD_PB5__SIUL_EIRQ21  S32V234_IMCR_SIUL_EIRQ21 PAD_CTL_EIRQ
#define S32V234_PAD_PB6__SIUL_EIRQ22  S32V234_IMCR_SIUL_EIRQ22 PAD_CTL_EIRQ
#define S32V234_PAD_PB7__SIUL_EIRQ23  S32V234_IMCR_SIUL_EIRQ23 PAD_CTL_EIRQ
#define S32V234_PAD_PB8__SIUL_EIRQ24  S32V234_IMCR_SIUL_EIRQ24 PAD_CTL_EIRQ
#define S32V234_PAD_PB9__SIUL_EIRQ25  S32V234_IMCR_SIUL_EIRQ25 PAD_CTL_EIRQ
#define S32V234_PAD_PB10__SIUL_EIRQ26 S32V234_IMCR_SIUL_EIRQ26 PAD_CTL_EIRQ
#define S32V234_PAD_PB11__SIUL_EIRQ27 S32V234_IMCR_SIUL_EIRQ27 PAD_CTL_EIRQ
#define S32V234_PAD_PB12__SIUL_EIRQ28 S32V234_IMCR_SIUL_EIRQ28 PAD_CTL_EIRQ
#define S32V234_PAD_PB13__SIUL_EIRQ29 S32V234_IMCR_SIUL_EIRQ29 PAD_CTL_EIRQ
#define S32V234_PAD_PB14__SIUL_EIRQ30 S32V234_IMCR_SIUL_EIRQ30 PAD_CTL_EIRQ
#define S32V234_PAD_PB15__SIUL_EIRQ31 S32V234_IMCR_SIUL_EIRQ31 PAD_CTL_EIRQ

#endif /* __DT_BINDINGS_S32V234_PINCTRL_H__ */
