#ifndef __OCP2131_BIAS__
#define __OCP2131_BIAS__

#define OCP2131_Positive_Output				0X00
#define OCP2131_Negative_Output				0X01
#define OCP2131_Set_voltage					0x14
#define OCP2131_Set_vsp_vsn_enable			0x03
#define OCP2131_Set_value					0x03
#define OCP2131_Mtp_Reg						0xFF
#define OCP2131_Mtp_save					0x80

#define LCD_BIAS_POSCNTL_REG				0x00
#define LCD_BIAS_NEGCNTL_REG				0x01
#define LCD_BIAS_CONTROL_REG				0x03
#define OCP2312_chip_id						0x04

struct lcd_bais_data {
	struct device *dev;
	struct i2c_client *client;
	struct mutex i2c_rw_lock;
	int enp_gpio;
	int enn_gpio;
	int select_bias_flag;				//select bias devices
};

static long lcd_bias_set_state(struct lcd_bais_data *bias, unsigned int s);
static int lcd_bias_write_reg(struct lcd_bais_data *bias, u8 reg, u8 val);

enum {
	ocp2131_bias = 0,
	sm5109c_bias,
};

enum {
	LCD_BIAS_GPIO_STATE_ENP0 = 0,
	LCD_BIAS_GPIO_STATE_ENP1,
	LCD_BIAS_GPIO_STATE_ENN0,
	LCD_BIAS_GPIO_STATE_ENN1,
	LCD_BIAS_GPIO_STATE_MAX,
};




#endif

