#ifndef __RTk_CONFIG_SWITCH_H__
#define __RTk_CONFIG_SWITCH_H__
#include <linux/gn_low_level_api.h>
#include <rtk_types.h>
#include <stat.h>
#include <port.h>


extern unsigned char rtl83_host_mac[6];

enum {
	rtkNetEthMiiReadReg,
	rtkNetEthMiiWriteReg,
	rtkNetEswEthProtectSet,
	rtkNetEswEthProtectGet,
	rtkNetEswEthProtectReset,
	rtkNetEswEthProtectStatus, //5
	rtkEthFilterBsp,
	rtkEthFilterAllPacket,
	rtkEthAddMcastMac,
	rtkTag8021QGlobalEnable,
	rtkTag8021QGlobalDisable, //10
	rtkTag8021QGlobalUPSet,
	rtkGetEthMib,
	rtkClearEthMib,
	rtkEthSetPortSpeed,
	rtkEthQueryLink, //15
	rtkEthGetL2Addr,
	rtkEthSTPblockAllPort,
	rtkEthGetMcastMacEntry,
};

typedef struct mii_data {
	__u16		phy_id;
	__u16		reg_num;
	__u16		val_in;
	__u32		val_out;
}phy_para;

typedef struct
{
	gn_port_t 			port;
	gn_port_mode_t 	speed_mode;

}gn_port_cfg;

typedef struct
{
	int					vid;
	unsigned char 		mac[6];
	char 				action;
	char					qos;
	gn_enable_t 			enable;
	rtk_uint32 			addr_id;
	rtk_l2_mcastAddr_t	l2McstAddr;
	rtk_l2_ucastAddr_t		l2Addr;

}gn_switch_cfg;

typedef struct
{
	gn_port_t 			port;
	gn_enable_t 		enable;
	char 			en_sta;
	char 			status;
}gn_protect_cfg;

typedef struct
{
	gn_port_t 			port;
	unsigned int 		rate;
}gn_rate_limit;

struct rtk_switch_cfg {
	unsigned int cmd;
	union {
		phy_para 			mii_data;
		rtk_stat_port_cntr_t    	allCnt;
		gn_ethlink_t			portLink;
		gn_port_cfg			port;
		gn_switch_cfg			sw_set;
		gn_protect_cfg			protect;
		gn_rate_limit			rate;
		char buf[4096];
	} cmd_data;
	unsigned int ret_type;
};

int rtl83_switch_init(void);

#endif /* __RTK_CONFIG_SWITCH_H__*/
