#ifndef __GN_LOW_LEVEL_API__
#define __GN_LOW_LEVEL_API__

#include <rtk_types.h>
#include <stat.h>
#include <port.h>
#include <l2.h>

typedef enum
{
    GN_SUCCESS = 0,
    GN_FAILURE = -1
} gn_status_t;

typedef enum {
    GN_DISABLE = 0,
    GN_ENABLE
} gn_enable_t;

typedef enum
{
    LAN_PORT = 0,
    PC_PORT,
    CPU_PORT,
    UNKNOW_PORT
} gn_port_t;

typedef enum {
    PORT_MODE_AUTO = 1,
    PORT_MODE_10_HALF,
    PORT_MODE_10_FULL,
    PORT_MODE_100_HALF,
    PORT_MODE_100_FULL,
    PORT_MODE_1000_FULL,
    PORT_MODE_MAX
} gn_port_mode_t;

typedef enum
{
   LNK_DWN = 0,
   LNK_UP
} gn_link_status_t;

typedef enum
{
   LINK_10M = 10,
   LINK_100M = 100,
   LINK_1000M = 1000
} gn_link_speed_t;
typedef enum
{
   LINK_HALF = 0,
   LINK_FULL
} gn_link_duplex_t;
typedef struct
{
   gn_port_t   		port;
   gn_link_status_t   status;
   gn_link_speed_t   speed;
   gn_link_duplex_t  duplex;
} gn_ethlink_t;

gn_status_t rtl83_config_init(unsigned char *host_mac);
gn_status_t NetEthMiiReadReg(gn_port_t port, rtk_port_phy_reg_t reg, rtk_port_phy_data_t *pData);
gn_status_t NetEthMiiWriteReg(gn_port_t port, rtk_port_phy_reg_t reg, rtk_port_phy_data_t regData);
gn_status_t NetEswEthProtectSet(gn_port_t port, gn_enable_t enable);
gn_status_t NetEswEthProtectGet(gn_port_t port, rtk_int8 *enable);
gn_status_t NetEswEthProtectReset(void);
gn_status_t NetEswEthProtectStatus(rtk_int8 *status);
gn_status_t EthFilterBsp(gn_port_t port, rtk_uint32 rate);
gn_status_t EthFilterAllPacket(rtk_uint32 rate);
gn_status_t EthAddMcastMac(char action, unsigned char* macAddr);
gn_status_t Tag8021QGlobalEnable(rtk_int32 vid);
gn_status_t Tag8021QGlobalDisable(rtk_int32 vid);
gn_status_t Tag8021QGlobalUPSet (rtk_int8 qos);
gn_status_t GetEthMib(gn_port_t port, rtk_stat_port_cntr_t *outData);
gn_status_t ClearEthMib(gn_port_t port);
gn_status_t EthSetPortSpeed ( gn_port_t port, gn_port_mode_t mode );
gn_status_t EthQueryLink ( gn_ethlink_t *link );
gn_status_t EthGetL2AddrMac(rtk_uint32 *pAddress, rtk_l2_ucastAddr_t *pL2_data);
gn_status_t EthSTPblockAllPort(gn_enable_t enable);
gn_status_t EthGetMcastMacEntry(rtk_uint32 *pAddr_id, rtk_l2_mcastAddr_t *pMcastAddr);
#endif
