load(
    "//build/kernel/kleaf:kernel.bzl",
    "kernel_abi",
    "kernel_build",
)

_IMX_EXT_MODULES = [
	"//nxp-mwifiex/mxm_wifiex/wlan_src:wlan.imx",
	"//verisilicon_sw_isp_vvcam/vvcam/v4l2:isp.imx",
]

_IMX_IN_TREE_MODULES = [
    "drivers/nvmem/nvmem-imx-ocotp-fsb-s400.ko",
    "drivers/firmware/imx/el_enclave.ko",
    "drivers/gpu/drm/imx/imxdrm.ko",
    "drivers/i2c/i2c-dev.ko",
    "drivers/rtc/rtc-imx-rpmsg.ko",
    "drivers/hwmon/fp9931-hwmon.ko",
    "drivers/gpu/drm/imx/lcdif/imx8mm-lcdif-crtc.ko",
    "drivers/iio/imu/st_lsm6dsx/st_lsm6dsx_i2c.ko",
    "sound/soc/sof/imx/snd-sof-imx8m.ko",
    "sound/soc/codecs/snd-soc-wm8960.ko",
    "drivers/staging/media/imx/imx8-capture.ko",
    "drivers/regulator/pca9450-regulator.ko",
    "drivers/usb/typec/mux/gpio-switch.ko",
    "drivers/gpu/drm/imx/mhdp/cdns_mhdp_imx.ko",
    "drivers/rpmsg/rpmsg_ns.ko",
    "drivers/base/regmap/regmap-i3c.ko",
    "drivers/usb/common/ulpi.ko",
    "sound/soc/codecs/snd-soc-wm8524.ko",
    "sound/soc/codecs/snd-soc-ak5558.ko",
    "drivers/gpu/drm/imx/dw_hdmi-imx.ko",
    "drivers/soc/imx/busfreq-imx8mq.ko",
    "drivers/spi/spidev.ko",
    "drivers/soc/imx/rpmsg_life_cycle.ko",
    "drivers/i2c/busses/i2c-rpmsg-imx.ko",
    "drivers/dma/pxp/pxp_device.ko",
    "sound/soc/codecs/snd-soc-tpa6130a2.ko",
    "drivers/mxc/hantro_845_h1/hx280enc.ko",
    "drivers/gpu/drm/bridge/synopsys/dw-hdmi.ko",
    "drivers/mailbox/imx-mailbox.ko",
    "drivers/net/phy/at803x.ko",
    "drivers/soc/imx/soc-imx8m.ko",
    "drivers/mux/mux-mmio.ko",
    "drivers/video/fbdev/mxc/mxc_epdc_v2_fb.ko",
    "drivers/reset/reset-dispmix.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8mq.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8mp.ko",
    "drivers/video/fbdev/core/cfbimgblt.ko",
    "drivers/clk/imx/clk-imx8mn.ko",
    "drivers/gpu/drm/bridge/cadence/cdns_mhdp_drmcore.ko",
    "sound/soc/fsl/snd-soc-fsl-utils.ko",
    "drivers/usb/dwc3/dwc3-imx8mp.ko",
    "drivers/iio/imu/st_lsm6dsx/st_lsm6dsx_spi.ko",
    "drivers/irqchip/irq-imx-mu-msi.ko",
    "drivers/gpu/drm/bridge/adv7511/adv7511.ko",
    "sound/soc/fsl/snd-soc-fsl-rpmsg.ko",
    "drivers/gpu/drm/display/drm_display_helper.ko",
    "sound/soc/fsl/snd-soc-imx-audmux.ko",
    "sound/soc/codecs/snd-soc-hdmi-codec.ko",
    "drivers/rtc/rtc-snvs.ko",
    "sound/soc/fsl/snd-soc-fsl-spdif.ko",
    "drivers/clk/imx/clk-imx8ulp.ko",
    "drivers/video/fbdev/core/fb.ko",
    "drivers/remoteproc/imx_dsp_rproc.ko",
    "drivers/iio/pressure/mpl3115.ko",
    "sound/soc/fsl/imx-audio-rpmsg.ko",
    "drivers/trusty/trusty-irq.ko",
    "drivers/thermal/imx8mm_thermal.ko",
    "drivers/gpu/drm/bridge/fsl-imx-ldb.ko",
    "drivers/trusty/trusty-virtio.ko",
    "drivers/staging/media/imx/gmsl-max9286.ko",
    "drivers/net/phy/micrel.ko",
    "drivers/gpu/drm/bridge/sec-dsim.ko",
    "drivers/mmc/host/sdhci-esdhc-imx.ko",
    "drivers/mmc/host/cqhci.ko",
    "sound/soc/fsl/snd-soc-fsl-easrc.ko",
    "drivers/usb/chipidea/ci_hdrc_imx.ko",
    "sound/soc/codecs/snd-soc-wm-hubs.ko",
    "drivers/mxc/hantro/hantrodec.ko",
    "drivers/mtd/spi-nor/spi-nor.ko",
    "drivers/gpu/drm/panel/panel-raydium-rm67191.ko",
    "drivers/usb/phy/phy-generic.ko",
    "drivers/dma/mxs-dma.ko",
    "sound/soc/fsl/snd-soc-fsl-ssi.ko",
    "sound/soc/fsl/snd-soc-fsl-micfil.ko",
    "drivers/staging/media/imx/imx8-media-dev.ko",
    "drivers/gpu/drm/imx/imx8mp-ldb.ko",
    "drivers/gpu/drm/drm_dma_helper.ko",
    "drivers/pinctrl/freescale/pinctrl-imx.ko",
    "drivers/rpmsg/virtio_rpmsg_bus.ko",
    "drivers/phy/freescale/phy-fsl-imx8mq-usb.ko",
    "drivers/mtd/parsers/ofpart.ko",
    "drivers/net/ethernet/freescale/fec.ko",
    "drivers/iio/imu/st_lsm6dsx/st_lsm6dsx_i3c.ko",
    "sound/soc/codecs/snd-soc-rpmsg-wm8960.ko",
    "drivers/usb/chipidea/ci_hdrc.ko",
    "drivers/leds/leds-gpio.ko",
    "drivers/i2c/busses/i2c-imx.ko",
    "drivers/usb/chipidea/ci_hdrc_msm.ko",
    "drivers/clk/imx/clk-imx8mp.ko",
    "drivers/video/fbdev/core/cfbcopyarea.ko",
    "sound/soc/codecs/snd-soc-bt-sco.ko",
    "drivers/pwm/pwm-rpmsg-imx.ko",
    "drivers/video/fbdev/mxc/fb_fence.ko",
    "sound/soc/sof/imx/snd-sof-imx8ulp.ko",
    "drivers/gpu/drm/bridge/synopsys/dw-hdmi-gp-audio.ko",
    "drivers/input/touchscreen/goodix_ts.ko",
    "drivers/spi/spi-nxp-fspi.ko",
    "drivers/usb/chipidea/usbmisc_imx.ko",
    "drivers/clocksource/timer-imx-tpm.ko",
    "sound/soc/sof/snd-sof-utils.ko",
    "drivers/remoteproc/imx_rproc.ko",
    "drivers/soc/imx/gpcv2.ko",
    "drivers/media/v4l2-core/v4l2-fwnode.ko",
    "sound/soc/fsl/snd-soc-imx-rpmsg.ko",
    "drivers/tty/serial/fsl_lpuart.ko",
    "drivers/gpu/drm/imx/dcss/imx-dcss.ko",
    "drivers/i2c/busses/i2c-imx-lpi2c.ko",
    "drivers/net/phy/realtek.ko",
    "lib/stmp_device.ko",
    "drivers/media/platform/mxc/capture/mx6s_capture.ko",
    "drivers/dma-buf/dma-buf-imx.ko",
    "drivers/iio/imu/rpmsg_iio_pedometer.ko",
    "drivers/pwm/pwm-imx27.ko",
    "sound/soc/fsl/snd-soc-imx-card.ko",
    "drivers/hwmon/hwmon.ko",
    "drivers/staging/media/imx/imx8-mipi-csi2-sam.ko",
    "drivers/clocksource/timer-imx-sysctr.ko",
    "drivers/dma/fsl-edma-v3.ko",
    "drivers/gpu/drm/imx/dcnano/imx-dcnano-drm.ko",
    "drivers/cpufreq/imx-cpufreq-dt.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8mn.ko",
    "drivers/iio/buffer/industrialio-triggered-buffer.ko",
    "drivers/media/v4l2-core/v4l2-async.ko",
    "drivers/trusty/trusty-core.ko",
    "drivers/media/platform/mxc/capture/ov5640_camera_mipi_v2.ko",
    "drivers/gpu/drm/bridge/synopsys/dw-hdmi-cec.ko",
    "drivers/cpufreq/cpufreq-dt.ko",
    "sound/soc/sof/snd-sof.ko",
    "drivers/spi/spi-bitbang.ko",
    "sound/soc/generic/snd-soc-simple-card-utils.ko",
    "drivers/watchdog/imx7ulp_wdt.ko",
    "drivers/iio/imu/st_lsm6dsx/st_lsm6dsx.ko",
    "sound/soc/fsl/snd-soc-fsl-asoc-card.ko",
    "sound/soc/fsl/imx-pcm-rpmsg.ko",
    "sound/soc/sof/snd-sof-of.ko",
    "sound/soc/codecs/snd-soc-rpmsg-wm8960-i2c.ko",
    "drivers/gpio/gpio-pca953x.ko",
    "drivers/gpio/gpio-vf610.ko",
    "drivers/gpu/imx/lcdif/imx8mm-lcdif-core.ko",
    "sound/soc/codecs/snd-soc-ak4458.ko",
    "drivers/video/fbdev/mxc/mxc_edid.ko",
    "drivers/gpu/imx/lcdifv3/imx-lcdifv3-core.ko",
    "drivers/reset/reset-imx8ulp-sim.ko",
    "sound/soc/fsl/snd-soc-fsl-asrc.ko",
    "drivers/regulator/fp9931-regulator.ko",
    "drivers/spi/spi-imx.ko",
    "drivers/tty/serial/imx.ko",
    "drivers/mtd/mtd.ko",
    "sound/soc/fsl/snd-soc-imx-spdif.ko",
    "drivers/irqchip/irq-imx-irqsteer.ko",
    "drivers/mfd/fp9931-core.ko",
    "drivers/gpu/drm/imx/imx8mp-hdmi-pavi.ko",
    "drivers/perf/fsl_imx8_ddr_perf.ko",
    "drivers/spi/spi-fsl-qspi.ko",
    "sound/soc/codecs/snd-soc-rpmsg-ak4497.ko",
    "drivers/power/supply/dummy_battery.ko",
    "drivers/gpu/drm/mxsfb/imx-lcdif.ko",
    "sound/soc/fsl/snd-soc-fsl-esai.ko",
    "drivers/gpu/drm/bridge/it6161.ko",
    "drivers/phy/freescale/phy-fsl-imx8m-pcie.ko",
    "drivers/media/i2c/ov5640.ko",
    "sound/soc/fsl/snd-soc-fsl-sai.ko",
    "drivers/staging/media/imx/imx8-isi-capture.ko",
    "sound/soc/fsl/snd-soc-imx-hdmi.ko",
    "drivers/hwmon/scmi-hwmon.ko",
    "drivers/regulator/gpio-regulator.ko",
    "drivers/trusty/trusty-log.ko",
    "drivers/phy/freescale/phy-fsl-imx8-mipi-dphy.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8ulp.ko",
    "sound/soc/generic/snd-soc-simple-card.ko",
    "drivers/gpu/drm/panel/panel-rocktech-hx8394f.ko",
    "drivers/mxc/gpu-viv/galcore.ko",
    "drivers/media/platform/mxc/capture/mxc_mipi_csi.ko",
    "drivers/mux/mux-core.ko",
    "drivers/gpu/drm/imx/lcdifv3/imx-lcdifv3-crtc.ko",
    "drivers/media/platform/imx8/mxc-mipi-csi2_yav.ko",
    "drivers/clk/imx/clk-imx8mm.ko",
    "sound/soc/fsl/snd-soc-fsl-aud2htx.ko",
    "drivers/gpu/drm/imx/sec_mipi_dsim-imx.ko",
    "drivers/input/touchscreen/elants_i2c.ko",
    "drivers/iio/buffer/kfifo_buf.ko",
    "drivers/dma-buf/heaps/dsp_heap.ko",
    "drivers/gpio/gpio-imx-rpmsg.ko",
    "drivers/input/keyboard/rpmsg-keys.ko",
    "drivers/firmware/arm_scmi/scmi_pm_domain.ko",
    "sound/soc/sof/imx/imx-common.ko",
    "drivers/dma-buf/heaps/cma_heap.ko",
    "drivers/video/backlight/pwm_bl.ko",
    "drivers/usb/chipidea/ci_hdrc_usb2.ko",
    "drivers/video/fbdev/core/fb_notify.ko",
    "drivers/spi/spi-fsl-lpspi.ko",
    "drivers/input/touchscreen/synaptics_dsx/synaptics_dsx_i2c.ko",
    "drivers/staging/media/imx/imx8-isi-hw.ko",
    "drivers/thermal/qoriq_thermal.ko",
    "drivers/watchdog/imx2_wdt.ko",
    "drivers/staging/media/imx/imx8-parallel-csi.ko",
    "drivers/video/fbdev/core/cfbfillrect.ko",
    "drivers/staging/media/imx/imx8-isi-mem2mem.ko",
    "drivers/dma-buf/heaps/system_heap.ko",
    "drivers/dma/pxp/pxp_dma_v3.ko",
    "drivers/phy/freescale/phy-fsl-imx8mp-lvds.ko",
    "drivers/trusty/trusty-ipc.ko",
    "sound/soc/sof/xtensa/snd-sof-xtensa-dsp.ko",
    "sound/soc/fsl/imx-pcm-dma.ko",
    "drivers/leds/leds-pwm.ko",
    "drivers/gpu/drm/bridge/it6263.ko",
    "drivers/clk/imx/mxc-clk.ko",
    "drivers/nvmem/nvmem-imx-ocotp.ko",
    "drivers/input/keyboard/snvs_pwrkey.ko",
    "drivers/staging/media/imx/imx8-mipi-csi2.ko",
    "drivers/clk/imx/clk-blk-ctrl.ko",
    "sound/soc/codecs/snd-soc-tlv320aic31xx.ko",
    "drivers/mxc/hantro_v4l2/vsiv4l2.ko",
    "drivers/mmc/core/pwrseq_simple.ko",
    "drivers/phy/freescale/phy-fsl-samsung-hdmi.ko",
    "drivers/gpu/drm/panel/panel-simple.ko",
    "drivers/usb/phy/phy-mxs-usb.ko",
    "drivers/gpio/gpio-mxc.ko",
    "drivers/dma/imx-sdma.ko",
    "drivers/mtd/chips/chipreg.ko",
    "sound/soc/codecs/snd-soc-wm8994.ko",
    "drivers/trusty/trusty-test.ko",
    "drivers/soc/imx/imx8m_pm_domains.ko",
    "drivers/reset/gpio-reset.ko",
    "drivers/gpu/drm/bridge/nwl-dsi.ko",
    "drivers/clk/imx/clk-imx8mq.ko",
    "drivers/media/rc/gpio-ir-recv.ko",
    "drivers/pci/controller/dwc/pci-imx6.ko",
    "drivers/soc/imx/imx8mp-blk-ctrl.ko",
    "drivers/thermal/device_cooling.ko",
    "drivers/firmware/imx/imx-dsp.ko",
    "drivers/mfd/wm8994.ko",
    "drivers/soc/imx/imx8ulp_lpm.ko",
    "drivers/reset/reset-imx7.ko",
    "drivers/iio/health/max30102.ko",
    "drivers/regulator/pfuze100-regulator.ko",
    "drivers/gpu/drm/mxsfb/mxsfb.ko",
    "drivers/soc/imx/imx8m-blk-ctrl.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8mm.ko",
    "drivers/soc/imx/gpcv2-imx.ko",
    "sound/soc/codecs/snd-soc-rpmsg-pcm512x-i2c.ko",
    "sound/soc/fsl/snd-soc-imx-pcm512x-rpmsg.ko",
    "drivers/soc/imx/lpa_ctrl.ko",
    "sound/soc/codecs/snd-soc-rpmsg-pcm512x.ko",
    "drivers/gpio/gpio-max732x.ko",
    "drivers/usb/cdns3/cdns3.ko",
    "drivers/usb/cdns3/cdns3-imx.ko",
    "drivers/iio/gyro/fxas21002c_spi.ko",
    "drivers/gpu/imx/dpu/imx-dpu-core.ko",
    "drivers/phy/phy-mixel-lvds.ko",
    "drivers/iio/imu/fxos8700_core.ko",
    "drivers/nvmem/nvmem-imx-ocotp-scu.ko",
    "drivers/clk/imx/clk-imx-scu.ko",
    "sound/soc/fsl/snd-soc-fsl-mqs.ko",
    "drivers/iio/imu/fxos8700_i2c.ko",
    "drivers/firmware/imx/imx-scu-firmware.ko",
    "drivers/gpu/drm/imx/imx8qxp-ldb.ko",
    "sound/soc/codecs/snd-soc-cs42xx8-i2c.ko",
    "drivers/iio/light/isl29018.ko",
    "drivers/iio/light/sip1221lr1s.ko",
    "drivers/gpu/imx/imx8_pc.ko",
    "drivers/clk/imx/clk-imx8qm-acm.ko",
    "drivers/gpu/drm/imx/dpu/imx-dpu-crtc.ko",
    "drivers/gpu/drm/imx/imx8qm-ldb.ko",
    "sound/soc/fsl/snd-soc-fsl-esai-client.ko",
    "drivers/iio/gyro/fxas21002c_core.ko",
    "sound/soc/fsl/snd-soc-fsl-audmix.ko",
    "drivers/thermal/imx_sc_thermal.ko",
    "drivers/firmware/imx/scu-pd.ko",
    "drivers/clk/imx/clk-imx-acm-utils.ko",
    "drivers/net/can/flexcan/flexcan.ko",
    "drivers/media/platform/amphion/amphion-vpu.ko",
    "drivers/firmware/imx/seco_mu.ko",
    "drivers/soc/imx/secvio/soc-imx-secvio-sc.ko",
    "drivers/rtc/rtc-imx-sc.ko",
    "drivers/iio/gyro/fxas21002c_i2c.ko",
    "drivers/gpu/imx/dpu-blit/imx-dpu-blit.ko",
    "drivers/media/platform/nxp/imx-jpeg/mxc-jpeg-encdec.ko",
    "drivers/clk/imx/clk-imx8dxl-acm.ko",
    "drivers/gpu/drm/imx/dpu/imx-dpu-render.ko",
    "drivers/iommu/arm/arm-smmu/arm_smmu.ko",
    "drivers/phy/cadence/phy-cadence-salvo.ko",
    "drivers/clk/imx/clk-imx-lpcg-scu.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8qm.ko",
    "drivers/pinctrl/freescale/pinctrl-scu.ko",
    "drivers/watchdog/imx_sc_wdt.ko",
    "drivers/input/keyboard/imx_sc_key.ko",
    "sound/soc/fsl/snd-soc-imx-audmix.ko",
    "drivers/gpu/imx/imx8_prg.ko",
    "drivers/pinctrl/freescale/pinctrl-imx8qxp.ko",
    "drivers/iio/adc/imx8qxp-adc.ko",
    "drivers/clk/imx/clk-imx8qxp-acm.ko",
    "drivers/phy/phy-mixel-lvds-combo.ko",
    "drivers/usb/cdns3/cdns-usb-common.ko",
    "drivers/gpu/imx/imx8_dprc.ko",
    "sound/soc/sof/imx/snd-sof-imx8.ko",
    "drivers/media/v4l2-core/v4l2-jpeg.ko",
    "drivers/mtd/nand/raw/gpmi-nand/gpmi-nand.ko",
    "drivers/mtd/nand/raw/nand.ko",
    "sound/soc/codecs/snd-soc-cs42xx8.ko",
    "drivers/mtd/nand/nandcore.ko",
    "drivers/i2c/busses/i2c-flexio.ko",
    "sound/soc/codecs/snd-soc-wm8962.ko",
    "drivers/mfd/imx-flexio.ko",
    "drivers/iio/light/tsl2540.ko",
    "drivers/gpu/drm/panel/panel-nxp-rm67162.ko",
    "drivers/phy/freescale/phy-fsl-imx8q-pcie.ko",
    "drivers/power/supply/mp2662_charger.ko",
    "drivers/iio/industrialio-configfs.ko",
    "drivers/iio/trigger/iio-trig-sysfs.ko",
    "drivers/power/supply/max17042_battery.ko",
    "drivers/iio/trigger/iio-trig-hrtimer.ko",
    "drivers/iio/industrialio-sw-trigger.ko",
    "net/wireless/cfg80211.ko",
    "net/mac80211/mac80211.ko",
    "drivers/gpu/drm/imx/display-imx-rpmsg.ko",
    "drivers/cpufreq/cpufreq-dt-platdev.ko",
    "drivers/input/touchscreen/hxchipset/himax_mmi.ko"
]

def define_imx():
    kernel_build(
        name = "imx",
        build_config = "build.config.imx",
        outs = ["vmlinux"],
        module_outs = _IMX_IN_TREE_MODULES,
        kbuild_symtypes="true",
        kmi_symbol_list = "//common:android/abi_gki_aarch64_imx",
        base_kernel = "//common:kernel_aarch64",
        make_goals = [
          "Image",
          "modules",
        ],
    )

    kernel_abi(
        name = "imx_abi",
        kernel_build = ":imx",
        kernel_modules = _IMX_EXT_MODULES,
        module_grouping = False,
    )
