/* SPDX-License-Identifier: MIT */
/*
 * Copyright (c) 2015 Google, Inc.
 *
 * Trusty also has a copy of this header.  Please keep the copies in sync.
 */
#ifndef _TRUSTY_LOG_H_
#define _TRUSTY_LOG_H_

/*
 * Ring buffer that supports one secure producer thread and one
 * linux side consumer thread.
 */
struct log_rb {
	volatile uint32_t alloc;
	volatile uint32_t put;
	uint32_t sz;
	volatile char data[];
} __packed;

#define SMC_SC_SHARED_LOG_VERSION	SMC_STDCALL_NR(SMC_ENTITY_LOGGING, 0)
#define SMC_SC_SHARED_LOG_ADD		SMC_STDCALL_NR(SMC_ENTITY_LOGGING, 1)
#define SMC_SC_SHARED_LOG_RM		SMC_STDCALL_NR(SMC_ENTITY_LOGGING, 2)

#define TRUSTY_LOG_API_VERSION	1

#define SMC_ENTITY_CONSOLE 52
#define SMC_SC_SHARED_CONSOLE_CTL SMC_STDCALL_NR(SMC_ENTITY_CONSOLE, 0)
#define TRUSTY_CONSOLE_DISABLE 0
#define TRUSTY_CONSOLE_ENABLE 1

#endif

