#include <linux/init.h>
#include <linux/module.h>
#include <linux/platform_device.h>
#include <linux/miscdevice.h>
#include <linux/fs.h>
#include <linux/timer.h>
#include <linux/delay.h>
#include <linux/input.h>
#include <linux/types.h>
#include <linux/pm.h>
#include <linux/gpio.h>
#include <linux/slab.h>
#include <linux/init.h>
#include <linux/platform_device.h>
#include <linux/fsl_devices.h>
#include <asm/setup.h>
#include <linux/of.h>
#include <linux/of_gpio.h>
#include <linux/stat.h>
#include <linux/module.h>
#include <linux/err.h>
#include <linux/spinlock.h>
#include <linux/err.h>
#include <linux/regulator/consumer.h>
#include "pir_s340r_s.h"

#define DRIVER_NAME_S "PIR_Sensor_s"
#define DEVICE_NAME_S "pir_s_misc"

#define PIR_S_MAGIC 'S'
#define PIR_S_OFF _IO (PIR_S_MAGIC, 0)
#define PIR_S_ON _IO (PIR_S_MAGIC, 1)

static int pir_s_serin_gpio_number;
static void pir_s_send_data(const int gpio_number, uint32_t data);
static void pir_s_serial_config(const int gpio_number, int enable);

static int pir_s_open(struct inode *inode, struct file *filp)
{
	printk("open pir");
	return 0;
}

static int pir_s_release(struct inode *inode, struct file *filp)
{
	printk("release pir");
	return 0;
}

static ssize_t pir_s_read(struct file *file, char __user *buff, size_t count, loff_t *offp)
{
	printk("pir_s_read pir");
	return 0;
}

static ssize_t pir_s_write(struct file *file, char __user *buff, size_t count, loff_t *offp)
{
	printk("pir_s_write pir");
	return 0;
}

static long pir_s_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	printk("pir_s_ioctl pir cmd:%d", cmd);
	switch (cmd) {
		case PIR_S_OFF: {
			pr_err("PIR_S_OFF");
			pir_s_serial_config(pir_s_serin_gpio_number, 0);
			break;
		}
		case PIR_S_ON: {
			pr_err("PIR_S_ON");
			pir_s_serial_config(pir_s_serin_gpio_number, 1);
			break;
		}
		default: {
			pr_err("pir s ioctl default %d", cmd);
			break;
		}
	}
	return 0;
}

static long pir_s_compat_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	printk("pir_s_compat_ioctl pir cmd:%d", cmd);
	switch (cmd) {
		case PIR_S_OFF: {
			pr_err("PIR_S_OFF!");
			pir_s_serial_config(pir_s_serin_gpio_number, 0);
			break;
		}
		case PIR_S_ON: {
			pr_err("PIR_S_ON!!");
			pir_s_serial_config(pir_s_serin_gpio_number, 1);
			break;
		}
		default: {
			pr_err("pir_s_compat_ioctl default %d", cmd);
			break;
		}
	}
	return 0;
}

static struct file_operations pir_s_ops = {
	.owner		= THIS_MODULE,
	.open		= pir_s_open,
	.release	= pir_s_release,
	.read		= pir_s_read,
	.write		= pir_s_write,
	.unlocked_ioctl	= pir_s_ioctl,
	.compat_ioctl	= pir_s_compat_ioctl,
};

static struct miscdevice pir_s_misc = {
	.minor = MISC_DYNAMIC_MINOR,
	.name = DEVICE_NAME_S,
	.fops = &pir_s_ops,
};

static void pir_s_send_data(const int gpio_number, uint32_t data)
{
	unsigned long flags = 0;
	local_irq_save(flags);

	gpio_set_value(gpio_number, 0);
	udelay(1000);
	for (int i = 0; i < 25; i++) {
		gpio_set_value(gpio_number, 0);
		udelay(1);
		gpio_set_value(gpio_number, 1);
		udelay(1);
		gpio_set_value(gpio_number, (data & (1<<24)) ? 1:0);
		udelay(100);
		data <<= 1;
	}
	gpio_set_value(gpio_number, 0);

	local_irq_restore(flags);
}

static void pir_s_serial_config(const int gpio_number, int enable)
{
	static uint32_t pir_s_cfg;
	pir_s_cfg = 0;
	pir_s_cfg = SENS_C;    //灵敏度
	pir_s_cfg <<= 4;
	pir_s_cfg |= BLIND_C;  //屏蔽时间
	pir_s_cfg <<= 2;
	pir_s_cfg |= PULSE_C;  //脉冲计数
	pir_s_cfg <<= 2;
	pir_s_cfg |= WINDOW_C; //窗口时间
	pir_s_cfg <<= 1;
	pir_s_cfg |= (enable ? MOTION_C : 0); //运动模式
	pir_s_cfg <<= 1;
	pir_s_cfg |= INT_C;    //中断源
	pir_s_cfg <<= 2;
	pir_s_cfg |= VOLT_C;   //信号源
	pir_s_cfg <<= 1;
	pir_s_cfg |= SUPP_C;   //稳压器
	pir_s_cfg <<= 1;
	pir_s_cfg |= TEST_C;   //自检
	pir_s_cfg <<= 1;
	pir_s_cfg |= CTEST_C;  //自检电容
	pir_s_cfg <<= 1;
	pir_s_cfg |= LINK_C;   //短接
	pir_s_cfg <<= 1;
	pir_s_cfg |= CALC_C;   //计数模式
	// pr_err("pir_s_serial_config pir_s_serial_config!!!!!!");
	pir_s_send_data(gpio_number, pir_s_cfg);
}

static int pir_s_parse_dt(struct pir_s340r *pir_s340r_s)
{
	const struct device_node *np = pir_s340r_s->dev->of_node;

	pir_s340r_s->serin_gpio = of_get_named_gpio(np, "pir-s-serin", 0);
	if (pir_s340r_s->serin_gpio < 0) {
		printk(DRIVER_NAME_S "serin can not parse");
		return -EIO;
	}
	pir_s340r_s->doci_gpio = of_get_named_gpio(np, "pir-s-doci", 0);
	if (pir_s340r_s->doci_gpio < 0) {
		printk(DRIVER_NAME_S "doci can not parse");
		return -EIO;
	}
	return 0;
}

static int pir_s_request_gpio(struct pir_s340r *pir_s340r_s)
{
	int ret;

	ret = devm_gpio_request_one(pir_s340r_s->dev, pir_s340r_s->serin_gpio, GPIOF_OUT_INIT_LOW, "pir-s-serin");
	if (ret != 0) {
		printk(DRIVER_NAME_S "serin_gpio request failed");
		return ret;
	}

	ret = gpio_direction_output(pir_s340r_s->serin_gpio, 0);
	if (ret != 0) {
		printk(DRIVER_NAME_S "serin_gpio gpio_direction_output:%d", ret);
		return ret;
	}
	pir_s_serin_gpio_number = pir_s340r_s->serin_gpio;

	ret = devm_gpio_request_one(pir_s340r_s->dev, pir_s340r_s->doci_gpio, GPIOF_DIR_IN, "pir-s-doci");
	if (ret != 0) {
		printk(DRIVER_NAME_S "doci_gpio request failed");
		return ret;
	}
	ret = gpio_direction_input(pir_s340r_s->doci_gpio);
	if (ret != 0) {
		printk(DRIVER_NAME_S "doci_gpio gpio_direction_input:%d", ret);
		return ret;
	}

	return ret;
}

#if INT_C == 1
static uint32_t pir_s_read_data(const struct pir_s340r *pir_s340r_s)
{
	uint32_t configure_data = 0;
	uint32_t pir_data = 0;
	int doci = -1;
	int ret = -1;

	doci = gpio_get_value(pir_s340r_s->doci_gpio);
	if (doci > 0) {
		gpio_direction_output(pir_s340r_s->doci_gpio, 1);    //Switch output mode PIR pin outputs high level
		udelay(120);			//Force the pull-up to at least 62.5us
		pir_data = 0;
		configure_data = 0;

		for (int i = 0; i < 40; i++) {
			gpio_direction_output(pir_s340r_s->doci_gpio, 0);
			udelay(1);
			gpio_set_value(pir_s340r_s->doci_gpio, 1);
			udelay(1);

			gpio_direction_input(pir_s340r_s->doci_gpio);
			udelay(4);
			if (i < 15) {
				pir_data <<= 1;
				pir_data |= gpio_get_value(pir_s340r_s->doci_gpio) ? 1 : 0;
			} else {
				configure_data <<= 1;
				configure_data |= gpio_get_value(pir_s340r_s->doci_gpio) ? 1 : 0;
			}
		}
		gpio_direction_output(pir_s340r_s->doci_gpio, 0);
		udelay(4);
		gpio_direction_input(pir_s340r_s->doci_gpio);

		if ((pir_data & (uint16_t)0x4000) != 0) {	//No overflow
			pir_data &= 0x3FFF;						//Get 14-bit data from PIR
			if (pir_data & 0x2000) {
				pir_data |= 0xC000;
				pir_data = ((~pir_data) + 1) & 0x7FFF;
			}
			if (pir_data > 90) {
				ret = pir_data;
			} else {
				ret = 0;
			}
		} else {
			ret = -1;
		}
	}

	return ret;
}
#elif INT_C == 0
static void pir_s_clear_irq(const struct pir_s340r *pir_s340r_s){
	int doci = -1;
	doci = gpio_get_value(pir_s340r_s->doci_gpio);
	if (doci > 0) {
		mdelay(100);
		//udelay(1);
		gpio_direction_output(pir_s340r_s->doci_gpio, 0);    //Switch output mode PIR pin outputs low level
		gpio_set_value(pir_s340r_s->doci_gpio, 0);
		mdelay(10);
		//udelay(100);
		gpio_direction_input(pir_s340r_s->doci_gpio);
	}
}
#endif

static irqreturn_t pir_s_irq_handle(int irq, void *private)
{
	struct pir_s340r *pir_s340r_s = private;
#if INT_C ==1
	int ret = 0;
	static int log_cnt;
#endif
	if (irq != gpio_to_irq(pir_s340r_s->doci_gpio)) {
		printk(DRIVER_NAME_S "pir_s340r_s irq error! irq:%d", irq);
		return IRQ_HANDLED;
	}

#if INT_C == 1
	log_cnt++;
	ret = pir_s_read_data(pir_s340r_s);
	if ((ret > 0) && (log_cnt > 50)) {
		input_report_key(pir_s340r_s->pir_input_dev, KEY_F21, 1);
		input_report_key(pir_s340r_s->pir_input_dev, KEY_F21, 0);
		input_sync(pir_s340r_s->pir_input_dev);
		log_cnt = 0;
	} else {
		return IRQ_HANDLED;    // off status, do nothing
	}
#elif INT_C == 0
	pir_s_clear_irq(pir_s340r_s);
	input_report_key(pir_s340r_s->pir_input_dev, KEY_F21, 1);
	input_report_key(pir_s340r_s->pir_input_dev, KEY_F21, 0);
	input_sync(pir_s340r_s->pir_input_dev);
#endif
	return IRQ_HANDLED;
}

static int pir_s_doci_init(struct pir_s340r *pir_s340r_s)
{
	int irq_flags = 0;
	int ret = -1;

	if (gpio_is_valid(pir_s340r_s->doci_gpio)) {
		irq_flags = IRQF_TRIGGER_HIGH | IRQF_ONESHOT;
		ret = devm_request_threaded_irq(pir_s340r_s->dev,
					gpio_to_irq(pir_s340r_s->doci_gpio),
					NULL, pir_s_irq_handle, irq_flags,
					dev_name(pir_s340r_s->dev), pir_s340r_s);
		if (ret) {
			printk(DRIVER_NAME_S "pir_s_doci_init failed:%d", ret);
			return ret;
		}
	} else {
		printk(DRIVER_NAME_S "gpio:%d is invalid", pir_s340r_s->doci_gpio);
	}
	return ret;
}

static int pir_s_probe(struct platform_device *pdev)
{
	struct pir_s340r *pir_s340r_s;
	int ret;

	pr_err("pir_s_s340r probe");

	pir_s340r_s = devm_kzalloc(&pdev->dev, sizeof(*pir_s340r_s), GFP_KERNEL);
	if (!pir_s340r_s) {
		printk(DRIVER_NAME_S "malloc pir_s340r_s failed");
		return -ENOMEM;
	}
	pir_s340r_s->pdev = pdev;
	pir_s340r_s->dev = &pdev->dev;

	ret = misc_register(&pir_s_misc);
	if (ret != 0) {
		printk(DRIVER_NAME_S "pir_s misc_register failed");
		return ret;
	}
	//parse dtsi to get gpio number
	ret = pir_s_parse_dt(pir_s340r_s);
	if (ret != 0) {
		printk(DRIVER_NAME_S "pir_s_parse_dt failed");
		return ret;
	}

	// request gpio
	ret = pir_s_request_gpio(pir_s340r_s);
	if (ret != 0) {
		printk(DRIVER_NAME_S "pir_s_request_gpio request failed");
		return ret;
	}

	// pir config init
	pir_s_serial_config(pir_s340r_s->serin_gpio, 1);

	// irq init
	ret = pir_s_doci_init(pir_s340r_s);
	if (ret != 0) {
		printk(DRIVER_NAME_S "pir_s_doci_init failed");
		return ret;
	}

	// register input
	pir_s340r_s->pir_input_dev = devm_input_allocate_device(pir_s340r_s->dev);
	if (!pir_s340r_s->pir_input_dev) {
		return -ENOMEM;
	}
	pir_s340r_s->pir_input_dev->name = "pir_s";
	pir_s340r_s->pir_input_dev->phys = "pir_s";
	pir_s340r_s->pir_input_dev->dev.parent = pir_s340r_s->dev;
	pir_s340r_s->pir_input_dev->id.bustype = BUS_HOST;
	pir_s340r_s->pir_input_dev->evbit[0] = BIT_MASK(EV_KEY);
	pir_s340r_s->pir_input_dev->keybit[BIT_WORD(KEY_F21)] = BIT_MASK(KEY_F21);
	ret = input_register_device(pir_s340r_s->pir_input_dev);
	if (ret != 0) {
		printk(DRIVER_NAME_S "input_register_device failed: %d", ret);
		return ret;
	}

	printk(DRIVER_NAME_S "pir_s probe success");
	return 0;
}

static int pir_s_remove(const struct platform_device *pdev)
{
	pr_err("pir remove");
	misc_deregister(&pir_s_misc);
	return 0;
}

static struct of_device_id pir_s_dt_match[] = {
	{ .compatible = "senba,pir_s"},
	{ },
};

MODULE_DEVICE_TABLE(of, pir_s_dt_match);

static struct platform_driver pir_s_driver = {
	.driver = {
		.name = DRIVER_NAME_S,
		.owner = THIS_MODULE,
		.of_match_table = of_match_ptr(pir_s_dt_match),
	},
	.probe = pir_s_probe,
	.remove = pir_s_remove,
};

static int pir_s_init(void)
{
	int ret;

	printk(DRIVER_NAME_S "pir_s init!!!!!!!!!!!");
	ret = platform_driver_register(&pir_s_driver);
	if (ret) {
		printk(DRIVER_NAME_S "init fail %d", ret);
	} else {
		printk(DRIVER_NAME_S "init success %d", ret);
	}
	return 0;
}

static void pir_s_exit(void)
{
	printk(DRIVER_NAME_S "pir exit");
	platform_driver_unregister(&pir_s_driver);
}

module_init(pir_s_init);
module_exit(pir_s_exit);

MODULE_DESCRIPTION("PIR_s Sensor driver");
MODULE_LICENSE("GPL");
