#include <linux/delay.h>
#include <linux/export.h>
#include <linux/gpio.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/phy.h>
#include <linux/etherdevice.h>
#include <linux/if_bridge.h>
#include <net/dsa.h>
#include <net/switchdev.h>
#include <linux/brcmphy.h>
#include <linux/rtnetlink.h>
#include <port.h>
#include <rtk_switch.h>
#include <rtk_error.h>
#include <rtl8367c_asicdrv_port.h>
#include <acl.h>
#include <smi.h>
#include <eee.h>
#include <vlan.h>
#include <trap.h>
#include <l2.h>
#include <linux/proc_fs.h>
#include <linux/gn_low_level_api.h>
#include <linux/of_gpio.h>
#include <linux/gn.h>
#include "rtl83_priv.h"

typedef enum {
    PORT_SPEED_SET = 1,
    PORT_LINK_STATUS,
    PHY_TEST_MODE,
    GREEN_ETH_SET,
    EEE_PORT_ENABLE,
    PHY_MDX_TEST,
    RGMII_DELAY,
    RGMII_SSC_SET,
    RGMII_DISABLE,
    RTL_PORT_ENABLE, //10
    TEXT_CMD_MAX
} test_cmd;

unsigned char rtl83_host_mac[6];
static unsigned char init_flag = 0;
static int g_eth_rst;

static int rtl83_phy_read16(struct dsa_switch *ds, int addr, int reg)
{
	u32 value = 0;
	int ret;

	ret = rtk_port_phyReg_get(addr, reg, &value);

	return ret ? ret : value;
}

static int rtl83_phy_write16(struct dsa_switch *ds, int addr, int reg, u16 val)
{
	return rtk_port_phyReg_set(addr, reg, val);
}

static void rtl83_adjust_link(struct dsa_switch *ds, int port, struct phy_device *phydev)
{
	rtk_port_linkStatus_t link;
	unsigned int speed, duplex;

	if ((port != 1) && (port != 3)) return;

	if(rtk_port_phyStatus_get(port, &link, &speed, &duplex) != 0){
		ERMSG("!!!!!! rtk_port_phyStatus_get fail");
		return;
	}
	phydev->link = link;
	switch(speed)
	{
		case PORT_SPEED_10M:
			phydev->speed = SPEED_10;
		       break;
		case PORT_SPEED_100M:
		        phydev->speed = SPEED_100;
		        break;
		case PORT_SPEED_1000M:
		        phydev->speed = SPEED_1000;
		        break;
		default:
		        break;
	}
	if(duplex == PORT_FULL_DUPLEX)
		phydev->duplex = DUPLEX_FULL;
	else
		phydev->duplex = DUPLEX_HALF;

	phydev->pause = 0;
	phydev->asym_pause = 0;

}

static enum dsa_tag_protocol rtl83_get_tag_protocol(struct dsa_switch *ds, int port, enum dsa_tag_protocol mp)
{
	return DSA_TAG_PROTO_NONE;
}

static int mdio_testing(const char *val, const struct kernel_param *kp)
{
	int _val = simple_strtol(val,NULL,0);
	unsigned int da, i, e=0;
	if (_val == 1) {
		smi_read(0x1202, &da);
		GNMSG("Read register address [0x1202] value: [0x%x]", da);
		for (i = 1 ; i < 10001 ; i++){
			smi_write(0x1202, i);
			smi_read(0x1202, &da);
			if (da == i) {
				if ((da % 1000 == 0) && (i % 1000 == 0))
					GNMSG("Write [0x1202] PASS i:[%d] da:[%d]", i, da);
			} else {
				e++;
				ERMSG("Write [0x1202] FAIL i:[%d] da:[%d] e:[%d]", i, da, e);
			}
			smi_write(0x1202, 0x88a8);
		}
	}
	return 0;
}
module_param_call(mdio_test, mdio_testing, NULL, NULL, 0644);

rtk_api_ret_t rtk_port_phyMdx_set(rtk_port_t port, rtk_port_phy_mdix_mode_t mode)
{
    rtk_uint32 regData;
    rtk_api_ret_t retVal;

    /* Check initialization state */
    RTK_CHK_INIT_STATE();

    /* Check Port Valid */
    RTK_CHK_PORT_IS_UTP(port);

    switch (mode)
    {
        case PHY_AUTO_CROSSOVER_MODE:
            if ((retVal = rtl8367c_getAsicPHYReg(rtk_switch_port_L2P_get(port), 24, &regData))!=RT_ERR_OK)
                return retVal;

            regData &= ~(0x0001 << 9);

            if ((retVal = rtl8367c_setAsicPHYReg(rtk_switch_port_L2P_get(port), 24, regData))!=RT_ERR_OK)
                return retVal;
            break;
        case PHY_FORCE_MDI_MODE:
            if ((retVal = rtl8367c_getAsicPHYReg(rtk_switch_port_L2P_get(port), 24, &regData))!=RT_ERR_OK)
                return retVal;

            regData |= (0x0001 << 9);
            regData |= (0x0001 << 8);

            if ((retVal = rtl8367c_setAsicPHYReg(rtk_switch_port_L2P_get(port), 24, regData))!=RT_ERR_OK)
                return retVal;
            break;
        case PHY_FORCE_MDIX_MODE:
            if ((retVal = rtl8367c_getAsicPHYReg(rtk_switch_port_L2P_get(port), 24, &regData))!=RT_ERR_OK)
                return retVal;

            regData |= (0x0001 << 9);
            regData &= ~(0x0001 << 8);

            if ((retVal = rtl8367c_setAsicPHYReg(rtk_switch_port_L2P_get(port), 24, regData))!=RT_ERR_OK)
                return retVal;
            break;
        default:
            return RT_ERR_INPUT;
            break;
    }

    /* Restart N-way */
    if ((retVal = rtl8367c_getAsicPHYReg(rtk_switch_port_L2P_get(port), 0, &regData))!=RT_ERR_OK)
        return retVal;

    regData |= (0x0001 << 9);

    if ((retVal = rtl8367c_setAsicPHYReg(rtk_switch_port_L2P_get(port), 0, regData))!=RT_ERR_OK)
        return retVal;

    return 0;
}

static ssize_t hw_test_mode(struct file *file, const char* buffer, size_t count, loff_t *offp)
{
	int len = count;
       char status[33];
	int charCnt, strNum, charPos, rel;
       char str1[4][8];
	unsigned int phy_port, cmd, txd, rxd;
	rtk_port_phy_test_mode_t mode;
	rtk_port_phy_ability_t ability;
	rtk_port_linkStatus_t link;
	rtk_data_t speed;
	gn_link_speed_t sp;
	rtk_data_t duplex;
	gn_port_mode_t speed_mode;
	rtk_port_mac_ability_t      mac_cfg;

	if (!rtkbus) {
		ERMSG("!!! rtkbus is error !!!");
                       return -1;
	}

        if(copy_from_user(status, buffer, len))
        {
                return -EFAULT;
        }
        status[len-1] = '\0';

        strNum = 0;
        charPos = 0;
        for(charCnt = 0; charCnt < 33; charCnt++)
        {
		if(status[charCnt] == '\0')
              {
		str1[strNum][charPos] = '\0';
                     break;
               }
               else if(status[charCnt] == ' ')
               {
		str1[strNum][charPos] = '\0';
                     strNum++;
                     charPos= 0;
                     continue;
                }
                else
                {
                     str1[strNum][charPos] = status[charCnt];
                     charPos++;
                }
           }

	    if(strcmp("w", &str1[0][0]) == 0) {
		   cmd = phy_port = mode = 0;
		   cmd = simple_strtol(&str1[1][0],NULL,10);
		   phy_port = simple_strtol(&str1[2][0],NULL,10);
		   mode = simple_strtol(&str1[3][0],NULL,10);

		   //if (((phy_port != 1) && (phy_port != 3)) || (cmd == 0)) goto example;
		   switch(cmd) {
			case PORT_SPEED_SET:
			     if (((phy_port != 1) && (phy_port != 3)) || (mode == 0)) goto example;
				 speed_mode = (gn_port_mode_t)mode;
		              /* Ability */
		              memset(&ability, 0x00, sizeof(rtk_port_phy_ability_t));

		              ability.FC = 1;
		              ability.AsyFC = 1;

		              switch(speed_mode)
		              {
		                  case PORT_MODE_AUTO:
		                      ability.Full_10     = 1;
		                      ability.Half_10     = 1;
		                      ability.Full_100    = 1;
		                      ability.Half_100    = 1;
		                      ability.Full_1000   = 1;
		                      ability.AutoNegotiation = 1;
		                      break;
		                  case PORT_MODE_10_HALF:
		                      ability.Half_10     = 1;
		                      break;
		                  case PORT_MODE_10_FULL:
		                      ability.Full_10     = 1;
		                      break;
		                  case PORT_MODE_100_HALF:
		                      ability.Half_100    = 1;
		                      break;
		                  case PORT_MODE_100_FULL:
		                      ability.Full_100    = 1;
		                      break;
		                  case PORT_MODE_1000_FULL:
		                      ability.Full_1000   = 1;
		                      ability.AutoNegotiation = 1;
		                      break;
		                  default:
				        ERMSG("!!!!!! mode error:[%d]", mode);
					 return -1;
		                      break;
		              }
		              if(ability.AutoNegotiation) {
					if(!rtk_port_phyAutoNegoAbility_set(phy_port, &ability)) {
						GNMSG("rtk_port_phyAutoNegoAbility_set() successful");
					}
		              }
		              else
		              {
		                  if(!rtk_port_phyForceModeAbility_set(phy_port, &ability)) {
						GNMSG("rtk_port_phyForceModeAbility_set() successful");
				    }
		              }
				break;
			case PORT_LINK_STATUS:
				link = speed = duplex = sp = 0;
				if ((phy_port != 1) && (phy_port != 3)) goto example;
				if(rtk_port_phyStatus_get(phy_port, &link, &speed, &duplex) != 0) {
					ERMSG("!!!!!! rtk_port_phyStatus_get fail");
					return -1;
				}
				switch(speed)
				{
				case PORT_SPEED_10M:
						sp = LINK_10M;
						break;
				case PORT_SPEED_100M:
						sp = LINK_100M;
						break;
				case PORT_SPEED_1000M:
						sp = LINK_1000M;
						break;
				default:
						return -1;
						break;
				   }
				   GNMSG("port:[%d]  link:[%d]  speed:[%d]  duplex:[%d]", phy_port, link, sp, duplex);
				break;
			case PHY_TEST_MODE:
				if ((rel = rtk_port_phyTestMode_set(phy_port, mode))) {
					ERMSG("!!! rtk_port_phyTestMode_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_port_phyTestMode_set() successful, port:[%d] mode:[%d]", phy_port, mode);
				}
				break;
			case GREEN_ETH_SET:
				if ((mode != 0) && (mode != 1)) goto example;
				if ((rel = rtk_switch_greenEthernet_set((rtk_enable_t) mode))) {
					ERMSG("!!! rtk_switch_greenEthernet_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_switch_greenEthernet_set() successful, enable:[%d]", mode);
				}
				break;
			case EEE_PORT_ENABLE:
				if ((mode != 0) && (mode != 1)) goto example;
				if ((rel = rtk_eee_portEnable_set(phy_port, (rtk_enable_t) mode))) {
					ERMSG("!!! rtk_eee_portEnable_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_eee_portEnable_set() successful, port:[%d] enable:[%d]", phy_port, mode);
				}
				break;
			case PHY_MDX_TEST:
				if ((rel = rtk_port_phyMdx_set(phy_port, (rtk_port_phy_mdix_mode_t) mode))) {
					ERMSG("!!! rtk_port_phyMdx_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_port_phyMdx_set() successful, port:[%d] mode:[%d]", phy_port, mode);
				}
				break;
			case RGMII_DELAY:
				txd = phy_port;
				rxd = mode;
				if ((rel = rtk_port_rgmiiDelayExt_set(EXT_PORT0, txd, rxd))) {
					ERMSG("!!! rtk_port_rgmiiDelayExt_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_port_rgmiiDelayExt_set() successful, txd:[%d] rxd:[%d]", txd, rxd);
				}
				break;
			case RGMII_SSC_SET:
				if ((mode != 0) && (mode != 1)) goto example;
				if ((rel = rtk_port_macForceLinkExtSSC_set(EXT_PORT0, (rtk_enable_t) mode))) {
					ERMSG("!!! rtk_port_macForceLinkExtSSC_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_port_macForceLinkExtSSC_set() successful, enable:[%d]", mode);
				}
				break;
			case RGMII_DISABLE:
				if ((mode != 0) && (mode != 1)) goto example;
				if (mode == 1) {
				       mac_cfg.forcemode = MAC_FORCE;
				       mac_cfg.speed     = SPD_1000M;
				       mac_cfg.duplex    = FULL_DUPLEX;
				       mac_cfg.link      = 1;
				       mac_cfg.nway      = 0;
				       mac_cfg.rxpause   = 0;
				       mac_cfg.txpause   = 0;
					if ((rel = rtk_port_macForceLinkExt_set(EXT_PORT0, MODE_EXT_RGMII, &mac_cfg))) {
						ERMSG("!!! rtk_port_macForceLinkExtSSC_set() fail:[%d]", rel);
						return -1;
					} else {
						GNMSG("rtk_port_macForceLinkExt_set() successful, enable:[%d]", mode);
					}
				} else {
					memset(&mac_cfg, 0x00, sizeof(rtk_port_mac_ability_t));
					if ((rel = rtk_port_macForceLinkExt_set(EXT_PORT0, MODE_EXT_DISABLE, &mac_cfg))) {
						ERMSG("!!! rtk_port_macForceLinkExt_set() fail:[%d]", rel);
						return -1;
					} else {
						GNMSG("rtk_port_macForceLinkExt_set() successful, enable:[%d]", mode);
					}
				}
				break;
			case RTL_PORT_ENABLE:
				if ((mode != 0) && (mode != 1)) goto example;
				if ((rel = rtk_port_adminEnable_set(phy_port, (rtk_enable_t) mode))) {
					ERMSG("!!! rtk_port_adminEnable_set() fail:[%d]", rel);
					return -1;
				} else {
					GNMSG("rtk_port_adminEnable_set() successful, port:[%d] enable:[%d]", phy_port, mode);
				}
				break;
			default:
				ERMSG("!!! cmd error:[%d]", cmd);
				return -1;
				break;
		   }

            }
            else
            {
example:
	              GNMSG("echo w [ cmd ] [ port(1/3) ] [ parameter ] > /proc/rtk_switch/hw_test");
			GNMSG("cmd:");
			GNMSG("		portSpeedSet		= 1");
			GNMSG("		portLinkStatus		= 2");
			GNMSG("		phyTestMode		= 3");
			GNMSG("		greenEthSet		= 4");
			GNMSG("		eeePortEnable		= 5");
			GNMSG("		phyMdxTest		= 6");
			GNMSG("		rgmiiTimeDelay	= 7");
			GNMSG("=================================================");
			GNMSG("portSpeedSet:");
			GNMSG("echo w 1 [ port(1/3) ] [ mode ] > /proc/rtk_switch/hw_test");
			GNMSG("mode:");
			GNMSG("		AUTO		= 1");
			GNMSG("		10_HALF		= 2");
			GNMSG("		10_FULL		= 3");
			GNMSG("		100_HALF	= 4");
			GNMSG("		100_FULL		= 5");
			GNMSG("		1000_FUL		= 6");
			GNMSG("exe: echo w 1 1 5 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("portLinkStatus:")
			GNMSG("echo w 2 [ port(1/3) ] 0 > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 2 1 0 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("phyTestMode:");
			GNMSG("echo w 3 [ port(1/3) ] [ mode(0, 1, 4) ] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 3 1 4 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("greenEthSet:");
			GNMSG("echo w 4 1 [ enable(0/1)] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 4 1 1 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("eeePortEnable:");
			GNMSG("echo w 5 [ port(1/3) ] [ enable(0/1) ] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 5 1 1 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("phyMdxTest:");
			GNMSG("echo w 6 [ port(1/3) ] [ mode(0 ~ 2) ] > /proc/rtk_switch/hw_test");
			GNMSG("mode:");
			GNMSG("	   PHY_AUTO_CROSSOVER_MODE	  = 0");
			GNMSG("    PHY_FORCE_MDI_MODE	         = 1");
			GNMSG("    PHY_FORCE_MDIX_MODE	         = 2");
			GNMSG("exe: echo w 6 1 1 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("rgmiiDelayExtSet:");
			GNMSG("echo w 7 [ txDelay(0 ~ 1) ] [ rxDelay(0 ~ 7) ] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 7 1 0 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("macForceLinkExtSSC_set:");
			GNMSG("echo w 8 1 [ enable(0/1)] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 8 1 1 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("macForceLinkExt_set:");
			GNMSG("echo w 9 1 [ enable(0/1)] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 9 1 0 > /proc/rtk_switch/hw_test");
			GNMSG("---------------------------------------------------------------");
			GNMSG("port_adminEnable_set:");
			GNMSG("echo w 10 [ port(1/3) ] [ enable(0/1) ] > /proc/rtk_switch/hw_test");
			GNMSG("exe: echo w 10 1 0 > /proc/rtk_switch/hw_test");
             }

        return len;

}
static const struct file_operations hw_test_fops = {
        .owner = THIS_MODULE,
        .write = hw_test_mode,
};

static ssize_t rtk_reg_read_write(struct file *file, const char* buffer, size_t count, loff_t *offp)
{
	int len = count;
       char status[33];
	unsigned int reg_value;
	int charCnt, strNum, charPos;
       char str1[4][8];
	unsigned int rmii_val;
       int ret_val;

	if (!rtkbus) {
		ERMSG("!!! rtkbus is error !!!");
                       return -1;
	}

	if(copy_from_user(status, buffer, len))
	{
	        return -EFAULT;
	}
	status[len-1] = '\0';

	strNum = 0;
	charPos = 0;
	for(charCnt = 0; charCnt < 33; charCnt++)
	{
	        if(status[charCnt] == '\0')
	        {
		        str1[strNum][charPos] = '\0';
	               break;
	        }
	        else if(status[charCnt] == ' ')
	        {
	                str1[strNum][charPos] = '\0';
	                strNum++;
	                charPos= 0;
	                continue;
	        }
	        else
	        {
	                str1[strNum][charPos] = status[charCnt];
	                charPos++;
	        }
	   }

	   if(strcmp("r", &str1[0][0]) == 0)
	   {
		rmii_val = 0;
		rmii_val = simple_strtol(&str1[1][0],NULL,16);

		memset(&reg_value, 0, sizeof(reg_value));
		if ((ret_val = rtl8367c_getAsicReg(rmii_val, &reg_value)) != RT_ERR_OK)
			ERMSG("rtl8367c_getAsicReg() fail(%x)!", ret_val);

	              GNMSG("Read register[0x%04x] value [0x%04x]...", rmii_val, reg_value);
	    } else if(strcmp("w", &str1[0][0]) == 0) {
			rmii_val = reg_value = 0;
			rmii_val = simple_strtol(&str1[1][0],NULL,16);
			reg_value = simple_strtol(&str1[2][0],NULL,16);

			if ((ret_val = rtl8367c_setAsicReg(rmii_val, reg_value)) != RT_ERR_OK)
				ERMSG("rtl8367c_setAsicReg() fail(%x)!", ret_val);

			GNMSG("Write register[0x%04x] value[0x%04x]...", rmii_val, reg_value);
	    }
	    else
	    {
		        GNMSG("Example: echo r 0x1304 > /proc/rtk_switch/rtk_reg_value");
		        GNMSG("Example: echo w 0x1304 0x6677 > /proc/rtk_switch/rtk_reg_value");
	     }

           return len;
}
static const struct file_operations rtk_reg_fops = {
        .owner = THIS_MODULE,
        .write = rtk_reg_read_write,
};

static ssize_t phy_read_write(struct file *file, const char* buffer, size_t count, loff_t *offp)
{
	int len = count;
       char status[33];
	int charCnt, strNum, charPos;
       char str1[4][8];
	unsigned int addr, reg, data;
       int ret_val;

	if (!rtkbus) {
		ERMSG("!!! rtkbus is error !!!");
                       return -1;
	}

	        if(copy_from_user(status, buffer, len))
	        {
	                return -EFAULT;
	        }
	        status[len-1] = '\0';

	        strNum = 0;
	        charPos = 0;
	        for(charCnt = 0; charCnt < 33; charCnt++)
	        {
	                if(status[charCnt] == '\0')
	                {
	                        str1[strNum][charPos] = '\0';
	                        break;
	                }
	                else if(status[charCnt] == ' ')
	                {
	                        str1[strNum][charPos] = '\0';
	                        strNum++;
	                        charPos= 0;
	                        continue;
	                }
	                else
	                {
	                        str1[strNum][charPos] = status[charCnt];
	                        charPos++;
	                }
	        }

	        if(strcmp("r", &str1[0][0]) == 0)
	        {
	              addr = 0;
			addr = simple_strtol(&str1[1][0],NULL,16);
			reg = simple_strtol(&str1[2][0],NULL,16);

			memset(&data, 0, sizeof(data));
			if ((ret_val = rtk_port_phyReg_get(addr, reg, &data)) != RT_ERR_OK)
				ERMSG("rtk_port_phyReg_get() fail(%x)!", ret_val);

	                GNMSG("Read PHY[%d] register[%d] data[0x%x]...", addr, reg, data);
	        } else if(strcmp("w", &str1[0][0]) == 0) {
			addr = reg = data = 0;
			addr = simple_strtol(&str1[1][0],NULL,16);
			reg = simple_strtol(&str1[2][0],NULL,16);
			data = simple_strtol(&str1[3][0],NULL,16);

			if ((ret_val = rtk_port_phyReg_set(addr, reg, data)) != RT_ERR_OK)
				ERMSG("rtk_port_phyReg_set() fail(%x)!", ret_val);

			GNMSG("Write PHY[%d] register[%d] value[0x%x]...", addr, reg, data);
	        }
	        else
	        {
		        GNMSG("Example: echo r 1 0 > /proc/rtk_switch/phy_reg_value");
		        GNMSG("Example: echo w 1 0 0x8000 > /proc/rtk_switch/phy_reg_value");
	        }

        return len;
}
static const struct file_operations phy_reg_fops = {
        .owner = THIS_MODULE,
        .write = phy_read_write,
};

static struct dsa_switch_ops rtl83_switch_ops = {
	.get_tag_protocol	= rtl83_get_tag_protocol,
	.phy_read		= rtl83_phy_read16,
	.phy_write		= rtl83_phy_write16,
	.adjust_link		= rtl83_adjust_link,
};

void ethResetPin(void)
{
	if (!gpio_request(g_eth_rst, "eth-rst")) {
		gpio_direction_output(g_eth_rst, 0);
		mdelay(20);
		gpio_set_value(g_eth_rst, 1);
		mdelay(90);
	} else {
		printk(KERN_ERR "eth-rst gpio_request for %d failure\n", g_eth_rst);
	}
}

int rtl83_switch_init(void)
{
	rtk_port_mac_ability_t      mac_cfg;
	ethResetPin();

	/* Chip initialization */
       if (rtk_switch_init()) {
		ERMSG("!!!!!! rtk_switch_init() fail !!!!!!");
              return RT_ERR_FAILED;
       }

       /* rtk_port_rgmiiDelayExt_set(rtk_port_t port, rtk_data_t txDelay, rtk_data_t rxDelay);
                TxDelay: 0 or 1
                RXDelay: 0 ~ 7
       */
       if (rtk_port_rgmiiDelayExt_set(EXT_PORT0, 1, 1)) {
		ERMSG("!!!!!! rtk_port_rgmiiDelayExt_set() fail !!!!!!");
		return RT_ERR_FAILED;
       }

       mac_cfg.forcemode = MAC_FORCE;
       mac_cfg.speed     = SPD_1000M;
       mac_cfg.duplex    = FULL_DUPLEX;
       mac_cfg.link      = 1;
       mac_cfg.nway      = 0;
       mac_cfg.rxpause   = 0;
       mac_cfg.txpause   = 0;
	if (rtk_port_macForceLinkExt_set(EXT_PORT0, MODE_EXT_RGMII, &mac_cfg)) {
		ERMSG("!!!!!! rtk_port_macForceLinkExt_set() fail !!!!!!");
		return RT_ERR_FAILED;
	}

	/* Enable all ports (due to all ports are disabled by h/w design) */
	if (rtk_port_phyEnableAll_set(ENABLED)) {
		ERMSG("!!!!!! rtk_port_phyEnableAll_set() fail !!!!!!");
		return RT_ERR_FAILED;
	}

	if (!rtk_port_macForceLinkExtSSC_set(EXT_PORT0, ENABLED))
		GNMSG("RTL8363NB-VB SSC enable");

#if defined(CONFIG_PROLINE_EXEC_ALPHA)
	if (!rtl8367c_setAsicReg(0x1303, 0x0784))
		GNMSG("RTL8363NB-VB RGMII driving setting");
#endif
	return 0;
}

struct rtl83_device *rtl83_switch_alloc(struct device *base, void *priv) //weihanyi_tmp
{
	struct dsa_switch *ds;
	struct rtl83_device *dev;
	ds = devm_kzalloc(base, sizeof(*ds), GFP_KERNEL);
	if (!ds)
		return NULL;

	ds->dev = base;
	ds->num_ports = DSA_MAX_PORTS;

	dev = devm_kzalloc(base, sizeof(*dev), GFP_KERNEL);
	if (!dev)
		return NULL;

	ds->priv = dev;
	dev->dev = base;

	dev->ds = ds;
	dev->priv = priv;

	ds->ops = &rtl83_switch_ops;
	return dev;
}

int rtl83_switch_register(struct rtl83_device *dev)
{
	int ret;
	rtk_uint32 phy_sid = -1, value = -1;
	struct device_node *np;
	if (init_flag == 1) {
		init_flag = 0;
		goto dsa_register;
	}

	np = dev->dev->of_node;
	g_eth_rst = of_get_named_gpio(np, "gpio-eth-rst", 0);
	if(g_eth_rst < 0)
	{
		GNMSG("RTL8363NB_VB not found gpio-eth-rst %d", g_eth_rst);
		goto dsa_register;
	}
	GNMSG("RTL8363NB_VB found gpio-eth-rst %d", g_eth_rst);
	if (!(ret = rtl83_switch_init())) {
		rtl8367c_getAsicPHYReg(0x1, 0x02, &value);
		phy_sid = (value & 0xffff) << 16;
		rtl8367c_getAsicPHYReg(0x1, 0x03, &value);
		phy_sid |= (value & 0xffff);
		if (phy_sid == 0x1cc943)
			dev->name = "RTL8363NB-VB";

		GNMSG("Switch RTL8363NB-VB initial successfully");
		pr_info("found switch: %s\n", dev->name);

		if (rtl83_config_init(rtl83_host_mac))
			ERMSG("!!!!!! rtl83_config_init() is fail !!!!!!");

		init_flag = 1;
	} else
		return ret;

dsa_register:
	return dsa_register_switch(dev->ds);
}

static int rtl83_mdio_probe(struct mdio_device *mdiodev)
{
	struct rtl83_device *dev;
	struct proc_dir_entry *switch_dir = NULL;
	struct proc_dir_entry *hw_test;
	struct proc_dir_entry *rtk_reg_file;
	struct proc_dir_entry *phy_reg_file;
	int ret;

	/* allow the generic PHY driver to take over the non-management MDIO
	 * addresses
	 
	if (mdiodev->addr != BRCM_PSEUDO_PHY_ADDR && mdiodev->addr != 0) {
		dev_err(&mdiodev->dev, "leaving address %d to PHY\n",
			mdiodev->addr);
		return -ENODEV;
	}*/
	dev = rtl83_switch_alloc(&mdiodev->dev, mdiodev->bus);
	if (!dev)
		return -ENOMEM;

	rtkbus = mdiodev->bus;

	dev->bus = mdiodev->bus;

	dev_set_drvdata(&mdiodev->dev, dev);

	ret = rtl83_switch_register(dev);
	if (ret) {
		dev_err(&mdiodev->dev, "failed to register switch: %i\n", ret);
		return ret;
	}

	if (switch_dir == NULL) {
		switch_dir = proc_mkdir("rtk_switch", NULL);
		hw_test = proc_create("hw_test", 0777, switch_dir, &hw_test_fops);
		rtk_reg_file = proc_create("rtk_reg_value", 0777, switch_dir, &rtk_reg_fops);
		phy_reg_file = proc_create("phy_reg_value", 0777, switch_dir, &phy_reg_fops);
	}
	return ret;
}

static void rtl83_mdio_remove(struct mdio_device *mdiodev)
{
	struct rtl83_device *dev = dev_get_drvdata(&mdiodev->dev);
	struct dsa_switch *ds = dev->ds;
	dsa_unregister_switch(ds);
	remove_proc_entry("rtk_switch", NULL);
}

static const struct of_device_id rtl83_of_match[] = {
	{ .compatible = "rtl,rtl8363nbvb" },
	{ /* sentinel */ },
};
MODULE_DEVICE_TABLE(of, rtl83_of_match);

static struct mdio_driver rtl83_mdio_driver = {
	.probe	= rtl83_mdio_probe,
	.remove	= rtl83_mdio_remove,
	.mdiodrv.driver = {
		.name = "rtl8363nbvb",
		.of_match_table = rtl83_of_match,
	},
};

static int __init rtl83_mdio_driver_register(void)
{
	return mdio_driver_register(&rtl83_mdio_driver);
}
late_initcall(rtl83_mdio_driver_register);

static void __exit rtl83_mdio_driver_unregister(void)
{
	mdio_driver_unregister(&rtl83_mdio_driver);
}
module_exit(rtl83_mdio_driver_unregister);

MODULE_AUTHOR("Weihan Yi <Weihan_Yi@wistron.com>");
MODULE_DESCRIPTION("RTL83 switch");
MODULE_LICENSE("Dual BSD/GPL");
