/****************************************************************************
*
*    The MIT License (MIT)
*
*    Copyright (c) 2014 - 2023 Vivante Corporation
*
*    Permission is hereby granted, free of charge, to any person obtaining a
*    copy of this software and associated documentation files (the "Software"),
*    to deal in the Software without restriction, including without limitation
*    the rights to use, copy, modify, merge, publish, distribute, sublicense,
*    and/or sell copies of the Software, and to permit persons to whom the
*    Software is furnished to do so, subject to the following conditions:
*
*    The above copyright notice and this permission notice shall be included in
*    all copies or substantial portions of the Software.
*
*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
*    DEALINGS IN THE SOFTWARE.
*
*****************************************************************************
*
*    The GPL License (GPL)
*
*    Copyright (C) 2014 - 2023 Vivante Corporation
*
*    This program is free software; you can redistribute it and/or
*    modify it under the terms of the GNU General Public License
*    as published by the Free Software Foundation; either version 2
*    of the License, or (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software Foundation,
*    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*
*****************************************************************************
*
*    Note: This software is released under dual MIT and GPL licenses. A
*    recipient may use this file under the terms of either the MIT license or
*    GPL License. If you wish to use only one license not the other, you can
*    indicate your decision by deleting one of the above license notices in your
*    version of this file.
*
*****************************************************************************/


#include "gc_hal.h"
#include "gc_hal_kernel.h"
#include "gc_hal_kernel_hardware.h"

#if gcdFLOP_RESET
#    include "gc_hal_kernel_hardware_func_flop_reset.h"
#else
#if gcdINITIALIZE_PPU
#if !gcdINITIALIZE_PPU_C
static gctUINT32 ppuMem0[] = { 0x00010000 };

static gctUINT32 ppuMem1[] = { 0x00010000 };

static gctUINT32 ppuMem2[] = {
    0x38011039, 0x39200804, 0xC0A90050, 0x74000008, 0x38021039, 0x39202804, 0xC0A90050, 0x74000008,
    0x38031039, 0x39204804, 0xC0A90050, 0x74000008, 0xB8017005, 0x002018FC, 0x01C900C0, 0x40390098,
    0xB8027005, 0x002028FC, 0x01C90140, 0x40390098, 0xB8037005, 0x002038FC, 0x01C901C0, 0x40390098,
    0x04041036, 0x00000804, 0x4000047A, 0x00000002, 0x0400100C, 0x3FC04804, 0x40AB0440, 0x2000007A,
    0x38000835, 0x39207804, 0x41E80050, 0x00390018, 0x04041036, 0x00001804, 0x4000047A, 0x00000002,
    0x0400100C, 0x3FC04804, 0x40AB0440, 0x2000007A, 0x38000835, 0x39207804, 0x41E80050, 0x00390028,
    0x04041036, 0x00002804, 0x4000047A, 0x00000002, 0x0400100C, 0x3FC04804, 0x40AB0440, 0x2000007A,
    0x38000835, 0x39207804, 0x41E80050, 0x00390038
};

static gctUINT32 ppuMem3[] = {
    0x7E7E7E7E, 0x797B7E7F, 0x79797879, 0x7D7C7B7A, 0x80818181, 0x7B7C7D7F, 0x83817C79, 0x7C7D8082,
    0x7C7C7D7D, 0x7D7D7C7C, 0x81818181, 0x7D7D7F80, 0x73777E83, 0x71717171, 0x7E7A7574, 0x8A888782,
    0x7475797B, 0x8D888078, 0x8F92918F, 0x787B8189, 0x908E8781, 0x787B838C, 0x7A767576, 0x85868581,
    0x817F8185, 0x87838181, 0x8182878D, 0x787C8181, 0x807A787A, 0x8B878483, 0x8D8A8787, 0x8885878D,
    0x817E7D7D, 0x81828483, 0x7C7D7D7E, 0x69686D76, 0x6E6D6C6C, 0x70727271, 0x74727172, 0x74757675,
    0x6F6E7072, 0x70717170, 0x6E6E7073, 0x78767471, 0x7A77726F, 0x84817F7C, 0x93949596, 0x8D8D9092,
    0x8F8F8D88, 0xB3A79991, 0xABB4BABD, 0x8D9199A2, 0x77737274, 0x676F787A, 0x78716862, 0x7577797A,
    0x74747474, 0x78777675, 0x78797A7A, 0x74747576, 0x817C7977, 0x82848685, 0x787A7D80, 0x8886807A,
    0x79858D91, 0x6D6A696E, 0x676D7471, 0x5659646A, 0x3E3B3F45, 0x44484A46, 0x675B504A, 0x82807A72,
    0x71777C80, 0x6868696C, 0x716E6D6B, 0x7F7B7773, 0x87909391, 0x908F8A85, 0x9596938F, 0x89898C91,
    0x89878584, 0x92908E8C, 0x99999693, 0x7B818993, 0x7A818582, 0x928B8078, 0x928A8D97, 0xA5968F93,
    0x939DA5AB, 0x8F8D8A8C, 0x8D8B8A8C, 0x85878B8D, 0x7C7D8082, 0x7F807F7E, 0x85858382, 0x787B7F83,
    0x72717475, 0x9B928378, 0x9EB4B6AB, 0x8C898589, 0x998F8A8E, 0x686D7E93, 0x6A6A6865, 0x65646568,
    0x64676868, 0x60616162, 0x7A7A7268, 0x72767878, 0x6C717577, 0x716A6466, 0x7D7E7B78, 0x7A777679,
    0x8484817F, 0x7A7E8183, 0x89807E84, 0x8080868D, 0x60505069, 0x7074857A, 0x968D7A69, 0x8E8C8D93,
    0x6D6D7A8D, 0x8A7E7470, 0x7C7D7F80, 0x7A7A7A7B, 0x7A7A7C7C, 0x74757678, 0x7C7A7775, 0x75777A7C,
    0x7A7A7978, 0x7A7A7A7A, 0x81817C7A, 0x7D7E7F81, 0x8D898581, 0x8185898D, 0x7374787B, 0x79797674,
    0x797A7A7B, 0x79797878, 0x807F7D7C, 0x7D7E7F80, 0x78797A7A, 0x79797878, 0x77787878, 0x76767677,
    0x77777778, 0x76767676, 0x78767574, 0x7F7E7C7A, 0x797B7D7F, 0x76767677, 0x807E7C7A, 0x82828181,
    0x7C7F8183, 0x7979797A, 0x84807B79, 0x8E8D8C88, 0x88888888, 0x86878788, 0x82818384, 0x85868684,
    0x87878787, 0x87878786, 0x767B8185, 0x72717173, 0x7F818282, 0x76787A7C, 0x76767676, 0x74747576,
    0x78736E6A, 0x77787A7A, 0x78757474, 0x85827F7B, 0x8D8E8D8D, 0x8184878C, 0x87837F7C, 0x82848788,
    0x80818182, 0x7E7E7F7F, 0x8985817E, 0x8C8C8D8C, 0x8B8A8A8B, 0x7A80878B, 0x86817D7B, 0x8D8D8C89,
    0x87888785, 0x82828386, 0x89848181, 0x9293938F, 0x8D8D8F92, 0x868A8E8F, 0x89837F7C, 0x8C8E8F8D,
    0x78808689, 0x63666A71, 0x5F5C5F63, 0x73726E67, 0x75727274, 0x68696E74, 0x6C6B6C6B, 0x83837D73,
    0x686B7074, 0x807A716A, 0x81828180, 0x676C747C, 0x68626060, 0x7D7C7A72, 0x7074787A, 0x7F79716E,
    0x6E6A7585, 0x686E7474, 0x5C646665, 0x4F4C4C52, 0x63615A53, 0x786F6763, 0x7A7F8385, 0x77757475,
    0x6B6E7171, 0x65646467, 0x6662605F, 0x736E6A68, 0x79797877, 0x74757779, 0x78747170, 0x7B7D7D7B,
    0x7F7B7B7E, 0x7C818483, 0x8B878585, 0x92939491, 0x99949190, 0x90959B9D, 0x6C717E8A, 0x7E7D7870,
    0x81828282, 0x84828080, 0x71727C87, 0x7D7A7774, 0x676F7E88, 0x837B7068, 0x84888A8B, 0x7A7A7C80,
    0x76747373, 0x76787979, 0x6E6E7072, 0x87817A73, 0x8385878A, 0x797B8082, 0x8989837D, 0x7E7C7D83,
    0x817B7A7B, 0x757F8788, 0x6F727476, 0x6D6D6D6E, 0x707A7A75, 0x62626368, 0x62636566, 0x67656362,
    0x6E6E6E6E, 0x7E78726E, 0x817F7E7D, 0x908D8A86, 0x82818488, 0x8A8C8B87, 0x8184878A, 0x807F7E7F,
    0x84858787, 0x767A7F82, 0x6C6C6C6C, 0x7674716E, 0x76787A7A, 0x70717274, 0x6E6D6E70, 0x7D7B7772,
    0x807B7A78, 0x878D8E87, 0x79828989, 0x74777774, 0x4E545E67, 0x6B645A50, 0x8A796C68, 0x63718490,
    0x7068615C, 0x74747675, 0x7C787471, 0x82828180, 0x7A7B7B7B, 0x74757779, 0x858B877E, 0x7B747077,
    0x6F717980, 0x74767572, 0x6E6F6F6F, 0x696A6B6D, 0x565C6060, 0x605F5A55, 0x5F5F5E5D, 0x66646160,
    0x736E6A68, 0x7C7F7E7A, 0x75757879, 0x79797877, 0x71717375, 0x6C6E7273, 0x6D6B6A69, 0x71706F6E,
    0x66686A6B, 0x61616263, 0x7F7F7365, 0x61697379, 0x6B67625D, 0x69696B6C, 0x7776716B, 0x75737274,
    0x6E788082, 0x6F696365, 0x6E6F7172, 0x6E6D6B6B, 0x74625E6F, 0x74767679, 0x77787979, 0x7F7B7876,
    0x7C7D7D7C, 0x6E71757A, 0x63626262, 0x6C6A6865, 0x7C827C72, 0x76747173, 0x74706F6F, 0x74777A78,
    0x6A6F7274, 0x56595E64, 0x615E775C, 0x61625E6E, 0x694F8559, 0x13285176, 0x1910261C, 0x16201313,
    0x29191017, 0x567B8219, 0x836E967A, 0x6B6C7087, 0x726C6862, 0x71827477, 0x10171091, 0x13252F10,
    0x1010171C, 0x17101923, 0x60847A58, 0x66735684, 0x6E6A6868, 0x79777471, 0x5C747B77, 0x5676866C,
    0x5C67616B, 0x102D1F14, 0x67251028, 0x955B7689, 0x8A8B8B8C, 0x8989898A, 0x936E9489, 0x79778177,
    0x102A6A6E, 0x10151310, 0x1E131214, 0x13131F1D, 0x817C8D8B, 0x71706368, 0x696E7479, 0x7A746E69,
    0x7D807E7C, 0x73737478, 0x79797572, 0x60646C74, 0x7870596B, 0x7B8D9A93, 0x777A7274, 0x105F6880,
    0x10181829, 0x78604720, 0x65696D6E, 0x56585C60, 0x8D685B55, 0x8E78A599, 0x21107F71, 0x1024102F,
    0x10101B2D, 0x13251618, 0x634F5C16, 0x44567A3C, 0x5B565350, 0x5D5D5D5C, 0x5E5C5C5C, 0x69686461,
    0x73716F6E, 0x7A797775, 0x56677099, 0x465D624C, 0x1F134859, 0x10191910, 0x10101010, 0x10101010,
    0x71939610, 0x8F574661, 0x7A7C7B7A, 0x7B797778, 0x6068886D, 0x705F7971, 0x18101925, 0x1F10101D,
    0x1B1A1F10, 0x6C4C1F13, 0x6866686A, 0x5D545A6B, 0x5A5A5959, 0x57585959, 0x6C625953, 0x6D6F7171,
    0x44586863, 0x4C4E3C58, 0x101F2613, 0x101D1110, 0x161F1019, 0x4F191310, 0x6056617B, 0x4A505F6C,
    0x855B3E60, 0x3F4A3E78, 0x107A3849, 0x1B101A27, 0x1910101A, 0x102B101F, 0x5E6F1112, 0x67626263,
    0x65625E5C, 0x5F626466, 0x7A808588, 0x4A556472, 0x66629274, 0x4E464873, 0x6E673E56, 0x102F6E57,
    0x1B101810, 0x13131C19, 0x101E1019, 0x35685021, 0x75676D6E, 0x5981667E, 0x463E4E4F, 0x105C6350,
    0x19111822, 0x21101E10, 0x21232323, 0x18191A1E, 0x1D101E12, 0x674E4810, 0x66747368, 0x7C6E5D59,
    0x6B6B6A6A, 0x6F6E6B6A, 0x7F80776E, 0x74707077, 0x51107274, 0x10171E18, 0x19191919, 0x19191919,
    0x191B1C1C, 0x17171819, 0x646A6268, 0x6A726C74, 0x73637362, 0x32485C51, 0x2E1A1017, 0x1F131023,
    0x2A103114, 0x564A121C, 0x4C45374F, 0x35425A64, 0x6D614E40, 0x4550606C, 0x3D454B50, 0x282A2F35,
    0x7B797979, 0x7D7F807E, 0x7B7B7B7B, 0x7F7E7D7C, 0x80808180, 0x7B7C7E7F, 0x83817C79, 0x7E7F8182,
    0x7A7A7A7B, 0x7B7A7A7A, 0x817F7D7C, 0x83838281, 0x777D7E7A, 0x7B746E6E, 0x807F7E7D, 0x83838281,
    0x7A7A7D7F, 0x918D857E, 0x9192918F, 0x7D81868D, 0x8D8D8883, 0x75798088, 0x837D7977, 0x8A8C8D89,
    0x84828285, 0x87838183, 0x7E81878D, 0x81838280, 0x8B878481, 0x9393928F, 0x8F939595, 0x8787898C,
    0x82808080, 0x83848684, 0x82828283, 0x6E6E737C, 0x6F6E6E6E, 0x72737371, 0x75737272, 0x7A7A7A79,
    0x72737476, 0x70727373, 0x6D6C6E71, 0x7877746F, 0x6F717475, 0x8C847A72, 0x8E8F9090, 0x87888A8C,
    0x8A87837F, 0xB1A5968D, 0xA4ABB1B4, 0x878C939B, 0x78757578, 0x6870787A, 0x837A6E66, 0x8B8B8B89,
    0x74747575, 0x79787675, 0x78797A7A, 0x76767777, 0x817D7B7A, 0x7E818383, 0x77747476, 0x8C89847D,
    0x74818C91, 0x6C68666A, 0x6D70726A, 0x5C5E666C, 0x564A494C, 0x6A707168, 0x746E6866, 0x81817D79,
    0x787B7E80, 0x6E6F7174, 0x7473706E, 0x7F7B7875, 0x878D8D8A, 0x8D8D8985, 0x99988F87, 0x797D8591,
    0x85817E7C, 0x93918D8A, 0x98999894, 0x7A7F8791, 0x70747472, 0x938B7D72, 0x8D888C96, 0x9C8F888D,
    0x979C9FA1, 0x8E8D8E91, 0x8D8C8C8D, 0x87898C8E, 0x7A7B7F82, 0x8482807C, 0x8181807E, 0x74767B80,
    0x72727374, 0x84817B75, 0x949F9988, 0x8D8B8687, 0x938D898C, 0x74717A8B, 0x6B6D7074, 0x65676869,
    0x68686765, 0x5B5C6064, 0x787A746A, 0x78787474, 0x787B7B7B, 0x7C777374, 0x84858381, 0x807E7E81,
    0x8483817E, 0x7C7F8283, 0x877E7B7D, 0x787E878B, 0x524F4B5A, 0x6661685E, 0x948D7A6B, 0x8D8B8C91,
    0x6E6A788C, 0x7F7C7A77, 0x7B7C7D7E, 0x7B7B7B7B, 0x7B7C7E7E, 0x7777787A, 0x74747576, 0x76757474,
    0x7A797878, 0x7A7A7A7A, 0x807E7A78, 0x7B7C7D7F, 0x87868381, 0x81838687, 0x7374797D, 0x7A7A7774,
    0x7B7C7D7D, 0x7A7A7A7B, 0x7F7E7D7D, 0x7C7C7E7F, 0x78797A7A, 0x78787878, 0x77787878, 0x76767677,
    0x74747575, 0x74747474, 0x77747473, 0x7D7C7A79, 0x787A7B7C, 0x77767677, 0x7D7D7D7C, 0x81807E7D,
    0x80818283, 0x7B7B7C7E, 0x8683817F, 0x8B8B8A88, 0x88888787, 0x85868787, 0x81818183, 0x85868684,
    0x86878787, 0x85858585, 0x787C8082, 0x75747475, 0x7F7F7F7F, 0x7C7D7E7F, 0x7F7F7E7E, 0x7C7C7E7F,
    0x7A797472, 0x7375797B, 0x7A787675, 0x8583817D, 0x8B8C8C8B, 0x7F818588, 0x87837E7B, 0x81848788,
    0x7E808181, 0x81807F7E, 0x8784817E, 0x8B8C8B8A, 0x8A8A8A8B, 0x7A7F8689, 0x85817E7C, 0x89898887,
    0x8184888B, 0x87868281, 0x88858281, 0x8D8D8D8B, 0x8B8B8C8D, 0x86888C8D, 0x87838180, 0x83868989,
    0x797E8285, 0x6C6E6F74, 0x5F5C6064, 0x73726E66, 0x76757475, 0x62636973, 0x6E696763, 0x8A8A8378,
    0x646E7A82, 0x79726862, 0x787A7978, 0x5E636B74, 0x615B5A5C, 0x7273726B, 0x7C7C7A78, 0x817E7B7B,
    0x6D6A7584, 0x686C7172, 0x61636668, 0x5053585D, 0x605B5047, 0x776F6662, 0x7F7F7C7A, 0x75777A7D,
    0x6B6E6F6E, 0x65646568, 0x68666564, 0x736F6B68, 0x7A797876, 0x7B7C7C7B, 0x70707375, 0x7A797673,
    0x7F7A7B7E, 0x7E838785, 0x8B878585, 0x9092928F, 0x99939190, 0x8E949A9C, 0x72757D85, 0x807F7C76,
    0x81807F7F, 0x86868482, 0x70717B87, 0x7A787573, 0x6C717B83, 0x8A83796F, 0x85898C8D, 0x7A7A7D81,
    0x74747677, 0x6F727474, 0x6E6C6E6F, 0x89847A73, 0x82848789, 0x787A7E81, 0x83817A73, 0x7A7A7A80,
    0x817A7979, 0x77808788, 0x70737475, 0x6D6D6E6E, 0x6E777773, 0x62626266, 0x5F606262, 0x63626160,
    0x6B6B6B6A, 0x817A726D, 0x797B8185, 0x8D88817B, 0x81818589, 0x8E8E8C87, 0x8286898C, 0x81818181,
    0x80818284, 0x73767B7F, 0x6C6B6C6C, 0x7574716E, 0x7678797A, 0x71727374, 0x6A6A6D6F, 0x7A78746E,
    0x7877797A, 0x8B8E8B81, 0x7A818685, 0x777A7A77, 0x4C505A62, 0x6F695D52, 0x87786D69, 0x6571838D,
    0x746F6761, 0x74747677, 0x7A777473, 0x7A7B7B7B, 0x77767575, 0x7A7A7A79, 0x868B8781, 0x7E79767C,
    0x6F71797F, 0x74757572, 0x6E6F7070, 0x696A6B6D, 0x545E6363, 0x53514F4E, 0x5E5D5C5A, 0x5D5D5D5E,
    0x6A64615F, 0x777B7B74, 0x6C6E7174, 0x696B6D6D, 0x6C6A6C6E, 0x6C6E6F6E, 0x6A686868, 0x6E6E6D6C,
    0x696C6E6E, 0x64646668, 0x7B7B7165, 0x61687076, 0x6A67625D, 0x62646769, 0x716C655F, 0x76747373,
    0x71797C7D, 0x6D69676A, 0x7072716F, 0x6F6E6C6E, 0x74625D6E, 0x76787779, 0x77767676, 0x79797877,
    0x7A7B7C7C, 0x6F727478, 0x71706F6F, 0x79787573, 0x7B7A7977, 0x6D6F7479, 0x6E6E7072, 0x7875726F,
    0x6D717475, 0x5B5D6268, 0x615C6759, 0x61685E6E, 0x7A7D5C44, 0xD6144E6D, 0xDDE5E2EB, 0xE4EBEBEB,
    0xEBDCE3EB, 0x8F6E73DD, 0x64518573, 0x6766626E, 0x6E676260, 0x74887C71, 0xE7DD3B61, 0xE7E9CCEB,
    0xDCE1EBEB, 0xEBDEDCE2, 0x606F8774, 0x6371687F, 0x6D6A6868, 0x7674726F, 0x80817C79, 0x61748786,
    0x78635A4E, 0xEBE5D014, 0x86C8E5E7, 0x6E748F7B, 0x77777778, 0x75757676, 0x7E647F74, 0x7470656D,
    0xE1444A68, 0xE9CED7EB, 0xE6DDDDDD, 0xE7EAE9E8, 0x874A7282, 0x9F7E876E, 0x696E7478, 0x79746E69,
    0x7C808180, 0x6E6E7076, 0x6B6E6E6F, 0x5E606267, 0x5F5C646D, 0x6E76716E, 0x73796A73, 0x17496762,
    0xDEEBDFE4, 0x899AC9D7, 0x6267696B, 0x56575A5E, 0x6B5C656F, 0x83687A6F, 0xD31A7483, 0xEAD3E5E7,
    0xEBEBDEE0, 0xEBE4EBDF, 0x692F63E8, 0x534A584E, 0x58565554, 0x5C5C5B5A, 0x5E5C5C5C, 0x65646260,
    0x6B696868, 0x70706E6D, 0x7A707474, 0x4E4A543B, 0xC41B564C, 0xE9E5EBC4, 0xE8E8E8E8, 0xE8E8E8E8,
    0x8F556FEB, 0x6E7A7593, 0x5B5F6E7B, 0x61646560, 0x4A727E51, 0x6B54585E, 0xE1EBD52E, 0xE4EBE7E8,
    0xE6E8EBEA, 0x6668E6EB, 0x4E5D5E4F, 0x6E6C5F4F, 0x53535252, 0x53535454, 0x635C5653, 0x67686867,
    0x375B6352, 0x44505A4F, 0xEBE2D820, 0xEAE6D6CC, 0xDCE8E5E8, 0x6FE8E2EB, 0x45556166, 0x43504E43,
    0x495A525A, 0x4E4D4276, 0x2B446056, 0xD0EBEBDC, 0xDCE4EBD1, 0xEBE2D2EB, 0x438CE3D5, 0x60626E6E,
    0x625E5956, 0x5D606264, 0x74736F6C, 0x5E626970, 0x6E6C8561, 0x4A4B496C, 0x7A63582A, 0xE929566C,
    0xDDD9EBE9, 0xE2EBE2EB, 0xE7DEDBEB, 0x785A54DC, 0x7B74715E, 0x687B5673, 0x443E5154, 0x1462654E,
    0xEBE3E3E4, 0xEBE3EBE7, 0xE2E3E3E3, 0xDFDFE0E1, 0xE8E0E9E2, 0x636C60C8, 0x727B786E, 0x7C746867,
    0x58575D62, 0x7D776C60, 0x7C7C746D, 0x6B6B6E75, 0xD0347668, 0xEBEBE4CA, 0xE9E9E9E9, 0xE9E9E9E9,
    0xE9E9E9E9, 0xE8E8E8E8, 0x5B5D5756, 0x61646062, 0x50485064, 0x104D4946, 0xDFE9EAE8, 0xEBEBEADB,
    0xD7EADEEB, 0x4876D4E3, 0x5B4E4958, 0x3F4B616D, 0x6960534A, 0x4E56626A, 0x3F474D50, 0x2C2E3238,
    0x79747372, 0x8483817E, 0x7F808181, 0x807F7F7F, 0x80818080, 0x7D7E7F80, 0x82817C79, 0x80808182,
    0x77777878, 0x78787777, 0x817C7A77, 0x8B8A8785, 0x7A817C74, 0x877A6D6F, 0x82858789, 0x7C7D7E81,
    0x81818284, 0x95918A84, 0x93928F8D, 0x87898E92, 0x8A8D8C89, 0x75787D84, 0x938A8380, 0x999B9C99,
    0x898A8A8B, 0x89848286, 0x7E81888F, 0x8C8A8681, 0x9699958F, 0x999E9E98, 0x8F9B9F9D, 0x84888A89,
    0x83828283, 0x87878786, 0x8A8A8989, 0x74747A84, 0x706E6F71, 0x74747472, 0x79747373, 0x8383817D,
    0x787A7C7F, 0x6F727476, 0x68686B6E, 0x7876726D, 0x686D747A, 0x9387776B, 0x898B8B8C, 0x82848687,
    0x84837F7A, 0xA59A8D85, 0x999FA3A5, 0x83868C92, 0x7A797A7D, 0x6E747A7C, 0x8A837A73, 0x8A8B8D8D,
    0x74757778, 0x79787674, 0x78787878, 0x78787878, 0x817E7C7B, 0x7F818383, 0x7A777778, 0x8081817F,
    0x6B788287, 0x68635F62, 0x73757066, 0x65686C6E, 0x75656062, 0x8B929389, 0x7D7E8081, 0x7D7D7C7C,
    0x81818180, 0x76787B7F, 0x79787674, 0x7D7B7A79, 0x84868581, 0x8B8B8884, 0x8E938C83, 0x6C6D7481,
    0x817D7A78, 0x8D8C8885, 0x93949391, 0x8183878E, 0x6E6F706F, 0x8D898074, 0x8C898D96, 0x8D838188,
    0x9D9C9894, 0x8C8F9399, 0x8A898887, 0x8286898A, 0x787C8389, 0x7C7A7977, 0x7E7E7B7A, 0x6F73777C,
    0x78726F6F, 0x8182827F, 0x8F958E81, 0x8E8D8887, 0x8B8B8989, 0x7F787882, 0x6B6E757B, 0x6A6C6E6C,
    0x686A6867, 0x56585D63, 0x777A736A, 0x7D7A7473, 0x8686827F, 0x87868484, 0x88898887, 0x83838487,
    0x85838180, 0x7D7E8184, 0x81818180, 0x5E6C7B81, 0x49514A4C, 0x6259574A, 0x938D7E71, 0x8C8A8B8F,
    0x736A788D, 0x747C8481, 0x7A7A7B7B, 0x7D7C7B7B, 0x7D7E7F80, 0x797A7A7B, 0x6B6E7477, 0x77746E6B,
    0x79787777, 0x7979797A, 0x7E7C7975, 0x7A7A7A7C, 0x81818282, 0x82828181, 0x74767B80, 0x7D7B7975,
    0x80818181, 0x7C7C7E7F, 0x7E7E7D7D, 0x7A7B7C7D, 0x78797A7B, 0x76767677, 0x77777777, 0x76767676,
    0x71727272, 0x70707171, 0x7472706F, 0x7A797875, 0x77797A7A, 0x76767676, 0x7A7A7B7B, 0x7F7C7A78,
    0x84838382, 0x80818283, 0x87878685, 0x87878787, 0x87878786, 0x85858687, 0x81808181, 0x86878684,
    0x85868787, 0x82828384, 0x797A7C7D, 0x76767778, 0x7F7D7A7A, 0x84838281, 0x87878786, 0x84858787,
    0x80817F7E, 0x6E72787D, 0x7F7C7A79, 0x86858381, 0x86878787, 0x7A7C8083, 0x86817C79, 0x81838787,
    0x7E818284, 0x7D7C7C7C, 0x8581807E, 0x8A8A8887, 0x88888989, 0x7B7F8487, 0x8381807F, 0x83848484,
    0x7E7F8488, 0x81828280, 0x8784817E, 0x87878687, 0x87878786, 0x87878788, 0x87878686, 0x7A7E8387,
    0x777A7D7F, 0x75757475, 0x5F5E6266, 0x72706C65, 0x78797675, 0x5D5E6470, 0x6C65605C, 0x89898376,
    0x6874818A, 0x6E6A6462, 0x71716E6D, 0x5F63696E, 0x5A55575C, 0x61656863, 0x867F756E, 0x84868788,
    0x6E6E7884, 0x686C7071, 0x6865676B, 0x5761696C, 0x5C564A3E, 0x7068605C, 0x837F7872, 0x73767B81,
    0x6B6E6F6F, 0x65646568, 0x6F6F6E6E, 0x7573706F, 0x7E7A7775, 0x86858381, 0x686E787F, 0x7C78706A,
    0x8078797C, 0x878D8F8A, 0x8B878686, 0x8D8F8F8E, 0x96928F8E, 0x8B909799, 0x7A7A7D81, 0x82817F7C,
    0x84807E7F, 0x8D8E8E8A, 0x6F717A86, 0x79777473, 0x7474787C, 0x928D847A, 0x85898D8E, 0x7A7B7E81,
    0x6E717477, 0x68696C6E, 0x69656464, 0x89837A71, 0x8386888A, 0x787A7F81, 0x7C79716B, 0x7676787A,
    0x837C7979, 0x79808788, 0x72747677, 0x6B6C6E6F, 0x6C73736E, 0x62626263, 0x5C5D5E5F, 0x5F5E5C5C,
    0x62606060, 0x7D766D65, 0x6E72797E, 0x83807972, 0x7F7F8489, 0x918F8A84, 0x81848788, 0x81818080,
    0x7D7F8181, 0x7274797C, 0x6C6C6C6C, 0x7473706E, 0x76777878, 0x73747475, 0x66686C6F, 0x76746E69,
    0x77747575, 0x8A8D8B81, 0x83878786, 0x80828381, 0x5457626B, 0x6E6A6259, 0x83766E6E, 0x67718189,
    0x7A786F68, 0x75747579, 0x76767474, 0x72737476, 0x74716F6E, 0x83817D78, 0x878A8886, 0x82818183,
    0x6F71787E, 0x73747573, 0x6E6E6F70, 0x69696B6C, 0x525C6261, 0x4D4D4B4B, 0x5D5C5B59, 0x56585B5C,
    0x615A5858, 0x71797A6E, 0x6262676B, 0x5E626564, 0x625F6061, 0x6B6A6865, 0x6B696868, 0x6F6E6E6D,
    0x6E707172, 0x68686A6C, 0x76756E65, 0x62676D72, 0x6867625D, 0x5B5D6266, 0x6F69625E, 0x70727373,
    0x77797774, 0x6A6A6D71, 0x7576726E, 0x6F6E6E71, 0x73625D6B, 0x76787777, 0x75727272, 0x787A7B7A,
    0x78797A7A, 0x72737476, 0x78767676, 0x7E7D7B7A, 0x80787B85, 0x626B7A83, 0x6A6A6968, 0x7974706C,
    0x71747778, 0x6264686C, 0x6A645A5F, 0x50625B72, 0x58896E95, 0xE9162710, 0xE8E1EBEB, 0xE4EBE2E6,
    0xE1DFEBE2, 0x101028E7, 0x68454A10, 0x72625669, 0x7C776C6A, 0x5174806E, 0xD8D12810, 0xE8EBCAEB,
    0xE4EAEBDE, 0xEBE5E2D8, 0x87645811, 0x7363697C, 0x6B6A6969, 0x706F6E6C, 0x6E768768, 0x7A78928C,
    0x94726577, 0xEBD2E015, 0x5CD4EBE0, 0x6F8D9355, 0x6C6C6C6C, 0x6B6B6B6B, 0x797A7D63, 0x1F1C1050,
    0xD0121326, 0xEBEBEBE7, 0xE8EBEBEB, 0xE5EBDAE3, 0x552E2519, 0x8770725F, 0x676A7074, 0x74706A66,
    0x777B7D7D, 0x696A6D72, 0x5E646B6F, 0x615F5C5B, 0x6C5C6A5E, 0x82857A7A, 0x605F5B68, 0x3972666E,
    0xEAEBE5EA, 0x7A92D6E6, 0x5E626365, 0x5456575B, 0x7058504F, 0x7C727179, 0xE21B2B10, 0xEBD2E8E5,
    0xE0E8E6E8, 0xE5E5D0D7, 0x633438DA, 0x63505362, 0x56545454, 0x5C5B5957, 0x5D5C5C5B, 0x5F5F5F5E,
    0x61605F5E, 0x63636262, 0x8B636352, 0x635A6349, 0xDE103B15, 0xEBE4E4EB, 0xEBEBEBEB, 0xEBEBEBEB,
    0x1A132DCC, 0x70552812, 0x4E5C6D77, 0x7D6E594C, 0x146E8866, 0x1A101030, 0xD6E7E33E, 0xE8E2DEEB,
    0xEBE6DDCC, 0x1728D6EB, 0x5B52341A, 0x56443841, 0x4D4D4C4C, 0x504F4F4E, 0x56555353, 0x5E5D5C59,
    0x363F3B44, 0x1013665B, 0xEBEAE531, 0xEBE0E4E8, 0xE5E2EBEB, 0x32DDD6EB, 0x6256392C, 0x4B413844,
    0x394E525A, 0x5A4A4D70, 0x25191F2A, 0xE0EBEBDF, 0xE3E7EBE4, 0xEBE2E4EB, 0x1434CDEB, 0x6F7B7D53,
    0x645E5853, 0x5F626567, 0x716D635C, 0x6C6C6D70, 0x66686C4E, 0x5860505B, 0x78637D76, 0xDE2C1E15,
    0xE8E3EBE8, 0xE5E5E5E9, 0xEBEBEBE2, 0x10112DEB, 0x6F4D3510, 0x7A856379, 0x3E435E67, 0x10555642,
    0xEBEAEBEB, 0xE3E4E8EA, 0xE2E2E2E2, 0xE3E3E3E3, 0xE4DEE6EB, 0x7D7926DD, 0x7E817A72, 0x77767577,
    0x50525D67, 0x7F77695A, 0x7A79746F, 0x65686E75, 0xE5295C55, 0xEBE7EBE8, 0xE6E6E6E6, 0xE6E6E6E6,
    0xE8E8E8E8, 0xEAEAE9E9, 0x5352534C, 0x5151544D, 0x26194F48, 0x1114294F, 0xEBDDD9EB, 0xE6E4E8EB,
    0xD6E9E1EB, 0x104ABBE9, 0x503A4345, 0x66676866, 0x65605B59, 0x565C6568, 0x40464B4F, 0x3133363A,
    0x78737070, 0x8887847F, 0x83868788, 0x7E7F8081, 0x81818181, 0x7F7F8081, 0x817F7B79, 0x80808081,
    0x75767777, 0x77777675, 0x827D7976, 0x8F8E8B87, 0x7A7E7A74, 0x8B817574, 0x85898D8E, 0x7A7B7D81,
    0x81818284, 0x93908A85, 0x938E8987, 0x91939696, 0x878C8E8F, 0x787A7D81, 0x988F8783, 0xA4A4A39F,
    0x8E939699, 0x8C868388, 0x83878D93, 0x8F8D8985, 0x90999A93, 0x8F98988F, 0x8F9D9C91, 0x82878786,
    0x85838485, 0x88898887, 0x8E8E8D8D, 0x78797F88, 0x72707273, 0x77787774, 0x7C777575, 0x8B8A8782,
    0x7E818689, 0x6D70757A, 0x62626568, 0x76736E68, 0x6E707477, 0x92887C72, 0x8B8C8D8D, 0x84858788,
    0x82868581, 0x9088807E, 0x8F929394, 0x8385888C, 0x7E7D8082, 0x757A7F80, 0x8A87817D, 0x80818588,
    0x7476797A, 0x77767474, 0x77777676, 0x79797878, 0x7E7B7A7A, 0x81828281, 0x81818182, 0x6E747A80,
    0x6871787A, 0x6B666262, 0x7879726C, 0x6E767674, 0x81797474, 0x878C8D8A, 0x7E82878A, 0x7C7B7A7B,
    0x87858280, 0x7A7E8286, 0x7B7C7A7A, 0x7A7A797A, 0x81807E7B, 0x8C8B8784, 0x7B898D8C, 0x6F68636B,
    0x80808181, 0x7F7F7F80, 0x8B898582, 0x92908D8D, 0x8F919598, 0x8E959993, 0x8C8A8C92, 0x807A7C87,
    0xA19B9189, 0x888E989F, 0x8B8A8782, 0x7D848A8C, 0x757A8186, 0x75757474, 0x81817F7D, 0x71747A7E,
    0x7A716D6B, 0x81868884, 0x767A7A77, 0x82817C76, 0x86898A8B, 0x817C7A7F, 0x6E707476, 0x7474726F,
    0x686D6F6F, 0x5F5D5E62, 0x7574726F, 0x7D7A7775, 0x8D8C8780, 0x888B8C8C, 0x8C8B8A89, 0x8386888B,
    0x85828182, 0x7D7D8084, 0x7A818481, 0x50627276, 0x55605A59, 0x726F6E5A, 0x8D8A7E74, 0x8786868A,
    0x786F7A8C, 0x737D8887, 0x7A7A7A7A, 0x7E7D7B7A, 0x7C7E7E7F, 0x797A7A7B, 0x686D7377, 0x77736D68,
    0x78787776, 0x78787979, 0x7C7B7874, 0x79797A7B, 0x7B7D8183, 0x83817D7B, 0x76797E82, 0x807E7A77,
    0x82838383, 0x7D7E8081, 0x7B7C7C7C, 0x7A7A7A7B, 0x77797A7B, 0x75757576, 0x76767676, 0x76767676,
    0x6F6F6F6F, 0x6E6E6E6E, 0x706E6D6C, 0x75747472, 0x76777979, 0x73737474, 0x76777574, 0x7A787574,
    0x87858280, 0x82848787, 0x85868687, 0x82838384, 0x86858584, 0x84848586, 0x81808181, 0x87878785,
    0x84858687, 0x7E7F8182, 0x79797979, 0x76777879, 0x7F7B7977, 0x86858481, 0x88878787, 0x85868787,
    0x85868583, 0x72757B81, 0x8481807E, 0x86868786, 0x7F818283, 0x7577797C, 0x85807A76, 0x80828587,
    0x7F828486, 0x7274777B, 0x81807E7D, 0x88878684, 0x87878787, 0x7D808285, 0x8181807F, 0x7D7E8081,
    0x837F7E80, 0x757C8487, 0x84817B76, 0x82828384, 0x83828180, 0x87868584, 0x84858686, 0x70757C81,
    0x72747577, 0x79777473, 0x61616468, 0x716E6A65, 0x7B7B7774, 0x5F5F6572, 0x6462615F, 0x7A7A756C,
    0x777A7B7C, 0x686A6E74, 0x746F6B68, 0x6E717475, 0x615D6269, 0x5E666C69, 0x81766961, 0x85878988,
    0x6F737B84, 0x6B6D6F6F, 0x6E69696D, 0x68707675, 0x63635B52, 0x6C645D5E, 0x7E7C7874, 0x7374787B,
    0x6A6F7476, 0x66646265, 0x7576736E, 0x73747474, 0x807B7875, 0x8E8D8985, 0x6972808A, 0x847D736A,
    0x7D787A80, 0x80878B87, 0x8C8A8887, 0x8C8D8D8D, 0x928D8C8B, 0x858B9294, 0x7B7B7B7C, 0x7F7E7D7B,
    0x837C7A7A, 0x8F92928D, 0x6F707983, 0x79777473, 0x7C777677, 0x94928C83, 0x82878B8D, 0x797A7C80,
    0x6D6F7477, 0x68686A6C, 0x6E67625F, 0x87847E76, 0x82838687, 0x7A7C7F81, 0x7474716F, 0x73737374,
    0x857F7A78, 0x7C818788, 0x74787A7B, 0x66686C70, 0x6A706F69, 0x64646264, 0x5C5D5E5F, 0x5A5A5A5B,
    0x54515152, 0x736C6259, 0x6B686B6E, 0x7C7A7771, 0x7A7B8084, 0x8A87837E, 0x7B7D7F80, 0x7C7B7A7A,
    0x77797A7C, 0x6E707476, 0x6D6C6C6B, 0x7473716E, 0x76767676, 0x75757676, 0x63666C71, 0x726F6A66,
    0x827B7774, 0x8990938C, 0x91918F8D, 0x8C8E9091, 0x6E737C85, 0x73747470, 0x81777476, 0x67707D85,
    0x7F7D746D, 0x7674747A, 0x74747575, 0x6E6E7173, 0x736F6D6C, 0x88857F79, 0x87878788, 0x86878989,
    0x7071777D, 0x70737473, 0x6B6D6E6E, 0x6868696A, 0x5A5D6162, 0x6264625C, 0x5C5C5C5C, 0x56585B5C,
    0x5C565657, 0x6C76796B, 0x5C595C5F, 0x61646662, 0x59565656, 0x6866625D, 0x6F6E6D6D, 0x74737271,
    0x70727374, 0x696A6C6E, 0x6E6E6A65, 0x6265686C, 0x6868625E, 0x585C6066, 0x6C645E5B, 0x6C6E7271,
    0x7A78726D, 0x6B6E7278, 0x7B7B746E, 0x6E6D6F75, 0x71625E6A, 0x73757474, 0x726D6C6E, 0x7C7F7F7A,
    0x74767779, 0x74747474, 0x74737372, 0x78777674, 0x897F8391, 0x636B7D8D, 0x6D66615E, 0x75767673,
    0x73767879, 0x696A6D70, 0x605E4C65, 0x51585367, 0x4F5C4E45, 0xE2E4D342, 0xEBEBE8DC, 0xE8E7E2EB,
    0xC8D7EBE2, 0xEBEBD0EB, 0x7B8CDFDE, 0x78706471, 0x80816A68, 0x28567456, 0xE2EBEAEB, 0xD7EBEBD8,
    0xEBE4E6E3, 0xE5E5EBDF, 0x6858CAE6, 0x6D657D65, 0x6868696A, 0x6A696968, 0x6E5C6D65, 0x96949381,
    0x70687C93, 0xE5EBDB32, 0x63C4D4CA, 0x6A767A63, 0x6B6B6B6B, 0x6B6B6B6B, 0x716E6E55, 0xEBB43E68,
    0xEBC6E7EB, 0xC7DFEBE5, 0xEBEBE8E4, 0xD6EBDEEB, 0x62EBE1D6, 0x767A536E, 0x62666C70, 0x6E6B6662,
    0x70717171, 0x6E6E6E6F, 0x5C636E74, 0x67635E5B, 0x5D596D67, 0x65636463, 0x68625B71, 0x15535C71,
    0xDBE4E1EA, 0x828FD7DA, 0x575A5B5C, 0x51525456, 0x695D5757, 0x686B4A69, 0xEBE0BB3A, 0xE8E9DEE6,
    0xE9E9E6EB, 0xE1EBEBEB, 0x69DCCFEB, 0x4B3E444A, 0x5451504F, 0x5C5A5856, 0x5C5C5B5B, 0x58595B5C,
    0x58585857, 0x5A595959, 0x5046546A, 0x4950363A, 0xE5EBE110, 0xC5EBD4E6, 0xE7E7E7E7, 0xE7E7E7E7,
    0xEBEBD3E7, 0x6475D6E0, 0x64635B53, 0x7C716562, 0x1E457A8E, 0xDFEBEBC5, 0xE3E3EBC7, 0xEBE6E5EB,
    0xEBE8E5DB, 0xEBE0EBDC, 0x40125DE0, 0x3E486060, 0x4B4B4B4B, 0x4E4D4C4C, 0x4D4F5154, 0x5654504E,
    0x4E6D4C4D, 0xDF392F31, 0xC3E4E0E3, 0xE0DEEBEB, 0xEBE1E2DC, 0xE1EBE7D2, 0x4A165EE8, 0x45536868,
    0x4D4E535C, 0x3631524E, 0xD7DC2E3E, 0xEBCBDCEB, 0xE6E7E5EB, 0xC3E4EBEB, 0xEBEBDAEB, 0x7557466E,
    0x6E68615C, 0x66696E70, 0x6F6E6863, 0x5F62666C, 0x585B5B55, 0x747C6756, 0x5B495256, 0xE1EBC329,
    0xEBEBD2C9, 0xEBE2EBEB, 0xD4DCEBE8, 0xEBEBC5EB, 0x5A6AC1E2, 0x8D96746E, 0x474D6B74, 0x145F5E4A,
    0xE8E4EBE9, 0xEBEBE0EB, 0xE7E7E8E8, 0xE7E8E8E8, 0xEBEBE0E7, 0x6E7742EB, 0x807C7671, 0x6C71797E,
    0x67696E70, 0x726E6A67, 0x71707071, 0x62676D70, 0xE7255C5E, 0xE6E1EBEB, 0xEBEBEBEB, 0xEBEBEBEB,
    0xEBEBEBEB, 0xEBEBEBEB, 0x4B4A5751, 0x3A404C3E, 0xCE453E49, 0xE6E3DDE5, 0xD9E4E9EB, 0xDCEBEBD9,
    0xE1EBEBCA, 0xD1DDEBEB, 0x5043574F, 0x6E6B6861, 0x63606162, 0x585E6466, 0x3D414548, 0x32333538,
    0x7B757372, 0x8A898781, 0x85888C8D, 0x7C7D7F81, 0x82828282, 0x7F808181, 0x7D7D7A79, 0x7F7D7C7D,
    0x77787979, 0x79797877, 0x85807C7A, 0x908F8D89, 0x78777A7F, 0x8786827D, 0x86898C8D, 0x7D7E8082,
    0x7A7A7B7D, 0x8886817B, 0x90888380, 0x96999997, 0x82878B8E, 0x7A7B7C7F, 0x8B85807D, 0x9D9A9691,
    0x8F969EA4, 0x8D878488, 0x8C8E9294, 0x8C8C8C8B, 0x818D918D, 0x878D8980, 0x8E99917F, 0x85888785,
    0x86848585, 0x88898A88, 0x8C8C8A8B, 0x76767C86, 0x74737374, 0x7A7B7A78, 0x7D7A7878, 0x8D8C8883,
    0x81868B8E, 0x696E747B, 0x5C5C6063, 0x736F6862, 0x7C797471, 0x8B888480, 0x8E909191, 0x88898B8D,
    0x858B8B88, 0x7F7A787C, 0x89888787, 0x87878888, 0x81818284, 0x7C7F8283, 0x8786817E, 0x84848687,
    0x76787A7C, 0x76757474, 0x76767676, 0x77777777, 0x78777778, 0x7A7A7B7A, 0x8684807D, 0x70757E84,
    0x71747574, 0x77736E6E, 0x7C7D7879, 0x76858279, 0x7A7A7673, 0x7A767475, 0x7A7D8182, 0x7E7C7A7A,
    0x8583817F, 0x7D7F8184, 0x7C7E7F7E, 0x7877777A, 0x817C7A7A, 0x8F8D8986, 0x7A8C9598, 0x8074686B,
    0x83888D8E, 0x7174787D, 0x837C7673, 0xA49E948B, 0xBABDC4C9, 0x96A6B6BA, 0x89868284, 0x7A787C86,
    0xA1998D83, 0x878D98A0, 0x9B99938C, 0x848E999B, 0x7474777A, 0x79787775, 0x7D7E7D7C, 0x6F72767A,
    0x706B696B, 0x6F747876, 0x706A6A6A, 0x8A8C877B, 0x84898D8E, 0x7C7F8181, 0x78787470, 0x7D7A7575,
    0x69717679, 0x7A736966, 0x6D6F7A84, 0x7C7B7872, 0x8C8D8881, 0x82878B8B, 0x8C888787, 0x80858B8D,
    0x817C7A7C, 0x807D7E82, 0x767C7F7B, 0x66717875, 0x6E747377, 0x818D967E, 0x88877F78, 0x83818084,
    0x7A757B86, 0x757C8482, 0x7979797A, 0x7C7B7A7A, 0x7A7B7B7C, 0x77787879, 0x6D6F7375, 0x75736F6D,
    0x78787776, 0x78787979, 0x7E7C7976, 0x7A7A7B7D, 0x7A7D8184, 0x84817D7A, 0x797B8084, 0x82817E7A,
    0x82838485, 0x7C7D7F81, 0x7A7A7A7B, 0x7979797A, 0x76787A7A, 0x74747475, 0x76767675, 0x76767676,
    0x6F6F6F6F, 0x6E6E6E6E, 0x6E6D6C6B, 0x7271706F, 0x72747575, 0x6C6D6E70, 0x75746F6B, 0x75737273,
    0x8985807C, 0x8285888A, 0x81818181, 0x80808080, 0x84838382, 0x83838484, 0x82818182, 0x88888785,
    0x82848686, 0x797A7D80, 0x7A7A7978, 0x797A7A7A, 0x7E7B7A79, 0x83828181, 0x81818181, 0x80808181,
    0x88868280, 0x80828688, 0x87868584, 0x85868787, 0x777A7D7E, 0x6F707274, 0x827D7672, 0x7E818385,
    0x7E818181, 0x686C7279, 0x7F7D7C7B, 0x86858381, 0x82838382, 0x7C7C7E80, 0x7D7D7C7C, 0x78797A7C,
    0x807A7979, 0x71798183, 0x817B7570, 0x80818283, 0x7E7C7B7B, 0x85848381, 0x7D7E7F80, 0x696E747A,
    0x6A6C6E70, 0x77746F6C, 0x6566686B, 0x706E6B68, 0x7F7D7773, 0x6A686E78, 0x62686D6E, 0x686A6862,
    0x8A807167, 0x6872808A, 0x736E6865, 0x74767776, 0x716C7077, 0x70777D7A, 0x756C625D, 0x7F80807D,
    0x6E757C81, 0x6C6D6D6D, 0x726E6D6E, 0x7A7A7A77, 0x70797873, 0x6A625E63, 0x74767879, 0x7A767372,
    0x68727A80, 0x66626062, 0x79787168, 0x6F747878, 0x817C7A78, 0x908E8A86, 0x727A8790, 0x8D867A73,
    0x7A7A8087, 0x6E757C7D, 0x8D8D8B8A, 0x898A8B8C, 0x8D898787, 0x7E848C8E, 0x76767677, 0x77777676,
    0x7C757374, 0x898C8C86, 0x6E6E7580, 0x77747371, 0x7F797574, 0x8E8E8B86, 0x7C808589, 0x7476797A,
    0x7173777A, 0x6D6E6F70, 0x7E766E6A, 0x85868683, 0x7B7A797A, 0x7C7E7F7E, 0x6E71767A, 0x6E6D6D6C,
    0x867E7772, 0x84878989, 0x777C7F80, 0x61646A71, 0x6C706E67, 0x6C6B6868, 0x60626465, 0x5C5C5C5E,
    0x4F4C4D4F, 0x6A655C55, 0x64616266, 0x7575736C, 0x7877797A, 0x7A7A7A79, 0x73747474, 0x77767474,
    0x6F707374, 0x67696C6E, 0x6D6B6A69, 0x7474716F, 0x76757474, 0x79787877, 0x65686F74, 0x6F6E6966,
    0x87817B77, 0x8B939690, 0x99959291, 0x92939699, 0x8C8C9094, 0x878B8D8D, 0x7E79797E, 0x666D7981,
    0x807E756E, 0x7775767A, 0x74747575, 0x6E6F7072, 0x74706E6E, 0x87847E79, 0x85828387, 0x868A8D8A,
    0x7071767B, 0x6E717473, 0x68696B6C, 0x68686868, 0x6B67686B, 0x81858377, 0x5C5C5E60, 0x5B5C5D5C,
    0x59565859, 0x65737668, 0x5A565657, 0x63666662, 0x57555453, 0x67635F5A, 0x6F6E6E6D, 0x74747371,
    0x6F717272, 0x68686B6E, 0x68676565, 0x66656567, 0x6C6B6762, 0x5D5F6469, 0x675C5550, 0x6E6F716E,
    0x7A756E69, 0x6F72767A, 0x81807972, 0x6B6D727A, 0x6F646069, 0x6E727070, 0x6C68696D, 0x7B7C7A74,
    0x72737475, 0x76747472, 0x77767676, 0x76767677, 0x8D83838D, 0x6F707C8C, 0x716A6768, 0x74787B79,
    0x73747677, 0x6E6E6F71, 0x62655878, 0x69565C6B, 0x1410164B, 0xE8E2C73D, 0xD0EBD5EB, 0xEAEAEBEB,
    0xEBEBD0D8, 0xD4DCEBD0, 0x6A7ADEEB, 0x5762636C, 0x52706977, 0x10274110, 0xE0CBE8EB, 0xEBE0E6EB,
    0xDBC3DAEB, 0xE8EBEBC3, 0x3835C1EB, 0x6E4E5031, 0x66686869, 0x64646465, 0x8C5C5A75, 0x8C907670,
    0x311D8B7B, 0xCBEBC525, 0x81DDE3EB, 0x605F687C, 0x67676767, 0x67676767, 0x21155B6F, 0xEBB0222B,
    0xC0EBE0E3, 0xEBEBE8E0, 0xDADBE0E4, 0xD5EBBFE2, 0x1DC5DEEB, 0x59431E25, 0x61646A6E, 0x6B686360,
    0x6B686564, 0x7776746F, 0x61666F75, 0x68666361, 0x5A5F6A75, 0x736E6E64, 0x63685363, 0x101C2D3F,
    0xE9EBE6E7, 0x6171D6E2, 0x51525252, 0x4F505050, 0x5754443D, 0x1D371047, 0xCAD7B939, 0xE4E6EBE7,
    0xEBEBE2E8, 0xE4D8EADB, 0x2EDEEAEB, 0x32293113, 0x53504D4B, 0x57575656, 0x5B5C5B5B, 0x54555759,
    0x55555555, 0x55555555, 0x51694B5F, 0x1B371054, 0xCCEBDC2B, 0xE3E6DCEB, 0xE9E9E9E9, 0xE9E9E9E9,
    0xE0E8EBE4, 0x6C63E8DC, 0x65676E75, 0x535A6265, 0x19152410, 0xDBE2EBCA, 0xE6E9D1EB, 0xD7E9E8D2,
    0xDAEBEBEB, 0xDEE2DEE7, 0x40104ED0, 0x3B44564F, 0x4A4B4C4C, 0x4C4C4B4A, 0x4A4D5155, 0x514F4B49,
    0x16412F3C, 0xE0341F19, 0xE3E7BEEB, 0xEBEBE4D0, 0xDBE2EBE5, 0xEBE9E0E7, 0x491356E2, 0x313F5050,
    0x44566257, 0x2E13483A, 0xEBE61910, 0xE7EBEBD1, 0xE2EBDFDD, 0xEBE8EBDC, 0xE7EBD6EB, 0x633C1035,
    0x7A746D68, 0x6F73787A, 0x6C6E6F70, 0x49515D67, 0x55505363, 0x70727463, 0x1A191051, 0xE8D2D03E,
    0xCAE0E4EB, 0xE2EADDEB, 0xEBEBDFEB, 0xD2EBDDD0, 0x5F7ADCEB, 0x7A786267, 0x535C7880, 0x105A5E50,
    0xEBE6EBE7, 0xCADBC7EB, 0xE8E8E8E9, 0xE3E6E8E9, 0xCBE8DBE3, 0x79817DC3, 0x77726E6E, 0x61687379,
    0x88837568, 0x72747A83, 0x65666B6F, 0x61646867, 0xD1104A50, 0xE8E3E8DE, 0xE2E2E2E2, 0xE2E2E2E2,
    0xE5E5E6E6, 0xE4E4E4E5, 0x484A5F5E, 0x293C5040, 0xD63A101C, 0xE8EBE3E4, 0xDEEBEBEA, 0xDFEBE7D7,
    0xE8EBEBE4, 0xEAD2EBD5, 0x40342A10, 0x6164695F, 0x62616264, 0x555B6264, 0x383D4043, 0x30303134,
    0x7F797574, 0x89898885, 0x85878B8C, 0x7D7E7F81, 0x81828282, 0x7C7D7F81, 0x7A7A7977, 0x7B7A7879,
    0x7C7C7D7D, 0x7D7D7C7C, 0x87848180, 0x8E8D8D8A, 0x77747E89, 0x81878A82, 0x8788898A, 0x7F808285,
    0x6E707476, 0x7C79746F, 0x8C837D7A, 0x94979994, 0x7C808589, 0x7F7F7D7C, 0x7F7D7B7A, 0x8E8B8581,
    0x8A8E979F, 0x8D878587, 0x91929191, 0x888A8D8F, 0x7D868B8A, 0x8E8F887E, 0x8B8F887B, 0x88898786,
    0x89878686, 0x888A8C8C, 0x81828284, 0x6E6E737B, 0x78747372, 0x7E7F7E7C, 0x7B79797A, 0x87878480,
    0x7F83888B, 0x666B7279, 0x58585C61, 0x716D655C, 0x837D756F, 0x88878787, 0x8E909191, 0x88898B8D,
    0x888D8A86, 0x7A797980, 0x8482807F, 0x89888787, 0x84838485, 0x7D808384, 0x81817F7D, 0x81817F80,
    0x797A7A7A, 0x7A7A7979, 0x77787878, 0x75767677, 0x70727577, 0x6C6E6F70, 0x8881746B, 0x81828689,
    0x76767472, 0x7E7A7675, 0x83857F85, 0x7A8E897C, 0x7579736C, 0x7E746C6E, 0x75757576, 0x7A797876,
    0x7C7C7C7C, 0x7F7F7E7D, 0x7C808282, 0x78767678, 0x857D797A, 0x93908E8C, 0x929B9E9C, 0x8F888387,
    0x878E9396, 0x72747A81, 0x7D777370, 0xAAA19387, 0xC1C6CACA, 0x8E9EB0BA, 0x857E7977, 0x7E7C7F84,
    0x9C958A81, 0x888D959C, 0xABABA49A, 0x8F9DA8AB, 0x74777A7D, 0x71737474, 0x6A6C6D6E, 0x5F616468,
    0x62606062, 0x62656665, 0x81746E6C, 0x9699988E, 0x858C8F8D, 0x767F8483, 0x81817A73, 0x817D7A7C,
    0x6F757B7E, 0x978A796E, 0x686F869A, 0x817D776E, 0x858A8983, 0x7B828583, 0x857F7C7B, 0x757D8789,
    0x7A716E70, 0x827D7B7E, 0x777B7C7B, 0x7F7F7C78, 0x7E818189, 0x808E9F8D, 0x88898581, 0x84818183,
    0x7A7A7B7F, 0x797B7E7D, 0x797A7A7A, 0x7A7A7979, 0x77787979, 0x75757676, 0x74747474, 0x74747474,
    0x79787777, 0x7979797A, 0x81817C7A, 0x7D7E7F81, 0x7F818284, 0x8482817F, 0x7C7E8185, 0x8382817E,
    0x7F818385, 0x7A7A7B7D, 0x78787979, 0x7A797878, 0x76777879, 0x74747474, 0x75757575, 0x76767676,
    0x71727272, 0x70707171, 0x6F6E6E6E, 0x7070706F, 0x70717272, 0x696A6C6E, 0x75746E68, 0x716F6E72,
    0x88837B76, 0x7F83878A, 0x7B7B7B7B, 0x7F7E7D7B, 0x82818181, 0x82828283, 0x82818182, 0x87878785,
    0x81848585, 0x74777A7E, 0x7B797776, 0x7F7F7E7D, 0x7F7E7D7C, 0x7F7F807F, 0x7A7B7D7E, 0x7C7B7A7A,
    0x8B86807B, 0x8D8E8F8E, 0x86878787, 0x81818385, 0x7074787A, 0x6A6A6B6E, 0x807A736E, 0x7B7E8182,
    0x787A7978, 0x63676E74, 0x7E7B7A79, 0x81818180, 0x7C7F8080, 0x74747578, 0x77767574, 0x74747576,
    0x6D6B6E70, 0x74747470, 0x7A777474, 0x7F81817F, 0x77747578, 0x8081817D, 0x7A7B7B7C, 0x696E7479,
    0x6465686A, 0x746F6A66, 0x6D6E6F70, 0x72716F6E, 0x837E7874, 0x7A797B81, 0x68737C81, 0x68696866,
    0x8F816F62, 0x6D788792, 0x6966625F, 0x67686A6B, 0x77707074, 0x7F858781, 0x6E6C6C6C, 0x78787673,
    0x6E767C7D, 0x6E6D6A69, 0x72716F6E, 0x7E7B7774, 0x6D7A7B78, 0x5E56525B, 0x6E727577, 0x807A736E,
    0x68737D83, 0x63605D60, 0x7F7C7368, 0x777F8280, 0x807D7C7B, 0x8C8A8783, 0x7C81898F, 0x8C88827D,
    0x7A7A7E81, 0x777B7E7E, 0x8D8D8D8B, 0x8787878A, 0x8A878585, 0x7980878B, 0x74737373, 0x70737576,
    0x7D777575, 0x898A8884, 0x6E6E7681, 0x73717170, 0x7C777473, 0x84858581, 0x74767C81, 0x6E717373,
    0x71717374, 0x71737373, 0x88837C78, 0x7D818789, 0x78747271, 0x8081807C, 0x686F7981, 0x6A6A6968,
    0x857C736C, 0x88888988, 0x7A7F8182, 0x5D626A72, 0x70726E67, 0x7674706E, 0x6A6C6D6E, 0x66666868,
    0x59585A5C, 0x6A68635D, 0x57596168, 0x6867635C, 0x78746F6C, 0x6A6E7478, 0x6B696868, 0x72706E6D,
    0x6C6E7072, 0x6567696B, 0x6B686765, 0x7473716E, 0x76747372, 0x7B7A7978, 0x6A6E747A, 0x6F6E6C69,
    0x7A767574, 0x83888981, 0x918B8786, 0x8C8C8E92, 0x908C8988, 0x92939493, 0x7A777A81, 0x636A747B,
    0x7F7B736C, 0x7A797A7D, 0x74757677, 0x71717273, 0x74737171, 0x817F7B78, 0x807C7E81, 0x83878A87,
    0x7171757A, 0x6C707474, 0x67686869, 0x6B696868, 0x736E6E71, 0x888E8D81, 0x5F606367, 0x5F616261,
    0x56565B5A, 0x606E7263, 0x59565555, 0x5E5E5E5C, 0x5A5A5857, 0x62605C5B, 0x68676665, 0x6D6C6B69,
    0x6E6E6E6E, 0x6466686B, 0x62606164, 0x6A666362, 0x73726F6C, 0x66686B6F, 0x6E68625E, 0x6D6E7070,
    0x74716D6A, 0x79797977, 0x82817A75, 0x696E777F, 0x6F666269, 0x6C706F6E, 0x68686A6E, 0x7373716D,
    0x70707171, 0x76757472, 0x80818181, 0x7A7B7D7F, 0x84807A79, 0x7B75757F, 0x74757A7F, 0x70747675,
    0x6F707172, 0x6F6F6E6E, 0x74766F80, 0x54285C79, 0xE6C81A56, 0xE5CBEBE0, 0x212CBBE8, 0x101E1010,
    0x1D191F30, 0xEBEBDE10, 0x6B78D4DC, 0x7D7E7472, 0x646F5C6F, 0xEAE8C937, 0xE4EBE4E4, 0x25101FD6,
    0x23172710, 0xCFEBBF26, 0xE0D2EBD6, 0x936E7AB5, 0x63656868, 0x5F5F6062, 0x60567A55, 0x7A68625B,
    0xC6117F6A, 0xEBE4EBB5, 0x66DDE0DE, 0x626A5F67, 0x61616060, 0x62626261, 0xBF386560, 0xE2EBD5E9,
    0x1CDEEBEB, 0x101A2419, 0x161C1914, 0xEBC92225, 0xEBE9EBE6, 0x7560D7E4, 0x6064696D, 0x69676260,
    0x68626060, 0x7A78746E, 0x62646A70, 0x60626262, 0x6E6C5F60, 0x4B645C72, 0x62716E62, 0xE8DE3A6D,
    0xE6E8DCDB, 0x646FE1E5, 0x4D4C4C4C, 0x4F4E4E4D, 0x55544D4F, 0xDCD63E5F, 0xEBCCEBDB, 0x152DC6EB,
    0x101D2512, 0xDEC52731, 0xD0EBD7E9, 0x5772D6E1, 0x504F4D4B, 0x55555452, 0x595B5C5C, 0x51535557,
    0x53535353, 0x53535353, 0x5B724E56, 0xE3C5316D, 0xE6C5EBE4, 0x1927C2EB, 0x10101010, 0x10101010,
    0xEBEAD11B, 0x6A56EBEB, 0x565C666D, 0x4A4D5154, 0xD0E3CA44, 0xEBC7E8EB, 0x312525C1, 0x17212613,
    0x221A1016, 0xEBE9EBCA, 0xE8EBDBD0, 0x5A585674, 0x494A4A4B, 0x4D4C4A4A, 0x4B4E5254, 0x4F4D4B4A,
    0x2D3B455E, 0xD6C9EBC6, 0xEBEBDFC7, 0x1010111B, 0x12101010, 0xB7EBEBEB, 0xDDE7CCC8, 0x48474062,
    0x3A495653, 0x99134062, 0xE6E5EBE5, 0x24D9EBDA, 0x20211816, 0xCA31171F, 0xEADCEBDF, 0x7DC7E2E5,
    0x7A756F6B, 0x72757A7B, 0x6C6E7275, 0x444E5C66, 0x5245455E, 0x553B5F6C, 0xDECA106B, 0xEBD4EBCB,
    0x1E1FB0D1, 0x102A1913, 0x1013101B, 0xE4EBC410, 0x6070CED2, 0x6060616D, 0x66697D7E, 0x105D6962,
    0xCDDAEBEB, 0x103741B3, 0x15121111, 0x10131818, 0x101B1714, 0x756D561F, 0x6E6A6D73, 0x60656D70,
    0x998B6F58, 0x80828A96, 0x62656C72, 0x64666764, 0xDF236268, 0xEAE8EBE8, 0x1F1F1F1F, 0x1F1F1F1F,
    0x14151515, 0x13131314, 0x5257696C, 0x27496457, 0xEBE2E3E0, 0xEBD7D1EB, 0x25191013, 0x17101018,
    0xBC151014, 0xEBE0EBEB, 0x58B7E5EB, 0x675D5B54, 0x615F5F5F, 0x52585E62, 0x393F4447, 0x2C2D3034,
    0x817A7674, 0x87898A87, 0x82848687, 0x80808081, 0x7F818181, 0x797A7B7D, 0x76777776, 0x77757474,
    0x81818283, 0x83828181, 0x89878584, 0x8D8D8D8B, 0x7A7A838D, 0x81878983, 0x88898988, 0x7D7F8387,
    0x696D7275, 0x76736E69, 0x877F7A7A, 0x8D919390, 0x7B7D8186, 0x8786837F, 0x7A7E7F7F, 0x7F7C7978,
    0x807E848C, 0x89878583, 0x918F8C89, 0x898B8D90, 0x83868A8D, 0x97928B86, 0x81828689, 0x88888783,
    0x8D898786, 0x898C8F8F, 0x7577787A, 0x6664686F, 0x7A757270, 0x81818280, 0x7776787A, 0x7E7D7C79,
    0x797B7F81, 0x65696F74, 0x56575C61, 0x706B635B, 0x7C7A7876, 0x8D89837F, 0x888A8A8B, 0x81838587,
    0x8C8D867E, 0x7E7C7E84, 0x817E7C7A, 0x87868583, 0x84858586, 0x797B8083, 0x74767778, 0x77747272,
    0x7D7A7877, 0x81818180, 0x7A7B7C7D, 0x74757678, 0x6C6E7376, 0x6667686A, 0x8C867669, 0x81808288,
    0x77797877, 0x7F7A7675, 0x8C8E858A, 0x7A91897D, 0x797B756E, 0x82797172, 0x7A7A7978, 0x78797A7A,
    0x73747679, 0x83807A75, 0x7C818587, 0x7A777677, 0x8D817A79, 0x93939595, 0xA9A79E95, 0x99999EA5,
    0x8A8D8F90, 0x81838587, 0x7C7A7B7C, 0x9F988C81, 0xAEB7B1A8, 0x8287929F, 0x827E7A7A, 0x83818182,
    0x958F8781, 0x8E909396, 0xA8AAA59B, 0x8D9AA5A6, 0x71798187, 0x6365686C, 0x595C5F61, 0x52525456,
    0x59575656, 0x605F5D5B, 0x78706862, 0x82817E7C, 0x858E8F89, 0x757E8181, 0x82817C77, 0x82807E80,
    0x757A7E80, 0x9F928176, 0x7275879A, 0x85827E78, 0x7B848783, 0x747B7D7A, 0x827A7473, 0x6E798588,
    0x72686468, 0x7D767476, 0x7677787A, 0x867C7474, 0x878D878B, 0x7E828F89, 0x83878582, 0x807D7C7F,
    0x7E7E7D7B, 0x7C7E7F7E, 0x797A7C7D, 0x76777778, 0x76767777, 0x74747475, 0x79787675, 0x75767879,
    0x7A797878, 0x7A7A7A7A, 0x8685817E, 0x81828385, 0x86858584, 0x84858586, 0x80818385, 0x83838381,
    0x7A7E8184, 0x78787778, 0x76767677, 0x7A7A7876, 0x75767777, 0x75747474, 0x75747474, 0x76767675,
    0x74747575, 0x74747474, 0x73747474, 0x72727273, 0x74747473, 0x70717374, 0x7476716C, 0x706D6C6F,
    0x87807772, 0x7A7F8588, 0x78777878, 0x7D7C7A79, 0x8181807F, 0x81818182, 0x81808181, 0x84858482,
    0x81838485, 0x7174787D, 0x77747270, 0x83817F7B, 0x81818181, 0x7D7E7F80, 0x787A7E81, 0x7F7C7A78,
    0x8F8B8682, 0x8D8F9191, 0x82858789, 0x7B7B7D80, 0x6B6F7476, 0x66666768, 0x7D776F6A, 0x797B8081,
    0x70737475, 0x5F62676B, 0x7D7A7875, 0x7E7F807F, 0x757B7E7F, 0x6868696E, 0x6F6E6C6A, 0x6F6F7070,
    0x62626669, 0x7D776E66, 0x73747A81, 0x7E7F7D78, 0x706D7074, 0x797C7E79, 0x78787878, 0x686C7276,
    0x61626568, 0x736E6862, 0x76777676, 0x75747475, 0x88817A79, 0x8987898B, 0x757D8587, 0x75777673,
    0x83807A76, 0x74787E83, 0x6B6A6866, 0x6365686A, 0x766E6C6C, 0x83868781, 0x73757C81, 0x7C7A7874,
    0x6F7A7E7C, 0x72706C69, 0x6F707070, 0x75747270, 0x6771706B, 0x5B534E56, 0x74747474, 0x7C797674,
    0x68737B80, 0x5F5D5C60, 0x817F7468, 0x838A8A84, 0x7F7E7F7F, 0x84838180, 0x83848688, 0x81828383,
    0x7D7A7878, 0x88878681, 0x8B8D8C8A, 0x82828387, 0x89878585, 0x777D8689, 0x7D777474, 0x72798081,
    0x82807E7D, 0x8D8B8986, 0x73747E89, 0x72717274, 0x77737170, 0x7A7B7C7A, 0x6B6D7378, 0x686B6D6C,
    0x736E6B6A, 0x7F7F7D79, 0x8B87827F, 0x7C81868A, 0x81807F7F, 0x83858584, 0x6A707B84, 0x6C6D6D6A,
    0x837D746D, 0x81818284, 0x7A7F8181, 0x5E626B74, 0x74757068, 0x817E7974, 0x76767675, 0x75757676,
    0x6D6D7073, 0x7272716E, 0x585C666E, 0x595C5C5B, 0x7C74685E, 0x6068737B, 0x615E5C5C, 0x6B696764,
    0x68696C6E, 0x62636667, 0x68646260, 0x72706E6B, 0x75747271, 0x7D7C7A78, 0x70747A80, 0x71706F6E,
    0x6F6D6C6B, 0x747A7C76, 0x81787372, 0x817F8083, 0x8382807C, 0x82818182, 0x7573767D, 0x62687177,
    0x7E786F69, 0x7D7D7F80, 0x74767879, 0x71727274, 0x74737271, 0x7A797876, 0x7A76777A, 0x7F838581,
    0x7171757A, 0x6A6E7374, 0x68686868, 0x6E6D6A68, 0x74747473, 0x7F83827B, 0x696A6E71, 0x62676A6B,
    0x565A5D5B, 0x5F6D7062, 0x59595755, 0x56565657, 0x5B5C5C5A, 0x5A595758, 0x5E5C5C5B, 0x6262615F,
    0x6B6C6C6C, 0x61636669, 0x5D5B5D63, 0x6E686260, 0x7A7A7A78, 0x6E6F7276, 0x7B7D7A77, 0x6C6D7076,
    0x6E6C6D6E, 0x827F7A73, 0x837F7A76, 0x6B737C83, 0x6F686268, 0x6E73706F, 0x6B6B6C6D, 0x6E6E6D6C,
    0x706E6E6E, 0x76757472, 0x7D7F7F80, 0x7475787A, 0x76787168, 0x7E746C6E, 0x7A828788, 0x65666870,
    0x6B6B6C6C, 0x6E6E6D6B, 0x6C6C7470, 0x56105A76, 0xE2EB211E, 0xDCE4DCDC, 0x6653E3EB, 0x62745042,
    0x57597F52, 0xE9DBDB2E, 0x1E3FC7EB, 0x7E755332, 0x667D7290, 0xE8E8CE29, 0xD0DAEBE1, 0x876E67EB,
    0x6B6C7E62, 0xC7EBCC43, 0xE6DAEAEB, 0x60688BEB, 0x62636668, 0x5C5C5D5F, 0x15196231, 0x13101E23,
    0xEB101C19, 0xEBC5EBE7, 0x5FEBEBE9, 0x5766565E, 0x5D5D5D5C, 0x5F5F5E5E, 0xCF13635C, 0xD1E5E9E7,
    0x41E2EBE5, 0x44716E39, 0x565C5044, 0xEBD72C54, 0xEBC1E2E8, 0x8656EBE2, 0x5D616669, 0x65625F5C,
    0x62606162, 0x6D6E6C68, 0x5D5E6368, 0x55595C5D, 0x5756574C, 0x1F4C1047, 0x10101710, 0xE1DA103E,
    0xE3E8E7EB, 0x676FE9E7, 0x4B4A4949, 0x50504F4D, 0x535A5150, 0xDEDD2556, 0xE7E1EBEB, 0x657EE2E8,
    0x2B4A6350, 0xE8E12852, 0xE7E6EBE2, 0x4B40D1EB, 0x4A494949, 0x5C59534E, 0x575A5C5C, 0x51525355,
    0x51515151, 0x52525251, 0x1E104060, 0xEBBD261A, 0xE1EBE6E8, 0x2E74EBD6, 0x53535353, 0x53535353,
    0xEBE0D51D, 0x1F2FC0DC, 0x55514A42, 0x4B4C4F53, 0xDCDED424, 0xD9ABEBE3, 0x453755EB, 0x382F3B38,
    0x404F3943, 0xE8E2D0CF, 0xCAE8EAEB, 0x48595153, 0x4949494A, 0x52504D4A, 0x4F505152, 0x4D4D4E4E,
    0x19475D5C, 0xE9EBE4CA, 0xEBEAE4EB, 0x5E5F6867, 0x1D33344C, 0xEBDCE9E9, 0xD1EBE8EB, 0x545F4B4E,
    0x4A42464A, 0xE920436E, 0xEBC3EBE9, 0x4FE9EBE2, 0x4444424E, 0xDC423C45, 0xD7EBEBD7, 0xA2EBEBDA,
    0x706B6662, 0x6C6E7172, 0x696D6E6E, 0x444C5762, 0x51424258, 0x6A1A4971, 0xEBEB141C, 0xD0EBDDD0,
    0x756EE4EB, 0x565E6354, 0x4C5F5C39, 0xE9DCE148, 0x203CCFEB, 0x746A5F49, 0x83777A70, 0x30849287,
    0xEBE7EBEB, 0x3D6866E5, 0x625B5655, 0x61666A68, 0x5E646D50, 0x4E736666, 0x6A69737F, 0x69696C6D,
    0x92866F5C, 0x81828790, 0x62656C72, 0x61626362, 0xD4104953, 0xE9E0E6E1, 0x61616161, 0x61616161,
    0x72727171, 0x73737372, 0x60696F71, 0x25557271, 0xE9EBD8DF, 0xEBEBE9DE, 0x4A605E50, 0x6A6D563F,
    0xCC305161, 0xDEE9CAE3, 0x5CDAEBEA, 0x5C596762, 0x5F5C5A58, 0x55585C5F, 0x424A5156, 0x2B2D3139,
    0x827A7572, 0x87898A88, 0x81818181, 0x82828181, 0x7D7E7F80, 0x7576787A, 0x74757676, 0x74737172,
    0x85868687, 0x87868685, 0x8A888786, 0x8D8D8D8C, 0x7F81888E, 0x83848481, 0x8A8B8A89, 0x7A7D8287,
    0x6A6E7479, 0x77736E69, 0x857E7A7A, 0x868B8E8C, 0x7E7D8185, 0x8E8D8983, 0x7A7F8181, 0x72707074,
    0x7871737A, 0x86868581, 0x8E8B8682, 0x8C8D8D8F, 0x8583878D, 0x938D8787, 0x77778799, 0x8585847F,
    0x908C8887, 0x8A8D9193, 0x6D6F7174, 0x5F5D6067, 0x7C76716E, 0x81838482, 0x73747679, 0x76767574,
    0x74757778, 0x64686E71, 0x56575C62, 0x706B635B, 0x72757A7F, 0x938A7E74, 0x81838484, 0x7A7C7E80,
    0x8D8C8279, 0x807F8187, 0x7E7C7A79, 0x82828181, 0x84868686, 0x74777C81, 0x6A6C6E6E, 0x78746E6B,
    0x817B7774, 0x88878784, 0x7C7E8081, 0x7476777A, 0x6A6E7275, 0x67686969, 0x90908376, 0x72717784,
    0x7A7F8181, 0x817D7878, 0x92968889, 0x7990877D, 0x7A7C7973, 0x7A747073, 0x88888786, 0x7D7F8387,
    0x6D6E7375, 0x87817870, 0x7C828789, 0x7B797677, 0x94847A78, 0x93959A9D, 0xB2A9998E, 0x9BA0AAB1,
    0x8C898887, 0x92918F8D, 0x7C818689, 0x938D837D, 0xA5B0A594, 0x837F808E, 0x83838485, 0x87838182,
    0x908B8580, 0x93939392, 0x989D9992, 0x818D9797, 0x6A747E85, 0x60616265, 0x575C5F62, 0x52525354,
    0x55555453, 0x58565554, 0x6868615A, 0x786E6464, 0x85918F84, 0x787E7E7C, 0x7F7C7A78, 0x83828180,
    0x7A7E807F, 0x998D7F78, 0x817B818C, 0x87878787, 0x737E8381, 0x70767771, 0x877D7775, 0x727E8B8E,
    0x6E646266, 0x746E6C70, 0x706D6B6E, 0x87776C6E, 0x919B8E8A, 0x867D8386, 0x777B7B7A, 0x74727073,
    0x83827F7B, 0x7F818383, 0x797B7D7E, 0x74747577, 0x75767676, 0x74747474, 0x7B7A7776, 0x76777A7B,
    0x7A7A7978, 0x7A7A7A7A, 0x89878481, 0x85858687, 0x8A888684, 0x8486888A, 0x82828385, 0x83848483,
    0x777B8083, 0x76757474, 0x75747575, 0x7A7A7876, 0x74757676, 0x75757474, 0x75747474, 0x76767675,
    0x77777778, 0x76767676, 0x76777878, 0x74747475, 0x7A797776, 0x7A7A7A7A, 0x74787572, 0x706C6A6E,
    0x867E746E, 0x777C8387, 0x76767677, 0x7C7B7A77, 0x81807F7F, 0x81818181, 0x7F7E8081, 0x81828281,
    0x81838484, 0x6F73777C, 0x736E6B69, 0x85827D78, 0x82828383, 0x7D7E7F81, 0x7A7D8184, 0x82807B7A,
    0x93928F8D, 0x86898D92, 0x7F838789, 0x7777797B, 0x686D7274, 0x64636365, 0x7C756D68, 0x787A7E7F,
    0x6A707578, 0x5C5C6064, 0x7D7A7674, 0x7C7D7F7F, 0x71797D7F, 0x5F5F6168, 0x6A686563, 0x6C6C6C6C,
    0x68676868, 0x8A82766D, 0x6E73818D, 0x7C7C7A73, 0x6C686C73, 0x747A7C76, 0x6F6F6F6F, 0x60646A6E,
    0x60616467, 0x746F6862, 0x7D7D7B7A, 0x78787A7B, 0x8B827D7D, 0x92919291, 0x7E828687, 0x8285837F,
    0x757D878D, 0x78757271, 0x7A7A7978, 0x7174767A, 0x79716E6E, 0x84868681, 0x797F8890, 0x84827E7A,
    0x747F827F, 0x78756F6D, 0x6E6E7073, 0x6A6C6E6E, 0x6E757068, 0x69615B62, 0x7C7A7571, 0x7374787B,
    0x6971787A, 0x5C5C5C62, 0x7A797064, 0x878C897F, 0x7D7F8181, 0x7E7E7D7D, 0x86848281, 0x777B8185,
    0x7B797775, 0x8683807D, 0x898C8B89, 0x7F7F8184, 0x89878686, 0x767D868A, 0x877F7A79, 0x78828D8E,
    0x83828181, 0x8D898684, 0x7A7D8793, 0x74747679, 0x726F6E6E, 0x74767675, 0x65676D73, 0x65686868,
    0x7A6F6866, 0x92918D84, 0x8D898582, 0x86888B8D, 0x90929395, 0x86888C8E, 0x6E727C85, 0x70737370,
    0x83817972, 0x78787A80, 0x7B7F8080, 0x60646C74, 0x78787169, 0x87847E79, 0x7F7D7B7A, 0x81818181,
    0x7A7C8083, 0x787A7B7B, 0x68696F75, 0x565D6568, 0x80746256, 0x5B657480, 0x59565351, 0x6563615C,
    0x5E606366, 0x5A5B5D5E, 0x65615D5C, 0x706E6C69, 0x75737170, 0x7E7D7B79, 0x74797F83, 0x72727373,
    0x746E6A66, 0x6B747C7A, 0x746A6464, 0x78757578, 0x7B828381, 0x6D6C6D73, 0x726E7279, 0x62676F74,
    0x7D756E68, 0x80818281, 0x7577797A, 0x71717273, 0x74737170, 0x74757574, 0x77737476, 0x7B80817E,
    0x71717579, 0x696E7374, 0x68686869, 0x716F6D6A, 0x787B7A75, 0x7A7A7976, 0x7474777A, 0x666C7375,
    0x595D605C, 0x626F7162, 0x595C5855, 0x54515155, 0x595C5B59, 0x52515155, 0x57565554, 0x5C5B5A58,
    0x6A6B6B6A, 0x60626568, 0x5B575C63, 0x7168625F, 0x7F818181, 0x7374767A, 0x8184817D, 0x70707279,
    0x69696D71, 0x8882796F, 0x827C7876, 0x6E768185, 0x71696268, 0x70757370, 0x6F6E6D6A, 0x706F6E6F,
    0x706E6D6C, 0x76757472, 0x71737474, 0x65686A6E, 0x6D746F63, 0x7A706562, 0x808A8781, 0x59585E6E,
    0x68686868, 0x6E6C6A68, 0x62627E76, 0xB0377E7F, 0xE8EBD6E6, 0x201E19E8, 0x3F661012, 0x59484F5C,
    0x81639143, 0xBB31151E, 0xD2CAEBD6, 0x6280A2CA, 0x747D6177, 0xE3EBE53A, 0x1035E2DB, 0x58605839,
    0x744E617C, 0x17101C10, 0xE5EBE2E3, 0x61616EEB, 0x60626566, 0x5A5B5C5D, 0xBE43496E, 0xE7EBDED3,
    0xEBE5DBE4, 0xE2EBE9D2, 0x68E8E0DF, 0x535B4C69, 0x5C5B5B5B, 0x5C5C5C5C, 0xEB196A46, 0xE0E0EBE2,
    0x4D301014, 0x555F6659, 0x8D765950, 0x10421086, 0xDFE4EBE5, 0x8563EAE1, 0x595C6265, 0x615E5B58,
    0x5E5E6265, 0x5E606160, 0x595A5E62, 0x4E53585A, 0x423C5C4F, 0xC3D82844, 0xEBE5CBEB, 0xEBDFE2DF,
    0xE9E7E0E3, 0x3D52E5EB, 0x4C4A4948, 0x5251504E, 0x56625754, 0xE8E91F56, 0x28EAE5D6, 0x3D572110,
    0x626E5253, 0x10103336, 0xE2E9D821, 0x6D39DCE9, 0x44424344, 0x6660564B, 0x56595C5D, 0x52525254,
    0x50505050, 0x51515150, 0xDA354533, 0xCFEAEBDD, 0x1C241FD9, 0x7D381020, 0x56565656, 0x56565656,
    0xDB391912, 0xEBE7EBE8, 0x4C6891B0, 0x44474644, 0xEBE6E61A, 0x192BD6DB, 0x49614831, 0x3D515B41,
    0x103C473A, 0xEBBF1E2D, 0xE8E7DCEB, 0x555C5A6F, 0x4A4A4949, 0x5756514E, 0x52525150, 0x4C4E5051,
    0x25384446, 0xE5EBD5EB, 0x101528D2, 0x62566E5E, 0x11565371, 0xEB101716, 0xDFE8DAEA, 0x39372B4C,
    0x5856523D, 0xCA21473C, 0xDBE7DCEB, 0x4124102E, 0x3E645B5B, 0x13145431, 0xEBC31029, 0x52D6EBE4,
    0x645F5A56, 0x65666868, 0x62676562, 0x3E434B57, 0x594C4F62, 0xA6254A7B, 0xE5E7E7D2, 0x351932EB,
    0x52681610, 0x625C607A, 0x58687246, 0xC2181716, 0xD6D2EBBB, 0xA08FA1CB, 0x8D818275, 0x1E798F8D,
    0xE9DCE4E8, 0x5A7E69E9, 0x6358524F, 0x686D706D, 0x67628C6D, 0x648E4A75, 0x6B6D7A8A, 0x74706E6D,
    0x8481786F, 0x74757980, 0x5C60666A, 0x57595B5C, 0xE8206074, 0xEBDDE7EB, 0x5C5C5C5C, 0x5C5C5C5C,
    0x6E6D6C6C, 0x7171706E, 0x64726E6D, 0x1B52727A, 0xE6E4EBE2, 0x182BC8EB, 0x554C4245, 0x6E5D4A4C,
    0x21324644, 0xE3D37515, 0x4CE5EBEB, 0x55516056, 0x5D5B5653, 0x595A5B5C, 0x49545D62, 0x2B2E353E,
    0x877B7574, 0x828A9290, 0x81818181, 0x84838281, 0x7A7C7D7E, 0x77777879, 0x74747576, 0x78777574,
    0x87888989, 0x81808183, 0x8C87817B, 0x8A8B8C8D, 0x84858787, 0x89878684, 0x878B8D8D, 0x7C7E8184,
    0x6B717A82, 0x756E6868, 0x817C7774, 0x82838584, 0x82818284, 0x8D8D8A87, 0x6F757D83, 0x6E6E6E6D,
    0x7F7C7B7A, 0x88878481, 0x8E8B8784, 0x898C8E90, 0x85868788, 0x918E8A87, 0x767A848C, 0x87847F79,
    0x8F87878A, 0x969B9E99, 0x6D737A7F, 0x68676768, 0x7978746E, 0x74797B7A, 0x6C6B6E6F, 0x7A79746F,
    0x686E767C, 0x68686666, 0x6D6C6660, 0x7A746D6B, 0x6E7B7F79, 0x817B7068, 0x7A7B8185, 0x7A7B7C7B,
    0x817D7A7A, 0x7A7F8485, 0x7C787575, 0x757A7E7F, 0x7D7D7F80, 0x797A7D7E, 0x6A6C6F72, 0x7B776F6B,
    0x7E7A7776, 0x87878783, 0x7B7F8386, 0x7A7A7979, 0x6F747576, 0x6766676A, 0x8F908A7F, 0x71697387,
    0x85838180, 0x81828485, 0x88898B8D, 0x81848788, 0x747A7A77, 0x79716B6C, 0x99999894, 0x8F969A9A,
    0x746C6D7D, 0x8F877A74, 0x7C848889, 0x7B767374, 0x93908880, 0x81889193, 0x91878382, 0xA5A6A59C,
    0x96959493, 0x90929395, 0x7E818890, 0x8F87817E, 0x989F9F9B, 0x8886868D, 0x87888D91, 0x85878887,
    0x83848687, 0x908D8985, 0x8785878A, 0x7E858B8B, 0x63697176, 0x5C5D5F61, 0x595C5D5E, 0x53545657,
    0x52535353, 0x52525252, 0x50515353, 0x6B625750, 0x817F756D, 0x7D7A797C, 0x817B7A7F, 0x85818184,
    0x807D7C7E, 0x89848181, 0x86878681, 0x81888B88, 0x73747A80, 0x8387877C, 0x8E817A7D, 0x8C8F9598,
    0x827E7D88, 0x7174747A, 0x6B615C62, 0x7E6F686E, 0x8B8D8A83, 0x767F8687, 0x7B777271, 0x66646A75,
    0x9A8E7A74, 0x8F918F94, 0x75797E83, 0x6F727474, 0x76767474, 0x7B7A7776, 0x74787B7D, 0x7A767372,
    0x7A797776, 0x7A7A7B7B, 0x88878481, 0x86868687, 0x88878584, 0x84858788, 0x84838383, 0x85858584,
    0x747A8083, 0x71707071, 0x716F7174, 0x77797975, 0x73737577, 0x79797875, 0x72747678, 0x78767472,
    0x77777778, 0x7A797878, 0x7E7E7A78, 0x78787A7C, 0x7A787675, 0x7A7A7A7A, 0x787A7674, 0x6B6B6E73,
    0x867C7471, 0x747C878B, 0x7173777A, 0x7C797471, 0x7F7C7A79, 0x81818181, 0x7A7C7F81, 0x817F7C7A,
    0x81808080, 0x71767D81, 0x736E6967, 0x81807C78, 0x81828383, 0x82828181, 0x747B8184, 0x80797270,
    0x93908B88, 0x888C9093, 0x8286898C, 0x72757A7F, 0x686B6E71, 0x60616264, 0x706B6865, 0x7C7A7874,
    0x5F6E797F, 0x57535054, 0x807B7169, 0x7C7B7C7F, 0x737A7B81, 0x5F5D585F, 0x68676360, 0x6C6B6969,
    0x81756F70, 0x83818386, 0x6A6E7A84, 0x7D7B776F, 0x6C686D72, 0x69707573, 0x68746D61, 0x64564B54,
    0x60616262, 0x75706862, 0x7C7A7878, 0x74787B7E, 0x87838589, 0x878D908D, 0x81818283, 0x87868482,
    0x72798185, 0x7D78726F, 0x8787847D, 0x77808787, 0x79727072, 0x80838581, 0x777D8386, 0x87807774,
    0x7C818587, 0x7F7B7979, 0x68686F79, 0x706E6D6B, 0x8A937E64, 0x8E776671, 0x80838586, 0x7475787C,
    0x6970767A, 0x5C5D5F63, 0x747A7263, 0x787F7D74, 0x7F81807A, 0x81848480, 0x87848281, 0x7E818587,
    0x80848381, 0x85797075, 0x8C8D8C8C, 0x87888A8B, 0x87878787, 0x87878787, 0x8D808085, 0x74899D9E,
    0x7E776C62, 0x85828181, 0x818A8C8A, 0x6E6E7076, 0x73716E6C, 0x7A787574, 0x68696F77, 0x62626468,
    0x746C6662, 0x9591887F, 0x8E8C867F, 0x8A88888B, 0x93939494, 0x85878C8F, 0x74757E89, 0x7C7A7978,
    0x8A827B7A, 0x73757E89, 0x7D7F8080, 0x676B7178, 0x6E747471, 0x7676736D, 0x827C7875, 0x898A8A87
};

static gctUINT32 ppuMem4[] = {
    0x7E83898D, 0x807E7B7B, 0x84817F7F, 0x5C687A83, 0x7E766C66, 0x616A777F, 0x5C5B5856, 0x625F5C5C,
    0x52515A62, 0x52585C58, 0x60585554, 0x70716F69, 0x71696A6E, 0x787F827D, 0x72747D87, 0x6D6D6E71,
    0x877F736A, 0x6A737F87, 0x6B686868, 0x7A78746E, 0x767A7B7C, 0x67696E72, 0x716E6E6E, 0x686E7274,
    0x7A75706C, 0x7D7D7D7C, 0x7477797A, 0x6E6E6E70, 0x72716F6E, 0x74747473, 0x75747474, 0x75757575,
    0x72747475, 0x70707071, 0x6E6A6868, 0x76767572, 0x78757678, 0x7D7F7F7C, 0x81807D7A, 0x686E787F,
    0x625E6062, 0x67696B68, 0x62625C55, 0x5352555C, 0x5C5C5B59, 0x5052565A, 0x56504F50, 0x68625E5C,
    0x7B7E7468, 0x6260626E, 0x59565B62, 0x726B645E, 0x7D818283, 0x76757679, 0x72747472, 0x726F6E6E,
    0x73727170, 0x87817A75, 0x7C74757A, 0x747F8786, 0x706A686E, 0x747B7872, 0x78747475, 0x6F747A7B,
    0x706D6C6C, 0x72737473, 0x74797874, 0x66626269, 0x6A6A6B6B, 0x6D6C6A6A, 0x807B7168, 0x5C636F7A,
    0x62636566, 0x65646362, 0x61516277, 0xE0226E5C, 0xE5EAE6E2, 0x48627ACA, 0x4C514837, 0x4E4E4A46,
    0x78575350, 0xE610687C, 0xDFE2DBE0, 0x504E58EB, 0x1026109F, 0xEBE6BD38, 0x7483AEEB, 0x5E5A5561,
    0x716D645C, 0x1834566C, 0xE8EBE2E6, 0x181531D3, 0x5B5D6162, 0x605D5C5A, 0xD1154469, 0xEBE8E8EB,
    0xCDEBDCEB, 0xEBDDEBDC, 0x5DE6E8EB, 0x47594A56, 0x5C5C5550, 0x5D71564A, 0xEB10616A, 0xE3EBD5EB,
    0x3E524456, 0x64645C56, 0x8C716370, 0x2E5C4E55, 0xE7E8E9EB, 0x6788B7D9, 0x50535B60, 0x605C5651,
    0x5C5D5E5F, 0x52545659, 0x57565554, 0x4B4E5256, 0x4A705252, 0xEBD8173F, 0xCDDFEBD4, 0xE5EBDCEB,
    0xE8EBE2EB, 0x4A57E5EB, 0x4E4C4B4B, 0x5251504F, 0x3B105F60, 0xEBC93914, 0x5DDFCBEB, 0x4B58522C,
    0x6259504A, 0x314A6369, 0xEBCECA29, 0x1043E4D6, 0x4F483E5C, 0x685E5D3A, 0x565B5C5C, 0x4E4D4D50,
    0x50504E4E, 0x4D4E5050, 0xDC193F49, 0xEBE3EAE2, 0x6F7457C9, 0x50465B4B, 0x5860686E, 0x53535254,
    0xE715402F, 0xE0EBEBE9, 0x385662DF, 0x29403755, 0xDDEBEB16, 0x5F3FE7EB, 0x553D4245, 0x2A4D4853,
    0x446F233E, 0xD9C93E3B, 0xC5EBE5E8, 0x434F4C71, 0x4547494A, 0x5D564E47, 0x504F5256, 0x4E515554,
    0x56105012, 0xC4EBE8DB, 0x314B87BB, 0x565A523D, 0x524A5648, 0x8725235A, 0xCBEBE6EB, 0x23331A53,
    0x5B51394C, 0xE8103F5C, 0xD9E2EBE5, 0x504C293C, 0x4A544B40, 0x513E3D40, 0xE9E11948, 0x5CE9DEEB,
    0x615D5957, 0x67676664, 0x4D84534D, 0x38584348, 0x5E3E595A, 0xDE16627A, 0xE1EBD4E9, 0x52607CD6,
    0x5D63686C, 0x5A585758, 0x6D5F6552, 0xE619767C, 0xEBEBE6E3, 0x7E626FDE, 0x8E938083, 0x31315410,
    0xE8EAEBE8, 0x84875FD3, 0x686C7174, 0x6F6D6967, 0x5C5A5E5E, 0x60636A68, 0x76666462, 0x74876868,
    0x857A627F, 0x836B5C93, 0x695F6462, 0x124D515B, 0xDB28121D, 0xE4E3E9E6, 0x4A4A4A4A, 0x4A4A4A4A,
    0x8B626B68, 0x5458807A, 0x7878736F, 0x145D526A, 0xD8EBEAB7, 0x648DCADE, 0x4A544A61, 0x5D56474F,
    0x3B476A43, 0xE8EB123C, 0x4DE2EBE6, 0x55536059, 0x55555454, 0x59585756, 0x45555C5C, 0x3B322D34,
    0x8078726F, 0x81858786, 0x7F808080, 0x8181807F, 0x7C7D7E7E, 0x7C7C7C7C, 0x7A7A7A7B, 0x7D7C7A7A,
    0x83878787, 0x7A7A7B7F, 0x8B867E79, 0x8C8C8D8D, 0x84868789, 0x87868484, 0x86878989, 0x7A7B7F82,
    0x696D767F, 0x756E6968, 0x7A777574, 0x80807E7C, 0x817F8081, 0x8B8A8884, 0x7A7E8286, 0x71737578,
    0x807D7B7A, 0x88878582, 0x8F8D8887, 0x888B8D8F, 0x87878889, 0x8E8C8987, 0x74777E85, 0x89878179,
    0x938D8B8B, 0x9A9B9B99, 0x787E858A, 0x74747474, 0x6F737472, 0x6D6F706E, 0x67656668, 0x74736F6A,
    0x686A6E72, 0x65666767, 0x74736D66, 0x817A7474, 0x707A7E7C, 0x7B746C69, 0x73737475, 0x74747474,
    0x7B787676, 0x74797E7F, 0x75727171, 0x73757878, 0x76747474, 0x78797A79, 0x6F747574, 0x7C756E6C,
    0x7B787675, 0x8181817F, 0x7A7C7E80, 0x79787879, 0x73777A7A, 0x69696A6E, 0x93948D80, 0x776E778B,
    0x85878582, 0x86838182, 0x85858687, 0x80828485, 0x70777A7A, 0x756F696A, 0xA3A29F9B, 0x989EA4A4,
    0x77717382, 0x90897D77, 0x7E858B8D, 0x817E7A79, 0x94948F88, 0x747E8890, 0x7A737274, 0x9C999387,
    0x90929496, 0x95939290, 0x81848C93, 0x8B857F7F, 0x8D91918E, 0x89858285, 0x8B8D9093, 0x8B8C8D8C,
    0x81828384, 0x86858382, 0x85818184, 0x79808788, 0x60646B6F, 0x5A5B5C5D, 0x585A5B5B, 0x55555657,
    0x51525253, 0x50505051, 0x484C5051, 0x5B544B47, 0x78756A5F, 0x8D827876, 0x817C8188, 0x787A8083,
    0x7B787A80, 0x8D878280, 0x8E93938F, 0x82878B8C, 0x77777D81, 0x8A8E8C81, 0x978A8688, 0x96999F9F,
    0x9593939D, 0x7A7C7E88, 0x6D646269, 0x7D6F686D, 0x858A8781, 0x6F757B80, 0x76736D6B, 0x61606671,
    0x98887571, 0x92949395, 0x75797E81, 0x70727474, 0x77777675, 0x817E7A78, 0x7A7E8182, 0x79777576,
    0x807E7D7C, 0x80818181, 0x85858280, 0x81818284, 0x85848382, 0x82838485, 0x83828181, 0x87868584,
    0x777A7F81, 0x76757474, 0x74737374, 0x76777775, 0x74747576, 0x77787876, 0x71727474, 0x74747271,
    0x74747474, 0x76767574, 0x7F7F7B79, 0x78797A7D, 0x76757474, 0x77777777, 0x7A7B7B7A, 0x7B7A7A7A,
    0x79706E71, 0x78808683, 0x6F727579, 0x7975726F, 0x7C7A7877, 0x80807F7E, 0x76787A7C, 0x7C7A7876,
    0x83817F7F, 0x7D818485, 0x7A777574, 0x7F7E7D7B, 0x81828383, 0x81818181, 0x777B8082, 0x837F7976,
    0x8F8E8D8C, 0x8B8C8D8F, 0x82868A8D, 0x73767A7F, 0x65696E71, 0x5F5F6062, 0x6863615F, 0x73716E6B,
    0x69717474, 0x5C5A5A60, 0x7E7A716A, 0x7B7A7B7D, 0x7277767C, 0x63625C62, 0x6E6A6662, 0x7372706F,
    0x887F7979, 0x8686898D, 0x6467737E, 0x7979746B, 0x67666C74, 0x666C706E, 0x75796857, 0x5B545462,
    0x5F5C5C5D, 0x74716B64, 0x7C7A7877, 0x777A7D7E, 0x807A7A7E, 0x868A8D87, 0x83818386, 0x8B8B8986,
    0x76777C81, 0x7C7D7C79, 0x7A7F817F, 0x777B7C7A, 0x7A747172, 0x7B808481, 0x71747577, 0x7C787471,
    0x7A7B7D7F, 0x7F7E7B7A, 0x696B7178, 0x69666568, 0x898B7C6C, 0x93867A7E, 0x84888B8C, 0x76787B80,
    0x6E737679, 0x61626568, 0x73796F5E, 0x787B7770, 0x7E7F7D79, 0x85878680, 0x8C888789, 0x898D908F,
    0x8B8F8D8C, 0x827A7780, 0x8F8E8E8E, 0x9090908F, 0x84848687, 0x84858585, 0x81797E87, 0x7585928F,
    0x7F786C63, 0x7F7F7F81, 0x71747675, 0x71737371, 0x7474716E, 0x7B797775, 0x6868717A, 0x66666868,
    0x69666362, 0x7E7B756F, 0x8C8B8580, 0x86858689, 0x8B898887, 0x8C8C8C8C, 0x7A7A818A, 0x7F7E7E7D,
    0x91877D7A, 0x6E758391, 0x78797877, 0x6E707476, 0x6E747673, 0x696C6C6B, 0x8178706C, 0x8D8D8D88,
    0x7D82878B, 0x7F7C7A7A, 0x918D8887, 0x747D8990, 0x817F7A78, 0x686F7980, 0x65626263, 0x6C6E6E6A,
    0x5B5B6065, 0x575C5E5D, 0x635C5653, 0x7474716B, 0x76757473, 0x88837C78, 0x6C6E747E, 0x6A696B6D,
    0x817B746E, 0x6B717A80, 0x6F6F6F70, 0x74737170, 0x74747575, 0x6F707173, 0x79726F70, 0x71798080,
    0x76746F6D, 0x7A7A7A79, 0x72747778, 0x6D6C6D6E, 0x6E6D6C6B, 0x6E6E6E6E, 0x6E6E6E6E, 0x6F6F6E6E,
    0x73747475, 0x6E6F7072, 0x6D6A6A6A, 0x73747370, 0x7A757271, 0x8383827F, 0x77787A7D, 0x686D7275,
    0x5F5E6164, 0x5B5E6262, 0x66635D57, 0x5C5C5E62, 0x5B595858, 0x5155595C, 0x56504E50, 0x67625D5B,
    0x747A746D, 0x68626168, 0x5B575B62, 0x746E6862, 0x75797C7E, 0x7F7A7674, 0x75797A7C, 0x74737272,
    0x827E7874, 0x82828383, 0x7E78787A, 0x7A818785, 0x73727075, 0x767A746F, 0x7A787675, 0x70747A7C,
    0x73706E6E, 0x70727475, 0x7074706B, 0x6C686669, 0x696A6C6E, 0x6467696A, 0x74706C69, 0x62666E73,
    0x5F606162, 0x6261605F, 0x695D6671, 0xC7216E61, 0xEAEBE6DF, 0x35567ACD, 0x50565147, 0x4D51514D,
    0x7367574A, 0xE912505B, 0xE8EBE8EB, 0x755850EB, 0xE0D12B6C, 0xE4EBEBD6, 0x5637252C, 0x52535860,
    0x68676462, 0x4C5A666A, 0xD6A81F1C, 0xEAE2C5EB, 0x595B5E61, 0x605D5B58, 0xD7356073, 0xE8E5EBEB,
    0x2BCAEBE1, 0xCEEBCF1F, 0x5CE5E8EB, 0x45584854, 0x5759534F, 0x4A624D44, 0xE52D6867, 0xE0DCDCEB,
    0x5559505C, 0x775D4F56, 0x6351767D, 0x235E5679, 0x23201310, 0x6E553726, 0x484D5256, 0x55504A47,
    0x57595A5A, 0x51525456, 0x54545352, 0x4A4C5052, 0x556B4A47, 0xE6DC3356, 0xEBEBE5EA, 0x1922EBCA,
    0xE8EBE2EB, 0x4A57E5EB, 0x504F4E4D, 0x52525150, 0xD03C5F54, 0xE1EBCAD2, 0x443116E0, 0x3946403B,
    0x4D4C4E4E, 0x5D625F56, 0xDF251610, 0xE1D5EBE5, 0x4B505CB5, 0x4F4D4B41, 0x53555554, 0x504F4E50,
    0x504F4E4D, 0x4E4F5050, 0xEB254868, 0xEAD1DFEB, 0x5A444DEB, 0x472F4B4E, 0x54585958, 0x514F4D4F,
    0xEB1E5555, 0xE0E3D0DE, 0x444F5CEB, 0x2E513B5D, 0xC9D0E627, 0x5442E3E7, 0x5151543D, 0x4A5E4442,
    0x2B50453D, 0x1E16102A, 0x351E1018, 0x48565444, 0x44454849, 0x4E4A4543, 0x51505357, 0x50545656,
    0xE0E8EA18, 0x2EC8E8EB, 0x69614A36, 0x53525662, 0x4D565B54, 0x2B3D4E50, 0xEBE4BC42, 0x5EC3C1D7,
    0x605D4338, 0xEB153D5D, 0xE8E8EBE2, 0x4B4C2F38, 0x5650444D, 0x525B5750, 0xE0E83052, 0x55E4EBE5,
    0x5A565250, 0x5E5E5E5C, 0x4B6B415C, 0x5852434A, 0x52395056, 0xEB326068, 0xEBEADCE8, 0x683A6CEB,
    0x585A5C5C, 0x56565657, 0x6A5C524C, 0xCF216E62, 0xEBEBE9EA, 0x816E7EE8, 0x7C69637A, 0xEBD7C72D,
    0xEBE3E0E9, 0x7C8768E9, 0x6E747A80, 0x76736E6C, 0x314F7280, 0x937B5B3A, 0x7C616168, 0x54736673,
    0x8C766E6B, 0x545D7887, 0x665D625F, 0x10484A55, 0xE9C6EBEB, 0xD6EBE7D5, 0x69696969, 0x69696969,
    0x6B6E686A, 0x725A4D5D, 0x67656568, 0x2C695661, 0x19181110, 0x7F644125, 0x63626367, 0x50564C59,
    0x5348624B, 0xEBDD1348, 0x6DDED8E2, 0x4E444F64, 0x4E505152, 0x4A4A4B4C, 0x434E514F, 0x38312E35,
    0x7D7A7571, 0x8482807F, 0x7C7E7F80, 0x7B7B7B7C, 0x807F7E7D, 0x83828181, 0x81818182, 0x81818181,
    0x7F838585, 0x7474767A, 0x89837B76, 0x8C8C8C8C, 0x8386888A, 0x81818181, 0x81828282, 0x75787B7F,
    0x66676E78, 0x76716C68, 0x74747475, 0x7F7C7A77, 0x7E7C7C7D, 0x88878682, 0x8D8D8D8D, 0x8083888B,
    0x817D7A7A, 0x87878683, 0x8F8D8A87, 0x878A8D8F, 0x88898A8B, 0x8A898988, 0x79797E83, 0x8E8C877F,
    0x93918E8C, 0x98979594, 0x7D82898E, 0x7D7D7C7B, 0x69717778, 0x65676765, 0x62626264, 0x69696865,
    0x6F6D6B6A, 0x686B6F70, 0x7D7A736B, 0x85807A7A, 0x73797C80, 0x746D686C, 0x6D6C6A69, 0x706E6E6D,
    0x7A777474, 0x71767C7D, 0x6D6C6D6E, 0x6F70706E, 0x706C6A69, 0x79797874, 0x767B7A76, 0x7B746E6F,
    0x76747474, 0x7A7A7A7A, 0x76767676, 0x76767676, 0x767D8182, 0x6667696E, 0x91938B7B, 0x7A707687,
    0x84878582, 0x827F7D7F, 0x7E7C7B7C, 0x7E808180, 0x6D73797C, 0x736E6968, 0xA7A6A39F, 0x9BA2A8A9,
    0x7C767987, 0x938E827C, 0x81878D93, 0x87868381, 0x9093928D, 0x7079838B, 0x746E6D6E, 0x928F897F,
    0x888D9398, 0x9D978F89, 0x878C939A, 0x88838184, 0x80818180, 0x8B86817F, 0x8A8C8E91, 0x8B8B8C8B,
    0x81818181, 0x7D7E7F81, 0x7E7A7A7B, 0x6F767E81, 0x5B5E6367, 0x58595959, 0x56575758, 0x55555656,
    0x50515152, 0x4D4E4F50, 0x42474B4C, 0x4E48413E, 0x6D6A5F54, 0x9787756D, 0x7E7A818C, 0x84878986,
    0x7A75777C, 0x9C948A82, 0x969E9F9E, 0x81858A8F, 0x79787C80, 0x91938F83, 0x9A908C8D, 0x999DA1A2,
    0x9B999399, 0x8483828D, 0x6E696A71, 0x7D6F686D, 0x80878781, 0x696C6F76, 0x74706A66, 0x5F60666F,
    0x8C7C6965, 0x8588878A, 0x76797D80, 0x70727474, 0x75757574, 0x86817B77, 0x81848585, 0x7E7C7C7E,
    0x8281807F, 0x82828382, 0x83838180, 0x7F7F7F81, 0x81818181, 0x81818181, 0x83818181, 0x87878584,
    0x7A7C7E80, 0x7D7C7A7A, 0x76777877, 0x75747474, 0x77757575, 0x74767879, 0x6F6F6F6F, 0x6F6F6F6F,
    0x72717070, 0x74747473, 0x80807C7A, 0x78797A7D, 0x75757575, 0x78777675, 0x837F7B7A, 0x87888987,
    0x6962676E, 0x7B818178, 0x6C6E7274, 0x74726E6C, 0x7A777574, 0x7E7D7D7B, 0x7476797A, 0x7A797674,
    0x83807E7E, 0x85878787, 0x81818282, 0x7C7D7F80, 0x81828282, 0x81818181, 0x7C7B7D7F, 0x89878480,
    0x8C8D8E8F, 0x8D8C8C8B, 0x8185898D, 0x74767A7E, 0x61676D70, 0x5E5D5C5D, 0x625E5C5B, 0x6E6C6865,
    0x7577726B, 0x6463666E, 0x7D7A746E, 0x79797A7C, 0x7576747A, 0x6A696468, 0x78746E6A, 0x7B7A7A7A,
    0x8C837E7C, 0x84868B8E, 0x5F616E7A, 0x78787468, 0x63646E76, 0x64696C68, 0x7C7A6855, 0x5A585E6E,
    0x645D5C5C, 0x7675736C, 0x7C7A7877, 0x7A7D7F7F, 0x7B747477, 0x83878A85, 0x807E8287, 0x8F8F8D87,
    0x7F7E8388, 0x81858784, 0x68727A7E, 0x73716B66, 0x7C747170, 0x767C8382, 0x676A6F73, 0x6B6A6867,
    0x76727273, 0x8181817C, 0x7176797A, 0x625E5F68, 0x7D77706C, 0x8D8A8681, 0x84888B8D, 0x77797C80,
    0x6E707273, 0x6466686B, 0x747A705F, 0x7778746E, 0x79787774, 0x8686827C, 0x8C88898C, 0x92949592,
    0x8E949697, 0x817B7A83, 0x8A888787, 0x8F8E8D8C, 0x80818487, 0x7F818181, 0x72727F8D, 0x7A81837C,
    0x8480766F, 0x787A7D82, 0x69696B6B, 0x7276766F, 0x7A787574, 0x807E7B7A, 0x6666707C, 0x68696B6A,
    0x63656869, 0x6C696764, 0x89898681, 0x81818186, 0x8481807F, 0x8E8D8A87, 0x7F7B8188, 0x80808182,
    0x93887E7A, 0x67748794, 0x72716F6E, 0x73747473, 0x6F757674, 0x6164676A, 0x7C716761, 0x8F8E8C86,
    0x7B818689, 0x7D7B7A79, 0x88878481, 0x8B8A8988, 0x8386888B, 0x767A7E81, 0x6E686C71, 0x767C7F79,
    0x666B6E6F, 0x5E5D5F62, 0x6F68615C, 0x7D7B7874, 0x80827D76, 0x8F857B7A, 0x6A6A6F77, 0x6A69696B,
    0x7975716E, 0x7174777A, 0x7477797A, 0x6A6B6E71, 0x6F6D6C6C, 0x7A787572, 0x8177767A, 0x7A858E8D,
    0x72717070, 0x78777574, 0x6F727577, 0x6A6A6B6D, 0x68696A6B, 0x62636466, 0x63636262, 0x64646463,
    0x73747373, 0x6E6E7072, 0x6C6B6C6D, 0x6E6E6F6E, 0x78716A65, 0x8B88847F, 0x6C727C85, 0x66686A6A,
    0x5D5E6164, 0x55585C5E, 0x67625C59, 0x65666868, 0x57555658, 0x54585C5C, 0x56504E50, 0x645F5C59,
    0x6C747470, 0x6E665E61, 0x5C565C64, 0x706E6A65, 0x6D6F7476, 0x8881766E, 0x8D8D8F90, 0x8184888B,
    0x8B867E77, 0x7D81868A, 0x7F7B7A7A, 0x7F818281, 0x7A7F7D81, 0x76756D6D, 0x82817C79, 0x74767B80
};

static gctUINT32 ppuMem5[] = {
    0x7573706F, 0x6C707476, 0x6E6E6A64, 0x706B6869, 0x67666768, 0x61646868, 0x6868696A, 0x65666868,
    0x5D5E5F5F, 0x5F5F5E5D, 0x5C65635C, 0xBF245040, 0xD5DEE0E1, 0x415C7BBA, 0x54575652, 0x4E565A56,
    0x5A47464E, 0xE3246557, 0xE4E6E9EA, 0x715A58E7, 0xEBE71F6A, 0xEBE9DFDE, 0x625D5954, 0x5C535662,
    0x5D626869, 0x6264625E, 0xEBDE254E, 0xD6E8D9E3, 0x56595C5F, 0x5D5C5856, 0xAB355D5A, 0xDED5D3C6,
    0x46BBEBDA, 0xD4EBE019, 0x5AE5E8EA, 0x44574752, 0x5155514F, 0x3150433D, 0xB7191D10, 0xE8E1EBEA,
    0x74655437, 0x5F575C5D, 0x694F6365, 0x43627A7C, 0x504D5054, 0x61626059, 0x4C505456, 0x56514B49,
    0x54555656, 0x51515253, 0x50515151, 0x4A4C4D4F, 0x435C5665, 0xC0B72E45, 0xEBE4E7EB, 0x1F46EBD9,
    0xE8EBE2EB, 0x4A57E5EB, 0x51515050, 0x53525252, 0xD0104F5F, 0xEBEBEBEB, 0x25565FBB, 0x524A6E59,
    0x4A4C4B49, 0x625E564D, 0xDD102568, 0xEBE5E1D2, 0x45445EEB, 0x464C454B, 0x52535352, 0x54525050,
    0x504F4D4D, 0x50505050, 0xC526445B, 0xEBD6D6D6, 0x5B594FB7, 0x3D364A44, 0x51514A44, 0x4E4B4A4D,
    0xE7206347, 0xEAE8D9E5, 0x3E3D41E8, 0x25421036, 0xEBE9EA1D, 0x6C4CCAE0, 0x5F4E5344, 0x505B4D5C,
    0x6E705548, 0x38434762, 0x45414848, 0x4A424A51, 0x44464747, 0x4A484444, 0x52505458, 0x50545756,
    0xD9EBE910, 0x47E6E8DC, 0x3A273956, 0x4D687863, 0x4A46474B, 0x34495652, 0xEBE7E317, 0x43E5EBEB,
    0x68605944, 0xD0125D82, 0xEBE0E2E9, 0x3C5C5B4C, 0x3833444C, 0x3842504D, 0xEBE81024, 0x61C9DAE5,
    0x5758595B, 0x5E5C5A58, 0x122A104B, 0x45251010, 0x4D455D6A, 0xB5305453, 0xE4EBE1EB, 0x484565C2,
    0x56514E4D, 0x565A5C5B, 0x62504E63, 0xDF45825C, 0xDEDCE8EB, 0x807179DD, 0x5E546893, 0xEBE6D121,
    0xEBE8E9EB, 0x988F6DDD, 0x6F767F84, 0x77746E6D, 0x55576081, 0x626D5646, 0x805C6172, 0x2C5D667B,
    0x29102012, 0x64676E2E, 0x62595E5A, 0x10444550, 0xEBD2E0E2, 0xD6E2D0EB, 0x57575757, 0x57575757,
    0x5A746F61, 0x7E70554F, 0x5C56585D, 0x4977615D, 0x68594F5B, 0x6374726A, 0x615E665C, 0x4D594B51,
    0x5554672B, 0xEBDA317A, 0x4EDFEBEB, 0x4459553E, 0x44484B4D, 0x3A3B3D40, 0x3F45433E, 0x38323036,
    0x7777726D, 0x827B7574, 0x7A7D8081, 0x75767779, 0x817F7D7B, 0x87878583, 0x85868787, 0x82828384,
    0x7D818282, 0x73737478, 0x88827B75, 0x88898A8A, 0x81848788, 0x7A7B7C7E, 0x7C7C7C7B, 0x7274777A,
    0x6462676E, 0x79746F6A, 0x79797A7A, 0x817F7C7A, 0x7F7D7D7E, 0x88888783, 0x93918F8E, 0x8C8F9394,
    0x817E7B7A, 0x87878684, 0x8D8C8887, 0x888A8D8E, 0x8B8C8C8C, 0x8787888A, 0x7F7D8184, 0x92908C85,
    0x8D8D8D8E, 0x8D8D8E8D, 0x7A7D848A, 0x80807D7A, 0x6E777B7B, 0x6468696A, 0x62626466, 0x61626362,
    0x77726C68, 0x6E72787A, 0x817F766E, 0x817D7A7D, 0x74757980, 0x6F68666E, 0x66676563, 0x6C686564,
    0x847E7A77, 0x767D8487, 0x686B6E71, 0x6E6C6A68, 0x706C6969, 0x797A7975, 0x797B7A77, 0x7A767374,
    0x716F6E6F, 0x75767674, 0x71706F6F, 0x78767473, 0x747B7F81, 0x6566686E, 0x82878171, 0x766A6D7A,
    0x8283817F, 0x7374797E, 0x76727070, 0x7E7E7D7A, 0x6B70777C, 0x73706D6A, 0xA2A19D99, 0x969DA3A4,
    0x7F7A7A86, 0x98948780, 0x86878D92, 0x87898A88, 0x878A8986, 0x7F848787, 0x938D8987, 0x999B9B98,
    0x82889198, 0xA2998D84, 0x898D939A, 0x83808085, 0x827F7E7D, 0x918E8A86, 0x81838486, 0x7E7F8081,
    0x82817E7C, 0x7A7C8081, 0x74747477, 0x656B7274, 0x57595D60, 0x57575757, 0x54555656, 0x52525354,
    0x4E505050, 0x4A4A4B4D, 0x41454848, 0x4E48413F, 0x64625B54, 0x8D806F67, 0x7C798087, 0x93928F87,
    0x83818081, 0xA2978C87, 0x93999FA3, 0x7C82898E, 0x7876797A, 0x92938F82, 0x9C938D8C, 0x969BA2A3,
    0x97938B8E, 0x807D7B87, 0x6F6D6F75, 0x7E726B6E, 0x7C858682, 0x6564676F, 0x736F6761, 0x6062686F,
    0x8A7D6860, 0x797B7B83, 0x76797B7E, 0x71727374, 0x73737374, 0x87817A74, 0x87878583, 0x86858586,
    0x86858584, 0x87878787, 0x85868584, 0x80808182, 0x80818181, 0x81818180, 0x83828282, 0x85858484,
    0x7E7D7E7E, 0x8382817F, 0x767C7E7F, 0x74716F71, 0x7A777574, 0x7074797A, 0x6E6E6D6B, 0x6B6D6E6E,
    0x74737271, 0x77777675, 0x7F7F7C7A, 0x7576797C, 0x73747475, 0x76757474, 0x857E7976, 0x747A8387,
    0x615D626A, 0x7A7B776D, 0x68696C6E, 0x726F6B68, 0x77747372, 0x7C7B7A79, 0x73747678, 0x78767473,
    0x807E7D7C, 0x84848381, 0x84868787, 0x7C7D8081, 0x81818181, 0x7E7F8081, 0x807B7A7B, 0x8D8D8C87,
    0x8A8C8D8E, 0x8B8B8989, 0x7F82878A, 0x7274797B, 0x5D646B6F, 0x5D5C5A5A, 0x65625F5E, 0x74716E68,
    0x7C7C756D, 0x6E6C6E74, 0x7B7A7774, 0x74757679, 0x7B77737A, 0x73716E72, 0x81807B78, 0x7E7F8081,
    0x8B847E7B, 0x83878C8E, 0x60616E7B, 0x797A756A, 0x62636E79, 0x686B6C67, 0x76766C60, 0x6865656D,
    0x70686565, 0x7C7F807A, 0x7D7A7A7A, 0x7B7D7F7F, 0x7C767578, 0x81878985, 0x76757D85, 0x8E8D8980,
    0x85878D92, 0x85878786, 0x5F6A767D, 0x6E685F5B, 0x7C746E6D, 0x737A8283, 0x5F636B72, 0x65656360,
    0x746B6767, 0x8386857F, 0x81868481, 0x635F6371, 0x70686769, 0x8083847C, 0x7C7F8182, 0x7575777A,
    0x72727170, 0x6B6D6F71, 0x767B766A, 0x74787673, 0x706F6E6E, 0x807E7A74, 0x85838383, 0x8D8D8B87,
    0x81878D93, 0x7A747279, 0x82828181, 0x7C7D8081, 0x7C7C8185, 0x7D7F817F, 0x686F8292, 0x7F7E786E,
    0x87888581, 0x72757A82, 0x74787773, 0x70767975, 0x7E7B7976, 0x87858180, 0x6B687380, 0x6B6E7271,
    0x68676768, 0x7E7A746D, 0x87888784, 0x7D7D7F83, 0x7A7A7B7B, 0x83817F7C, 0x807B7D83, 0x7C7E8183,
    0x8B817B7A, 0x6371838D, 0x6E6D6C6C, 0x7271706E, 0x6E737372, 0x62636669, 0x756C625D, 0x8D89847D,
    0x7B808487, 0x7C7A7979, 0x75797A7A, 0x93887B74, 0x81858D92, 0x8482817F, 0x7A75787C, 0x81878984,
    0x6F797D7D, 0x63605E63, 0x817C746E, 0x8A878583, 0x8785807B, 0x86858687, 0x7271757B, 0x706F7072,
    0x75726F6D, 0x7A7A7978, 0x767A7C7D, 0x62656B71, 0x69666463, 0x807B756F, 0x847A7D84, 0x7E8A9491,
    0x70717475, 0x77767472, 0x6D707477, 0x68696A6B, 0x63686C6E, 0x56575A5E, 0x59585858, 0x5B5B5A5A,
    0x72706E6D, 0x6E6F7172, 0x6C6C6E6F, 0x696B6D6D, 0x716B645F, 0x8A847C76, 0x666F7F8B, 0x5F626263,
    0x605E5F61, 0x5C5E6161, 0x645E5B59, 0x67696B69, 0x5251575D, 0x55595B58, 0x55504F50, 0x625D5A58,
    0x676F7270, 0x71675D5D, 0x5B565C66, 0x69696863, 0x686A6E70, 0x8B82756C, 0xA09E9B9A, 0x8A929BA0,
    0x81817D7A, 0x7C7C7D80, 0x7E7F7C7A, 0x82807C7C, 0x828C8A8B, 0x716E676D, 0x85847D76, 0x74757A80,
    0x76736F6E, 0x6A6E7477, 0x6E706C67, 0x6B676468, 0x65646362, 0x68676665, 0x67696A69, 0x64626263,
    0x62626262, 0x63636262, 0x644F5468, 0x2A10827B, 0x2D211F20, 0x5350443E, 0x5A58544F, 0x50585E5C,
    0x6B615447, 0xEA104450, 0xEBE9EBE1, 0x575F79EB, 0xE5D9106C, 0xE2EBE5E4, 0x5063746E, 0x66534D4F,
    0x5B626666, 0x56585756, 0xEBEB1A69, 0xE3EBEBD8, 0x54585D61, 0x59565453, 0x30165A5A, 0x10101B21,
    0x492D1F1C, 0xE2E0DB26, 0x59E6E9EA, 0x43584850, 0x4E51504E, 0x1C443F3B, 0xEBD9E9E8, 0x1531C7E7,
    0x6758683B, 0x4C5E694B, 0x62595C64, 0x626C4C45, 0x56494A50, 0x46576865, 0x4F525659, 0x5755504E,
    0x52535354, 0x52525252, 0x50505151, 0x4E4E4E4F, 0x5C5C3F39, 0x10301252, 0x12101E10, 0x15392A30,
    0xE8EBE2EB, 0x4A57E5EB, 0x53535353, 0x53535353, 0xE010544E, 0xEAE3EBEA, 0x5A533CEB, 0x3E464447,
    0x4E4F4B47, 0x4D4C4B4C, 0xD6184E4F, 0xE8E5E6DC, 0x47304AE4, 0x4D524C4A, 0x50515252, 0x51505050,
    0x4F4E4D4D, 0x50505050, 0x35114B4F, 0x1019251F, 0x637F4C48, 0x434E513C, 0x544F463F, 0x4D4E5053,
    0xDD256E3D, 0xDEEBEBEB, 0x584F47EA, 0xE6D02543, 0xE2EBEBB9, 0x323C3126, 0x4C284458, 0x30333C5F,
    0x4949243C, 0x3A573E4A, 0x464F6056, 0x58373D4F, 0x49484645, 0x5955504B, 0x51515559, 0x4C505554,
    0xDEE0E842, 0x51E8E6E7, 0x5A514842, 0x4B515A5D, 0x3C34494F, 0x623E4453, 0xD3D9EB1C, 0x3EDFD1DC,
    0x50555F38, 0xEB2F6071, 0xE9E3DAE6, 0x31433F2D, 0x59585647, 0x3A3D4253, 0xEAE71666, 0x87E7E5E8,
    0x5A5F666A, 0x615E5A58, 0xEBD1335E, 0xB2DCE6EB, 0x515E7380, 0x491C4B4A, 0x2A2C1310, 0x3654442C,
    0x50494648, 0x4F565B59, 0x7E989D95, 0xE8103F47, 0xEBE9EBE2, 0x78717AE8, 0x615A6E94, 0xE4E3D624,
    0x2A29ABEB, 0x84784C2C, 0x757B8186, 0x7A787474, 0x5A535B70, 0x896F5C5B, 0x775E6978, 0x15576876,
    0xE1E2EBEB, 0x4F6BA3BB, 0x695C6260, 0x1250565E, 0xEBE8E8EB, 0x102A4DDE, 0x5B5B5B5B, 0x5B5B5B5B,
    0x66595D4F, 0x4E56695B, 0x4E48494B, 0x3D5C4D4A, 0x666C583E, 0x61767564, 0x2F4C5B68, 0x5A553528,
    0x30445953, 0xDFEB183F, 0x59D3E3DE, 0x3E3D4147, 0x3E424547, 0x3334373A, 0x3B3E3833, 0x3E383436,
    0x6E6D6761, 0x8078706E, 0x7A7E8182, 0x73747477, 0x817F7C7A, 0x87878684, 0x86878787, 0x81818284,
    0x7D818181, 0x75747679, 0x87827C77, 0x83848687, 0x7D808284, 0x7475777A, 0x77777675, 0x70727476,
    0x68626268, 0x7D79746E, 0x83828180, 0x86868584, 0x86838383, 0x8D8D8C89, 0x8B89898A, 0x888A8C8C,
    0x82807E7D, 0x87878684, 0x8D8B8886, 0x8A8B8D8D, 0x8C8D8D8C, 0x8787898B, 0x827F8081, 0x9493918A,
    0x86878C92, 0x81868988, 0x74767D83, 0x82817E79, 0x7B81817E, 0x686E7477, 0x63636567, 0x64656665,
    0x7A746E6A, 0x6E747A7D, 0x82817A73, 0x7D7A7A7D, 0x7473767D, 0x6E686971, 0x61626362, 0x68645F5E,
    0x8D867E7A, 0x7C858D91, 0x686E7477, 0x6E6B6867, 0x726F6E6E, 0x77787875, 0x75757677, 0x75767776,
    0x6C696869, 0x7374736F, 0x6E6C6C6C, 0x7B797471, 0x7075797A, 0x6565676B, 0x747C7A6C, 0x7367656D,
    0x81807D7B, 0x656D777F, 0x716C6868, 0x7E7E7B77, 0x6F72777C, 0x77767470, 0x99999590, 0x8F969B9B,
    0x7F79767F, 0x96958A81, 0x8987878B, 0x81878D8D, 0x7E7F7F7D, 0x93928B82, 0xA8A5A2A1, 0xA6A8ABAB,
    0x80858D94, 0xA2998D82, 0x85898F95, 0x7C7A7A81, 0x88828181, 0x93949490, 0x7A7B7A7A, 0x71727478,
    0x807C7976, 0x7A7B7F81, 0x6C6F7478, 0x6063686A, 0x5556595C, 0x56565656, 0x51535454, 0x4D4E4F50,
    0x4B4D4E4E, 0x4848494A, 0x44474847, 0x504A4442, 0x5E5B5857, 0x78736B63, 0x83807E7D, 0x86898A87,
    0x8C8E8B88, 0x968B8185, 0x898C949D, 0x787F878A, 0x7A777878, 0x90938E83, 0xA098908A, 0x949BA3A5,
    0x999A9396, 0x71717385, 0x72707175, 0x7E746E70, 0x767E807F, 0x605D5F69, 0x746F655C, 0x62666C71,
    0x93897166, 0x7C7C7C87, 0x77797A7B, 0x72727374, 0x72737475, 0x85807874, 0x8A888683, 0x87878889,
    0x8C8C8C8C, 0x8D8D8D8C, 0x898A8A89, 0x84848486, 0x82828384, 0x84838282, 0x85858686, 0x82838384,
    0x807F7D7D, 0x85848381, 0x767E8385, 0x74706E6F, 0x7C797574, 0x6D72797C, 0x716E6C69, 0x696C6E71,
    0x7A787574, 0x7C7C7C7B, 0x7D7D7B79, 0x7374767A, 0x70717273, 0x7271706F, 0x78777676, 0x5C656F76,
    0x62616367, 0x74716C66, 0x64636566, 0x716E6A66, 0x74727070, 0x7B7A7876, 0x70727476, 0x76747270,
    0x7B7A7A79, 0x81807E7C, 0x81818181, 0x7D7E8081, 0x7F807F7F, 0x7A7B7D7F, 0x817A7877, 0x8D8E8E89,
    0x898A8A8A, 0x87888889, 0x7B7F8487, 0x70737578, 0x5C62696E, 0x5E5C5958, 0x6D686664, 0x7C7A7671,
    0x7C7F7B76, 0x74717175, 0x76777675, 0x6F6F7174, 0x7E746E76, 0x7C7B777A, 0x86878583, 0x7A7A7D81,
    0x8A857E7A, 0x868B8E8E, 0x6365727E, 0x7778746C, 0x5F616B75, 0x696C6C65, 0x71736E6A, 0x78736E6E,
    0x7E777474, 0x82878986, 0x7E7C7B7B, 0x797B7F80, 0x7A737274, 0x81868884, 0x6D6E7781, 0x89878175,
    0x8D908E8C, 0x82828489, 0x676F797E, 0x6A656060, 0x7A706A68, 0x727A8181, 0x6666686B, 0x68696B69,
    0x74686261, 0x85878781, 0x8C8F8C88, 0x69676D7D, 0x716C6C6E, 0x7A7D7E79, 0x73737474, 0x76757474,
    0x7B7A7776, 0x78797A7B, 0x777A7B78, 0x6F767A77, 0x6C6A6A6B, 0x7674706E, 0x7E7E7A77, 0x86827E7D,
    0x7B7E8287, 0x68686D75, 0x7A7A7A79, 0x6E717478, 0x7A77797A, 0x8182817E, 0x68728391, 0x807A7168,
    0x81858787, 0x6F71757A, 0x838B8476, 0x7276787A, 0x7D7A7674, 0x89878380, 0x736F7884, 0x6E737979,
    0x72696462, 0x9F988C7E, 0x84878787, 0x7B7C7E81, 0x7475787A, 0x76757473, 0x817B7B80, 0x797C8185,
    0x7A777778, 0x67717B7E, 0x6C6B6B6C, 0x71706E6D, 0x6A6E6F71, 0x63626266, 0x6E696461, 0x84807973,
    0x7A7E8285, 0x7A7A7979, 0x7A80817E, 0x90857A76, 0x7A81898F, 0x83817D7A, 0x84818182, 0x8A8B8A87,
    0x717D8384, 0x6C656165, 0x8B867E78, 0x94928E8D, 0x8680848B, 0x7C879290, 0x7D7D8085, 0x7877787C,
    0x7473706E, 0x7A797877, 0x74777979, 0x5E62686E, 0x63605E5E, 0x7B787169, 0x7E777B83, 0x818B918B,
    0x7072777B, 0x78777472, 0x6B6E7477, 0x68696A6A, 0x60666A6D, 0x5052565A, 0x53525151, 0x56555554,
    0x706D6A68, 0x70717271, 0x6D6E6F71, 0x686A6C6D, 0x69686664, 0x7A746E6A, 0x646C7982, 0x5C5E6061,
    0x64626060, 0x63656666, 0x625D5C5C, 0x66696B68, 0x50525C64, 0x55575754, 0x55505051, 0x605C5857,
    0x676D6D6A, 0x6E675F5F, 0x5A545B64, 0x68696863, 0x69696C6D, 0x857E746C, 0x928F8F8F, 0x848A9093,
    0x71757A7E, 0x7F7A736F, 0x8082807B, 0x847F7A7A, 0x86918E8E, 0x6868636E, 0x7F7B726A, 0x7776777B,
    0x78746F6D, 0x6C71777A, 0x6E74736F, 0x625F5E65, 0x62656461, 0x66615C5D, 0x6D6E6862, 0x63606065,
    0x68686867, 0x69696968, 0x585F5652, 0x76466A54, 0x565A6671, 0x7372715F, 0x645F5449, 0x52585F63,
    0x64444043, 0xEB115C68, 0xE2DCEBE2, 0x665766D8, 0xEBEB1369, 0xE5EBE9E8, 0x50545543, 0x5350585A,
    0x5E605D58, 0x5C5D5D5C, 0xE0E8106E, 0xEBE2EBDD, 0x53596064, 0x53515050, 0x4A3E604D, 0x6C66624F,
    0x594D4F4B, 0xE6EBEA1D, 0x58E7EBEB, 0x43594950, 0x4E4F4F4E, 0x1344443F, 0xE6EBEAEB, 0x6A68E8E3,
    0x2C105058, 0x12182512, 0x15101918, 0x52581C1A, 0x4D565550, 0x6B594744, 0x484A5157, 0x4D4D4C4A,
    0x50505152, 0x50504F4F, 0x50505151, 0x53525150, 0x56565660, 0x64694B5B, 0x5F656E5D, 0x374B484A,
    0xE8EBE2EB, 0x4A57E5EB, 0x54545454, 0x53535353, 0xEB2D6C44, 0xEBE5EBE2, 0x304547DA, 0x48394743
};
#        endif

#        define PATCH_OFFSET_0 29
#        define PATCH_OFFSET_1 31
#        define PATCH_OFFSET_2 83
#        define PATCH_OFFSET_3 11
#        define PATCH_OFFSET_4 17
#        define PATCH_OFFSET_5 23
#        define PATCH_OFFSET_6 33

static gctUINT32 ppuCmd0_0xA0[] = {
    0x0801028A,
    0x00000011,
    0x08010E13,
    0x00000002,
    0x08010E4E,
    0x00400000,
    0x08010E4F,
    0x00000000,
    0x08010E50,
    0x00000000,
    0x10000000,
    0x00000000
};

static gctUINT32 ppuCmd1_0xA0[] = {
    0x08010E03,
    0x00000C23,
    0x08010E03,
    0x00000C23,
    0x08010594,
    0x00000001,
    0x10000000,
    0x00000000
};

static gctUINT32 ppuCmd2_0xA0[] = {
    0x08015580,
    0x00000002,
    0x08010E02,
    0x00000701,
    0x48000000,
    0x00000701,
    0x0804D800,
    0x7388C280,
    0x00000080,
    0x00800080,
    0x444051F0,
    0x18000000,
    0x0804D804,
    0x00004000,
    0x00000000,
    0x10DA10B0,
    0x00000000,
    0x18000000,
    0x0804D808,
    0x738902C0,
    0x00000040,
    0x00400040,
    0x444051F0,
    0x18000000,
    0x0804D80C,
    0x00001000,
    0x00000000,
    0x10DA10B0,
    0x00000000,
    0x18000000,
    0x0804D810,
    0x73891300,
    0x00000040,
    0x00400040,
    0x444051F0,
    0x18000000,
    0x0804D814,
    0x00001000,
    0x00000000,
    0x10DA10B0,
    0x00000000,
    0x18000000,
    0x0801D818,
    0x7388BF40,
    0x0801D819,
    0x7388BF80,
    0x0804D81C,
    0x73892340,
    0x00000080,
    0x00400040,
    0x44405071,
    0x18000000,
    0x0804D820,
    0x00002000,
    0x00000003,
    0x10DD10B0,
    0x00000000,
    0x18000000,
    0x0804D824,
    0x11111111,
    0x00000000,
    0x03020100,
    0x07060504,
    0x18000000,
    0x0804D828,
    0x22222222,
    0x00000000,
    0x00000000,
    0x00000400,
    0x18000000,
    0x0804D82C,
    0x00000001,
    0x00000001,
    0x00000001,
    0x00000001,
    0x18000000,
    0x0804D830,
    0x00000001,
    0x00000001,
    0x00000001,
    0x00000001,
    0x18000000,
    0x080102A4,
    0x00000000,
    0x08010420,
    0x00000000,
    0x08010427,
    0x00000000,
    0x08010416,
    0x00000000,
    0x08010409,
    0x00000000,
    0x0801021F,
    0x00000000,
    0x08010424,
    0x00000010,
    0x0801040A,
    0x7388C000,
    0x08015580,
    0x00000002,
    0x0801021A,
    0x00000001,
    0x08010425,
    0x0000000F,
    0x08030402,
    0x00001F01,
    0x00000005,
    0x00000F00,
    0x08010228,
    0x00000000,
    0x0801028C,
    0x00000100,
    0x08010E07,
    0x00000000,
    0x0801040C,
    0x00000000,
    0x0801020C,
    0x0F3F0000,
    0x08010201,
    0x00000001,
    0x080102AA,
    0x00000000,
    0x08010E22,
    0x007F0000,
    0x08010412,
    0x00000000,
    0x08010E27,
    0xFFFFFFFF,
    0x08010240,
    0x03000002,
    0x08010249,
    0x00000000,
    0x08010247,
    0x00000002,
    0x0801024B,
    0x00000000,
    0x0801024D,
    0x00000000,
    0x0801024F,
    0x00000000,
    0x08010256,
    0x00000008,
    0x08010257,
    0x00000001,
    0x08010258,
    0x00000000,
    0x08060250,
    0x00000000,
    0x0000003F,
    0xFFFFFFFF,
    0x00000007,
    0x00000000,
    0x000003FF,
    0x18000000,
    0x08010248,
    0xBADABEEB,
    0x08010E03,
    0x00000024,
    0x08010E02,
    0x00000701,
    0x48000000,
    0x00000701,
    0x08010E03,
    0x00000C23,
    0x08010E03,
    0x00000C23,
    0x08010594,
    0x00000001,
    0x10000000,
    0x00000000
};

static gctUINT32 ppuCmd3_0xA0[] = {
    0x08010E03,
    0x00000C23,
    0x08010E03,
    0x00000C23,
    0x08010594,
    0x00000001,
    0x10000000,
    0x00000000
};

static gctUINT32 ppuMem0_0xA0[] = {
    0x7E83898D,
    0x807E7B7B,
    0x84817F7F,
    0x5C687A83,
    0x7E766C66,
    0x616A777F,
    0x5C5B5856,
    0x625F5C5C,
    0x52515A62,
    0x52585C58,
    0x60585554,
    0x70716F69,
    0x71696A6E,
    0x787F827D,
    0x72747D87,
    0x6D6D6E71,
    0x877F736A,
    0x6A737F87,
    0x6B686868,
    0x7A78746E,
    0x767A7B7C,
    0x67696E72,
    0x716E6E6E,
    0x686E7274,
    0x7A75706C,
    0x7D7D7D7C,
    0x7477797A,
    0x6E6E6E70,
    0x72716F6E,
    0x74747473,
    0x75747474,
    0x75757575,
    0x72747475,
    0x70707071,
    0x6E6A6868,
    0x76767572,
    0x78757678,
    0x7D7F7F7C,
    0x81807D7A,
    0x686E787F,
    0x625E6062,
    0x67696B68,
    0x62625C55,
    0x5352555C,
    0x5C5C5B59,
    0x5052565A,
    0x56504F50,
    0x68625E5C,
    0x7B7E7468,
    0x6260626E,
    0x59565B62,
    0x726B645E,
    0x7D818283,
    0x76757679,
    0x72747472,
    0x726F6E6E,
    0x73727170,
    0x87817A75,
    0x7C74757A,
    0x747F8786,
    0x706A686E,
    0x747B7872,
    0x78747475,
    0x6F747A7B,
    0x706D6C6C,
    0x72737473,
    0x74797874,
    0x66626269,
    0x6A6A6B6B,
    0x6D6C6A6A,
    0x807B7168,
    0x5C636F7A,
    0x62636566,
    0x65646362,
    0x61516277,
    0xE0226E5C,
    0xE5EAE6E2,
    0x48627ACA,
    0x4C514837,
    0x4E4E4A46,
    0x78575350,
    0xE610687C,
    0xDFE2DBE0,
    0x504E58EB,
    0x1026109F,
    0xEBE6BD38,
    0x7483AEEB,
    0x5E5A5561,
    0x716D645C,
    0x1834566C,
    0xE8EBE2E6,
    0x181531D3,
    0x5B5D6162,
    0x605D5C5A,
    0xD1154469,
    0xEBE8E8EB,
    0xCDEBDCEB,
    0xEBDDEBDC,
    0x5DE6E8EB,
    0x47594A56,
    0x5C5C5550,
    0x5D71564A,
    0xEB10616A,
    0xE3EBD5EB,
    0x3E524456,
    0x64645C56,
    0x8C716370,
    0x2E5C4E55,
    0xE7E8E9EB,
    0x6788B7D9,
    0x50535B60,
    0x605C5651,
    0x5C5D5E5F,
    0x52545659,
    0x57565554,
    0x4B4E5256,
    0x4A705252,
    0xEBD8173F,
    0xCDDFEBD4,
    0xE5EBDCEB,
    0xE8EBE2EB,
    0x4A57E5EB,
    0x4E4C4B4B,
    0x5251504F,
    0x3B105F60,
    0xEBC93914,
    0x5DDFCBEB,
    0x4B58522C,
    0x6259504A,
    0x314A6369,
    0xEBCECA29,
    0x1043E4D6,
    0x4F483E5C,
    0x685E5D3A,
    0x565B5C5C,
    0x4E4D4D50,
    0x50504E4E,
    0x4D4E5050,
    0xDC193F49,
    0xEBE3EAE2,
    0x6F7457C9,
    0x50465B4B,
    0x5860686E,
    0x53535254,
    0xE715402F,
    0xE0EBEBE9,
    0x385662DF,
    0x29403755,
    0xDDEBEB16,
    0x5F3FE7EB,
    0x553D4245,
    0x2A4D4853,
    0x446F233E,
    0xD9C93E3B,
    0xC5EBE5E8,
    0x434F4C71,
    0x4547494A,
    0x5D564E47,
    0x504F5256,
    0x4E515554,
    0x56105012,
    0xC4EBE8DB,
    0x314B87BB,
    0x565A523D,
    0x524A5648,
    0x8725235A,
    0xCBEBE6EB,
    0x23331A53,
    0x5B51394C,
    0xE8103F5C,
    0xD9E2EBE5,
    0x504C293C,
    0x4A544B40,
    0x513E3D40,
    0xE9E11948,
    0x5CE9DEEB,
    0x615D5957,
    0x67676664,
    0x4D84534D,
    0x38584348,
    0x5E3E595A,
    0xDE16627A,
    0xE1EBD4E9,
    0x52607CD6,
    0x5D63686C,
    0x5A585758,
    0x6D5F6552,
    0xE619767C,
    0xEBEBE6E3,
    0x7E626FDE,
    0x8E938083,
    0x31315410,
    0xE8EAEBE8,
    0x84875FD3,
    0x686C7174,
    0x6F6D6967,
    0x5C5A5E5E,
    0x60636A68,
    0x76666462,
    0x74876868,
    0x857A627F,
    0x836B5C93,
    0x695F6462,
    0x124D515B,
    0xDB28121D,
    0xE4E3E9E6,
    0x4A4A4A4A,
    0x4A4A4A4A,
    0x8B626B68,
    0x5458807A,
    0x7878736F,
    0x145D526A,
    0xD8EBEAB7,
    0x648DCADE,
    0x4A544A61,
    0x5D56474F,
    0x3B476A43,
    0xE8EB123C,
    0x4DE2EBE6,
    0x55536059,
    0x55555454,
    0x59585756,
    0x45555C5C,
    0x3B322D34,
    0x8078726F,
    0x81858786,
    0x7F808080,
    0x8181807F,
    0x7C7D7E7E,
    0x7C7C7C7C,
    0x7A7A7A7B,
    0x7D7C7A7A,
    0x83878787,
    0x7A7A7B7F,
    0x8B867E79,
    0x8C8C8D8D,
    0x84868789,
    0x87868484,
    0x86878989,
    0x7A7B7F82,
    0x696D767F,
    0x756E6968,
    0x7A777574,
    0x80807E7C,
    0x817F8081,
    0x8B8A8884,
    0x7A7E8286,
    0x71737578,
    0x807D7B7A,
    0x88878582,
    0x8F8D8887,
    0x888B8D8F,
    0x87878889,
    0x8E8C8987,
    0x74777E85,
    0x89878179,
    0x938D8B8B,
    0x9A9B9B99,
    0x787E858A,
    0x74747474,
    0x6F737472,
    0x6D6F706E,
    0x67656668,
    0x74736F6A,
    0x686A6E72,
    0x65666767,
    0x74736D66,
    0x817A7474,
    0x707A7E7C,
    0x7B746C69,
    0x73737475,
    0x74747474,
    0x7B787676,
    0x74797E7F,
    0x75727171,
    0x73757878,
    0x76747474,
    0x78797A79,
    0x6F747574,
    0x7C756E6C,
    0x7B787675,
    0x8181817F,
    0x7A7C7E80,
    0x79787879,
    0x73777A7A,
    0x69696A6E,
    0x93948D80,
    0x776E778B,
    0x85878582,
    0x86838182,
    0x85858687,
    0x80828485,
    0x70777A7A,
    0x756F696A,
    0xA3A29F9B,
    0x989EA4A4,
    0x77717382,
    0x90897D77,
    0x7E858B8D,
    0x817E7A79,
    0x94948F88,
    0x747E8890,
    0x7A737274,
    0x9C999387,
    0x90929496,
    0x95939290,
    0x81848C93,
    0x8B857F7F,
    0x8D91918E,
    0x89858285,
    0x8B8D9093,
    0x8B8C8D8C,
    0x81828384,
    0x86858382,
    0x85818184,
    0x79808788,
    0x60646B6F,
    0x5A5B5C5D,
    0x585A5B5B,
    0x55555657,
    0x51525253,
    0x50505051,
    0x484C5051,
    0x5B544B47,
    0x78756A5F,
    0x8D827876,
    0x817C8188,
    0x787A8083,
    0x7B787A80,
    0x8D878280,
    0x8E93938F,
    0x82878B8C,
    0x77777D81,
    0x8A8E8C81,
    0x978A8688,
    0x96999F9F,
    0x9593939D,
    0x7A7C7E88,
    0x6D646269,
    0x7D6F686D,
    0x858A8781,
    0x6F757B80,
    0x76736D6B,
    0x61606671,
    0x98887571,
    0x92949395,
    0x75797E81,
    0x70727474,
    0x77777675,
    0x817E7A78,
    0x7A7E8182,
    0x79777576,
    0x807E7D7C,
    0x80818181,
    0x85858280,
    0x81818284,
    0x85848382,
    0x82838485,
    0x83828181,
    0x87868584,
    0x777A7F81,
    0x76757474,
    0x74737374,
    0x76777775,
    0x74747576,
    0x77787876,
    0x71727474,
    0x74747271,
    0x74747474,
    0x76767574,
    0x7F7F7B79,
    0x78797A7D,
    0x76757474,
    0x77777777,
    0x7A7B7B7A,
    0x7B7A7A7A,
    0x79706E71,
    0x78808683,
    0x6F727579,
    0x7975726F,
    0x7C7A7877,
    0x80807F7E,
    0x76787A7C,
    0x7C7A7876,
    0x83817F7F,
    0x7D818485,
    0x7A777574,
    0x7F7E7D7B,
    0x81828383,
    0x81818181,
    0x777B8082,
    0x837F7976,
    0x8F8E8D8C,
    0x8B8C8D8F,
    0x82868A8D,
    0x73767A7F,
    0x65696E71,
    0x5F5F6062,
    0x6863615F,
    0x73716E6B,
    0x69717474,
    0x5C5A5A60,
    0x7E7A716A,
    0x7B7A7B7D,
    0x7277767C,
    0x63625C62,
    0x6E6A6662,
    0x7372706F,
    0x887F7979,
    0x8686898D,
    0x6467737E,
    0x7979746B,
    0x67666C74,
    0x666C706E,
    0x75796857,
    0x5B545462,
    0x5F5C5C5D,
    0x74716B64,
    0x7C7A7877,
    0x777A7D7E,
    0x807A7A7E,
    0x868A8D87,
    0x83818386,
    0x8B8B8986,
    0x76777C81,
    0x7C7D7C79,
    0x7A7F817F,
    0x777B7C7A,
    0x7A747172,
    0x7B808481,
    0x71747577,
    0x7C787471,
    0x7A7B7D7F,
    0x7F7E7B7A,
    0x696B7178,
    0x69666568,
    0x898B7C6C,
    0x93867A7E,
    0x84888B8C,
    0x76787B80,
    0x6E737679,
    0x61626568,
    0x73796F5E,
    0x787B7770,
    0x7E7F7D79,
    0x85878680,
    0x8C888789,
    0x898D908F,
    0x8B8F8D8C,
    0x827A7780,
    0x8F8E8E8E,
    0x9090908F,
    0x84848687,
    0x84858585,
    0x81797E87,
    0x7585928F,
    0x7F786C63,
    0x7F7F7F81,
    0x71747675,
    0x71737371,
    0x7474716E,
    0x7B797775,
    0x6868717A,
    0x66666868,
    0x69666362,
    0x7E7B756F,
    0x8C8B8580,
    0x86858689,
    0x8B898887,
    0x8C8C8C8C,
    0x7A7A818A,
    0x7F7E7E7D,
    0x91877D7A,
    0x6E758391,
    0x78797877,
    0x6E707476,
    0x6E747673,
    0x696C6C6B,
    0x8178706C,
    0x8D8D8D88,
    0x7D82878B,
    0x7F7C7A7A,
    0x918D8887,
    0x747D8990,
    0x817F7A78,
    0x686F7980,
    0x65626263,
    0x6C6E6E6A,
    0x5B5B6065,
    0x575C5E5D,
    0x635C5653,
    0x7474716B,
    0x76757473,
    0x88837C78,
    0x6C6E747E,
    0x6A696B6D,
    0x817B746E,
    0x6B717A80,
    0x6F6F6F70,
    0x74737170,
    0x74747575,
    0x6F707173,
    0x79726F70,
    0x71798080,
    0x76746F6D,
    0x7A7A7A79,
    0x72747778,
    0x6D6C6D6E,
    0x6E6D6C6B,
    0x6E6E6E6E,
    0x6E6E6E6E,
    0x6F6F6E6E,
    0x73747475,
    0x6E6F7072,
    0x6D6A6A6A,
    0x73747370,
    0x7A757271,
    0x8383827F,
    0x77787A7D,
    0x686D7275,
    0x5F5E6164,
    0x5B5E6262,
    0x66635D57,
    0x5C5C5E62,
    0x5B595858,
    0x5155595C,
    0x56504E50,
    0x67625D5B,
    0x747A746D,
    0x68626168,
    0x5B575B62,
    0x746E6862,
    0x75797C7E,
    0x7F7A7674,
    0x75797A7C,
    0x74737272,
    0x827E7874,
    0x82828383,
    0x7E78787A,
    0x7A818785,
    0x73727075,
    0x767A746F,
    0x7A787675,
    0x70747A7C,
    0x73706E6E,
    0x70727475,
    0x7074706B,
    0x6C686669,
    0x696A6C6E,
    0x6467696A,
    0x74706C69,
    0x62666E73,
    0x5F606162,
    0x6261605F,
    0x695D6671,
    0xC7216E61,
    0xEAEBE6DF,
    0x35567ACD,
    0x50565147,
    0x4D51514D,
    0x7367574A,
    0xE912505B,
    0xE8EBE8EB,
    0x755850EB,
    0xE0D12B6C,
    0xE4EBEBD6,
    0x5637252C,
    0x52535860,
    0x68676462,
    0x4C5A666A,
    0xD6A81F1C,
    0xEAE2C5EB,
    0x595B5E61,
    0x605D5B58,
    0xD7356073,
    0xE8E5EBEB,
    0x2BCAEBE1,
    0xCEEBCF1F,
    0x5CE5E8EB,
    0x45584854,
    0x5759534F,
    0x4A624D44,
    0xE52D6867,
    0xE0DCDCEB,
    0x5559505C,
    0x775D4F56,
    0x6351767D,
    0x235E5679,
    0x23201310,
    0x6E553726,
    0x484D5256,
    0x55504A47,
    0x57595A5A,
    0x51525456,
    0x54545352,
    0x4A4C5052,
    0x556B4A47,
    0xE6DC3356,
    0xEBEBE5EA,
    0x1922EBCA,
    0xE8EBE2EB,
    0x4A57E5EB,
    0x504F4E4D,
    0x52525150,
    0xD03C5F54,
    0xE1EBCAD2,
    0x443116E0,
    0x3946403B,
    0x4D4C4E4E,
    0x5D625F56,
    0xDF251610,
    0xE1D5EBE5,
    0x4B505CB5,
    0x4F4D4B41,
    0x53555554,
    0x504F4E50,
    0x504F4E4D,
    0x4E4F5050,
    0xEB254868,
    0xEAD1DFEB,
    0x5A444DEB,
    0x472F4B4E,
    0x54585958,
    0x514F4D4F,
    0xEB1E5555,
    0xE0E3D0DE,
    0x444F5CEB,
    0x2E513B5D,
    0xC9D0E627,
    0x5442E3E7,
    0x5151543D,
    0x4A5E4442,
    0x2B50453D,
    0x1E16102A,
    0x351E1018,
    0x48565444,
    0x44454849,
    0x4E4A4543,
    0x51505357,
    0x50545656,
    0xE0E8EA18,
    0x2EC8E8EB,
    0x69614A36,
    0x53525662,
    0x4D565B54,
    0x2B3D4E50,
    0xEBE4BC42,
    0x5EC3C1D7,
    0x605D4338,
    0xEB153D5D,
    0xE8E8EBE2,
    0x4B4C2F38,
    0x5650444D,
    0x525B5750,
    0xE0E83052,
    0x55E4EBE5,
    0x5A565250,
    0x5E5E5E5C,
    0x4B6B415C,
    0x5852434A,
    0x52395056,
    0xEB326068,
    0xEBEADCE8,
    0x683A6CEB,
    0x585A5C5C,
    0x56565657,
    0x6A5C524C,
    0xCF216E62,
    0xEBEBE9EA,
    0x816E7EE8,
    0x7C69637A,
    0xEBD7C72D,
    0xEBE3E0E9,
    0x7C8768E9,
    0x6E747A80,
    0x76736E6C,
    0x314F7280,
    0x937B5B3A,
    0x7C616168,
    0x54736673,
    0x8C766E6B,
    0x545D7887,
    0x665D625F,
    0x10484A55,
    0xE9C6EBEB,
    0xD6EBE7D5,
    0x69696969,
    0x69696969,
    0x6B6E686A,
    0x725A4D5D,
    0x67656568,
    0x2C695661,
    0x19181110,
    0x7F644125,
    0x63626367,
    0x50564C59,
    0x5348624B,
    0xEBDD1348,
    0x6DDED8E2,
    0x4E444F64,
    0x4E505152,
    0x4A4A4B4C,
    0x434E514F,
    0x38312E35,
    0x7D7A7571,
    0x8482807F,
    0x7C7E7F80,
    0x7B7B7B7C,
    0x807F7E7D,
    0x83828181,
    0x81818182,
    0x81818181,
    0x7F838585,
    0x7474767A,
    0x89837B76,
    0x8C8C8C8C,
    0x8386888A,
    0x81818181,
    0x81828282,
    0x75787B7F,
    0x66676E78,
    0x76716C68,
    0x74747475,
    0x7F7C7A77,
    0x7E7C7C7D,
    0x88878682,
    0x8D8D8D8D,
    0x8083888B,
    0x817D7A7A,
    0x87878683,
    0x8F8D8A87,
    0x878A8D8F,
    0x88898A8B,
    0x8A898988,
    0x79797E83,
    0x8E8C877F,
    0x93918E8C,
    0x98979594,
    0x7D82898E,
    0x7D7D7C7B,
    0x69717778,
    0x65676765,
    0x62626264,
    0x69696865,
    0x6F6D6B6A,
    0x686B6F70,
    0x7D7A736B,
    0x85807A7A,
    0x73797C80,
    0x746D686C,
    0x6D6C6A69,
    0x706E6E6D,
    0x7A777474,
    0x71767C7D,
    0x6D6C6D6E,
    0x6F70706E,
    0x706C6A69,
    0x79797874,
    0x767B7A76,
    0x7B746E6F,
    0x76747474,
    0x7A7A7A7A,
    0x76767676,
    0x76767676,
    0x767D8182,
    0x6667696E,
    0x91938B7B,
    0x7A707687,
    0x84878582,
    0x827F7D7F,
    0x7E7C7B7C,
    0x7E808180,
    0x6D73797C,
    0x736E6968,
    0xA7A6A39F,
    0x9BA2A8A9,
    0x7C767987,
    0x938E827C,
    0x81878D93,
    0x87868381,
    0x9093928D,
    0x7079838B,
    0x746E6D6E,
    0x928F897F,
    0x888D9398,
    0x9D978F89,
    0x878C939A,
    0x88838184,
    0x80818180,
    0x8B86817F,
    0x8A8C8E91,
    0x8B8B8C8B,
    0x81818181,
    0x7D7E7F81,
    0x7E7A7A7B,
    0x6F767E81,
    0x5B5E6367,
    0x58595959,
    0x56575758,
    0x55555656,
    0x50515152,
    0x4D4E4F50,
    0x42474B4C,
    0x4E48413E,
    0x6D6A5F54,
    0x9787756D,
    0x7E7A818C,
    0x84878986,
    0x7A75777C,
    0x9C948A82,
    0x969E9F9E,
    0x81858A8F,
    0x79787C80,
    0x91938F83,
    0x9A908C8D,
    0x999DA1A2,
    0x9B999399,
    0x8483828D,
    0x6E696A71,
    0x7D6F686D,
    0x80878781,
    0x696C6F76,
    0x74706A66,
    0x5F60666F,
    0x8C7C6965,
    0x8588878A,
    0x76797D80,
    0x70727474,
    0x75757574,
    0x86817B77,
    0x81848585,
    0x7E7C7C7E,
    0x8281807F,
    0x82828382,
    0x83838180,
    0x7F7F7F81,
    0x81818181,
    0x81818181,
    0x83818181,
    0x87878584,
    0x7A7C7E80,
    0x7D7C7A7A,
    0x76777877,
    0x75747474,
    0x77757575,
    0x74767879,
    0x6F6F6F6F,
    0x6F6F6F6F,
    0x72717070,
    0x74747473,
    0x80807C7A,
    0x78797A7D,
    0x75757575,
    0x78777675,
    0x837F7B7A,
    0x87888987,
    0x6962676E,
    0x7B818178,
    0x6C6E7274,
    0x74726E6C,
    0x7A777574,
    0x7E7D7D7B,
    0x7476797A,
    0x7A797674,
    0x83807E7E,
    0x85878787,
    0x81818282,
    0x7C7D7F80,
    0x81828282,
    0x81818181,
    0x7C7B7D7F,
    0x89878480,
    0x8C8D8E8F,
    0x8D8C8C8B,
    0x8185898D,
    0x74767A7E,
    0x61676D70,
    0x5E5D5C5D,
    0x625E5C5B,
    0x6E6C6865,
    0x7577726B,
    0x6463666E,
    0x7D7A746E,
    0x79797A7C,
    0x7576747A,
    0x6A696468,
    0x78746E6A,
    0x7B7A7A7A,
    0x8C837E7C,
    0x84868B8E,
    0x5F616E7A,
    0x78787468,
    0x63646E76,
    0x64696C68,
    0x7C7A6855,
    0x5A585E6E,
    0x645D5C5C,
    0x7675736C,
    0x7C7A7877,
    0x7A7D7F7F,
    0x7B747477,
    0x83878A85,
    0x807E8287,
    0x8F8F8D87,
    0x7F7E8388,
    0x81858784,
    0x68727A7E,
    0x73716B66,
    0x7C747170,
    0x767C8382,
    0x676A6F73,
    0x6B6A6867,
    0x76727273,
    0x8181817C,
    0x7176797A,
    0x625E5F68,
    0x7D77706C,
    0x8D8A8681,
    0x84888B8D,
    0x77797C80,
    0x6E707273,
    0x6466686B,
    0x747A705F,
    0x7778746E,
    0x79787774,
    0x8686827C,
    0x8C88898C,
    0x92949592,
    0x8E949697,
    0x817B7A83,
    0x8A888787,
    0x8F8E8D8C,
    0x80818487,
    0x7F818181,
    0x72727F8D,
    0x7A81837C,
    0x8480766F,
    0x787A7D82,
    0x69696B6B,
    0x7276766F,
    0x7A787574,
    0x807E7B7A,
    0x6666707C,
    0x68696B6A,
    0x63656869,
    0x6C696764,
    0x89898681,
    0x81818186,
    0x8481807F,
    0x8E8D8A87,
    0x7F7B8188,
    0x80808182,
    0x93887E7A,
    0x67748794,
    0x72716F6E,
    0x73747473,
    0x6F757674,
    0x6164676A,
    0x7C716761,
    0x8F8E8C86,
    0x7B818689,
    0x7D7B7A79,
    0x88878481,
    0x8B8A8988,
    0x8386888B,
    0x767A7E81,
    0x6E686C71,
    0x767C7F79,
    0x666B6E6F,
    0x5E5D5F62,
    0x6F68615C,
    0x7D7B7874,
    0x80827D76,
    0x8F857B7A,
    0x6A6A6F77,
    0x6A69696B,
    0x7975716E,
    0x7174777A,
    0x7477797A,
    0x6A6B6E71,
    0x6F6D6C6C,
    0x7A787572,
    0x8177767A,
    0x7A858E8D,
    0x72717070,
    0x78777574,
    0x6F727577,
    0x6A6A6B6D,
    0x68696A6B,
    0x62636466,
    0x63636262,
    0x64646463,
    0x73747373,
    0x6E6E7072,
    0x6C6B6C6D,
    0x6E6E6F6E,
    0x78716A65,
    0x8B88847F,
    0x6C727C85,
    0x66686A6A,
    0x5D5E6164,
    0x55585C5E,
    0x67625C59,
    0x65666868,
    0x57555658,
    0x54585C5C,
    0x56504E50,
    0x645F5C59,
    0x6C747470,
    0x6E665E61,
    0x5C565C64,
    0x706E6A65,
    0x6D6F7476,
    0x8881766E,
    0x8D8D8F90,
    0x8184888B,
    0x8B867E77,
    0x7D81868A,
    0x7F7B7A7A,
    0x7F818281,
    0x7A7F7D81,
    0x76756D6D,
    0x82817C79,
    0x74767B80
};

static gctUINT32 ppuMem1_0xA0[] = {
    0x00010000
};

static gctUINT32 ppuMem2_0xA0[] = {
    0x00010000
};

static gctUINT32 ppuMem3_0xA0[] = {
    0x38011039,
    0x39200804,
    0xC0A90050,
    0x74000008,
    0x38021039,
    0x39202804,
    0xC0A90050,
    0x74000008,
    0x38031039,
    0x39204804,
    0xC0A90050,
    0x74000008,
    0xB8017005,
    0x002018FC,
    0x01C900C0,
    0x40390098,
    0xB8027005,
    0x002028FC,
    0x01C90140,
    0x40390098,
    0xB8037005,
    0x002038FC,
    0x01C901C0,
    0x40390098,
    0x02001001,
    0x15408804,
    0x40000010,
    0x76FFDFF8,
    0x04041036,
    0x00000804,
    0x4154007A,
    0x00000000,
    0x0400100C,
    0x3FC04804,
    0x40010440,
    0x2000007A,
    0x38000835,
    0x39207804,
    0x41E80050,
    0x00390018,
    0x04041036,
    0x00001804,
    0x4154007A,
    0x00000000,
    0x0400100C,
    0x3FC04804,
    0x40010440,
    0x2000007A,
    0x38000835,
    0x39207804,
    0x41E80050,
    0x00390028,
    0x04041036,
    0x00002804,
    0x4154007A,
    0x00000000,
    0x0400100C,
    0x3FC04804,
    0x40010440,
    0x2000007A,
    0x38000835,
    0x39207804,
    0x41E80050,
    0x00390038
};

#    endif

#if gcdRESET_USC1

#if gcdRESET_USC_C

#            include "gc_hal_kernel_hardware_func_usc.h"
#        endif

#if !gcdRESET_USC_C
static gctUINT32 nnBuffer0[] = {
    0x8010010c, 0x07383fc2, 0xc1000000, 0x00a01000,
    0x08e00008, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000800, 0x40000000,
    0x00e700ff, 0x00000040, 0x00000000, 0x03ffffff,
    0x00000000, 0x03ffffff, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static gctUINT32 nnBuffer1[] = {
    0x8040010c, 0x07383fd5, 0x01000000, 0x00a00e00,
    0x08700008, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000800, 0x00000000,
    0x00e701fe, 0x00000070, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};

static gctUINT32 nnBuffer2[] = {
    0x8080010c, 0x07383fd5, 0x01000000, 0x00a01000,
    0x09000008, 0x00000000, 0x00000000, 0x00000000
};

static gctUINT32 nnBuffer3[] = {
    0x8010010e, 0x07383fc2, 0xc1000000, 0x00a01000,
    0x08e00008, 0x00000000, 0x00000000, 0x00000000,
    0x00143000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000800, 0x00000000,
    0x00e700ff, 0x00000040, 0x00000000, 0x03ffffff,
    0x00000000, 0x03ffffff, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000,
    0x00000000, 0x00000000, 0x00000000, 0x00000000
};
#        endif

#        define NN_BUFFER_IDX     0
#        define KERNEL_BUFFER_IDX 1
#        define INPUT_BUFFER_IDX  2
#        define RESULT_BUFFER_IDX 3
#        define SRAM_BUFFER_IDX_C 4

#        define PATCH_KERNEL_OFFSET 5
#        define PATCH_INPUT_OFFSET  6
#        define PATCH_RESULT_OFFSET 7
#    endif

#if gcdRESET_USC2
static gctUINT32 instBuffer[] = {
    0x04021009, 0x00200000, 0x80000000, 0x20000048,
    0x02021009, 0x00200000, 0x80000000, 0x20154048,
    0x07801009, 0x00200000, 0x80000000, 0x20390008,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008,
    0x02021001, 0x2aa02800, 0x80000000, 0x202a8048,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008,
    0x02021001, 0x2aa02800, 0x80000000, 0x202a8048,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008,
    0x02021001, 0x2aa02800, 0x80000000, 0x202a8048,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008,
    0x02021001, 0x2aa02800, 0x80000000, 0x202a8048,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008,
    0x02021001, 0x2aa02800, 0x80000000, 0x202a8048,
    0x07801033, 0x3fe02800, 0x81540140, 0x00390008
};

#        define INST_BUFFER_IDX   0
#        define OUTPUT_BUFFER_IDX 1
#        define SRAM_BUFFER_IDX   2
#    endif
#endif

#define _GC_OBJ_ZONE    gcvZONE_HARDWARE

#define gcmSEMAPHORESTALL(buffer)                                                                       \
    do {                                                                                                \
        /* Arm the PE-FE Semaphore. */                                                                  \
        *(buffer)++ = gcmSETFIELDVALUE(0, AQ_COMMAND_LOAD_STATE_COMMAND, OPCODE, LOAD_STATE) |         \
                           gcmSETFIELD(0, AQ_COMMAND_LOAD_STATE_COMMAND, COUNT, 1) |                  \
                           gcmSETFIELD(0, AQ_COMMAND_LOAD_STATE_COMMAND, ADDRESS, 0x0E02); \
                                                                                                        \
        *(buffer)++ = gcmSETFIELDVALUE(0, AQ_SEMAPHORE, SOURCE, FRONT_END) |                       \
                      gcmSETFIELDVALUE(0, AQ_SEMAPHORE, DESTINATION, PIXEL_ENGINE);                     \
                                                                                                        \
        /* STALL FE until PE is done flushing. */                                                       \
        *(buffer)++ = gcmSETFIELDVALUE(0, STALL_COMMAND, OPCODE, STALL);                                \
                                                                                                        \
        *(buffer)++ = gcmSETFIELDVALUE(0, STALL_STALL, SOURCE, FRONT_END) |                        \
                      gcmSETFIELDVALUE(0, STALL_STALL, DESTINATION, PIXEL_ENGINE);                      \
    } while (0)

#if gcdFLOP_RESET
static gceSTATUS
_FuncRelease(IN OUT gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE                    hardware = gcvNULL;
    gcsFUNCTION_COMMAND_PTR        command  = gcvNULL;
    gcsFUNCTION_EXECUTION_DATA_PTR data     = gcvNULL;
    gctUINT8                       i, j;

    if (!Execution || !Execution->funcCmd)
        return gcvSTATUS_OK;

    hardware = (gckHARDWARE)Execution->hardware;

    for (i = 0; i < Execution->funcCmdCount; i++) {
        command = &Execution->funcCmd[i];
        /*free golden*/
#if gcdFLOP_RESET_DEBUG
        if (command->golden) {
            gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)command->golden));
            command->golden = gcvNULL;
        }
#    endif

        /* Free data buffers. */
        if (command->data) {
            for (j = 0; j < command->dataCount; j++) {
                data = &command->data[j];

                if (data->bufVidMem) {
                    if (data->address) {
                        /* Synchroneous unlock. */
                        gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                            data->bufVidMem, 0, gcvNULL));
                        data->address = 0;
                    }

                    if (data->logical) {
                        gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                               data->bufVidMem, 0,
                                                               gcvFALSE, gcvFALSE));
                        data->logical = gcvNULL;
                    }

                    gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel, data->bufVidMem));
                    data->bufVidMem = gcvNULL;
                }
            }

            gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)command->data));
            command->data      = gcvNULL;
            command->dataCount = 0;
        }

        /* Free command. */
        if (command->funcVidMem) {
            if (command->address) {
                /* Synchroneous unlock. */
                gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                    command->funcVidMem, 0, gcvNULL));
                command->address = 0;
            }

            if (command->logical) {
                gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                       command->funcVidMem, 0,
                                                       gcvFALSE, gcvFALSE));
                command->logical = gcvNULL;
            }

            gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel, command->funcVidMem));
            command->funcVidMem = gcvNULL;
        }
    }

    gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    Execution->funcCmd      = gcvNULL;
    Execution->funcCmdCount = 0;

    return gcvSTATUS_OK;
}
#endif

static gceSTATUS
_FuncExecute(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    return gckHARDWARE_ExecuteFunctions(Execution);
}

#if gcdFLOP_RESET
static gceSTATUS
_FuncExecute_FLOPRESET(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#if gcdENABLE_FLOP_RESET_DEBUG
    gctUINT32 i = 0, j = 0, minus_flag = 0;
#    endif

    gceSTATUS status = gckHARDWARE_ExecuteFunctions(Execution);

#if gcdENABLE_FLOP_RESET_DEBUG && gcdFLOP_RESET_PPU
    minus_flag += 1;
#    endif

#if gcdENABLE_FLOP_RESET_DEBUG
    for (i = 0; i < Execution->funcCmdCount - minus_flag; i++) {
        gcmkPRINT("outSizeBytes is : %d", Execution->funcCmd[i].outSize);
        gcmkPRINT("outAddress is %x", Execution->funcCmd[i].data[2].address);
        for (j = 0; j < Execution->funcCmd[i].outSize; j++) {
            if (((gctUINT8_PTR)(Execution->funcCmd[i].golden))[j] !=
                ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[j]) {
                if (i == 0) {
                    gcmkPRINT("top 2 outputBytes: %x, %x",
                              ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[0],
                              ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[1]);
                    gcmkPRINT("top 2 goldenBytes: %x, %x",
                              ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[0],
                              ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[1]);
                    gcmkPRINT("NN workaround verify failed!");
                    return status;
                } else if (i == 1) {
                    gcmkPRINT("top 2 outputBytes: %x, %x",
                              ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[0],
                              ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[1]);
                    gcmkPRINT("top 2 goldenBytes: %x, %x",
                              ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[0],
                              ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[1]);
                    gcmkPRINT("TP workaround verify failed!");
                    return status;
                }
            }
        }
        if (i == 0) {
            gcmkPRINT("top 2 outputBytes: %x, %x",
                      ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[0],
                      ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[1]);
            gcmkPRINT("top 2 goldenBytes: %x, %x",
                      ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[0],
                      ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[1]);
            gcmkPRINT("NN workaround verify success!");
        } else {
            gcmkPRINT("top 2 outputBytes: %x, %x",
                      ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[0],
                      ((gctUINT8_PTR)(Execution->funcCmd[i].outlogical))[1]);
            gcmkPRINT("top 2 goldenBytes: %x, %x",
                      ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[0],
                      ((gctUINT8_PTR)(Execution->funcCmd[i].golden))[1]);
            gcmkPRINT("TP workaround verify success!");
        }
    }
#    endif

    return status;
}
#endif

static gceSTATUS
_FuncValidate_MMU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (hardware->mmuVersion > 0 &&
        hardware->options.enableMMU &&
        hardware->options.secureMode != gcvSECURE_IN_TA) {
        Execution->valid = gcvTRUE;
    } else {
        Execution->valid = gcvFALSE;
    }

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_MMU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gctUINT8    i;
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (Execution->funcCmd) {
        for (i = 0; i < Execution->funcCmdCount; i++) {
            if (Execution->funcCmd[i].funcVidMem) {
                if (Execution->funcCmd[i].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[i].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[0].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[i].funcVidMem));
                Execution->funcCmd[i].funcVidMem = gcvNULL;
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

static gceSTATUS
_ProgramMMUStates(IN gckHARDWARE Hardware, IN gckMMU Mmu, IN gceMMU_MODE Mode,
                  IN gctPOINTER Logical, IN OUT gctUINT32 *Bytes)
{
    gceSTATUS      status = gcvSTATUS_OK;
    gctUINT32      config, address;
    gctUINT32      extMtlb, extSafeAddress, configEx = 0;
    gctPHYS_ADDR_T physical;
    gctUINT32_PTR  buffer;
    gctBOOL        ace;
    gctUINT32      reserveBytes = 0;
    gctBOOL        config2D;
    gctUINT        i;
    gctUINT        probeSelectCount = 4;

    gcmkHEADER_ARG("Hardware=%p", Hardware);

    /* Verify the arguments. */
    gcmkVERIFY_OBJECT(Hardware, gcvOBJ_HARDWARE);
    gcmkVERIFY_ARGUMENT(Hardware->mmuVersion != 0);

    ace = gckHARDWARE_IsFeatureAvailable(Hardware, gcvFEATURE_ACE);

    switch (Hardware->options.secureMode) {
    case gcvSECURE_IN_NORMAL:
        reserveBytes = 8 + 4 * 4;
        break;
    case gcvSECURE_NONE:
        reserveBytes = 16 + 4 * 4;
        if (ace)
            reserveBytes += 8;
        break;
    case gcvSECURE_IN_TA:
    default:
        gcmkASSERT(gcvFALSE);
        gcmkPRINT("%s(%d): secureMode is wrong", __FUNCTION__, __LINE__);
        break;
    }

    config2D = gckHARDWARE_IsFeatureAvailable(Hardware, gcvFEATURE_PIPE_3D) &&
               gckHARDWARE_IsFeatureAvailable(Hardware, gcvFEATURE_PIPE_2D);

    if (config2D) {
        reserveBytes +=
            /* Pipe Select. */
            4 * 4
            /* Configure MMU States. */
            + 4 * 4
            /* Semaphore stall */
            + 4 * 8;

        if (ace)
            reserveBytes += 8;
    }

    reserveBytes += 8 + 8 * probeSelectCount;

    physical = Mmu->mtlbPhysical;

    config  = (gctUINT32)(physical & 0xFFFFFFFF);
    extMtlb = (gctUINT32)(physical >> 32);

    /* more than 40bit physical address */
    if (extMtlb & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    physical = Mmu->safePagePhysical;

    address        = (gctUINT32)(physical & 0xFFFFFFFF);
    extSafeAddress = (gctUINT32)(physical >> 32);

    if (address & 0x3F)
        gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

    /* more than 40bit physical address */
    if (extSafeAddress & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    if (ace) {
        configEx = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) | (((gctUINT32) ((gctUINT32) (extSafeAddress) & ((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) |
                   ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) | (((gctUINT32) ((gctUINT32) (extMtlb) & ((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16)));
    }

    switch (Mode) {
    case gcvMMU_MODE_1K:
        if (config & 0x3FF)
            gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

        config |= ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)));

        break;

    case gcvMMU_MODE_4K:
        if (config & 0xFFF)
            gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

        config |= ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)));

        break;

    default:
        gcmkONERROR(gcvSTATUS_INVALID_ARGUMENT);
    }

    if (Logical != gcvNULL) {
        buffer = (gctUINT32_PTR)Logical;

        if (Hardware->options.secureMode == gcvSECURE_IN_NORMAL) {
            gcsMMU_TABLE_ARRAY_ENTRY *entry;

            entry = (gcsMMU_TABLE_ARRAY_ENTRY *)Hardware->pagetableArray.logical;

            /* Setup page table array entry. */
            if (Hardware->bigEndian) {
                entry->low  = gcmBSWAP32(config);
                entry->high = gcmBSWAP32(extMtlb);
            } else {
                entry->low  = config;
                entry->high = extMtlb;
            }

            gcmkDUMP(Mmu->os, "#[mmu: page table array]");

            gcmkDUMP(Mmu->os, "@[physical.fill 0x%010llX 0x%08X 0x%08X]",
                     (unsigned long long)Hardware->pagetableArray.address, entry->low, 4);

            gcmkDUMP(Mmu->os, "@[physical.fill 0x%010llX 0x%08X 0x%08X]",
                     (unsigned long long)Hardware->pagetableArray.address + 4, entry->high, 4);

            gcmkONERROR(gckVIDMEM_NODE_CleanCache(Hardware->kernel,
                                                  Hardware->pagetableArray.videoMem,
                                                  0, entry, 8));

            /* Setup command buffer to load index 0 of page table array. */
            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x006B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = (((((gctUINT32) (~0U)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) &((((gctUINT32) (~0U)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))));
        } else {
            gcmkASSERT(Hardware->options.secureMode == gcvSECURE_NONE);

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0061) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = config;

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0060) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = address;

            if (ace) {
                *buffer++ =
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0068) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

                *buffer++ = configEx;
            }
        }

        *buffer++ =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                 ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E12) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                 ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

        *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))) |
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 24:24) - (0 ? 24:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 24:24) - (0 ? 24:24) + 1))))))) << (0 ? 24:24))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 24:24) - (0 ? 24:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 24:24) - (0 ? 24:24) + 1))))))) << (0 ? 24:24))) |
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 19:19) - (0 ? 19:19) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 19:19) - (0 ? 19:19) + 1))))))) << (0 ? 19:19))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 19:19) - (0 ? 19:19) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 19:19) - (0 ? 19:19) + 1))))))) << (0 ? 19:19))) |
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 22:22) - (0 ? 22:22) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:22) - (0 ? 22:22) + 1))))))) << (0 ? 22:22))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 22:22) - (0 ? 22:22) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:22) - (0 ? 22:22) + 1))))))) << (0 ? 22:22)));

        for (i = 0; i < probeSelectCount; i++)
        {
            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E1E) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));


            *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (i) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                   ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 20:16) - (0 ? 20:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 20:16) - (0 ? 20:16) + 1))))))) << (0 ? 20:16))) | (((gctUINT32) (0x0A & ((gctUINT32) ((((1 ? 20:16) - (0 ? 20:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 20:16) - (0 ? 20:16) + 1))))))) << (0 ? 20:16))) |
                   ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:24) - (0 ? 25:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:24) - (0 ? 25:24) + 1))))))) << (0 ? 25:24))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 25:24) - (0 ? 25:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:24) - (0 ? 25:24) + 1))))))) << (0 ? 25:24)));
        }

        do{*(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E02) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x09 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8)));} while(0);
;


        if (config2D) {
            /* LoadState(AQPipeSelect, 1), pipe. */
            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E00) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = 0x1;

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0061) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = config;

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0060) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = address;

            if (ace) {
                *buffer++ =
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0068) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

                *buffer++ = configEx;
            }

            do{*(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E02) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x09 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8)));} while(0);
;


            /* LoadState(AQPipeSelect, 1), pipe. */
            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E00) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = 0x0;

            do{*(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E02) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x09 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))); *(buffer)++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8)));} while(0);
;

        }
    }

    if (Bytes != gcvNULL)
        *Bytes = reserveBytes;

    /* Return the status. */
    gcmkFOOTER_NO();
    return status;

OnError:
    /* Return the status. */
    gcmkFOOTER();
    return status;
}

static gceSTATUS
_ProgramMMUStatesMCFE(IN gckHARDWARE Hardware, IN gckMMU Mmu, IN gceMMU_MODE Mode,
                      IN gctPOINTER Logical, IN OUT gctUINT32 *Bytes)
{
    gceSTATUS      status = gcvSTATUS_OK;
    gctUINT32      config, address;
    gctUINT32      extMtlb, extSafeAddress, configEx = 0;
    gctPHYS_ADDR_T physical;
    gctUINT32_PTR  buffer;
    gctBOOL        ace;
    gctUINT32      reserveBytes = 0;

    gcmkHEADER_ARG("Hardware=%p", Hardware);

    /* Verify the arguments. */
    gcmkVERIFY_OBJECT(Hardware, gcvOBJ_HARDWARE);
    gcmkVERIFY_ARGUMENT(Hardware->mmuVersion != 0);

    ace = gckHARDWARE_IsFeatureAvailable(Hardware, gcvFEATURE_ACE);

    switch (Hardware->options.secureMode) {
    case gcvSECURE_IN_NORMAL:
        reserveBytes = 8;
        reserveBytes += 8;
        break;
    case gcvSECURE_NONE:
        reserveBytes = 16;
        ;
        if (ace) {
            reserveBytes += 8;
            reserveBytes += 8;
        }
        break;
    case gcvSECURE_IN_TA:
    default:
        gcmkASSERT(gcvFALSE);
        gcmkPRINT("%s(%d): secureMode is wrong", __FUNCTION__, __LINE__);
        break;
    }

    physical = Mmu->mtlbPhysical;

    config  = (gctUINT32)(physical & 0xFFFFFFFF);
    extMtlb = (gctUINT32)(physical >> 32);

    /* more than 40bit physical address */
    if (extMtlb & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    physical = Mmu->safePagePhysical;

    address        = (gctUINT32)(physical & 0xFFFFFFFF);
    extSafeAddress = (gctUINT32)(physical >> 32);

    if (address & 0x3F)
        gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

    /* more than 40bit physical address */
    if (extSafeAddress & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    if (ace) {
        configEx = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) | (((gctUINT32) ((gctUINT32) (extSafeAddress) & ((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) |
                   ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) | (((gctUINT32) ((gctUINT32) (extMtlb) & ((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16)));
    }

    switch (Mode) {
    case gcvMMU_MODE_1K:
        if (config & 0x3FF)
            gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

        config |= ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)));

        break;

    case gcvMMU_MODE_4K:
        if (config & 0xFFF)
            gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

        config |= ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)));

        break;

    default:
        gcmkONERROR(gcvSTATUS_INVALID_ARGUMENT);
    }

    if (Logical != gcvNULL) {
        buffer = (gctUINT32_PTR)Logical;

        if (Hardware->options.secureMode == gcvSECURE_IN_NORMAL) {
            gcsMMU_TABLE_ARRAY_ENTRY *entry;

            entry = (gcsMMU_TABLE_ARRAY_ENTRY *)Hardware->pagetableArray.logical;

            /* Setup page table array entry. */
            if (Hardware->bigEndian) {
                entry->low  = gcmBSWAP32(config);
                entry->high = gcmBSWAP32(extMtlb);
            } else {
                entry->low  = config;
                entry->high = extMtlb;
            }

            gcmkDUMP(Mmu->os, "#[mmu: page table array]");

            gcmkDUMP(Mmu->os, "@[physical.fill 0x%010llX 0x%08X 0x%08X]",
                     (unsigned long long)Hardware->pagetableArray.address, entry->low, 4);

            gcmkDUMP(Mmu->os, "@[physical.fill 0x%010llX 0x%08X 0x%08X]",
                     (unsigned long long)Hardware->pagetableArray.address + 4, entry->high, 4);

            gcmkONERROR(gckVIDMEM_NODE_CleanCache(Hardware->kernel,
                                                  Hardware->pagetableArray.videoMem, 0, entry, 8));

            /* Setup command buffer to load index 0 of page table array. */
            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x006B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = (((((gctUINT32) (~0U)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) &((((gctUINT32) (~0U)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 16:16) - (0 ? 16:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 16:16) - (0 ? 16:16) + 1))))))) << (0 ? 16:16))));

            *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x03 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
            *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x03 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
        } else {
            gcmkASSERT(Hardware->options.secureMode == gcvSECURE_NONE);

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0061) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = config;

            *buffer++ =
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0060) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                     ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

            *buffer++ = address;

            if (ace) {
                *buffer++ =
                    ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0068) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                         ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

                *buffer++ = configEx;

                *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x03 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
                *buffer++ = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x03 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
            }
        }
    }

    if (Bytes != gcvNULL)
        *Bytes = reserveBytes;

    /* Return the status. */
    gcmkFOOTER_NO();
    return status;

OnError:
    /* Return the status. */
    gcmkFOOTER();
    return status;
}

static gceSTATUS
_FuncInit_MMU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS      status;
    gctUINT32      mmuBytes = 0;
    gctUINT32      tailBytes;
    gctUINT32      flags = gcvALLOC_FLAG_CONTIGUOUS;
    gceMMU_MODE    mode;
    gcePOOL        pool;
    gctPHYS_ADDR_T physical;
    gckHARDWARE    hardware = (gckHARDWARE)Execution->hardware;
    gckMMU         mmu      = hardware->kernel->mmu;
    gctPOINTER     pointer  = gcvNULL;
    gctUINT64      data     = 0;

    if (mmu->initMode == gcvMMU_INIT_FROM_REG)
        return gcvSTATUS_OK;

#if gcdENABLE_MMU_1KMODE
    mode = gcvMMU_MODE_1K;
#else
    mode = gcvMMU_MODE_4K;
#endif

    if (hardware->largeVA)
        mode = gcvMMU_MODE_4K;

    if (!gckHARDWARE_IsFeatureAvailable(hardware,
                                        gcvFEATURE_MMU_PAGE_DESCRIPTOR)) {
#ifdef __linux__
#if defined(CONFIG_ZONE_DMA32) || defined(CONFIG_ZONE_DMA)
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 37)
    flags |= gcvALLOC_FLAG_4GB_ADDR | gcvALLOC_FLAG_4K_PAGES;
#endif
#endif
#else
    flags |= gcvALLOC_FLAG_4GB_ADDR;
#endif
    }

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    flags |= gcvALLOC_FLAG_CACHEABLE;
#endif

#if gcdENABLE_40BIT_VA
    flags |= gcvALLOC_FLAG_32BIT_VA;
#endif

    status = gckOS_QueryOption(hardware->os, "mmuCmdPool", &data);
    if (gcmIS_SUCCESS(status))
        pool = (gcePOOL)data;
    else
        pool = gcvPOOL_DEFAULT;

#if gcdCAPTURE_ONLY_MODE
    pool = gcvPOOL_VIRTUAL;
#endif

    Execution->funcCmdCount = 1;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer,
                     gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    Execution->funcCmd[0].funcVidMemBytes = 1024;
    /* Allocate mmu command buffer within 32bit space */
    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_MMU_PAGE_DESCRIPTOR))
    {
        /* Ensure address of command buffer for MMU setup does not exceed 32 bit */
        flags |= gcvALLOC_FLAG_4GB_ADDR;
    }
    gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                              gcvVIDMEM_TYPE_COMMAND, flags,
                                              &Execution->funcCmd[0].funcVidMemBytes, &pool,
                                              &Execution->funcCmd[0].funcVidMem));

    /* Lock for kernel side CPU access. */
    gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                       Execution->funcCmd[0].funcVidMem,
                                       gcvFALSE, gcvFALSE,
                                       &Execution->funcCmd[0].logical));

    /* Get GPU physical address. */
    gcmkONERROR(gckVIDMEM_NODE_GetGPUPhysical(hardware->kernel,
                                              Execution->funcCmd[0].funcVidMem,
                                              0, &physical));

    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_MMU_PAGE_DESCRIPTOR) &&
        (physical & 0xFFFFFFFF00000000ULL)) {
        gcmkFATAL("%s(%d): Command buffer physical address (0x%llx) for MMU setup exceeds 32bits, please rebuild kernel with CONFIG_ZONE_DMA32=y or CONFIG_ZONE_DMA=y or both.",
                  __FUNCTION__, __LINE__, physical);

        gcmkFATAL("Some Archs, for ARM64, the setting is special:\n"
                    "kernel version   ZONE_DMA   ZONE_DMA32\n"
                    "3.7  - 3.14        no          yes\n"
                    "3.15 - 4.15        yes         no\n"
                    "4.16 - 5.4.5       no          yes\n"
                    "5.5.rc1 -          yes         yes\n");

        gcmkONERROR(gcvSTATUS_OUT_OF_MEMORY);
    }

    Execution->funcCmd[0].physical = physical;

    if (hardware->mcFE) {
        gcmkONERROR(_ProgramMMUStatesMCFE(hardware,
                                          hardware->kernel->mmu, mode,
                                          Execution->funcCmd[0].logical, &mmuBytes));
    } else {
        gcmkONERROR(_ProgramMMUStates(hardware,
                                      hardware->kernel->mmu, mode,
                                      Execution->funcCmd[0].logical, &mmuBytes));
    }

    Execution->funcCmd[0].endPhysical = Execution->funcCmd[0].physical + mmuBytes;
    Execution->funcCmd[0].endLogical  = (gctUINT8_PTR)Execution->funcCmd[0].logical + mmuBytes;

    gcmkSAFECASTPHYSADDRT(Execution->funcCmd[0].address, Execution->funcCmd[0].physical);

    /*
     * It is OK to cast the end physical to 32bit end address,
     * even though the end physical is above 32bit.
     * As the debug register which is checked with lastEnd,
     * also will cast above 32bit address to 32bit address.
     */
    gcmkSAFECASTPHYSADDRT(Execution->funcCmd[0].endAddress, Execution->funcCmd[0].endPhysical);

    if (hardware->wlFE) {
        tailBytes = (gctUINT32)(Execution->funcCmd[0].funcVidMemBytes - mmuBytes);
        gcmkONERROR(gckWLFE_End(hardware,
                                Execution->funcCmd[0].endLogical,
                                Execution->funcCmd[0].endAddress,
                                &tailBytes));
    } else {
        tailBytes = 0;
    }

    Execution->funcCmd[0].bytes = mmuBytes + tailBytes;

    gcmkONERROR(gckVIDMEM_NODE_CleanCache(hardware->kernel,
                                          Execution->funcCmd[0].funcVidMem, 0,
                                          Execution->funcCmd[0].logical,
                                          Execution->funcCmd[0].bytes));

    return gcvSTATUS_OK;

OnError:
    _FuncRelease_MMU(Execution);

    return status;
}

static gceSTATUS
_FuncExecute_MMU_REG(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS   status         = gcvSTATUS_OK;
    gckHARDWARE hardware       = (gckHARDWARE)Execution->hardware;
    gckMMU      mmu            = hardware->kernel->mmu;
    gctUINT32   address        = 0;
    gctUINT32   extSafeAddress = 0;
    gctUINT32   mtlb, extMtlb;

    mtlb    = (gctUINT32)(mmu->mtlbPhysical & 0xFFFFFFFF);
    extMtlb = (gctUINT32)(mmu->mtlbPhysical >> 32);

    /* more than 40bit physical address */
    if (extMtlb & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    gcmkONERROR(gckOS_WriteRegisterEx(
        hardware->os, hardware->kernel,
        0x003B4,
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4))) | (((gctUINT32) ((gctUINT32) ((extMtlb << 20) | (mtlb >> 12)) & ((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4)))));

    address        = (gctUINT32)(mmu->safePagePhysical & 0xFFFFFFFF);
    extSafeAddress = (gctUINT32)(mmu->safePagePhysical >> 32);

    if (address & 0x3F)
        gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

    /* more than 40bit physical address */
    if (extSafeAddress & 0xFFFFFF00)
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

    gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                      0x00394, 1));

    gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                      0x0039C, address));

    gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                      0x00398, address));

    gcmkONERROR(gckOS_WriteRegisterEx(
        hardware->os, hardware->kernel,
        0x003A0,
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) | (((gctUINT32) ((gctUINT32) ((gctUINT32)extSafeAddress) & ((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:31) - (0 ? 31:31) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:31) - (0 ? 31:31) + 1))))))) << (0 ? 31:31))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 31:31) - (0 ? 31:31) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:31) - (0 ? 31:31) + 1))))))) << (0 ? 31:31))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) | (((gctUINT32) ((gctUINT32) ((gctUINT32)extSafeAddress) & ((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:15) - (0 ? 15:15) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:15) - (0 ? 15:15) + 1))))))) << (0 ? 15:15))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 15:15) - (0 ? 15:15) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:15) - (0 ? 15:15) + 1))))))) << (0 ? 15:15)))));

OnError:
    return status;
}

static gceSTATUS
_FuncExecute_MMU_CMD(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS     status  = gcvSTATUS_OK;
    gctUINT32     address = 0;
    gctUINT32     idle;
    gctUINT32     timer = 0, delay = 10;
    gckHARDWARE   hardware   = (gckHARDWARE)Execution->hardware;
    gckMMU        mmu        = hardware->kernel->mmu;
    gctUINT32_PTR endLogical = (gctUINT32_PTR)Execution->funcCmd[0].endLogical;

    /*
     * Prepared command sequence contains an END,
     * so update lastEnd and store executeCount to END command.
     */

    hardware->lastEnd = Execution->funcCmd[0].endAddress;

    if (hardware->wlFE) {
        /* Append a executeCount in End command, MCFE does not support such End command. */
        *(endLogical + 1) = hardware->executeCount + 1;
    }

    if (gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_MMU_PAGE_DESCRIPTOR)) {
        gctUINT32 extAddress = (gctUINT32)(Execution->funcCmd[0].physical >> 32);

        gcmkONERROR(gckOS_WriteRegisterEx(
            hardware->os, hardware->kernel,
            0x003B4,
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) (0x2 & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) |
                 ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4))) | (((gctUINT32) ((gctUINT32) ((extAddress << 20)) & ((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4)))));
    }

    if (hardware->options.secureMode == gcvSECURE_IN_NORMAL) {
        gctUINT32 extSafeAddress;

        /* Set up base address of page table array. */
        gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                          0x0038C,
                                          (gctUINT32)(hardware->pagetableArray.address & 0xFFFFFFFF)));

        gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                          0x00390,
                                          (gctUINT32)((hardware->pagetableArray.address >> 32) & 0xFFFFFFFF)));

        gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                          0x00394, 1));

        address        = (gctUINT32)(mmu->safePagePhysical & 0xFFFFFFFF);
        extSafeAddress = (gctUINT32)(mmu->safePagePhysical >> 32);

        if (address & 0x3F)
            gcmkONERROR(gcvSTATUS_NOT_ALIGNED);

        /* more than 40bit physical address */
        if (extSafeAddress & 0xFFFFFF00)
            gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);

        gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                          0x0039C, address));

        gcmkONERROR(gckOS_WriteRegisterEx(hardware->os, hardware->kernel,
                                          0x00398, address));

        gcmkONERROR(gckOS_WriteRegisterEx(
            hardware->os, hardware->kernel,
            0x003A0,
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) | (((gctUINT32) ((gctUINT32) ((gctUINT32)extSafeAddress) & ((gctUINT32) ((((1 ? 23:16) - (0 ? 23:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 23:16) - (0 ? 23:16) + 1))))))) << (0 ? 23:16))) |
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:31) - (0 ? 31:31) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:31) - (0 ? 31:31) + 1))))))) << (0 ? 31:31))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 31:31) - (0 ? 31:31) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:31) - (0 ? 31:31) + 1))))))) << (0 ? 31:31))) |
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) | (((gctUINT32) ((gctUINT32) ((gctUINT32)extSafeAddress) & ((gctUINT32) ((((1 ? 7:0) - (0 ? 7:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 7:0) - (0 ? 7:0) + 1))))))) << (0 ? 7:0))) |
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:15) - (0 ? 15:15) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:15) - (0 ? 15:15) + 1))))))) << (0 ? 15:15))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 15:15) - (0 ? 15:15) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:15) - (0 ? 15:15) + 1))))))) << (0 ? 15:15)))));
    }

    gckFUNCTION_Dump(Execution);

    /* Execute prepared command sequence. */
    if (hardware->mcFE) {
        gcmkONERROR(gckMCFE_Execute(hardware, gcvFALSE, 0,
                                    Execution->funcCmd[0].address,
                                    Execution->funcCmd[0].bytes));
    } else {
        gcmkONERROR(gckWLFE_Execute(hardware,
                                    Execution->funcCmd[0].address,
                                    Execution->funcCmd[0].bytes));
    }

#if gcdLINK_QUEUE_SIZE
    {
        gcuQUEUEDATA data;

        gcmkVERIFY_OK(gckOS_GetProcessID(&data.linkData.pid));

        data.linkData.start    = Execution->funcCmd[0].address;
        data.linkData.end      = Execution->funcCmd[0].address + Execution->funcCmd[0].bytes;
        data.linkData.linkLow  = 0;
        data.linkData.linkHigh = 0;

        gckQUEUE_Enqueue(&hardware->linkQueue, &data);
    }
#endif

    /* Wait until MMU configure finishes. */
    do {
#if gcdFPGA_BUILD
        gckOS_Delay(hardware->os, delay);
#else
        gckOS_Udelay(hardware->os, delay);
#endif

        gcmkONERROR(gckOS_ReadRegisterEx(hardware->os, hardware->kernel,
                                         0x00004, &idle));

        timer += delay;
        delay *= 2;

#if gcdGPU_TIMEOUT
        if (timer >= hardware->kernel->timeOut) {
            gckHARDWARE_DumpGPUState(hardware);

            if (hardware->kernel->command)
                gckCOMMAND_DumpExecutingBuffer(hardware->kernel->command);

            /*
             * Even if hardware is not reset correctly, let software
             * continue to avoid software stuck. Software will timeout again
             * and try to recover GPU in next timeout.
             */
            gcmkONERROR(gcvSTATUS_DEVICE);
        }
#endif
    } while (!(((((gctUINT32) (idle)) >> (0 ? 0:0)) & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) == 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1)))))) ));

    if (gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_MMU_PAGE_DESCRIPTOR)) {
        gcmkONERROR(gckOS_WriteRegisterEx(
            hardware->os, hardware->kernel,
            0x003B4,
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) |
                 ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 31:4) - (0 ? 31:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:4) - (0 ? 31:4) + 1))))))) << (0 ? 31:4)))));
    }

    gcmkDUMP(hardware->os, "@[register.wait 0x%05X 0x%08X 0x%08X]",
             0x00004,
             ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) ((gctUINT32) (~0U) & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))),
             idle);

OnError:
    return status;
}

static gceSTATUS
_FuncExecute_MMU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gckMMU      mmu      = hardware->kernel->mmu;
    gceSTATUS   status   = gcvSTATUS_OK;

    if (mmu->initMode == gcvMMU_INIT_FROM_REG)
        gcmkONERROR(_FuncExecute_MMU_REG(Execution));
    else
        gcmkONERROR(_FuncExecute_MMU_CMD(Execution));

OnError:
    return status;
}

static gceSTATUS
_FuncValidate_Flush(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_BLT_ENGINE) &&
        gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_COMPUTE_ONLY)) {
        Execution->valid = gcvFALSE;
    } else {
        Execution->valid = gcvTRUE;
    }

#if gcdDUMP_IN_KERNEL
    if (hardware->mcFE)
        Execution->valid = gcvFALSE;
#endif

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_Flush(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gctUINT8    i;
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (Execution->funcCmd) {
        for (i = 0; i < Execution->funcCmdCount; i++) {
            if (Execution->funcCmd[i].funcVidMem) {
                if (Execution->funcCmd[i].address) {
                    /* Synchroneous unlock. */
                    gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                        Execution->funcCmd[i].funcVidMem,
                                                        0, gcvNULL));
                    Execution->funcCmd[i].address = 0;
                }

                if (Execution->funcCmd[i].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[i].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[i].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[i].funcVidMem));

                Execution->funcCmd[i].funcVidMem = gcvNULL;
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncInit_Flush(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS    status     = gcvSTATUS_OK;
    gctUINT32    flushBytes = 0;
    gctUINT32    offset     = 0;
    gctUINT32    endBytes   = 0;
    gctADDRESS   address;
    gctUINT32    allocFlag  = 0;
    gcePOOL      pool;
    gctUINT8_PTR logical;
    gckHARDWARE  hardware   = (gckHARDWARE)Execution->hardware;
    gctPOINTER   pointer    = gcvNULL;

#if !gcdCAPTURE_ONLY_MODE
    pool = gcvPOOL_DEFAULT;
#else
    pool = gcvPOOL_VIRTUAL;
#endif

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag = gcvALLOC_FLAG_CACHEABLE;
#endif

#if gcdENABLE_40BIT_VA
    allocFlag |= gcvALLOC_FLAG_32BIT_VA;
#endif

    Execution->funcCmdCount = 1;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer,
                     gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    Execution->funcCmd[0].funcVidMemBytes = 1024;
    Execution->funcCmd[0].channelId       = 0;
    /* Allocate video memory node for aux functions. */
    gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                              gcvVIDMEM_TYPE_COMMAND,
                                              allocFlag,
                                              &Execution->funcCmd[0].funcVidMemBytes, &pool,
                                              &Execution->funcCmd[0].funcVidMem));

    /* Lock for GPU access. */
    gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                    Execution->funcCmd[0].funcVidMem,
                                    &Execution->funcCmd[0].address));

    /* Lock for kernel side CPU access. */
    gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                       Execution->funcCmd[0].funcVidMem,
                                       gcvFALSE, gcvFALSE,
                                       &Execution->funcCmd[0].logical));
    /*
     * All cache flush command sequence.
     */
    logical = (gctUINT8_PTR)Execution->funcCmd[0].logical;
    address = Execution->funcCmd[0].address;

    /* Get the size of the flush command. */
    gcmkONERROR(gckHARDWARE_Flush(hardware, gcvFLUSH_ALL, gcvNULL, &flushBytes));

    /* Append a flush. */
    gcmkONERROR(gckHARDWARE_Flush(hardware, gcvFLUSH_ALL, logical, &flushBytes));

    offset += flushBytes;
    logical += offset;
    address += offset;

    if (hardware->wlFE) {
        gcmkONERROR(gckWLFE_End(hardware, gcvNULL, ~0U, &endBytes));
        gcmkONERROR(gckWLFE_End(hardware, logical, address, &endBytes));
    }

    Execution->funcCmd[0].bytes      = flushBytes + endBytes;
    Execution->funcCmd[0].endAddress = Execution->funcCmd[0].address + flushBytes;
    Execution->funcCmd[0].endLogical = (gctUINT8_PTR)Execution->funcCmd[0].logical + flushBytes;

    return gcvSTATUS_OK;
OnError:
    _FuncRelease_Flush(Execution);

    return status;
}

#if gcdFLOP_RESET
static gceSTATUS
_FuncValidate_FlopReset(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS status = gcvSTATUS_OK;

#ifndef EMULATOR
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
#    endif

#ifdef EMULATOR
    Execution->valid = gcvFALSE;
#    else
    Execution->valid = gcvFALSE;

    if (hardware->type == gcvHARDWARE_VIP &&
        (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_EVIS2_FLOP_RESET_FIX) ||
         !gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX) ||
         !gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_USC_ASYNC_CP_RTN_FLOP_RESET_FIX))) {
        Execution->valid = gcvTRUE;
    }
    if (hardware->identity.customerID == 0x15)
        Execution->valid = gcvTRUE;
#    endif

    return status;
}

gceSTATUS
gckFUNCTION_CheckCHIPID(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (hardware->identity.customerID == 0xb5 || hardware->identity.customerID == 0x9f ||
        hardware->identity.customerID == 0x7d || hardware->identity.customerID == 0x99 ||
        hardware->identity.customerID == 0xa1 || hardware->identity.customerID == 0x88 ||
        hardware->identity.customerID == 0x98 || hardware->identity.customerID == 0x92 ||
        hardware->identity.customerID == 0xa3 || hardware->identity.customerID == 0xa9 ||
        hardware->identity.customerID == 0x97 || hardware->identity.customerID == 0x82 ||
        hardware->identity.customerID == 0x84 || hardware->identity.customerID == 0x9  ||
        hardware->identity.customerID == 0xa0 || hardware->identity.customerID == 0xa5 ||
        hardware->identity.customerID == 0x23 || hardware->identity.customerID == 0xb3 ||
        hardware->identity.customerID == 0x96 || hardware->identity.customerID == 0x86 ||
        hardware->identity.customerID == 0x83 || hardware->identity.customerID == 0x7f ||
        hardware->identity.customerID == 0x80 || hardware->identity.customerID == 0x15 ||
        hardware->identity.customerID == 0x85) {
        return gcvSTATUS_TRUE;
    }
    return gcvSTATUS_FALSE;
}

static gceSTATUS
_FuncInit_FlopReset(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS status = gcvSTATUS_OK;

    gckHARDWARE hardware  = (gckHARDWARE)Execution->hardware;
    gctPOINTER  pointer   = gcvNULL;
    gctUINT32   index     = 0;
    gctBOOL     doPPU     = gcvFALSE;
    gctBOOL     doNN      = gcvFALSE;
    gctBOOL     doTP      = gcvFALSE;
    gctUINT32   allocFlag = gcvALLOC_FLAG_NONE;
    gcePOOL     pool      = gcvPOOL_DEFAULT;

    Execution->funcCmdCount = 0;

#if gcdFLOP_RESET_NN
    if ((gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_NN_ENGINE) &&
         hardware->identity.customerID == 0x9f) ||
        gckFUNCTION_CheckCHIPID(Execution)) {
        doNN = gcvTRUE;
        Execution->funcCmdCount++;
    }
#    endif

#if gcdFLOP_RESET_TP
    if ((gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_TP_ENGINE) &&
         hardware->identity.customerID == 0x9f) ||
        gckFUNCTION_CheckCHIPID(Execution)) {
        doTP = gcvTRUE;
        Execution->funcCmdCount++;
    }
#    endif

#if gcdFLOP_RESET_PPU
    doPPU = gcvTRUE;
    Execution->funcCmdCount++;
#    endif

    if (!Execution->funcCmdCount) {
        /* Nothing to do. */
        return gcvSTATUS_OK;
    }

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    gcmkONERROR(gckOS_ZeroMemory((gctPOINTER)pointer,
                                 gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount));

#if !gcdCAPTURE_ONLY_MODE
    pool = gcvPOOL_DEFAULT;
#    else
    pool = gcvPOOL_VIRTUAL;
#    endif

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag = gcvALLOC_FLAG_CACHEABLE;
#    endif

    if (doNN) {
        gcmkONERROR(gckHARDWARE_ResetFlopWithNN(hardware, allocFlag, &pool,
                                                &Execution->funcCmd[index++]));
    }

    if (doTP) {
        gcmkONERROR(gckHARDWARE_ResetFlopWithTP(hardware, allocFlag, &pool,
                                                &Execution->funcCmd[index++]));
    }

    if (doPPU) {
        gcmkONERROR(gckHARDWARE_ResetFlopWithPPU(hardware, allocFlag, &pool,
                                                 &Execution->funcCmd[index++]));
    }

    gcmkASSERT(index <= Execution->funcCmdCount);

    return gcvSTATUS_OK;

OnError:
    _FuncRelease(Execution);

    return status;
}
#else
#if gcdINITIALIZE_PPU

#if gcdINITIALIZE_PPU_C
#            include "gc_hal_kernel_hardware_func_ppu.h"
#        endif

static gceSTATUS
_FuncValidate_PPU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#ifdef EMULATOR
    Execution->valid = gcvFALSE;
#        else
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    Execution->valid = gcvFALSE;
    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_EVIS2_FLOP_RESET_FIX)) {
#if gcdINITIALIZE_PPU_C
        Execution->valid = gcvTRUE;
#            else
        if (hardware->identity.customerID == 0x21 ||
            hardware->identity.customerID == 0x25 ||
            hardware->identity.customerID == 0x86) {
            Execution->valid = gcvTRUE;
        }
#            endif
    }
#        endif
    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_PPU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctUINT32   i, j;

    if (Execution->funcCmd) {
#if gcdINITIALIZE_PPU_C

        gctUINT32 pass = gcvTRUE;

        for (i = 0; i < (64 * 6 / 4); i++) {
            if (((gctUINT32_PTR)(Execution->funcCmd[0].data[OUTPUT_PPU_IDX].logical))[i] !=
                0x02020202) {
                pass = gcvFALSE;
                gcmkPRINT("Incorrect Result:[%d] 0x%08x\n",
                          i,
                          ((gctUINT32_PTR)(Execution->funcCmd[0].data[OUTPUT_PPU_IDX].logical))[i]);
            }
        }
        gcmkPRINT("PPU %s!\n", pass ? "PASS" : "FAIL");

#        endif

        for (j = 0; j < Execution->funcCmdCount; j++) {
            if (Execution->funcCmd[j].data) {
                for (i = 0; i < 7; i++) {
                    if (Execution->funcCmd[j].data[i].bufVidMem) {
                        if (Execution->funcCmd[j].data[i].logical) {
                            gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                     Execution->funcCmd[j].data[i].bufVidMem,
                                                     0, gcvFALSE, gcvFALSE);
                            Execution->funcCmd[j].data[i].logical = gcvNULL;
                        }
                        if (Execution->funcCmd[j].data[i].address) {
                            gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                  Execution->funcCmd[j].data[i].bufVidMem,
                                                  0, gcvNULL);
                            Execution->funcCmd[j].data[i].address = 0;
                        }

                        gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                   Execution->funcCmd[j].data[i].bufVidMem);
                    }
                }

                gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[j].data));
                Execution->funcCmd[j].data = gcvNULL;
            }

            if (Execution->funcCmd[j].funcVidMem) {
                if (Execution->funcCmd[j].address) {
                    /* Synchroneous unlock. */
                    gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                        Execution->funcCmd[j].funcVidMem,
                                                        0, gcvNULL));
                    Execution->funcCmd[j].address = 0;
                }

                if (Execution->funcCmd[j].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[j].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[j].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[j].funcVidMem));

                Execution->funcCmd[j].funcVidMem = gcvNULL;
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

gceSTATUS
_PatchPPUBuffer(IN gcsFUNCTION_EXECUTION_PTR Execution
#if gcdINITIALIZE_PPU_C
,
                IN gctUINT32 Width, IN gctUINT32 Height,
                OUT gctUINT32_PTR Bytes, OUT gctUINT32_PTR RegCount
#        endif
                )
{
    gceSTATUS     status                 = gcvSTATUS_OK;
    gcePOOL       pool                   = gcvPOOL_DEFAULT;
#if !gcdINITIALIZE_PPU_C
    gctUINT32_PTR command                = (gctUINT32_PTR)Execution->funcCmd[0].logical;
    gctUINT32     commandPatchOffsets[7] = { 0 };
#        endif
    gctUINT32_PTR patchBuffers[7]        = { NULL };
    gctSIZE_T     patchBufferSizes[7]    = { 0 };
    gctUINT32     i;
    gctUINT32     allocFlag = 0;
    gckHARDWARE   hardware  = (gckHARDWARE)Execution->hardware;
    gctPOINTER    pointer   = gcvNULL;
    gctUINT32     patchSize = 7;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag               = gcvALLOC_FLAG_CACHEABLE;
#        endif
#if gcdINITIALIZE_PPU_C
    gctUINT32 j             = 0;
    gctUINT32 data_type = 0x7, item_size = 1;

    patchBuffers[INPUT_PPU_IDX]  = NULL;
    patchBuffers[OUTPUT_PPU_IDX] = NULL;
    patchBuffers[INST_PPU_IDX]   = NULL;

    patchBufferSizes[INPUT_PPU_IDX]  = Width * Height * item_size;
    patchBufferSizes[OUTPUT_PPU_IDX] = Width * Height * item_size;
    patchBufferSizes[INST_PPU_IDX]   = 4 * 4 * gcmSIZEOF(gctUINT32);

#        else
    patchBuffers[0] = ppuMem0;
    patchBuffers[1] = ppuMem1;
    patchBuffers[2] = ppuMem2;
    patchBuffers[3] = ppuMem3;
    patchBuffers[4] = ppuMem4;
    patchBuffers[5] = ppuMem5;
    patchBuffers[6] = gcvNULL;

    patchBufferSizes[0] = gcmSIZEOF(ppuMem0);
    patchBufferSizes[1] = gcmSIZEOF(ppuMem1);
    patchBufferSizes[2] = gcmSIZEOF(ppuMem2);
    patchBufferSizes[3] = gcmSIZEOF(ppuMem3);
    patchBufferSizes[4] = gcmSIZEOF(ppuMem4);
    patchBufferSizes[5] = gcmSIZEOF(ppuMem5);
    patchBufferSizes[6] = 1024 * 6;

    commandPatchOffsets[0] = PATCH_OFFSET_0;
    commandPatchOffsets[1] = PATCH_OFFSET_1;
    commandPatchOffsets[2] = PATCH_OFFSET_2;
    commandPatchOffsets[3] = PATCH_OFFSET_3;
    commandPatchOffsets[4] = PATCH_OFFSET_4;
    commandPatchOffsets[5] = PATCH_OFFSET_5;
    commandPatchOffsets[6] = PATCH_OFFSET_6;
#        endif

    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * patchSize,
                               &pointer));

    gckOS_ZeroMemory(pointer, gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * patchSize);

    Execution->funcCmd[0].data = (gcsFUNCTION_EXECUTION_DATA_PTR)pointer;

    for (i = 0; i < patchSize; i++) {
#if gcdINITIALIZE_PPU_C
        if (patchBufferSizes[i] <= 0)
            continue;
#        endif
        /* Allocate memory for buffers. */
        gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                                  gcvVIDMEM_TYPE_BITMAP,
                                                  allocFlag, &patchBufferSizes[i], &pool,
                                                  &Execution->funcCmd[0].data[i].bufVidMem));

        gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem,
                                           gcvFALSE, gcvFALSE,
                                           &Execution->funcCmd[0].data[i].logical));

        gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                        Execution->funcCmd[0].data[i].bufVidMem,
                                        &Execution->funcCmd[0].data[i].address));

#if gcdINITIALIZE_PPU_C
        gckOS_ZeroMemory(Execution->funcCmd[0].data[i].logical,
                         patchBufferSizes[i]);

        if (patchBuffers[i]) {
            gckOS_MemCopy(Execution->funcCmd[0].data[i].logical,
                          patchBuffers[i], patchBufferSizes[i]);
        } else if (i == INST_PPU_IDX) {
            gcoHwFunc_SH_CMD(hardware, data_type,
                             (gctUINT32_PTR)Execution->funcCmd[0].data[i].logical,
                             Bytes, RegCount);
        } else {
            for (j = 0; j < patchBufferSizes[i] / 4; j++)
                ((gctUINT32_PTR)(Execution->funcCmd[0].data[i].logical))[j] = 0x01010101;
        }
#        else
        /* patch the buffer */
        command[commandPatchOffsets[i]] = Execution->funcCmd[0].data[i].address;
#        endif
    }

    return status;
OnError:
    if (Execution->funcCmd[0].data) {
        for (i = 0; i < patchSize; i++) {
            if (Execution->funcCmd[0].data[i].bufVidMem) {
                if (Execution->funcCmd[0].data[i].logical) {
                    gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                             Execution->funcCmd[0].data[i].bufVidMem,
                                             0, gcvFALSE, gcvFALSE);
                    Execution->funcCmd[0].data[i].logical = gcvNULL;
                }
                if (Execution->funcCmd[0].data[i].address) {
                    gckVIDMEM_NODE_Unlock(hardware->kernel,
                                          Execution->funcCmd[0].data[i].bufVidMem,
                                          0, gcvNULL);
                    Execution->funcCmd[0].data[i].address = 0;
                }

                gckVIDMEM_NODE_Dereference(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem);
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[0].data));
        Execution->funcCmd[0].data = gcvNULL;
    }

    return status;
}

gceSTATUS
_InitializePPU(IN gcsFUNCTION_EXECUTION_PTR Execution,
               IN OUT gctUINT32 *Bytes)
{
    gceSTATUS status     = gcvSTATUS_OK;
    gctPOINTER logical   = Execution->funcCmd[0].logical;
#if gcdINITIALIZE_PPU_C
    gctUINT32 width      = 64, height = 6, stride = 64;
    gctUINT32 count      = 0, regCount = 0;

    gcsFEATURE_DATABASE *db =
        (gcsFEATURE_DATABASE *)((gckHARDWARE)Execution->hardware)->featureDatabase;

    gctINT32  workDim          = 0x2,
              valueOrder       = 0x2;
    gctUINT32 groupsizeX       = 1, groupsizeY   = 1, groupsizeZ   = 0;
    gctUINT32 globalscaleX     = 4, globalscaleY = 1, globalscaleZ = 0;
    gctUINT32 groupcountX      = gcmALIGN_NP2(width, globalscaleX)/globalscaleX,
              groupcountY      = gcmALIGN_NP2(height, globalscaleY)/globalscaleY,
              groupcountZ      = 0;
    gctUINT32 globaloffsetX    = 0, globaloffsetY = 0, globaloffsetZ = 0;
    gctUINT32 threadAllocation =
        gcmALIGN_NP2(groupsizeX * groupsizeY, db->NumShaderCores * 4)/db->NumShaderCores * 4;

    /* Patch the command. */
    if (logical)
        status = _PatchPPUBuffer(Execution, width, height, &count, &regCount);

    if (count > 0 && regCount > 0) {
#endif
#if gcdINITIALIZE_PPU_C
        gctUINT32 flushCommands[] = {
#else
    static gctUINT32 flushCommands[] = {
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x028A) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000011,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E13) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) (0x2 & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))),
#else
        0x00000002,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x5580) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))),
#else
        0x00000002,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E02) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))),
#else
        0x00000701,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x09 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))),
#else
        0x00000701,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        Execution->funcCmd[0].data[0].address, stride, (height << 16 | width),
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3))) | (((gctUINT32) ((gctUINT32) (0x0) & ((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:4) - (0 ? 5:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:4) - (0 ? 5:4) + 1))))))) << (0 ? 5:4))) | (((gctUINT32) ((gctUINT32) (0x3) & ((gctUINT32) ((((1 ? 5:4) - (0 ? 5:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:4) - (0 ? 5:4) + 1))))))) << (0 ? 5:4)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 9:6) - (0 ? 9:6) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:6) - (0 ? 9:6) + 1))))))) << (0 ? 9:6))) | (((gctUINT32) ((gctUINT32) (0x7) & ((gctUINT32) ((((1 ? 9:6) - (0 ? 9:6) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:6) - (0 ? 9:6) + 1))))))) << (0 ? 9:6)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:10) - (0 ? 11:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:10) - (0 ? 11:10) + 1))))))) << (0 ? 11:10))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 11:10) - (0 ? 11:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:10) - (0 ? 11:10) + 1))))))) << (0 ? 11:10)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:12) - (0 ? 12:12) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:12) - (0 ? 12:12) + 1))))))) << (0 ? 12:12))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 12:12) - (0 ? 12:12) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:12) - (0 ? 12:12) + 1))))))) << (0 ? 12:12)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:14) - (0 ? 15:14) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:14) - (0 ? 15:14) + 1))))))) << (0 ? 15:14))) | (((gctUINT32) ((gctUINT32) (0x1) & ((gctUINT32) ((((1 ? 15:14) - (0 ? 15:14) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:14) - (0 ? 15:14) + 1))))))) << (0 ? 15:14)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 18:16) - (0 ? 18:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 18:16) - (0 ? 18:16) + 1))))))) << (0 ? 18:16))) | (((gctUINT32) ((gctUINT32) (0x0) & ((gctUINT32) ((((1 ? 18:16) - (0 ? 18:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 18:16) - (0 ? 18:16) + 1))))))) << (0 ? 18:16)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 22:20) - (0 ? 22:20) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:20) - (0 ? 22:20) + 1))))))) << (0 ? 22:20))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 22:20) - (0 ? 22:20) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:20) - (0 ? 22:20) + 1))))))) << (0 ? 22:20)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 30:28) - (0 ? 30:28) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 30:28) - (0 ? 30:28) + 1))))))) << (0 ? 30:28))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 30:28) - (0 ? 30:28) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 30:28) - (0 ? 30:28) + 1))))))) << (0 ? 30:28))),
#else
        0xD8000340, 0x00000080, 0x00800080, 0x444051F0,
#endif
        0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
#if gcdINITIALIZE_PPU_C

        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x04) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        Execution->funcCmd[0].data[1].address, stride, (height << 16 | width),
                ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3))) | (((gctUINT32) ((gctUINT32) (0x0) & ((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:4) - (0 ? 5:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:4) - (0 ? 5:4) + 1))))))) << (0 ? 5:4))) | (((gctUINT32) ((gctUINT32) (0x3) & ((gctUINT32) ((((1 ? 5:4) - (0 ? 5:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:4) - (0 ? 5:4) + 1))))))) << (0 ? 5:4)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 9:6) - (0 ? 9:6) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:6) - (0 ? 9:6) + 1))))))) << (0 ? 9:6))) | (((gctUINT32) ((gctUINT32) (0x7) & ((gctUINT32) ((((1 ? 9:6) - (0 ? 9:6) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:6) - (0 ? 9:6) + 1))))))) << (0 ? 9:6)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:10) - (0 ? 11:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:10) - (0 ? 11:10) + 1))))))) << (0 ? 11:10))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 11:10) - (0 ? 11:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:10) - (0 ? 11:10) + 1))))))) << (0 ? 11:10)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:12) - (0 ? 12:12) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:12) - (0 ? 12:12) + 1))))))) << (0 ? 12:12))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 12:12) - (0 ? 12:12) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:12) - (0 ? 12:12) + 1))))))) << (0 ? 12:12)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:14) - (0 ? 15:14) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:14) - (0 ? 15:14) + 1))))))) << (0 ? 15:14))) | (((gctUINT32) ((gctUINT32) (0x1) & ((gctUINT32) ((((1 ? 15:14) - (0 ? 15:14) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:14) - (0 ? 15:14) + 1))))))) << (0 ? 15:14)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 18:16) - (0 ? 18:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 18:16) - (0 ? 18:16) + 1))))))) << (0 ? 18:16))) | (((gctUINT32) ((gctUINT32) (0x0) & ((gctUINT32) ((((1 ? 18:16) - (0 ? 18:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 18:16) - (0 ? 18:16) + 1))))))) << (0 ? 18:16)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 22:20) - (0 ? 22:20) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:20) - (0 ? 22:20) + 1))))))) << (0 ? 22:20))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 22:20) - (0 ? 22:20) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 22:20) - (0 ? 22:20) + 1))))))) << (0 ? 22:20)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24)))
              | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 30:28) - (0 ? 30:28) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 30:28) - (0 ? 30:28) + 1))))))) << (0 ? 30:28))) | (((gctUINT32) ((gctUINT32) (0x4) & ((gctUINT32) ((((1 ? 30:28) - (0 ? 30:28) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 30:28) - (0 ? 30:28) + 1))))))) << (0 ? 30:28))),
#else
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x08) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xD8004380, 0x00000040, 0x00400040, 0x444051F0,
#endif
        0xFFFFFFFF,

#if gcdINITIALIZE_PPU_C

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x08) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (16) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x55555555, 0x00000000, // TCfg
        0x01234567, 0x89abcdef, 0x55555555, 0x01234567, 0x89abcdef, // BinSelect
        0x00000000, // AccumType, ConstantType, and PostShift
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, // Constant
        0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0240) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) ((gctUINT32) (workDim) & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 6:4) - (0 ? 6:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 6:4) - (0 ? 6:4) + 1))))))) << (0 ? 6:4))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 6:4) - (0 ? 6:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 6:4) - (0 ? 6:4) + 1))))))) << (0 ? 6:4)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))) | (((gctUINT32) ((gctUINT32) (valueOrder) & ((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))),
#else
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x10) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xD80053C0, 0x00000040, 0x00400040, 0x444051F0, 0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x18) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xD8000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x19) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xD8000040,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x1C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (8) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xD8006400, 0x00000080, 0x00400040, 0x44405071, 0x00000003, 0x00002000, 0x00000000, 0x00000000, 0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x24) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x11111111, 0x00000000, 0x03020100, 0x07060504, 0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x28) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x22222222, 0x00000000, 0x00000000, 0x00000400, 0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x2C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000001, 0x00000001, 0x00000001, 0x00000001, 0xFFFFFFFF,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800 + 0x30) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (4) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000001, 0x00000001, 0x00000001, 0x00000001, 0xFFFFFFFF,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x022C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 2:2) - (0 ? 2:2) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:2) - (0 ? 2:2) + 1))))))) << (0 ? 2:2))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 2:2) - (0 ? 2:2) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:2) - (0 ? 2:2) + 1))))))) << (0 ? 2:2)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 3:3) - (0 ? 3:3) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 3:3) - (0 ? 3:3) + 1))))))) << (0 ? 3:3)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:4) - (0 ? 4:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:4) - (0 ? 4:4) + 1))))))) << (0 ? 4:4))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 4:4) - (0 ? 4:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:4) - (0 ? 4:4) + 1))))))) << (0 ? 4:4))),
#else
        0x0000001F,
#endif

#if !gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x02A4) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,
#endif
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0420) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0))) | (((gctUINT32) ((gctUINT32) (0) & ((gctUINT32) ((((1 ? 2:0) - (0 ? 2:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 2:0) - (0 ? 2:0) + 1))))))) << (0 ? 2:0))),
#else
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0420) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0403) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        regCount,
#else
        0x00000005,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0416) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0409) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x021F) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0424) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        count/4,
#else
        0x0000000F,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x040A) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        Execution->funcCmd[0].data[2].address,
#else
        0xD8000100,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x5580) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) ((gctUINT32) (0x1) & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))),
#else
        0x00000002,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x021A) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))),
#else
        0x00000001,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0425) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        count/4 - 1,
#else
        0x0000000E,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0402) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
#if gcdINITIALIZE_PPU_C
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:0) - (0 ? 5:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:0) - (0 ? 5:0) + 1))))))) << (0 ? 5:0))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 5:0) - (0 ? 5:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:0) - (0 ? 5:0) + 1))))))) << (0 ? 5:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) ((gctUINT32) (~0) & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))),
#else
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (3) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00001F01, 0x00000005, 0x00000F00,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0228) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x02AA) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

#if !gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x028C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000100,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E07) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x040C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,
#if !gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x020C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x0F3F0000,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0201) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:0) - (0 ? 5:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:0) - (0 ? 5:0) + 1))))))) << (0 ? 5:0))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 5:0) - (0 ? 5:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:0) - (0 ? 5:0) + 1))))))) << (0 ? 5:0))),
#else
        0x00000001,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E22) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0412) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0240) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) ((gctUINT32) (0x2) & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 6:4) - (0 ? 6:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 6:4) - (0 ? 6:4) + 1))))))) << (0 ? 6:4))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 6:4) - (0 ? 6:4) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 6:4) - (0 ? 6:4) + 1))))))) << (0 ? 6:4)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))) | (((gctUINT32) ((gctUINT32) (0x3) & ((gctUINT32) ((((1 ? 26:24) - (0 ? 26:24) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 26:24) - (0 ? 26:24) + 1))))))) << (0 ? 26:24))),
#else
        0x03000002,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0249) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0247) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        threadAllocation,
#else
        0x00000001,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x024B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globaloffsetX,
#else
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x024D) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globaloffsetY,
#else
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x024F) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globaloffsetZ,
#else
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0256) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globalscaleX,
#else
        0x00000008,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0257) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globalscaleY,
#else
        0x00000001,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0258) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        globalscaleZ,
#else
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0250) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (6) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        groupcountX - 1, groupcountY - 1, groupcountZ - 1,
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))) | (((gctUINT32) ((gctUINT32) (groupsizeX - 1) & ((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))),
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))) | (((gctUINT32) ((gctUINT32) (groupsizeY - 1) & ((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))),
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))) | (((gctUINT32) ((gctUINT32) (groupsizeZ - 1) & ((gctUINT32) ((((1 ? 9:0) - (0 ? 9:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 9:0) - (0 ? 9:0) + 1))))))) << (0 ? 9:0))),
#else
        0x00000000, 0x0000003F, 0xFFFFFFFF, 0x00000007, 0x00000000, 0x000003FF,
#endif
        0x00000000,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0248) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
        0xBADABEEB,

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))),
#else
        0x00000C20,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E02) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))),
#else
        0x00000701,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x09 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 4:0) - (0 ? 4:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 4:0) - (0 ? 4:0) + 1))))))) << (0 ? 4:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))) | (((gctUINT32) (0x07 & ((gctUINT32) ((((1 ? 12:8) - (0 ? 12:8) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 12:8) - (0 ? 12:8) + 1))))))) << (0 ? 12:8))),
#else
        0x00000701,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))),
#else
        0x00000C23,
#endif
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))),
#else
        0x00000C23,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0594) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))),
#else
        0x00000001,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 0:0) - (0 ? 0:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 0:0) - (0 ? 0:0) + 1))))))) << (0 ? 0:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 1:1) - (0 ? 1:1) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:1) - (0 ? 1:1) + 1))))))) << (0 ? 1:1)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 5:5) - (0 ? 5:5) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 5:5) - (0 ? 5:5) + 1))))))) << (0 ? 5:5)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 10:10) - (0 ? 10:10) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 10:10) - (0 ? 10:10) + 1))))))) << (0 ? 10:10)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))) | (((gctUINT32) (0x1 & ((gctUINT32) ((((1 ? 11:11) - (0 ? 11:11) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 11:11) - (0 ? 11:11) + 1))))))) << (0 ? 11:11))),
#else
        0x00000C23,
#endif

#if !gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E13) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0)))
        | ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))),
#if gcdINITIALIZE_PPU_C
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))) | (((gctUINT32) (0x0 & ((gctUINT32) ((((1 ? 1:0) - (0 ? 1:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 1:0) - (0 ? 1:0) + 1))))))) << (0 ? 1:0))),
#else
        0x00000000,
#endif

        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x02 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))),
        0x00000000,
#endif
    };
#if gcdINITIALIZE_PPU_C

        *Bytes = gcmSIZEOF(flushCommands);

        gckOS_MemCopy(logical, flushCommands, *Bytes);
    }
#else
    *Bytes = gcmSIZEOF(flushCommands) - 8;
    /* Patch the command. */
    if (logical) {
        gckOS_MemCopy(logical, flushCommands, *Bytes);
        status = _PatchPPUBuffer(Execution);
    }
#endif
    return status;
}

static gceSTATUS
_FuncInit_PPU(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS    status   = gcvSTATUS_OK;
    gctUINT32    ppuBytes = 0;
    gctUINT32    offset   = 0;
    gctUINT32    endBytes = 0;
    gctADDRESS   address;
    gctUINT32    allocFlag = 0;
    gcePOOL      pool;
    gctUINT8_PTR logical;
    gckHARDWARE  hardware = (gckHARDWARE)Execution->hardware;
    gctPOINTER   pointer  = gcvNULL;

    pool = gcvPOOL_DEFAULT;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag = gcvALLOC_FLAG_CACHEABLE;
#        endif
    Execution->funcCmdCount = 1;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer, gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    Execution->funcCmd[0].funcVidMemBytes = 1024;
    /* Allocate video memory node for aux functions. */
    gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel,
                                              64, gcvVIDMEM_TYPE_COMMAND, allocFlag,
                                              &Execution->funcCmd[0].funcVidMemBytes, &pool,
                                              &Execution->funcCmd[0].funcVidMem));

    /* Lock for GPU access. */
    gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                    Execution->funcCmd[0].funcVidMem,
                                    &Execution->funcCmd[0].address));

    /* Lock for kernel side CPU access. */
    gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                       Execution->funcCmd[0].funcVidMem,
                                       gcvFALSE, gcvFALSE,
                                       &Execution->funcCmd[0].logical));
    /*
     * All cache flush command sequence.
     */
    logical = (gctUINT8_PTR)Execution->funcCmd[0].logical;
    address = Execution->funcCmd[0].address;
    /* Append a flush. */
    gcmkONERROR(_InitializePPU(Execution, &ppuBytes));

    offset += ppuBytes;
    logical += offset;
    address += offset;

    if (hardware->wlFE) {
        gcmkONERROR(gckWLFE_End(hardware, gcvNULL, ~0U, &endBytes));
        gcmkONERROR(gckWLFE_End(hardware, logical, address, &endBytes));
    }

    Execution->funcCmd[0].bytes      = ppuBytes + endBytes;
    Execution->funcCmd[0].endAddress = Execution->funcCmd[0].address + ppuBytes;
    Execution->funcCmd[0].endLogical = (gctUINT8_PTR)Execution->funcCmd[0].logical + ppuBytes;

    return gcvSTATUS_OK;
OnError:
    _FuncRelease_PPU(Execution);

    return status;
}

static gceSTATUS
_FuncValidate_PPU_0xA0(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#ifdef EMULATOR
    Execution->valid = gcvFALSE;
#        else
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    Execution->valid = gcvFALSE;
    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_EVIS2_FLOP_RESET_FIX)) {
        if (hardware->identity.customerID == 0xA0)
            Execution->valid = gcvTRUE;
    }
#        endif

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_PPU_0xA0(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctUINT32   i, j;

    if (Execution->funcCmd) {
        for (j = 0; j < Execution->funcCmdCount; j++) {
            if (Execution->funcCmd[j].data) {
                for (i = 0; i < 7; i++) {
                    if (Execution->funcCmd[j].data[i].bufVidMem) {
                        if (Execution->funcCmd[j].data[i].logical) {
                            gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                     Execution->funcCmd[j].data[i].bufVidMem, 0,
                                                     gcvFALSE, gcvFALSE);
                            Execution->funcCmd[j].data[i].logical = gcvNULL;
                        }
                        if (Execution->funcCmd[j].data[i].address) {
                            gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                  Execution->funcCmd[j].data[i].bufVidMem, 0,
                                                  gcvNULL);
                            Execution->funcCmd[j].data[i].address = 0;
                        }

                        gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                   Execution->funcCmd[j].data[i].bufVidMem);
                    }
                }

                gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[j].data));
                Execution->funcCmd[j].data = gcvNULL;
            }

            if (Execution->funcCmd[j].funcVidMem) {
                if (Execution->funcCmd[j].address) {
                    /* Synchroneous unlock. */
                    gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                        Execution->funcCmd[j].funcVidMem,
                                                        0, gcvNULL));
                    Execution->funcCmd[j].address = 0;
                }

                if (Execution->funcCmd[j].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[j].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[j].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[j].funcVidMem));

                Execution->funcCmd[j].funcVidMem = gcvNULL;
            }
        }
        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

gceSTATUS
_PatchPPUBuffer_0xA0(IN gctPOINTER Hardware, IN gcsFUNCTION_COMMAND *funcCmd)
{
    gceSTATUS     status  = gcvSTATUS_OK;
    gcePOOL       pool    = gcvPOOL_DEFAULT;
    gctUINT32_PTR command = (gctUINT32_PTR)funcCmd->logical;
    gctUINT32     commandPatchOffsets[7];
    gctUINT32_PTR patchBuffers[7];
    gctSIZE_T     patchBufferSizes[7];
    gctUINT32     i;
    gctUINT32     allocFlag = 0;
    gckHARDWARE   hardware  = (gckHARDWARE)Hardware;
    gctPOINTER    pointer   = gcvNULL;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag               = gcvALLOC_FLAG_CACHEABLE;
#        endif

    patchBuffers[0] = gcvNULL;
    patchBuffers[1] = ppuMem0_0xA0;
    patchBuffers[2] = gcvNULL;
    patchBuffers[3] = ppuMem1_0xA0;
    patchBuffers[4] = ppuMem2_0xA0;
    patchBuffers[5] = gcvNULL;
    patchBuffers[6] = ppuMem3_0xA0;

    patchBufferSizes[0] = 32 * 1024;
    patchBufferSizes[1] = gcmSIZEOF(ppuMem0_0xA0);
    ;
    patchBufferSizes[2] = 32 * 1024;
    patchBufferSizes[3] = gcmSIZEOF(ppuMem1_0xA0);
    patchBufferSizes[4] = gcmSIZEOF(ppuMem2_0xA0);
    patchBufferSizes[5] = 32 * 1024;
    patchBufferSizes[6] = gcmSIZEOF(ppuMem3_0xA0);

    commandPatchOffsets[0] = 7;
    commandPatchOffsets[1] = 19;
    commandPatchOffsets[2] = 31;
    commandPatchOffsets[3] = 43;
    commandPatchOffsets[4] = 45;
    commandPatchOffsets[5] = 47;
    commandPatchOffsets[6] = 97;

    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 7,
                               &pointer));

    gckOS_ZeroMemory(pointer, gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 7);

    funcCmd->data = (gcsFUNCTION_EXECUTION_DATA_PTR)pointer;

    for (i = 0; i < 7; i++) {
        /* Allocate memory for buffers. */
        gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                                  gcvVIDMEM_TYPE_BITMAP, allocFlag,
                                                  &patchBufferSizes[i], &pool,
                                                  &funcCmd->data[i].bufVidMem));

        gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                           funcCmd->data[i].bufVidMem,
                                           gcvFALSE, gcvFALSE,
                                           &funcCmd->data[i].logical));

        gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                        funcCmd->data[i].bufVidMem,
                                        &funcCmd->data[i].address));

        gckOS_ZeroMemory(funcCmd->data[i].logical, patchBufferSizes[i]);

        if (patchBuffers[i])
            gckOS_MemCopy(funcCmd->data[i].logical, patchBuffers[i], patchBufferSizes[i]);

        /* patch the buffer */
        command[commandPatchOffsets[i]] = funcCmd->data[i].address;
    }

    return status;
OnError:
    if (funcCmd->data) {
        for (i = 0; i < 7; i++) {
            if (funcCmd->data[i].bufVidMem) {
                if (funcCmd->data[i].logical) {
                    gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                             funcCmd->data[i].bufVidMem, 0,
                                             gcvFALSE, gcvFALSE);
                    funcCmd->data[i].logical = gcvNULL;
                }
                if (funcCmd->data[i].address) {
                    gckVIDMEM_NODE_Unlock(hardware->kernel,
                                          funcCmd->data[i].bufVidMem,
                                          0, gcvNULL);
                    funcCmd->data[i].address = 0;
                }

                gckVIDMEM_NODE_Dereference(hardware->kernel, funcCmd->data[i].bufVidMem);
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, funcCmd->data));
        funcCmd->data = gcvNULL;
    }

    return status;
}

gceSTATUS
_InitializePPU_0xA0(IN gcsFUNCTION_EXECUTION_PTR Execution,
                    IN gctUINT32 Index,
                    IN OUT gctUINT32 *Bytes)
{
    gceSTATUS  status  = gcvSTATUS_OK;
    gctPOINTER logical = Execution->funcCmd[Index].logical;

    switch (Index) {
    case 0:
        *Bytes = gcmSIZEOF(ppuCmd0_0xA0);
        if (logical)
            gckOS_MemCopy(logical, ppuCmd0_0xA0, *Bytes);
        break;
    case 1:
        *Bytes = gcmSIZEOF(ppuCmd1_0xA0);
        if (logical)
            gckOS_MemCopy(logical, ppuCmd1_0xA0, *Bytes);
        break;
    case 2:
        *Bytes = gcmSIZEOF(ppuCmd2_0xA0);
        if (logical) {
            gckOS_MemCopy(logical, ppuCmd2_0xA0, *Bytes);
            status = _PatchPPUBuffer_0xA0(Execution->hardware, &Execution->funcCmd[2]);
        }
        break;
    case 3:
        *Bytes = gcmSIZEOF(ppuCmd3_0xA0);
        if (logical)
            gckOS_MemCopy(logical, ppuCmd3_0xA0, *Bytes);
        break;
    default:
        return gcvSTATUS_INVALID_ARGUMENT;
        break;
    }

    *Bytes = *Bytes - 8;
    return status;
}

static gceSTATUS
_FuncInit_PPU_0xA0(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS    status   = gcvSTATUS_OK;
    gctUINT32    ppuBytes = 0;
    gctUINT32    endBytes = 0;
    gctADDRESS   address;
    gctUINT32    i, allocFlag = 0;
    gcePOOL      pool;
    gctUINT8_PTR logical;
    gckHARDWARE  hardware = (gckHARDWARE)Execution->hardware;
    gctPOINTER   pointer  = gcvNULL;

    pool = gcvPOOL_DEFAULT;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag = gcvALLOC_FLAG_CACHEABLE;
#        endif
    Execution->funcCmdCount = 4;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer,
                     gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    for (i = 0; i < Execution->funcCmdCount; i++) {
        Execution->funcCmd[i].funcVidMemBytes = 1024;
        /* Allocate video memory node for aux functions. */
        gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                                  gcvVIDMEM_TYPE_COMMAND, allocFlag,
                                                  &Execution->funcCmd[i].funcVidMemBytes,
                                                  &pool, &Execution->funcCmd[i].funcVidMem));

        /* Lock for GPU access. */
        gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                        Execution->funcCmd[i].funcVidMem,
                                        &Execution->funcCmd[i].address));

        /* Lock for kernel side CPU access. */
        gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                           Execution->funcCmd[i].funcVidMem,
                                           gcvFALSE, gcvFALSE,
                                           &Execution->funcCmd[i].logical));
        /*
         * All cache flush command sequence.
         */
        logical = (gctUINT8_PTR)Execution->funcCmd[i].logical;
        address = Execution->funcCmd[i].address;

        /* Append a flush. */
        gcmkONERROR(_InitializePPU_0xA0(Execution, i, &ppuBytes));

        logical += ppuBytes;
        address += ppuBytes;

        if (hardware->wlFE) {
            gcmkONERROR(gckWLFE_End(hardware, gcvNULL, ~0U, &endBytes));
            gcmkONERROR(gckWLFE_End(hardware, logical, address, &endBytes));
        }

        Execution->funcCmd[i].bytes      = ppuBytes + endBytes;
        Execution->funcCmd[i].endAddress = Execution->funcCmd[i].address + ppuBytes;
        Execution->funcCmd[i].endLogical = (gctUINT8_PTR)Execution->funcCmd[i].logical + ppuBytes;
    }

    return gcvSTATUS_OK;
OnError:
    _FuncRelease_PPU_0xA0(Execution);

    return status;
}

#    endif

#if gcdRESET_USC1
gceSTATUS
_InitializeUSC(IN gcsFUNCTION_EXECUTION_PTR Execution, IN OUT gctUINT32 *Bytes)
{
    gctUINT32            i;
    gcePOOL              pool          = gcvPOOL_DEFAULT;
    gctUINT32_PTR        flushCommands = gcvNULL;
    gctUINT32_PTR        nnCommands    = gcvNULL;
    gctSIZE_T            patchBufferSizes[5];
    gceSTATUS            status    = gcvSTATUS_OK;
    gckHARDWARE          hardware  = (gckHARDWARE)Execution->hardware;
    gctUINT8_PTR         logical   = (gctUINT8_PTR)Execution->funcCmd[0].logical;
    gctPOINTER           pointer   = gcvNULL;

#if gcdRESET_USC_C
    gcsFEATURE_DATABASE *db        = (gcsFEATURE_DATABASE *)(hardware->featureDatabase);
    gctUINT32            sram_size = hardware->kernel->device->extSRAMSizes[0] + db->VIP_SRAM_SIZE;
    USC_NN_TYPE          hw_type   = (db->NN_XYDP0) ? USC_NN_TYPE_V8 :
                                        ((db->VIP_V7) ? USC_NN_TYPE_V7 : USC_NN_TYPE_V6);

    gctUINT32 item_size  = 2, core_count = 0;
    gctUINT8  data_type  = 0;
    gctUINT32 filterSize = 0, biasSize = 4, filterTotalCount = 1,
              zdp = (db->NN_ZDP3) ? 3 : 1, size = 64;

    gcmkONERROR(_InitializeUSC_NNCommands(hardware, hw_type, 0, 0, 0,
                                          &data_type, &item_size, &core_count,
                                          &patchBufferSizes[NN_BUFFER_IDX],
                                          &nnCommands));

    filterSize = 2 * 2 * 1 * item_size;
    size       = gcmALIGN_NP2(((filterSize + biasSize + 3) * filterTotalCount + 3), 64);

    patchBufferSizes[INPUT_BUFFER_IDX]  = gcmALIGN_NP2(3 * 2 * item_size, 64);
    patchBufferSizes[RESULT_BUFFER_IDX] = gcmALIGN_NP2(2 * 1 * item_size, 64);

    /*v8*/
    if (hw_type == USC_NN_TYPE_V8)
        /*head(align to 64) + body(align to 64) + tail(align to 64)*/
        patchBufferSizes[KERNEL_BUFFER_IDX] =
            64 + gcmALIGN_NP2((gcmALIGN_NP2(filterSize, zdp * 3) * (zdp * 3) * filterTotalCount) + (1 * (16 / item_size)), 64) + 64;
    else
        /*head(align to 64) + body(align to 64)*/
        patchBufferSizes[KERNEL_BUFFER_IDX] = size + 64;

    patchBufferSizes[SRAM_BUFFER_IDX_C] = (sram_size > 0) ? sram_size : (128 * 1024);

#        else
    gctUINT32 idx = 0;

    if (hardware->identity.customerID == 0x86) {
        patchBufferSizes[NN_BUFFER_IDX] = gcmSIZEOF(nnBuffer0);
        nnCommands = nnBuffer0;
    } else if (hardware->identity.customerID == 0x25) {
        patchBufferSizes[NN_BUFFER_IDX] = gcmSIZEOF(nnBuffer1);
        nnCommands = nnBuffer1;
    } else if (hardware->identity.customerID == 0x21) {
        patchBufferSizes[NN_BUFFER_IDX] = gcmSIZEOF(nnBuffer2);
        nnCommands = nnBuffer2;
    } else if (hardware->identity.customerID == 0xA0) {
        patchBufferSizes[NN_BUFFER_IDX] = gcmSIZEOF(nnBuffer3);
        nnCommands = nnBuffer3;
    } else {
        gcmkONERROR(gcvSTATUS_NOT_SUPPORTED);
    }

    patchBufferSizes[INPUT_BUFFER_IDX]  = 512 * 1024;
    patchBufferSizes[KERNEL_BUFFER_IDX] = 512 * 1024;
    patchBufferSizes[RESULT_BUFFER_IDX] = 512 * 1024;
    patchBufferSizes[SRAM_BUFFER_IDX_C] = 0;
#        endif
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               160 * gcmSIZEOF(gctUINT32),
                               (gctPOINTER *)&flushCommands));

    gckOS_ZeroMemory((gctPOINTER)flushCommands, 160 * gcmSIZEOF(gctUINT32));

    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 5,
                               &pointer));

    gckOS_ZeroMemory(pointer, gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 5);

    Execution->funcCmd[0].data = (gcsFUNCTION_EXECUTION_DATA_PTR)pointer;

    for (i = 0; i < 5; i++) {
        if (patchBufferSizes[i] == 0)
            continue;
        /* Allocate memory for buffers. */
        gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                                  gcvVIDMEM_TYPE_COMMAND, gcvALLOC_FLAG_NONE,
                                                  &patchBufferSizes[i], &pool,
                                                  &Execution->funcCmd[0].data[i].bufVidMem));

        gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem,
                                           gcvFALSE, gcvFALSE,
                                           &Execution->funcCmd[0].data[i].logical));

        gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                        Execution->funcCmd[0].data[i].bufVidMem,
                                        &Execution->funcCmd[0].data[i].address));

        gcmkONERROR(gckOS_ZeroMemory(Execution->funcCmd[0].data[i].logical,
                                     patchBufferSizes[i]));
    }
#if gcdRESET_USC_C
    if (Execution->funcCmd[0].data[KERNEL_BUFFER_IDX].logical) {
        _InitializeUSC_NNKernel(hardware, hw_type, data_type, item_size, core_count,
                                (gctUINT32_PTR)Execution->funcCmd[0].data[KERNEL_BUFFER_IDX].logical);

#if gcdDUMP_IN_KERNEL
        gcmkDUMP(hardware->os, "#[reset usc: nn kernel]");
        gcmkDUMP_BUFFER(hardware->os, gcvDUMP_BUFFER_KERNEL_COMMAND,
                        Execution->funcCmd[0].data[KERNEL_BUFFER_IDX].logical,
                        Execution->funcCmd[0].data[KERNEL_BUFFER_IDX].address,
                        patchBufferSizes[KERNEL_BUFFER_IDX]);
#            endif
    }

    if (Execution->funcCmd[0].data[INPUT_BUFFER_IDX].logical) {
        gctUINT32 i = 0, offset = 0;
        /*                    uint8, fp16, int8, uint16, int16, uint4, int4, bf16*/
        gctUINT32 value[] = { 1, 0x3c00, 1, 1, 1, 1, 1, 0x3f80 };

        if (hw_type == USC_NN_TYPE_V8)
            value[0x4] = 0x81;

        for (i = 0; i < (3 * 2); i++)
            _BitValue((gctUINT8_PTR *)&(Execution->funcCmd[0].data[INPUT_BUFFER_IDX].logical),
                      value[data_type], &offset, item_size * 8);

#if gcdDUMP_IN_KERNEL
        gcmkDUMP(hardware->os, "#[reset usc: nn input]");
        gcmkDUMP_BUFFER(hardware->os, gcvDUMP_BUFFER_KERNEL_COMMAND,
                        Execution->funcCmd[0].data[INPUT_BUFFER_IDX].logical,
                        Execution->funcCmd[0].data[INPUT_BUFFER_IDX].address,
                        patchBufferSizes[INPUT_BUFFER_IDX]);
#            endif
    }

#        endif

    /* Patch NN command */
    nnCommands[PATCH_KERNEL_OFFSET] = Execution->funcCmd[0].data[KERNEL_BUFFER_IDX].address >> 6;
    nnCommands[PATCH_INPUT_OFFSET]  = Execution->funcCmd[0].data[INPUT_BUFFER_IDX].address;
    nnCommands[PATCH_RESULT_OFFSET] = Execution->funcCmd[0].data[RESULT_BUFFER_IDX].address;

    gckOS_MemCopy(Execution->funcCmd[0].data[NN_BUFFER_IDX].logical,
                  nnCommands,
                  patchBufferSizes[NN_BUFFER_IDX]);

#if gcdDUMP_IN_KERNEL
    gcmkDUMP(hardware->os, "#[reset usc: nn instruction]");
    gcmkDUMP_BUFFER(hardware->os, gcvDUMP_BUFFER_KERNEL_COMMAND,
                    Execution->funcCmd[0].data[NN_BUFFER_IDX].logical,
                    Execution->funcCmd[0].data[NN_BUFFER_IDX].address,
                    patchBufferSizes[NN_BUFFER_IDX]);
#        endif

#if gcdRESET_USC_C
    _InitializeUSC_NNCmdBuffer(hardware, hw_type, flushCommands,
                               Execution->funcCmd[0].data[NN_BUFFER_IDX].address,
                               Execution->funcCmd[0].data[SRAM_BUFFER_IDX_C].address, Bytes);
#        else
    /* construct command */
    if (hardware->identity.customerID == 0x21) {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x006B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000000;

        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000040;
    } else if (hardware->identity.customerID == 0xA0) {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E4E) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0xf0800000;

        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E4F) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000000;

        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E50) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000000;

        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000040;
    }

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0529) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0xfffffe7f;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0500) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x04011311;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0501) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0502) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x3f800000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0503) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x4b7fffff;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0504) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

    if (hardware->identity.customerID == 0x21)
        flushCommands[idx++] = 0x000a0000;
    else
        flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0520) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

    if (hardware->identity.customerID == 0x21)
        flushCommands[idx++] = 0x000a0000;
    else
        flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0505) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000500;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0506) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00070007;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x050B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x05102f0a;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E06) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x050C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0518) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x050D) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000500;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0300) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0301) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0302) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x43a00000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0303) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x43700000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0308) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x43a07800;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0309) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x4370f000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0595) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00400000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0380) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000004;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0515) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0516) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0518) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0520) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));

    if (hardware->identity.customerID == 0x21)
        flushCommands[idx++] = 0x000a0000;
    else
        flushCommands[idx++] = 0x00000000;

    if (hardware->identity.customerID == 0x86) {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E4C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x0000008c;
    } else if (hardware->identity.customerID == 0xA0) {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E4C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0x00000008;

        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E4E) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = 0xf0800000;
    }

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0428) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = Execution->funcCmd[0].data[NN_BUFFER_IDX].address;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000040;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x02 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
    flushCommands[idx++] = 0x00000000;

    *Bytes               = idx * 4 - 8;
#        endif
    /* Copy command to command buffer */
    gckOS_MemCopy(logical, flushCommands, *Bytes);

    if (flushCommands) {
        gckOS_Free(hardware->os, flushCommands);
        flushCommands = gcvNULL;
    }
    return status;

OnError:
    if (flushCommands) {
        gckOS_Free(hardware->os, flushCommands);
        flushCommands = gcvNULL;
    }

    if (Execution->funcCmd[0].data) {
        for (i = 0; i < 5; i++) {
            if (Execution->funcCmd[0].data[i].bufVidMem) {
                if (Execution->funcCmd[0].data[i].logical) {
                    gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                             Execution->funcCmd[0].data[i].bufVidMem,
                                             0, gcvFALSE, gcvFALSE);
                    Execution->funcCmd[0].data[i].logical = gcvNULL;
                }
                if (Execution->funcCmd[0].data[i].address) {
                    gckVIDMEM_NODE_Unlock(hardware->kernel,
                                          Execution->funcCmd[0].data[i].bufVidMem,
                                          0, gcvNULL);
                    Execution->funcCmd[0].data[i].address = 0;
                }

                gckVIDMEM_NODE_Dereference(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem);
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[0].data));
        Execution->funcCmd[0].data = gcvNULL;
    }

    return status;
}

static gceSTATUS
_FuncValidate_USC(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#ifdef EMULATOR
    Execution->valid = gcvFALSE;
#        else
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    Execution->valid = gcvFALSE;
    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_USC_ASYNC_CP_RTN_FLOP_RESET_FIX)) {
#if gcdRESET_USC_C
        Execution->valid = gcvTRUE;
#            else
        if (hardware->identity.customerID == 0x21 ||
            hardware->identity.customerID == 0x25 ||
            hardware->identity.customerID == 0x86 ||
            hardware->identity.customerID == 0xA0) {
            Execution->valid = gcvTRUE;
        }
#            endif
    }
#        endif
    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_USC(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctUINT32   i = 0, j = 0;

    if (Execution->funcCmd) {
#if gcdRESET_USC_C
        if (Execution->funcCmd[0].data) {
            if (*((gctUINT32_PTR)(Execution->funcCmd[0].data[3].logical)) == 0x00000404 ||  /* INT8 */
                *((gctUINT32_PTR)(Execution->funcCmd[0].data[3].logical)) == 0x00040004 ||  /* INT16 */
                *((gctUINT32_PTR)(Execution->funcCmd[0].data[3].logical)) == 0x44004400     /* FP16 */
            ) {
                gcmkPRINT("USC PASS! ");
            }
        }
#        endif

        for (j = 0; j < Execution->funcCmdCount; j++) {
            if (Execution->funcCmd[j].data) {
                for (i = 0; i < 5; i++) {
                    if (Execution->funcCmd[j].data[i].bufVidMem) {
                        if (Execution->funcCmd[j].data[i].logical) {
                            gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                     Execution->funcCmd[j].data[i].bufVidMem,
                                                     0, gcvFALSE, gcvFALSE);
                            Execution->funcCmd[j].data[i].logical = gcvNULL;
                        }
                        if (Execution->funcCmd[j].data[i].address) {
                            gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                  Execution->funcCmd[j].data[i].bufVidMem,
                                                  0, gcvNULL);
                            Execution->funcCmd[j].data[i].address = 0;
                        }

                        gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                   Execution->funcCmd[j].data[i].bufVidMem);
                    }
                }

                gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[j].data));
                Execution->funcCmd[j].data = gcvNULL;
            }

            if (Execution->funcCmd[j].funcVidMem) {
                if (Execution->funcCmd[j].address) {
                    /* Synchroneous unlock. */
                    gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                        Execution->funcCmd[j].funcVidMem,
                                                        0, gcvNULL));
                    Execution->funcCmd[j].address = 0;
                }

                if (Execution->funcCmd[j].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[j].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[j].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[j].funcVidMem));

                Execution->funcCmd[j].funcVidMem = gcvNULL;
            }
        }
        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncInit_USC(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS   status   = gcvSTATUS_OK;
    gctUINT32   uscBytes = 0;
    gctUINT32   offset   = 0;
    gctUINT32   endBytes = 0;
    gctADDRESS  address;
    gctUINT32   allocFlag = 0;
    gcePOOL     pool;
    gctPOINTER  logical;
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctPOINTER  pointer  = gcvNULL;

    pool = gcvPOOL_DEFAULT;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag = gcvALLOC_FLAG_CACHEABLE;
#        endif
    Execution->funcCmdCount = 1;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer,
                     gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    Execution->funcCmd[0].funcVidMemBytes = 1024;
    /* Allocate video memory node for aux functions. */
    gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                              gcvVIDMEM_TYPE_COMMAND, allocFlag,
                                              &Execution->funcCmd[0].funcVidMemBytes, &pool,
                                              &Execution->funcCmd[0].funcVidMem));

    /* Lock for GPU access. */
    gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                    Execution->funcCmd[0].funcVidMem,
                                    &Execution->funcCmd[0].address));

    /* Lock for kernel side CPU access. */
    gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                       Execution->funcCmd[0].funcVidMem,
                                       gcvFALSE, gcvFALSE,
                                       &Execution->funcCmd[0].logical));
    /*
     * All cache flush command sequence.
     */
    logical = Execution->funcCmd[0].logical;
    address = Execution->funcCmd[0].address;
    /* Append a flush. */
    gcmkONERROR(_InitializeUSC(Execution, &uscBytes));

    offset += uscBytes;
    address += offset;
    logical = (gctUINT8_PTR)logical + offset;

    if (hardware->wlFE) {
        gcmkONERROR(gckWLFE_End(hardware, gcvNULL, ~0U, &endBytes));
        gcmkONERROR(gckWLFE_End(hardware, logical, address, &endBytes));
    }

    Execution->funcCmd[0].bytes      = uscBytes + endBytes;
    Execution->funcCmd[0].endAddress = Execution->funcCmd[0].address + uscBytes;
    Execution->funcCmd[0].endLogical = (gctUINT8_PTR)Execution->funcCmd[0].logical + uscBytes;

    return gcvSTATUS_OK;
OnError:
    _FuncRelease_USC(Execution);

    return status;
}
#    endif
#if gcdRESET_USC2
gceSTATUS
_InitializeUSC2(IN gcsFUNCTION_EXECUTION_PTR Execution, IN OUT gctUINT32 *Bytes)
{
    gctUINT32     i, idx = 0;
    gcePOOL       pool          = gcvPOOL_DEFAULT;
    gctUINT32_PTR flushCommands = gcvNULL;
    gctSIZE_T     patchBufferSizes[3];
    gceSTATUS     status   = gcvSTATUS_OK;
    gckHARDWARE   hardware = (gckHARDWARE)Execution->hardware;
    gctUINT8_PTR  logical  = (gctUINT8_PTR)Execution->funcCmd[0].logical;
    gctPOINTER    pointer  = gcvNULL;

    patchBufferSizes[INST_BUFFER_IDX]   = gcmSIZEOF(instBuffer);
    patchBufferSizes[OUTPUT_BUFFER_IDX] = 1024;
    patchBufferSizes[SRAM_BUFFER_IDX]   = 128 * 1024;

    gcmkONERROR(gckOS_Allocate(hardware->os,
                               128 * gcmSIZEOF(gctUINT32),
                               (gctPOINTER *)&flushCommands));

    gckOS_ZeroMemory((gctPOINTER)flushCommands, 128 * gcmSIZEOF(gctUINT32));

    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 3,
                               &pointer));

    gckOS_ZeroMemory(pointer, gcmSIZEOF(gcsFUNCTION_EXECUTION_DATA) * 3);

    Execution->funcCmd[0].data = (gcsFUNCTION_EXECUTION_DATA_PTR)pointer;

    for (i = 0; i < 3; i++) {
        /* Allocate memory for buffers. */
        gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                                  gcvVIDMEM_TYPE_BITMAP, gcvALLOC_FLAG_NONE,
                                                  &patchBufferSizes[i], &pool,
                                                  &Execution->funcCmd[0].data[i].bufVidMem));

        gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem,
                                           gcvFALSE, gcvFALSE,
                                           &Execution->funcCmd[0].data[i].logical));

        gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel,
                                        Execution->funcCmd[0].data[i].bufVidMem,
                                        &Execution->funcCmd[0].data[i].address));

        gcmkONERROR(gckOS_ZeroMemory(Execution->funcCmd[0].data[i].logical,
                                     patchBufferSizes[i]));
    }

    gckOS_MemCopy(Execution->funcCmd[0].data[INST_BUFFER_IDX].logical,
                  instBuffer,
                  patchBufferSizes[INST_BUFFER_IDX]);

    /* construct command */
    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x0D & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                           gcvCORE_3D_ALL_MASK;
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0xD800) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (0x14) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0x00000002;
    flushCommands[idx++] = 0x075bcd15;
    flushCommands[idx++] = 0x00001000;
    flushCommands[idx++] = 0x00010000;
    flushCommands[idx++] = 0x00020000;
    flushCommands[idx++] = 0x00030000;
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0x00000002;
    flushCommands[idx++] = 0x00000004;
    flushCommands[idx++] = 0x0000000c;
    flushCommands[idx++] = 0x00000003;
    flushCommands[idx++] = 0x00000003;
    flushCommands[idx++] = 0x0000000f;
    flushCommands[idx++] = Execution->funcCmd[0].data[OUTPUT_BUFFER_IDX].address;
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000080;
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0xffffffff;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x0D & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                           gcvCORE_3D_ALL_MASK;
    flushCommands[idx++] = 0xf7f38c3c;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x021F) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0424) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x0000000e;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0402) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (3) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0x00000003;
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x040A) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = Execution->funcCmd[0].data[INST_BUFFER_IDX].address;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0409) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x022C) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000010;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x021A) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000001;

    if (hardware->identity.customerID == 0xA0) {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x040E) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
        flushCommands[idx++] = Execution->funcCmd[0].data[SRAM_BUFFER_IDX].address;
    } else {
        flushCommands[idx++] =
            ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x0D & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~
0U : (~
(~
0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | gcvCORE_3D_ALL_MASK;

        flushCommands[idx++] = 0x00000000;
    }

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E21) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x022E) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000300;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0240) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x02000001;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0247) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000001;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0249) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0250) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (3) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0253) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (3) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000000;
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x024B) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x024D) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000000;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0256) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (3) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0x00000001;
    flushCommands[idx++] = 0x00000001;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E01) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000020;

    flushCommands[idx++] =
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0248) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
        ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000001;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E03) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x00000020;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x01 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) | (((gctUINT32) ((gctUINT32) (0x0E01) & ((gctUINT32) ((((1 ? 15:0) - (0 ? 15:0) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 15:0) - (0 ? 15:0) + 1))))))) << (0 ? 15:0))) |
                           ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16))) | (((gctUINT32) ((gctUINT32) (1) & ((gctUINT32) ((((1 ? 25:16) - (0 ? 25:16) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 25:16) - (0 ? 25:16) + 1))))))) << (0 ? 25:16)));
    flushCommands[idx++] = 0x0000004f;

    flushCommands[idx++] = ((((gctUINT32) (0)) & ~(((gctUINT32) (((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27))) | (((gctUINT32) (0x02 & ((gctUINT32) ((((1 ? 31:27) - (0 ? 31:27) + 1) ==
 32) ? ~0U : (~(~0U << ((1 ? 31:27) - (0 ? 31:27) + 1))))))) << (0 ? 31:27)));
    flushCommands[idx++] = 0x00000000;

    *Bytes = idx * 4 - 8;
    /* Copy command to command buffer */
    gckOS_MemCopy(logical, flushCommands, *Bytes);
    if (flushCommands) {
        gckOS_Free(hardware->os, flushCommands);
        flushCommands = gcvNULL;
    }

    return status;
OnError:
    if (flushCommands) {
        gckOS_Free(hardware->os, flushCommands);
        flushCommands = gcvNULL;
    }

    if (Execution->funcCmd[0].data) {
        for (i = 0; i < 3; i++) {
            if (Execution->funcCmd[0].data[i].bufVidMem) {
                if (Execution->funcCmd[0].data[i].logical) {
                    gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                             Execution->funcCmd[0].data[i].bufVidMem,
                                             0, gcvFALSE, gcvFALSE);
                    Execution->funcCmd[0].data[i].logical = gcvNULL;
                }
                if (Execution->funcCmd[0].data[i].address) {
                    gckVIDMEM_NODE_Unlock(hardware->kernel,
                                          Execution->funcCmd[0].data[i].bufVidMem,
                                          0, gcvNULL);
                    Execution->funcCmd[0].data[i].address = 0;
                }

                gckVIDMEM_NODE_Dereference(hardware->kernel,
                                           Execution->funcCmd[0].data[i].bufVidMem);
            }
        }

        gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[0].data));
        Execution->funcCmd[0].data = gcvNULL;
    }

    return status;
}

static gceSTATUS
_FuncValidate_USC2(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#ifdef EMULATOR
    Execution->valid = gcvFALSE;
#        else
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    Execution->valid = gcvFALSE;
    if (!gckHARDWARE_IsFeatureAvailable(hardware, gcvFEATURE_USC_EVICT_CTRL_FIFO_FLOP_RESET_FIX)) {
        if (hardware->identity.customerID == 0x21 ||
            hardware->identity.customerID == 0x25 ||
            hardware->identity.customerID == 0x86 ||
            hardware->identity.customerID == 0xA0) {
            Execution->valid = gcvTRUE;
        }
    }
#        endif
    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncRelease_USC2(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctUINT32   i, j;

    if (Execution->funcCmd) {
        for (j = 0; j < Execution->funcCmdCount; j++) {
            if (Execution->funcCmd[j].data) {
                for (i = 0; i < 3; i++) {
                    if (Execution->funcCmd[j].data[i].bufVidMem) {
                        if (Execution->funcCmd[j].data[i].logical) {
                            gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                     Execution->funcCmd[j].data[i].bufVidMem,
                                                     0, gcvFALSE, gcvFALSE);
                            Execution->funcCmd[j].data[i].logical = gcvNULL;
                        }
                        if (Execution->funcCmd[j].data[i].address) {
                            gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                  Execution->funcCmd[j].data[i].bufVidMem,
                                                  0, gcvNULL);
                            Execution->funcCmd[j].data[i].address = 0;
                        }

                        gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                   Execution->funcCmd[j].data[i].bufVidMem);
                    }
                }

                gcmkVERIFY_OK(gckOS_Free(hardware->os, Execution->funcCmd[j].data));
                Execution->funcCmd[j].data = gcvNULL;
            }

            if (Execution->funcCmd[j].funcVidMem) {
                if (Execution->funcCmd[j].address) {
                    /* Synchroneous unlock. */
                    gcmkVERIFY_OK(gckVIDMEM_NODE_Unlock(hardware->kernel,
                                                        Execution->funcCmd[j].funcVidMem,
                                                        0, gcvNULL));
                    Execution->funcCmd[j].address = 0;
                }

                if (Execution->funcCmd[j].logical) {
                    gcmkVERIFY_OK(gckVIDMEM_NODE_UnlockCPU(hardware->kernel,
                                                           Execution->funcCmd[j].funcVidMem,
                                                           0, gcvFALSE, gcvFALSE));
                    Execution->funcCmd[j].logical = gcvNULL;
                }

                gcmkVERIFY_OK(gckVIDMEM_NODE_Dereference(hardware->kernel,
                                                         Execution->funcCmd[j].funcVidMem));

                Execution->funcCmd[j].funcVidMem = gcvNULL;
            }
        }
        gcmkVERIFY_OK(gckOS_Free(hardware->os, (gctPOINTER)Execution->funcCmd));
    }

    return gcvSTATUS_OK;
}

static gceSTATUS
_FuncInit_USC2(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS   status   = gcvSTATUS_OK;
    gctUINT32   uscBytes = 0;
    gctUINT32   offset   = 0;
    gctUINT32   endBytes = 0;
    gctADDRESS  address;
    gctUINT32   allocFlag = 0;
    gcePOOL     pool;
    gctPOINTER  logical;
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;
    gctPOINTER  pointer  = gcvNULL;

    pool                    = gcvPOOL_DEFAULT;

#if gcdENABLE_CACHEABLE_COMMAND_BUFFER
    allocFlag               = gcvALLOC_FLAG_CACHEABLE;
#        endif
    Execution->funcCmdCount = 1;

    /* Allocate the gcsFUNCTION_COMMAND buffer */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount,
                               (gctPOINTER *)&pointer));

    gckOS_ZeroMemory((gctPOINTER)pointer,
                     gcmSIZEOF(gcsFUNCTION_COMMAND) * Execution->funcCmdCount);

    Execution->funcCmd = (gcsFUNCTION_COMMAND_PTR)pointer;

    Execution->funcCmd[0].funcVidMemBytes = 1024;
    /* Allocate video memory node for aux functions. */
    gcmkONERROR(gckKERNEL_AllocateVideoMemory(hardware->kernel, 64,
                                              gcvVIDMEM_TYPE_COMMAND,
                                              allocFlag, &Execution->funcCmd[0].funcVidMemBytes,
                                              &pool, &Execution->funcCmd[0].funcVidMem));

    /* Lock for GPU access. */
    gcmkONERROR(gckVIDMEM_NODE_Lock(hardware->kernel, Execution->funcCmd[0].funcVidMem,
                                    &Execution->funcCmd[0].address));

    /* Lock for kernel side CPU access. */
    gcmkONERROR(gckVIDMEM_NODE_LockCPU(hardware->kernel,
                                       Execution->funcCmd[0].funcVidMem,
                                       gcvFALSE, gcvFALSE,
                                       &Execution->funcCmd[0].logical));
    /*
     * All cache flush command sequence.
     */
    logical = Execution->funcCmd[0].logical;
    address = Execution->funcCmd[0].address;
    /* Append a flush. */
    gcmkONERROR(_InitializeUSC2(Execution, &uscBytes));

    offset += uscBytes;
    address += offset;
    logical = (gctUINT8_PTR)logical + offset;

    if (hardware->wlFE) {
        gcmkONERROR(gckWLFE_End(hardware, gcvNULL, ~0U, &endBytes));
        gcmkONERROR(gckWLFE_End(hardware, logical, address, &endBytes));
    }

    Execution->funcCmd[0].bytes      = uscBytes + endBytes;
    Execution->funcCmd[0].endAddress = Execution->funcCmd[0].address + uscBytes;
    Execution->funcCmd[0].endLogical = (gctUINT8_PTR)Execution->funcCmd[0].logical + uscBytes;

    return gcvSTATUS_OK;

OnError:
    _FuncRelease_USC2(Execution);

    return status;
}

#    endif
#endif

/*******************************************************************************
 **
 **  gckFUNCTION_Construct
 **
 **  Generate command buffer snippets which will be used by gckHARDWARE, by which
 **  gckHARDWARE can manipulate GPU by FE command without using gckCOMMAND to avoid
 **  race condition and deadlock.
 **
 **  Notice:
 **  1. Each snippet can only be executed when GPU is idle.
 **  2. Execution is triggered by AHB (0x658)
 **  3. Each snippet followed by END so software can sync with GPU by checking GPU
 **     idle
 **  4. It is transparent to gckCOMMAND command buffer.
 **
 **  Existing Snippets:
 **  1. MMU Configure
 **     For new MMU, after GPU is reset, FE execute this command sequence to enable MMU.
 */
gceSTATUS
gckFUNCTION_Construct(IN gctPOINTER Hardware)
{
    gceSTATUS   status   = gcvSTATUS_OK;
    gckHARDWARE hardware = (gckHARDWARE)Hardware;
    gctPOINTER  pointer  = gcvNULL;
    gctUINT     i;

    gcmkHEADER_ARG("Hardware=%p", Hardware);
    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Hardware != gcvNULL);

    /* Allocate the gcsFUNCTION_EXECUTION object. */
    gcmkONERROR(gckOS_Allocate(hardware->os,
                               gcmSIZEOF(gcsFUNCTION_EXECUTION) * gcvFUNCTION_EXECUTION_NUM,
                               &pointer));

    gckOS_ZeroMemory(pointer,
                     gcmSIZEOF(gcsFUNCTION_EXECUTION) * gcvFUNCTION_EXECUTION_NUM);

    hardware->functions = (gcsFUNCTION_EXECUTION_PTR)pointer;

    for (i = 0; i < gcvFUNCTION_EXECUTION_NUM; i++) {
        gcsFUNCTION_EXECUTION_PTR func = &hardware->functions[i];

        func->hardware = hardware;
        func->funcId   = (gceFUNCTION_EXECUTION)i;
        func->funcCmd  = gcvNULL;

        /* Init functions API pointer */
        switch (i) {
        case gcvFUNCTION_EXECUTION_MMU:
            gckOS_MemCopy(func->funcName, "set mmu", 8);
            func->funcExecution.init     = _FuncInit_MMU;
            func->funcExecution.validate = _FuncValidate_MMU;
            func->funcExecution.execute  = _FuncExecute_MMU;
            func->funcExecution.release  = _FuncRelease_MMU;
            break;

        case gcvFUNCTION_EXECUTION_FLUSH:
            gckOS_MemCopy(func->funcName, "flush", 6);
            func->funcExecution.init     = _FuncInit_Flush;
            func->funcExecution.validate = _FuncValidate_Flush;
            func->funcExecution.execute  = _FuncExecute;
            func->funcExecution.release  = _FuncRelease_Flush;
            break;

#if gcdFLOP_RESET
        case gcvFUNCTION_EXECUTION_FLOP_RESET:
            gckOS_MemCopy(func->funcName, "flop reset", 11);
            func->funcExecution.init     = _FuncInit_FlopReset;
            func->funcExecution.validate = _FuncValidate_FlopReset;
            func->funcExecution.execute  = _FuncExecute_FLOPRESET;
            func->funcExecution.release  = _FuncRelease;
            break;
#else
#if gcdINITIALIZE_PPU
        case gcvFUNCTION_EXECUTION_INITIALIZE_PPU:
            gckOS_MemCopy(func->funcName, "init ppu", 9);
            switch (hardware->identity.customerID) {
            case 0xA0:
                func->funcExecution.init     = _FuncInit_PPU_0xA0;
                func->funcExecution.validate = _FuncValidate_PPU_0xA0;
                func->funcExecution.execute  = _FuncExecute;
                func->funcExecution.release  = _FuncRelease_PPU_0xA0;
                break;
            default:
                func->funcExecution.init     = _FuncInit_PPU;
                func->funcExecution.validate = _FuncValidate_PPU;
                func->funcExecution.execute  = _FuncExecute;
                func->funcExecution.release  = _FuncRelease_PPU;
                break;
            }
            break;
#    endif
#if gcdRESET_USC1
        case gcvFUNCTION_EXECUTION_RESET_USC:
            gckOS_MemCopy(func->funcName, "reset usc", 10);
            func->funcExecution.init     = _FuncInit_USC;
            func->funcExecution.validate = _FuncValidate_USC;
            func->funcExecution.execute  = _FuncExecute;
            func->funcExecution.release  = _FuncRelease_USC;
            break;
#    endif
#if gcdRESET_USC2

        case gcvFUNCTION_EXECUTION_RESET_USC2:
            gckOS_MemCopy(func->funcName, "reset usc2", 11);
            func->funcExecution.init     = _FuncInit_USC2;
            func->funcExecution.validate = _FuncValidate_USC2;
            func->funcExecution.execute  = _FuncExecute;
            func->funcExecution.release  = _FuncRelease_USC2;
            break;
#    endif
#endif

        default:
            gcmkONERROR(gcvSTATUS_INVALID_ARGUMENT);
        }
    }

    return gcvSTATUS_OK;
OnError:
    if (hardware->functions)
        gcmkVERIFY_OK(gckOS_Free(hardware->os, hardware->functions));

    /* Return the status. */
    gcmkFOOTER();
    return status;
}

gceSTATUS
gckFUNCTION_Destory(IN gctPOINTER Hardware)
{
    gceSTATUS   status   = gcvSTATUS_OK;
    gckHARDWARE hardware = (gckHARDWARE)Hardware;
    gctUINT     i;

    gcmkHEADER_ARG("Hardware=%p", Hardware);
    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Hardware != gcvNULL);

    for (i = 0; i < gcvFUNCTION_EXECUTION_NUM; i++)
        gckFUNCTION_Release(&hardware->functions[i]);

    gcmkVERIFY_OK(gckOS_Free(hardware->os, hardware->functions));
    hardware->functions = gcvNULL;

    /* Return the status. */
    gcmkFOOTER();
    return status;
}

gceSTATUS
gckFUNCTION_Validate(IN gcsFUNCTION_EXECUTION_PTR Execution, IN OUT gctBOOL_PTR Valid)
{
    gceSTATUS status = gcvSTATUS_NOT_SUPPORTED;

    gcmkHEADER_ARG("Execution=%p", Execution);
    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Execution != gcvNULL);
    gcmkVERIFY_ARGUMENT(Valid != gcvNULL);

    if (Execution->funcExecution.validate) {
        status = Execution->funcExecution.validate(Execution);
        *Valid = Execution->valid;
    }

    gcmkFOOTER();
    return status;
}

gceSTATUS
gckFUNCTION_Init(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS status = gcvSTATUS_NOT_SUPPORTED;

    gcmkHEADER_ARG("Execution=%p", Execution);
    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Execution != gcvNULL);

    Execution->inited = gcvTRUE;
    if (Execution->funcExecution.init)
        status = Execution->funcExecution.init(Execution);

    if (status != gcvSTATUS_OK)
        Execution->inited = gcvFALSE;

    gcmkFOOTER();
    return status;
}

gceSTATUS
gckFUNCTION_Execute(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS status = gcvSTATUS_OK;

    gcmkHEADER_ARG("Execution=0x%x", Execution);

    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Execution != gcvNULL);

    if (Execution->inited && Execution->funcExecution.execute)
        gcmkONERROR(Execution->funcExecution.execute(Execution));
    else
        status = gcvSTATUS_NOT_SUPPORTED;

OnError:
    gcmkFOOTER();
    return status;
}

gceSTATUS
gckFUNCTION_Release(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
    gceSTATUS status = gcvSTATUS_NOT_SUPPORTED;

    gcmkHEADER_ARG("Execution=0x%x", Execution);

    /* Verify the arguments. */
    gcmkVERIFY_ARGUMENT(Execution != gcvNULL);

    if (Execution->inited && Execution->funcExecution.release)
        status = Execution->funcExecution.release(Execution);

    Execution->inited = gcvFALSE;

    gcmkFOOTER();
    return status;
}

void
gckFUNCTION_Dump(IN gcsFUNCTION_EXECUTION_PTR Execution)
{
#if gcdDUMP_IN_KERNEL
    gctUINT32   i;
    gckHARDWARE hardware = (gckHARDWARE)Execution->hardware;

    if (!Execution || !Execution->funcCmd)
        return;

    gcmkDUMP(hardware->os, "#[function: %s]", Execution->funcName);
    for (i = 0; i < Execution->funcCmdCount; i++) {
        gcmkDUMP_BUFFER(hardware->os,
                        gcvDUMP_BUFFER_KERNEL_COMMAND,
                        Execution->funcCmd[i].logical,
                        Execution->funcCmd[i].address,
                        Execution->funcCmd[i].bytes);
    }
#endif
}

