#ifndef SIP1221LR1S_H
#define SIP1221LR1S_H

#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/delay.h>
//#include <linux/ide.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/errno.h>
#include <linux/gpio.h>
#include <linux/cdev.h>
#include <linux/device.h>
#include <linux/of_gpio.h>
#include <linux/semaphore.h>
#include <linux/timer.h>
#include <linux/spi/spi.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/of_gpio.h>
#include <linux/platform_device.h>
#include <linux/device.h>
#include <linux/timer.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <linux/i2c.h>
#include <asm/uaccess.h>
//#include <stdbool.h>
#include <linux/wait.h>
#include <linux/poll.h>
#include <linux/workqueue.h>
#include <linux/proc_fs.h>

#define log_i(fmt, args...) \
    printk(KERN_INFO "%s:%d [info]:" fmt "\r\n", __func__,__LINE__,##args);

#define log_w(fmt, args...) \
    printk(KERN_WARNING "%s:%d [warn]:" fmt "\r\n", __func__,__LINE__,##args);

#define log_e(fmt, args...) \
    printk(KERN_ERR "%s:%d [error]:" fmt "\r\n",__func__,__LINE__,##args);

#define log_d(fmt, args...) \
    printk(KERN_DEBUG "%s:%d [debug]:" fmt "\r\n",__func__,__LINE__,##args);


#define IOC_MAGIC 'c'

#define IOCINT              _IO(IOC_MAGIC, 0)
#define IOCGREG             _IOR(IOC_MAGIC, 1, int)
#define SENSOR_RESET        _IOW(IOC_MAGIC, 2, int)
#define SENSOR_ENABLE       _IOW(IOC_MAGIC, 3, int)
#define SENSOR_DISABLE      _IOW(IOC_MAGIC, 4, int)
#define QUARY_SENSOR_NUM    _IOR(IOC_MAGIC, 5, int)
#define GET_SENSOR_INFO     _IOR(IOC_MAGIC, 6, int)
#define SENSOR_CONFIG       _IOW(IOC_MAGIC, 7, int)
#define SENSOR_CALI         _IOW(IOC_MAGIC, 8, int)
#define GET_SENSOR_CALI     _IOW(IOC_MAGIC, 9, int)


#define IOC_MAXNR  0xff

/* SIP1221lr1s Register map */
/* Register definitions */
#define SIP_DEVICE_ADDR  0x58
#define SIP1221_ID       0x06
// reg list
#define SIP1221_CLK_CTRL 0x02
#define SIP1221_ID_REG   0x03
#define SIP1221_CTRL 0x05
#define SIP1221_INT_CTRL 0x06
#define SIP1221_ALS_ENABLE 0x50
#define SIP1221_ALS_CTRL0 0x51
#define SIP1221_ALS_CTRL1 0x52
#define SIP1221_ALS_INTEN 0x53
#define SIP1221_ALS_THLOW_H 0x54
#define SIP1221_ALS_THLOW_L 0x55
#define SIP1221_ALS_THHIGH_H 0x56
#define SIP1221_ALS_THHIGH_L 0x57
#define SIP1221_ALS_INTE_TIME_H 0x58
#define SIP1221_ALS_INTE_TIME_M 0x59
#define SIP1221_ALS_INTE_TIME_L 0x5A
#define SIP1221_ALS_PERIOD_STEP 0x5B
#define SIP1221_ALS_PERIOD_TIME 0x5C
#define SIP1221_ALS_RST_NUM 0x5D
#define SIP1221_ALS_AZ_CTRL 0x5E
#define SIP1221_ALS_AZ_EN 0x5F
#define SIP1221_RESERVE1 0x60
#define SIP1221_ALS0_1_GAIN 0x62
#define SIP1221_ALS2_GAIN 0x63
#define SIP1221_FLK_CTRL 0x71
#define SIP1221_FLK_INTE_H 0x73
#define SIP1221_FLK_INTE_M 0x74
#define SIP1221_FLK_INTE_L 0x75
#define SIP1221_ALS_INT_STATUS 0x81
#define SIP1221_DATA_VALID 0x84
#define SIP1221_ALS_DATA  0x90
#define SIP1221_ALSDATA_L 0x94
#define SIP1221_ALSDATA_H 0x95
#define SIP1221_WBDATA_L 0x96
#define SIP1221_WBDATA_H 0x97
#define SIP1221_FDATA 0x9F
#define SIP1221_FSTATUS 0xA0
#define SIP1221_FLVL 0xA1
#define SIP1221_F_THRESH 0xA2
#define SIP1221_FMODE0 0xA3
#define SIP1221_FMODE1 0xA4
#define SIP1221_SYNCDLY_CNT_H 0xE2
#define SIP1221_SYNCDLY_CNT_L 0xE3
#define SIP1221_SYNCTRIG_CNT 0xE4
#define SIP1221_SYNCWDT_CNT_H 0xE8
#define SIP1221_SYNC_FRQCHG_THRESH_H 0xEA
#define SIP1221_SYNC_FRQCHG_THRESH_L 0xEB
#define SIP1221_SYNC_PERIOD_L 0xEC
#define SIP1221_SYNC_PERIOD_M 0xED
#define SIP1221_SYNC_PERIOD_H 0xEE

// SIP1221lr1s_CTRL_REG @0x05
#define OSC_EN (0x01 << 1)
#define SOFT_RST_N (0x01 << 0)
// SIP1221lr1s_INT_CTRL_REG @0x06
#define WORK_MODE (0x01 << 4)
#define INT_EN (0x01 << 2)
#define INT_POLARITY (0x01 << 1)
#define INT_CLEAR_MODE (0x01 << 0)

// SIP1221lr1s_ALS_ENABLE   @0x50
#define ALS1_EN (0x01 << 2)
#define ALS0_EN (0x01 << 1)
#define ALS_EN (0x01 << 0)
// SIP1221lr1s_ALS_CTRL0  @0x51
#define ALS_PERIOD_EN (0x01 << 0)
// SIP1221lr1s_ALS_CTRL1  @0x52
#define ALS_PERSIST_NUM_MASK (0x0F << 4)
#define ALS_CHANNEL_INT_EN (0x01 << 2)
// SIP1221lr1s_ALSINT_EN @0x5F
#define ALS_ERR_INT_EN (0x01 << 3)
#define ALS_ANS_SAT_INT_EN (0x01 << 2)
#define ALS_DIG_SAT_INT_EN (0x01 << 1)
#define ALS_INT_EN (0x01 << 0)
// SIP1221lr1s_ALS_GAIN  @0x60
#define ALS1_GAIN_MASK (0x0F << 4)
#define ALS0_GAIN_MASK (0x0F << 0)
// SIP1221lr1s_ALS_AZ_EN @0x65
#define AL_AZ_MANUAL_EN (0x01 << 1)
#define AL_AZ_AUTO_EN (0x01 << 0)

// SIP1221lr1s_ALS_INT_STATUS @0x8E
#define ALS_ERR_INT (0x01 << 3)
#define ALS_ANS_SAT_INT (0x01 << 2)
#define ALS_DIG_SAT_INT (0x01 << 1)
#define ALS_INT (0x01 << 0)
// SIP1221lr1s_DATA_VALID @0xA8
#define ALS_DATA_VALID (0x01 << 2)

// Configration calculations
#define P_SLOW_CLOCK (4938)
#define P_FAST_CLOCK (2469)
#define ATIME_DUTY_CYCLE (2716)
#define ATIME_DIG_DUTY_CYCLE (1250)
#define ATIME_STEP_TIME_MS(ms)                                              \
    (uint16_t)(((uint32_t)(((uint32_t)ms * 1000 * 1000) / ATIME_DUTY_CYCLE) - 1) % \
               65536)
#define ATIME_STEP_NUM(ms)                                                 \
    (uint8_t)(((uint32_t)(((uint32_t)ms * 1000 * 1000) / ATIME_DUTY_CYCLE) - 1) / \
              65536)
// AL_PERIOD_STEP_H * AL_PERIOD_TIME
// need tiny transfer to register define
#define AWTIME_COUNT(ms) \
    (uint16_t)((((uint32_t)ms * 1000 *1000) / ATIME_DIG_DUTY_CYCLE) / 256)
#define ALS_PERSIST(p) (uint8_t)((p & 0x0) << 4)

#ifndef MAX
#define MAX(a, b)    (((a) > (b)) ? (a) : (b))
#endif /* MAX */
#ifndef MIN
#define MIN(a, b)    (((a) < (b)) ? (a) : (b))
#endif /* MIN */
#ifndef ABS
#define ABS(a)       ((a) >= 0 ? (a) : (-(a)))
#endif /* ABS */

#define Default_ITIME 100
#define Default_IGAIN 128
#define Default_AWTIME 100
#define Default_PWTIME 50
#define Default_PTIME 10
#define LOW_AUTO_GAIN_VALUE 3
#define AUTO_GAIN_DIV 2
#define SATURATION_LOW_PERCENT 800
#define SATURATION_HIGH_PERCENT 1000
#define LOWEST_GAIN_ID 0
#define INTEGER_SIZE 12
#define MAX_GAIN_ID 12


/* For Contamination */
/* Contamination THRESHOLD need Adjust next step */
#define SIP1221lr1s_CONTAMINATED_COUNT 16
#define SIP1221lr1s_THRESH_CONTAMINATED 400000
#define SIP1221lr1s_DATA_JITTER_TH 15000
#define SIP1221lr1s_VERY_NEAR_THRESHOLD 600000
#define SIP1221lr1s_PROX_MAX_VALUE 1500000
#define MAX_ALS_VALUE 0xFFFF
#define SIP1221lr1s_MAX_LUX 0xFFFF

#define ALS_POLLING_TIME   101
#define PS_POLLING_TIME   105
#define USE_INTERRUPT_MODE                0
#define PDATA_INCLUDE_XTALK               1 // if is 1, all pdata include xtalk
#define USE_LUX_COEF_OPTION               1
#define EN_SHUNT_GAIN                     0
#define OPTION_DUMP_REGISTER              0
#define ALS_WAIT_TIMEOUT_OPTION           0
#define EN_SPOT_ALGORITHM                 1
#define USE_SERIAL_WORK_MODE_OPTION       0
#define USE_DIR_MODE                      1
#define SIP1221LR1S_SUPPORT_DUMP          0
#define POFFSET_STEP                  6
#define MAX_RANGE_COUNT               12
#define MAX_POFFSET_COUNT             31
#define SIP_PS_WINDOWS_NUM            0

#define I2C_SPEED           400000
#define MAX_DETECT_RETRY_TIMES       (5)
#define UNIT_MS_TO_NS       1000000
#define ALS_DELAY_TIME      (100 * UNIT_MS_TO_NS)
#define PS_DELAY_TIME       (100 * UNIT_MS_TO_NS)
#define SIP1221LR1S_LUX_AVERAGE_COUNT     5

#ifndef ARR_SIZE
#define ARR_SIZE(arr)                 (sizeof(arr)/sizeof(arr[0]))
#endif /* ARR_SIZE */

#define SIP_ASSERT(exp) do { \
    int res = exp;\
    if (res < 0) { \
        log_e("error code = %d", res); \
        return -1;\
    } \
} while (0)

#define SIP_VERIFY(exp) do { \
    if (!(exp)) { \
        return -1;\
    } \
} while (0)

#define SIP_VERIFY2(exp, format, ...) do { \
    if (!(exp)) { \
        log_e(format, ##__VA_ARGS__); \
        return -1;\
    } \
} while (0)

#define SIP_COMPARE(actual, expected) do { \
    if (actual != expected) { \
        log_e("actual = %d, expected = %d", actual, expected); \
        return -1;\
    } \
} while (0)


typedef struct {
    int32_t           k_DA_01;
    int32_t           k_DA_02;
    int32_t           k_DA_03;
    int32_t           k_DA_11;
    int32_t           k_DA_12;
    int32_t           k_DA_13;
    int32_t           k_D_01;
    int32_t           k_D_02;
    int32_t           k_D_03;
    int32_t           k_D_11;
    int32_t           k_D_12;
    int32_t           k_D_13;
    int32_t           k_AH_01;
    int32_t           k_AH_02;
    int32_t           k_AH_03;
    int32_t           k_AH_11;
    int32_t           k_AH_12;
    int32_t           k_AH_13;
    int32_t           t_ratio_CD;
    int32_t           t_ratio_DA;
    int32_t           t_ratio_AH;
    int32_t           k_C_ch0;
    int32_t           k_C_ch1;
    int32_t           k_D_ch0;
    int32_t           k_D_ch1;
    int32_t           k_A_ch0;
    int32_t           k_A_ch1;
    int32_t           k_H_ch0;
    int32_t           k_H_ch1;
} sip1221lr1s_spectral_param;

enum {
    C_LIGHT,
    D50_LIGHT,
    D65_LIGHT,
    A_LIGHT,
    H_LIGHT,
};

enum lcd_panel_type {
    PRIMARY_LCD_PANEL = 11,
    SECONDARY_LCD_PANEL,
    TERTIARY_LCD_PANEL,
    FOURTH_LCD_PANEL,
    FIFTH_LCD_PANEL,
    SIXTH_LCD_PANEL,
    SEVENTH_LCD_PANEL,
    MAX_LCD_PANEL,
};

typedef struct {
    int (*write_reg)(uint8_t addr, uint8_t value);
    int (*write_regs)(uint8_t addr, uint8_t *p_value, uint8_t count);
    int (*read_reg)(uint8_t addr, uint8_t *value);
    int (*read_regs)(uint8_t addr, uint8_t *p_value, uint8_t count);
    int (*modify_reg)(uint8_t addr, uint8_t value, uint8_t mask);
    int (*check_reg)(uint8_t addr, uint8_t value, uint8_t mask);
} sip_i2c_info_t;

typedef struct
{
    struct {
        uint8_t         gain0_count;
        uint8_t         gain1_count;
        uint16_t        short_inte_time; // ms
        uint16_t        long_inte_time; // ms
        bool            is_dri;
    } conf;

    struct {
        uint16_t        raw[2]; // channels
        uint16_t        lux_raw;
        uint32_t        ir_ratio;   //*1000
        uint64_t        lux;
    } out;

    struct {
        int             target_ch0;
        int             target_ch1;
        int             target_lux;
        uint32_t        dark_ch0_coef;
        uint32_t        dark_ch1_coef;
        uint32_t        dark_lux_coef;
        uint32_t        light_ch0_coef; // target_ch0 / cali_ch0
        uint32_t        light_ch1_coef; // target_ch1 / cali_ch1
        uint32_t        light_lux_coef; // target_lux / cali_lux
        uint32_t        cali_count;
        uint8_t         cali_result;
    } cali;

    struct {
        uint16_t        inte_time; // ms
        uint16_t        max_range; // count
        uint8_t         gain0_count;
        uint8_t         gain1_count;
        uint32_t        tgain0;
        uint32_t        tgain1;
        uint32_t        cpl0;
        uint32_t        cpl1;
        uint32_t        brightness;
        int32_t         lcd_type;
    } tmp;

    const sip1221lr1s_spectral_param *sp;

    struct {
        uint8_t         data_valid;
        uint8_t         int_status;
        uint8_t         enable_status;
        uint8_t         data_invalid_times;
        bool            enabled;
        bool            raw_enabled;
        bool            first_frame_flag_after_enable;
        bool            data_changed;
        bool            cali_enable;
    } stat;

} sip1221lr1s_als_info_t;

enum ALS_CONTROL_CMD
{
    ALS_DISABLE_CMD = 0x00,
    ALS_ENABLE_CMD,
    ALS_CALI_CMD,
    ALS_CONFIT_CMD,

    //some status
    ALS_CALI_INIT = 128,
    ALS_CALI_FAIL = 129,
    ALS_CALI_SUCCESS = 130,
};

struct sip1221lr1s_device
{
    int irq;
    int irq_gpio;
    uint32_t irq_gpio_flags;
    struct i2c_client * client;

    struct timer_list als_timer;
    struct timer_list als_cali_timer;
    struct work_struct als_work;
    struct work_struct als_cali_work;

    bool als_data_is_ready;
    bool ps_data_is_ready;
    wait_queue_head_t wait;

    struct proc_dir_entry *si_sensor_proc;

    sip_i2c_info_t iinfo;
    sip1221lr1s_als_info_t ainfo;
};

typedef struct {
    uint8_t reg;
    uint8_t value;
} sip_reg_t;

typedef struct {
    uint32_t    tgain; // theory
    uint32_t    rgain; // real
} sip_als_gain_info_t;

#endif