/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright 2018-2020 NXP.
 */


#ifndef __DCSS_HDR10_TABLES_H__
#define __DCSS_HDR10_TABLES_H__

static const u32 dcss_cscas[20][29] = {
	{0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0},
	{0x3, 0x4000, 0x0, 0x5c45, 0x4000, 0xfffff5b6, 0xffffdc41, 0x4000,
	0x75b9, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x36c, 0x36c, 0x36c},
	{0x3, 0x36ce, 0x0, 0x50d1, 0x36ce, 0xfffff6fd, 0xffffe0b1, 0x36ce,
	0x671c, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36c, 0x36c,
	0x36c},
	{0x3, 0x4000, 0x0, 0x628a, 0x4000, 0xfffff449, 0xffffe2b7, 0x4000,
	0x741c, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x36c, 0x36c, 0x36c},
	{0x3, 0x4000, 0x0, 0x57ba, 0x4000, 0xffffea79, 0xffffd352, 0x4000,
	0x6ee1, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x36c, 0x36c, 0x36c},
	{0x3, 0x36ce, 0x0, 0x564e, 0x36ce, 0xfffff5bd, 0xffffe65a, 0x36ce,
	0x65b2, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36c, 0x36c,
	0x36c},
	{0x3, 0x36ce, 0x0, 0x4cd6, 0x36ce, 0xffffed25, 0xffffd8de, 0x36ce,
	0x611d, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x36c, 0x36c,
	0x36c},
	{0x1, 0x4abe, 0x0, 0x0, 0x0, 0x4abe, 0x0, 0x0, 0x0, 0x4abe, 0xffffffc0,
	0xffffffc0, 0xffffffc0, 0x0, 0x0, 0x0, 0x36c, 0x36c, 0x36c, 0xe, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x255f, 0x0, 0x35e1, 0x255f, 0xfffff9fe, 0xffffeb21, 0x255f,
	0x44bd, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x4000, 0x0, 0x5e60, 0x4000, 0xfffff579, 0xffffdb70, 0x4000,
	0x7869, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff},
	{0x3, 0x255f, 0x0, 0x398a, 0x255f, 0xfffff929, 0xffffeee7, 0x255f,
	0x43cc, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x255f, 0x0, 0x333a, 0x255f, 0xfffff36f, 0xffffe5ea, 0x255f,
	0x40be, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xd, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x4000, 0x0, 0x64ca, 0x4000, 0xfffff404, 0xffffe20c, 0x4000,
	0x76c3, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff},
	{0x3, 0x4000, 0x0, 0x59bb, 0x4000, 0xffffe9fb, 0xffffd24d, 0x4000,
	0x7169, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff},
	{0x3, 0x4176, 0x0, 0x5e60, 0x4176, 0xfffff579, 0xffffdb70, 0x4176,
	0x7869, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x380, 0x380, 0x380},
	{0x3, 0x380e, 0x0, 0x52a9, 0x380e, 0xfffff6c8, 0xffffdffa, 0x380e,
	0x6977, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380},
	{0x3, 0x4176, 0x0, 0x64ca, 0x4176, 0xfffff404, 0xffffe20c, 0x4176,
	0x76c3, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x380, 0x380, 0x380},
	{0x3, 0x4176, 0x0, 0x59bb, 0x4176, 0xffffe9fb, 0xffffd24d, 0x4176,
	0x7169, 0x0, 0xffffffc0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe40,
	0xfffffe40, 0x36c, 0x1c0, 0x1c0, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x380, 0x380, 0x380},
	{0x3, 0x380e, 0x0, 0x5847, 0x380e, 0xfffff581, 0xffffe5c4, 0x380e,
	0x6804, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380},
	{0x3, 0x380e, 0x0, 0x4e97, 0x380e, 0xffffecb7, 0xffffd7fa, 0x380e,
	0x6355, 0x0, 0x0, 0xfffffe00, 0xfffffe00, 0x0, 0xfffffe00, 0xfffffe00,
	0x3ff, 0x1ff, 0x1ff, 0xe, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380},
};

static const u16 dcss_iluts[11][1026] = {
	{0x3, 0x0, 0x200, 0x600, 0x840, 0x9c0, 0xac0, 0xbe0, 0xc90, 0xd40,
	0xe08, 0xe78, 0xef0, 0xf78, 0x1008, 0x1054, 0x10ac, 0x1108, 0x116c,
	0x11d4, 0x1222, 0x125c, 0x129c, 0x12de, 0x1324, 0x136e, 0x13ba, 0x1406,
	0x1430, 0x145d, 0x148c, 0x14bc, 0x14ef, 0x1524, 0x155b, 0x1595, 0x15d1,
	0x1607, 0x1627, 0x1649, 0x166b, 0x168f, 0x16b5, 0x16db, 0x1703, 0x172c,
	0x1757, 0x1783, 0x17b1, 0x17e0, 0x1808, 0x1821, 0x183a, 0x1855, 0x1870,
	0x188c, 0x18a9, 0x18c7, 0x18e6, 0x1905, 0x1926, 0x1947, 0x1969, 0x198c,
	0x19b1, 0x19d6, 0x19fc, 0x1a11, 0x1a25, 0x1a3a, 0x1a4f, 0x1a64, 0x1a7a,
	0x1a91, 0x1aa8, 0x1ac0, 0x1ad8, 0x1af1, 0x1b0b, 0x1b25, 0x1b3f, 0x1b5b,
	0x1b77, 0x1b93, 0x1bb0, 0x1bce, 0x1bed, 0x1c06, 0x1c16, 0x1c26, 0x1c37,
	0x1c48, 0x1c59, 0x1c6b, 0x1c7d, 0x1c8f, 0x1ca2, 0x1cb6, 0x1cc9, 0x1cdd,
	0x1cf2, 0x1d07, 0x1d1c, 0x1d32, 0x1d48, 0x1d5f, 0x1d76, 0x1d8d, 0x1da5,
	0x1dbd, 0x1dd6, 0x1df0, 0x1e04, 0x1e12, 0x1e1f, 0x1e2d, 0x1e3b, 0x1e49,
	0x1e57, 0x1e66, 0x1e75, 0x1e84, 0x1e94, 0x1ea4, 0x1eb4, 0x1ec4, 0x1ed5,
	0x1ee6, 0x1ef7, 0x1f08, 0x1f1a, 0x1f2c, 0x1f3f, 0x1f52, 0x1f65, 0x1f78,
	0x1f8c, 0x1fa0, 0x1fb5, 0x1fca, 0x1fdf, 0x1ff4, 0x2005, 0x2010, 0x201b,
	0x2027, 0x2032, 0x203e, 0x204a, 0x2057, 0x2063, 0x2070, 0x207d, 0x208a,
	0x2097, 0x20a4, 0x20b2, 0x20c0, 0x20ce, 0x20dd, 0x20eb, 0x20fa, 0x2109,
	0x2118, 0x2128, 0x2138, 0x2148, 0x2158, 0x2168, 0x2179, 0x218a, 0x219b,
	0x21ad, 0x21bf, 0x21d1, 0x21e3, 0x21f6, 0x2204, 0x220e, 0x2217, 0x2221,
	0x222b, 0x2235, 0x2240, 0x224a, 0x2255, 0x225f, 0x226a, 0x2275, 0x2281,
	0x228c, 0x2298, 0x22a3, 0x22af, 0x22bb, 0x22c8, 0x22d4, 0x22e1, 0x22ed,
	0x22fa, 0x2307, 0x2315, 0x2322, 0x2330, 0x233e, 0x234c, 0x235a, 0x2368,
	0x2377, 0x2386, 0x2395, 0x23a4, 0x23b4, 0x23c3, 0x23d3, 0x23e3, 0x23f4,
	0x2402, 0x240a, 0x2413, 0x241b, 0x2424, 0x242d, 0x2436, 0x243f, 0x2448,
	0x2452, 0x245b, 0x2465, 0x246e, 0x2478, 0x2482, 0x248c, 0x2496, 0x24a1,
	0x24ab, 0x24b6, 0x24c1, 0x24cc, 0x24d7, 0x24e2, 0x24ed, 0x24f9, 0x2504,
	0x2510, 0x251c, 0x2528, 0x2534, 0x2541, 0x254d, 0x255a, 0x2567, 0x2574,
	0x2581, 0x258f, 0x259c, 0x25aa, 0x25b8, 0x25c6, 0x25d4, 0x25e3, 0x25f1,
	0x2600, 0x2607, 0x260f, 0x2616, 0x261e, 0x2626, 0x262e, 0x2636, 0x263e,
	0x2647, 0x264f, 0x2657, 0x2660, 0x2669, 0x2671, 0x267a, 0x2683, 0x268c,
	0x2696, 0x269f, 0x26a8, 0x26b2, 0x26bc, 0x26c5, 0x26cf, 0x26d9, 0x26e4,
	0x26ee, 0x26f8, 0x2703, 0x270d, 0x2718, 0x2723, 0x272e, 0x2739, 0x2745,
	0x2750, 0x275c, 0x2767, 0x2773, 0x277f, 0x278b, 0x2798, 0x27a4, 0x27b1,
	0x27bd, 0x27ca, 0x27d7, 0x27e4, 0x27f2, 0x27ff, 0x2806, 0x280d, 0x2814,
	0x281b, 0x2822, 0x2829, 0x2831, 0x2838, 0x2840, 0x2847, 0x284f, 0x2857,
	0x285e, 0x2866, 0x286e, 0x2877, 0x287f, 0x2887, 0x288f, 0x2898, 0x28a1,
	0x28a9, 0x28b2, 0x28bb, 0x28c4, 0x28cd, 0x28d6, 0x28df, 0x28e9, 0x28f2,
	0x28fc, 0x2906, 0x2910, 0x291a, 0x2924, 0x292e, 0x2938, 0x2942, 0x294d,
	0x2958, 0x2962, 0x296d, 0x2978, 0x2983, 0x298f, 0x299a, 0x29a6, 0x29b1,
	0x29bd, 0x29c9, 0x29d5, 0x29e1, 0x29ee, 0x29fa, 0x2a03, 0x2a09, 0x2a10,
	0x2a16, 0x2a1d, 0x2a24, 0x2a2a, 0x2a31, 0x2a38, 0x2a3f, 0x2a46, 0x2a4d,
	0x2a54, 0x2a5c, 0x2a63, 0x2a6a, 0x2a72, 0x2a79, 0x2a81, 0x2a89, 0x2a91,
	0x2a99, 0x2aa1, 0x2aa9, 0x2ab1, 0x2ab9, 0x2ac2, 0x2aca, 0x2ad3, 0x2adb,
	0x2ae4, 0x2aed, 0x2af6, 0x2aff, 0x2b08, 0x2b11, 0x2b1b, 0x2b24, 0x2b2e,
	0x2b37, 0x2b41, 0x2b4b, 0x2b55, 0x2b5f, 0x2b69, 0x2b73, 0x2b7e, 0x2b88,
	0x2b93, 0x2b9e, 0x2ba9, 0x2bb3, 0x2bbf, 0x2bca, 0x2bd5, 0x2be1, 0x2bec,
	0x2bf8, 0x2c02, 0x2c08, 0x2c0e, 0x2c14, 0x2c1a, 0x2c20, 0x2c26, 0x2c2d,
	0x2c33, 0x2c3a, 0x2c40, 0x2c47, 0x2c4e, 0x2c55, 0x2c5b, 0x2c62, 0x2c69,
	0x2c71, 0x2c78, 0x2c7f, 0x2c86, 0x2c8e, 0x2c95, 0x2c9d, 0x2ca4, 0x2cac,
	0x2cb4, 0x2cbc, 0x2cc4, 0x2ccc, 0x2cd4, 0x2cdc, 0x2ce4, 0x2ced, 0x2cf5,
	0x2cfe, 0x2d07, 0x2d0f, 0x2d18, 0x2d21, 0x2d2a, 0x2d33, 0x2d3d, 0x2d46,
	0x2d4f, 0x2d59, 0x2d63, 0x2d6c, 0x2d76, 0x2d80, 0x2d8a, 0x2d94, 0x2d9f,
	0x2da9, 0x2db3, 0x2dbe, 0x2dc9, 0x2dd4, 0x2dde, 0x2dea, 0x2df5, 0x2e00,
	0x2e05, 0x2e0b, 0x2e11, 0x2e17, 0x2e1d, 0x2e23, 0x2e29, 0x2e2f, 0x2e35,
	0x2e3b, 0x2e42, 0x2e48, 0x2e4f, 0x2e55, 0x2e5c, 0x2e62, 0x2e69, 0x2e70,
	0x2e77, 0x2e7e, 0x2e85, 0x2e8c, 0x2e93, 0x2e9a, 0x2ea2, 0x2ea9, 0x2eb1,
	0x2eb8, 0x2ec0, 0x2ec7, 0x2ecf, 0x2ed7, 0x2edf, 0x2ee7, 0x2eef, 0x2ef7,
	0x2f00, 0x2f08, 0x2f11, 0x2f19, 0x2f22, 0x2f2a, 0x2f33, 0x2f3c, 0x2f45,
	0x2f4e, 0x2f58, 0x2f61, 0x2f6a, 0x2f74, 0x2f7d, 0x2f87, 0x2f91, 0x2f9b,
	0x2fa5, 0x2faf, 0x2fb9, 0x2fc3, 0x2fce, 0x2fd8, 0x2fe3, 0x2fee, 0x2ff8,
	0x3001, 0x3007, 0x300d, 0x3012, 0x3018, 0x301e, 0x3024, 0x3029, 0x302f,
	0x3035, 0x303c, 0x3042, 0x3048, 0x304e, 0x3055, 0x305b, 0x3061, 0x3068,
	0x306f, 0x3075, 0x307c, 0x3083, 0x308a, 0x3091, 0x3098, 0x309f, 0x30a6,
	0x30ad, 0x30b4, 0x30bc, 0x30c3, 0x30cb, 0x30d3, 0x30da, 0x30e2, 0x30ea,
	0x30f2, 0x30fa, 0x3102, 0x310a, 0x3113, 0x311b, 0x3123, 0x312c, 0x3135,
	0x313d, 0x3146, 0x314f, 0x3158, 0x3161, 0x316a, 0x3174, 0x317d, 0x3187,
	0x3190, 0x319a, 0x31a4, 0x31ad, 0x31b7, 0x31c2, 0x31cc, 0x31d6, 0x31e0,
	0x31eb, 0x31f6, 0x3200, 0x3205, 0x320b, 0x3210, 0x3216, 0x321c, 0x3221,
	0x3227, 0x322d, 0x3233, 0x3239, 0x323f, 0x3245, 0x324b, 0x3251, 0x3258,
	0x325e, 0x3264, 0x326b, 0x3271, 0x3278, 0x327f, 0x3285, 0x328c, 0x3293,
	0x329a, 0x32a1, 0x32a8, 0x32af, 0x32b6, 0x32be, 0x32c5, 0x32cd, 0x32d4,
	0x32dc, 0x32e4, 0x32eb, 0x32f3, 0x32fb, 0x3303, 0x330b, 0x3314, 0x331c,
	0x3324, 0x332d, 0x3335, 0x333e, 0x3347, 0x3350, 0x3358, 0x3361, 0x336b,
	0x3374, 0x337d, 0x3387, 0x3390, 0x339a, 0x33a3, 0x33ad, 0x33b7, 0x33c1,
	0x33cb, 0x33d5, 0x33e0, 0x33ea, 0x33f5, 0x33ff, 0x3405, 0x340a, 0x3410,
	0x3415, 0x341b, 0x3421, 0x3426, 0x342c, 0x3432, 0x3438, 0x343e, 0x3444,
	0x344a, 0x3450, 0x3456, 0x345d, 0x3463, 0x346a, 0x3470, 0x3477, 0x347d,
	0x3484, 0x348b, 0x3492, 0x3498, 0x349f, 0x34a7, 0x34ae, 0x34b5, 0x34bc,
	0x34c4, 0x34cb, 0x34d3, 0x34da, 0x34e2, 0x34ea, 0x34f1, 0x34f9, 0x3501,
	0x350a, 0x3512, 0x351a, 0x3522, 0x352b, 0x3533, 0x353c, 0x3545, 0x354e,
	0x3557, 0x3560, 0x3569, 0x3572, 0x357b, 0x3585, 0x358e, 0x3598, 0x35a1,
	0x35ab, 0x35b5, 0x35bf, 0x35c9, 0x35d3, 0x35de, 0x35e8, 0x35f3, 0x35fe,
	0x3604, 0x3609, 0x360f, 0x3614, 0x361a, 0x3620, 0x3626, 0x362b, 0x3631,
	0x3637, 0x363d, 0x3643, 0x3649, 0x3650, 0x3656, 0x365c, 0x3663, 0x3669,
	0x3670, 0x3676, 0x367d, 0x3684, 0x368a, 0x3691, 0x3698, 0x369f, 0x36a7,
	0x36ae, 0x36b5, 0x36bc, 0x36c4, 0x36cb, 0x36d3, 0x36db, 0x36e2, 0x36ea,
	0x36f2, 0x36fa, 0x3702, 0x370b, 0x3713, 0x371b, 0x3724, 0x372c, 0x3735,
	0x373e, 0x3747, 0x374f, 0x3758, 0x3762, 0x376b, 0x3774, 0x377e, 0x3787,
	0x3791, 0x379b, 0x37a4, 0x37ae, 0x37b9, 0x37c3, 0x37cd, 0x37d7, 0x37e2,
	0x37ed, 0x37f7, 0x3801, 0x3806, 0x380c, 0x3812, 0x3817, 0x381d, 0x3823,
	0x3829, 0x382f, 0x3835, 0x383b, 0x3841, 0x3847, 0x384d, 0x3854, 0x385a,
	0x3861, 0x3867, 0x386e, 0x3874, 0x387b, 0x3882, 0x3889, 0x3890, 0x3897,
	0x389e, 0x38a6, 0x38ad, 0x38b4, 0x38bc, 0x38c3, 0x38cb, 0x38d3, 0x38db,
	0x38e3, 0x38eb, 0x38f3, 0x38fb, 0x3903, 0x390b, 0x3914, 0x391c, 0x3925,
	0x392e, 0x3937, 0x3940, 0x3949, 0x3952, 0x395b, 0x3965, 0x396e, 0x3978,
	0x3981, 0x398b, 0x3995, 0x399f, 0x39a9, 0x39b3, 0x39be, 0x39c8, 0x39d3,
	0x39de, 0x39e8, 0x39f3, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x3},
	{0x3, 0x0, 0x200, 0x500, 0x700, 0x8c0, 0xa20, 0xae0, 0xbe0, 0xc70,
	0xd00, 0xdb0, 0xe30, 0xe98, 0xf00, 0xf78, 0xff8, 0x103c, 0x1084,
	0x10d0, 0x1120, 0x1178, 0x11d0, 0x1218, 0x124a, 0x127e, 0x12b6, 0x12f0,
	0x132c, 0x136c, 0x13ae, 0x13f2, 0x141d, 0x1442, 0x1469, 0x1491, 0x14bb,
	0x14e6, 0x1513, 0x1542, 0x1572, 0x15a4, 0x15d7, 0x1606, 0x1621, 0x163e,
	0x165b, 0x1679, 0x1698, 0x16b9, 0x16da, 0x16fc, 0x171f, 0x1743, 0x1768,
	0x178e, 0x17b5, 0x17dd, 0x1803, 0x1818, 0x182e, 0x1844, 0x185b, 0x1873,
	0x188b, 0x18a4, 0x18bd, 0x18d7, 0x18f2, 0x190d, 0x1929, 0x1945, 0x1962,
	0x1980, 0x199f, 0x19be, 0x19de, 0x19ff, 0x1a10, 0x1a21, 0x1a32, 0x1a44,
	0x1a56, 0x1a69, 0x1a7c, 0x1a8f, 0x1aa3, 0x1ab7, 0x1acc, 0x1ae1, 0x1af6,
	0x1b0c, 0x1b23, 0x1b39, 0x1b51, 0x1b68, 0x1b81, 0x1b99, 0x1bb2, 0x1bcc,
	0x1be6, 0x1c00, 0x1c0e, 0x1c1b, 0x1c29, 0x1c38, 0x1c46, 0x1c55, 0x1c64,
	0x1c74, 0x1c83, 0x1c93, 0x1ca3, 0x1cb4, 0x1cc5, 0x1cd6, 0x1ce7, 0x1cf9,
	0x1d0b, 0x1d1d, 0x1d30, 0x1d42, 0x1d56, 0x1d69, 0x1d7d, 0x1d91, 0x1da6,
	0x1dbb, 0x1dd0, 0x1de6, 0x1dfc, 0x1e09, 0x1e14, 0x1e20, 0x1e2b, 0x1e37,
	0x1e43, 0x1e4f, 0x1e5c, 0x1e69, 0x1e75, 0x1e82, 0x1e90, 0x1e9d, 0x1eab,
	0x1eb9, 0x1ec7, 0x1ed5, 0x1ee3, 0x1ef2, 0x1f01, 0x1f10, 0x1f20, 0x1f2f,
	0x1f3f, 0x1f4f, 0x1f60, 0x1f70, 0x1f81, 0x1f92, 0x1fa3, 0x1fb5, 0x1fc7,
	0x1fd9, 0x1feb, 0x1ffe, 0x2008, 0x2012, 0x201b, 0x2025, 0x202f, 0x2039,
	0x2043, 0x204e, 0x2058, 0x2063, 0x206e, 0x2079, 0x2084, 0x208f, 0x209b,
	0x20a6, 0x20b2, 0x20be, 0x20ca, 0x20d6, 0x20e3, 0x20ef, 0x20fc, 0x2109,
	0x2116, 0x2123, 0x2131, 0x213e, 0x214c, 0x215a, 0x2168, 0x2176, 0x2185,
	0x2194, 0x21a2, 0x21b2, 0x21c1, 0x21d0, 0x21e0, 0x21f0, 0x2200, 0x2208,
	0x2210, 0x2218, 0x2221, 0x2229, 0x2232, 0x223b, 0x2244, 0x224d, 0x2256,
	0x225f, 0x2268, 0x2272, 0x227b, 0x2285, 0x228f, 0x2299, 0x22a3, 0x22ad,
	0x22b7, 0x22c2, 0x22cc, 0x22d7, 0x22e2, 0x22ed, 0x22f8, 0x2303, 0x230e,
	0x231a, 0x2325, 0x2331, 0x233d, 0x2349, 0x2355, 0x2361, 0x236e, 0x237a,
	0x2387, 0x2394, 0x23a1, 0x23ae, 0x23bc, 0x23c9, 0x23d7, 0x23e5, 0x23f3,
	0x2400, 0x2407, 0x240f, 0x2416, 0x241d, 0x2425, 0x242c, 0x2434, 0x243c,
	0x2444, 0x244c, 0x2454, 0x245c, 0x2464, 0x246c, 0x2475, 0x247d, 0x2486,
	0x248e, 0x2497, 0x24a0, 0x24a9, 0x24b2, 0x24bb, 0x24c4, 0x24ce, 0x24d7,
	0x24e1, 0x24eb, 0x24f4, 0x24fe, 0x2508, 0x2512, 0x251d, 0x2527, 0x2531,
	0x253c, 0x2547, 0x2552, 0x255d, 0x2568, 0x2573, 0x257e, 0x2589, 0x2595,
	0x25a1, 0x25ac, 0x25b8, 0x25c4, 0x25d1, 0x25dd, 0x25e9, 0x25f6, 0x2601,
	0x2607, 0x260e, 0x2614, 0x261b, 0x2622, 0x2629, 0x262f, 0x2636, 0x263d,
	0x2644, 0x264c, 0x2653, 0x265a, 0x2661, 0x2669, 0x2670, 0x2678, 0x2680,
	0x2687, 0x268f, 0x2697, 0x269f, 0x26a7, 0x26af, 0x26b8, 0x26c0, 0x26c8,
	0x26d1, 0x26d9, 0x26e2, 0x26eb, 0x26f4, 0x26fd, 0x2706, 0x270f, 0x2718,
	0x2722, 0x272b, 0x2734, 0x273e, 0x2748, 0x2752, 0x275c, 0x2766, 0x2770,
	0x277a, 0x2784, 0x278f, 0x2799, 0x27a4, 0x27af, 0x27b9, 0x27c4, 0x27d0,
	0x27db, 0x27e6, 0x27f1, 0x27fd, 0x2804, 0x280a, 0x2810, 0x2816, 0x281c,
	0x2822, 0x2828, 0x282f, 0x2835, 0x283b, 0x2842, 0x2848, 0x284f, 0x2855,
	0x285c, 0x2863, 0x286a, 0x2870, 0x2877, 0x287e, 0x2886, 0x288d, 0x2894,
	0x289b, 0x28a3, 0x28aa, 0x28b2, 0x28b9, 0x28c1, 0x28c9, 0x28d0, 0x28d8,
	0x28e0, 0x28e8, 0x28f1, 0x28f9, 0x2901, 0x2909, 0x2912, 0x291a, 0x2923,
	0x292c, 0x2935, 0x293d, 0x2946, 0x294f, 0x2959, 0x2962, 0x296b, 0x2975,
	0x297e, 0x2988, 0x2991, 0x299b, 0x29a5, 0x29af, 0x29b9, 0x29c3, 0x29cd,
	0x29d8, 0x29e2, 0x29ed, 0x29f7, 0x2a01, 0x2a06, 0x2a0c, 0x2a11, 0x2a17,
	0x2a1c, 0x2a22, 0x2a28, 0x2a2e, 0x2a33, 0x2a39, 0x2a3f, 0x2a45, 0x2a4b,
	0x2a52, 0x2a58, 0x2a5e, 0x2a64, 0x2a6b, 0x2a71, 0x2a78, 0x2a7e, 0x2a85,
	0x2a8b, 0x2a92, 0x2a99, 0x2aa0, 0x2aa7, 0x2aae, 0x2ab5, 0x2abc, 0x2ac3,
	0x2aca, 0x2ad2, 0x2ad9, 0x2ae1, 0x2ae8, 0x2af0, 0x2af7, 0x2aff, 0x2b07,
	0x2b0f, 0x2b17, 0x2b1f, 0x2b27, 0x2b2f, 0x2b38, 0x2b40, 0x2b48, 0x2b51,
	0x2b59, 0x2b62, 0x2b6b, 0x2b74, 0x2b7d, 0x2b86, 0x2b8f, 0x2b98, 0x2ba1,
	0x2baa, 0x2bb4, 0x2bbd, 0x2bc7, 0x2bd0, 0x2bda, 0x2be4, 0x2bee, 0x2bf8,
	0x2c01, 0x2c06, 0x2c0b, 0x2c10, 0x2c16, 0x2c1b, 0x2c20, 0x2c26, 0x2c2b,
	0x2c31, 0x2c36, 0x2c3c, 0x2c41, 0x2c47, 0x2c4d, 0x2c53, 0x2c59, 0x2c5e,
	0x2c64, 0x2c6a, 0x2c70, 0x2c77, 0x2c7d, 0x2c83, 0x2c89, 0x2c90, 0x2c96,
	0x2c9d, 0x2ca3, 0x2caa, 0x2cb0, 0x2cb7, 0x2cbe, 0x2cc5, 0x2ccc, 0x2cd3,
	0x2cda, 0x2ce1, 0x2ce8, 0x2cef, 0x2cf6, 0x2cfe, 0x2d05, 0x2d0d, 0x2d14,
	0x2d1c, 0x2d24, 0x2d2b, 0x2d33, 0x2d3b, 0x2d43, 0x2d4b, 0x2d53, 0x2d5b,
	0x2d64, 0x2d6c, 0x2d74, 0x2d7d, 0x2d85, 0x2d8e, 0x2d97, 0x2da0, 0x2da9,
	0x2db2, 0x2dbb, 0x2dc4, 0x2dcd, 0x2dd6, 0x2de0, 0x2de9, 0x2df3, 0x2dfc,
	0x2e03, 0x2e08, 0x2e0d, 0x2e12, 0x2e17, 0x2e1c, 0x2e21, 0x2e26, 0x2e2b,
	0x2e30, 0x2e36, 0x2e3b, 0x2e41, 0x2e46, 0x2e4c, 0x2e51, 0x2e57, 0x2e5c,
	0x2e62, 0x2e68, 0x2e6e, 0x2e73, 0x2e79, 0x2e7f, 0x2e85, 0x2e8b, 0x2e92,
	0x2e98, 0x2e9e, 0x2ea4, 0x2eab, 0x2eb1, 0x2eb8, 0x2ebe, 0x2ec5, 0x2ecb,
	0x2ed2, 0x2ed9, 0x2ee0, 0x2ee6, 0x2eed, 0x2ef4, 0x2efb, 0x2f03, 0x2f0a,
	0x2f11, 0x2f18, 0x2f20, 0x2f27, 0x2f2f, 0x2f36, 0x2f3e, 0x2f46, 0x2f4e,
	0x2f55, 0x2f5d, 0x2f65, 0x2f6d, 0x2f76, 0x2f7e, 0x2f86, 0x2f8e, 0x2f97,
	0x2f9f, 0x2fa8, 0x2fb1, 0x2fb9, 0x2fc2, 0x2fcb, 0x2fd4, 0x2fdd, 0x2fe6,
	0x2ff0, 0x2ff9, 0x3001, 0x3006, 0x300a, 0x300f, 0x3014, 0x3019, 0x301e,
	0x3023, 0x3028, 0x302d, 0x3032, 0x3037, 0x303d, 0x3042, 0x3047, 0x304d,
	0x3052, 0x3057, 0x305d, 0x3062, 0x3068, 0x306e, 0x3073, 0x3079, 0x307f,
	0x3085, 0x308b, 0x3091, 0x3097, 0x309d, 0x30a3, 0x30a9, 0x30af, 0x30b6,
	0x30bc, 0x30c2, 0x30c9, 0x30cf, 0x30d6, 0x30dd, 0x30e3, 0x30ea, 0x30f1,
	0x30f8, 0x30ff, 0x3106, 0x310d, 0x3114, 0x311b, 0x3122, 0x3129, 0x3131,
	0x3138, 0x3140, 0x3147, 0x314f, 0x3157, 0x315e, 0x3166, 0x316e, 0x3176,
	0x317e, 0x3186, 0x318f, 0x3197, 0x319f, 0x31a8, 0x31b0, 0x31b9, 0x31c1,
	0x31ca, 0x31d3, 0x31dc, 0x31e5, 0x31ee, 0x31f7, 0x3200, 0x3204, 0x3209,
	0x320e, 0x3213, 0x3217, 0x321c, 0x3221, 0x3226, 0x322b, 0x3230, 0x3235,
	0x323a, 0x323f, 0x3245, 0x324a, 0x324f, 0x3255, 0x325a, 0x325f, 0x3265,
	0x326a, 0x3270, 0x3276, 0x327b, 0x3281, 0x3287, 0x328d, 0x3293, 0x3299,
	0x329f, 0x32a5, 0x32ab, 0x32b1, 0x32b7, 0x32bd, 0x32c4, 0x32ca, 0x32d1,
	0x32d7, 0x32de, 0x32e4, 0x32eb, 0x32f2, 0x32f8, 0x32ff, 0x3306, 0x330d,
	0x3314, 0x331b, 0x3322, 0x332a, 0x3331, 0x3338, 0x3340, 0x3347, 0x334f,
	0x3357, 0x335e, 0x3366, 0x336e, 0x3376, 0x337e, 0x3386, 0x338e, 0x3396,
	0x339e, 0x33a7, 0x33af, 0x33b8, 0x33c0, 0x33c9, 0x33d2, 0x33da, 0x33e3,
	0x33ec, 0x33f5, 0x33fe, 0x3404, 0x3408, 0x340d, 0x3412, 0x3416, 0x341b,
	0x3420, 0x3425, 0x342a, 0x342f, 0x3434, 0x3439, 0x343e, 0x3443, 0x3448,
	0x344e, 0x3453, 0x3458, 0x345e, 0x3463, 0x3469, 0x346e, 0x3474, 0x347a,
	0x347f, 0x3485, 0x348b, 0x3491, 0x3497, 0x349d, 0x34a3, 0x34a9, 0x34af,
	0x34b5, 0x34bb, 0x34c2, 0x34c8, 0x34ce, 0x34d5, 0x34db, 0x34e2, 0x34e9,
	0x34ef, 0x34f6, 0x34fd, 0x3504, 0x350b, 0x3512, 0x3519, 0x3520, 0x3527,
	0x352f, 0x3536, 0x353d, 0x3545, 0x354c, 0x3554, 0x355c, 0x3563, 0x356b,
	0x3573, 0x357b, 0x3583, 0x358b, 0x3593, 0x359c, 0x35a4, 0x35ad, 0x35b5,
	0x35be, 0x35c6, 0x35cf, 0x35d8, 0x35e1, 0x35ea, 0x35f3, 0x35fc, 0x3602,
	0x3607, 0x360c, 0x3610, 0x3615, 0x361a, 0x361f, 0x3624, 0x3629, 0x362e,
	0x3633, 0x3638, 0x363d, 0x3642, 0x3647, 0x364d, 0x3652, 0x3657, 0x365d,
	0x3662, 0x3668, 0x366d, 0x3673, 0x3679, 0x367f, 0x3684, 0x368a, 0x3690,
	0x3696, 0x369c, 0x36a2, 0x36a8, 0x36ae, 0x36b5, 0x36bb, 0x36c1, 0x36c8,
	0x36ce, 0x36d5, 0x36db, 0x36e2, 0x36e9, 0x36f0, 0x36f6, 0x36fd, 0x3704,
	0x370b, 0x3712, 0x371a, 0x3721, 0x3728, 0x372f, 0x3737, 0x373e, 0x3746,
	0x374e, 0x3755, 0x375d, 0x3765, 0x376d, 0x3775, 0x377d, 0x3785, 0x378d,
	0x3796, 0x379e, 0x37a7, 0x37af, 0x37b8, 0x37c1, 0x37c9, 0x37d2, 0x37db,
	0x37e4, 0x37ed, 0x37f7, 0x3800, 0x3804, 0x3809, 0x380e, 0x3813, 0x3818,
	0x381d, 0x3821, 0x3826, 0x382c, 0x3831, 0x3836, 0x383b, 0x3840, 0x3846,
	0x384b, 0x3850, 0x3856, 0x385b, 0x3861, 0x3866, 0x386c, 0x3872, 0x3878,
	0x387d, 0x3883, 0x3889, 0x388f, 0x3895, 0x389b, 0x38a2, 0x38a8, 0x38ae,
	0x38b5, 0x38bb, 0x38c1, 0x38c8, 0x38cf, 0x38d5, 0x38dc, 0x38e3, 0x38ea,
	0x38f1, 0x38f8, 0x38ff, 0x3906, 0x390d, 0x3914, 0x391b, 0x3923, 0x392a,
	0x3932, 0x3939, 0x3941, 0x3949, 0x3951, 0x3959, 0x3961, 0x3969, 0x3971,
	0x3979, 0x3981, 0x398a, 0x3992, 0x399b, 0x39a3, 0x39ac, 0x39b5, 0x39be,
	0x39c7, 0x39d0, 0x39d9, 0x39e2, 0x39ec, 0x39f5, 0x39ff, 0x3},
	{0x3, 0x0, 0x4, 0x8, 0xc, 0x10, 0x14, 0x18, 0x1d, 0x21, 0x25, 0x29,
	0x2d, 0x31, 0x36, 0x3a, 0x3e, 0x42, 0x46, 0x4a, 0x4e, 0x53, 0x57, 0x5b,
	0x5f, 0x63, 0x67, 0x6c, 0x70, 0x74, 0x78, 0x7c, 0x80, 0x84, 0x89, 0x8d,
	0x91, 0x95, 0x99, 0x9d, 0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0xbb, 0xbf,
	0xc3, 0xc7, 0xcb, 0xcf, 0xd3, 0xd8, 0xdc, 0xe0, 0xe4, 0xe8, 0xec, 0xf1,
	0xf5, 0xf9, 0xfd, 0x101, 0x105, 0x109, 0x10e, 0x112, 0x116, 0x11a,
	0x11e, 0x122, 0x126, 0x12a, 0x12e, 0x132, 0x137, 0x13b, 0x13f, 0x143,
	0x148, 0x14c, 0x151, 0x155, 0x15a, 0x15e, 0x163, 0x167, 0x16c, 0x171,
	0x176, 0x17a, 0x17f, 0x184, 0x189, 0x18e, 0x193, 0x197, 0x19c, 0x1a1,
	0x1a6, 0x1ac, 0x1b1, 0x1b6, 0x1bb, 0x1c0, 0x1c5, 0x1cb, 0x1d0, 0x1d5,
	0x1db, 0x1e0, 0x1e6, 0x1eb, 0x1f1, 0x1f6, 0x1fc, 0x201, 0x207, 0x20d,
	0x212, 0x218, 0x21e, 0x224, 0x22a, 0x230, 0x235, 0x23b, 0x241, 0x247,
	0x24d, 0x254, 0x25a, 0x260, 0x266, 0x26c, 0x273, 0x279, 0x27f, 0x286,
	0x28c, 0x292, 0x299, 0x29f, 0x2a6, 0x2ad, 0x2b3, 0x2ba, 0x2c0, 0x2c7,
	0x2ce, 0x2d5, 0x2dc, 0x2e2, 0x2e9, 0x2f0, 0x2f7, 0x2fe, 0x305, 0x30c,
	0x313, 0x31b, 0x322, 0x329, 0x330, 0x338, 0x33f, 0x346, 0x34e, 0x355,
	0x35c, 0x364, 0x36c, 0x373, 0x37b, 0x382, 0x38a, 0x392, 0x399, 0x3a1,
	0x3a9, 0x3b1, 0x3b9, 0x3c1, 0x3c9, 0x3d1, 0x3d9, 0x3e1, 0x3e9, 0x3f1,
	0x3f9, 0x402, 0x40a, 0x412, 0x41a, 0x423, 0x42b, 0x434, 0x43c, 0x445,
	0x44d, 0x456, 0x45e, 0x467, 0x470, 0x478, 0x481, 0x48a, 0x493, 0x49c,
	0x4a5, 0x4ae, 0x4b7, 0x4c0, 0x4c9, 0x4d2, 0x4db, 0x4e4, 0x4ed, 0x4f7,
	0x500, 0x509, 0x513, 0x51c, 0x525, 0x52f, 0x538, 0x542, 0x54c, 0x555,
	0x55f, 0x569, 0x572, 0x57c, 0x586, 0x590, 0x59a, 0x5a4, 0x5ad, 0x5b7,
	0x5c2, 0x5cc, 0x5d6, 0x5e0, 0x5ea, 0x5f4, 0x5ff, 0x609, 0x613, 0x61e,
	0x628, 0x632, 0x63d, 0x647, 0x652, 0x65d, 0x667, 0x672, 0x67d, 0x687,
	0x692, 0x69d, 0x6a8, 0x6b3, 0x6be, 0x6c9, 0x6d4, 0x6df, 0x6ea, 0x6f5,
	0x700, 0x70c, 0x717, 0x722, 0x72d, 0x739, 0x744, 0x750, 0x75b, 0x767,
	0x772, 0x77e, 0x789, 0x795, 0x7a1, 0x7ad, 0x7b8, 0x7c4, 0x7d0, 0x7dc,
	0x7e8, 0x7f4, 0x800, 0x80c, 0x818, 0x824, 0x831, 0x83d, 0x849, 0x855,
	0x862, 0x86e, 0x87b, 0x887, 0x893, 0x8a0, 0x8ad, 0x8b9, 0x8c6, 0x8d3,
	0x8df, 0x8ec, 0x8f9, 0x906, 0x913, 0x920, 0x92d, 0x93a, 0x947, 0x954,
	0x961, 0x96e, 0x97b, 0x988, 0x996, 0x9a3, 0x9b0, 0x9be, 0x9cb, 0x9d9,
	0x9e6, 0x9f4, 0xa02, 0xa0f, 0xa1d, 0xa2b, 0xa38, 0xa46, 0xa54, 0xa62,
	0xa70, 0xa7e, 0xa8c, 0xa9a, 0xaa8, 0xab6, 0xac4, 0xad2, 0xae1, 0xaef,
	0xafd, 0xb0c, 0xb1a, 0xb29, 0xb37, 0xb46, 0xb54, 0xb63, 0xb71, 0xb80,
	0xb8f, 0xb9e, 0xbac, 0xbbb, 0xbca, 0xbd9, 0xbe8, 0xbf7, 0xc06, 0xc15,
	0xc24, 0xc34, 0xc43, 0xc52, 0xc61, 0xc71, 0xc80, 0xc90, 0xc9f, 0xcaf,
	0xcbe, 0xcce, 0xcdd, 0xced, 0xcfd, 0xd0c, 0xd1c, 0xd2c, 0xd3c, 0xd4c,
	0xd5c, 0xd6c, 0xd7c, 0xd8c, 0xd9c, 0xdac, 0xdbc, 0xdcd, 0xddd, 0xded,
	0xdfe, 0xe0e, 0xe1f, 0xe2f, 0xe40, 0xe50, 0xe61, 0xe71, 0xe82, 0xe93,
	0xea4, 0xeb4, 0xec5, 0xed6, 0xee7, 0xef8, 0xf09, 0xf1a, 0xf2b, 0xf3d,
	0xf4e, 0xf5f, 0xf70, 0xf82, 0xf93, 0xfa4, 0xfb6, 0xfc7, 0xfd9, 0xfea,
	0xffc, 0x100e, 0x101f, 0x1031, 0x1043, 0x1055, 0x1067, 0x1078, 0x108a,
	0x109c, 0x10ae, 0x10c0, 0x10d3, 0x10e5, 0x10f7, 0x1109, 0x111b, 0x112e,
	0x1140, 0x1153, 0x1165, 0x1178, 0x118a, 0x119d, 0x11af, 0x11c2, 0x11d5,
	0x11e7, 0x11fa, 0x120d, 0x1220, 0x1233, 0x1246, 0x1259, 0x126c, 0x127f,
	0x1292, 0x12a5, 0x12b8, 0x12cc, 0x12df, 0x12f2, 0x1306, 0x1319, 0x132d,
	0x1340, 0x1354, 0x1367, 0x137b, 0x138f, 0x13a2, 0x13b6, 0x13ca, 0x13de,
	0x13f2, 0x1406, 0x141a, 0x142e, 0x1442, 0x1456, 0x146a, 0x147e, 0x1492,
	0x14a7, 0x14bb, 0x14cf, 0x14e4, 0x14f8, 0x150d, 0x1521, 0x1536, 0x154a,
	0x155f, 0x1574, 0x1588, 0x159d, 0x15b2, 0x15c7, 0x15dc, 0x15f1, 0x1606,
	0x161b, 0x1630, 0x1645, 0x165a, 0x1670, 0x1685, 0x169a, 0x16b0, 0x16c5,
	0x16da, 0x16f0, 0x1705, 0x171b, 0x1731, 0x1746, 0x175c, 0x1772, 0x1788,
	0x179d, 0x17b3, 0x17c9, 0x17df, 0x17f5, 0x180b, 0x1821, 0x1837, 0x184e,
	0x1864, 0x187a, 0x1890, 0x18a7, 0x18bd, 0x18d4, 0x18ea, 0x1901, 0x1917,
	0x192e, 0x1944, 0x195b, 0x1972, 0x1989, 0x19a0, 0x19b6, 0x19cd, 0x19e4,
	0x19fb, 0x1a12, 0x1a29, 0x1a41, 0x1a58, 0x1a6f, 0x1a86, 0x1a9e, 0x1ab5,
	0x1acc, 0x1ae4, 0x1afb, 0x1b13, 0x1b2a, 0x1b42, 0x1b5a, 0x1b72, 0x1b89,
	0x1ba1, 0x1bb9, 0x1bd1, 0x1be9, 0x1c01, 0x1c19, 0x1c31, 0x1c49, 0x1c61,
	0x1c79, 0x1c92, 0x1caa, 0x1cc2, 0x1cdb, 0x1cf3, 0x1d0b, 0x1d24, 0x1d3d,
	0x1d55, 0x1d6e, 0x1d86, 0x1d9f, 0x1db8, 0x1dd1, 0x1dea, 0x1e03, 0x1e1c,
	0x1e35, 0x1e4e, 0x1e67, 0x1e80, 0x1e99, 0x1eb2, 0x1ecb, 0x1ee5, 0x1efe,
	0x1f18, 0x1f31, 0x1f4a, 0x1f64, 0x1f7e, 0x1f97, 0x1fb1, 0x1fcb, 0x1fe4,
	0x1ffe, 0x2018, 0x2032, 0x204c, 0x2066, 0x2080, 0x209a, 0x20b4, 0x20ce,
	0x20e8, 0x2103, 0x211d, 0x2137, 0x2152, 0x216c, 0x2187, 0x21a1, 0x21bc,
	0x21d6, 0x21f1, 0x220c, 0x2226, 0x2241, 0x225c, 0x2277, 0x2292, 0x22ad,
	0x22c8, 0x22e3, 0x22fe, 0x2319, 0x2334, 0x2350, 0x236b, 0x2386, 0x23a2,
	0x23bd, 0x23d9, 0x23f4, 0x2410, 0x242b, 0x2447, 0x2463, 0x247e, 0x249a,
	0x24b6, 0x24d2, 0x24ee, 0x250a, 0x2526, 0x2542, 0x255e, 0x257a, 0x2596,
	0x25b3, 0x25cf, 0x25eb, 0x2608, 0x2624, 0x2640, 0x265d, 0x267a, 0x2696,
	0x26b3, 0x26d0, 0x26ec, 0x2709, 0x2726, 0x2743, 0x2760, 0x277d, 0x279a,
	0x27b7, 0x27d4, 0x27f1, 0x280e, 0x282b, 0x2849, 0x2866, 0x2884, 0x28a1,
	0x28be, 0x28dc, 0x28fa, 0x2917, 0x2935, 0x2953, 0x2970, 0x298e, 0x29ac,
	0x29ca, 0x29e8, 0x2a06, 0x2a24, 0x2a42, 0x2a60, 0x2a7e, 0x2a9c, 0x2abb,
	0x2ad9, 0x2af7, 0x2b16, 0x2b34, 0x2b53, 0x2b71, 0x2b90, 0x2bae, 0x2bcd,
	0x2bec, 0x2c0a, 0x2c29, 0x2c48, 0x2c67, 0x2c86, 0x2ca5, 0x2cc4, 0x2ce3,
	0x2d02, 0x2d21, 0x2d41, 0x2d60, 0x2d7f, 0x2d9f, 0x2dbe, 0x2dde, 0x2dfd,
	0x2e1d, 0x2e3c, 0x2e5c, 0x2e7c, 0x2e9b, 0x2ebb, 0x2edb, 0x2efb, 0x2f1b,
	0x2f3b, 0x2f5b, 0x2f7b, 0x2f9b, 0x2fbb, 0x2fdb, 0x2ffc, 0x301c, 0x303c,
	0x305d, 0x307d, 0x309e, 0x30be, 0x30df, 0x30ff, 0x3120, 0x3141, 0x3161,
	0x3182, 0x31a3, 0x31c4, 0x31e5, 0x3206, 0x3227, 0x3248, 0x3269, 0x328a,
	0x32ac, 0x32cd, 0x32ee, 0x3310, 0x3331, 0x3353, 0x3374, 0x3396, 0x33b7,
	0x33d9, 0x33fb, 0x341c, 0x343e, 0x3460, 0x3482, 0x34a4, 0x34c6, 0x34e8,
	0x350a, 0x352c, 0x354e, 0x3571, 0x3593, 0x35b5, 0x35d7, 0x35fa, 0x361c,
	0x363f, 0x3661, 0x3684, 0x36a7, 0x36c9, 0x36ec, 0x370f, 0x3732, 0x3755,
	0x3778, 0x379b, 0x37be, 0x37e1, 0x3804, 0x3827, 0x384a, 0x386d, 0x3891,
	0x38b4, 0x38d7, 0x38fb, 0x391e, 0x3942, 0x3966, 0x3989, 0x39ad, 0x39d1,
	0x39f4, 0x3a18, 0x3a3c, 0x3a60, 0x3a84, 0x3aa8, 0x3acc, 0x3af0, 0x3b14,
	0x3b39, 0x3b5d, 0x3b81, 0x3ba6, 0x3bca, 0x3bee, 0x3c13, 0x3c37, 0x3c5c,
	0x3c81, 0x3ca5, 0x3cca, 0x3cef, 0x3d14, 0x3d39, 0x3d5e, 0x3d83, 0x3da8,
	0x3dcd, 0x3df2, 0x3e17, 0x3e3c, 0x3e61, 0x3e87, 0x3eac, 0x3ed2, 0x3ef7,
	0x3f1c, 0x3f42, 0x3f68, 0x3f8d, 0x3fb3, 0x3fd9, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x0},
	{0x3, 0x0, 0x3, 0x7, 0xa, 0xe, 0x11, 0x15, 0x18, 0x1c, 0x20, 0x23,
	0x27, 0x2a, 0x2e, 0x31, 0x35, 0x38, 0x3c, 0x40, 0x43, 0x47, 0x4a, 0x4e,
	0x51, 0x55, 0x58, 0x5c, 0x60, 0x63, 0x67, 0x6a, 0x6e, 0x71, 0x75, 0x78,
	0x7c, 0x80, 0x83, 0x87, 0x8a, 0x8e, 0x91, 0x95, 0x99, 0x9c, 0xa0, 0xa3,
	0xa7, 0xaa, 0xae, 0xb1, 0xb5, 0xb9, 0xbc, 0xc0, 0xc3, 0xc7, 0xca, 0xce,
	0xd1, 0xd5, 0xd9, 0xdc, 0xe0, 0xe3, 0xe7, 0xea, 0xee, 0xf1, 0xf5, 0xf9,
	0xfc, 0x100, 0x103, 0x107, 0x10a, 0x10e, 0x112, 0x115, 0x119, 0x11c,
	0x120, 0x123, 0x126, 0x12a, 0x12d, 0x131, 0x134, 0x138, 0x13c, 0x13f,
	0x143, 0x147, 0x14b, 0x14e, 0x152, 0x156, 0x15a, 0x15e, 0x162, 0x166,
	0x16a, 0x16e, 0x172, 0x176, 0x17a, 0x17e, 0x182, 0x186, 0x18a, 0x18f,
	0x193, 0x197, 0x19b, 0x1a0, 0x1a4, 0x1a8, 0x1ad, 0x1b1, 0x1b5, 0x1ba,
	0x1be, 0x1c3, 0x1c7, 0x1cc, 0x1d0, 0x1d5, 0x1d9, 0x1de, 0x1e3, 0x1e7,
	0x1ec, 0x1f1, 0x1f6, 0x1fa, 0x1ff, 0x204, 0x209, 0x20e, 0x213, 0x217,
	0x21c, 0x221, 0x226, 0x22b, 0x230, 0x236, 0x23b, 0x240, 0x245, 0x24a,
	0x24f, 0x255, 0x25a, 0x25f, 0x264, 0x26a, 0x26f, 0x274, 0x27a, 0x27f,
	0x285, 0x28a, 0x290, 0x295, 0x29b, 0x2a0, 0x2a6, 0x2ac, 0x2b1, 0x2b7,
	0x2bd, 0x2c2, 0x2c8, 0x2ce, 0x2d4, 0x2da, 0x2df, 0x2e5, 0x2eb, 0x2f1,
	0x2f7, 0x2fd, 0x303, 0x309, 0x30f, 0x315, 0x31c, 0x322, 0x328, 0x32e,
	0x334, 0x33b, 0x341, 0x347, 0x34d, 0x354, 0x35a, 0x361, 0x367, 0x36d,
	0x374, 0x37a, 0x381, 0x388, 0x38e, 0x395, 0x39b, 0x3a2, 0x3a9, 0x3b0,
	0x3b6, 0x3bd, 0x3c4, 0x3cb, 0x3d2, 0x3d8, 0x3df, 0x3e6, 0x3ed, 0x3f4,
	0x3fb, 0x402, 0x409, 0x411, 0x418, 0x41f, 0x426, 0x42d, 0x434, 0x43c,
	0x443, 0x44a, 0x452, 0x459, 0x460, 0x468, 0x46f, 0x477, 0x47e, 0x486,
	0x48d, 0x495, 0x49c, 0x4a4, 0x4ac, 0x4b3, 0x4bb, 0x4c3, 0x4cb, 0x4d3,
	0x4da, 0x4e2, 0x4ea, 0x4f2, 0x4fa, 0x502, 0x50a, 0x512, 0x51a, 0x522,
	0x52a, 0x532, 0x53a, 0x543, 0x54b, 0x553, 0x55b, 0x564, 0x56c, 0x574,
	0x57d, 0x585, 0x58d, 0x596, 0x59e, 0x5a7, 0x5af, 0x5b8, 0x5c1, 0x5c9,
	0x5d2, 0x5db, 0x5e3, 0x5ec, 0x5f5, 0x5fe, 0x606, 0x60f, 0x618, 0x621,
	0x62a, 0x633, 0x63c, 0x645, 0x64e, 0x657, 0x660, 0x669, 0x672, 0x67b,
	0x685, 0x68e, 0x697, 0x6a0, 0x6aa, 0x6b3, 0x6bd, 0x6c6, 0x6cf, 0x6d9,
	0x6e2, 0x6ec, 0x6f5, 0x6ff, 0x709, 0x712, 0x71c, 0x726, 0x72f, 0x739,
	0x743, 0x74d, 0x756, 0x760, 0x76a, 0x774, 0x77e, 0x788, 0x792, 0x79c,
	0x7a6, 0x7b0, 0x7ba, 0x7c4, 0x7cf, 0x7d9, 0x7e3, 0x7ed, 0x7f7, 0x802,
	0x80c, 0x816, 0x821, 0x82b, 0x836, 0x840, 0x84b, 0x855, 0x860, 0x86a,
	0x875, 0x880, 0x88a, 0x895, 0x8a0, 0x8ab, 0x8b5, 0x8c0, 0x8cb, 0x8d6,
	0x8e1, 0x8ec, 0x8f7, 0x902, 0x90d, 0x918, 0x923, 0x92e, 0x939, 0x944,
	0x950, 0x95b, 0x966, 0x971, 0x97d, 0x988, 0x993, 0x99f, 0x9aa, 0x9b6,
	0x9c1, 0x9cd, 0x9d8, 0x9e4, 0x9f0, 0x9fb, 0xa07, 0xa13, 0xa1e, 0xa2a,
	0xa36, 0xa42, 0xa4e, 0xa59, 0xa65, 0xa71, 0xa7d, 0xa89, 0xa95, 0xaa1,
	0xaad, 0xab9, 0xac6, 0xad2, 0xade, 0xaea, 0xaf6, 0xb03, 0xb0f, 0xb1b,
	0xb28, 0xb34, 0xb41, 0xb4d, 0xb5a, 0xb66, 0xb73, 0xb7f, 0xb8c, 0xb98,
	0xba5, 0xbb2, 0xbbf, 0xbcb, 0xbd8, 0xbe5, 0xbf2, 0xbff, 0xc0c, 0xc19,
	0xc25, 0xc32, 0xc40, 0xc4d, 0xc5a, 0xc67, 0xc74, 0xc81, 0xc8e, 0xc9c,
	0xca9, 0xcb6, 0xcc3, 0xcd1, 0xcde, 0xcec, 0xcf9, 0xd07, 0xd14, 0xd22,
	0xd2f, 0xd3d, 0xd4a, 0xd58, 0xd66, 0xd73, 0xd81, 0xd8f, 0xd9d, 0xdab,
	0xdb8, 0xdc6, 0xdd4, 0xde2, 0xdf0, 0xdfe, 0xe0c, 0xe1a, 0xe29, 0xe37,
	0xe45, 0xe53, 0xe61, 0xe70, 0xe7e, 0xe8c, 0xe9a, 0xea9, 0xeb7, 0xec6,
	0xed4, 0xee3, 0xef1, 0xf00, 0xf0e, 0xf1d, 0xf2c, 0xf3a, 0xf49, 0xf58,
	0xf67, 0xf75, 0xf84, 0xf93, 0xfa2, 0xfb1, 0xfc0, 0xfcf, 0xfde, 0xfed,
	0xffc, 0x100b, 0x101a, 0x102a, 0x1039, 0x1048, 0x1057, 0x1067, 0x1076,
	0x1085, 0x1095, 0x10a4, 0x10b4, 0x10c3, 0x10d3, 0x10e2, 0x10f2, 0x1101,
	0x1111, 0x1121, 0x1130, 0x1140, 0x1150, 0x1160, 0x116f, 0x117f, 0x118f,
	0x119f, 0x11af, 0x11bf, 0x11cf, 0x11df, 0x11ef, 0x11ff, 0x120f, 0x121f,
	0x1230, 0x1240, 0x1250, 0x1260, 0x1271, 0x1281, 0x1291, 0x12a2, 0x12b2,
	0x12c3, 0x12d3, 0x12e4, 0x12f4, 0x1305, 0x1316, 0x1326, 0x1337, 0x1348,
	0x1359, 0x1369, 0x137a, 0x138b, 0x139c, 0x13ad, 0x13be, 0x13cf, 0x13e0,
	0x13f1, 0x1402, 0x1413, 0x1424, 0x1435, 0x1446, 0x1458, 0x1469, 0x147a,
	0x148b, 0x149d, 0x14ae, 0x14c0, 0x14d1, 0x14e3, 0x14f4, 0x1506, 0x1517,
	0x1529, 0x153a, 0x154c, 0x155e, 0x156f, 0x1581, 0x1593, 0x15a5, 0x15b7,
	0x15c9, 0x15db, 0x15ec, 0x15fe, 0x1610, 0x1623, 0x1635, 0x1647, 0x1659,
	0x166b, 0x167d, 0x168f, 0x16a2, 0x16b4, 0x16c6, 0x16d9, 0x16eb, 0x16fe,
	0x1710, 0x1722, 0x1735, 0x1748, 0x175a, 0x176d, 0x177f, 0x1792, 0x17a5,
	0x17b8, 0x17ca, 0x17dd, 0x17f0, 0x1803, 0x1816, 0x1829, 0x183c, 0x184f,
	0x1862, 0x1875, 0x1888, 0x189b, 0x18ae, 0x18c1, 0x18d5, 0x18e8, 0x18fb,
	0x190e, 0x1922, 0x1935, 0x1949, 0x195c, 0x196f, 0x1983, 0x1996, 0x19aa,
	0x19be, 0x19d1, 0x19e5, 0x19f9, 0x1a0c, 0x1a20, 0x1a34, 0x1a48, 0x1a5c,
	0x1a70, 0x1a84, 0x1a97, 0x1aab, 0x1ac0, 0x1ad4, 0x1ae8, 0x1afc, 0x1b10,
	0x1b24, 0x1b38, 0x1b4d, 0x1b61, 0x1b75, 0x1b8a, 0x1b9e, 0x1bb2, 0x1bc7,
	0x1bdb, 0x1bf0, 0x1c04, 0x1c19, 0x1c2e, 0x1c42, 0x1c57, 0x1c6c, 0x1c80,
	0x1c95, 0x1caa, 0x1cbf, 0x1cd4, 0x1ce8, 0x1cfd, 0x1d12, 0x1d27, 0x1d3c,
	0x1d51, 0x1d67, 0x1d7c, 0x1d91, 0x1da6, 0x1dbb, 0x1dd1, 0x1de6, 0x1dfb,
	0x1e10, 0x1e26, 0x1e3b, 0x1e51, 0x1e66, 0x1e7c, 0x1e91, 0x1ea7, 0x1ebd,
	0x1ed2, 0x1ee8, 0x1efe, 0x1f13, 0x1f29, 0x1f3f, 0x1f55, 0x1f6b, 0x1f81,
	0x1f96, 0x1fac, 0x1fc2, 0x1fd9, 0x1fef, 0x2005, 0x201b, 0x2031, 0x2047,
	0x205d, 0x2074, 0x208a, 0x20a0, 0x20b7, 0x20cd, 0x20e4, 0x20fa, 0x2111,
	0x2127, 0x213e, 0x2154, 0x216b, 0x2182, 0x2198, 0x21af, 0x21c6, 0x21dd,
	0x21f3, 0x220a, 0x2221, 0x2238, 0x224f, 0x2266, 0x227d, 0x2294, 0x22ab,
	0x22c2, 0x22da, 0x22f1, 0x2308, 0x231f, 0x2337, 0x234e, 0x2365, 0x237d,
	0x2394, 0x23ac, 0x23c3, 0x23db, 0x23f2, 0x240a, 0x2421, 0x2439, 0x2451,
	0x2469, 0x2480, 0x2498, 0x24b0, 0x24c8, 0x24e0, 0x24f8, 0x2510, 0x2528,
	0x2540, 0x2558, 0x2570, 0x2588, 0x25a0, 0x25b8, 0x25d0, 0x25e9, 0x2601,
	0x2619, 0x2632, 0x264a, 0x2663, 0x267b, 0x2693, 0x26ac, 0x26c5, 0x26dd,
	0x26f6, 0x270e, 0x2727, 0x2740, 0x2759, 0x2771, 0x278a, 0x27a3, 0x27bc,
	0x27d5, 0x27ee, 0x2807, 0x2820, 0x2839, 0x2852, 0x286b, 0x2884, 0x289e,
	0x28b7, 0x28d0, 0x28e9, 0x2903, 0x291c, 0x2936, 0x294f, 0x2968, 0x2982,
	0x299c, 0x29b5, 0x29cf, 0x29e8, 0x2a02, 0x2a1c, 0x2a35, 0x2a4f, 0x2a69,
	0x2a83, 0x2a9d, 0x2ab7, 0x2ad1, 0x2aeb, 0x2b05, 0x2b1f, 0x2b39, 0x2b53,
	0x2b6d, 0x2b87, 0x2ba1, 0x2bbc, 0x2bd6, 0x2bf0, 0x2c0b, 0x2c25, 0x2c3f,
	0x2c5a, 0x2c74, 0x2c8f, 0x2ca9, 0x2cc4, 0x2cdf, 0x2cf9, 0x2d14, 0x2d2f,
	0x2d49, 0x2d64, 0x2d7f, 0x2d9a, 0x2db5, 0x2dd0, 0x2deb, 0x2e06, 0x2e21,
	0x2e3c, 0x2e57, 0x2e72, 0x2e8d, 0x2ea8, 0x2ec4, 0x2edf, 0x2efa, 0x2f16,
	0x2f31, 0x2f4c, 0x2f68, 0x2f83, 0x2f9f, 0x2fba, 0x2fd6, 0x2ff1, 0x300d,
	0x3029, 0x3044, 0x3060, 0x307c, 0x3098, 0x30b4, 0x30d0, 0x30eb, 0x3107,
	0x3123, 0x313f, 0x315b, 0x3178, 0x3194, 0x31b0, 0x31cc, 0x31e8, 0x3205,
	0x3221, 0x323d, 0x325a, 0x3276, 0x3292, 0x32af, 0x32cb, 0x32e8, 0x3304,
	0x3321, 0x333e, 0x335a, 0x3377, 0x3394, 0x33b1, 0x33cd, 0x33ea, 0x3407,
	0x3424, 0x3441, 0x345e, 0x347b, 0x3498, 0x34b5, 0x34d2, 0x34ef, 0x350d,
	0x352a, 0x3547, 0x3564, 0x3582, 0x359f, 0x35bc, 0x35da, 0x35f7, 0x3615,
	0x3632, 0x3650, 0x366e, 0x368b, 0x36a9, 0x36c7, 0x36e4, 0x3702, 0x3720,
	0x373e, 0x375c, 0x377a, 0x3798, 0x37b6, 0x37d4, 0x37f2, 0x3810, 0x382e,
	0x384c, 0x386a, 0x3888, 0x38a7, 0x38c5, 0x38e3, 0x3902, 0x3920, 0x393f,
	0x395d, 0x397c, 0x399a, 0x39b9, 0x39d7, 0x39f6, 0x3a15, 0x3a33, 0x3a52,
	0x3a71, 0x3a90, 0x3aaf, 0x3acd, 0x3aec, 0x3b0b, 0x3b2a, 0x3b49, 0x3b68,
	0x3b87, 0x3ba7, 0x3bc6, 0x3be5, 0x3c04, 0x3c24, 0x3c43, 0x3c62, 0x3c82,
	0x3ca1, 0x3cc0, 0x3ce0, 0x3cff, 0x3d1f, 0x3d3f, 0x3d5e, 0x3d7e, 0x3d9e,
	0x3dbd, 0x3ddd, 0x3dfd, 0x3e1d, 0x3e3d, 0x3e5d, 0x3e7c, 0x3e9c, 0x3ebc,
	0x3edc, 0x3efd, 0x3f1d, 0x3f3d, 0x3f5d, 0x3f7d, 0x3f9e, 0x3fbe, 0x3fde,
	0x3fff, 0x0},
	{0x3, 0x0, 0xfa0, 0x13a2, 0x160c, 0x17a3, 0x18d8, 0x1a0c, 0x1ac9,
	0x1ba3, 0x1c4d, 0x1cd8, 0x1d70, 0x1e0c, 0x1e67, 0x1ec9, 0x1f33, 0x1fa3,
	0x200e, 0x204d, 0x2091, 0x20d8, 0x2122, 0x2170, 0x21c2, 0x220c, 0x2238,
	0x2267, 0x2297, 0x22c9, 0x22fd, 0x2333, 0x236a, 0x23a3, 0x23df, 0x240e,
	0x242d, 0x244d, 0x246e, 0x2491, 0x24b4, 0x24d8, 0x24fc, 0x2522, 0x2549,
	0x2570, 0x2599, 0x25c2, 0x25ed, 0x260c, 0x2622, 0x2638, 0x264f, 0x2667,
	0x267f, 0x2697, 0x26b0, 0x26c9, 0x26e3, 0x26fd, 0x2717, 0x2733, 0x274e,
	0x276a, 0x2787, 0x27a3, 0x27c1, 0x27df, 0x27fd, 0x280e, 0x281d, 0x282d,
	0x283d, 0x284d, 0x285e, 0x286e, 0x287f, 0x2891, 0x28a2, 0x28b4, 0x28c5,
	0x28d8, 0x28ea, 0x28fc, 0x290f, 0x2922, 0x2935, 0x2949, 0x295d, 0x2970,
	0x2985, 0x2999, 0x29ae, 0x29c2, 0x29d7, 0x29ed, 0x2a01, 0x2a0c, 0x2a17,
	0x2a22, 0x2a2d, 0x2a38, 0x2a44, 0x2a4f, 0x2a5b, 0x2a67, 0x2a73, 0x2a7f,
	0x2a8b, 0x2a97, 0x2aa3, 0x2ab0, 0x2abc, 0x2ac9, 0x2ad6, 0x2ae3, 0x2af0,
	0x2afd, 0x2b0a, 0x2b17, 0x2b25, 0x2b33, 0x2b40, 0x2b4e, 0x2b5c, 0x2b6a,
	0x2b78, 0x2b87, 0x2b95, 0x2ba3, 0x2bb2, 0x2bc1, 0x2bd0, 0x2bdf, 0x2bee,
	0x2bfd, 0x2c06, 0x2c0e, 0x2c15, 0x2c1d, 0x2c25, 0x2c2d, 0x2c35, 0x2c3d,
	0x2c45, 0x2c4d, 0x2c55, 0x2c5e, 0x2c66, 0x2c6e, 0x2c77, 0x2c7f, 0x2c88,
	0x2c91, 0x2c99, 0x2ca2, 0x2cab, 0x2cb4, 0x2cbd, 0x2cc5, 0x2cce, 0x2cd8,
	0x2ce1, 0x2cea, 0x2cf3, 0x2cfc, 0x2d06, 0x2d0f, 0x2d19, 0x2d22, 0x2d2c,
	0x2d35, 0x2d3f, 0x2d49, 0x2d53, 0x2d5d, 0x2d66, 0x2d70, 0x2d7a, 0x2d85,
	0x2d8f, 0x2d99, 0x2da3, 0x2dae, 0x2db8, 0x2dc2, 0x2dcd, 0x2dd7, 0x2de2,
	0x2ded, 0x2df7, 0x2e01, 0x2e06, 0x2e0c, 0x2e11, 0x2e17, 0x2e1c, 0x2e22,
	0x2e27, 0x2e2d, 0x2e33, 0x2e38, 0x2e3e, 0x2e44, 0x2e49, 0x2e4f, 0x2e55,
	0x2e5b, 0x2e61, 0x2e67, 0x2e6d, 0x2e73, 0x2e79, 0x2e7f, 0x2e85, 0x2e8b,
	0x2e91, 0x2e97, 0x2e9d, 0x2ea3, 0x2eaa, 0x2eb0, 0x2eb6, 0x2ebc, 0x2ec3,
	0x2ec9, 0x2ecf, 0x2ed6, 0x2edc, 0x2ee3, 0x2ee9, 0x2ef0, 0x2ef6, 0x2efd,
	0x2f03, 0x2f0a, 0x2f11, 0x2f17, 0x2f1e, 0x2f25, 0x2f2c, 0x2f33, 0x2f39,
	0x2f40, 0x2f47, 0x2f4e, 0x2f55, 0x2f5c, 0x2f63, 0x2f6a, 0x2f71, 0x2f78,
	0x2f7f, 0x2f87, 0x2f8e, 0x2f95, 0x2f9c, 0x2fa3, 0x2fab, 0x2fb2, 0x2fb9,
	0x2fc1, 0x2fc8, 0x2fd0, 0x2fd7, 0x2fdf, 0x2fe6, 0x2fee, 0x2ff5, 0x2ffd,
	0x3002, 0x3006, 0x300a, 0x300e, 0x3011, 0x3015, 0x3019, 0x301d, 0x3021,
	0x3025, 0x3029, 0x302d, 0x3031, 0x3035, 0x3039, 0x303d, 0x3041, 0x3045,
	0x3049, 0x304d, 0x3051, 0x3055, 0x305a, 0x305e, 0x3062, 0x3066, 0x306a,
	0x306e, 0x3073, 0x3077, 0x307b, 0x307f, 0x3084, 0x3088, 0x308c, 0x3091,
	0x3095, 0x3099, 0x309e, 0x30a2, 0x30a6, 0x30ab, 0x30af, 0x30b4, 0x30b8,
	0x30bd, 0x30c1, 0x30c5, 0x30ca, 0x30ce, 0x30d3, 0x30d8, 0x30dc, 0x30e1,
	0x30e5, 0x30ea, 0x30ee, 0x30f3, 0x30f8, 0x30fc, 0x3101, 0x3106, 0x310a,
	0x310f, 0x3114, 0x3119, 0x311d, 0x3122, 0x3127, 0x312c, 0x3131, 0x3135,
	0x313a, 0x313f, 0x3144, 0x3149, 0x314e, 0x3153, 0x3158, 0x315d, 0x3161,
	0x3166, 0x316b, 0x3170, 0x3175, 0x317a, 0x3180, 0x3185, 0x318a, 0x318f,
	0x3194, 0x3199, 0x319e, 0x31a3, 0x31a8, 0x31ae, 0x31b3, 0x31b8, 0x31bd,
	0x31c2, 0x31c8, 0x31cd, 0x31d2, 0x31d7, 0x31dd, 0x31e2, 0x31e7, 0x31ed,
	0x31f2, 0x31f7, 0x31fd, 0x3201, 0x3204, 0x3206, 0x3209, 0x320c, 0x320e,
	0x3211, 0x3214, 0x3217, 0x3219, 0x321c, 0x321f, 0x3222, 0x3225, 0x3227,
	0x322a, 0x322d, 0x3230, 0x3233, 0x3235, 0x3238, 0x323b, 0x323e, 0x3241,
	0x3244, 0x3247, 0x3249, 0x324c, 0x324f, 0x3252, 0x3255, 0x3258, 0x325b,
	0x325e, 0x3261, 0x3264, 0x3267, 0x326a, 0x326d, 0x3270, 0x3273, 0x3276,
	0x3279, 0x327c, 0x327f, 0x3282, 0x3285, 0x3288, 0x328b, 0x328e, 0x3291,
	0x3294, 0x3297, 0x329a, 0x329d, 0x32a0, 0x32a3, 0x32a6, 0x32aa, 0x32ad,
	0x32b0, 0x32b3, 0x32b6, 0x32b9, 0x32bd, 0x32c0, 0x32c3, 0x32c6, 0x32ca,
	0x32cd, 0x32d0, 0x32d4, 0x32d7, 0x32db, 0x32de, 0x32e1, 0x32e5, 0x32e8,
	0x32ec, 0x32ef, 0x32f3, 0x32f7, 0x32fa, 0x32fe, 0x3302, 0x3305, 0x3309,
	0x330d, 0x3310, 0x3314, 0x3318, 0x331c, 0x3320, 0x3324, 0x3328, 0x332b,
	0x332f, 0x3333, 0x3337, 0x333b, 0x3340, 0x3344, 0x3348, 0x334c, 0x3350,
	0x3354, 0x3358, 0x335d, 0x3361, 0x3365, 0x336a, 0x336e, 0x3372, 0x3377,
	0x337b, 0x3380, 0x3384, 0x3389, 0x338d, 0x3392, 0x3396, 0x339b, 0x33a0,
	0x33a4, 0x33a9, 0x33ae, 0x33b3, 0x33b7, 0x33bc, 0x33c1, 0x33c6, 0x33cb,
	0x33d0, 0x33d5, 0x33da, 0x33df, 0x33e4, 0x33e9, 0x33ef, 0x33f4, 0x33f9,
	0x33fe, 0x3402, 0x3404, 0x3407, 0x340a, 0x340c, 0x340f, 0x3412, 0x3415,
	0x3417, 0x341a, 0x341d, 0x3420, 0x3423, 0x3426, 0x3429, 0x342b, 0x342e,
	0x3431, 0x3434, 0x3437, 0x343a, 0x343d, 0x3440, 0x3444, 0x3447, 0x344a,
	0x344d, 0x3450, 0x3453, 0x3456, 0x345a, 0x345d, 0x3460, 0x3463, 0x3467,
	0x346a, 0x346d, 0x3471, 0x3474, 0x3477, 0x347b, 0x347e, 0x3482, 0x3485,
	0x3489, 0x348c, 0x3490, 0x3493, 0x3497, 0x349b, 0x349e, 0x34a2, 0x34a6,
	0x34a9, 0x34ad, 0x34b1, 0x34b5, 0x34b9, 0x34bc, 0x34c0, 0x34c4, 0x34c8,
	0x34cc, 0x34d0, 0x34d4, 0x34d8, 0x34dc, 0x34e0, 0x34e4, 0x34e8, 0x34ec,
	0x34f1, 0x34f5, 0x34f9, 0x34fd, 0x3502, 0x3506, 0x350a, 0x350f, 0x3513,
	0x3517, 0x351c, 0x3520, 0x3525, 0x3529, 0x352e, 0x3533, 0x3537, 0x353c,
	0x3541, 0x3545, 0x354a, 0x354f, 0x3554, 0x3558, 0x355d, 0x3562, 0x3567,
	0x356c, 0x3571, 0x3576, 0x357b, 0x3580, 0x3585, 0x358a, 0x3590, 0x3595,
	0x359a, 0x359f, 0x35a5, 0x35aa, 0x35b0, 0x35b5, 0x35ba, 0x35c0, 0x35c5,
	0x35cb, 0x35d1, 0x35d6, 0x35dc, 0x35e2, 0x35e7, 0x35ed, 0x35f3, 0x35f9,
	0x35ff, 0x3602, 0x3605, 0x3608, 0x360b, 0x360e, 0x3611, 0x3614, 0x3617,
	0x361a, 0x361e, 0x3621, 0x3624, 0x3627, 0x362a, 0x362e, 0x3631, 0x3634,
	0x3637, 0x363b, 0x363e, 0x3642, 0x3645, 0x3648, 0x364c, 0x364f, 0x3653,
	0x3656, 0x365a, 0x365d, 0x3661, 0x3664, 0x3668, 0x366c, 0x366f, 0x3673,
	0x3677, 0x367a, 0x367e, 0x3682, 0x3686, 0x368a, 0x368d, 0x3691, 0x3695,
	0x3699, 0x369d, 0x36a1, 0x36a5, 0x36a9, 0x36ad, 0x36b1, 0x36b5, 0x36ba,
	0x36be, 0x36c2, 0x36c6, 0x36ca, 0x36cf, 0x36d3, 0x36d7, 0x36dc, 0x36e0,
	0x36e4, 0x36e9, 0x36ed, 0x36f2, 0x36f6, 0x36fb, 0x36ff, 0x3704, 0x3709,
	0x370d, 0x3712, 0x3717, 0x371b, 0x3720, 0x3725, 0x372a, 0x372f, 0x3734,
	0x3739, 0x373e, 0x3743, 0x3748, 0x374d, 0x3752, 0x3757, 0x375c, 0x3761,
	0x3767, 0x376c, 0x3771, 0x3776, 0x377c, 0x3781, 0x3787, 0x378c, 0x3792,
	0x3797, 0x379d, 0x37a2, 0x37a8, 0x37ae, 0x37b3, 0x37b9, 0x37bf, 0x37c5,
	0x37cb, 0x37d1, 0x37d7, 0x37dd, 0x37e3, 0x37e9, 0x37ef, 0x37f5, 0x37fb,
	0x3800, 0x3804, 0x3807, 0x380a, 0x380d, 0x3810, 0x3813, 0x3817, 0x381a,
	0x381d, 0x3821, 0x3824, 0x3827, 0x382b, 0x382e, 0x3831, 0x3835, 0x3838,
	0x383c, 0x383f, 0x3843, 0x3846, 0x384a, 0x384e, 0x3851, 0x3855, 0x3859,
	0x385c, 0x3860, 0x3864, 0x3867, 0x386b, 0x386f, 0x3873, 0x3877, 0x387b,
	0x387f, 0x3883, 0x3887, 0x388a, 0x388f, 0x3893, 0x3897, 0x389b, 0x389f,
	0x38a3, 0x38a7, 0x38ab, 0x38b0, 0x38b4, 0x38b8, 0x38bc, 0x38c1, 0x38c5,
	0x38c9, 0x38ce, 0x38d2, 0x38d7, 0x38db, 0x38e0, 0x38e4, 0x38e9, 0x38ee,
	0x38f2, 0x38f7, 0x38fc, 0x3900, 0x3905, 0x390a, 0x390f, 0x3914, 0x3919,
	0x391d, 0x3922, 0x3927, 0x392c, 0x3931, 0x3937, 0x393c, 0x3941, 0x3946,
	0x394b, 0x3950, 0x3956, 0x395b, 0x3960, 0x3966, 0x396b, 0x3971, 0x3976,
	0x397c, 0x3981, 0x3987, 0x398c, 0x3992, 0x3998, 0x399e, 0x39a3, 0x39a9,
	0x39af, 0x39b5, 0x39bb, 0x39c1, 0x39c7, 0x39cd, 0x39d3, 0x39d9, 0x39df,
	0x39e5, 0x39ec, 0x39f2, 0x39f8, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x3},
	{0x3, 0x0, 0xea8, 0x12aa, 0x1500, 0x16ab, 0x1815, 0x1900, 0x1a0b,
	0x1aab, 0x1b60, 0x1c15, 0x1c85, 0x1d00, 0x1d86, 0x1e0b, 0x1e58, 0x1eab,
	0x1f03, 0x1f60, 0x1fc3, 0x2015, 0x204c, 0x2085, 0x20c2, 0x2100, 0x2142,
	0x2186, 0x21cc, 0x220b, 0x2231, 0x2258, 0x2281, 0x22ab, 0x22d6, 0x2303,
	0x2331, 0x2360, 0x2391, 0x23c3, 0x23f6, 0x2415, 0x2430, 0x244c, 0x2468,
	0x2485, 0x24a3, 0x24c2, 0x24e1, 0x2500, 0x2521, 0x2542, 0x2563, 0x2586,
	0x25a9, 0x25cc, 0x25f1, 0x260b, 0x261e, 0x2631, 0x2644, 0x2658, 0x266c,
	0x2681, 0x2696, 0x26ab, 0x26c0, 0x26d6, 0x26ec, 0x2703, 0x271a, 0x2731,
	0x2748, 0x2760, 0x2779, 0x2791, 0x27aa, 0x27c3, 0x27dd, 0x27f6, 0x2808,
	0x2815, 0x2823, 0x2830, 0x283e, 0x284c, 0x285a, 0x2868, 0x2877, 0x2885,
	0x2894, 0x28a3, 0x28b2, 0x28c2, 0x28d1, 0x28e1, 0x28f0, 0x2900, 0x2910,
	0x2921, 0x2931, 0x2942, 0x2952, 0x2963, 0x2974, 0x2986, 0x2997, 0x29a9,
	0x29bb, 0x29cc, 0x29df, 0x29f1, 0x2a01, 0x2a0b, 0x2a14, 0x2a1e, 0x2a27,
	0x2a31, 0x2a3a, 0x2a44, 0x2a4e, 0x2a58, 0x2a62, 0x2a6c, 0x2a76, 0x2a81,
	0x2a8b, 0x2a96, 0x2aa0, 0x2aab, 0x2ab6, 0x2ac0, 0x2acb, 0x2ad6, 0x2ae1,
	0x2aec, 0x2af8, 0x2b03, 0x2b0e, 0x2b1a, 0x2b25, 0x2b31, 0x2b3d, 0x2b48,
	0x2b54, 0x2b60, 0x2b6c, 0x2b79, 0x2b85, 0x2b91, 0x2b9d, 0x2baa, 0x2bb6,
	0x2bc3, 0x2bd0, 0x2bdd, 0x2bea, 0x2bf6, 0x2c02, 0x2c08, 0x2c0f, 0x2c15,
	0x2c1c, 0x2c23, 0x2c2a, 0x2c30, 0x2c37, 0x2c3e, 0x2c45, 0x2c4c, 0x2c53,
	0x2c5a, 0x2c61, 0x2c68, 0x2c70, 0x2c77, 0x2c7e, 0x2c85, 0x2c8d, 0x2c94,
	0x2c9c, 0x2ca3, 0x2cab, 0x2cb2, 0x2cba, 0x2cc2, 0x2cc9, 0x2cd1, 0x2cd9,
	0x2ce1, 0x2ce8, 0x2cf0, 0x2cf8, 0x2d00, 0x2d08, 0x2d10, 0x2d18, 0x2d21,
	0x2d29, 0x2d31, 0x2d39, 0x2d42, 0x2d4a, 0x2d52, 0x2d5b, 0x2d63, 0x2d6c,
	0x2d74, 0x2d7d, 0x2d86, 0x2d8e, 0x2d97, 0x2da0, 0x2da9, 0x2db2, 0x2dbb,
	0x2dc3, 0x2dcc, 0x2dd5, 0x2ddf, 0x2de8, 0x2df1, 0x2dfa, 0x2e01, 0x2e06,
	0x2e0b, 0x2e0f, 0x2e14, 0x2e19, 0x2e1e, 0x2e22, 0x2e27, 0x2e2c, 0x2e31,
	0x2e36, 0x2e3a, 0x2e3f, 0x2e44, 0x2e49, 0x2e4e, 0x2e53, 0x2e58, 0x2e5d,
	0x2e62, 0x2e67, 0x2e6c, 0x2e71, 0x2e76, 0x2e7c, 0x2e81, 0x2e86, 0x2e8b,
	0x2e90, 0x2e96, 0x2e9b, 0x2ea0, 0x2ea6, 0x2eab, 0x2eb0, 0x2eb6, 0x2ebb,
	0x2ec0, 0x2ec6, 0x2ecb, 0x2ed1, 0x2ed6, 0x2edc, 0x2ee1, 0x2ee7, 0x2eec,
	0x2ef2, 0x2ef8, 0x2efd, 0x2f03, 0x2f09, 0x2f0e, 0x2f14, 0x2f1a, 0x2f20,
	0x2f25, 0x2f2b, 0x2f31, 0x2f37, 0x2f3d, 0x2f43, 0x2f48, 0x2f4e, 0x2f54,
	0x2f5a, 0x2f60, 0x2f66, 0x2f6c, 0x2f72, 0x2f79, 0x2f7f, 0x2f85, 0x2f8b,
	0x2f91, 0x2f97, 0x2f9d, 0x2fa4, 0x2faa, 0x2fb0, 0x2fb6, 0x2fbd, 0x2fc3,
	0x2fc9, 0x2fd0, 0x2fd6, 0x2fdd, 0x2fe3, 0x2fea, 0x2ff0, 0x2ff6, 0x2ffd,
	0x3002, 0x3005, 0x3008, 0x300b, 0x300f, 0x3012, 0x3015, 0x3019, 0x301c,
	0x301f, 0x3023, 0x3026, 0x302a, 0x302d, 0x3030, 0x3034, 0x3037, 0x303b,
	0x303e, 0x3042, 0x3045, 0x3049, 0x304c, 0x3050, 0x3053, 0x3057, 0x305a,
	0x305e, 0x3061, 0x3065, 0x3068, 0x306c, 0x3070, 0x3073, 0x3077, 0x307b,
	0x307e, 0x3082, 0x3085, 0x3089, 0x308d, 0x3091, 0x3094, 0x3098, 0x309c,
	0x309f, 0x30a3, 0x30a7, 0x30ab, 0x30ae, 0x30b2, 0x30b6, 0x30ba, 0x30be,
	0x30c2, 0x30c5, 0x30c9, 0x30cd, 0x30d1, 0x30d5, 0x30d9, 0x30dd, 0x30e1,
	0x30e4, 0x30e8, 0x30ec, 0x30f0, 0x30f4, 0x30f8, 0x30fc, 0x3100, 0x3104,
	0x3108, 0x310c, 0x3110, 0x3114, 0x3118, 0x311d, 0x3121, 0x3125, 0x3129,
	0x312d, 0x3131, 0x3135, 0x3139, 0x313d, 0x3142, 0x3146, 0x314a, 0x314e,
	0x3152, 0x3157, 0x315b, 0x315f, 0x3163, 0x3168, 0x316c, 0x3170, 0x3174,
	0x3179, 0x317d, 0x3181, 0x3186, 0x318a, 0x318e, 0x3193, 0x3197, 0x319c,
	0x31a0, 0x31a4, 0x31a9, 0x31ad, 0x31b2, 0x31b6, 0x31bb, 0x31bf, 0x31c3,
	0x31c8, 0x31cc, 0x31d1, 0x31d5, 0x31da, 0x31df, 0x31e3, 0x31e8, 0x31ec,
	0x31f1, 0x31f5, 0x31fa, 0x31ff, 0x3201, 0x3204, 0x3206, 0x3208, 0x320b,
	0x320d, 0x320f, 0x3212, 0x3214, 0x3216, 0x3219, 0x321b, 0x321e, 0x3220,
	0x3222, 0x3225, 0x3227, 0x3229, 0x322c, 0x322e, 0x3231, 0x3233, 0x3236,
	0x3238, 0x323a, 0x323d, 0x323f, 0x3242, 0x3244, 0x3247, 0x3249, 0x324c,
	0x324e, 0x3251, 0x3253, 0x3256, 0x3258, 0x325b, 0x325d, 0x3260, 0x3262,
	0x3265, 0x3267, 0x326a, 0x326c, 0x326f, 0x3271, 0x3274, 0x3276, 0x3279,
	0x327c, 0x327e, 0x3281, 0x3283, 0x3286, 0x3289, 0x328b, 0x328e, 0x3290,
	0x3293, 0x3296, 0x3298, 0x329b, 0x329e, 0x32a0, 0x32a3, 0x32a6, 0x32a8,
	0x32ab, 0x32ae, 0x32b0, 0x32b3, 0x32b6, 0x32b8, 0x32bb, 0x32be, 0x32c1,
	0x32c4, 0x32c6, 0x32c9, 0x32cc, 0x32cf, 0x32d2, 0x32d5, 0x32d8, 0x32da,
	0x32dd, 0x32e0, 0x32e3, 0x32e6, 0x32e9, 0x32ec, 0x32ef, 0x32f2, 0x32f6,
	0x32f9, 0x32fc, 0x32ff, 0x3302, 0x3305, 0x3308, 0x330c, 0x330f, 0x3312,
	0x3315, 0x3318, 0x331c, 0x331f, 0x3322, 0x3326, 0x3329, 0x332c, 0x3330,
	0x3333, 0x3337, 0x333a, 0x333e, 0x3341, 0x3345, 0x3348, 0x334c, 0x334f,
	0x3353, 0x3356, 0x335a, 0x335e, 0x3361, 0x3365, 0x3369, 0x336c, 0x3370,
	0x3374, 0x3378, 0x337c, 0x337f, 0x3383, 0x3387, 0x338b, 0x338f, 0x3393,
	0x3397, 0x339b, 0x339f, 0x33a3, 0x33a7, 0x33ab, 0x33af, 0x33b3, 0x33b7,
	0x33bb, 0x33bf, 0x33c4, 0x33c8, 0x33cc, 0x33d0, 0x33d5, 0x33d9, 0x33dd,
	0x33e2, 0x33e6, 0x33eb, 0x33ef, 0x33f3, 0x33f8, 0x33fc, 0x3400, 0x3402,
	0x3405, 0x3407, 0x3409, 0x340c, 0x340e, 0x3410, 0x3413, 0x3415, 0x3418,
	0x341a, 0x341c, 0x341f, 0x3421, 0x3424, 0x3426, 0x3429, 0x342b, 0x342e,
	0x3430, 0x3433, 0x3435, 0x3438, 0x343a, 0x343d, 0x3440, 0x3442, 0x3445,
	0x3448, 0x344a, 0x344d, 0x3450, 0x3452, 0x3455, 0x3458, 0x345b, 0x345d,
	0x3460, 0x3463, 0x3466, 0x3469, 0x346b, 0x346e, 0x3471, 0x3474, 0x3477,
	0x347a, 0x347d, 0x3480, 0x3483, 0x3486, 0x3489, 0x348c, 0x348f, 0x3492,
	0x3495, 0x3498, 0x349b, 0x349e, 0x34a2, 0x34a5, 0x34a8, 0x34ab, 0x34ae,
	0x34b2, 0x34b5, 0x34b8, 0x34bb, 0x34bf, 0x34c2, 0x34c5, 0x34c9, 0x34cc,
	0x34cf, 0x34d3, 0x34d6, 0x34da, 0x34dd, 0x34e1, 0x34e4, 0x34e8, 0x34eb,
	0x34ef, 0x34f2, 0x34f6, 0x34fa, 0x34fd, 0x3501, 0x3505, 0x3508, 0x350c,
	0x3510, 0x3514, 0x3517, 0x351b, 0x351f, 0x3523, 0x3527, 0x352b, 0x352f,
	0x3532, 0x3536, 0x353a, 0x353e, 0x3542, 0x3546, 0x354b, 0x354f, 0x3553,
	0x3557, 0x355b, 0x355f, 0x3563, 0x3568, 0x356c, 0x3570, 0x3574, 0x3579,
	0x357d, 0x3581, 0x3586, 0x358a, 0x358f, 0x3593, 0x3598, 0x359c, 0x35a1,
	0x35a5, 0x35aa, 0x35ae, 0x35b3, 0x35b8, 0x35bc, 0x35c1, 0x35c6, 0x35cb,
	0x35cf, 0x35d4, 0x35d9, 0x35de, 0x35e3, 0x35e8, 0x35ed, 0x35f2, 0x35f7,
	0x35fc, 0x3600, 0x3603, 0x3605, 0x3608, 0x360a, 0x360d, 0x3610, 0x3612,
	0x3615, 0x3618, 0x361a, 0x361d, 0x3620, 0x3622, 0x3625, 0x3628, 0x362b,
	0x362d, 0x3630, 0x3633, 0x3636, 0x3639, 0x363b, 0x363e, 0x3641, 0x3644,
	0x3647, 0x364a, 0x364d, 0x3650, 0x3653, 0x3656, 0x3659, 0x365c, 0x365f,
	0x3662, 0x3665, 0x3668, 0x366b, 0x366e, 0x3672, 0x3675, 0x3678, 0x367b,
	0x367e, 0x3682, 0x3685, 0x3688, 0x368b, 0x368f, 0x3692, 0x3695, 0x3699,
	0x369c, 0x36a0, 0x36a3, 0x36a6, 0x36aa, 0x36ad, 0x36b1, 0x36b4, 0x36b8,
	0x36bb, 0x36bf, 0x36c3, 0x36c6, 0x36ca, 0x36cd, 0x36d1, 0x36d5, 0x36d9,
	0x36dc, 0x36e0, 0x36e4, 0x36e8, 0x36eb, 0x36ef, 0x36f3, 0x36f7, 0x36fb,
	0x36ff, 0x3703, 0x3707, 0x370b, 0x370f, 0x3713, 0x3717, 0x371b, 0x371f,
	0x3723, 0x3727, 0x372b, 0x372f, 0x3734, 0x3738, 0x373c, 0x3740, 0x3745,
	0x3749, 0x374d, 0x3752, 0x3756, 0x375b, 0x375f, 0x3764, 0x3768, 0x376d,
	0x3771, 0x3776, 0x377a, 0x377f, 0x3783, 0x3788, 0x378d, 0x3792, 0x3796,
	0x379b, 0x37a0, 0x37a5, 0x37aa, 0x37ae, 0x37b3, 0x37b8, 0x37bd, 0x37c2,
	0x37c7, 0x37cc, 0x37d1, 0x37d6, 0x37dc, 0x37e1, 0x37e6, 0x37eb, 0x37f0,
	0x37f6, 0x37fb, 0x3800, 0x3802, 0x3805, 0x3808, 0x380b, 0x380d, 0x3810,
	0x3813, 0x3816, 0x3818, 0x381b, 0x381e, 0x3821, 0x3824, 0x3827, 0x382a,
	0x382c, 0x382f, 0x3832, 0x3835, 0x3838, 0x383b, 0x383e, 0x3841, 0x3844,
	0x3847, 0x384a, 0x384d, 0x3851, 0x3854, 0x3857, 0x385a, 0x385d, 0x3860,
	0x3864, 0x3867, 0x386a, 0x386d, 0x3870, 0x3874, 0x3877, 0x387a, 0x387e,
	0x3881, 0x3885, 0x3888, 0x388b, 0x388f, 0x3892, 0x3896, 0x3899, 0x389d,
	0x38a0, 0x38a4, 0x38a7, 0x38ab, 0x38af, 0x38b2, 0x38b6, 0x38ba, 0x38bd,
	0x38c1, 0x38c5, 0x38c8, 0x38cc, 0x38d0, 0x38d4, 0x38d8, 0x38dc, 0x38df,
	0x38e3, 0x38e7, 0x38eb, 0x38ef, 0x38f3, 0x38f7, 0x38fb, 0x38ff, 0x3903,
	0x3907, 0x390c, 0x3910, 0x3914, 0x3918, 0x391c, 0x3920, 0x3925, 0x3929,
	0x392d, 0x3932, 0x3936, 0x393a, 0x393f, 0x3943, 0x3948, 0x394c, 0x3951,
	0x3955, 0x395a, 0x395e, 0x3963, 0x3967, 0x396c, 0x3971, 0x3975, 0x397a,
	0x397f, 0x3984, 0x3989, 0x398d, 0x3992, 0x3997, 0x399c, 0x39a1, 0x39a6,
	0x39ab, 0x39b0, 0x39b5, 0x39ba, 0x39bf, 0x39c4, 0x39c9, 0x39cf, 0x39d4,
	0x39d9, 0x39de, 0x39e4, 0x39e9, 0x39ee, 0x39f4, 0x39f9, 0x39ff, 0x3},
	{0x3, 0x0, 0x1, 0x2, 0x4, 0x5, 0x7, 0x8, 0xa, 0xb, 0xd, 0xe, 0xf, 0x11,
	0x12, 0x14, 0x15, 0x17, 0x18, 0x1a, 0x1b, 0x1c, 0x1e, 0x1f, 0x21, 0x22,
	0x24, 0x25, 0x27, 0x28, 0x29, 0x2b, 0x2c, 0x2e, 0x2f, 0x31, 0x32, 0x34,
	0x35, 0x37, 0x38, 0x3a, 0x3b, 0x3d, 0x3f, 0x40, 0x42, 0x44, 0x45, 0x47,
	0x49, 0x4b, 0x4d, 0x4f, 0x51, 0x52, 0x54, 0x56, 0x58, 0x5b, 0x5d, 0x5f,
	0x61, 0x63, 0x65, 0x67, 0x6a, 0x6c, 0x6e, 0x70, 0x73, 0x75, 0x78, 0x7a,
	0x7c, 0x7f, 0x81, 0x84, 0x87, 0x89, 0x8c, 0x8f, 0x91, 0x94, 0x97, 0x99,
	0x9c, 0x9f, 0xa2, 0xa5, 0xa8, 0xab, 0xae, 0xb1, 0xb4, 0xb7, 0xba, 0xbd,
	0xc0, 0xc4, 0xc7, 0xca, 0xcd, 0xd1, 0xd4, 0xd7, 0xdb, 0xde, 0xe2, 0xe5,
	0xe9, 0xec, 0xf0, 0xf4, 0xf7, 0xfb, 0xff, 0x103, 0x106, 0x10a, 0x10e,
	0x112, 0x116, 0x11a, 0x11e, 0x122, 0x126, 0x12a, 0x12e, 0x132, 0x137,
	0x13b, 0x13f, 0x143, 0x148, 0x14c, 0x150, 0x155, 0x159, 0x15e, 0x162,
	0x167, 0x16b, 0x170, 0x175, 0x179, 0x17e, 0x183, 0x188, 0x18d, 0x192,
	0x196, 0x19b, 0x1a0, 0x1a5, 0x1aa, 0x1b0, 0x1b5, 0x1ba, 0x1bf, 0x1c4,
	0x1c9, 0x1cf, 0x1d4, 0x1d9, 0x1df, 0x1e4, 0x1ea, 0x1ef, 0x1f5, 0x1fa,
	0x200, 0x206, 0x20b, 0x211, 0x217, 0x21d, 0x223, 0x228, 0x22e, 0x234,
	0x23a, 0x240, 0x246, 0x24c, 0x253, 0x259, 0x25f, 0x265, 0x26b, 0x272,
	0x278, 0x27f, 0x285, 0x28b, 0x292, 0x298, 0x29f, 0x2a6, 0x2ac, 0x2b3,
	0x2ba, 0x2c1, 0x2c7, 0x2ce, 0x2d5, 0x2dc, 0x2e3, 0x2ea, 0x2f1, 0x2f8,
	0x2ff, 0x306, 0x30e, 0x315, 0x31c, 0x323, 0x32b, 0x332, 0x33a, 0x341,
	0x349, 0x350, 0x358, 0x35f, 0x367, 0x36f, 0x376, 0x37e, 0x386, 0x38e,
	0x396, 0x39e, 0x3a6, 0x3ae, 0x3b6, 0x3be, 0x3c6, 0x3ce, 0x3d6, 0x3df,
	0x3e7, 0x3ef, 0x3f8, 0x400, 0x409, 0x411, 0x41a, 0x422, 0x42b, 0x434,
	0x43c, 0x445, 0x44e, 0x457, 0x45f, 0x468, 0x471, 0x47a, 0x483, 0x48c,
	0x496, 0x49f, 0x4a8, 0x4b1, 0x4bb, 0x4c4, 0x4cd, 0x4d7, 0x4e0, 0x4ea,
	0x4f3, 0x4fd, 0x506, 0x510, 0x51a, 0x523, 0x52d, 0x537, 0x541, 0x54b,
	0x555, 0x55f, 0x569, 0x573, 0x57d, 0x587, 0x592, 0x59c, 0x5a6, 0x5b0,
	0x5bb, 0x5c5, 0x5d0, 0x5da, 0x5e5, 0x5ef, 0x5fa, 0x605, 0x610, 0x61a,
	0x625, 0x630, 0x63b, 0x646, 0x651, 0x65c, 0x667, 0x672, 0x67d, 0x689,
	0x694, 0x69f, 0x6aa, 0x6b6, 0x6c1, 0x6cd, 0x6d8, 0x6e4, 0x6f0, 0x6fb,
	0x707, 0x713, 0x71e, 0x72a, 0x736, 0x742, 0x74e, 0x75a, 0x766, 0x772,
	0x77e, 0x78b, 0x797, 0x7a3, 0x7af, 0x7bc, 0x7c8, 0x7d5, 0x7e1, 0x7ee,
	0x7fa, 0x807, 0x814, 0x821, 0x82d, 0x83a, 0x847, 0x854, 0x861, 0x86e,
	0x87b, 0x888, 0x895, 0x8a3, 0x8b0, 0x8bd, 0x8ca, 0x8d8, 0x8e5, 0x8f3,
	0x900, 0x90e, 0x91b, 0x929, 0x937, 0x945, 0x952, 0x960, 0x96e, 0x97c,
	0x98a, 0x998, 0x9a6, 0x9b4, 0x9c3, 0x9d1, 0x9df, 0x9ed, 0x9fc, 0xa0a,
	0xa19, 0xa27, 0xa36, 0xa44, 0xa53, 0xa62, 0xa70, 0xa7f, 0xa8e, 0xa9d,
	0xaac, 0xabb, 0xaca, 0xad9, 0xae8, 0xaf7, 0xb07, 0xb16, 0xb25, 0xb35,
	0xb44, 0xb53, 0xb63, 0xb73, 0xb82, 0xb92, 0xba2, 0xbb1, 0xbc1, 0xbd1,
	0xbe1, 0xbf1, 0xc01, 0xc11, 0xc21, 0xc31, 0xc41, 0xc52, 0xc62, 0xc72,
	0xc83, 0xc93, 0xca4, 0xcb4, 0xcc5, 0xcd5, 0xce6, 0xcf7, 0xd08, 0xd18,
	0xd29, 0xd3a, 0xd4b, 0xd5c, 0xd6d, 0xd7e, 0xd90, 0xda1, 0xdb2, 0xdc3,
	0xdd5, 0xde6, 0xdf8, 0xe09, 0xe1b, 0xe2d, 0xe3e, 0xe50, 0xe62, 0xe74,
	0xe85, 0xe97, 0xea9, 0xebb, 0xece, 0xee0, 0xef2, 0xf04, 0xf16, 0xf29,
	0xf3b, 0xf4e, 0xf60, 0xf73, 0xf85, 0xf98, 0xfab, 0xfbd, 0xfd0, 0xfe3,
	0xff6, 0x1009, 0x101c, 0x102f, 0x1042, 0x1055, 0x1068, 0x107c, 0x108f,
	0x10a2, 0x10b6, 0x10c9, 0x10dd, 0x10f0, 0x1104, 0x1117, 0x112b, 0x113f,
	0x1153, 0x1167, 0x117b, 0x118f, 0x11a3, 0x11b7, 0x11cb, 0x11df, 0x11f3,
	0x1208, 0x121c, 0x1230, 0x1245, 0x1259, 0x126e, 0x1282, 0x1297, 0x12ac,
	0x12c1, 0x12d5, 0x12ea, 0x12ff, 0x1314, 0x1329, 0x133e, 0x1353, 0x1369,
	0x137e, 0x1393, 0x13a8, 0x13be, 0x13d3, 0x13e9, 0x13fe, 0x1414, 0x142a,
	0x143f, 0x1455, 0x146b, 0x1481, 0x1497, 0x14ad, 0x14c3, 0x14d9, 0x14ef,
	0x1505, 0x151b, 0x1532, 0x1548, 0x155f, 0x1575, 0x158c, 0x15a2, 0x15b9,
	0x15cf, 0x15e6, 0x15fd, 0x1614, 0x162b, 0x1642, 0x1659, 0x1670, 0x1687,
	0x169e, 0x16b5, 0x16cc, 0x16e4, 0x16fb, 0x1713, 0x172a, 0x1742, 0x1759,
	0x1771, 0x1789, 0x17a0, 0x17b8, 0x17d0, 0x17e8, 0x1800, 0x1818, 0x1830,
	0x1848, 0x1860, 0x1879, 0x1891, 0x18a9, 0x18c2, 0x18da, 0x18f3, 0x190b,
	0x1924, 0x193d, 0x1956, 0x196e, 0x1987, 0x19a0, 0x19b9, 0x19d2, 0x19eb,
	0x1a04, 0x1a1e, 0x1a37, 0x1a50, 0x1a69, 0x1a83, 0x1a9c, 0x1ab6, 0x1acf,
	0x1ae9, 0x1b03, 0x1b1d, 0x1b36, 0x1b50, 0x1b6a, 0x1b84, 0x1b9e, 0x1bb8,
	0x1bd2, 0x1bed, 0x1c07, 0x1c21, 0x1c3c, 0x1c56, 0x1c70, 0x1c8b, 0x1ca6,
	0x1cc0, 0x1cdb, 0x1cf6, 0x1d11, 0x1d2b, 0x1d46, 0x1d61, 0x1d7c, 0x1d97,
	0x1db3, 0x1dce, 0x1de9, 0x1e04, 0x1e20, 0x1e3b, 0x1e57, 0x1e72, 0x1e8e,
	0x1eaa, 0x1ec5, 0x1ee1, 0x1efd, 0x1f19, 0x1f35, 0x1f51, 0x1f6d, 0x1f89,
	0x1fa5, 0x1fc1, 0x1fde, 0x1ffa, 0x2017, 0x2033, 0x2050, 0x206c, 0x2089,
	0x20a5, 0x20c2, 0x20df, 0x20fc, 0x2119, 0x2136, 0x2153, 0x2170, 0x218d,
	0x21aa, 0x21c8, 0x21e5, 0x2202, 0x2220, 0x223d, 0x225b, 0x2279, 0x2296,
	0x22b4, 0x22d2, 0x22f0, 0x230e, 0x232c, 0x234a, 0x2368, 0x2386, 0x23a4,
	0x23c2, 0x23e1, 0x23ff, 0x241d, 0x243c, 0x245a, 0x2479, 0x2498, 0x24b7,
	0x24d5, 0x24f4, 0x2513, 0x2532, 0x2551, 0x2570, 0x258f, 0x25af, 0x25ce,
	0x25ed, 0x260d, 0x262c, 0x264b, 0x266b, 0x268b, 0x26aa, 0x26ca, 0x26ea,
	0x270a, 0x272a, 0x274a, 0x276a, 0x278a, 0x27aa, 0x27ca, 0x27ea, 0x280b,
	0x282b, 0x284c, 0x286c, 0x288d, 0x28ad, 0x28ce, 0x28ef, 0x2910, 0x2930,
	0x2951, 0x2972, 0x2993, 0x29b5, 0x29d6, 0x29f7, 0x2a18, 0x2a3a, 0x2a5b,
	0x2a7c, 0x2a9e, 0x2ac0, 0x2ae1, 0x2b03, 0x2b25, 0x2b47, 0x2b68, 0x2b8a,
	0x2bac, 0x2bcf, 0x2bf1, 0x2c13, 0x2c35, 0x2c57, 0x2c7a, 0x2c9c, 0x2cbf,
	0x2ce1, 0x2d04, 0x2d27, 0x2d49, 0x2d6c, 0x2d8f, 0x2db2, 0x2dd5, 0x2df8,
	0x2e1b, 0x2e3e, 0x2e62, 0x2e85, 0x2ea8, 0x2ecc, 0x2eef, 0x2f13, 0x2f36,
	0x2f5a, 0x2f7e, 0x2fa1, 0x2fc5, 0x2fe9, 0x300d, 0x3031, 0x3055, 0x3079,
	0x309e, 0x30c2, 0x30e6, 0x310b, 0x312f, 0x3154, 0x3178, 0x319d, 0x31c1,
	0x31e6, 0x320b, 0x3230, 0x3255, 0x327a, 0x329f, 0x32c4, 0x32e9, 0x330f,
	0x3334, 0x3359, 0x337f, 0x33a4, 0x33ca, 0x33ef, 0x3415, 0x343b, 0x3461,
	0x3487, 0x34ad, 0x34d3, 0x34f9, 0x351f, 0x3545, 0x356b, 0x3592, 0x35b8,
	0x35de, 0x3605, 0x362b, 0x3652, 0x3679, 0x36a0, 0x36c6, 0x36ed, 0x3714,
	0x373b, 0x3762, 0x3789, 0x37b1, 0x37d8, 0x37ff, 0x3827, 0x384e, 0x3876,
	0x389d, 0x38c5, 0x38ed, 0x3914, 0x393c, 0x3964, 0x398c, 0x39b4, 0x39dc,
	0x3a04, 0x3a2c, 0x3a55, 0x3a7d, 0x3aa5, 0x3ace, 0x3af6, 0x3b1f, 0x3b48,
	0x3b70, 0x3b99, 0x3bc2, 0x3beb, 0x3c14, 0x3c3d, 0x3c66, 0x3c8f, 0x3cb8,
	0x3ce2, 0x3d0b, 0x3d35, 0x3d5e, 0x3d88, 0x3db1, 0x3ddb, 0x3e05, 0x3e2e,
	0x3e58, 0x3e82, 0x3eac, 0x3ed6, 0x3f00, 0x3f2b, 0x3f55, 0x3f7f, 0x3faa,
	0x3fd4, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0},
	{0x3, 0x0, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0x8, 0x9, 0xb, 0xc, 0xd, 0xe,
	0x10, 0x11, 0x12, 0x13, 0x15, 0x16, 0x17, 0x18, 0x1a, 0x1b, 0x1c, 0x1d,
	0x1e, 0x20, 0x21, 0x22, 0x23, 0x25, 0x26, 0x27, 0x28, 0x2a, 0x2b, 0x2c,
	0x2d, 0x2f, 0x30, 0x31, 0x32, 0x34, 0x35, 0x36, 0x37, 0x39, 0x3a, 0x3c,
	0x3d, 0x3e, 0x40, 0x41, 0x43, 0x44, 0x46, 0x47, 0x49, 0x4a, 0x4c, 0x4d,
	0x4f, 0x51, 0x52, 0x54, 0x56, 0x57, 0x59, 0x5b, 0x5d, 0x5f, 0x60, 0x62,
	0x64, 0x66, 0x68, 0x6a, 0x6c, 0x6e, 0x70, 0x72, 0x74, 0x76, 0x78, 0x7a,
	0x7c, 0x7e, 0x80, 0x82, 0x85, 0x87, 0x89, 0x8b, 0x8e, 0x90, 0x92, 0x94,
	0x97, 0x99, 0x9c, 0x9e, 0xa0, 0xa3, 0xa5, 0xa8, 0xaa, 0xad, 0xb0, 0xb2,
	0xb5, 0xb7, 0xba, 0xbd, 0xc0, 0xc2, 0xc5, 0xc8, 0xcb, 0xcd, 0xd0, 0xd3,
	0xd6, 0xd9, 0xdc, 0xdf, 0xe2, 0xe5, 0xe8, 0xeb, 0xee, 0xf1, 0xf4, 0xf7,
	0xfb, 0xfe, 0x101, 0x104, 0x108, 0x10b, 0x10e, 0x111, 0x115, 0x118,
	0x11c, 0x11f, 0x123, 0x126, 0x12a, 0x12d, 0x131, 0x134, 0x138, 0x13b,
	0x13f, 0x143, 0x146, 0x14a, 0x14e, 0x152, 0x155, 0x159, 0x15d, 0x161,
	0x165, 0x169, 0x16d, 0x171, 0x175, 0x179, 0x17d, 0x181, 0x185, 0x189,
	0x18d, 0x192, 0x196, 0x19a, 0x19e, 0x1a2, 0x1a7, 0x1ab, 0x1af, 0x1b4,
	0x1b8, 0x1bd, 0x1c1, 0x1c6, 0x1ca, 0x1cf, 0x1d3, 0x1d8, 0x1dc, 0x1e1,
	0x1e6, 0x1ea, 0x1ef, 0x1f4, 0x1f9, 0x1fe, 0x202, 0x207, 0x20c, 0x211,
	0x216, 0x21b, 0x220, 0x225, 0x22a, 0x22f, 0x234, 0x239, 0x23e, 0x244,
	0x249, 0x24e, 0x253, 0x258, 0x25e, 0x263, 0x269, 0x26e, 0x273, 0x279,
	0x27e, 0x284, 0x289, 0x28f, 0x294, 0x29a, 0x2a0, 0x2a5, 0x2ab, 0x2b1,
	0x2b7, 0x2bc, 0x2c2, 0x2c8, 0x2ce, 0x2d4, 0x2da, 0x2e0, 0x2e6, 0x2ec,
	0x2f2, 0x2f8, 0x2fe, 0x304, 0x30a, 0x310, 0x316, 0x31d, 0x323, 0x329,
	0x32f, 0x336, 0x33c, 0x343, 0x349, 0x350, 0x356, 0x35d, 0x363, 0x36a,
	0x370, 0x377, 0x37e, 0x384, 0x38b, 0x392, 0x398, 0x39f, 0x3a6, 0x3ad,
	0x3b4, 0x3bb, 0x3c2, 0x3c9, 0x3d0, 0x3d7, 0x3de, 0x3e5, 0x3ec, 0x3f3,
	0x3fb, 0x402, 0x409, 0x410, 0x418, 0x41f, 0x426, 0x42e, 0x435, 0x43d,
	0x444, 0x44c, 0x453, 0x45b, 0x462, 0x46a, 0x472, 0x479, 0x481, 0x489,
	0x491, 0x499, 0x4a0, 0x4a8, 0x4b0, 0x4b8, 0x4c0, 0x4c8, 0x4d0, 0x4d8,
	0x4e0, 0x4e8, 0x4f1, 0x4f9, 0x501, 0x509, 0x512, 0x51a, 0x522, 0x52b,
	0x533, 0x53b, 0x544, 0x54c, 0x555, 0x55e, 0x566, 0x56f, 0x577, 0x580,
	0x589, 0x592, 0x59a, 0x5a3, 0x5ac, 0x5b5, 0x5be, 0x5c7, 0x5d0, 0x5d9,
	0x5e2, 0x5eb, 0x5f4, 0x5fd, 0x606, 0x60f, 0x619, 0x622, 0x62b, 0x635,
	0x63e, 0x647, 0x651, 0x65a, 0x664, 0x66d, 0x677, 0x680, 0x68a, 0x694,
	0x69d, 0x6a7, 0x6b1, 0x6bb, 0x6c4, 0x6ce, 0x6d8, 0x6e2, 0x6ec, 0x6f6,
	0x700, 0x70a, 0x714, 0x71e, 0x728, 0x732, 0x73d, 0x747, 0x751, 0x75b,
	0x766, 0x770, 0x77a, 0x785, 0x78f, 0x79a, 0x7a4, 0x7af, 0x7ba, 0x7c4,
	0x7cf, 0x7da, 0x7e4, 0x7ef, 0x7fa, 0x805, 0x810, 0x81a, 0x825, 0x830,
	0x83b, 0x846, 0x851, 0x85d, 0x868, 0x873, 0x87e, 0x889, 0x895, 0x8a0,
	0x8ab, 0x8b7, 0x8c2, 0x8cd, 0x8d9, 0x8e4, 0x8f0, 0x8fb, 0x907, 0x913,
	0x91e, 0x92a, 0x936, 0x942, 0x94d, 0x959, 0x965, 0x971, 0x97d, 0x989,
	0x995, 0x9a1, 0x9ad, 0x9b9, 0x9c5, 0x9d2, 0x9de, 0x9ea, 0x9f6, 0xa03,
	0xa0f, 0xa1c, 0xa28, 0xa34, 0xa41, 0xa4d, 0xa5a, 0xa67, 0xa73, 0xa80,
	0xa8d, 0xa99, 0xaa6, 0xab3, 0xac0, 0xacd, 0xada, 0xae7, 0xaf4, 0xb01,
	0xb0e, 0xb1b, 0xb28, 0xb35, 0xb42, 0xb50, 0xb5d, 0xb6a, 0xb77, 0xb85,
	0xb92, 0xba0, 0xbad, 0xbbb, 0xbc8, 0xbd6, 0xbe4, 0xbf1, 0xbff, 0xc0d,
	0xc1a, 0xc28, 0xc36, 0xc44, 0xc52, 0xc60, 0xc6e, 0xc7c, 0xc8a, 0xc98,
	0xca6, 0xcb4, 0xcc3, 0xcd1, 0xcdf, 0xced, 0xcfc, 0xd0a, 0xd19, 0xd27,
	0xd35, 0xd44, 0xd53, 0xd61, 0xd70, 0xd7e, 0xd8d, 0xd9c, 0xdab, 0xdba,
	0xdc8, 0xdd7, 0xde6, 0xdf5, 0xe04, 0xe13, 0xe22, 0xe31, 0xe41, 0xe50,
	0xe5f, 0xe6e, 0xe7e, 0xe8d, 0xe9c, 0xeac, 0xebb, 0xecb, 0xeda, 0xeea,
	0xef9, 0xf09, 0xf19, 0xf28, 0xf38, 0xf48, 0xf58, 0xf68, 0xf77, 0xf87,
	0xf97, 0xfa7, 0xfb7, 0xfc7, 0xfd8, 0xfe8, 0xff8, 0x1008, 0x1018,
	0x1029, 0x1039, 0x1049, 0x105a, 0x106a, 0x107b, 0x108b, 0x109c, 0x10ad,
	0x10bd, 0x10ce, 0x10df, 0x10ef, 0x1100, 0x1111, 0x1122, 0x1133, 0x1144,
	0x1155, 0x1166, 0x1177, 0x1188, 0x1199, 0x11aa, 0x11bb, 0x11cd, 0x11de,
	0x11ef, 0x1201, 0x1212, 0x1223, 0x1235, 0x1246, 0x1258, 0x126a, 0x127b,
	0x128d, 0x129f, 0x12b0, 0x12c2, 0x12d4, 0x12e6, 0x12f8, 0x130a, 0x131c,
	0x132e, 0x1340, 0x1352, 0x1364, 0x1376, 0x1388, 0x139b, 0x13ad, 0x13bf,
	0x13d2, 0x13e4, 0x13f6, 0x1409, 0x141c, 0x142e, 0x1441, 0x1453, 0x1466,
	0x1479, 0x148b, 0x149e, 0x14b1, 0x14c4, 0x14d7, 0x14ea, 0x14fd, 0x1510,
	0x1523, 0x1536, 0x1549, 0x155c, 0x1570, 0x1583, 0x1596, 0x15aa, 0x15bd,
	0x15d0, 0x15e4, 0x15f7, 0x160b, 0x161e, 0x1632, 0x1646, 0x1659, 0x166d,
	0x1681, 0x1695, 0x16a9, 0x16bd, 0x16d1, 0x16e4, 0x16f9, 0x170d, 0x1721,
	0x1735, 0x1749, 0x175d, 0x1771, 0x1786, 0x179a, 0x17af, 0x17c3, 0x17d7,
	0x17ec, 0x1800, 0x1815, 0x182a, 0x183e, 0x1853, 0x1868, 0x187d, 0x1891,
	0x18a6, 0x18bb, 0x18d0, 0x18e5, 0x18fa, 0x190f, 0x1924, 0x1939, 0x194f,
	0x1964, 0x1979, 0x198e, 0x19a4, 0x19b9, 0x19cf, 0x19e4, 0x19fa, 0x1a0f,
	0x1a25, 0x1a3a, 0x1a50, 0x1a66, 0x1a7b, 0x1a91, 0x1aa7, 0x1abd, 0x1ad3,
	0x1ae9, 0x1aff, 0x1b15, 0x1b2b, 0x1b41, 0x1b57, 0x1b6d, 0x1b84, 0x1b9a,
	0x1bb0, 0x1bc7, 0x1bdd, 0x1bf4, 0x1c0a, 0x1c21, 0x1c37, 0x1c4e, 0x1c64,
	0x1c7b, 0x1c92, 0x1ca9, 0x1cbf, 0x1cd6, 0x1ced, 0x1d04, 0x1d1b, 0x1d32,
	0x1d49, 0x1d60, 0x1d78, 0x1d8f, 0x1da6, 0x1dbd, 0x1dd5, 0x1dec, 0x1e03,
	0x1e1b, 0x1e32, 0x1e4a, 0x1e61, 0x1e79, 0x1e91, 0x1ea8, 0x1ec0, 0x1ed8,
	0x1ef0, 0x1f07, 0x1f1f, 0x1f37, 0x1f4f, 0x1f67, 0x1f7f, 0x1f98, 0x1fb0,
	0x1fc8, 0x1fe0, 0x1ff8, 0x2011, 0x2029, 0x2042, 0x205a, 0x2072, 0x208b,
	0x20a4, 0x20bc, 0x20d5, 0x20ee, 0x2106, 0x211f, 0x2138, 0x2151, 0x216a,
	0x2183, 0x219c, 0x21b5, 0x21ce, 0x21e7, 0x2200, 0x2219, 0x2233, 0x224c,
	0x2265, 0x227f, 0x2298, 0x22b2, 0x22cb, 0x22e5, 0x22fe, 0x2318, 0x2331,
	0x234b, 0x2365, 0x237f, 0x2399, 0x23b3, 0x23cc, 0x23e6, 0x2401, 0x241b,
	0x2435, 0x244f, 0x2469, 0x2483, 0x249e, 0x24b8, 0x24d2, 0x24ed, 0x2507,
	0x2522, 0x253c, 0x2557, 0x2571, 0x258c, 0x25a7, 0x25c2, 0x25dc, 0x25f7,
	0x2612, 0x262d, 0x2648, 0x2663, 0x267e, 0x2699, 0x26b4, 0x26cf, 0x26eb,
	0x2706, 0x2721, 0x273d, 0x2758, 0x2774, 0x278f, 0x27ab, 0x27c6, 0x27e2,
	0x27fd, 0x2819, 0x2835, 0x2851, 0x286d, 0x2888, 0x28a4, 0x28c0, 0x28dc,
	0x28f8, 0x2915, 0x2931, 0x294d, 0x2969, 0x2985, 0x29a2, 0x29be, 0x29db,
	0x29f7, 0x2a14, 0x2a30, 0x2a4d, 0x2a69, 0x2a86, 0x2aa3, 0x2ac0, 0x2adc,
	0x2af9, 0x2b16, 0x2b33, 0x2b50, 0x2b6d, 0x2b8a, 0x2ba7, 0x2bc4, 0x2be2,
	0x2bff, 0x2c1c, 0x2c3a, 0x2c57, 0x2c74, 0x2c92, 0x2caf, 0x2ccd, 0x2ceb,
	0x2d08, 0x2d26, 0x2d44, 0x2d61, 0x2d7f, 0x2d9d, 0x2dbb, 0x2dd9, 0x2df7,
	0x2e15, 0x2e33, 0x2e51, 0x2e70, 0x2e8e, 0x2eac, 0x2eca, 0x2ee9, 0x2f07,
	0x2f26, 0x2f44, 0x2f63, 0x2f81, 0x2fa0, 0x2fbf, 0x2fdd, 0x2ffc, 0x301b,
	0x303a, 0x3059, 0x3078, 0x3097, 0x30b6, 0x30d5, 0x30f4, 0x3113, 0x3132,
	0x3152, 0x3171, 0x3190, 0x31b0, 0x31cf, 0x31ef, 0x320e, 0x322e, 0x324e,
	0x326d, 0x328d, 0x32ad, 0x32cd, 0x32ec, 0x330c, 0x332c, 0x334c, 0x336c,
	0x338c, 0x33ac, 0x33cd, 0x33ed, 0x340d, 0x342e, 0x344e, 0x346e, 0x348f,
	0x34af, 0x34d0, 0x34f0, 0x3511, 0x3532, 0x3552, 0x3573, 0x3594, 0x35b5,
	0x35d6, 0x35f7, 0x3618, 0x3639, 0x365a, 0x367b, 0x369c, 0x36bd, 0x36df,
	0x3700, 0x3721, 0x3743, 0x3764, 0x3786, 0x37a7, 0x37c9, 0x37eb, 0x380c,
	0x382e, 0x3850, 0x3872, 0x3894, 0x38b6, 0x38d8, 0x38fa, 0x391c, 0x393e,
	0x3960, 0x3982, 0x39a4, 0x39c7, 0x39e9, 0x3a0b, 0x3a2e, 0x3a50, 0x3a73,
	0x3a95, 0x3ab8, 0x3adb, 0x3afd, 0x3b20, 0x3b43, 0x3b66, 0x3b89, 0x3bac,
	0x3bcf, 0x3bf2, 0x3c15, 0x3c38, 0x3c5b, 0x3c7e, 0x3ca2, 0x3cc5, 0x3ce8,
	0x3d0c, 0x3d2f, 0x3d53, 0x3d76, 0x3d9a, 0x3dbe, 0x3de1, 0x3e05, 0x3e29,
	0x3e4d, 0x3e71, 0x3e95, 0x3eb9, 0x3edd, 0x3f01, 0x3f25, 0x3f49, 0x3f6d,
	0x3f91, 0x3fb6, 0x3fda, 0x3fff, 0x0},
	{0x3, 0x0, 0x200, 0x600, 0x800, 0x980, 0xaa0, 0xba0, 0xc70, 0xd20,
	0xde0, 0xe58, 0xed0, 0xf58, 0xfe0, 0x103c, 0x1090, 0x10e8, 0x1144,
	0x11a8, 0x120a, 0x1242, 0x127e, 0x12bc, 0x1300, 0x1346, 0x138e, 0x13dc,
	0x1416, 0x1441, 0x146d, 0x149b, 0x14cc, 0x14fe, 0x1532, 0x1569, 0x15a2,
	0x15dd, 0x160d, 0x162c, 0x164d, 0x166f, 0x1693, 0x16b7, 0x16dd, 0x1704,
	0x172c, 0x1756, 0x1781, 0x17ad, 0x17db, 0x1805, 0x181d, 0x1836, 0x1850,
	0x186b, 0x1886, 0x18a2, 0x18bf, 0x18dd, 0x18fb, 0x191b, 0x193b, 0x195c,
	0x197e, 0x19a1, 0x19c5, 0x19e9, 0x1a07, 0x1a1b, 0x1a2e, 0x1a43, 0x1a57,
	0x1a6d, 0x1a83, 0x1a99, 0x1ab0, 0x1ac7, 0x1adf, 0x1af8, 0x1b11, 0x1b2a,
	0x1b45, 0x1b5f, 0x1b7b, 0x1b97, 0x1bb4, 0x1bd1, 0x1bef, 0x1c06, 0x1c16,
	0x1c26, 0x1c36, 0x1c47, 0x1c58, 0x1c69, 0x1c7b, 0x1c8d, 0x1c9f, 0x1cb2,
	0x1cc5, 0x1cd9, 0x1ced, 0x1d01, 0x1d16, 0x1d2b, 0x1d40, 0x1d56, 0x1d6d,
	0x1d83, 0x1d9b, 0x1db2, 0x1dca, 0x1de3, 0x1dfc, 0x1e0a, 0x1e17, 0x1e25,
	0x1e32, 0x1e40, 0x1e4e, 0x1e5c, 0x1e6a, 0x1e79, 0x1e88, 0x1e97, 0x1ea7,
	0x1eb7, 0x1ec7, 0x1ed7, 0x1ee8, 0x1ef9, 0x1f0a, 0x1f1b, 0x1f2d, 0x1f3f,
	0x1f52, 0x1f64, 0x1f77, 0x1f8b, 0x1f9e, 0x1fb2, 0x1fc6, 0x1fdb, 0x1ff0,
	0x2002, 0x200d, 0x2018, 0x2024, 0x202f, 0x203a, 0x2046, 0x2052, 0x205e,
	0x206a, 0x2077, 0x2084, 0x2091, 0x209e, 0x20ab, 0x20b8, 0x20c6, 0x20d4,
	0x20e2, 0x20f1, 0x20ff, 0x210e, 0x211d, 0x212c, 0x213c, 0x214b, 0x215b,
	0x216b, 0x217c, 0x218d, 0x219d, 0x21af, 0x21c0, 0x21d2, 0x21e4, 0x21f6,
	0x2204, 0x220d, 0x2217, 0x2220, 0x222a, 0x2234, 0x223e, 0x2248, 0x2253,
	0x225d, 0x2268, 0x2273, 0x227d, 0x2289, 0x2294, 0x229f, 0x22ab, 0x22b6,
	0x22c2, 0x22ce, 0x22db, 0x22e7, 0x22f4, 0x2300, 0x230d, 0x231a, 0x2328,
	0x2335, 0x2343, 0x2350, 0x235e, 0x236d, 0x237b, 0x238a, 0x2398, 0x23a7,
	0x23b7, 0x23c6, 0x23d5, 0x23e5, 0x23f5, 0x2402, 0x240b, 0x2413, 0x241b,
	0x2424, 0x242d, 0x2435, 0x243e, 0x2447, 0x2450, 0x245a, 0x2463, 0x246c,
	0x2476, 0x2480, 0x248a, 0x2493, 0x249e, 0x24a8, 0x24b2, 0x24bd, 0x24c7,
	0x24d2, 0x24dd, 0x24e8, 0x24f3, 0x24fe, 0x250a, 0x2515, 0x2521, 0x252d,
	0x2539, 0x2545, 0x2552, 0x255e, 0x256b, 0x2578, 0x2584, 0x2592, 0x259f,
	0x25ac, 0x25ba, 0x25c8, 0x25d6, 0x25e4, 0x25f2, 0x2600, 0x2607, 0x260f,
	0x2616, 0x261e, 0x2626, 0x262d, 0x2635, 0x263d, 0x2645, 0x264d, 0x2656,
	0x265e, 0x2666, 0x266f, 0x2678, 0x2680, 0x2689, 0x2692, 0x269b, 0x26a5,
	0x26ae, 0x26b7, 0x26c1, 0x26ca, 0x26d4, 0x26de, 0x26e8, 0x26f2, 0x26fc,
	0x2707, 0x2711, 0x271c, 0x2726, 0x2731, 0x273c, 0x2747, 0x2753, 0x275e,
	0x2769, 0x2775, 0x2781, 0x278d, 0x2799, 0x27a5, 0x27b1, 0x27bd, 0x27ca,
	0x27d7, 0x27e4, 0x27f1, 0x27fe, 0x2805, 0x280c, 0x2813, 0x281a, 0x2821,
	0x2828, 0x282f, 0x2836, 0x283d, 0x2845, 0x284c, 0x2854, 0x285b, 0x2863,
	0x286b, 0x2873, 0x287b, 0x2883, 0x288b, 0x2893, 0x289c, 0x28a4, 0x28ad,
	0x28b5, 0x28be, 0x28c7, 0x28d0, 0x28d9, 0x28e2, 0x28eb, 0x28f4, 0x28fe,
	0x2907, 0x2911, 0x291b, 0x2925, 0x292f, 0x2939, 0x2943, 0x294d, 0x2958,
	0x2962, 0x296d, 0x2977, 0x2982, 0x298d, 0x2998, 0x29a4, 0x29af, 0x29bb,
	0x29c6, 0x29d2, 0x29de, 0x29ea, 0x29f6, 0x2a01, 0x2a07, 0x2a0d, 0x2a14,
	0x2a1a, 0x2a21, 0x2a27, 0x2a2e, 0x2a34, 0x2a3b, 0x2a42, 0x2a49, 0x2a50,
	0x2a57, 0x2a5e, 0x2a65, 0x2a6d, 0x2a74, 0x2a7b, 0x2a83, 0x2a8a, 0x2a92,
	0x2a9a, 0x2aa2, 0x2aaa, 0x2ab2, 0x2aba, 0x2ac2, 0x2aca, 0x2ad3, 0x2adb,
	0x2ae4, 0x2aec, 0x2af5, 0x2afe, 0x2b07, 0x2b10, 0x2b19, 0x2b22, 0x2b2b,
	0x2b35, 0x2b3e, 0x2b48, 0x2b52, 0x2b5c, 0x2b65, 0x2b6f, 0x2b7a, 0x2b84,
	0x2b8e, 0x2b99, 0x2ba3, 0x2bae, 0x2bb9, 0x2bc4, 0x2bcf, 0x2bda, 0x2be5,
	0x2bf0, 0x2bfc, 0x2c03, 0x2c09, 0x2c0f, 0x2c15, 0x2c1b, 0x2c21, 0x2c28,
	0x2c2e, 0x2c34, 0x2c3b, 0x2c41, 0x2c48, 0x2c4e, 0x2c55, 0x2c5b, 0x2c62,
	0x2c69, 0x2c70, 0x2c77, 0x2c7e, 0x2c85, 0x2c8c, 0x2c94, 0x2c9b, 0x2ca3,
	0x2caa, 0x2cb2, 0x2cb9, 0x2cc1, 0x2cc9, 0x2cd1, 0x2cd9, 0x2ce1, 0x2ce9,
	0x2cf2, 0x2cfa, 0x2d02, 0x2d0b, 0x2d13, 0x2d1c, 0x2d25, 0x2d2e, 0x2d37,
	0x2d40, 0x2d49, 0x2d52, 0x2d5c, 0x2d65, 0x2d6f, 0x2d78, 0x2d82, 0x2d8c,
	0x2d96, 0x2da0, 0x2daa, 0x2db4, 0x2dbf, 0x2dc9, 0x2dd4, 0x2dde, 0x2de9,
	0x2df4, 0x2dff, 0x2e05, 0x2e0b, 0x2e10, 0x2e16, 0x2e1c, 0x2e22, 0x2e28,
	0x2e2d, 0x2e34, 0x2e3a, 0x2e40, 0x2e46, 0x2e4c, 0x2e53, 0x2e59, 0x2e60,
	0x2e66, 0x2e6d, 0x2e73, 0x2e7a, 0x2e81, 0x2e88, 0x2e8f, 0x2e96, 0x2e9d,
	0x2ea4, 0x2eab, 0x2eb3, 0x2eba, 0x2ec2, 0x2ec9, 0x2ed1, 0x2ed9, 0x2ee0,
	0x2ee8, 0x2ef0, 0x2ef8, 0x2f00, 0x2f09, 0x2f11, 0x2f19, 0x2f22, 0x2f2a,
	0x2f33, 0x2f3c, 0x2f44, 0x2f4d, 0x2f56, 0x2f5f, 0x2f68, 0x2f72, 0x2f7b,
	0x2f85, 0x2f8e, 0x2f98, 0x2fa1, 0x2fab, 0x2fb5, 0x2fbf, 0x2fc9, 0x2fd4,
	0x2fde, 0x2fe8, 0x2ff3, 0x2ffe, 0x3004, 0x3009, 0x300f, 0x3014, 0x301a,
	0x3020, 0x3025, 0x302b, 0x3031, 0x3037, 0x303d, 0x3043, 0x3049, 0x304f,
	0x3055, 0x305c, 0x3062, 0x3068, 0x306f, 0x3075, 0x307c, 0x3083, 0x3089,
	0x3090, 0x3097, 0x309e, 0x30a5, 0x30ac, 0x30b3, 0x30ba, 0x30c2, 0x30c9,
	0x30d1, 0x30d8, 0x30e0, 0x30e7, 0x30ef, 0x30f7, 0x30ff, 0x3107, 0x310f,
	0x3117, 0x311f, 0x3128, 0x3130, 0x3139, 0x3141, 0x314a, 0x3153, 0x315b,
	0x3164, 0x316d, 0x3176, 0x3180, 0x3189, 0x3192, 0x319c, 0x31a5, 0x31af,
	0x31b9, 0x31c3, 0x31cd, 0x31d7, 0x31e1, 0x31eb, 0x31f6, 0x3200, 0x3205,
	0x320a, 0x3210, 0x3215, 0x321b, 0x3220, 0x3226, 0x322c, 0x3232, 0x3237,
	0x323d, 0x3243, 0x3249, 0x324f, 0x3255, 0x325b, 0x3262, 0x3268, 0x326e,
	0x3275, 0x327b, 0x3282, 0x3288, 0x328f, 0x3296, 0x329d, 0x32a4, 0x32ab,
	0x32b2, 0x32b9, 0x32c0, 0x32c7, 0x32cf, 0x32d6, 0x32dd, 0x32e5, 0x32ed,
	0x32f4, 0x32fc, 0x3304, 0x330c, 0x3314, 0x331c, 0x3324, 0x332d, 0x3335,
	0x333d, 0x3346, 0x334f, 0x3357, 0x3360, 0x3369, 0x3372, 0x337b, 0x3384,
	0x338d, 0x3397, 0x33a0, 0x33aa, 0x33b3, 0x33bd, 0x33c7, 0x33d1, 0x33db,
	0x33e5, 0x33ef, 0x33fa, 0x3402, 0x3407, 0x340d, 0x3412, 0x3417, 0x341d,
	0x3422, 0x3428, 0x342e, 0x3434, 0x3439, 0x343f, 0x3445, 0x344b, 0x3451,
	0x3457, 0x345d, 0x3464, 0x346a, 0x3470, 0x3477, 0x347d, 0x3484, 0x348a,
	0x3491, 0x3498, 0x349f, 0x34a6, 0x34ad, 0x34b4, 0x34bb, 0x34c2, 0x34c9,
	0x34d1, 0x34d8, 0x34df, 0x34e7, 0x34ef, 0x34f6, 0x34fe, 0x3506, 0x350e,
	0x3516, 0x351e, 0x3526, 0x352f, 0x3537, 0x3540, 0x3548, 0x3551, 0x355a,
	0x3562, 0x356b, 0x3574, 0x357e, 0x3587, 0x3590, 0x359a, 0x35a3, 0x35ad,
	0x35b6, 0x35c0, 0x35ca, 0x35d4, 0x35de, 0x35e8, 0x35f3, 0x35fd, 0x3604,
	0x3609, 0x360e, 0x3614, 0x3619, 0x361f, 0x3624, 0x362a, 0x3630, 0x3636,
	0x363b, 0x3641, 0x3647, 0x364d, 0x3654, 0x365a, 0x3660, 0x3666, 0x366d,
	0x3673, 0x367a, 0x3680, 0x3687, 0x368d, 0x3694, 0x369b, 0x36a2, 0x36a9,
	0x36b0, 0x36b7, 0x36be, 0x36c6, 0x36cd, 0x36d5, 0x36dc, 0x36e4, 0x36eb,
	0x36f3, 0x36fb, 0x3703, 0x370b, 0x3713, 0x371b, 0x3724, 0x372c, 0x3734,
	0x373d, 0x3746, 0x374e, 0x3757, 0x3760, 0x3769, 0x3772, 0x377b, 0x3785,
	0x378e, 0x3798, 0x37a1, 0x37ab, 0x37b5, 0x37bf, 0x37c9, 0x37d3, 0x37dd,
	0x37e7, 0x37f2, 0x37fd, 0x3803, 0x3809, 0x380e, 0x3814, 0x3819, 0x381f,
	0x3825, 0x382a, 0x3830, 0x3836, 0x383c, 0x3842, 0x3848, 0x384e, 0x3855,
	0x385b, 0x3861, 0x3868, 0x386e, 0x3875, 0x387b, 0x3882, 0x3889, 0x3890,
	0x3897, 0x389e, 0x38a5, 0x38ac, 0x38b3, 0x38ba, 0x38c2, 0x38c9, 0x38d1,
	0x38d8, 0x38e0, 0x38e8, 0x38f0, 0x38f8, 0x3900, 0x3908, 0x3910, 0x3919,
	0x3921, 0x3929, 0x3932, 0x393b, 0x3944, 0x394c, 0x3955, 0x395f, 0x3968,
	0x3971, 0x397a, 0x3984, 0x398e, 0x3997, 0x39a1, 0x39ab, 0x39b5, 0x39bf,
	0x39c9, 0x39d4, 0x39de, 0x39e9, 0x39f4, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x3},
	{0x3, 0x0, 0x4, 0x8, 0xc, 0x10, 0x14, 0x18, 0x1c, 0x20, 0x24, 0x28,
	0x2c, 0x30, 0x34, 0x38, 0x3c, 0x41, 0x45, 0x49, 0x4d, 0x51, 0x55, 0x59,
	0x5d, 0x61, 0x65, 0x69, 0x6d, 0x71, 0x75, 0x79, 0x7d, 0x82, 0x86, 0x8a,
	0x8e, 0x92, 0x96, 0x9a, 0x9e, 0xa2, 0xa6, 0xaa, 0xae, 0xb2, 0xb6, 0xba,
	0xbe, 0xc3, 0xc7, 0xcb, 0xcf, 0xd3, 0xd7, 0xdb, 0xdf, 0xe3, 0xe7, 0xeb,
	0xef, 0xf3, 0xf7, 0xfb, 0xff, 0x104, 0x108, 0x10c, 0x110, 0x114, 0x118,
	0x11c, 0x120, 0x124, 0x127, 0x12b, 0x12f, 0x134, 0x138, 0x13c, 0x140,
	0x144, 0x149, 0x14d, 0x151, 0x156, 0x15a, 0x15f, 0x163, 0x168, 0x16c,
	0x171, 0x175, 0x17a, 0x17f, 0x183, 0x188, 0x18d, 0x192, 0x197, 0x19b,
	0x1a0, 0x1a5, 0x1aa, 0x1af, 0x1b4, 0x1b9, 0x1be, 0x1c3, 0x1c9, 0x1ce,
	0x1d3, 0x1d8, 0x1dd, 0x1e3, 0x1e8, 0x1ed, 0x1f3, 0x1f8, 0x1fe, 0x203,
	0x209, 0x20e, 0x214, 0x21a, 0x21f, 0x225, 0x22b, 0x230, 0x236, 0x23c,
	0x242, 0x248, 0x24e, 0x254, 0x25a, 0x260, 0x266, 0x26c, 0x272, 0x278,
	0x27e, 0x285, 0x28b, 0x291, 0x297, 0x29e, 0x2a4, 0x2ab, 0x2b1, 0x2b8,
	0x2be, 0x2c5, 0x2cb, 0x2d2, 0x2d9, 0x2df, 0x2e6, 0x2ed, 0x2f4, 0x2fa,
	0x301, 0x308, 0x30f, 0x316, 0x31d, 0x324, 0x32b, 0x332, 0x339, 0x341,
	0x348, 0x34f, 0x356, 0x35e, 0x365, 0x36c, 0x374, 0x37b, 0x383, 0x38a,
	0x392, 0x399, 0x3a1, 0x3a8, 0x3b0, 0x3b8, 0x3c0, 0x3c7, 0x3cf, 0x3d7,
	0x3df, 0x3e7, 0x3ef, 0x3f7, 0x3ff, 0x407, 0x40f, 0x417, 0x41f, 0x427,
	0x430, 0x438, 0x440, 0x449, 0x451, 0x459, 0x462, 0x46a, 0x473, 0x47b,
	0x484, 0x48d, 0x495, 0x49e, 0x4a7, 0x4af, 0x4b8, 0x4c1, 0x4ca, 0x4d3,
	0x4dc, 0x4e5, 0x4ee, 0x4f7, 0x500, 0x509, 0x512, 0x51b, 0x525, 0x52e,
	0x537, 0x540, 0x54a, 0x553, 0x55d, 0x566, 0x570, 0x579, 0x583, 0x58c,
	0x596, 0x5a0, 0x5a9, 0x5b3, 0x5bd, 0x5c7, 0x5d1, 0x5db, 0x5e5, 0x5ef,
	0x5f9, 0x603, 0x60d, 0x617, 0x621, 0x62b, 0x635, 0x640, 0x64a, 0x654,
	0x65f, 0x669, 0x674, 0x67e, 0x689, 0x693, 0x69e, 0x6a8, 0x6b3, 0x6be,
	0x6c8, 0x6d3, 0x6de, 0x6e9, 0x6f4, 0x6ff, 0x70a, 0x715, 0x720, 0x72b,
	0x736, 0x741, 0x74c, 0x757, 0x763, 0x76e, 0x779, 0x785, 0x790, 0x79c,
	0x7a7, 0x7b3, 0x7be, 0x7ca, 0x7d5, 0x7e1, 0x7ed, 0x7f8, 0x804, 0x810,
	0x81c, 0x828, 0x834, 0x840, 0x84c, 0x858, 0x864, 0x870, 0x87c, 0x888,
	0x894, 0x8a1, 0x8ad, 0x8b9, 0x8c6, 0x8d2, 0x8df, 0x8eb, 0x8f8, 0x904,
	0x911, 0x91d, 0x92a, 0x937, 0x944, 0x950, 0x95d, 0x96a, 0x977, 0x984,
	0x991, 0x99e, 0x9ab, 0x9b8, 0x9c5, 0x9d2, 0x9e0, 0x9ed, 0x9fa, 0xa07,
	0xa15, 0xa22, 0xa30, 0xa3d, 0xa4b, 0xa58, 0xa66, 0xa73, 0xa81, 0xa8f,
	0xa9d, 0xaaa, 0xab8, 0xac6, 0xad4, 0xae2, 0xaf0, 0xafe, 0xb0c, 0xb1a,
	0xb28, 0xb36, 0xb44, 0xb53, 0xb61, 0xb6f, 0xb7e, 0xb8c, 0xb9a, 0xba9,
	0xbb7, 0xbc6, 0xbd5, 0xbe3, 0xbf2, 0xc01, 0xc0f, 0xc1e, 0xc2d, 0xc3c,
	0xc4b, 0xc5a, 0xc69, 0xc78, 0xc87, 0xc96, 0xca5, 0xcb4, 0xcc3, 0xcd3,
	0xce2, 0xcf1, 0xd01, 0xd10, 0xd1f, 0xd2f, 0xd3f, 0xd4e, 0xd5e, 0xd6d,
	0xd7d, 0xd8d, 0xd9c, 0xdac, 0xdbc, 0xdcc, 0xddc, 0xdec, 0xdfc, 0xe0c,
	0xe1c, 0xe2c, 0xe3c, 0xe4c, 0xe5d, 0xe6d, 0xe7d, 0xe8e, 0xe9e, 0xeae,
	0xebf, 0xecf, 0xee0, 0xef1, 0xf01, 0xf12, 0xf23, 0xf33, 0xf44, 0xf55,
	0xf66, 0xf77, 0xf88, 0xf99, 0xfaa, 0xfbb, 0xfcc, 0xfdd, 0xfee, 0xfff,
	0x1011, 0x1022, 0x1033, 0x1045, 0x1056, 0x1068, 0x1079, 0x108b, 0x109c,
	0x10ae, 0x10c0, 0x10d1, 0x10e3, 0x10f5, 0x1107, 0x1119, 0x112b, 0x113c,
	0x114e, 0x1160, 0x1173, 0x1185, 0x1197, 0x11a9, 0x11bb, 0x11ce, 0x11e0,
	0x11f2, 0x1205, 0x1217, 0x1229, 0x123c, 0x124f, 0x1261, 0x1274, 0x1286,
	0x1299, 0x12ac, 0x12bf, 0x12d2, 0x12e4, 0x12f7, 0x130a, 0x131d, 0x1330,
	0x1343, 0x1357, 0x136a, 0x137d, 0x1390, 0x13a3, 0x13b7, 0x13ca, 0x13de,
	0x13f1, 0x1405, 0x1418, 0x142c, 0x143f, 0x1453, 0x1467, 0x147a, 0x148e,
	0x14a2, 0x14b6, 0x14ca, 0x14de, 0x14f2, 0x1506, 0x151a, 0x152e, 0x1542,
	0x1556, 0x156a, 0x157f, 0x1593, 0x15a7, 0x15bc, 0x15d0, 0x15e5, 0x15f9,
	0x160e, 0x1622, 0x1637, 0x164c, 0x1660, 0x1675, 0x168a, 0x169f, 0x16b4,
	0x16c9, 0x16de, 0x16f3, 0x1708, 0x171d, 0x1732, 0x1747, 0x175c, 0x1772,
	0x1787, 0x179c, 0x17b2, 0x17c7, 0x17dc, 0x17f2, 0x1808, 0x181d, 0x1833,
	0x1848, 0x185e, 0x1874, 0x188a, 0x18a0, 0x18b5, 0x18cb, 0x18e1, 0x18f7,
	0x190d, 0x1923, 0x193a, 0x1950, 0x1966, 0x197c, 0x1993, 0x19a9, 0x19bf,
	0x19d6, 0x19ec, 0x1a03, 0x1a19, 0x1a30, 0x1a47, 0x1a5d, 0x1a74, 0x1a8b,
	0x1aa2, 0x1ab8, 0x1acf, 0x1ae6, 0x1afd, 0x1b14, 0x1b2b, 0x1b42, 0x1b59,
	0x1b71, 0x1b88, 0x1b9f, 0x1bb6, 0x1bce, 0x1be5, 0x1bfd, 0x1c14, 0x1c2c,
	0x1c43, 0x1c5b, 0x1c72, 0x1c8a, 0x1ca2, 0x1cba, 0x1cd2, 0x1ce9, 0x1d01,
	0x1d19, 0x1d31, 0x1d49, 0x1d61, 0x1d79, 0x1d92, 0x1daa, 0x1dc2, 0x1dda,
	0x1df3, 0x1e0b, 0x1e23, 0x1e3c, 0x1e54, 0x1e6d, 0x1e86, 0x1e9e, 0x1eb7,
	0x1ed0, 0x1ee8, 0x1f01, 0x1f1a, 0x1f33, 0x1f4c, 0x1f65, 0x1f7e, 0x1f97,
	0x1fb0, 0x1fc9, 0x1fe2, 0x1ffb, 0x2015, 0x202e, 0x2047, 0x2061, 0x207a,
	0x2094, 0x20ad, 0x20c7, 0x20e0, 0x20fa, 0x2114, 0x212d, 0x2147, 0x2161,
	0x217b, 0x2195, 0x21af, 0x21c9, 0x21e3, 0x21fd, 0x2217, 0x2231, 0x224b,
	0x2266, 0x2280, 0x229a, 0x22b5, 0x22cf, 0x22ea, 0x2304, 0x231f, 0x2339,
	0x2354, 0x236f, 0x2389, 0x23a4, 0x23bf, 0x23da, 0x23f5, 0x2410, 0x242b,
	0x2446, 0x2461, 0x247c, 0x2497, 0x24b2, 0x24ce, 0x24e9, 0x2504, 0x2520,
	0x253b, 0x2556, 0x2572, 0x258e, 0x25a9, 0x25c5, 0x25e0, 0x25fc, 0x2618,
	0x2634, 0x2650, 0x266c, 0x2687, 0x26a3, 0x26c0, 0x26dc, 0x26f8, 0x2714,
	0x2730, 0x274c, 0x2769, 0x2785, 0x27a1, 0x27be, 0x27da, 0x27f7, 0x2813,
	0x2830, 0x284d, 0x2869, 0x2886, 0x28a3, 0x28c0, 0x28dc, 0x28f9, 0x2916,
	0x2933, 0x2950, 0x296d, 0x298b, 0x29a8, 0x29c5, 0x29e2, 0x2a00, 0x2a1d,
	0x2a3a, 0x2a58, 0x2a75, 0x2a93, 0x2ab0, 0x2ace, 0x2aec, 0x2b09, 0x2b27,
	0x2b45, 0x2b63, 0x2b81, 0x2b9e, 0x2bbc, 0x2bda, 0x2bf8, 0x2c17, 0x2c35,
	0x2c53, 0x2c71, 0x2c8f, 0x2cae, 0x2ccc, 0x2ceb, 0x2d09, 0x2d27, 0x2d46,
	0x2d65, 0x2d83, 0x2da2, 0x2dc1, 0x2ddf, 0x2dfe, 0x2e1d, 0x2e3c, 0x2e5b,
	0x2e7a, 0x2e99, 0x2eb8, 0x2ed7, 0x2ef6, 0x2f15, 0x2f35, 0x2f54, 0x2f73,
	0x2f93, 0x2fb2, 0x2fd2, 0x2ff1, 0x3011, 0x3030, 0x3050, 0x3070, 0x308f,
	0x30af, 0x30cf, 0x30ef, 0x310f, 0x312f, 0x314f, 0x316f, 0x318f, 0x31af,
	0x31cf, 0x31f0, 0x3210, 0x3230, 0x3251, 0x3271, 0x3291, 0x32b2, 0x32d2,
	0x32f3, 0x3314, 0x3334, 0x3355, 0x3376, 0x3397, 0x33b8, 0x33d8, 0x33f9,
	0x341a, 0x343b, 0x345d, 0x347e, 0x349f, 0x34c0, 0x34e1, 0x3503, 0x3524,
	0x3545, 0x3567, 0x3588, 0x35aa, 0x35cb, 0x35ed, 0x360f, 0x3631, 0x3652,
	0x3674, 0x3696, 0x36b8, 0x36da, 0x36fc, 0x371e, 0x3740, 0x3762, 0x3784,
	0x37a6, 0x37c9, 0x37eb, 0x380d, 0x3830, 0x3852, 0x3875, 0x3897, 0x38ba,
	0x38dc, 0x38ff, 0x3922, 0x3945, 0x3967, 0x398a, 0x39ad, 0x39d0, 0x39f3,
	0x3a16, 0x3a39, 0x3a5c, 0x3a7f, 0x3aa3, 0x3ac6, 0x3ae9, 0x3b0d, 0x3b30,
	0x3b53, 0x3b77, 0x3b9a, 0x3bbe, 0x3be2, 0x3c05, 0x3c29, 0x3c4d, 0x3c71,
	0x3c94, 0x3cb8, 0x3cdc, 0x3d00, 0x3d24, 0x3d48, 0x3d6c, 0x3d91, 0x3db5,
	0x3dd9, 0x3dfd, 0x3e22, 0x3e46, 0x3e6b, 0x3e8f, 0x3eb4, 0x3ed8, 0x3efd,
	0x3f21, 0x3f46, 0x3f6b, 0x3f90, 0x3fb5, 0x3fda, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0},
	{0x3, 0x0, 0xf78, 0x137a, 0x15ea, 0x177a, 0x18b7, 0x19ea, 0x1aaa,
	0x1b7a, 0x1c33, 0x1cb7, 0x1d4a, 0x1dea, 0x1e4c, 0x1eaa, 0x1f0e, 0x1f7a,
	0x1fed, 0x2033, 0x2074, 0x20b7, 0x20ff, 0x214a, 0x2198, 0x21ea, 0x221f,
	0x224c, 0x227a, 0x22aa, 0x22db, 0x230e, 0x2343, 0x237a, 0x23b3, 0x23ed,
	0x2414, 0x2433, 0x2453, 0x2474, 0x2495, 0x24b7, 0x24db, 0x24ff, 0x2524,
	0x254a, 0x2570, 0x2598, 0x25c0, 0x25ea, 0x260a, 0x261f, 0x2635, 0x264c,
	0x2662, 0x267a, 0x2691, 0x26aa, 0x26c2, 0x26db, 0x26f5, 0x270e, 0x2729,
	0x2743, 0x275f, 0x277a, 0x2796, 0x27b3, 0x27d0, 0x27ed, 0x2805, 0x2814,
	0x2824, 0x2833, 0x2843, 0x2853, 0x2863, 0x2874, 0x2884, 0x2895, 0x28a6,
	0x28b7, 0x28c9, 0x28db, 0x28ed, 0x28ff, 0x2911, 0x2924, 0x2937, 0x294a,
	0x295d, 0x2970, 0x2984, 0x2998, 0x29ac, 0x29c0, 0x29d5, 0x29ea, 0x29ff,
	0x2a0a, 0x2a14, 0x2a1f, 0x2a2a, 0x2a35, 0x2a40, 0x2a4c, 0x2a57, 0x2a62,
	0x2a6e, 0x2a7a, 0x2a85, 0x2a91, 0x2a9d, 0x2aaa, 0x2ab6, 0x2ac2, 0x2acf,
	0x2adb, 0x2ae8, 0x2af5, 0x2b01, 0x2b0e, 0x2b1c, 0x2b29, 0x2b36, 0x2b43,
	0x2b51, 0x2b5f, 0x2b6c, 0x2b7a, 0x2b88, 0x2b96, 0x2ba5, 0x2bb3, 0x2bc1,
	0x2bd0, 0x2bde, 0x2bed, 0x2bfc, 0x2c05, 0x2c0d, 0x2c14, 0x2c1c, 0x2c24,
	0x2c2b, 0x2c33, 0x2c3b, 0x2c43, 0x2c4b, 0x2c53, 0x2c5b, 0x2c63, 0x2c6b,
	0x2c74, 0x2c7c, 0x2c84, 0x2c8d, 0x2c95, 0x2c9e, 0x2ca6, 0x2caf, 0x2cb7,
	0x2cc0, 0x2cc9, 0x2cd2, 0x2cdb, 0x2ce4, 0x2ced, 0x2cf6, 0x2cff, 0x2d08,
	0x2d11, 0x2d1a, 0x2d24, 0x2d2d, 0x2d37, 0x2d40, 0x2d4a, 0x2d53, 0x2d5d,
	0x2d67, 0x2d70, 0x2d7a, 0x2d84, 0x2d8e, 0x2d98, 0x2da2, 0x2dac, 0x2db6,
	0x2dc0, 0x2dcb, 0x2dd5, 0x2ddf, 0x2dea, 0x2df4, 0x2dff, 0x2e04, 0x2e0a,
	0x2e0f, 0x2e14, 0x2e1a, 0x2e1f, 0x2e25, 0x2e2a, 0x2e30, 0x2e35, 0x2e3b,
	0x2e40, 0x2e46, 0x2e4c, 0x2e51, 0x2e57, 0x2e5d, 0x2e62, 0x2e68, 0x2e6e,
	0x2e74, 0x2e7a, 0x2e80, 0x2e85, 0x2e8b, 0x2e91, 0x2e97, 0x2e9d, 0x2ea3,
	0x2eaa, 0x2eb0, 0x2eb6, 0x2ebc, 0x2ec2, 0x2ec8, 0x2ecf, 0x2ed5, 0x2edb,
	0x2ee1, 0x2ee8, 0x2eee, 0x2ef5, 0x2efb, 0x2f01, 0x2f08, 0x2f0e, 0x2f15,
	0x2f1c, 0x2f22, 0x2f29, 0x2f2f, 0x2f36, 0x2f3d, 0x2f43, 0x2f4a, 0x2f51,
	0x2f58, 0x2f5f, 0x2f66, 0x2f6c, 0x2f73, 0x2f7a, 0x2f81, 0x2f88, 0x2f8f,
	0x2f96, 0x2f9d, 0x2fa5, 0x2fac, 0x2fb3, 0x2fba, 0x2fc1, 0x2fc8, 0x2fd0,
	0x2fd7, 0x2fde, 0x2fe6, 0x2fed, 0x2ff5, 0x2ffc, 0x3001, 0x3005, 0x3009,
	0x300d, 0x3011, 0x3014, 0x3018, 0x301c, 0x3020, 0x3024, 0x3028, 0x302b,
	0x302f, 0x3033, 0x3037, 0x303b, 0x303f, 0x3043, 0x3047, 0x304b, 0x304f,
	0x3053, 0x3057, 0x305b, 0x305f, 0x3063, 0x3067, 0x306b, 0x306f, 0x3074,
	0x3078, 0x307c, 0x3080, 0x3084, 0x3088, 0x308d, 0x3091, 0x3095, 0x3099,
	0x309e, 0x30a2, 0x30a6, 0x30aa, 0x30af, 0x30b3, 0x30b7, 0x30bc, 0x30c0,
	0x30c5, 0x30c9, 0x30cd, 0x30d2, 0x30d6, 0x30db, 0x30df, 0x30e4, 0x30e8,
	0x30ed, 0x30f1, 0x30f6, 0x30fa, 0x30ff, 0x3103, 0x3108, 0x310d, 0x3111,
	0x3116, 0x311a, 0x311f, 0x3124, 0x3128, 0x312d, 0x3132, 0x3137, 0x313b,
	0x3140, 0x3145, 0x314a, 0x314e, 0x3153, 0x3158, 0x315d, 0x3162, 0x3167,
	0x316b, 0x3170, 0x3175, 0x317a, 0x317f, 0x3184, 0x3189, 0x318e, 0x3193,
	0x3198, 0x319d, 0x31a2, 0x31a7, 0x31ac, 0x31b1, 0x31b6, 0x31bb, 0x31c0,
	0x31c5, 0x31cb, 0x31d0, 0x31d5, 0x31da, 0x31df, 0x31e4, 0x31ea, 0x31ef,
	0x31f4, 0x31f9, 0x31ff, 0x3202, 0x3204, 0x3207, 0x320a, 0x320c, 0x320f,
	0x3212, 0x3214, 0x3217, 0x321a, 0x321c, 0x321f, 0x3222, 0x3225, 0x3227,
	0x322a, 0x322d, 0x3230, 0x3232, 0x3235, 0x3238, 0x323b, 0x323e, 0x3240,
	0x3243, 0x3246, 0x3249, 0x324c, 0x324e, 0x3251, 0x3254, 0x3257, 0x325a,
	0x325d, 0x3260, 0x3262, 0x3265, 0x3268, 0x326b, 0x326e, 0x3271, 0x3274,
	0x3277, 0x327a, 0x327d, 0x3280, 0x3282, 0x3285, 0x3288, 0x328b, 0x328e,
	0x3291, 0x3294, 0x3297, 0x329a, 0x329d, 0x32a0, 0x32a3, 0x32a6, 0x32aa,
	0x32ad, 0x32b0, 0x32b3, 0x32b6, 0x32b9, 0x32bc, 0x32bf, 0x32c2, 0x32c6,
	0x32c9, 0x32cc, 0x32cf, 0x32d3, 0x32d6, 0x32d9, 0x32dd, 0x32e0, 0x32e4,
	0x32e7, 0x32ea, 0x32ee, 0x32f1, 0x32f5, 0x32f8, 0x32fc, 0x32ff, 0x3303,
	0x3307, 0x330a, 0x330e, 0x3312, 0x3315, 0x3319, 0x331d, 0x3321, 0x3324,
	0x3328, 0x332c, 0x3330, 0x3334, 0x3338, 0x333c, 0x3340, 0x3344, 0x3348,
	0x334c, 0x3350, 0x3354, 0x3358, 0x335c, 0x3360, 0x3365, 0x3369, 0x336d,
	0x3371, 0x3376, 0x337a, 0x337e, 0x3383, 0x3387, 0x338c, 0x3390, 0x3394,
	0x3399, 0x339e, 0x33a2, 0x33a7, 0x33ab, 0x33b0, 0x33b5, 0x33b9, 0x33be,
	0x33c3, 0x33c8, 0x33cd, 0x33d2, 0x33d6, 0x33db, 0x33e0, 0x33e5, 0x33ea,
	0x33ef, 0x33f5, 0x33fa, 0x33ff, 0x3402, 0x3404, 0x3407, 0x340a, 0x340c,
	0x340f, 0x3412, 0x3414, 0x3417, 0x341a, 0x341d, 0x341f, 0x3422, 0x3425,
	0x3428, 0x342b, 0x342e, 0x3430, 0x3433, 0x3436, 0x3439, 0x343c, 0x343f,
	0x3442, 0x3445, 0x3448, 0x344b, 0x344e, 0x3451, 0x3455, 0x3458, 0x345b,
	0x345e, 0x3461, 0x3464, 0x3468, 0x346b, 0x346e, 0x3471, 0x3475, 0x3478,
	0x347b, 0x347f, 0x3482, 0x3486, 0x3489, 0x348d, 0x3490, 0x3493, 0x3497,
	0x349b, 0x349e, 0x34a2, 0x34a5, 0x34a9, 0x34ad, 0x34b0, 0x34b4, 0x34b8,
	0x34bc, 0x34bf, 0x34c3, 0x34c7, 0x34cb, 0x34cf, 0x34d3, 0x34d6, 0x34da,
	0x34de, 0x34e2, 0x34e6, 0x34ea, 0x34ee, 0x34f3, 0x34f7, 0x34fb, 0x34ff,
	0x3503, 0x3507, 0x350c, 0x3510, 0x3514, 0x3519, 0x351d, 0x3521, 0x3526,
	0x352a, 0x352f, 0x3533, 0x3538, 0x353c, 0x3541, 0x3545, 0x354a, 0x354f,
	0x3553, 0x3558, 0x355d, 0x3562, 0x3566, 0x356b, 0x3570, 0x3575, 0x357a,
	0x357f, 0x3584, 0x3589, 0x358e, 0x3593, 0x3598, 0x359d, 0x35a3, 0x35a8,
	0x35ad, 0x35b2, 0x35b8, 0x35bd, 0x35c2, 0x35c8, 0x35cd, 0x35d3, 0x35d8,
	0x35de, 0x35e4, 0x35e9, 0x35ef, 0x35f4, 0x35fa, 0x3600, 0x3603, 0x3606,
	0x3609, 0x360b, 0x360e, 0x3611, 0x3614, 0x3617, 0x361b, 0x361e, 0x3621,
	0x3624, 0x3627, 0x362a, 0x362d, 0x3630, 0x3634, 0x3637, 0x363a, 0x363d,
	0x3641, 0x3644, 0x3647, 0x364b, 0x364e, 0x3651, 0x3655, 0x3658, 0x365c,
	0x365f, 0x3663, 0x3666, 0x366a, 0x366d, 0x3671, 0x3675, 0x3678, 0x367c,
	0x3680, 0x3683, 0x3687, 0x368b, 0x368e, 0x3692, 0x3696, 0x369a, 0x369e,
	0x36a2, 0x36a6, 0x36aa, 0x36ae, 0x36b2, 0x36b6, 0x36ba, 0x36be, 0x36c2,
	0x36c6, 0x36ca, 0x36ce, 0x36d2, 0x36d7, 0x36db, 0x36df, 0x36e3, 0x36e8,
	0x36ec, 0x36f0, 0x36f5, 0x36f9, 0x36fe, 0x3702, 0x3707, 0x370b, 0x3710,
	0x3715, 0x3719, 0x371e, 0x3723, 0x3727, 0x372c, 0x3731, 0x3736, 0x373a,
	0x373f, 0x3744, 0x3749, 0x374e, 0x3753, 0x3758, 0x375d, 0x3762, 0x3767,
	0x376d, 0x3772, 0x3777, 0x377c, 0x3782, 0x3787, 0x378c, 0x3792, 0x3797,
	0x379c, 0x37a2, 0x37a7, 0x37ad, 0x37b3, 0x37b8, 0x37be, 0x37c4, 0x37c9,
	0x37cf, 0x37d5, 0x37db, 0x37e1, 0x37e7, 0x37ec, 0x37f2, 0x37f8, 0x37ff,
	0x3802, 0x3805, 0x3808, 0x380b, 0x380e, 0x3812, 0x3815, 0x3818, 0x381b,
	0x381e, 0x3822, 0x3825, 0x3828, 0x382c, 0x382f, 0x3832, 0x3836, 0x3839,
	0x383c, 0x3840, 0x3843, 0x3847, 0x384a, 0x384e, 0x3851, 0x3855, 0x3858,
	0x385c, 0x3860, 0x3863, 0x3867, 0x386b, 0x386e, 0x3872, 0x3876, 0x387a,
	0x387e, 0x3881, 0x3885, 0x3889, 0x388d, 0x3891, 0x3895, 0x3899, 0x389d,
	0x38a1, 0x38a5, 0x38a9, 0x38ad, 0x38b1, 0x38b6, 0x38ba, 0x38be, 0x38c2,
	0x38c7, 0x38cb, 0x38cf, 0x38d4, 0x38d8, 0x38dc, 0x38e1, 0x38e5, 0x38ea,
	0x38ee, 0x38f3, 0x38f7, 0x38fc, 0x3901, 0x3905, 0x390a, 0x390f, 0x3913,
	0x3918, 0x391d, 0x3922, 0x3927, 0x392c, 0x3931, 0x3936, 0x393b, 0x3940,
	0x3945, 0x394a, 0x394f, 0x3954, 0x3959, 0x395e, 0x3964, 0x3969, 0x396e,
	0x3974, 0x3979, 0x397e, 0x3984, 0x3989, 0x398f, 0x3994, 0x399a, 0x39a0,
	0x39a5, 0x39ab, 0x39b1, 0x39b6, 0x39bc, 0x39c2, 0x39c8, 0x39ce, 0x39d4,
	0x39da, 0x39e0, 0x39e6, 0x39ec, 0x39f2, 0x39f8, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x3},
};

static const u32 dcss_cscbs[5][29] = {
	{0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0},
	{0x3, 0x503c, 0x2a1c, 0x58a, 0x8d7, 0x7598, 0x174, 0x219, 0xb42,
	0x7288, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff, 0x1, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0xffc0000, 0xffc0000, 0xffc0000},
	{0x3, 0x53c5, 0x26a5, 0x57a, 0x93a, 0x7539, 0x170, 0x231, 0xc84,
	0x712f, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff, 0x1, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0xffc0000, 0xffc0000, 0xffc0000},
	{0x3, 0x42d2, 0xfffffd30, 0x0, 0x0, 0x4000, 0x0, 0x0, 0xc2, 0x3f3f,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff, 0xe, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff},
	{0x3, 0x3d4d, 0x2b4, 0x0, 0x0, 0x4000, 0x0, 0x0, 0xffffff3e, 0x40c4,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff, 0xe, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x3fff, 0x3fff, 0x3fff},
};

static const u16 dcss_oluts[11][1024] = {
	{0x155, 0xe, 0x13ef, 0x1, 0x4f, 0x536, 0x3fff, 0x0, 0x5, 0x23, 0xa7,
	0x2a7, 0xa2f, 0x2758, 0x3fff, 0x0, 0x0, 0x2, 0x9, 0x17, 0x35, 0x73,
	0xef, 0x1e2, 0x3b8, 0x749, 0xe3d, 0x1bf7, 0x378e, 0x3fff, 0x3fff, 0x0,
	0x0, 0x0, 0x1, 0x2, 0x3, 0x6, 0xb, 0x12, 0x1c, 0x2b, 0x41, 0x60, 0x8b,
	0xc8, 0x11e, 0x195, 0x23c, 0x324, 0x467, 0x629, 0x89d, 0xc0a, 0x10d8,
	0x179b, 0x2128, 0x2ebb, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x6, 0x7, 0xa,
	0xd, 0x10, 0x14, 0x19, 0x20, 0x27, 0x30, 0x3b, 0x47, 0x57, 0x69, 0x7f,
	0x98, 0xb7, 0xdb, 0x106, 0x138, 0x174, 0x1ba, 0x20d, 0x26f, 0x2e3,
	0x36b, 0x40c, 0x4ca, 0x5aa, 0x6b3, 0x7ec, 0x95d, 0xb12, 0xd18, 0xf7c,
	0x1253, 0x15b1, 0x19b1, 0x1e73, 0x241e, 0x2ae0, 0x32f2, 0x3c9a, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1,
	0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9,
	0xa, 0xc, 0xd, 0xf, 0x11, 0x13, 0x15, 0x18, 0x1b, 0x1e, 0x21, 0x25,
	0x29, 0x2e, 0x32, 0x38, 0x3e, 0x44, 0x4b, 0x53, 0x5b, 0x64, 0x6e, 0x79,
	0x85, 0x92, 0xa0, 0xaf, 0xbf, 0xd1, 0xe5, 0xfa, 0x111, 0x12b, 0x146,
	0x164, 0x184, 0x1a7, 0x1ce, 0x1f7, 0x224, 0x255, 0x28a, 0x2c4, 0x303,
	0x347, 0x391, 0x3e1, 0x439, 0x498, 0x4ff, 0x56f, 0x5e8, 0x66d, 0x6fc,
	0x799, 0x842, 0x8fb, 0x9c4, 0xa9e, 0xb8c, 0xc8e, 0xda7, 0xed9, 0x1027,
	0x1191, 0x131d, 0x14cb, 0x16a0, 0x18a0, 0x1ace, 0x1d2e, 0x1fc6, 0x229b,
	0x25b2, 0x2912, 0x2cc2, 0x30ca, 0x3533, 0x3a06, 0x3f4d, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4,
	0x4, 0x4, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0x9, 0xa,
	0xb, 0xb, 0xc, 0xd, 0xe, 0xf, 0x10, 0x10, 0x11, 0x13, 0x14, 0x15, 0x16,
	0x17, 0x19, 0x1a, 0x1c, 0x1d, 0x1f, 0x20, 0x22, 0x24, 0x26, 0x28, 0x2a,
	0x2c, 0x2f, 0x31, 0x34, 0x36, 0x39, 0x3c, 0x3f, 0x42, 0x46, 0x49, 0x4d,
	0x51, 0x55, 0x59, 0x5d, 0x62, 0x67, 0x6c, 0x71, 0x76, 0x7c, 0x82, 0x88,
	0x8e, 0x95, 0x9c, 0xa3, 0xab, 0xb3, 0xbb, 0xc4, 0xcd, 0xd6, 0xe0, 0xea,
	0xf5, 0x100, 0x10b, 0x118, 0x124, 0x131, 0x13f, 0x14d, 0x15c, 0x16c,
	0x17c, 0x18d, 0x19e, 0x1b1, 0x1c4, 0x1d8, 0x1ec, 0x202, 0x218, 0x230,
	0x248, 0x262, 0x27d, 0x298, 0x2b5, 0x2d3, 0x2f3, 0x313, 0x335, 0x359,
	0x37e, 0x3a4, 0x3cd, 0x3f7, 0x422, 0x450, 0x47f, 0x4b1, 0x4e4, 0x51a,
	0x552, 0x58c, 0x5c9, 0x608, 0x64b, 0x68f, 0x6d7, 0x722, 0x770, 0x7c2,
	0x817, 0x86f, 0x8cb, 0x92c, 0x990, 0x9f9, 0xa66, 0xad8, 0xb4e, 0xbca,
	0xc4b, 0xcd2, 0xd5f, 0xdf1, 0xe8a, 0xf2a, 0xfd1, 0x107e, 0x1134,
	0x11f1, 0x12b7, 0x1385, 0x145c, 0x153d, 0x1627, 0x171c, 0x181c, 0x1927,
	0x1a3e, 0x1b61, 0x1c91, 0x1dcf, 0x1f1b, 0x2075, 0x21df, 0x235a, 0x24e5,
	0x2683, 0x2833, 0x29f6, 0x2bce, 0x2dbc, 0x2fc0, 0x31db, 0x340f, 0x365d,
	0x38c6, 0x3b4c, 0x3def, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1,
	0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2,
	0x2, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x4, 0x4,
	0x4, 0x4, 0x5, 0x5, 0x5, 0x5, 0x5, 0x5, 0x6, 0x6, 0x6, 0x6, 0x7, 0x7,
	0x7, 0x7, 0x8, 0x8, 0x8, 0x8, 0x9, 0x9, 0x9, 0xa, 0xa, 0xa, 0xb, 0xb,
	0xb, 0xc, 0xc, 0xc, 0xd, 0xd, 0xe, 0xe, 0xe, 0xf, 0xf, 0x10, 0x10,
	0x11, 0x11, 0x12, 0x12, 0x13, 0x13, 0x14, 0x15, 0x15, 0x16, 0x16, 0x17,
	0x18, 0x18, 0x19, 0x1a, 0x1a, 0x1b, 0x1c, 0x1d, 0x1d, 0x1e, 0x1f, 0x20,
	0x21, 0x22, 0x23, 0x24, 0x24, 0x25, 0x26, 0x27, 0x29, 0x2a, 0x2b, 0x2c,
	0x2d, 0x2e, 0x2f, 0x31, 0x32, 0x33, 0x34, 0x36, 0x37, 0x39, 0x3a, 0x3b,
	0x3d, 0x3e, 0x40, 0x42, 0x43, 0x45, 0x47, 0x48, 0x4a, 0x4c, 0x4e, 0x50,
	0x52, 0x54, 0x56, 0x58, 0x5a, 0x5c, 0x5e, 0x61, 0x63, 0x65, 0x68, 0x6a,
	0x6d, 0x6f, 0x72, 0x75, 0x77, 0x7a, 0x7d, 0x80, 0x83, 0x86, 0x89, 0x8d,
	0x90, 0x93, 0x97, 0x9a, 0x9e, 0xa1, 0xa5, 0xa9, 0xad, 0xb1, 0xb5, 0xb9,
	0xbd, 0xc1, 0xc6, 0xca, 0xcf, 0xd4, 0xd8, 0xdd, 0xe2, 0xe7, 0xed, 0xf2,
	0xf7, 0xfd, 0x103, 0x108, 0x10e, 0x114, 0x11b, 0x121, 0x127, 0x12e,
	0x135, 0x13b, 0x142, 0x14a, 0x151, 0x158, 0x160, 0x168, 0x170, 0x178,
	0x180, 0x188, 0x191, 0x19a, 0x1a3, 0x1ac, 0x1b5, 0x1bf, 0x1c9, 0x1d3,
	0x1dd, 0x1e7, 0x1f2, 0x1fc, 0x207, 0x213, 0x21e, 0x22a, 0x236, 0x242,
	0x24f, 0x25b, 0x268, 0x276, 0x283, 0x291, 0x29f, 0x2ae, 0x2bd, 0x2cc,
	0x2db, 0x2eb, 0x2fb, 0x30b, 0x31c, 0x32d, 0x33e, 0x350, 0x362, 0x374,
	0x387, 0x39b, 0x3ae, 0x3c2, 0x3d7, 0x3ec, 0x401, 0x417, 0x42d, 0x444,
	0x45b, 0x473, 0x48b, 0x4a4, 0x4bd, 0x4d7, 0x4f1, 0x50c, 0x528, 0x544,
	0x560, 0x57d, 0x59b, 0x5ba, 0x5d9, 0x5f8, 0x619, 0x63a, 0x65c, 0x67e,
	0x6a1, 0x6c5, 0x6ea, 0x70f, 0x735, 0x75c, 0x784, 0x7ad, 0x7d7, 0x801,
	0x82c, 0x859, 0x886, 0x8b4, 0x8e3, 0x913, 0x944, 0x977, 0x9aa, 0x9de,
	0xa14, 0xa4a, 0xa82, 0xabb, 0xaf5, 0xb30, 0xb6d, 0xbab, 0xbea, 0xc2b,
	0xc6d, 0xcb0, 0xcf5, 0xd3b, 0xd83, 0xdcc, 0xe17, 0xe63, 0xeb2, 0xf01,
	0xf53, 0xfa6, 0xffb, 0x1052, 0x10ab, 0x1106, 0x1162, 0x11c1, 0x1222,
	0x1284, 0x12e9, 0x1350, 0x13ba, 0x1425, 0x1493, 0x1504, 0x1576, 0x15ec,
	0x1664, 0x16de, 0x175b, 0x17db, 0x185e, 0x18e3, 0x196b, 0x19f7, 0x1a85,
	0x1b17, 0x1bac, 0x1c44, 0x1cdf, 0x1d7e, 0x1e20, 0x1ec6, 0x1f70, 0x201d,
	0x20ce, 0x2183, 0x223d, 0x22fa, 0x23bb, 0x2481, 0x254b, 0x261a, 0x26ed,
	0x27c5, 0x28a2, 0x2983, 0x2a6a, 0x2b56, 0x2c47, 0x2d3e, 0x2e3a, 0x2f3c,
	0x3044, 0x3152, 0x3266, 0x3380, 0x34a0, 0x35c7, 0x36f5, 0x3829, 0x3965,
	0x3aa8, 0x3bf2, 0x3d44, 0x3e9d, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x6},
	{0x2c59, 0x2416, 0x3322, 0x1dd0, 0x287e, 0x2ff0, 0x3679, 0x188b,
	0x2131, 0x2661, 0x2a78, 0x2e2b, 0x3186, 0x34c8, 0x3836, 0x141d, 0x1b81,
	0x1fa3, 0x22a3, 0x2531, 0x277a, 0x2988, 0x2b6b, 0x2d33, 0x2eed, 0x30a3,
	0x325a, 0x3416, 0x35b5, 0x374e, 0x38f8, 0xff8, 0x1698, 0x1a32, 0x1ca3,
	0x1eab, 0x206e, 0x2210, 0x2355, 0x2497, 0x25e9, 0x26e2, 0x2816, 0x28f9,
	0x2a17, 0x2ae8, 0x2c01, 0x2cbe, 0x2dbb, 0x2e85, 0x2f65, 0x3047, 0x310d,
	0x3209, 0x32b7, 0x339e, 0x3469, 0x3536, 0x3624, 0x36db, 0x37d2, 0x388f,
	0x3971, 0xbe0, 0x124a, 0x1572, 0x17b5, 0x1962, 0x1acc, 0x1c29, 0x1d30,
	0x1e43, 0x1f20, 0x201b, 0x20ca, 0x21a2, 0x2256, 0x22f8, 0x23bc, 0x2454,
	0x24e1, 0x2589, 0x2629, 0x269f, 0x272b, 0x27d0, 0x2848, 0x28b9, 0x293d,
	0x29d8, 0x2a45, 0x2aae, 0x2b27, 0x2bb4, 0x2c2b, 0x2c89, 0x2cf6, 0x2d74,
	0x2e03, 0x2e57, 0x2eb8, 0x2f27, 0x2fa8, 0x301e, 0x3073, 0x30d6, 0x3147,
	0x31ca, 0x3230, 0x3287, 0x32eb, 0x335e, 0x33e3, 0x343e, 0x3497, 0x34fd,
	0x3573, 0x35fc, 0x364d, 0x36a8, 0x3712, 0x378d, 0x380e, 0x3861, 0x38c1,
	0x3932, 0x39b5, 0x700, 0xe30, 0x1120, 0x132c, 0x14bb, 0x1621, 0x171f,
	0x182e, 0x18f2, 0x19de, 0x1a7c, 0x1b23, 0x1be6, 0x1c64, 0x1ce7, 0x1d7d,
	0x1e14, 0x1e75, 0x1ee3, 0x1f60, 0x1feb, 0x2043, 0x209b, 0x20fc, 0x2168,
	0x21e0, 0x2232, 0x227b, 0x22cc, 0x2325, 0x2387, 0x23f3, 0x2434, 0x2475,
	0x24bb, 0x2508, 0x255d, 0x25b8, 0x260e, 0x2644, 0x2680, 0x26c0, 0x2706,
	0x2752, 0x27a4, 0x27fd, 0x282f, 0x2863, 0x289b, 0x28d8, 0x291a, 0x2962,
	0x29af, 0x2a01, 0x2a2e, 0x2a5e, 0x2a92, 0x2aca, 0x2b07, 0x2b48, 0x2b8f,
	0x2bda, 0x2c16, 0x2c41, 0x2c70, 0x2ca3, 0x2cda, 0x2d14, 0x2d53, 0x2d97,
	0x2de0, 0x2e17, 0x2e41, 0x2e6e, 0x2e9e, 0x2ed2, 0x2f0a, 0x2f46, 0x2f86,
	0x2fcb, 0x300a, 0x3032, 0x305d, 0x308b, 0x30bc, 0x30f1, 0x3129, 0x3166,
	0x31a8, 0x31ee, 0x321c, 0x3245, 0x3270, 0x329f, 0x32d1, 0x3306, 0x3340,
	0x337e, 0x33c0, 0x3404, 0x342a, 0x3453, 0x347f, 0x34af, 0x34e2, 0x3519,
	0x3554, 0x3593, 0x35d8, 0x3610, 0x3638, 0x3662, 0x3690, 0x36c1, 0x36f6,
	0x372f, 0x376d, 0x37af, 0x37f7, 0x3821, 0x384b, 0x3878, 0x38a8, 0x38dc,
	0x3914, 0x3951, 0x3992, 0x39d9, 0x200, 0xa20, 0xd00, 0xf00, 0x1084,
	0x11d0, 0x12b6, 0x13ae, 0x1469, 0x1513, 0x15d7, 0x165b, 0x16da, 0x1768,
	0x1803, 0x185b, 0x18bd, 0x1929, 0x199f, 0x1a10, 0x1a56, 0x1aa3, 0x1af6,
	0x1b51, 0x1bb2, 0x1c0e, 0x1c46, 0x1c83, 0x1cc5, 0x1d0b, 0x1d56, 0x1da6,
	0x1dfc, 0x1e2b, 0x1e5c, 0x1e90, 0x1ec7, 0x1f01, 0x1f3f, 0x1f81, 0x1fc7,
	0x2008, 0x202f, 0x2058, 0x2084, 0x20b2, 0x20e3, 0x2116, 0x214c, 0x2185,
	0x21c1, 0x2200, 0x2221, 0x2244, 0x2268, 0x228f, 0x22b7, 0x22e2, 0x230e,
	0x233d, 0x236e, 0x23a1, 0x23d7, 0x2407, 0x2425, 0x2444, 0x2464, 0x2486,
	0x24a9, 0x24ce, 0x24f4, 0x251d, 0x2547, 0x2573, 0x25a1, 0x25d1, 0x2601,
	0x261b, 0x2636, 0x2653, 0x2670, 0x268f, 0x26af, 0x26d1, 0x26f4, 0x2718,
	0x273e, 0x2766, 0x278f, 0x27b9, 0x27e6, 0x280a, 0x2822, 0x283b, 0x2855,
	0x2870, 0x288d, 0x28aa, 0x28c9, 0x28e8, 0x2909, 0x292c, 0x294f, 0x2975,
	0x299b, 0x29c3, 0x29ed, 0x2a0c, 0x2a22, 0x2a39, 0x2a52, 0x2a6b, 0x2a85,
	0x2aa0, 0x2abc, 0x2ad9, 0x2af7, 0x2b17, 0x2b38, 0x2b59, 0x2b7d, 0x2ba1,
	0x2bc7, 0x2bee, 0x2c0b, 0x2c20, 0x2c36, 0x2c4d, 0x2c64, 0x2c7d, 0x2c96,
	0x2cb0, 0x2ccc, 0x2ce8, 0x2d05, 0x2d24, 0x2d43, 0x2d64, 0x2d85, 0x2da9,
	0x2dcd, 0x2df3, 0x2e0d, 0x2e21, 0x2e36, 0x2e4c, 0x2e62, 0x2e79, 0x2e92,
	0x2eab, 0x2ec5, 0x2ee0, 0x2efb, 0x2f18, 0x2f36, 0x2f55, 0x2f76, 0x2f97,
	0x2fb9, 0x2fdd, 0x3001, 0x3014, 0x3028, 0x303d, 0x3052, 0x3068, 0x307f,
	0x3097, 0x30af, 0x30c9, 0x30e3, 0x30ff, 0x311b, 0x3138, 0x3157, 0x3176,
	0x3197, 0x31b9, 0x31dc, 0x3200, 0x3213, 0x3226, 0x323a, 0x324f, 0x3265,
	0x327b, 0x3293, 0x32ab, 0x32c4, 0x32de, 0x32f8, 0x3314, 0x3331, 0x334f,
	0x336e, 0x338e, 0x33af, 0x33d2, 0x33f5, 0x340d, 0x3420, 0x3434, 0x3448,
	0x345e, 0x3474, 0x348b, 0x34a3, 0x34bb, 0x34d5, 0x34ef, 0x350b, 0x3527,
	0x3545, 0x3563, 0x3583, 0x35a4, 0x35c6, 0x35ea, 0x3607, 0x361a, 0x362e,
	0x3642, 0x3657, 0x366d, 0x3684, 0x369c, 0x36b5, 0x36ce, 0x36e9, 0x3704,
	0x3721, 0x373e, 0x375d, 0x377d, 0x379e, 0x37c1, 0x37e4, 0x3804, 0x3818,
	0x382c, 0x3840, 0x3856, 0x386c, 0x3883, 0x389b, 0x38b5, 0x38cf, 0x38ea,
	0x3906, 0x3923, 0x3941, 0x3961, 0x3981, 0x39a3, 0x39c7, 0x39ec, 0x0,
	0x500, 0x8c0, 0xae0, 0xc70, 0xdb0, 0xe98, 0xf78, 0x103c, 0x10d0,
	0x1178, 0x1218, 0x127e, 0x12f0, 0x136c, 0x13f2, 0x1442, 0x1491, 0x14e6,
	0x1542, 0x15a4, 0x1606, 0x163e, 0x1679, 0x16b9, 0x16fc, 0x1743, 0x178e,
	0x17dd, 0x1818, 0x1844, 0x1873, 0x18a4, 0x18d7, 0x190d, 0x1945, 0x1980,
	0x19be, 0x19ff, 0x1a21, 0x1a44, 0x1a69, 0x1a8f, 0x1ab7, 0x1ae1, 0x1b0c,
	0x1b39, 0x1b68, 0x1b99, 0x1bcc, 0x1c00, 0x1c1b, 0x1c38, 0x1c55, 0x1c74,
	0x1c93, 0x1cb4, 0x1cd6, 0x1cf9, 0x1d1d, 0x1d42, 0x1d69, 0x1d91, 0x1dbb,
	0x1de6, 0x1e09, 0x1e20, 0x1e37, 0x1e4f, 0x1e69, 0x1e82, 0x1e9d, 0x1eb9,
	0x1ed5, 0x1ef2, 0x1f10, 0x1f2f, 0x1f4f, 0x1f70, 0x1f92, 0x1fb5, 0x1fd9,
	0x1ffe, 0x2012, 0x2025, 0x2039, 0x204e, 0x2063, 0x2079, 0x208f, 0x20a6,
	0x20be, 0x20d6, 0x20ef, 0x2109, 0x2123, 0x213e, 0x215a, 0x2176, 0x2194,
	0x21b2, 0x21d0, 0x21f0, 0x2208, 0x2218, 0x2229, 0x223b, 0x224d, 0x225f,
	0x2272, 0x2285, 0x2299, 0x22ad, 0x22c2, 0x22d7, 0x22ed, 0x2303, 0x231a,
	0x2331, 0x2349, 0x2361, 0x237a, 0x2394, 0x23ae, 0x23c9, 0x23e5, 0x2400,
	0x240f, 0x241d, 0x242c, 0x243c, 0x244c, 0x245c, 0x246c, 0x247d, 0x248e,
	0x24a0, 0x24b2, 0x24c4, 0x24d7, 0x24eb, 0x24fe, 0x2512, 0x2527, 0x253c,
	0x2552, 0x2568, 0x257e, 0x2595, 0x25ac, 0x25c4, 0x25dd, 0x25f6, 0x2607,
	0x2614, 0x2622, 0x262f, 0x263d, 0x264c, 0x265a, 0x2669, 0x2678, 0x2687,
	0x2697, 0x26a7, 0x26b8, 0x26c8, 0x26d9, 0x26eb, 0x26fd, 0x270f, 0x2722,
	0x2734, 0x2748, 0x275c, 0x2770, 0x2784, 0x2799, 0x27af, 0x27c4, 0x27db,
	0x27f1, 0x2804, 0x2810, 0x281c, 0x2828, 0x2835, 0x2842, 0x284f, 0x285c,
	0x286a, 0x2877, 0x2886, 0x2894, 0x28a3, 0x28b2, 0x28c1, 0x28d0, 0x28e0,
	0x28f1, 0x2901, 0x2912, 0x2923, 0x2935, 0x2946, 0x2959, 0x296b, 0x297e,
	0x2991, 0x29a5, 0x29b9, 0x29cd, 0x29e2, 0x29f7, 0x2a06, 0x2a11, 0x2a1c,
	0x2a28, 0x2a33, 0x2a3f, 0x2a4b, 0x2a58, 0x2a64, 0x2a71, 0x2a7e, 0x2a8b,
	0x2a99, 0x2aa7, 0x2ab5, 0x2ac3, 0x2ad2, 0x2ae1, 0x2af0, 0x2aff, 0x2b0f,
	0x2b1f, 0x2b2f, 0x2b40, 0x2b51, 0x2b62, 0x2b74, 0x2b86, 0x2b98, 0x2baa,
	0x2bbd, 0x2bd0, 0x2be4, 0x2bf8, 0x2c06, 0x2c10, 0x2c1b, 0x2c26, 0x2c31,
	0x2c3c, 0x2c47, 0x2c53, 0x2c5e, 0x2c6a, 0x2c77, 0x2c83, 0x2c90, 0x2c9d,
	0x2caa, 0x2cb7, 0x2cc5, 0x2cd3, 0x2ce1, 0x2cef, 0x2cfe, 0x2d0d, 0x2d1c,
	0x2d2b, 0x2d3b, 0x2d4b, 0x2d5b, 0x2d6c, 0x2d7d, 0x2d8e, 0x2da0, 0x2db2,
	0x2dc4, 0x2dd6, 0x2de9, 0x2dfc, 0x2e08, 0x2e12, 0x2e1c, 0x2e26, 0x2e30,
	0x2e3b, 0x2e46, 0x2e51, 0x2e5c, 0x2e68, 0x2e73, 0x2e7f, 0x2e8b, 0x2e98,
	0x2ea4, 0x2eb1, 0x2ebe, 0x2ecb, 0x2ed9, 0x2ee6, 0x2ef4, 0x2f03, 0x2f11,
	0x2f20, 0x2f2f, 0x2f3e, 0x2f4e, 0x2f5d, 0x2f6d, 0x2f7e, 0x2f8e, 0x2f9f,
	0x2fb1, 0x2fc2, 0x2fd4, 0x2fe6, 0x2ff9, 0x3006, 0x300f, 0x3019, 0x3023,
	0x302d, 0x3037, 0x3042, 0x304d, 0x3057, 0x3062, 0x306e, 0x3079, 0x3085,
	0x3091, 0x309d, 0x30a9, 0x30b6, 0x30c2, 0x30cf, 0x30dd, 0x30ea, 0x30f8,
	0x3106, 0x3114, 0x3122, 0x3131, 0x3140, 0x314f, 0x315e, 0x316e, 0x317e,
	0x318f, 0x319f, 0x31b0, 0x31c1, 0x31d3, 0x31e5, 0x31f7, 0x3204, 0x320e,
	0x3217, 0x3221, 0x322b, 0x3235, 0x323f, 0x324a, 0x3255, 0x325f, 0x326a,
	0x3276, 0x3281, 0x328d, 0x3299, 0x32a5, 0x32b1, 0x32bd, 0x32ca, 0x32d7,
	0x32e4, 0x32f2, 0x32ff, 0x330d, 0x331b, 0x332a, 0x3338, 0x3347, 0x3357,
	0x3366, 0x3376, 0x3386, 0x3396, 0x33a7, 0x33b8, 0x33c9, 0x33da, 0x33ec,
	0x33fe, 0x3408, 0x3412, 0x341b, 0x3425, 0x342f, 0x3439, 0x3443, 0x344e,
	0x3458, 0x3463, 0x346e, 0x347a, 0x3485, 0x3491, 0x349d, 0x34a9, 0x34b5,
	0x34c2, 0x34ce, 0x34db, 0x34e9, 0x34f6, 0x3504, 0x3512, 0x3520, 0x352f,
	0x353d, 0x354c, 0x355c, 0x356b, 0x357b, 0x358b, 0x359c, 0x35ad, 0x35be,
	0x35cf, 0x35e1, 0x35f3, 0x3602, 0x360c, 0x3615, 0x361f, 0x3629, 0x3633,
	0x363d, 0x3647, 0x3652, 0x365d, 0x3668, 0x3673, 0x367f, 0x368a, 0x3696,
	0x36a2, 0x36ae, 0x36bb, 0x36c8, 0x36d5, 0x36e2, 0x36f0, 0x36fd, 0x370b,
	0x371a, 0x3728, 0x3737, 0x3746, 0x3755, 0x3765, 0x3775, 0x3785, 0x3796,
	0x37a7, 0x37b8, 0x37c9, 0x37db, 0x37ed, 0x3800, 0x3809, 0x3813, 0x381d,
	0x3826, 0x3831, 0x383b, 0x3846, 0x3850, 0x385b, 0x3866, 0x3872, 0x387d,
	0x3889, 0x3895, 0x38a2, 0x38ae, 0x38bb, 0x38c8, 0x38d5, 0x38e3, 0x38f1,
	0x38ff, 0x390d, 0x391b, 0x392a, 0x3939, 0x3949, 0x3959, 0x3969, 0x3979,
	0x398a, 0x399b, 0x39ac, 0x39be, 0x39d0, 0x39e2, 0x39f5, 0xc},
	{0x1630, 0x667, 0x30ff, 0x241, 0xcfd, 0x2226, 0x3fff, 0x105, 0x40a,
	0x961, 0x1140, 0x1bd1, 0x2935, 0x3989, 0x3fff, 0x80, 0x193, 0x313,
	0x525, 0x7d0, 0xb1a, 0xf09, 0x13a2, 0x18ea, 0x1ee5, 0x2596, 0x2d02,
	0x352c, 0x3e17, 0x3fff, 0x3fff, 0x3e, 0xc3, 0x148, 0x1e6, 0x2a6, 0x38a,
	0x493, 0x5c2, 0x717, 0x893, 0xa38, 0xc06, 0xdfe, 0x101f, 0x126c,
	0x14e4, 0x1788, 0x1a58, 0x1d55, 0x2080, 0x23d9, 0x2760, 0x2b16, 0x2efb,
	0x3310, 0x3755, 0x3bca, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x1d,
	0x5f, 0xa2, 0xe4, 0x126, 0x16c, 0x1bb, 0x212, 0x273, 0x2dc, 0x34e,
	0x3c9, 0x44d, 0x4db, 0x572, 0x613, 0x6be, 0x772, 0x831, 0x8f9, 0x9cb,
	0xaa8, 0xb8f, 0xc80, 0xd7c, 0xe82, 0xf93, 0x10ae, 0x11d5, 0x1306,
	0x1442, 0x1588, 0x16da, 0x1837, 0x19a0, 0x1b13, 0x1c92, 0x1e1c, 0x1fb1,
	0x2152, 0x22fe, 0x24b6, 0x267a, 0x2849, 0x2a24, 0x2c0a, 0x2dfd, 0x2ffc,
	0x3206, 0x341c, 0x363f, 0x386d, 0x3aa8, 0x3cef, 0x3f42, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0xc, 0x2d,
	0x4e, 0x70, 0x91, 0xb2, 0xd3, 0xf5, 0x116, 0x137, 0x15a, 0x17f, 0x1a6,
	0x1d0, 0x1fc, 0x22a, 0x25a, 0x28c, 0x2c0, 0x2f7, 0x330, 0x36c, 0x3a9,
	0x3e9, 0x42b, 0x470, 0x4b7, 0x500, 0x54c, 0x59a, 0x5ea, 0x63d, 0x692,
	0x6ea, 0x744, 0x7a1, 0x800, 0x862, 0x8c6, 0x92d, 0x996, 0xa02, 0xa70,
	0xae1, 0xb54, 0xbca, 0xc43, 0xcbe, 0xd3c, 0xdbc, 0xe40, 0xec5, 0xf4e,
	0xfd9, 0x1067, 0x10f7, 0x118a, 0x1220, 0x12b8, 0x1354, 0x13f2, 0x1492,
	0x1536, 0x15dc, 0x1685, 0x1731, 0x17df, 0x1890, 0x1944, 0x19fb, 0x1ab5,
	0x1b72, 0x1c31, 0x1cf3, 0x1db8, 0x1e80, 0x1f4a, 0x2018, 0x20e8, 0x21bc,
	0x2292, 0x236b, 0x2447, 0x2526, 0x2608, 0x26ec, 0x27d4, 0x28be, 0x29ac,
	0x2a9c, 0x2b90, 0x2c86, 0x2d7f, 0x2e7c, 0x2f7b, 0x307d, 0x3182, 0x328a,
	0x3396, 0x34a4, 0x35b5, 0x36c9, 0x37e1, 0x38fb, 0x3a18, 0x3b39, 0x3c5c,
	0x3d83, 0x3eac, 0x3fd9, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x4, 0x14, 0x25, 0x36, 0x46, 0x57, 0x67, 0x78,
	0x89, 0x99, 0xaa, 0xbb, 0xcb, 0xdc, 0xec, 0xfd, 0x10e, 0x11e, 0x12e,
	0x13f, 0x151, 0x163, 0x176, 0x189, 0x19c, 0x1b1, 0x1c5, 0x1db, 0x1f1,
	0x207, 0x21e, 0x235, 0x24d, 0x266, 0x27f, 0x299, 0x2b3, 0x2ce, 0x2e9,
	0x305, 0x322, 0x33f, 0x35c, 0x37b, 0x399, 0x3b9, 0x3d9, 0x3f9, 0x41a,
	0x43c, 0x45e, 0x481, 0x4a5, 0x4c9, 0x4ed, 0x513, 0x538, 0x55f, 0x586,
	0x5ad, 0x5d6, 0x5ff, 0x628, 0x652, 0x67d, 0x6a8, 0x6d4, 0x700, 0x72d,
	0x75b, 0x789, 0x7b8, 0x7e8, 0x818, 0x849, 0x87b, 0x8ad, 0x8df, 0x913,
	0x947, 0x97b, 0x9b0, 0x9e6, 0xa1d, 0xa54, 0xa8c, 0xac4, 0xafd, 0xb37,
	0xb71, 0xbac, 0xbe8, 0xc24, 0xc61, 0xc9f, 0xcdd, 0xd1c, 0xd5c, 0xd9c,
	0xddd, 0xe1f, 0xe61, 0xea4, 0xee7, 0xf2b, 0xf70, 0xfb6, 0xffc, 0x1043,
	0x108a, 0x10d3, 0x111b, 0x1165, 0x11af, 0x11fa, 0x1246, 0x1292, 0x12df,
	0x132d, 0x137b, 0x13ca, 0x141a, 0x146a, 0x14bb, 0x150d, 0x155f, 0x15b2,
	0x1606, 0x165a, 0x16b0, 0x1705, 0x175c, 0x17b3, 0x180b, 0x1864, 0x18bd,
	0x1917, 0x1972, 0x19cd, 0x1a29, 0x1a86, 0x1ae4, 0x1b42, 0x1ba1, 0x1c01,
	0x1c61, 0x1cc2, 0x1d24, 0x1d86, 0x1dea, 0x1e4e, 0x1eb2, 0x1f18, 0x1f7e,
	0x1fe4, 0x204c, 0x20b4, 0x211d, 0x2187, 0x21f1, 0x225c, 0x22c8, 0x2334,
	0x23a2, 0x2410, 0x247e, 0x24ee, 0x255e, 0x25cf, 0x2640, 0x26b3, 0x2726,
	0x279a, 0x280e, 0x2884, 0x28fa, 0x2970, 0x29e8, 0x2a60, 0x2ad9, 0x2b53,
	0x2bcd, 0x2c48, 0x2cc4, 0x2d41, 0x2dbe, 0x2e3c, 0x2ebb, 0x2f3b, 0x2fbb,
	0x303c, 0x30be, 0x3141, 0x31c4, 0x3248, 0x32cd, 0x3353, 0x33d9, 0x3460,
	0x34e8, 0x3571, 0x35fa, 0x3684, 0x370f, 0x379b, 0x3827, 0x38b4, 0x3942,
	0x39d1, 0x3a60, 0x3af0, 0x3b81, 0x3c13, 0x3ca5, 0x3d39, 0x3dcd, 0x3e61,
	0x3ef7, 0x3f8d, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x0, 0x8, 0x10, 0x18, 0x21, 0x29, 0x31, 0x3a,
	0x42, 0x4a, 0x53, 0x5b, 0x63, 0x6c, 0x74, 0x7c, 0x84, 0x8d, 0x95, 0x9d,
	0xa6, 0xae, 0xb6, 0xbf, 0xc7, 0xcf, 0xd8, 0xe0, 0xe8, 0xf1, 0xf9,
	0x101, 0x109, 0x112, 0x11a, 0x122, 0x12a, 0x132, 0x13b, 0x143, 0x14c,
	0x155, 0x15e, 0x167, 0x171, 0x17a, 0x184, 0x18e, 0x197, 0x1a1, 0x1ac,
	0x1b6, 0x1c0, 0x1cb, 0x1d5, 0x1e0, 0x1eb, 0x1f6, 0x201, 0x20d, 0x218,
	0x224, 0x230, 0x23b, 0x247, 0x254, 0x260, 0x26c, 0x279, 0x286, 0x292,
	0x29f, 0x2ad, 0x2ba, 0x2c7, 0x2d5, 0x2e2, 0x2f0, 0x2fe, 0x30c, 0x31b,
	0x329, 0x338, 0x346, 0x355, 0x364, 0x373, 0x382, 0x392, 0x3a1, 0x3b1,
	0x3c1, 0x3d1, 0x3e1, 0x3f1, 0x402, 0x412, 0x423, 0x434, 0x445, 0x456,
	0x467, 0x478, 0x48a, 0x49c, 0x4ae, 0x4c0, 0x4d2, 0x4e4, 0x4f7, 0x509,
	0x51c, 0x52f, 0x542, 0x555, 0x569, 0x57c, 0x590, 0x5a4, 0x5b7, 0x5cc,
	0x5e0, 0x5f4, 0x609, 0x61e, 0x632, 0x647, 0x65d, 0x672, 0x687, 0x69d,
	0x6b3, 0x6c9, 0x6df, 0x6f5, 0x70c, 0x722, 0x739, 0x750, 0x767, 0x77e,
	0x795, 0x7ad, 0x7c4, 0x7dc, 0x7f4, 0x80c, 0x824, 0x83d, 0x855, 0x86e,
	0x887, 0x8a0, 0x8b9, 0x8d3, 0x8ec, 0x906, 0x920, 0x93a, 0x954, 0x96e,
	0x988, 0x9a3, 0x9be, 0x9d9, 0x9f4, 0xa0f, 0xa2b, 0xa46, 0xa62, 0xa7e,
	0xa9a, 0xab6, 0xad2, 0xaef, 0xb0c, 0xb29, 0xb46, 0xb63, 0xb80, 0xb9e,
	0xbbb, 0xbd9, 0xbf7, 0xc15, 0xc34, 0xc52, 0xc71, 0xc90, 0xcaf, 0xcce,
	0xced, 0xd0c, 0xd2c, 0xd4c, 0xd6c, 0xd8c, 0xdac, 0xdcd, 0xded, 0xe0e,
	0xe2f, 0xe50, 0xe71, 0xe93, 0xeb4, 0xed6, 0xef8, 0xf1a, 0xf3d, 0xf5f,
	0xf82, 0xfa4, 0xfc7, 0xfea, 0x100e, 0x1031, 0x1055, 0x1078, 0x109c,
	0x10c0, 0x10e5, 0x1109, 0x112e, 0x1153, 0x1178, 0x119d, 0x11c2, 0x11e7,
	0x120d, 0x1233, 0x1259, 0x127f, 0x12a5, 0x12cc, 0x12f2, 0x1319, 0x1340,
	0x1367, 0x138f, 0x13b6, 0x13de, 0x1406, 0x142e, 0x1456, 0x147e, 0x14a7,
	0x14cf, 0x14f8, 0x1521, 0x154a, 0x1574, 0x159d, 0x15c7, 0x15f1, 0x161b,
	0x1645, 0x1670, 0x169a, 0x16c5, 0x16f0, 0x171b, 0x1746, 0x1772, 0x179d,
	0x17c9, 0x17f5, 0x1821, 0x184e, 0x187a, 0x18a7, 0x18d4, 0x1901, 0x192e,
	0x195b, 0x1989, 0x19b6, 0x19e4, 0x1a12, 0x1a41, 0x1a6f, 0x1a9e, 0x1acc,
	0x1afb, 0x1b2a, 0x1b5a, 0x1b89, 0x1bb9, 0x1be9, 0x1c19, 0x1c49, 0x1c79,
	0x1caa, 0x1cdb, 0x1d0b, 0x1d3d, 0x1d6e, 0x1d9f, 0x1dd1, 0x1e03, 0x1e35,
	0x1e67, 0x1e99, 0x1ecb, 0x1efe, 0x1f31, 0x1f64, 0x1f97, 0x1fcb, 0x1ffe,
	0x2032, 0x2066, 0x209a, 0x20ce, 0x2103, 0x2137, 0x216c, 0x21a1, 0x21d6,
	0x220c, 0x2241, 0x2277, 0x22ad, 0x22e3, 0x2319, 0x2350, 0x2386, 0x23bd,
	0x23f4, 0x242b, 0x2463, 0x249a, 0x24d2, 0x250a, 0x2542, 0x257a, 0x25b3,
	0x25eb, 0x2624, 0x265d, 0x2696, 0x26d0, 0x2709, 0x2743, 0x277d, 0x27b7,
	0x27f1, 0x282b, 0x2866, 0x28a1, 0x28dc, 0x2917, 0x2953, 0x298e, 0x29ca,
	0x2a06, 0x2a42, 0x2a7e, 0x2abb, 0x2af7, 0x2b34, 0x2b71, 0x2bae, 0x2bec,
	0x2c29, 0x2c67, 0x2ca5, 0x2ce3, 0x2d21, 0x2d60, 0x2d9f, 0x2dde, 0x2e1d,
	0x2e5c, 0x2e9b, 0x2edb, 0x2f1b, 0x2f5b, 0x2f9b, 0x2fdb, 0x301c, 0x305d,
	0x309e, 0x30df, 0x3120, 0x3161, 0x31a3, 0x31e5, 0x3227, 0x3269, 0x32ac,
	0x32ee, 0x3331, 0x3374, 0x33b7, 0x33fb, 0x343e, 0x3482, 0x34c6, 0x350a,
	0x354e, 0x3593, 0x35d7, 0x361c, 0x3661, 0x36a7, 0x36ec, 0x3732, 0x3778,
	0x37be, 0x3804, 0x384a, 0x3891, 0x38d7, 0x391e, 0x3966, 0x39ad, 0x39f4,
	0x3a3c, 0x3a84, 0x3acc, 0x3b14, 0x3b5d, 0x3ba6, 0x3bee, 0x3c37, 0x3c81,
	0x3cca, 0x3d14, 0x3d5e, 0x3da8, 0x3df2, 0x3e3c, 0x3e87, 0x3ed2, 0x3f1c,
	0x3f68, 0x3fb3, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x6},
	{0x1095, 0x4fa, 0x240a, 0x1d9, 0x9d8, 0x1949, 0x30eb, 0xe0, 0x334,
	0x72f, 0xcf9, 0x14ae, 0x1e66, 0x2a35, 0x382e, 0x6e, 0x152, 0x27a,
	0x409, 0x606, 0x875, 0xb5a, 0xeb7, 0x1291, 0x16eb, 0x1bc7, 0x2127,
	0x270e, 0x2d7f, 0x347b, 0x3c04, 0x35, 0xa7, 0x119, 0x193, 0x226, 0x2d4,
	0x39b, 0x47e, 0x57d, 0x697, 0x7cf, 0x923, 0xa95, 0xc25, 0xdd4, 0xfa2,
	0x118f, 0x139c, 0x15c9, 0x1816, 0x1a84, 0x1d12, 0x1fc2, 0x2294, 0x2588,
	0x289e, 0x2bd6, 0x2f31, 0x32af, 0x3650, 0x3a15, 0x3dfd, 0x18, 0x51,
	0x8a, 0xc3, 0xfc, 0x134, 0x172, 0x1b5, 0x1ff, 0x24f, 0x2a6, 0x303,
	0x367, 0x3d2, 0x443, 0x4bb, 0x53a, 0x5c1, 0x64e, 0x6e2, 0x77e, 0x821,
	0x8cb, 0x97d, 0xa36, 0xaf6, 0xbbf, 0xc8e, 0xd66, 0xe45, 0xf2c, 0x101a,
	0x1111, 0x120f, 0x1316, 0x1424, 0x153a, 0x1659, 0x177f, 0x18ae, 0x19e5,
	0x1b24, 0x1c6c, 0x1dbb, 0x1f13, 0x2074, 0x21dd, 0x234e, 0x24c8, 0x264a,
	0x27d5, 0x2968, 0x2b05, 0x2ca9, 0x2e57, 0x300d, 0x31cc, 0x3394, 0x3564,
	0x373e, 0x3920, 0x3b0b, 0x3cff, 0x3efd, 0xa, 0x27, 0x43, 0x60, 0x7c,
	0x99, 0xb5, 0xd1, 0xee, 0x10a, 0x126, 0x143, 0x162, 0x182, 0x1a4,
	0x1c7, 0x1ec, 0x213, 0x23b, 0x264, 0x290, 0x2bd, 0x2eb, 0x31c, 0x34d,
	0x381, 0x3b6, 0x3ed, 0x426, 0x460, 0x49c, 0x4da, 0x51a, 0x55b, 0x59e,
	0x5e3, 0x62a, 0x672, 0x6bd, 0x709, 0x756, 0x7a6, 0x7f7, 0x84b, 0x8a0,
	0x8f7, 0x950, 0x9aa, 0xa07, 0xa65, 0xac6, 0xb28, 0xb8c, 0xbf2, 0xc5a,
	0xcc3, 0xd2f, 0xd9d, 0xe0c, 0xe7e, 0xef1, 0xf67, 0xfde, 0x1057, 0x10d3,
	0x1150, 0x11cf, 0x1250, 0x12d3, 0x1359, 0x13e0, 0x1469, 0x14f4, 0x1581,
	0x1610, 0x16a2, 0x1735, 0x17ca, 0x1862, 0x18fb, 0x1996, 0x1a34, 0x1ad4,
	0x1b75, 0x1c19, 0x1cbf, 0x1d67, 0x1e10, 0x1ebd, 0x1f6b, 0x201b, 0x20cd,
	0x2182, 0x2238, 0x22f1, 0x23ac, 0x2469, 0x2528, 0x25e9, 0x26ac, 0x2771,
	0x2839, 0x2903, 0x29cf, 0x2a9d, 0x2b6d, 0x2c3f, 0x2d14, 0x2deb, 0x2ec4,
	0x2f9f, 0x307c, 0x315b, 0x323d, 0x3321, 0x3407, 0x34ef, 0x35da, 0x36c7,
	0x37b6, 0x38a7, 0x399a, 0x3a90, 0x3b87, 0x3c82, 0x3d7e, 0x3e7c, 0x3f7d,
	0x3, 0x11, 0x20, 0x2e, 0x3c, 0x4a, 0x58, 0x67, 0x75, 0x83, 0x91, 0xa0,
	0xae, 0xbc, 0xca, 0xd9, 0xe7, 0xf5, 0x103, 0x112, 0x120, 0x12d, 0x13c,
	0x14b, 0x15a, 0x16a, 0x17a, 0x18a, 0x19b, 0x1ad, 0x1be, 0x1d0, 0x1e3,
	0x1f6, 0x209, 0x21c, 0x230, 0x245, 0x25a, 0x26f, 0x285, 0x29b, 0x2b1,
	0x2c8, 0x2df, 0x2f7, 0x30f, 0x328, 0x341, 0x35a, 0x374, 0x38e, 0x3a9,
	0x3c4, 0x3df, 0x3fb, 0x418, 0x434, 0x452, 0x46f, 0x48d, 0x4ac, 0x4cb,
	0x4ea, 0x50a, 0x52a, 0x54b, 0x56c, 0x58d, 0x5af, 0x5d2, 0x5f5, 0x618,
	0x63c, 0x660, 0x685, 0x6aa, 0x6cf, 0x6f5, 0x71c, 0x743, 0x76a, 0x792,
	0x7ba, 0x7e3, 0x80c, 0x836, 0x860, 0x88a, 0x8b5, 0x8e1, 0x90d, 0x939,
	0x966, 0x993, 0x9c1, 0x9f0, 0xa1e, 0xa4e, 0xa7d, 0xaad, 0xade, 0xb0f,
	0xb41, 0xb73, 0xba5, 0xbd8, 0xc0c, 0xc40, 0xc74, 0xca9, 0xcde, 0xd14,
	0xd4a, 0xd81, 0xdb8, 0xdf0, 0xe29, 0xe61, 0xe9a, 0xed4, 0xf0e, 0xf49,
	0xf84, 0xfc0, 0xffc, 0x1039, 0x1076, 0x10b4, 0x10f2, 0x1130, 0x116f,
	0x11af, 0x11ef, 0x1230, 0x1271, 0x12b2, 0x12f4, 0x1337, 0x137a, 0x13be,
	0x1402, 0x1446, 0x148b, 0x14d1, 0x1517, 0x155e, 0x15a5, 0x15ec, 0x1635,
	0x167d, 0x16c6, 0x1710, 0x175a, 0x17a5, 0x17f0, 0x183c, 0x1888, 0x18d5,
	0x1922, 0x196f, 0x19be, 0x1a0c, 0x1a5c, 0x1aab, 0x1afc, 0x1b4d, 0x1b9e,
	0x1bf0, 0x1c42, 0x1c95, 0x1ce8, 0x1d3c, 0x1d91, 0x1de6, 0x1e3b, 0x1e91,
	0x1ee8, 0x1f3f, 0x1f96, 0x1fef, 0x2047, 0x20a0, 0x20fa, 0x2154, 0x21af,
	0x220a, 0x2266, 0x22c2, 0x231f, 0x237d, 0x23db, 0x2439, 0x2498, 0x24f8,
	0x2558, 0x25b8, 0x2619, 0x267b, 0x26dd, 0x2740, 0x27a3, 0x2807, 0x286b,
	0x28d0, 0x2936, 0x299c, 0x2a02, 0x2a69, 0x2ad1, 0x2b39, 0x2ba1, 0x2c0b,
	0x2c74, 0x2cdf, 0x2d49, 0x2db5, 0x2e21, 0x2e8d, 0x2efa, 0x2f68, 0x2fd6,
	0x3044, 0x30b4, 0x3123, 0x3194, 0x3205, 0x3276, 0x32e8, 0x335a, 0x33cd,
	0x3441, 0x34b5, 0x352a, 0x359f, 0x3615, 0x368b, 0x3702, 0x377a, 0x37f2,
	0x386a, 0x38e3, 0x395d, 0x39d7, 0x3a52, 0x3acd, 0x3b49, 0x3bc6, 0x3c43,
	0x3cc0, 0x3d3f, 0x3dbd, 0x3e3d, 0x3ebc, 0x3f3d, 0x3fbe, 0x0, 0x7, 0xe,
	0x15, 0x1c, 0x23, 0x2a, 0x31, 0x38, 0x40, 0x47, 0x4e, 0x55, 0x5c, 0x63,
	0x6a, 0x71, 0x78, 0x80, 0x87, 0x8e, 0x95, 0x9c, 0xa3, 0xaa, 0xb1, 0xb9,
	0xc0, 0xc7, 0xce, 0xd5, 0xdc, 0xe3, 0xea, 0xf1, 0xf9, 0x100, 0x107,
	0x10e, 0x115, 0x11c, 0x123, 0x12a, 0x131, 0x138, 0x13f, 0x147, 0x14e,
	0x156, 0x15e, 0x166, 0x16e, 0x176, 0x17e, 0x186, 0x18f, 0x197, 0x1a0,
	0x1a8, 0x1b1, 0x1ba, 0x1c3, 0x1cc, 0x1d5, 0x1de, 0x1e7, 0x1f1, 0x1fa,
	0x204, 0x20e, 0x217, 0x221, 0x22b, 0x236, 0x240, 0x24a, 0x255, 0x25f,
	0x26a, 0x274, 0x27f, 0x28a, 0x295, 0x2a0, 0x2ac, 0x2b7, 0x2c2, 0x2ce,
	0x2da, 0x2e5, 0x2f1, 0x2fd, 0x309, 0x315, 0x322, 0x32e, 0x33b, 0x347,
	0x354, 0x361, 0x36d, 0x37a, 0x388, 0x395, 0x3a2, 0x3b0, 0x3bd, 0x3cb,
	0x3d8, 0x3e6, 0x3f4, 0x402, 0x411, 0x41f, 0x42d, 0x43c, 0x44a, 0x459,
	0x468, 0x477, 0x486, 0x495, 0x4a4, 0x4b3, 0x4c3, 0x4d3, 0x4e2, 0x4f2,
	0x502, 0x512, 0x522, 0x532, 0x543, 0x553, 0x564, 0x574, 0x585, 0x596,
	0x5a7, 0x5b8, 0x5c9, 0x5db, 0x5ec, 0x5fe, 0x60f, 0x621, 0x633, 0x645,
	0x657, 0x669, 0x67b, 0x68e, 0x6a0, 0x6b3, 0x6c6, 0x6d9, 0x6ec, 0x6ff,
	0x712, 0x726, 0x739, 0x74d, 0x760, 0x774, 0x788, 0x79c, 0x7b0, 0x7c4,
	0x7d9, 0x7ed, 0x802, 0x816, 0x82b, 0x840, 0x855, 0x86a, 0x880, 0x895,
	0x8ab, 0x8c0, 0x8d6, 0x8ec, 0x902, 0x918, 0x92e, 0x944, 0x95b, 0x971,
	0x988, 0x99f, 0x9b6, 0x9cd, 0x9e4, 0x9fb, 0xa13, 0xa2a, 0xa42, 0xa59,
	0xa71, 0xa89, 0xaa1, 0xab9, 0xad2, 0xaea, 0xb03, 0xb1b, 0xb34, 0xb4d,
	0xb66, 0xb7f, 0xb98, 0xbb2, 0xbcb, 0xbe5, 0xbff, 0xc19, 0xc32, 0xc4d,
	0xc67, 0xc81, 0xc9c, 0xcb6, 0xcd1, 0xcec, 0xd07, 0xd22, 0xd3d, 0xd58,
	0xd73, 0xd8f, 0xdab, 0xdc6, 0xde2, 0xdfe, 0xe1a, 0xe37, 0xe53, 0xe70,
	0xe8c, 0xea9, 0xec6, 0xee3, 0xf00, 0xf1d, 0xf3a, 0xf58, 0xf75, 0xf93,
	0xfb1, 0xfcf, 0xfed, 0x100b, 0x102a, 0x1048, 0x1067, 0x1085, 0x10a4,
	0x10c3, 0x10e2, 0x1101, 0x1121, 0x1140, 0x1160, 0x117f, 0x119f, 0x11bf,
	0x11df, 0x11ff, 0x121f, 0x1240, 0x1260, 0x1281, 0x12a2, 0x12c3, 0x12e4,
	0x1305, 0x1326, 0x1348, 0x1369, 0x138b, 0x13ad, 0x13cf, 0x13f1, 0x1413,
	0x1435, 0x1458, 0x147a, 0x149d, 0x14c0, 0x14e3, 0x1506, 0x1529, 0x154c,
	0x156f, 0x1593, 0x15b7, 0x15db, 0x15fe, 0x1623, 0x1647, 0x166b, 0x168f,
	0x16b4, 0x16d9, 0x16fe, 0x1722, 0x1748, 0x176d, 0x1792, 0x17b8, 0x17dd,
	0x1803, 0x1829, 0x184f, 0x1875, 0x189b, 0x18c1, 0x18e8, 0x190e, 0x1935,
	0x195c, 0x1983, 0x19aa, 0x19d1, 0x19f9, 0x1a20, 0x1a48, 0x1a70, 0x1a97,
	0x1ac0, 0x1ae8, 0x1b10, 0x1b38, 0x1b61, 0x1b8a, 0x1bb2, 0x1bdb, 0x1c04,
	0x1c2e, 0x1c57, 0x1c80, 0x1caa, 0x1cd4, 0x1cfd, 0x1d27, 0x1d51, 0x1d7c,
	0x1da6, 0x1dd1, 0x1dfb, 0x1e26, 0x1e51, 0x1e7c, 0x1ea7, 0x1ed2, 0x1efe,
	0x1f29, 0x1f55, 0x1f81, 0x1fac, 0x1fd9, 0x2005, 0x2031, 0x205d, 0x208a,
	0x20b7, 0x20e4, 0x2111, 0x213e, 0x216b, 0x2198, 0x21c6, 0x21f3, 0x2221,
	0x224f, 0x227d, 0x22ab, 0x22da, 0x2308, 0x2337, 0x2365, 0x2394, 0x23c3,
	0x23f2, 0x2421, 0x2451, 0x2480, 0x24b0, 0x24e0, 0x2510, 0x2540, 0x2570,
	0x25a0, 0x25d0, 0x2601, 0x2632, 0x2663, 0x2693, 0x26c5, 0x26f6, 0x2727,
	0x2759, 0x278a, 0x27bc, 0x27ee, 0x2820, 0x2852, 0x2884, 0x28b7, 0x28e9,
	0x291c, 0x294f, 0x2982, 0x29b5, 0x29e8, 0x2a1c, 0x2a4f, 0x2a83, 0x2ab7,
	0x2aeb, 0x2b1f, 0x2b53, 0x2b87, 0x2bbc, 0x2bf0, 0x2c25, 0x2c5a, 0x2c8f,
	0x2cc4, 0x2cf9, 0x2d2f, 0x2d64, 0x2d9a, 0x2dd0, 0x2e06, 0x2e3c, 0x2e72,
	0x2ea8, 0x2edf, 0x2f16, 0x2f4c, 0x2f83, 0x2fba, 0x2ff1, 0x3029, 0x3060,
	0x3098, 0x30d0, 0x3107, 0x313f, 0x3178, 0x31b0, 0x31e8, 0x3221, 0x325a,
	0x3292, 0x32cb, 0x3304, 0x333e, 0x3377, 0x33b1, 0x33ea, 0x3424, 0x345e,
	0x3498, 0x34d2, 0x350d, 0x3547, 0x3582, 0x35bc, 0x35f7, 0x3632, 0x366e,
	0x36a9, 0x36e4, 0x3720, 0x375c, 0x3798, 0x37d4, 0x3810, 0x384c, 0x3888,
	0x38c5, 0x3902, 0x393f, 0x397c, 0x39b9, 0x39f6, 0x3a33, 0x3a71, 0x3aaf,
	0x3aec, 0x3b2a, 0x3b68, 0x3ba7, 0x3be5, 0x3c24, 0x3c62, 0x3ca1, 0x3ce0,
	0x3d1f, 0x3d5e, 0x3d9e, 0x3ddd, 0x3e1d, 0x3e5d, 0x3e9c, 0x3edc, 0x3f1d,
	0x3f5d, 0x3f9e, 0x3fde, 0x6},
	{0x798, 0x1ce, 0x20ac, 0x72, 0x413, 0xf47, 0x3fff, 0x1c, 0x103, 0x2d4,
	0x58e, 0xaaa, 0x1639, 0x3065, 0x3fff, 0x6, 0x40, 0xb3, 0x161, 0x24a,
	0x36c, 0x4c9, 0x679, 0x8f9, 0xcbc, 0x1266, 0x1aeb, 0x27bc, 0x3b05,
	0x3fff, 0x3fff, 0x1, 0xf, 0x2c, 0x57, 0x91, 0xd9, 0x130, 0x196, 0x20a,
	0x28d, 0x31e, 0x3be, 0x46c, 0x529, 0x5fe, 0x701, 0x840, 0x9c6, 0xba6,
	0xdf1, 0x10c2, 0x1437, 0x1873, 0x1da6, 0x2406, 0x2bd8, 0x3570, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0, 0x3, 0xa, 0x15, 0x23, 0x35, 0x4b,
	0x64, 0x81, 0xa2, 0xc6, 0xee, 0x119, 0x148, 0x17b, 0x1b2, 0x1ec, 0x229,
	0x26b, 0x2b0, 0x2f8, 0x345, 0x395, 0x3e8, 0x43f, 0x49a, 0x4f9, 0x55b,
	0x5c5, 0x63a, 0x6bb, 0x74b, 0x7ea, 0x89a, 0x95d, 0xa35, 0xb24, 0xc2d,
	0xd53, 0xe98, 0x1000, 0x118f, 0x1348, 0x1531, 0x174f, 0x19a7, 0x1c3f,
	0x1f1f, 0x224e, 0x25d5, 0x29bc, 0x2e10, 0x32da, 0x3828, 0x3e08, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0,
	0x0, 0x2, 0x5, 0x8, 0xd, 0x12, 0x18, 0x1f, 0x28, 0x31, 0x3a, 0x45,
	0x51, 0x5e, 0x6b, 0x7a, 0x89, 0x99, 0xaa, 0xbd, 0xd0, 0xe4, 0xf8,
	0x10e, 0x125, 0x13c, 0x155, 0x16e, 0x189, 0x1a4, 0x1c0, 0x1dd, 0x1fb,
	0x21a, 0x239, 0x25a, 0x27c, 0x29e, 0x2c2, 0x2e6, 0x30b, 0x331, 0x358,
	0x380, 0x3a9, 0x3d3, 0x3fe, 0x429, 0x456, 0x483, 0x4b2, 0x4e1, 0x511,
	0x542, 0x574, 0x5a9, 0x5e1, 0x61b, 0x659, 0x69a, 0x6de, 0x726, 0x771,
	0x7c1, 0x814, 0x86c, 0x8c9, 0x92b, 0x991, 0x9fd, 0xa6f, 0xae6, 0xb64,
	0xbe9, 0xc74, 0xd07, 0xda1, 0xe44, 0xeef, 0xfa3, 0x1060, 0x1127,
	0x11f9, 0x12d6, 0x13be, 0x14b2, 0x15b4, 0x16c2, 0x17df, 0x190b, 0x1a47,
	0x1b93, 0x1cf0, 0x1e60, 0x1fe3, 0x217b, 0x2327, 0x24ea, 0x26c5, 0x28b9,
	0x2ac7, 0x2cf0, 0x2f37, 0x319b, 0x3420, 0x36c7, 0x3992, 0x3c82, 0x3f99,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x0, 0x0, 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x7, 0x9, 0xb, 0xe, 0x11, 0x13,
	0x17, 0x1a, 0x1e, 0x21, 0x25, 0x2a, 0x2e, 0x33, 0x38, 0x3d, 0x42, 0x48,
	0x4e, 0x54, 0x5a, 0x61, 0x68, 0x6f, 0x76, 0x7d, 0x85, 0x8d, 0x95, 0x9d,
	0xa6, 0xaf, 0xb8, 0xc1, 0xcb, 0xd4, 0xde, 0xe9, 0xf3, 0xfe, 0x109,
	0x114, 0x11f, 0x12b, 0x136, 0x142, 0x14f, 0x15b, 0x168, 0x175, 0x182,
	0x18f, 0x19d, 0x1ab, 0x1b9, 0x1c7, 0x1d6, 0x1e4, 0x1f3, 0x202, 0x212,
	0x222, 0x231, 0x242, 0x252, 0x262, 0x273, 0x284, 0x296, 0x2a7, 0x2b9,
	0x2cb, 0x2dd, 0x2ef, 0x302, 0x315, 0x328, 0x33b, 0x34f, 0x362, 0x376,
	0x38a, 0x39f, 0x3b4, 0x3c8, 0x3de, 0x3f3, 0x409, 0x41e, 0x434, 0x44b,
	0x461, 0x478, 0x48f, 0x4a6, 0x4bd, 0x4d5, 0x4ed, 0x505, 0x51d, 0x536,
	0x54f, 0x568, 0x581, 0x59c, 0x5b7, 0x5d3, 0x5ef, 0x60c, 0x62a, 0x649,
	0x669, 0x689, 0x6aa, 0x6cd, 0x6f0, 0x713, 0x738, 0x75e, 0x785, 0x7ac,
	0x7d5, 0x7ff, 0x82a, 0x856, 0x883, 0x8b1, 0x8e1, 0x912, 0x944, 0x977,
	0x9ac, 0x9e2, 0xa19, 0xa52, 0xa8c, 0xac8, 0xb05, 0xb44, 0xb85, 0xbc7,
	0xc0b, 0xc51, 0xc98, 0xce1, 0xd2d, 0xd7a, 0xdc9, 0xe1a, 0xe6e, 0xec3,
	0xf1b, 0xf75, 0xfd1, 0x1030, 0x1091, 0x10f4, 0x115b, 0x11c3, 0x122f,
	0x129d, 0x130f, 0x1383, 0x13fa, 0x1474, 0x14f1, 0x1572, 0x15f6, 0x167d,
	0x1708, 0x1797, 0x1829, 0x18bf, 0x1959, 0x19f6, 0x1a98, 0x1b3e, 0x1be8,
	0x1c97, 0x1d4a, 0x1e02, 0x1ebf, 0x1f81, 0x2047, 0x2113, 0x21e4, 0x22ba,
	0x2396, 0x2477, 0x255f, 0x264c, 0x2740, 0x283a, 0x293a, 0x2a41, 0x2b4e,
	0x2c63, 0x2d7f, 0x2ea2, 0x2fcd, 0x30ff, 0x323a, 0x337c, 0x34c7, 0x361a,
	0x3777, 0x38dc, 0x3a4a, 0x3bc2, 0x3d44, 0x3ecf, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7,
	0x8, 0x9, 0xa, 0xb, 0xc, 0xd, 0xf, 0x10, 0x11, 0x13, 0x14, 0x16, 0x17,
	0x19, 0x1b, 0x1d, 0x1e, 0x20, 0x22, 0x24, 0x26, 0x29, 0x2b, 0x2d, 0x2f,
	0x32, 0x34, 0x37, 0x39, 0x3c, 0x3e, 0x41, 0x44, 0x47, 0x4a, 0x4c, 0x4f,
	0x53, 0x56, 0x59, 0x5c, 0x5f, 0x63, 0x66, 0x69, 0x6d, 0x70, 0x74, 0x78,
	0x7b, 0x7f, 0x83, 0x87, 0x8b, 0x8f, 0x93, 0x97, 0x9b, 0xa0, 0xa4, 0xa8,
	0xad, 0xb1, 0xb6, 0xba, 0xbf, 0xc4, 0xc8, 0xcd, 0xd2, 0xd7, 0xdc, 0xe1,
	0xe6, 0xeb, 0xf0, 0xf6, 0xfb, 0x100, 0x106, 0x10b, 0x111, 0x116, 0x11c,
	0x122, 0x128, 0x12d, 0x133, 0x139, 0x13f, 0x145, 0x14c, 0x152, 0x158,
	0x15e, 0x165, 0x16b, 0x171, 0x178, 0x17f, 0x185, 0x18c, 0x193, 0x199,
	0x1a0, 0x1a7, 0x1ae, 0x1b5, 0x1bc, 0x1c3, 0x1cb, 0x1d2, 0x1d9, 0x1e1,
	0x1e8, 0x1ef, 0x1f7, 0x1ff, 0x206, 0x20e, 0x216, 0x21e, 0x225, 0x22d,
	0x235, 0x23d, 0x246, 0x24e, 0x256, 0x25e, 0x267, 0x26f, 0x277, 0x280,
	0x289, 0x291, 0x29a, 0x2a3, 0x2ab, 0x2b4, 0x2bd, 0x2c6, 0x2cf, 0x2d8,
	0x2e1, 0x2eb, 0x2f4, 0x2fd, 0x306, 0x310, 0x319, 0x323, 0x32d, 0x336,
	0x340, 0x34a, 0x353, 0x35d, 0x367, 0x371, 0x37b, 0x385, 0x390, 0x39a,
	0x3a4, 0x3ae, 0x3b9, 0x3c3, 0x3ce, 0x3d8, 0x3e3, 0x3ee, 0x3f8, 0x403,
	0x40e, 0x419, 0x424, 0x42f, 0x43a, 0x445, 0x450, 0x45b, 0x467, 0x472,
	0x47e, 0x489, 0x495, 0x4a0, 0x4ac, 0x4b7, 0x4c3, 0x4cf, 0x4db, 0x4e7,
	0x4f3, 0x4ff, 0x50b, 0x517, 0x523, 0x530, 0x53c, 0x548, 0x555, 0x561,
	0x56e, 0x57b, 0x588, 0x595, 0x5a2, 0x5b0, 0x5be, 0x5cc, 0x5da, 0x5e8,
	0x5f6, 0x605, 0x614, 0x623, 0x632, 0x641, 0x651, 0x661, 0x671, 0x681,
	0x691, 0x6a2, 0x6b3, 0x6c4, 0x6d5, 0x6e7, 0x6f8, 0x70a, 0x71d, 0x72f,
	0x742, 0x754, 0x768, 0x77b, 0x78f, 0x7a2, 0x7b7, 0x7cb, 0x7e0, 0x7f4,
	0x80a, 0x81f, 0x835, 0x84b, 0x861, 0x878, 0x88f, 0x8a6, 0x8bd, 0x8d5,
	0x8ed, 0x905, 0x91e, 0x937, 0x950, 0x96a, 0x984, 0x99e, 0x9b9, 0x9d4,
	0x9ef, 0xa0b, 0xa27, 0xa43, 0xa60, 0xa7d, 0xa9b, 0xab9, 0xad7, 0xaf6,
	0xb15, 0xb34, 0xb54, 0xb74, 0xb95, 0xbb6, 0xbd8, 0xbfa, 0xc1c, 0xc3f,
	0xc62, 0xc86, 0xcaa, 0xccf, 0xcf4, 0xd1a, 0xd40, 0xd66, 0xd8d, 0xdb5,
	0xddd, 0xe06, 0xe2f, 0xe58, 0xe83, 0xead, 0xed9, 0xf05, 0xf31, 0xf5e,
	0xf8c, 0xfba, 0xfe8, 0x1018, 0x1048, 0x1078, 0x10a9, 0x10db, 0x110e,
	0x1141, 0x1175, 0x11a9, 0x11de, 0x1214, 0x124a, 0x1282, 0x12b9, 0x12f2,
	0x132b, 0x1365, 0x13a0, 0x13dc, 0x1418, 0x1455, 0x1493, 0x14d2, 0x1511,
	0x1552, 0x1593, 0x15d5, 0x1618, 0x165b, 0x16a0, 0x16e5, 0x172b, 0x1773,
	0x17bb, 0x1804, 0x184e, 0x1899, 0x18e5, 0x1932, 0x1980, 0x19ce, 0x1a1e,
	0x1a6f, 0x1ac1, 0x1b14, 0x1b68, 0x1bbe, 0x1c14, 0x1c6b, 0x1cc4, 0x1d1d,
	0x1d78, 0x1dd4, 0x1e31, 0x1e8f, 0x1eef, 0x1f50, 0x1fb2, 0x2015, 0x2079,
	0x20df, 0x2146, 0x21af, 0x2219, 0x2284, 0x22f0, 0x235e, 0x23ce, 0x243f,
	0x24b1, 0x2524, 0x259a, 0x2610, 0x2689, 0x2702, 0x277e, 0x27fa, 0x2879,
	0x28f9, 0x297b, 0x29fe, 0x2a84, 0x2b0a, 0x2b93, 0x2c1d, 0x2ca9, 0x2d37,
	0x2dc7, 0x2e59, 0x2eec, 0x2f81, 0x3019, 0x30b2, 0x314d, 0x31ea, 0x3289,
	0x332b, 0x33ce, 0x3473, 0x351b, 0x35c5, 0x3671, 0x371f, 0x37cf, 0x3882,
	0x3936, 0x39ee, 0x3aa7, 0x3b63, 0x3c21, 0x3ce2, 0x3da5, 0x3e6b, 0x3f34,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x6},
	{0x32a8, 0x2ea6, 0x361d, 0x2aa0, 0x30fc, 0x344a, 0x3808, 0x2696,
	0x2cf8, 0x3012, 0x3208, 0x3374, 0x3517, 0x36eb, 0x38d8, 0x2281, 0x28f0,
	0x2c0f, 0x2e06, 0x2f5a, 0x3082, 0x3181, 0x3256, 0x3305, 0x33f8, 0x34a8,
	0x359c, 0x367b, 0x3771, 0x3867, 0x395e, 0x1e58, 0x24e1, 0x2808, 0x2a01,
	0x2b54, 0x2c7e, 0x2d7d, 0x2e53, 0x2efd, 0x2fbd, 0x3049, 0x30be, 0x313d,
	0x31c8, 0x322e, 0x327e, 0x32d5, 0x333a, 0x33b3, 0x3421, 0x3477, 0x34dd,
	0x3557, 0x35e8, 0x364a, 0x36b1, 0x372b, 0x37bd, 0x3835, 0x389d, 0x3918,
	0x39ab, 0x1a0b, 0x20c2, 0x23f6, 0x25f1, 0x2748, 0x2877, 0x2974, 0x2a4e,
	0x2af8, 0x2bb6, 0x2c45, 0x2cba, 0x2d39, 0x2dc3, 0x2e2c, 0x2e7c, 0x2ed1,
	0x2f2b, 0x2f8b, 0x2ff0, 0x302d, 0x3065, 0x309f, 0x30dd, 0x311d, 0x315f,
	0x31a4, 0x31ec, 0x321b, 0x3242, 0x326a, 0x3293, 0x32be, 0x32ec, 0x331f,
	0x3356, 0x3393, 0x33d5, 0x340e, 0x3435, 0x3460, 0x348f, 0x34c2, 0x34fa,
	0x3536, 0x3579, 0x35c1, 0x3608, 0x3633, 0x3662, 0x3695, 0x36cd, 0x370b,
	0x374d, 0x3796, 0x37e6, 0x381e, 0x384d, 0x3881, 0x38ba, 0x38f7, 0x393a,
	0x3984, 0x39d4, 0x1500, 0x1c85, 0x1fc3, 0x21cc, 0x2331, 0x2468, 0x2563,
	0x2644, 0x26ec, 0x27aa, 0x283e, 0x28b2, 0x2931, 0x29bb, 0x2a27, 0x2a76,
	0x2acb, 0x2b25, 0x2b85, 0x2bea, 0x2c2a, 0x2c61, 0x2c9c, 0x2cd9, 0x2d18,
	0x2d5b, 0x2da0, 0x2de8, 0x2e19, 0x2e3f, 0x2e67, 0x2e90, 0x2ebb, 0x2ee7,
	0x2f14, 0x2f43, 0x2f72, 0x2fa4, 0x2fd6, 0x3005, 0x301f, 0x303b, 0x3057,
	0x3073, 0x3091, 0x30ae, 0x30cd, 0x30ec, 0x310c, 0x312d, 0x314e, 0x3170,
	0x3193, 0x31b6, 0x31da, 0x31ff, 0x3212, 0x3225, 0x3238, 0x324c, 0x3260,
	0x3274, 0x3289, 0x329e, 0x32b3, 0x32c9, 0x32e0, 0x32f9, 0x3312, 0x332c,
	0x3348, 0x3365, 0x3383, 0x33a3, 0x33c4, 0x33e6, 0x3405, 0x3418, 0x342b,
	0x3440, 0x3455, 0x346b, 0x3483, 0x349b, 0x34b5, 0x34cf, 0x34eb, 0x3508,
	0x3527, 0x3546, 0x3568, 0x358a, 0x35ae, 0x35d4, 0x35fc, 0x3612, 0x3628,
	0x363e, 0x3656, 0x366e, 0x3688, 0x36a3, 0x36bf, 0x36dc, 0x36fb, 0x371b,
	0x373c, 0x375f, 0x3783, 0x37aa, 0x37d1, 0x37fb, 0x3813, 0x382a, 0x3841,
	0x385a, 0x3874, 0x388f, 0x38ab, 0x38c8, 0x38e7, 0x3907, 0x3929, 0x394c,
	0x3971, 0x3997, 0x39bf, 0x39e9, 0xea8, 0x1815, 0x1b60, 0x1d86, 0x1f03,
	0x204c, 0x2142, 0x2231, 0x22d6, 0x2391, 0x2430, 0x24a3, 0x2521, 0x25a9,
	0x261e, 0x266c, 0x26c0, 0x271a, 0x2779, 0x27dd, 0x2823, 0x285a, 0x2894,
	0x28d1, 0x2910, 0x2952, 0x2997, 0x29df, 0x2a14, 0x2a3a, 0x2a62, 0x2a8b,
	0x2ab6, 0x2ae1, 0x2b0e, 0x2b3d, 0x2b6c, 0x2b9d, 0x2bd0, 0x2c02, 0x2c1c,
	0x2c37, 0x2c53, 0x2c70, 0x2c8d, 0x2cab, 0x2cc9, 0x2ce8, 0x2d08, 0x2d29,
	0x2d4a, 0x2d6c, 0x2d8e, 0x2db2, 0x2dd5, 0x2dfa, 0x2e0f, 0x2e22, 0x2e36,
	0x2e49, 0x2e5d, 0x2e71, 0x2e86, 0x2e9b, 0x2eb0, 0x2ec6, 0x2edc, 0x2ef2,
	0x2f09, 0x2f20, 0x2f37, 0x2f4e, 0x2f66, 0x2f7f, 0x2f97, 0x2fb0, 0x2fc9,
	0x2fe3, 0x2ffd, 0x300b, 0x3019, 0x3026, 0x3034, 0x3042, 0x3050, 0x305e,
	0x306c, 0x307b, 0x3089, 0x3098, 0x30a7, 0x30b6, 0x30c5, 0x30d5, 0x30e4,
	0x30f4, 0x3104, 0x3114, 0x3125, 0x3135, 0x3146, 0x3157, 0x3168, 0x3179,
	0x318a, 0x319c, 0x31ad, 0x31bf, 0x31d1, 0x31e3, 0x31f5, 0x3204, 0x320d,
	0x3216, 0x3220, 0x3229, 0x3233, 0x323d, 0x3247, 0x3251, 0x325b, 0x3265,
	0x326f, 0x3279, 0x3283, 0x328e, 0x3298, 0x32a3, 0x32ae, 0x32b8, 0x32c4,
	0x32cf, 0x32da, 0x32e6, 0x32f2, 0x32ff, 0x330c, 0x3318, 0x3326, 0x3333,
	0x3341, 0x334f, 0x335e, 0x336c, 0x337c, 0x338b, 0x339b, 0x33ab, 0x33bb,
	0x33cc, 0x33dd, 0x33ef, 0x3400, 0x3409, 0x3413, 0x341c, 0x3426, 0x3430,
	0x343a, 0x3445, 0x3450, 0x345b, 0x3466, 0x3471, 0x347d, 0x3489, 0x3495,
	0x34a2, 0x34ae, 0x34bb, 0x34c9, 0x34d6, 0x34e4, 0x34f2, 0x3501, 0x3510,
	0x351f, 0x352f, 0x353e, 0x354f, 0x355f, 0x3570, 0x3581, 0x3593, 0x35a5,
	0x35b8, 0x35cb, 0x35de, 0x35f2, 0x3603, 0x360d, 0x3618, 0x3622, 0x362d,
	0x3639, 0x3644, 0x3650, 0x365c, 0x3668, 0x3675, 0x3682, 0x368f, 0x369c,
	0x36aa, 0x36b8, 0x36c6, 0x36d5, 0x36e4, 0x36f3, 0x3703, 0x3713, 0x3723,
	0x3734, 0x3745, 0x3756, 0x3768, 0x377a, 0x378d, 0x37a0, 0x37b3, 0x37c7,
	0x37dc, 0x37f0, 0x3802, 0x380d, 0x3818, 0x3824, 0x382f, 0x383b, 0x3847,
	0x3854, 0x3860, 0x386d, 0x387a, 0x3888, 0x3896, 0x38a4, 0x38b2, 0x38c1,
	0x38d0, 0x38df, 0x38ef, 0x38ff, 0x3910, 0x3920, 0x3932, 0x3943, 0x3955,
	0x3967, 0x397a, 0x398d, 0x39a1, 0x39b5, 0x39c9, 0x39de, 0x39f4, 0x0,
	0x12aa, 0x16ab, 0x1900, 0x1aab, 0x1c15, 0x1d00, 0x1e0b, 0x1eab, 0x1f60,
	0x2015, 0x2085, 0x2100, 0x2186, 0x220b, 0x2258, 0x22ab, 0x2303, 0x2360,
	0x23c3, 0x2415, 0x244c, 0x2485, 0x24c2, 0x2500, 0x2542, 0x2586, 0x25cc,
	0x260b, 0x2631, 0x2658, 0x2681, 0x26ab, 0x26d6, 0x2703, 0x2731, 0x2760,
	0x2791, 0x27c3, 0x27f6, 0x2815, 0x2830, 0x284c, 0x2868, 0x2885, 0x28a3,
	0x28c2, 0x28e1, 0x2900, 0x2921, 0x2942, 0x2963, 0x2986, 0x29a9, 0x29cc,
	0x29f1, 0x2a0b, 0x2a1e, 0x2a31, 0x2a44, 0x2a58, 0x2a6c, 0x2a81, 0x2a96,
	0x2aab, 0x2ac0, 0x2ad6, 0x2aec, 0x2b03, 0x2b1a, 0x2b31, 0x2b48, 0x2b60,
	0x2b79, 0x2b91, 0x2baa, 0x2bc3, 0x2bdd, 0x2bf6, 0x2c08, 0x2c15, 0x2c23,
	0x2c30, 0x2c3e, 0x2c4c, 0x2c5a, 0x2c68, 0x2c77, 0x2c85, 0x2c94, 0x2ca3,
	0x2cb2, 0x2cc2, 0x2cd1, 0x2ce1, 0x2cf0, 0x2d00, 0x2d10, 0x2d21, 0x2d31,
	0x2d42, 0x2d52, 0x2d63, 0x2d74, 0x2d86, 0x2d97, 0x2da9, 0x2dbb, 0x2dcc,
	0x2ddf, 0x2df1, 0x2e01, 0x2e0b, 0x2e14, 0x2e1e, 0x2e27, 0x2e31, 0x2e3a,
	0x2e44, 0x2e4e, 0x2e58, 0x2e62, 0x2e6c, 0x2e76, 0x2e81, 0x2e8b, 0x2e96,
	0x2ea0, 0x2eab, 0x2eb6, 0x2ec0, 0x2ecb, 0x2ed6, 0x2ee1, 0x2eec, 0x2ef8,
	0x2f03, 0x2f0e, 0x2f1a, 0x2f25, 0x2f31, 0x2f3d, 0x2f48, 0x2f54, 0x2f60,
	0x2f6c, 0x2f79, 0x2f85, 0x2f91, 0x2f9d, 0x2faa, 0x2fb6, 0x2fc3, 0x2fd0,
	0x2fdd, 0x2fea, 0x2ff6, 0x3002, 0x3008, 0x300f, 0x3015, 0x301c, 0x3023,
	0x302a, 0x3030, 0x3037, 0x303e, 0x3045, 0x304c, 0x3053, 0x305a, 0x3061,
	0x3068, 0x3070, 0x3077, 0x307e, 0x3085, 0x308d, 0x3094, 0x309c, 0x30a3,
	0x30ab, 0x30b2, 0x30ba, 0x30c2, 0x30c9, 0x30d1, 0x30d9, 0x30e1, 0x30e8,
	0x30f0, 0x30f8, 0x3100, 0x3108, 0x3110, 0x3118, 0x3121, 0x3129, 0x3131,
	0x3139, 0x3142, 0x314a, 0x3152, 0x315b, 0x3163, 0x316c, 0x3174, 0x317d,
	0x3186, 0x318e, 0x3197, 0x31a0, 0x31a9, 0x31b2, 0x31bb, 0x31c3, 0x31cc,
	0x31d5, 0x31df, 0x31e8, 0x31f1, 0x31fa, 0x3201, 0x3206, 0x320b, 0x320f,
	0x3214, 0x3219, 0x321e, 0x3222, 0x3227, 0x322c, 0x3231, 0x3236, 0x323a,
	0x323f, 0x3244, 0x3249, 0x324e, 0x3253, 0x3258, 0x325d, 0x3262, 0x3267,
	0x326c, 0x3271, 0x3276, 0x327c, 0x3281, 0x3286, 0x328b, 0x3290, 0x3296,
	0x329b, 0x32a0, 0x32a6, 0x32ab, 0x32b0, 0x32b6, 0x32bb, 0x32c1, 0x32c6,
	0x32cc, 0x32d2, 0x32d8, 0x32dd, 0x32e3, 0x32e9, 0x32ef, 0x32f6, 0x32fc,
	0x3302, 0x3308, 0x330f, 0x3315, 0x331c, 0x3322, 0x3329, 0x3330, 0x3337,
	0x333e, 0x3345, 0x334c, 0x3353, 0x335a, 0x3361, 0x3369, 0x3370, 0x3378,
	0x337f, 0x3387, 0x338f, 0x3397, 0x339f, 0x33a7, 0x33af, 0x33b7, 0x33bf,
	0x33c8, 0x33d0, 0x33d9, 0x33e2, 0x33eb, 0x33f3, 0x33fc, 0x3402, 0x3407,
	0x340c, 0x3410, 0x3415, 0x341a, 0x341f, 0x3424, 0x3429, 0x342e, 0x3433,
	0x3438, 0x343d, 0x3442, 0x3448, 0x344d, 0x3452, 0x3458, 0x345d, 0x3463,
	0x3469, 0x346e, 0x3474, 0x347a, 0x3480, 0x3486, 0x348c, 0x3492, 0x3498,
	0x349e, 0x34a5, 0x34ab, 0x34b2, 0x34b8, 0x34bf, 0x34c5, 0x34cc, 0x34d3,
	0x34da, 0x34e1, 0x34e8, 0x34ef, 0x34f6, 0x34fd, 0x3505, 0x350c, 0x3514,
	0x351b, 0x3523, 0x352b, 0x3532, 0x353a, 0x3542, 0x354b, 0x3553, 0x355b,
	0x3563, 0x356c, 0x3574, 0x357d, 0x3586, 0x358f, 0x3598, 0x35a1, 0x35aa,
	0x35b3, 0x35bc, 0x35c6, 0x35cf, 0x35d9, 0x35e3, 0x35ed, 0x35f7, 0x3600,
	0x3605, 0x360a, 0x3610, 0x3615, 0x361a, 0x3620, 0x3625, 0x362b, 0x3630,
	0x3636, 0x363b, 0x3641, 0x3647, 0x364d, 0x3653, 0x3659, 0x365f, 0x3665,
	0x366b, 0x3672, 0x3678, 0x367e, 0x3685, 0x368b, 0x3692, 0x3699, 0x36a0,
	0x36a6, 0x36ad, 0x36b4, 0x36bb, 0x36c3, 0x36ca, 0x36d1, 0x36d9, 0x36e0,
	0x36e8, 0x36ef, 0x36f7, 0x36ff, 0x3707, 0x370f, 0x3717, 0x371f, 0x3727,
	0x372f, 0x3738, 0x3740, 0x3749, 0x3752, 0x375b, 0x3764, 0x376d, 0x3776,
	0x377f, 0x3788, 0x3792, 0x379b, 0x37a5, 0x37ae, 0x37b8, 0x37c2, 0x37cc,
	0x37d6, 0x37e1, 0x37eb, 0x37f6, 0x3800, 0x3805, 0x380b, 0x3810, 0x3816,
	0x381b, 0x3821, 0x3827, 0x382c, 0x3832, 0x3838, 0x383e, 0x3844, 0x384a,
	0x3851, 0x3857, 0x385d, 0x3864, 0x386a, 0x3870, 0x3877, 0x387e, 0x3885,
	0x388b, 0x3892, 0x3899, 0x38a0, 0x38a7, 0x38af, 0x38b6, 0x38bd, 0x38c5,
	0x38cc, 0x38d4, 0x38dc, 0x38e3, 0x38eb, 0x38f3, 0x38fb, 0x3903, 0x390c,
	0x3914, 0x391c, 0x3925, 0x392d, 0x3936, 0x393f, 0x3948, 0x3951, 0x395a,
	0x3963, 0x396c, 0x3975, 0x397f, 0x3989, 0x3992, 0x399c, 0x39a6, 0x39b0,
	0x39ba, 0x39c4, 0x39cf, 0x39d9, 0x39e4, 0x39ee, 0x39f9, 0xc},
	{0x1329, 0x468, 0x2f5a, 0x12e, 0xa44, 0x1f6d, 0x3fff, 0x65, 0x27f,
	0x6fb, 0xe50, 0x18da, 0x26ea, 0x38c5, 0x3fff, 0x2c, 0xba, 0x1c4, 0x35f,
	0x59c, 0x888, 0xc31, 0x10a2, 0x15e6, 0x1c07, 0x230e, 0x2b03, 0x33ef,
	0x3ddb, 0x3fff, 0x3fff, 0x15, 0x45, 0x8c, 0xf0, 0x175, 0x21d, 0x2ea,
	0x3df, 0x4fd, 0x646, 0x7bc, 0x960, 0xb35, 0xd3a, 0xf73, 0x11df, 0x1481,
	0x1759, 0x1a69, 0x1db3, 0x2136, 0x24f4, 0x28ef, 0x2d27, 0x319d, 0x3652,
	0x3b48, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0xa, 0x21, 0x38, 0x54,
	0x78, 0xa2, 0xd4, 0x10e, 0x150, 0x19b, 0x1ef, 0x24c, 0x2b3, 0x323,
	0x39e, 0x422, 0x4b1, 0x54b, 0x5ef, 0x69f, 0x75a, 0x821, 0x8f3, 0x9d1,
	0xabb, 0xbb1, 0xcb4, 0xdc3, 0xee0, 0x1009, 0x113f, 0x1282, 0x13d3,
	0x1532, 0x169e, 0x1818, 0x19a0, 0x1b36, 0x1cdb, 0x1e8e, 0x2050, 0x2220,
	0x23ff, 0x25ed, 0x27ea, 0x29f7, 0x2c13, 0x2e3e, 0x3079, 0x32c4, 0x351f,
	0x3789, 0x3a04, 0x3c8f, 0x3f2b, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x4, 0xf, 0x1b, 0x27, 0x32, 0x3f, 0x4d,
	0x5d, 0x6e, 0x81, 0x97, 0xae, 0xc7, 0xe2, 0xff, 0x11e, 0x13f, 0x162,
	0x188, 0x1b0, 0x1d9, 0x206, 0x234, 0x265, 0x298, 0x2ce, 0x306, 0x341,
	0x37e, 0x3be, 0x400, 0x445, 0x48c, 0x4d7, 0x523, 0x573, 0x5c5, 0x61a,
	0x672, 0x6cd, 0x72a, 0x78b, 0x7ee, 0x854, 0x8bd, 0x929, 0x998, 0xa0a,
	0xa7f, 0xaf7, 0xb73, 0xbf1, 0xc72, 0xcf7, 0xd7e, 0xe09, 0xe97, 0xf29,
	0xfbd, 0x1055, 0x10f0, 0x118f, 0x1230, 0x12d5, 0x137e, 0x142a, 0x14d9,
	0x158c, 0x1642, 0x16fb, 0x17b8, 0x1879, 0x193d, 0x1a04, 0x1acf, 0x1b9e,
	0x1c70, 0x1d46, 0x1e20, 0x1efd, 0x1fde, 0x20c2, 0x21aa, 0x2296, 0x2386,
	0x2479, 0x2570, 0x266b, 0x276a, 0x286c, 0x2972, 0x2a7c, 0x2b8a, 0x2c9c,
	0x2db2, 0x2ecc, 0x2fe9, 0x310b, 0x3230, 0x3359, 0x3487, 0x35b8, 0x36ed,
	0x3827, 0x3964, 0x3aa5, 0x3beb, 0x3d35, 0x3e82, 0x3fd4, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x1, 0x7, 0xd,
	0x12, 0x18, 0x1e, 0x24, 0x29, 0x2f, 0x35, 0x3b, 0x42, 0x49, 0x51, 0x58,
	0x61, 0x6a, 0x73, 0x7c, 0x87, 0x91, 0x9c, 0xa8, 0xb4, 0xc0, 0xcd, 0xdb,
	0xe9, 0xf7, 0x106, 0x116, 0x126, 0x137, 0x148, 0x159, 0x16b, 0x17e,
	0x192, 0x1a5, 0x1ba, 0x1cf, 0x1e4, 0x1fa, 0x211, 0x228, 0x240, 0x259,
	0x272, 0x28b, 0x2a6, 0x2c1, 0x2dc, 0x2f8, 0x315, 0x332, 0x350, 0x36f,
	0x38e, 0x3ae, 0x3ce, 0x3ef, 0x411, 0x434, 0x457, 0x47a, 0x49f, 0x4c4,
	0x4ea, 0x510, 0x537, 0x55f, 0x587, 0x5b0, 0x5da, 0x605, 0x630, 0x65c,
	0x689, 0x6b6, 0x6e4, 0x713, 0x742, 0x772, 0x7a3, 0x7d5, 0x807, 0x83a,
	0x86e, 0x8a3, 0x8d8, 0x90e, 0x945, 0x97c, 0x9b4, 0x9ed, 0xa27, 0xa62,
	0xa9d, 0xad9, 0xb16, 0xb53, 0xb92, 0xbd1, 0xc11, 0xc52, 0xc93, 0xcd5,
	0xd18, 0xd5c, 0xda1, 0xde6, 0xe2d, 0xe74, 0xebb, 0xf04, 0xf4e, 0xf98,
	0xfe3, 0x102f, 0x107c, 0x10c9, 0x1117, 0x1167, 0x11b7, 0x1208, 0x1259,
	0x12ac, 0x12ff, 0x1353, 0x13a8, 0x13fe, 0x1455, 0x14ad, 0x1505, 0x155f,
	0x15b9, 0x1614, 0x1670, 0x16cc, 0x172a, 0x1789, 0x17e8, 0x1848, 0x18a9,
	0x190b, 0x196e, 0x19d2, 0x1a37, 0x1a9c, 0x1b03, 0x1b6a, 0x1bd2, 0x1c3c,
	0x1ca6, 0x1d11, 0x1d7c, 0x1de9, 0x1e57, 0x1ec5, 0x1f35, 0x1fa5, 0x2017,
	0x2089, 0x20fc, 0x2170, 0x21e5, 0x225b, 0x22d2, 0x234a, 0x23c2, 0x243c,
	0x24b7, 0x2532, 0x25af, 0x262c, 0x26aa, 0x272a, 0x27aa, 0x282b, 0x28ad,
	0x2930, 0x29b5, 0x2a3a, 0x2ac0, 0x2b47, 0x2bcf, 0x2c57, 0x2ce1, 0x2d6c,
	0x2df8, 0x2e85, 0x2f13, 0x2fa1, 0x3031, 0x30c2, 0x3154, 0x31e6, 0x327a,
	0x330f, 0x33a4, 0x343b, 0x34d3, 0x356b, 0x3605, 0x36a0, 0x373b, 0x37d8,
	0x3876, 0x3914, 0x39b4, 0x3a55, 0x3af6, 0x3b99, 0x3c3d, 0x3ce2, 0x3d88,
	0x3e2e, 0x3ed6, 0x3f7f, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x0, 0x2, 0x5, 0x8, 0xb, 0xe, 0x11,
	0x14, 0x17, 0x1a, 0x1c, 0x1f, 0x22, 0x25, 0x28, 0x2b, 0x2e, 0x31, 0x34,
	0x37, 0x3a, 0x3d, 0x40, 0x44, 0x47, 0x4b, 0x4f, 0x52, 0x56, 0x5b, 0x5f,
	0x63, 0x67, 0x6c, 0x70, 0x75, 0x7a, 0x7f, 0x84, 0x89, 0x8f, 0x94, 0x99,
	0x9f, 0xa5, 0xab, 0xb1, 0xb7, 0xbd, 0xc4, 0xca, 0xd1, 0xd7, 0xde, 0xe5,
	0xec, 0xf4, 0xfb, 0x103, 0x10a, 0x112, 0x11a, 0x122, 0x12a, 0x132,
	0x13b, 0x143, 0x14c, 0x155, 0x15e, 0x167, 0x170, 0x179, 0x183, 0x18d,
	0x196, 0x1a0, 0x1aa, 0x1b5, 0x1bf, 0x1c9, 0x1d4, 0x1df, 0x1ea, 0x1f5,
	0x200, 0x20b, 0x217, 0x223, 0x22e, 0x23a, 0x246, 0x253, 0x25f, 0x26b,
	0x278, 0x285, 0x292, 0x29f, 0x2ac, 0x2ba, 0x2c7, 0x2d5, 0x2e3, 0x2f1,
	0x2ff, 0x30e, 0x31c, 0x32b, 0x33a, 0x349, 0x358, 0x367, 0x376, 0x386,
	0x396, 0x3a6, 0x3b6, 0x3c6, 0x3d6, 0x3e7, 0x3f8, 0x409, 0x41a, 0x42b,
	0x43c, 0x44e, 0x45f, 0x471, 0x483, 0x496, 0x4a8, 0x4bb, 0x4cd, 0x4e0,
	0x4f3, 0x506, 0x51a, 0x52d, 0x541, 0x555, 0x569, 0x57d, 0x592, 0x5a6,
	0x5bb, 0x5d0, 0x5e5, 0x5fa, 0x610, 0x625, 0x63b, 0x651, 0x667, 0x67d,
	0x694, 0x6aa, 0x6c1, 0x6d8, 0x6f0, 0x707, 0x71e, 0x736, 0x74e, 0x766,
	0x77e, 0x797, 0x7af, 0x7c8, 0x7e1, 0x7fa, 0x814, 0x82d, 0x847, 0x861,
	0x87b, 0x895, 0x8b0, 0x8ca, 0x8e5, 0x900, 0x91b, 0x937, 0x952, 0x96e,
	0x98a, 0x9a6, 0x9c3, 0x9df, 0x9fc, 0xa19, 0xa36, 0xa53, 0xa70, 0xa8e,
	0xaac, 0xaca, 0xae8, 0xb07, 0xb25, 0xb44, 0xb63, 0xb82, 0xba2, 0xbc1,
	0xbe1, 0xc01, 0xc21, 0xc41, 0xc62, 0xc83, 0xca4, 0xcc5, 0xce6, 0xd08,
	0xd29, 0xd4b, 0xd6d, 0xd90, 0xdb2, 0xdd5, 0xdf8, 0xe1b, 0xe3e, 0xe62,
	0xe85, 0xea9, 0xece, 0xef2, 0xf16, 0xf3b, 0xf60, 0xf85, 0xfab, 0xfd0,
	0xff6, 0x101c, 0x1042, 0x1068, 0x108f, 0x10b6, 0x10dd, 0x1104, 0x112b,
	0x1153, 0x117b, 0x11a3, 0x11cb, 0x11f3, 0x121c, 0x1245, 0x126e, 0x1297,
	0x12c1, 0x12ea, 0x1314, 0x133e, 0x1369, 0x1393, 0x13be, 0x13e9, 0x1414,
	0x143f, 0x146b, 0x1497, 0x14c3, 0x14ef, 0x151b, 0x1548, 0x1575, 0x15a2,
	0x15cf, 0x15fd, 0x162b, 0x1659, 0x1687, 0x16b5, 0x16e4, 0x1713, 0x1742,
	0x1771, 0x17a0, 0x17d0, 0x1800, 0x1830, 0x1860, 0x1891, 0x18c2, 0x18f3,
	0x1924, 0x1956, 0x1987, 0x19b9, 0x19eb, 0x1a1e, 0x1a50, 0x1a83, 0x1ab6,
	0x1ae9, 0x1b1d, 0x1b50, 0x1b84, 0x1bb8, 0x1bed, 0x1c21, 0x1c56, 0x1c8b,
	0x1cc0, 0x1cf6, 0x1d2b, 0x1d61, 0x1d97, 0x1dce, 0x1e04, 0x1e3b, 0x1e72,
	0x1eaa, 0x1ee1, 0x1f19, 0x1f51, 0x1f89, 0x1fc1, 0x1ffa, 0x2033, 0x206c,
	0x20a5, 0x20df, 0x2119, 0x2153, 0x218d, 0x21c8, 0x2202, 0x223d, 0x2279,
	0x22b4, 0x22f0, 0x232c, 0x2368, 0x23a4, 0x23e1, 0x241d, 0x245a, 0x2498,
	0x24d5, 0x2513, 0x2551, 0x258f, 0x25ce, 0x260d, 0x264b, 0x268b, 0x26ca,
	0x270a, 0x274a, 0x278a, 0x27ca, 0x280b, 0x284c, 0x288d, 0x28ce, 0x2910,
	0x2951, 0x2993, 0x29d6, 0x2a18, 0x2a5b, 0x2a9e, 0x2ae1, 0x2b25, 0x2b68,
	0x2bac, 0x2bf1, 0x2c35, 0x2c7a, 0x2cbf, 0x2d04, 0x2d49, 0x2d8f, 0x2dd5,
	0x2e1b, 0x2e62, 0x2ea8, 0x2eef, 0x2f36, 0x2f7e, 0x2fc5, 0x300d, 0x3055,
	0x309e, 0x30e6, 0x312f, 0x3178, 0x31c1, 0x320b, 0x3255, 0x329f, 0x32e9,
	0x3334, 0x337f, 0x33ca, 0x3415, 0x3461, 0x34ad, 0x34f9, 0x3545, 0x3592,
	0x35de, 0x362b, 0x3679, 0x36c6, 0x3714, 0x3762, 0x37b1, 0x37ff, 0x384e,
	0x389d, 0x38ed, 0x393c, 0x398c, 0x39dc, 0x3a2c, 0x3a7d, 0x3ace, 0x3b1f,
	0x3b70, 0x3bc2, 0x3c14, 0x3c66, 0x3cb8, 0x3d0b, 0x3d5e, 0x3db1, 0x3e05,
	0x3e58, 0x3eac, 0x3f00, 0x3f55, 0x3faa, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x6},
	{0xdab, 0x33c, 0x216a, 0xe8, 0x766, 0x1646, 0x2f44, 0x52, 0x1dc, 0x512,
	0xa41, 0x11aa, 0x1b84, 0x27fd, 0x3743, 0x26, 0x92, 0x155, 0x27e, 0x418,
	0x62b, 0x8c2, 0xbe4, 0xf97, 0x13e4, 0x18d0, 0x1e61, 0x249e, 0x2b8a,
	0x332c, 0x3b89, 0x12, 0x3a, 0x70, 0xba, 0x11c, 0x196, 0x22a, 0x2da,
	0x3a6, 0x491, 0x59a, 0x6c4, 0x810, 0x97d, 0xb0e, 0xcc3, 0xe9c, 0x109c,
	0x12c2, 0x1510, 0x1786, 0x1a25, 0x1ced, 0x1fe0, 0x22fe, 0x2648, 0x29be,
	0x2d61, 0x3132, 0x3532, 0x3960, 0x3dbe, 0x8, 0x1c, 0x30, 0x46, 0x60,
	0x80, 0xa5, 0xd0, 0x101, 0x138, 0x175, 0x1b8, 0x202, 0x253, 0x2ab,
	0x30a, 0x370, 0x3de, 0x453, 0x4d0, 0x555, 0x5e2, 0x677, 0x714, 0x7ba,
	0x868, 0x91e, 0x9de, 0xaa6, 0xb77, 0xc52, 0xd35, 0xe22, 0xf19, 0x1018,
	0x1122, 0x1235, 0x1352, 0x1479, 0x15aa, 0x16e4, 0x182a, 0x1979, 0x1ad3,
	0x1c37, 0x1da6, 0x1f1f, 0x20a4, 0x2233, 0x23cc, 0x2571, 0x2721, 0x28dc,
	0x2aa3, 0x2c74, 0x2e51, 0x303a, 0x322e, 0x342e, 0x3639, 0x3850, 0x3a73,
	0x3ca2, 0x3edd, 0x3, 0xd, 0x17, 0x21, 0x2b, 0x35, 0x40, 0x4c, 0x59,
	0x68, 0x78, 0x89, 0x9c, 0xb0, 0xc5, 0xdc, 0xf4, 0x10e, 0x12a, 0x146,
	0x165, 0x185, 0x1a7, 0x1ca, 0x1ef, 0x216, 0x23e, 0x269, 0x294, 0x2c2,
	0x2f2, 0x323, 0x356, 0x38b, 0x3c2, 0x3fb, 0x435, 0x472, 0x4b0, 0x4f1,
	0x533, 0x577, 0x5be, 0x606, 0x651, 0x69d, 0x6ec, 0x73d, 0x78f, 0x7e4,
	0x83b, 0x895, 0x8f0, 0x94d, 0x9ad, 0xa0f, 0xa73, 0xada, 0xb42, 0xbad,
	0xc1a, 0xc8a, 0xcfc, 0xd70, 0xde6, 0xe5f, 0xeda, 0xf58, 0xfd8, 0x105a,
	0x10df, 0x1166, 0x11ef, 0x127b, 0x130a, 0x139b, 0x142e, 0x14c4, 0x155c,
	0x15f7, 0x1695, 0x1735, 0x17d7, 0x187d, 0x1924, 0x19cf, 0x1a7b, 0x1b2b,
	0x1bdd, 0x1c92, 0x1d49, 0x1e03, 0x1ec0, 0x1f7f, 0x2042, 0x2106, 0x21ce,
	0x2298, 0x2365, 0x2435, 0x2507, 0x25dc, 0x26b4, 0x278f, 0x286d, 0x294d,
	0x2a30, 0x2b16, 0x2bff, 0x2ceb, 0x2dd9, 0x2eca, 0x2fbf, 0x30b6, 0x31b0,
	0x32ad, 0x33ac, 0x34af, 0x35b5, 0x36bd, 0x37c9, 0x38d8, 0x39e9, 0x3afd,
	0x3c15, 0x3d2f, 0x3e4d, 0x3f6d, 0x1, 0x6, 0xb, 0x10, 0x15, 0x1a, 0x1e,
	0x23, 0x28, 0x2d, 0x32, 0x37, 0x3d, 0x43, 0x49, 0x4f, 0x56, 0x5d, 0x64,
	0x6c, 0x74, 0x7c, 0x85, 0x8e, 0x97, 0xa0, 0xaa, 0xb5, 0xc0, 0xcb, 0xd6,
	0xe2, 0xee, 0xfb, 0x108, 0x115, 0x123, 0x131, 0x13f, 0x14e, 0x15d,
	0x16d, 0x17d, 0x18d, 0x19e, 0x1af, 0x1c1, 0x1d3, 0x1e6, 0x1f9, 0x20c,
	0x220, 0x234, 0x249, 0x25e, 0x273, 0x289, 0x2a0, 0x2b7, 0x2ce, 0x2e6,
	0x2fe, 0x316, 0x32f, 0x349, 0x363, 0x37e, 0x398, 0x3b4, 0x3d0, 0x3ec,
	0x409, 0x426, 0x444, 0x462, 0x481, 0x4a0, 0x4c0, 0x4e0, 0x501, 0x522,
	0x544, 0x566, 0x589, 0x5ac, 0x5d0, 0x5f4, 0x619, 0x63e, 0x664, 0x68a,
	0x6b1, 0x6d8, 0x700, 0x728, 0x751, 0x77a, 0x7a4, 0x7cf, 0x7fa, 0x825,
	0x851, 0x87e, 0x8ab, 0x8d9, 0x907, 0x936, 0x965, 0x995, 0x9c5, 0x9f6,
	0xa28, 0xa5a, 0xa8d, 0xac0, 0xaf4, 0xb28, 0xb5d, 0xb92, 0xbc8, 0xbff,
	0xc36, 0xc6e, 0xca6, 0xcdf, 0xd19, 0xd53, 0xd8d, 0xdc8, 0xe04, 0xe41,
	0xe7e, 0xebb, 0xef9, 0xf38, 0xf77, 0xfb7, 0xff8, 0x1039, 0x107b,
	0x10bd, 0x1100, 0x1144, 0x1188, 0x11cd, 0x1212, 0x1258, 0x129f, 0x12e6,
	0x132e, 0x1376, 0x13bf, 0x1409, 0x1453, 0x149e, 0x14ea, 0x1536, 0x1583,
	0x15d0, 0x161e, 0x166d, 0x16bd, 0x170d, 0x175d, 0x17af, 0x1800, 0x1853,
	0x18a6, 0x18fa, 0x194f, 0x19a4, 0x19fa, 0x1a50, 0x1aa7, 0x1aff, 0x1b57,
	0x1bb0, 0x1c0a, 0x1c64, 0x1cbf, 0x1d1b, 0x1d78, 0x1dd5, 0x1e32, 0x1e91,
	0x1ef0, 0x1f4f, 0x1fb0, 0x2011, 0x2072, 0x20d5, 0x2138, 0x219c, 0x2200,
	0x2265, 0x22cb, 0x2331, 0x2399, 0x2401, 0x2469, 0x24d2, 0x253c, 0x25a7,
	0x2612, 0x267e, 0x26eb, 0x2758, 0x27c6, 0x2835, 0x28a4, 0x2915, 0x2985,
	0x29f7, 0x2a69, 0x2adc, 0x2b50, 0x2bc4, 0x2c3a, 0x2caf, 0x2d26, 0x2d9d,
	0x2e15, 0x2e8e, 0x2f07, 0x2f81, 0x2ffc, 0x3078, 0x30f4, 0x3171, 0x31ef,
	0x326d, 0x32ec, 0x336c, 0x33ed, 0x346e, 0x34f0, 0x3573, 0x35f7, 0x367b,
	0x3700, 0x3786, 0x380c, 0x3894, 0x391c, 0x39a4, 0x3a2e, 0x3ab8, 0x3b43,
	0x3bcf, 0x3c5b, 0x3ce8, 0x3d76, 0x3e05, 0x3e95, 0x3f25, 0x3fb6, 0x0,
	0x2, 0x4, 0x7, 0x9, 0xc, 0xe, 0x11, 0x13, 0x16, 0x18, 0x1b, 0x1d, 0x20,
	0x22, 0x25, 0x27, 0x2a, 0x2c, 0x2f, 0x31, 0x34, 0x36, 0x39, 0x3c, 0x3e,
	0x41, 0x44, 0x47, 0x4a, 0x4d, 0x51, 0x54, 0x57, 0x5b, 0x5f, 0x62, 0x66,
	0x6a, 0x6e, 0x72, 0x76, 0x7a, 0x7e, 0x82, 0x87, 0x8b, 0x90, 0x94, 0x99,
	0x9e, 0xa3, 0xa8, 0xad, 0xb2, 0xb7, 0xbd, 0xc2, 0xc8, 0xcd, 0xd3, 0xd9,
	0xdf, 0xe5, 0xeb, 0xf1, 0xf7, 0xfe, 0x104, 0x10b, 0x111, 0x118, 0x11f,
	0x126, 0x12d, 0x134, 0x13b, 0x143, 0x14a, 0x152, 0x159, 0x161, 0x169,
	0x171, 0x179, 0x181, 0x189, 0x192, 0x19a, 0x1a2, 0x1ab, 0x1b4, 0x1bd,
	0x1c6, 0x1cf, 0x1d8, 0x1e1, 0x1ea, 0x1f4, 0x1fe, 0x207, 0x211, 0x21b,
	0x225, 0x22f, 0x239, 0x244, 0x24e, 0x258, 0x263, 0x26e, 0x279, 0x284,
	0x28f, 0x29a, 0x2a5, 0x2b1, 0x2bc, 0x2c8, 0x2d4, 0x2e0, 0x2ec, 0x2f8,
	0x304, 0x310, 0x31d, 0x329, 0x336, 0x343, 0x350, 0x35d, 0x36a, 0x377,
	0x384, 0x392, 0x39f, 0x3ad, 0x3bb, 0x3c9, 0x3d7, 0x3e5, 0x3f3, 0x402,
	0x410, 0x41f, 0x42e, 0x43d, 0x44c, 0x45b, 0x46a, 0x479, 0x489, 0x499,
	0x4a8, 0x4b8, 0x4c8, 0x4d8, 0x4e8, 0x4f9, 0x509, 0x51a, 0x52b, 0x53b,
	0x54c, 0x55e, 0x56f, 0x580, 0x592, 0x5a3, 0x5b5, 0x5c7, 0x5d9, 0x5eb,
	0x5fd, 0x60f, 0x622, 0x635, 0x647, 0x65a, 0x66d, 0x680, 0x694, 0x6a7,
	0x6bb, 0x6ce, 0x6e2, 0x6f6, 0x70a, 0x71e, 0x732, 0x747, 0x75b, 0x770,
	0x785, 0x79a, 0x7af, 0x7c4, 0x7da, 0x7ef, 0x805, 0x81a, 0x830, 0x846,
	0x85d, 0x873, 0x889, 0x8a0, 0x8b7, 0x8cd, 0x8e4, 0x8fb, 0x913, 0x92a,
	0x942, 0x959, 0x971, 0x989, 0x9a1, 0x9b9, 0x9d2, 0x9ea, 0xa03, 0xa1c,
	0xa34, 0xa4d, 0xa67, 0xa80, 0xa99, 0xab3, 0xacd, 0xae7, 0xb01, 0xb1b,
	0xb35, 0xb50, 0xb6a, 0xb85, 0xba0, 0xbbb, 0xbd6, 0xbf1, 0xc0d, 0xc28,
	0xc44, 0xc60, 0xc7c, 0xc98, 0xcb4, 0xcd1, 0xced, 0xd0a, 0xd27, 0xd44,
	0xd61, 0xd7e, 0xd9c, 0xdba, 0xdd7, 0xdf5, 0xe13, 0xe31, 0xe50, 0xe6e,
	0xe8d, 0xeac, 0xecb, 0xeea, 0xf09, 0xf28, 0xf48, 0xf68, 0xf87, 0xfa7,
	0xfc7, 0xfe8, 0x1008, 0x1029, 0x1049, 0x106a, 0x108b, 0x10ad, 0x10ce,
	0x10ef, 0x1111, 0x1133, 0x1155, 0x1177, 0x1199, 0x11bb, 0x11de, 0x1201,
	0x1223, 0x1246, 0x126a, 0x128d, 0x12b0, 0x12d4, 0x12f8, 0x131c, 0x1340,
	0x1364, 0x1388, 0x13ad, 0x13d2, 0x13f6, 0x141c, 0x1441, 0x1466, 0x148b,
	0x14b1, 0x14d7, 0x14fd, 0x1523, 0x1549, 0x1570, 0x1596, 0x15bd, 0x15e4,
	0x160b, 0x1632, 0x1659, 0x1681, 0x16a9, 0x16d1, 0x16f9, 0x1721, 0x1749,
	0x1771, 0x179a, 0x17c3, 0x17ec, 0x1815, 0x183e, 0x1868, 0x1891, 0x18bb,
	0x18e5, 0x190f, 0x1939, 0x1964, 0x198e, 0x19b9, 0x19e4, 0x1a0f, 0x1a3a,
	0x1a66, 0x1a91, 0x1abd, 0x1ae9, 0x1b15, 0x1b41, 0x1b6d, 0x1b9a, 0x1bc7,
	0x1bf4, 0x1c21, 0x1c4e, 0x1c7b, 0x1ca9, 0x1cd6, 0x1d04, 0x1d32, 0x1d60,
	0x1d8f, 0x1dbd, 0x1dec, 0x1e1b, 0x1e4a, 0x1e79, 0x1ea8, 0x1ed8, 0x1f07,
	0x1f37, 0x1f67, 0x1f98, 0x1fc8, 0x1ff8, 0x2029, 0x205a, 0x208b, 0x20bc,
	0x20ee, 0x211f, 0x2151, 0x2183, 0x21b5, 0x21e7, 0x2219, 0x224c, 0x227f,
	0x22b2, 0x22e5, 0x2318, 0x234b, 0x237f, 0x23b3, 0x23e6, 0x241b, 0x244f,
	0x2483, 0x24b8, 0x24ed, 0x2522, 0x2557, 0x258c, 0x25c2, 0x25f7, 0x262d,
	0x2663, 0x2699, 0x26cf, 0x2706, 0x273d, 0x2774, 0x27ab, 0x27e2, 0x2819,
	0x2851, 0x2888, 0x28c0, 0x28f8, 0x2931, 0x2969, 0x29a2, 0x29db, 0x2a14,
	0x2a4d, 0x2a86, 0x2ac0, 0x2af9, 0x2b33, 0x2b6d, 0x2ba7, 0x2be2, 0x2c1c,
	0x2c57, 0x2c92, 0x2ccd, 0x2d08, 0x2d44, 0x2d7f, 0x2dbb, 0x2df7, 0x2e33,
	0x2e70, 0x2eac, 0x2ee9, 0x2f26, 0x2f63, 0x2fa0, 0x2fdd, 0x301b, 0x3059,
	0x3097, 0x30d5, 0x3113, 0x3152, 0x3190, 0x31cf, 0x320e, 0x324e, 0x328d,
	0x32cd, 0x330c, 0x334c, 0x338c, 0x33cd, 0x340d, 0x344e, 0x348f, 0x34d0,
	0x3511, 0x3552, 0x3594, 0x35d6, 0x3618, 0x365a, 0x369c, 0x36df, 0x3721,
	0x3764, 0x37a7, 0x37eb, 0x382e, 0x3872, 0x38b6, 0x38fa, 0x393e, 0x3982,
	0x39c7, 0x3a0b, 0x3a50, 0x3a95, 0x3adb, 0x3b20, 0x3b66, 0x3bac, 0x3bf2,
	0x3c38, 0x3c7e, 0x3cc5, 0x3d0c, 0x3d53, 0x3d9a, 0x3de1, 0x3e29, 0x3e71,
	0x3eb9, 0x3f01, 0x3f49, 0x3f91, 0x3fda, 0x6},
	{0x2e59, 0x255e, 0x3614, 0x1ec7, 0x2a3b, 0x323d, 0x39f4, 0x197e,
	0x2273, 0x2805, 0x2c55, 0x304f, 0x3428, 0x3803, 0x39ff, 0x14cc, 0x1c7b,
	0x20b8, 0x2413, 0x26a5, 0x2907, 0x2b3e, 0x2d52, 0x2f4d, 0x3139, 0x331c,
	0x34fe, 0x36e4, 0x38d1, 0x39ff, 0x39ff, 0x1090, 0x1781, 0x1b11, 0x1dca,
	0x1ff0, 0x21af, 0x2335, 0x24a8, 0x261e, 0x2747, 0x287b, 0x29af, 0x2ab2,
	0x2be5, 0x2cc9, 0x2df4, 0x2ec9, 0x2fe8, 0x30ba, 0x31cd, 0x32a4, 0x33aa,
	0x348a, 0x3587, 0x3673, 0x3769, 0x3861, 0x3955, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0xc70, 0x1300, 0x164d, 0x1886, 0x1a57, 0x1bef, 0x1d16, 0x1e4e,
	0x1f52, 0x2052, 0x212c, 0x2220, 0x22ce, 0x23a7, 0x245a, 0x24fe, 0x25c8,
	0x265e, 0x26f2, 0x27a5, 0x283d, 0x28be, 0x2958, 0x2a07, 0x2a74, 0x2af5,
	0x2b8e, 0x2c21, 0x2c8c, 0x2d0b, 0x2da0, 0x2e28, 0x2e8f, 0x2f09, 0x2f98,
	0x3020, 0x3083, 0x30f7, 0x3180, 0x3210, 0x326e, 0x32dd, 0x3360, 0x33fa,
	0x3457, 0x34c2, 0x3540, 0x35d4, 0x3641, 0x36a9, 0x3724, 0x37b5, 0x3830,
	0x3897, 0x3910, 0x39a1, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x800, 0xed0, 0x120a, 0x1416, 0x15a2, 0x16dd, 0x181d,
	0x18fb, 0x1a07, 0x1ab0, 0x1b7b, 0x1c36, 0x1cc5, 0x1d6d, 0x1e17, 0x1e88,
	0x1f0a, 0x1f9e, 0x2024, 0x2084, 0x20f1, 0x216b, 0x21f6, 0x2248, 0x229f,
	0x2300, 0x236d, 0x23e5, 0x2435, 0x2480, 0x24d2, 0x252d, 0x2592, 0x2600,
	0x263d, 0x2680, 0x26ca, 0x271c, 0x2775, 0x27d7, 0x2821, 0x285b, 0x289c,
	0x28e2, 0x292f, 0x2982, 0x29de, 0x2a21, 0x2a57, 0x2a92, 0x2ad3, 0x2b19,
	0x2b65, 0x2bb9, 0x2c09, 0x2c3b, 0x2c70, 0x2caa, 0x2ce9, 0x2d2e, 0x2d78,
	0x2dc9, 0x2e10, 0x2e40, 0x2e73, 0x2eab, 0x2ee8, 0x2f2a, 0x2f72, 0x2fbf,
	0x3009, 0x3037, 0x3068, 0x309e, 0x30d8, 0x3117, 0x315b, 0x31a5, 0x31f6,
	0x3226, 0x3255, 0x3288, 0x32c0, 0x32fc, 0x333d, 0x3384, 0x33d1, 0x3412,
	0x343f, 0x3470, 0x34a6, 0x34df, 0x351e, 0x3562, 0x35ad, 0x35fd, 0x362a,
	0x365a, 0x368d, 0x36c6, 0x3703, 0x3746, 0x378e, 0x37dd, 0x3819, 0x3848,
	0x387b, 0x38b3, 0x38f0, 0x3932, 0x397a, 0x39c9, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x200, 0xaa0, 0xde0, 0xfe0, 0x1144,
	0x127e, 0x138e, 0x146d, 0x1532, 0x160d, 0x1693, 0x172c, 0x17db, 0x1850,
	0x18bf, 0x193b, 0x19c5, 0x1a2e, 0x1a83, 0x1adf, 0x1b45, 0x1bb4, 0x1c16,
	0x1c58, 0x1c9f, 0x1ced, 0x1d40, 0x1d9b, 0x1dfc, 0x1e32, 0x1e6a, 0x1ea7,
	0x1ee8, 0x1f2d, 0x1f77, 0x1fc6, 0x200d, 0x203a, 0x206a, 0x209e, 0x20d4,
	0x210e, 0x214b, 0x218d, 0x21d2, 0x220d, 0x2234, 0x225d, 0x2289, 0x22b6,
	0x22e7, 0x231a, 0x2350, 0x238a, 0x23c6, 0x2402, 0x2424, 0x2447, 0x246c,
	0x2493, 0x24bd, 0x24e8, 0x2515, 0x2545, 0x2578, 0x25ac, 0x25e4, 0x260f,
	0x262d, 0x264d, 0x266f, 0x2692, 0x26b7, 0x26de, 0x2707, 0x2731, 0x275e,
	0x278d, 0x27bd, 0x27f1, 0x2813, 0x282f, 0x284c, 0x286b, 0x288b, 0x28ad,
	0x28d0, 0x28f4, 0x291b, 0x2943, 0x296d, 0x2998, 0x29c6, 0x29f6, 0x2a14,
	0x2a2e, 0x2a49, 0x2a65, 0x2a83, 0x2aa2, 0x2ac2, 0x2ae4, 0x2b07, 0x2b2b,
	0x2b52, 0x2b7a, 0x2ba3, 0x2bcf, 0x2bfc, 0x2c15, 0x2c2e, 0x2c48, 0x2c62,
	0x2c7e, 0x2c9b, 0x2cb9, 0x2cd9, 0x2cfa, 0x2d1c, 0x2d40, 0x2d65, 0x2d8c,
	0x2db4, 0x2dde, 0x2e05, 0x2e1c, 0x2e34, 0x2e4c, 0x2e66, 0x2e81, 0x2e9d,
	0x2eba, 0x2ed9, 0x2ef8, 0x2f19, 0x2f3c, 0x2f5f, 0x2f85, 0x2fab, 0x2fd4,
	0x2ffe, 0x3014, 0x302b, 0x3043, 0x305c, 0x3075, 0x3090, 0x30ac, 0x30c9,
	0x30e7, 0x3107, 0x3128, 0x314a, 0x316d, 0x3192, 0x31b9, 0x31e1, 0x3205,
	0x321b, 0x3232, 0x3249, 0x3262, 0x327b, 0x3296, 0x32b2, 0x32cf, 0x32ed,
	0x330c, 0x332d, 0x334f, 0x3372, 0x3397, 0x33bd, 0x33e5, 0x3407, 0x341d,
	0x3434, 0x344b, 0x3464, 0x347d, 0x3498, 0x34b4, 0x34d1, 0x34ef, 0x350e,
	0x352f, 0x3551, 0x3574, 0x359a, 0x35c0, 0x35e8, 0x3609, 0x361f, 0x3636,
	0x364d, 0x3666, 0x3680, 0x369b, 0x36b7, 0x36d5, 0x36f3, 0x3713, 0x3734,
	0x3757, 0x377b, 0x37a1, 0x37c9, 0x37f2, 0x380e, 0x3825, 0x383c, 0x3855,
	0x386e, 0x3889, 0x38a5, 0x38c2, 0x38e0, 0x3900, 0x3921, 0x3944, 0x3968,
	0x398e, 0x39b5, 0x39de, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x0,
	0x600, 0x980, 0xba0, 0xd20, 0xe58, 0xf58, 0x103c, 0x10e8, 0x11a8,
	0x1242, 0x12bc, 0x1346, 0x13dc, 0x1441, 0x149b, 0x14fe, 0x1569, 0x15dd,
	0x162c, 0x166f, 0x16b7, 0x1704, 0x1756, 0x17ad, 0x1805, 0x1836, 0x186b,
	0x18a2, 0x18dd, 0x191b, 0x195c, 0x19a1, 0x19e9, 0x1a1b, 0x1a43, 0x1a6d,
	0x1a99, 0x1ac7, 0x1af8, 0x1b2a, 0x1b5f, 0x1b97, 0x1bd1, 0x1c06, 0x1c26,
	0x1c47, 0x1c69, 0x1c8d, 0x1cb2, 0x1cd9, 0x1d01, 0x1d2b, 0x1d56, 0x1d83,
	0x1db2, 0x1de3, 0x1e0a, 0x1e25, 0x1e40, 0x1e5c, 0x1e79, 0x1e97, 0x1eb7,
	0x1ed7, 0x1ef9, 0x1f1b, 0x1f3f, 0x1f64, 0x1f8b, 0x1fb2, 0x1fdb, 0x2002,
	0x2018, 0x202f, 0x2046, 0x205e, 0x2077, 0x2091, 0x20ab, 0x20c6, 0x20e2,
	0x20ff, 0x211d, 0x213c, 0x215b, 0x217c, 0x219d, 0x21c0, 0x21e4, 0x2204,
	0x2217, 0x222a, 0x223e, 0x2253, 0x2268, 0x227d, 0x2294, 0x22ab, 0x22c2,
	0x22db, 0x22f4, 0x230d, 0x2328, 0x2343, 0x235e, 0x237b, 0x2398, 0x23b7,
	0x23d5, 0x23f5, 0x240b, 0x241b, 0x242d, 0x243e, 0x2450, 0x2463, 0x2476,
	0x248a, 0x249e, 0x24b2, 0x24c7, 0x24dd, 0x24f3, 0x250a, 0x2521, 0x2539,
	0x2552, 0x256b, 0x2584, 0x259f, 0x25ba, 0x25d6, 0x25f2, 0x2607, 0x2616,
	0x2626, 0x2635, 0x2645, 0x2656, 0x2666, 0x2678, 0x2689, 0x269b, 0x26ae,
	0x26c1, 0x26d4, 0x26e8, 0x26fc, 0x2711, 0x2726, 0x273c, 0x2753, 0x2769,
	0x2781, 0x2799, 0x27b1, 0x27ca, 0x27e4, 0x27fe, 0x280c, 0x281a, 0x2828,
	0x2836, 0x2845, 0x2854, 0x2863, 0x2873, 0x2883, 0x2893, 0x28a4, 0x28b5,
	0x28c7, 0x28d9, 0x28eb, 0x28fe, 0x2911, 0x2925, 0x2939, 0x294d, 0x2962,
	0x2977, 0x298d, 0x29a4, 0x29bb, 0x29d2, 0x29ea, 0x2a01, 0x2a0d, 0x2a1a,
	0x2a27, 0x2a34, 0x2a42, 0x2a50, 0x2a5e, 0x2a6d, 0x2a7b, 0x2a8a, 0x2a9a,
	0x2aaa, 0x2aba, 0x2aca, 0x2adb, 0x2aec, 0x2afe, 0x2b10, 0x2b22, 0x2b35,
	0x2b48, 0x2b5c, 0x2b6f, 0x2b84, 0x2b99, 0x2bae, 0x2bc4, 0x2bda, 0x2bf0,
	0x2c03, 0x2c0f, 0x2c1b, 0x2c28, 0x2c34, 0x2c41, 0x2c4e, 0x2c5b, 0x2c69,
	0x2c77, 0x2c85, 0x2c94, 0x2ca3, 0x2cb2, 0x2cc1, 0x2cd1, 0x2ce1, 0x2cf2,
	0x2d02, 0x2d13, 0x2d25, 0x2d37, 0x2d49, 0x2d5c, 0x2d6f, 0x2d82, 0x2d96,
	0x2daa, 0x2dbf, 0x2dd4, 0x2de9, 0x2dff, 0x2e0b, 0x2e16, 0x2e22, 0x2e2d,
	0x2e3a, 0x2e46, 0x2e53, 0x2e60, 0x2e6d, 0x2e7a, 0x2e88, 0x2e96, 0x2ea4,
	0x2eb3, 0x2ec2, 0x2ed1, 0x2ee0, 0x2ef0, 0x2f00, 0x2f11, 0x2f22, 0x2f33,
	0x2f44, 0x2f56, 0x2f68, 0x2f7b, 0x2f8e, 0x2fa1, 0x2fb5, 0x2fc9, 0x2fde,
	0x2ff3, 0x3004, 0x300f, 0x301a, 0x3025, 0x3031, 0x303d, 0x3049, 0x3055,
	0x3062, 0x306f, 0x307c, 0x3089, 0x3097, 0x30a5, 0x30b3, 0x30c2, 0x30d1,
	0x30e0, 0x30ef, 0x30ff, 0x310f, 0x311f, 0x3130, 0x3141, 0x3153, 0x3164,
	0x3176, 0x3189, 0x319c, 0x31af, 0x31c3, 0x31d7, 0x31eb, 0x3200, 0x320a,
	0x3215, 0x3220, 0x322c, 0x3237, 0x3243, 0x324f, 0x325b, 0x3268, 0x3275,
	0x3282, 0x328f, 0x329d, 0x32ab, 0x32b9, 0x32c7, 0x32d6, 0x32e5, 0x32f4,
	0x3304, 0x3314, 0x3324, 0x3335, 0x3346, 0x3357, 0x3369, 0x337b, 0x338d,
	0x33a0, 0x33b3, 0x33c7, 0x33db, 0x33ef, 0x3402, 0x340d, 0x3417, 0x3422,
	0x342e, 0x3439, 0x3445, 0x3451, 0x345d, 0x346a, 0x3477, 0x3484, 0x3491,
	0x349f, 0x34ad, 0x34bb, 0x34c9, 0x34d8, 0x34e7, 0x34f6, 0x3506, 0x3516,
	0x3526, 0x3537, 0x3548, 0x355a, 0x356b, 0x357e, 0x3590, 0x35a3, 0x35b6,
	0x35ca, 0x35de, 0x35f3, 0x3604, 0x360e, 0x3619, 0x3624, 0x3630, 0x363b,
	0x3647, 0x3654, 0x3660, 0x366d, 0x367a, 0x3687, 0x3694, 0x36a2, 0x36b0,
	0x36be, 0x36cd, 0x36dc, 0x36eb, 0x36fb, 0x370b, 0x371b, 0x372c, 0x373d,
	0x374e, 0x3760, 0x3772, 0x3785, 0x3798, 0x37ab, 0x37bf, 0x37d3, 0x37e7,
	0x37fd, 0x3809, 0x3814, 0x381f, 0x382a, 0x3836, 0x3842, 0x384e, 0x385b,
	0x3868, 0x3875, 0x3882, 0x3890, 0x389e, 0x38ac, 0x38ba, 0x38c9, 0x38d8,
	0x38e8, 0x38f8, 0x3908, 0x3919, 0x3929, 0x393b, 0x394c, 0x395f, 0x3971,
	0x3984, 0x3997, 0x39ab, 0x39bf, 0x39d4, 0x39e9, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0xc},
	{0x1542, 0x62b, 0x2ed7, 0x230, 0xc78, 0x20ad, 0x3fda, 0xff, 0x3e7,
	0x904, 0x108b, 0x1aa2, 0x2769, 0x36fc, 0x3fff, 0x7d, 0x188, 0x2fa,
	0x4f7, 0x785, 0xaaa, 0xe6d, 0x12d2, 0x17dc, 0x1d92, 0x23f5, 0x2b09,
	0x32d2, 0x3b53, 0x3fff, 0x3fff, 0x3c, 0xbe, 0x140, 0x1d8, 0x291, 0x36c,
	0x46a, 0x58c, 0x6d3, 0x840, 0x9d2, 0xb8c, 0xd6d, 0xf77, 0x11a9, 0x1405,
	0x168a, 0x193a, 0x1c14, 0x1f1a, 0x224b, 0x25a9, 0x2933, 0x2ceb, 0x30cf,
	0x34e1, 0x3922, 0x3d91, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x1c, 0x5d,
	0x9e, 0xdf, 0x120, 0x163, 0x1af, 0x203, 0x260, 0x2c5, 0x332, 0x3a8,
	0x427, 0x4af, 0x540, 0x5db, 0x67e, 0x72b, 0x7e1, 0x8a1, 0x96a, 0xa3d,
	0xb1a, 0xc01, 0xcf1, 0xdec, 0xef1, 0xfff, 0x1119, 0x123c, 0x136a,
	0x14a2, 0x15e5, 0x1732, 0x188a, 0x19ec, 0x1b59, 0x1cd2, 0x1e54, 0x1fe2,
	0x217b, 0x231f, 0x24ce, 0x2687, 0x284d, 0x2a1d, 0x2bf8, 0x2ddf, 0x2fd2,
	0x31cf, 0x33d8, 0x35ed, 0x380d, 0x3a39, 0x3c71, 0x3eb4, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0xc, 0x2c, 0x4d, 0x6d,
	0x8e, 0xae, 0xcf, 0xef, 0x110, 0x12f, 0x151, 0x175, 0x19b, 0x1c3,
	0x1ed, 0x21a, 0x248, 0x278, 0x2ab, 0x2df, 0x316, 0x34f, 0x38a, 0x3c7,
	0x407, 0x449, 0x48d, 0x4d3, 0x51b, 0x566, 0x5b3, 0x603, 0x654, 0x6a8,
	0x6ff, 0x757, 0x7b3, 0x810, 0x870, 0x8d2, 0x937, 0x99e, 0xa07, 0xa73,
	0xae2, 0xb53, 0xbc6, 0xc3c, 0xcb4, 0xd2f, 0xdac, 0xe2c, 0xeae, 0xf33,
	0xfbb, 0x1045, 0x10d1, 0x1160, 0x11f2, 0x1286, 0x131d, 0x13b7, 0x1453,
	0x14f2, 0x1593, 0x1637, 0x16de, 0x1787, 0x1833, 0x18e1, 0x1993, 0x1a47,
	0x1afd, 0x1bb6, 0x1c72, 0x1d31, 0x1df3, 0x1eb7, 0x1f7e, 0x2047, 0x2114,
	0x21e3, 0x22b5, 0x2389, 0x2461, 0x253b, 0x2618, 0x26f8, 0x27da, 0x28c0,
	0x29a8, 0x2a93, 0x2b81, 0x2c71, 0x2d65, 0x2e5b, 0x2f54, 0x3050, 0x314f,
	0x3251, 0x3355, 0x345d, 0x3567, 0x3674, 0x3784, 0x3897, 0x39ad, 0x3ac6,
	0x3be2, 0x3d00, 0x3e22, 0x3f46, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x4, 0x14, 0x24, 0x34, 0x45, 0x55, 0x65, 0x75, 0x86,
	0x96, 0xa6, 0xb6, 0xc7, 0xd7, 0xe7, 0xf7, 0x108, 0x118, 0x127, 0x138,
	0x149, 0x15a, 0x16c, 0x17f, 0x192, 0x1a5, 0x1b9, 0x1ce, 0x1e3, 0x1f8,
	0x20e, 0x225, 0x23c, 0x254, 0x26c, 0x285, 0x29e, 0x2b8, 0x2d2, 0x2ed,
	0x308, 0x324, 0x341, 0x35e, 0x37b, 0x399, 0x3b8, 0x3d7, 0x3f7, 0x417,
	0x438, 0x459, 0x47b, 0x49e, 0x4c1, 0x4e5, 0x509, 0x52e, 0x553, 0x579,
	0x5a0, 0x5c7, 0x5ef, 0x617, 0x640, 0x669, 0x693, 0x6be, 0x6e9, 0x715,
	0x741, 0x76e, 0x79c, 0x7ca, 0x7f8, 0x828, 0x858, 0x888, 0x8b9, 0x8eb,
	0x91d, 0x950, 0x984, 0x9b8, 0x9ed, 0xa22, 0xa58, 0xa8f, 0xac6, 0xafe,
	0xb36, 0xb6f, 0xba9, 0xbe3, 0xc1e, 0xc5a, 0xc96, 0xcd3, 0xd10, 0xd4e,
	0xd8d, 0xdcc, 0xe0c, 0xe4c, 0xe8e, 0xecf, 0xf12, 0xf55, 0xf99, 0xfdd,
	0x1022, 0x1068, 0x10ae, 0x10f5, 0x113c, 0x1185, 0x11ce, 0x1217, 0x1261,
	0x12ac, 0x12f7, 0x1343, 0x1390, 0x13de, 0x142c, 0x147a, 0x14ca, 0x151a,
	0x156a, 0x15bc, 0x160e, 0x1660, 0x16b4, 0x1708, 0x175c, 0x17b2, 0x1808,
	0x185e, 0x18b5, 0x190d, 0x1966, 0x19bf, 0x1a19, 0x1a74, 0x1acf, 0x1b2b,
	0x1b88, 0x1be5, 0x1c43, 0x1ca2, 0x1d01, 0x1d61, 0x1dc2, 0x1e23, 0x1e86,
	0x1ee8, 0x1f4c, 0x1fb0, 0x2015, 0x207a, 0x20e0, 0x2147, 0x21af, 0x2217,
	0x2280, 0x22ea, 0x2354, 0x23bf, 0x242b, 0x2497, 0x2504, 0x2572, 0x25e0,
	0x2650, 0x26c0, 0x2730, 0x27a1, 0x2813, 0x2886, 0x28f9, 0x296d, 0x29e2,
	0x2a58, 0x2ace, 0x2b45, 0x2bbc, 0x2c35, 0x2cae, 0x2d27, 0x2da2, 0x2e1d,
	0x2e99, 0x2f15, 0x2f93, 0x3011, 0x308f, 0x310f, 0x318f, 0x3210, 0x3291,
	0x3314, 0x3397, 0x341a, 0x349f, 0x3524, 0x35aa, 0x3631, 0x36b8, 0x3740,
	0x37c9, 0x3852, 0x38dc, 0x3967, 0x39f3, 0x3a7f, 0x3b0d, 0x3b9a, 0x3c29,
	0x3cb8, 0x3d48, 0x3dd9, 0x3e6b, 0x3efd, 0x3f90, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x0, 0x8, 0x10, 0x18, 0x20, 0x28, 0x30, 0x38, 0x41,
	0x49, 0x51, 0x59, 0x61, 0x69, 0x71, 0x79, 0x82, 0x8a, 0x92, 0x9a, 0xa2,
	0xaa, 0xb2, 0xba, 0xc3, 0xcb, 0xd3, 0xdb, 0xe3, 0xeb, 0xf3, 0xfb,
	0x104, 0x10c, 0x114, 0x11c, 0x124, 0x12b, 0x134, 0x13c, 0x144, 0x14d,
	0x156, 0x15f, 0x168, 0x171, 0x17a, 0x183, 0x18d, 0x197, 0x1a0, 0x1aa,
	0x1b4, 0x1be, 0x1c9, 0x1d3, 0x1dd, 0x1e8, 0x1f3, 0x1fe, 0x209, 0x214,
	0x21f, 0x22b, 0x236, 0x242, 0x24e, 0x25a, 0x266, 0x272, 0x27e, 0x28b,
	0x297, 0x2a4, 0x2b1, 0x2be, 0x2cb, 0x2d9, 0x2e6, 0x2f4, 0x301, 0x30f,
	0x31d, 0x32b, 0x339, 0x348, 0x356, 0x365, 0x374, 0x383, 0x392, 0x3a1,
	0x3b0, 0x3c0, 0x3cf, 0x3df, 0x3ef, 0x3ff, 0x40f, 0x41f, 0x430, 0x440,
	0x451, 0x462, 0x473, 0x484, 0x495, 0x4a7, 0x4b8, 0x4ca, 0x4dc, 0x4ee,
	0x500, 0x512, 0x525, 0x537, 0x54a, 0x55d, 0x570, 0x583, 0x596, 0x5a9,
	0x5bd, 0x5d1, 0x5e5, 0x5f9, 0x60d, 0x621, 0x635, 0x64a, 0x65f, 0x674,
	0x689, 0x69e, 0x6b3, 0x6c8, 0x6de, 0x6f4, 0x70a, 0x720, 0x736, 0x74c,
	0x763, 0x779, 0x790, 0x7a7, 0x7be, 0x7d5, 0x7ed, 0x804, 0x81c, 0x834,
	0x84c, 0x864, 0x87c, 0x894, 0x8ad, 0x8c6, 0x8df, 0x8f8, 0x911, 0x92a,
	0x944, 0x95d, 0x977, 0x991, 0x9ab, 0x9c5, 0x9e0, 0x9fa, 0xa15, 0xa30,
	0xa4b, 0xa66, 0xa81, 0xa9d, 0xab8, 0xad4, 0xaf0, 0xb0c, 0xb28, 0xb44,
	0xb61, 0xb7e, 0xb9a, 0xbb7, 0xbd5, 0xbf2, 0xc0f, 0xc2d, 0xc4b, 0xc69,
	0xc87, 0xca5, 0xcc3, 0xce2, 0xd01, 0xd1f, 0xd3f, 0xd5e, 0xd7d, 0xd9c,
	0xdbc, 0xddc, 0xdfc, 0xe1c, 0xe3c, 0xe5d, 0xe7d, 0xe9e, 0xebf, 0xee0,
	0xf01, 0xf23, 0xf44, 0xf66, 0xf88, 0xfaa, 0xfcc, 0xfee, 0x1011, 0x1033,
	0x1056, 0x1079, 0x109c, 0x10c0, 0x10e3, 0x1107, 0x112b, 0x114e, 0x1173,
	0x1197, 0x11bb, 0x11e0, 0x1205, 0x1229, 0x124f, 0x1274, 0x1299, 0x12bf,
	0x12e4, 0x130a, 0x1330, 0x1357, 0x137d, 0x13a3, 0x13ca, 0x13f1, 0x1418,
	0x143f, 0x1467, 0x148e, 0x14b6, 0x14de, 0x1506, 0x152e, 0x1556, 0x157f,
	0x15a7, 0x15d0, 0x15f9, 0x1622, 0x164c, 0x1675, 0x169f, 0x16c9, 0x16f3,
	0x171d, 0x1747, 0x1772, 0x179c, 0x17c7, 0x17f2, 0x181d, 0x1848, 0x1874,
	0x18a0, 0x18cb, 0x18f7, 0x1923, 0x1950, 0x197c, 0x19a9, 0x19d6, 0x1a03,
	0x1a30, 0x1a5d, 0x1a8b, 0x1ab8, 0x1ae6, 0x1b14, 0x1b42, 0x1b71, 0x1b9f,
	0x1bce, 0x1bfd, 0x1c2c, 0x1c5b, 0x1c8a, 0x1cba, 0x1ce9, 0x1d19, 0x1d49,
	0x1d79, 0x1daa, 0x1dda, 0x1e0b, 0x1e3c, 0x1e6d, 0x1e9e, 0x1ed0, 0x1f01,
	0x1f33, 0x1f65, 0x1f97, 0x1fc9, 0x1ffb, 0x202e, 0x2061, 0x2094, 0x20c7,
	0x20fa, 0x212d, 0x2161, 0x2195, 0x21c9, 0x21fd, 0x2231, 0x2266, 0x229a,
	0x22cf, 0x2304, 0x2339, 0x236f, 0x23a4, 0x23da, 0x2410, 0x2446, 0x247c,
	0x24b2, 0x24e9, 0x2520, 0x2556, 0x258e, 0x25c5, 0x25fc, 0x2634, 0x266c,
	0x26a3, 0x26dc, 0x2714, 0x274c, 0x2785, 0x27be, 0x27f7, 0x2830, 0x2869,
	0x28a3, 0x28dc, 0x2916, 0x2950, 0x298b, 0x29c5, 0x2a00, 0x2a3a, 0x2a75,
	0x2ab0, 0x2aec, 0x2b27, 0x2b63, 0x2b9e, 0x2bda, 0x2c17, 0x2c53, 0x2c8f,
	0x2ccc, 0x2d09, 0x2d46, 0x2d83, 0x2dc1, 0x2dfe, 0x2e3c, 0x2e7a, 0x2eb8,
	0x2ef6, 0x2f35, 0x2f73, 0x2fb2, 0x2ff1, 0x3030, 0x3070, 0x30af, 0x30ef,
	0x312f, 0x316f, 0x31af, 0x31f0, 0x3230, 0x3271, 0x32b2, 0x32f3, 0x3334,
	0x3376, 0x33b8, 0x33f9, 0x343b, 0x347e, 0x34c0, 0x3503, 0x3545, 0x3588,
	0x35cb, 0x360f, 0x3652, 0x3696, 0x36da, 0x371e, 0x3762, 0x37a6, 0x37eb,
	0x3830, 0x3875, 0x38ba, 0x38ff, 0x3945, 0x398a, 0x39d0, 0x3a16, 0x3a5c,
	0x3aa3, 0x3ae9, 0x3b30, 0x3b77, 0x3bbe, 0x3c05, 0x3c4d, 0x3c94, 0x3cdc,
	0x3d24, 0x3d6c, 0x3db5, 0x3dfd, 0x3e46, 0x3e8f, 0x3ed8, 0x3f21, 0x3f6b,
	0x3fb5, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff, 0x3fff,
	0x3fff, 0x3fff, 0x6},
	{0x3394, 0x2f73, 0x37ad, 0x2b6c, 0x31e4, 0x3584, 0x39f8, 0x275f,
	0x2ddf, 0x30b3, 0x32a6, 0x347b, 0x3687, 0x38b1, 0x39ff, 0x2343, 0x29d5,
	0x2caf, 0x2ea3, 0x302f, 0x3145, 0x3249, 0x3312, 0x341a, 0x34f3, 0x361b,
	0x370b, 0x3839, 0x3945, 0x39ff, 0x39ff, 0x1f0e, 0x25c0, 0x28a6, 0x2a9d,
	0x2c2b, 0x2d40, 0x2e46, 0x2f08, 0x2fe6, 0x306f, 0x30fa, 0x3193, 0x321c,
	0x3277, 0x32d9, 0x3350, 0x33e0, 0x3448, 0x34b4, 0x3538, 0x35d8, 0x364e,
	0x36c6, 0x3758, 0x3805, 0x3872, 0x38f7, 0x399a, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x1aaa, 0x2198, 0x2495, 0x2691, 0x2824, 0x2937, 0x2a40, 0x2b01,
	0x2bde, 0x2c6b, 0x2cf6, 0x2d8e, 0x2e1a, 0x2e74, 0x2ed5, 0x2f3d, 0x2fac,
	0x3011, 0x304f, 0x3091, 0x30d6, 0x311f, 0x316b, 0x31bb, 0x3207, 0x3232,
	0x3260, 0x328e, 0x32bf, 0x32f5, 0x3330, 0x3371, 0x33b9, 0x3404, 0x3430,
	0x3461, 0x3497, 0x34d3, 0x3514, 0x355d, 0x35ad, 0x3603, 0x3634, 0x366a,
	0x36a6, 0x36e8, 0x3731, 0x3782, 0x37db, 0x381e, 0x3855, 0x3891, 0x38d4,
	0x391d, 0x396e, 0x39c8, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x15ea, 0x1d4a, 0x2074, 0x227a, 0x2414, 0x2524, 0x2635,
	0x26f5, 0x27d0, 0x2863, 0x28ed, 0x2984, 0x2a14, 0x2a6e, 0x2acf, 0x2b36,
	0x2ba5, 0x2c0d, 0x2c4b, 0x2c8d, 0x2cd2, 0x2d1a, 0x2d67, 0x2db6, 0x2e04,
	0x2e30, 0x2e5d, 0x2e8b, 0x2ebc, 0x2eee, 0x2f22, 0x2f58, 0x2f8f, 0x2fc8,
	0x3001, 0x3020, 0x303f, 0x305f, 0x3080, 0x30a2, 0x30c5, 0x30e8, 0x310d,
	0x3132, 0x3158, 0x317f, 0x31a7, 0x31d0, 0x31f9, 0x3212, 0x3227, 0x323e,
	0x3254, 0x326b, 0x3282, 0x329a, 0x32b3, 0x32cc, 0x32e7, 0x3303, 0x3321,
	0x3340, 0x3360, 0x3383, 0x33a7, 0x33cd, 0x33f5, 0x340f, 0x3425, 0x343c,
	0x3455, 0x346e, 0x3489, 0x34a5, 0x34c3, 0x34e2, 0x3503, 0x3526, 0x354a,
	0x3570, 0x3598, 0x35c2, 0x35ef, 0x360e, 0x3627, 0x3641, 0x365c, 0x3678,
	0x3696, 0x36b6, 0x36d7, 0x36f9, 0x371e, 0x3744, 0x376d, 0x3797, 0x37c4,
	0x37f2, 0x3812, 0x382c, 0x3847, 0x3863, 0x3881, 0x38a1, 0x38c2, 0x38e5,
	0x390a, 0x3931, 0x3959, 0x3984, 0x39b1, 0x39e0, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0xf78, 0x18b7, 0x1c33, 0x1e4c, 0x1fed,
	0x20ff, 0x221f, 0x22db, 0x23b3, 0x2453, 0x24db, 0x2570, 0x260a, 0x2662,
	0x26c2, 0x2729, 0x2796, 0x2805, 0x2843, 0x2884, 0x28c9, 0x2911, 0x295d,
	0x29ac, 0x29ff, 0x2a2a, 0x2a57, 0x2a85, 0x2ab6, 0x2ae8, 0x2b1c, 0x2b51,
	0x2b88, 0x2bc1, 0x2bfc, 0x2c1c, 0x2c3b, 0x2c5b, 0x2c7c, 0x2c9e, 0x2cc0,
	0x2ce4, 0x2d08, 0x2d2d, 0x2d53, 0x2d7a, 0x2da2, 0x2dcb, 0x2df4, 0x2e0f,
	0x2e25, 0x2e3b, 0x2e51, 0x2e68, 0x2e80, 0x2e97, 0x2eb0, 0x2ec8, 0x2ee1,
	0x2efb, 0x2f15, 0x2f2f, 0x2f4a, 0x2f66, 0x2f81, 0x2f9d, 0x2fba, 0x2fd7,
	0x2ff5, 0x3009, 0x3018, 0x3028, 0x3037, 0x3047, 0x3057, 0x3067, 0x3078,
	0x3088, 0x3099, 0x30aa, 0x30bc, 0x30cd, 0x30df, 0x30f1, 0x3103, 0x3116,
	0x3128, 0x313b, 0x314e, 0x3162, 0x3175, 0x3189, 0x319d, 0x31b1, 0x31c5,
	0x31da, 0x31ef, 0x3202, 0x320c, 0x3217, 0x3222, 0x322d, 0x3238, 0x3243,
	0x324e, 0x325a, 0x3265, 0x3271, 0x327d, 0x3288, 0x3294, 0x32a0, 0x32ad,
	0x32b9, 0x32c6, 0x32d3, 0x32e0, 0x32ee, 0x32fc, 0x330a, 0x3319, 0x3328,
	0x3338, 0x3348, 0x3358, 0x3369, 0x337a, 0x338c, 0x339e, 0x33b0, 0x33c3,
	0x33d6, 0x33ea, 0x33ff, 0x340a, 0x3414, 0x341f, 0x342b, 0x3436, 0x3442,
	0x344e, 0x345b, 0x3468, 0x3475, 0x3482, 0x3490, 0x349e, 0x34ad, 0x34bc,
	0x34cb, 0x34da, 0x34ea, 0x34fb, 0x350c, 0x351d, 0x352f, 0x3541, 0x3553,
	0x3566, 0x357a, 0x358e, 0x35a3, 0x35b8, 0x35cd, 0x35e4, 0x35fa, 0x3609,
	0x3614, 0x3621, 0x362d, 0x363a, 0x3647, 0x3655, 0x3663, 0x3671, 0x3680,
	0x368e, 0x369e, 0x36ae, 0x36be, 0x36ce, 0x36df, 0x36f0, 0x3702, 0x3715,
	0x3727, 0x373a, 0x374e, 0x3762, 0x3777, 0x378c, 0x37a2, 0x37b8, 0x37cf,
	0x37e7, 0x37ff, 0x380b, 0x3818, 0x3825, 0x3832, 0x3840, 0x384e, 0x385c,
	0x386b, 0x387a, 0x3889, 0x3899, 0x38a9, 0x38ba, 0x38cb, 0x38dc, 0x38ee,
	0x3901, 0x3913, 0x3927, 0x393b, 0x394f, 0x3964, 0x3979, 0x398f, 0x39a5,
	0x39bc, 0x39d4, 0x39ec, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x0,
	0x137a, 0x177a, 0x19ea, 0x1b7a, 0x1cb7, 0x1dea, 0x1eaa, 0x1f7a, 0x2033,
	0x20b7, 0x214a, 0x21ea, 0x224c, 0x22aa, 0x230e, 0x237a, 0x23ed, 0x2433,
	0x2474, 0x24b7, 0x24ff, 0x254a, 0x2598, 0x25ea, 0x261f, 0x264c, 0x267a,
	0x26aa, 0x26db, 0x270e, 0x2743, 0x277a, 0x27b3, 0x27ed, 0x2814, 0x2833,
	0x2853, 0x2874, 0x2895, 0x28b7, 0x28db, 0x28ff, 0x2924, 0x294a, 0x2970,
	0x2998, 0x29c0, 0x29ea, 0x2a0a, 0x2a1f, 0x2a35, 0x2a4c, 0x2a62, 0x2a7a,
	0x2a91, 0x2aaa, 0x2ac2, 0x2adb, 0x2af5, 0x2b0e, 0x2b29, 0x2b43, 0x2b5f,
	0x2b7a, 0x2b96, 0x2bb3, 0x2bd0, 0x2bed, 0x2c05, 0x2c14, 0x2c24, 0x2c33,
	0x2c43, 0x2c53, 0x2c63, 0x2c74, 0x2c84, 0x2c95, 0x2ca6, 0x2cb7, 0x2cc9,
	0x2cdb, 0x2ced, 0x2cff, 0x2d11, 0x2d24, 0x2d37, 0x2d4a, 0x2d5d, 0x2d70,
	0x2d84, 0x2d98, 0x2dac, 0x2dc0, 0x2dd5, 0x2dea, 0x2dff, 0x2e0a, 0x2e14,
	0x2e1f, 0x2e2a, 0x2e35, 0x2e40, 0x2e4c, 0x2e57, 0x2e62, 0x2e6e, 0x2e7a,
	0x2e85, 0x2e91, 0x2e9d, 0x2eaa, 0x2eb6, 0x2ec2, 0x2ecf, 0x2edb, 0x2ee8,
	0x2ef5, 0x2f01, 0x2f0e, 0x2f1c, 0x2f29, 0x2f36, 0x2f43, 0x2f51, 0x2f5f,
	0x2f6c, 0x2f7a, 0x2f88, 0x2f96, 0x2fa5, 0x2fb3, 0x2fc1, 0x2fd0, 0x2fde,
	0x2fed, 0x2ffc, 0x3005, 0x300d, 0x3014, 0x301c, 0x3024, 0x302b, 0x3033,
	0x303b, 0x3043, 0x304b, 0x3053, 0x305b, 0x3063, 0x306b, 0x3074, 0x307c,
	0x3084, 0x308d, 0x3095, 0x309e, 0x30a6, 0x30af, 0x30b7, 0x30c0, 0x30c9,
	0x30d2, 0x30db, 0x30e4, 0x30ed, 0x30f6, 0x30ff, 0x3108, 0x3111, 0x311a,
	0x3124, 0x312d, 0x3137, 0x3140, 0x314a, 0x3153, 0x315d, 0x3167, 0x3170,
	0x317a, 0x3184, 0x318e, 0x3198, 0x31a2, 0x31ac, 0x31b6, 0x31c0, 0x31cb,
	0x31d5, 0x31df, 0x31ea, 0x31f4, 0x31ff, 0x3204, 0x320a, 0x320f, 0x3214,
	0x321a, 0x321f, 0x3225, 0x322a, 0x3230, 0x3235, 0x323b, 0x3240, 0x3246,
	0x324c, 0x3251, 0x3257, 0x325d, 0x3262, 0x3268, 0x326e, 0x3274, 0x327a,
	0x3280, 0x3285, 0x328b, 0x3291, 0x3297, 0x329d, 0x32a3, 0x32aa, 0x32b0,
	0x32b6, 0x32bc, 0x32c2, 0x32c9, 0x32cf, 0x32d6, 0x32dd, 0x32e4, 0x32ea,
	0x32f1, 0x32f8, 0x32ff, 0x3307, 0x330e, 0x3315, 0x331d, 0x3324, 0x332c,
	0x3334, 0x333c, 0x3344, 0x334c, 0x3354, 0x335c, 0x3365, 0x336d, 0x3376,
	0x337e, 0x3387, 0x3390, 0x3399, 0x33a2, 0x33ab, 0x33b5, 0x33be, 0x33c8,
	0x33d2, 0x33db, 0x33e5, 0x33ef, 0x33fa, 0x3402, 0x3407, 0x340c, 0x3412,
	0x3417, 0x341d, 0x3422, 0x3428, 0x342e, 0x3433, 0x3439, 0x343f, 0x3445,
	0x344b, 0x3451, 0x3458, 0x345e, 0x3464, 0x346b, 0x3471, 0x3478, 0x347f,
	0x3486, 0x348d, 0x3493, 0x349b, 0x34a2, 0x34a9, 0x34b0, 0x34b8, 0x34bf,
	0x34c7, 0x34cf, 0x34d6, 0x34de, 0x34e6, 0x34ee, 0x34f7, 0x34ff, 0x3507,
	0x3510, 0x3519, 0x3521, 0x352a, 0x3533, 0x353c, 0x3545, 0x354f, 0x3558,
	0x3562, 0x356b, 0x3575, 0x357f, 0x3589, 0x3593, 0x359d, 0x35a8, 0x35b2,
	0x35bd, 0x35c8, 0x35d3, 0x35de, 0x35e9, 0x35f4, 0x3600, 0x3606, 0x360b,
	0x3611, 0x3617, 0x361e, 0x3624, 0x362a, 0x3630, 0x3637, 0x363d, 0x3644,
	0x364b, 0x3651, 0x3658, 0x365f, 0x3666, 0x366d, 0x3675, 0x367c, 0x3683,
	0x368b, 0x3692, 0x369a, 0x36a2, 0x36aa, 0x36b2, 0x36ba, 0x36c2, 0x36ca,
	0x36d2, 0x36db, 0x36e3, 0x36ec, 0x36f5, 0x36fe, 0x3707, 0x3710, 0x3719,
	0x3723, 0x372c, 0x3736, 0x373f, 0x3749, 0x3753, 0x375d, 0x3767, 0x3772,
	0x377c, 0x3787, 0x3792, 0x379c, 0x37a7, 0x37b3, 0x37be, 0x37c9, 0x37d5,
	0x37e1, 0x37ec, 0x37f8, 0x3802, 0x3808, 0x380e, 0x3815, 0x381b, 0x3822,
	0x3828, 0x382f, 0x3836, 0x383c, 0x3843, 0x384a, 0x3851, 0x3858, 0x3860,
	0x3867, 0x386e, 0x3876, 0x387e, 0x3885, 0x388d, 0x3895, 0x389d, 0x38a5,
	0x38ad, 0x38b6, 0x38be, 0x38c7, 0x38cf, 0x38d8, 0x38e1, 0x38ea, 0x38f3,
	0x38fc, 0x3905, 0x390f, 0x3918, 0x3922, 0x392c, 0x3936, 0x3940, 0x394a,
	0x3954, 0x395e, 0x3969, 0x3974, 0x397e, 0x3989, 0x3994, 0x39a0, 0x39ab,
	0x39b6, 0x39c2, 0x39ce, 0x39da, 0x39e6, 0x39f2, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff,
	0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0x39ff, 0xc},
};

static const u32 dcss_cscos[8][29] = {
	{0x1, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x36c, 0x36c, 0x36c, 0x0, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
	0x3ac, 0x3ac, 0x3ac},
	{0x8000, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
	0x0, 0x0},
	{0x3, 0x20e0, 0x54d9, 0x76c, 0xffffee22, 0xffffd1e1, 0x4000, 0x4000,
	0xffffc527, 0xfffffadc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380, 0xf, 0x40, 0x200, 0x200, 0x40, 0x40, 0x40, 0x3ac, 0x3c0, 0x3c0},
	{0x3, 0x21a1, 0x56c9, 0x798, 0xffffee22, 0xffffd1e1, 0x4000, 0x4000,
	0xffffc527, 0xfffffadc, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff, 0xf, 0x0, 0x200, 0x200, 0x0, 0x0, 0x0, 0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x1a9b, 0x5981, 0x909, 0xfffff157, 0xffffceac, 0x4000, 0x4000,
	0xffffc5e0, 0xfffffa23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380, 0xf, 0x40, 0x200, 0x200, 0x40, 0x40, 0x40, 0x3ac, 0x3c0, 0x3c0},
	{0x3, 0x256b, 0x4976, 0xe45, 0xffffea68, 0xffffd59b, 0x4000, 0x4000,
	0xffffca6a, 0xfffff599, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x380, 0x380,
	0x380, 0xf, 0x40, 0x200, 0x200, 0x40, 0x40, 0x40, 0x3ac, 0x3c0, 0x3c0},
	{0x3, 0x1b37, 0x5b8c, 0x93e, 0xfffff157, 0xffffceac, 0x4000, 0x4000,
	0xffffc5e0, 0xfffffa23, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff, 0xf, 0x0, 0x200, 0x200, 0x0, 0x0, 0x0, 0x3ff, 0x3ff, 0x3ff},
	{0x3, 0x2646, 0x4b23, 0xe98, 0xffffea68, 0xffffd59b, 0x4000, 0x4000,
	0xffffca6a, 0xfffff599, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x3ff, 0x3ff,
	0x3ff, 0xf, 0x0, 0x200, 0x200, 0x0, 0x0, 0x0, 0x3ff, 0x3ff, 0x3ff},
};

struct dcss_pipe_cfg {
	u32 id;
	u8 idx[5];
};

static const struct dcss_pipe_cfg dcss_cfg_table[226] = {
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160a16, {0, 0, 0, 0, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160a1a, {1, 0, 0, 0, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160a86, {0, 4, 0, 0, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160a8a, {1, 4, 0, 0, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160c16, {0, 1, 0, 0, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160c1a, {2, 0, 0, 0, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160c86, {0, 5, 0, 0, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a160c8a, {2, 4, 0, 0, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a161226, {0, 2, 1, 0, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a16122a, {3, 2, 1, 0, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a161306, {0, 6, 1, 0, 0}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a161426, {0, 3, 1, 0, 0}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a16142a, {5, 2, 1, 0, 0}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a161506, {0, 7, 1, 0, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a16222a, {4, 2, 2, 0, 0}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2084 */
	{0x0a16242a, {6, 2, 2, 0, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0a16, {0, 0, 0, 8, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0a1a, {14, 8, 0, 8, 2}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0a86, {0, 4, 0, 8, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0a8a, {14, 10, 0, 8, 2}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0c16, {0, 1, 0, 8, 2}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0c1a, {15, 8, 0, 8, 2}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0c86, {0, 5, 0, 8, 2}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a0c8a, {15, 10, 0, 8, 2}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a1226, {0, 2, 1, 8, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a122a, {16, 9, 1, 8, 2}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a1306, {0, 6, 1, 8, 2}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a1426, {0, 3, 1, 8, 2}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a142a, {18, 9, 1, 8, 2}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a1506, {0, 7, 1, 8, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a222a, {17, 9, 2, 8, 2}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2084 */
	{0x0a1a242a, {19, 9, 2, 8, 2}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860a16, {0, 0, 0, 4, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860a1a, {1, 0, 0, 4, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860a86, {0, 4, 0, 4, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860a8a, {1, 4, 0, 4, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860c16, {0, 1, 0, 4, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860c1a, {2, 0, 0, 4, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860c86, {0, 5, 0, 4, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a860c8a, {2, 4, 0, 4, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a861226, {0, 2, 1, 4, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a86122a, {3, 2, 1, 4, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a861306, {0, 6, 1, 4, 0}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a861426, {0, 3, 1, 4, 0}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a86142a, {5, 2, 1, 4, 0}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a861506, {0, 7, 1, 4, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a86222a, {4, 2, 2, 4, 0}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC2020,REC2100HLG */
	{0x0a86242a, {6, 2, 2, 4, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0a16, {0, 0, 0, 10, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0a1a, {14, 8, 0, 10, 2}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0a86, {0, 4, 0, 10, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0a8a, {14, 10, 0, 10, 2}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0c16, {0, 1, 0, 10, 2}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0c1a, {15, 8, 0, 10, 2}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0c86, {0, 5, 0, 10, 2}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a0c8a, {15, 10, 0, 10, 2}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a1226, {0, 2, 1, 10, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a122a, {16, 9, 1, 10, 2}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a1306, {0, 6, 1, 10, 2}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a1426, {0, 3, 1, 10, 2}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a142a, {18, 9, 1, 10, 2}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a1506, {0, 7, 1, 10, 2}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a222a, {17, 9, 2, 10, 2}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG */
	{0x0a8a242a, {19, 9, 2, 10, 2}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160a16, {7, 1, 0, 1, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160a1a, {8, 1, 0, 1, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160a86, {7, 5, 0, 1, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160a8a, {8, 5, 0, 1, 1}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160c16, {0, 1, 0, 1, 1}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160c1a, {9, 1, 0, 1, 1}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160c86, {0, 5, 0, 1, 1}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c160c8a, {9, 5, 0, 1, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c161226, {7, 3, 1, 1, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c16122a, {10, 3, 1, 1, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c161306, {7, 7, 1, 1, 1}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c161426, {0, 3, 1, 1, 1}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c16142a, {12, 3, 1, 1, 1}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c161506, {0, 7, 1, 1, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c16222a, {11, 3, 2, 1, 1}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC2020,REC2084 */
	{0x0c16242a, {13, 3, 2, 1, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0a16, {7, 1, 0, 1, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0a1a, {8, 1, 0, 1, 3}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0a86, {7, 5, 0, 1, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0a8a, {8, 5, 0, 1, 3}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0c16, {0, 1, 0, 1, 3}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0c1a, {9, 1, 0, 1, 3}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0c86, {0, 5, 0, 1, 3}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a0c8a, {9, 5, 0, 1, 3}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a1226, {7, 3, 1, 1, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a122a, {10, 3, 1, 1, 3}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a1306, {7, 7, 1, 1, 3}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a1426, {0, 3, 1, 1, 3}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a142a, {12, 3, 1, 1, 3}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a1506, {0, 7, 1, 1, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a222a, {11, 3, 2, 1, 3}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2084 */
	{0x0c1a242a, {13, 3, 2, 1, 3}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860a16, {7, 1, 0, 5, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860a1a, {8, 1, 0, 5, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860a86, {7, 5, 0, 5, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860a8a, {8, 5, 0, 5, 1}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860c16, {0, 1, 0, 5, 1}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860c1a, {9, 1, 0, 5, 1}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860c86, {0, 5, 0, 5, 1}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c860c8a, {9, 5, 0, 5, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c861226, {7, 3, 1, 5, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c86122a, {10, 3, 1, 5, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c861306, {7, 7, 1, 5, 1}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c861426, {0, 3, 1, 5, 1}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c86142a, {12, 3, 1, 5, 1}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c861506, {0, 7, 1, 5, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c86222a, {11, 3, 2, 5, 1}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC2020,REC2100HLG */
	{0x0c86242a, {13, 3, 2, 5, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0a16, {7, 1, 0, 5, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0a1a, {8, 1, 0, 5, 3}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0a86, {7, 5, 0, 5, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0a8a, {8, 5, 0, 5, 3}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0c16, {0, 1, 0, 5, 3}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0c1a, {9, 1, 0, 5, 3}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0c86, {0, 5, 0, 5, 3}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a0c8a, {9, 5, 0, 5, 3}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a1226, {7, 3, 1, 5, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a122a, {10, 3, 1, 5, 3}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a1306, {7, 7, 1, 5, 3}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a1426, {0, 3, 1, 5, 3}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a142a, {12, 3, 1, 5, 3}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a1506, {0, 7, 1, 5, 3}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a222a, {11, 3, 2, 5, 3}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC2020,REC2100HLG */
	{0x0c8a242a, {13, 3, 2, 5, 3}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12260a16, {0, 0, 0, 2, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12260a86, {0, 4, 0, 2, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12261226, {0, 2, 0, 2, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x1226122a, {3, 2, 0, 2, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12261306, {0, 6, 0, 2, 0}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12261426, {0, 3, 0, 2, 0}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x1226142a, {5, 2, 0, 2, 0}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x12261506, {0, 7, 0, 2, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x1226222a, {4, 2, 3, 2, 0}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC709,REC709 */
	{0x1226242a, {6, 2, 3, 2, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a0a16, {0, 0, 0, 9, 4}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a0a86, {0, 4, 0, 9, 4}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a1226, {0, 2, 0, 9, 4}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a122a, {16, 9, 0, 9, 4}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a1306, {0, 6, 0, 9, 4}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a1426, {0, 3, 0, 9, 4}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a142a, {18, 9, 0, 9, 4}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a1506, {0, 7, 0, 9, 4}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a222a, {17, 9, 3, 9, 4}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC709,REC709 */
	{0x122a242a, {19, 9, 3, 9, 4}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060a16, {0, 0, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060a1a, {1, 0, 0, 6, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060a86, {0, 4, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060a8a, {1, 4, 0, 6, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060c16, {0, 1, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060c1a, {2, 0, 0, 6, 0}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060c86, {0, 5, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13060c8a, {2, 4, 0, 6, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13061226, {0, 2, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x1306122a, {3, 2, 0, 6, 0}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13061306, {0, 6, 0, 6, 0}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13061426, {0, 3, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x1306142a, {5, 2, 0, 6, 0}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x13061506, {0, 7, 0, 6, 0}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x1306222a, {4, 2, 3, 6, 0}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Limited,REC709,SRGB */
	{0x1306242a, {6, 2, 3, 6, 0}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14260a16, {7, 1, 0, 3, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14260a86, {7, 5, 0, 3, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14261226, {7, 3, 0, 3, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x1426122a, {10, 3, 0, 3, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14261306, {7, 7, 0, 3, 1}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14261426, {0, 3, 0, 3, 1}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x1426142a, {12, 3, 0, 3, 1}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x14261506, {0, 7, 0, 3, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x1426222a, {11, 3, 3, 3, 1}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC709,REC709 */
	{0x1426242a, {13, 3, 3, 3, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a0a16, {7, 1, 0, 3, 6}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a0a86, {7, 5, 0, 3, 6}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a1226, {7, 3, 0, 3, 6}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a122a, {10, 3, 0, 3, 6}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a1306, {7, 7, 0, 3, 6}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a1426, {0, 3, 0, 3, 6}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a142a, {12, 3, 0, 3, 6}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a1506, {0, 7, 0, 3, 6}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a222a, {11, 3, 3, 3, 6}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC709,REC709 */
	{0x142a242a, {13, 3, 3, 3, 6}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15060a16, {7, 1, 0, 7, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15060a86, {7, 5, 0, 7, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15061226, {7, 3, 0, 7, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x1506122a, {10, 3, 0, 7, 1}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15061306, {7, 7, 0, 7, 1}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15061426, {0, 3, 0, 7, 1}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x1506142a, {12, 3, 0, 7, 1}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x15061506, {0, 7, 0, 7, 1}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x1506222a, {11, 3, 3, 7, 1}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:RGB,10b,Full,REC709,SRGB */
	{0x1506242a, {13, 3, 3, 7, 1}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0a16, {0, 0, 0, 9, 5}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0a1a, {14, 8, 0, 9, 5}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0a86, {0, 4, 0, 9, 5}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0a8a, {14, 10, 0, 9, 5}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0c16, {0, 1, 0, 9, 5}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0c1a, {15, 8, 0, 9, 5}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0c86, {0, 5, 0, 9, 5}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a0c8a, {15, 10, 0, 9, 5}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a1226, {0, 2, 4, 9, 5}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a122a, {16, 9, 4, 9, 5}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a1306, {0, 6, 4, 9, 5}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a1426, {0, 3, 4, 9, 5}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a142a, {18, 9, 4, 9, 5}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a1506, {0, 7, 4, 9, 5}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a222a, {17, 9, 0, 9, 5}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709 */
	{0x222a242a, {19, 9, 0, 9, 5}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0a16, {7, 1, 0, 3, 7}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0a1a, {8, 1, 0, 3, 7}},
	/* IPIPE:RGB,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0a86, {7, 5, 0, 3, 7}},
	/* IPIPE:YCbCr,10b,Limited,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0a8a, {8, 5, 0, 3, 7}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0c16, {0, 1, 0, 3, 7}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2084;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0c1a, {9, 1, 0, 3, 7}},
	/* IPIPE:RGB,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0c86, {0, 5, 0, 3, 7}},
	/* IPIPE:YCbCr,10b,Full,REC2020,REC2100HLG;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a0c8a, {9, 5, 0, 3, 7}},
	/* IPIPE:RGB,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a1226, {7, 3, 4, 3, 7}},
	/* IPIPE:YCbCr,10b,Limited,REC709,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a122a, {10, 3, 4, 3, 7}},
	/* IPIPE:RGB,10b,Limited,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a1306, {7, 7, 4, 3, 7}},
	/* IPIPE:RGB,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a1426, {0, 3, 4, 3, 7}},
	/* IPIPE:YCbCr,10b,Full,REC709,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a142a, {12, 3, 4, 3, 7}},
	/* IPIPE:RGB,10b,Full,REC709,SRGB;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a1506, {0, 7, 4, 3, 7}},
	/* IPIPE:YCbCr,10b,Limited,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a222a, {11, 3, 0, 3, 7}},
	/* IPIPE:YCbCr,10b,Full,REC601_NTSC,REC709;OPIPE:YCbCr,10b,Full,REC601_NTSC,REC709 */
	{0x242a242a, {13, 3, 0, 3, 7}},
};

#endif /* __DCSS_HDR10_TABLES_H__ */
